/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#id NetworkProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#location NetworkProfile#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#name NetworkProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#resource_group_name NetworkProfile#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#tags NetworkProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * container_network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#container_network_interface NetworkProfile#container_network_interface}
    */
    readonly containerNetworkInterface: NetworkProfileContainerNetworkInterface;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#timeouts NetworkProfile#timeouts}
    */
    readonly timeouts?: NetworkProfileTimeouts;
}
export interface NetworkProfileContainerNetworkInterfaceIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#name NetworkProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#subnet_id NetworkProfile#subnet_id}
    */
    readonly subnetId: string;
}
export declare function networkProfileContainerNetworkInterfaceIpConfigurationToTerraform(struct?: NetworkProfileContainerNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
export declare function networkProfileContainerNetworkInterfaceIpConfigurationToHclTerraform(struct?: NetworkProfileContainerNetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
export declare class NetworkProfileContainerNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkProfileContainerNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkProfileContainerNetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class NetworkProfileContainerNetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkProfileContainerNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkProfileContainerNetworkInterfaceIpConfigurationOutputReference;
}
export interface NetworkProfileContainerNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#name NetworkProfile#name}
    */
    readonly name: string;
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#ip_configuration NetworkProfile#ip_configuration}
    */
    readonly ipConfiguration: NetworkProfileContainerNetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
}
export declare function networkProfileContainerNetworkInterfaceToTerraform(struct?: NetworkProfileContainerNetworkInterfaceOutputReference | NetworkProfileContainerNetworkInterface): any;
export declare function networkProfileContainerNetworkInterfaceToHclTerraform(struct?: NetworkProfileContainerNetworkInterfaceOutputReference | NetworkProfileContainerNetworkInterface): any;
export declare class NetworkProfileContainerNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkProfileContainerNetworkInterface | undefined;
    set internalValue(value: NetworkProfileContainerNetworkInterface | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ipConfiguration;
    get ipConfiguration(): NetworkProfileContainerNetworkInterfaceIpConfigurationList;
    putIpConfiguration(value: NetworkProfileContainerNetworkInterfaceIpConfiguration[] | cdktf.IResolvable): void;
    get ipConfigurationInput(): cdktf.IResolvable | NetworkProfileContainerNetworkInterfaceIpConfiguration[] | undefined;
}
export interface NetworkProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#create NetworkProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#delete NetworkProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#read NetworkProfile#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#update NetworkProfile#update}
    */
    readonly update?: string;
}
export declare function networkProfileTimeoutsToTerraform(struct?: NetworkProfileTimeouts | cdktf.IResolvable): any;
export declare function networkProfileTimeoutsToHclTerraform(struct?: NetworkProfileTimeouts | cdktf.IResolvable): any;
export declare class NetworkProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile azurerm_network_profile}
*/
export declare class NetworkProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_profile";
    /**
    * Generates CDKTF code for importing a NetworkProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkProfile to import
    * @param importFromId The id of the existing NetworkProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/network_profile azurerm_network_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkProfileConfig
    */
    constructor(scope: Construct, id: string, config: NetworkProfileConfig);
    get containerNetworkInterfaceIds(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _containerNetworkInterface;
    get containerNetworkInterface(): NetworkProfileContainerNetworkInterfaceOutputReference;
    putContainerNetworkInterface(value: NetworkProfileContainerNetworkInterface): void;
    get containerNetworkInterfaceInput(): NetworkProfileContainerNetworkInterface | undefined;
    private _timeouts;
    get timeouts(): NetworkProfileTimeoutsOutputReference;
    putTimeouts(value: NetworkProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
