/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#condition RoleAssignment#condition}
    */
    readonly condition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#condition_version RoleAssignment#condition_version}
    */
    readonly conditionVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#delegated_managed_identity_resource_id RoleAssignment#delegated_managed_identity_resource_id}
    */
    readonly delegatedManagedIdentityResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#description RoleAssignment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#id RoleAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#name RoleAssignment#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#principal_id RoleAssignment#principal_id}
    */
    readonly principalId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#principal_type RoleAssignment#principal_type}
    */
    readonly principalType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#role_definition_id RoleAssignment#role_definition_id}
    */
    readonly roleDefinitionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#role_definition_name RoleAssignment#role_definition_name}
    */
    readonly roleDefinitionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#scope RoleAssignment#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#skip_service_principal_aad_check RoleAssignment#skip_service_principal_aad_check}
    */
    readonly skipServicePrincipalAadCheck?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#timeouts RoleAssignment#timeouts}
    */
    readonly timeouts?: RoleAssignmentTimeouts;
}
export interface RoleAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#create RoleAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#delete RoleAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#read RoleAssignment#read}
    */
    readonly read?: string;
}
export declare function roleAssignmentTimeoutsToTerraform(struct?: RoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare function roleAssignmentTimeoutsToHclTerraform(struct?: RoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare class RoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RoleAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RoleAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment azurerm_role_assignment}
*/
export declare class RoleAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_role_assignment";
    /**
    * Generates CDKTF code for importing a RoleAssignment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RoleAssignment to import
    * @param importFromId The id of the existing RoleAssignment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RoleAssignment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/role_assignment azurerm_role_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: RoleAssignmentConfig);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _conditionVersion?;
    get conditionVersion(): string;
    set conditionVersion(value: string);
    resetConditionVersion(): void;
    get conditionVersionInput(): string | undefined;
    private _delegatedManagedIdentityResourceId?;
    get delegatedManagedIdentityResourceId(): string;
    set delegatedManagedIdentityResourceId(value: string);
    resetDelegatedManagedIdentityResourceId(): void;
    get delegatedManagedIdentityResourceIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
    private _principalType?;
    get principalType(): string;
    set principalType(value: string);
    resetPrincipalType(): void;
    get principalTypeInput(): string | undefined;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    resetRoleDefinitionId(): void;
    get roleDefinitionIdInput(): string | undefined;
    private _roleDefinitionName?;
    get roleDefinitionName(): string;
    set roleDefinitionName(value: string);
    resetRoleDefinitionName(): void;
    get roleDefinitionNameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _skipServicePrincipalAadCheck?;
    get skipServicePrincipalAadCheck(): boolean | cdktf.IResolvable;
    set skipServicePrincipalAadCheck(value: boolean | cdktf.IResolvable);
    resetSkipServicePrincipalAadCheck(): void;
    get skipServicePrincipalAadCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): RoleAssignmentTimeoutsOutputReference;
    putTimeouts(value: RoleAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RoleAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
