/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SearchServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#allowed_ips SearchService#allowed_ips}
    */
    readonly allowedIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#authentication_failure_mode SearchService#authentication_failure_mode}
    */
    readonly authenticationFailureMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#customer_managed_key_enforcement_enabled SearchService#customer_managed_key_enforcement_enabled}
    */
    readonly customerManagedKeyEnforcementEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#hosting_mode SearchService#hosting_mode}
    */
    readonly hostingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#id SearchService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#local_authentication_enabled SearchService#local_authentication_enabled}
    */
    readonly localAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#location SearchService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#name SearchService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#network_rule_bypass_option SearchService#network_rule_bypass_option}
    */
    readonly networkRuleBypassOption?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#partition_count SearchService#partition_count}
    */
    readonly partitionCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#public_network_access_enabled SearchService#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#replica_count SearchService#replica_count}
    */
    readonly replicaCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#resource_group_name SearchService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#semantic_search_sku SearchService#semantic_search_sku}
    */
    readonly semanticSearchSku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#sku SearchService#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#tags SearchService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#identity SearchService#identity}
    */
    readonly identity?: SearchServiceIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#timeouts SearchService#timeouts}
    */
    readonly timeouts?: SearchServiceTimeouts;
}
export interface SearchServiceQueryKeys {
}
export declare function searchServiceQueryKeysToTerraform(struct?: SearchServiceQueryKeys): any;
export declare function searchServiceQueryKeysToHclTerraform(struct?: SearchServiceQueryKeys): any;
export declare class SearchServiceQueryKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SearchServiceQueryKeys | undefined;
    set internalValue(value: SearchServiceQueryKeys | undefined);
    get key(): string;
    get name(): string;
}
export declare class SearchServiceQueryKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SearchServiceQueryKeysOutputReference;
}
export interface SearchServiceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#identity_ids SearchService#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#type SearchService#type}
    */
    readonly type: string;
}
export declare function searchServiceIdentityToTerraform(struct?: SearchServiceIdentityOutputReference | SearchServiceIdentity): any;
export declare function searchServiceIdentityToHclTerraform(struct?: SearchServiceIdentityOutputReference | SearchServiceIdentity): any;
export declare class SearchServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SearchServiceIdentity | undefined;
    set internalValue(value: SearchServiceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SearchServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#create SearchService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#delete SearchService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#read SearchService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#update SearchService#update}
    */
    readonly update?: string;
}
export declare function searchServiceTimeoutsToTerraform(struct?: SearchServiceTimeouts | cdktf.IResolvable): any;
export declare function searchServiceTimeoutsToHclTerraform(struct?: SearchServiceTimeouts | cdktf.IResolvable): any;
export declare class SearchServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SearchServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SearchServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service azurerm_search_service}
*/
export declare class SearchService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_search_service";
    /**
    * Generates CDKTF code for importing a SearchService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SearchService to import
    * @param importFromId The id of the existing SearchService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SearchService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/search_service azurerm_search_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SearchServiceConfig
    */
    constructor(scope: Construct, id: string, config: SearchServiceConfig);
    private _allowedIps?;
    get allowedIps(): string[];
    set allowedIps(value: string[]);
    resetAllowedIps(): void;
    get allowedIpsInput(): string[] | undefined;
    private _authenticationFailureMode?;
    get authenticationFailureMode(): string;
    set authenticationFailureMode(value: string);
    resetAuthenticationFailureMode(): void;
    get authenticationFailureModeInput(): string | undefined;
    get customerManagedKeyEncryptionComplianceStatus(): string;
    private _customerManagedKeyEnforcementEnabled?;
    get customerManagedKeyEnforcementEnabled(): boolean | cdktf.IResolvable;
    set customerManagedKeyEnforcementEnabled(value: boolean | cdktf.IResolvable);
    resetCustomerManagedKeyEnforcementEnabled(): void;
    get customerManagedKeyEnforcementEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostingMode?;
    get hostingMode(): string;
    set hostingMode(value: string);
    resetHostingMode(): void;
    get hostingModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthenticationEnabled?;
    get localAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set localAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationEnabled(): void;
    get localAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkRuleBypassOption?;
    get networkRuleBypassOption(): string;
    set networkRuleBypassOption(value: string);
    resetNetworkRuleBypassOption(): void;
    get networkRuleBypassOptionInput(): string | undefined;
    private _partitionCount?;
    get partitionCount(): number;
    set partitionCount(value: number);
    resetPartitionCount(): void;
    get partitionCountInput(): number | undefined;
    get primaryKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _queryKeys;
    get queryKeys(): SearchServiceQueryKeysList;
    private _replicaCount?;
    get replicaCount(): number;
    set replicaCount(value: number);
    resetReplicaCount(): void;
    get replicaCountInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryKey(): string;
    private _semanticSearchSku?;
    get semanticSearchSku(): string;
    set semanticSearchSku(value: string);
    resetSemanticSearchSku(): void;
    get semanticSearchSkuInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): SearchServiceIdentityOutputReference;
    putIdentity(value: SearchServiceIdentity): void;
    resetIdentity(): void;
    get identityInput(): SearchServiceIdentity | undefined;
    private _timeouts;
    get timeouts(): SearchServiceTimeoutsOutputReference;
    putTimeouts(value: SearchServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SearchServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
