/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SiteRecoveryVmwareReplicatedVmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#appliance_name SiteRecoveryVmwareReplicatedVm#appliance_name}
    */
    readonly applianceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#default_log_storage_account_id SiteRecoveryVmwareReplicatedVm#default_log_storage_account_id}
    */
    readonly defaultLogStorageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#default_recovery_disk_type SiteRecoveryVmwareReplicatedVm#default_recovery_disk_type}
    */
    readonly defaultRecoveryDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#default_target_disk_encryption_set_id SiteRecoveryVmwareReplicatedVm#default_target_disk_encryption_set_id}
    */
    readonly defaultTargetDiskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#id SiteRecoveryVmwareReplicatedVm#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#license_type SiteRecoveryVmwareReplicatedVm#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#multi_vm_group_name SiteRecoveryVmwareReplicatedVm#multi_vm_group_name}
    */
    readonly multiVmGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#name SiteRecoveryVmwareReplicatedVm#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#physical_server_credential_name SiteRecoveryVmwareReplicatedVm#physical_server_credential_name}
    */
    readonly physicalServerCredentialName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#recovery_replication_policy_id SiteRecoveryVmwareReplicatedVm#recovery_replication_policy_id}
    */
    readonly recoveryReplicationPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#recovery_vault_id SiteRecoveryVmwareReplicatedVm#recovery_vault_id}
    */
    readonly recoveryVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#source_vm_name SiteRecoveryVmwareReplicatedVm#source_vm_name}
    */
    readonly sourceVmName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_availability_set_id SiteRecoveryVmwareReplicatedVm#target_availability_set_id}
    */
    readonly targetAvailabilitySetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_boot_diagnostics_storage_account_id SiteRecoveryVmwareReplicatedVm#target_boot_diagnostics_storage_account_id}
    */
    readonly targetBootDiagnosticsStorageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_network_id SiteRecoveryVmwareReplicatedVm#target_network_id}
    */
    readonly targetNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_proximity_placement_group_id SiteRecoveryVmwareReplicatedVm#target_proximity_placement_group_id}
    */
    readonly targetProximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_resource_group_id SiteRecoveryVmwareReplicatedVm#target_resource_group_id}
    */
    readonly targetResourceGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_vm_name SiteRecoveryVmwareReplicatedVm#target_vm_name}
    */
    readonly targetVmName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_vm_size SiteRecoveryVmwareReplicatedVm#target_vm_size}
    */
    readonly targetVmSize?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_zone SiteRecoveryVmwareReplicatedVm#target_zone}
    */
    readonly targetZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#test_network_id SiteRecoveryVmwareReplicatedVm#test_network_id}
    */
    readonly testNetworkId?: string;
    /**
    * managed_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#managed_disk SiteRecoveryVmwareReplicatedVm#managed_disk}
    */
    readonly managedDisk?: SiteRecoveryVmwareReplicatedVmManagedDisk[] | cdktf.IResolvable;
    /**
    * network_interface block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#network_interface SiteRecoveryVmwareReplicatedVm#network_interface}
    */
    readonly networkInterface?: SiteRecoveryVmwareReplicatedVmNetworkInterface[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#timeouts SiteRecoveryVmwareReplicatedVm#timeouts}
    */
    readonly timeouts?: SiteRecoveryVmwareReplicatedVmTimeouts;
}
export interface SiteRecoveryVmwareReplicatedVmManagedDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#disk_id SiteRecoveryVmwareReplicatedVm#disk_id}
    */
    readonly diskId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#log_storage_account_id SiteRecoveryVmwareReplicatedVm#log_storage_account_id}
    */
    readonly logStorageAccountId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_disk_encryption_set_id SiteRecoveryVmwareReplicatedVm#target_disk_encryption_set_id}
    */
    readonly targetDiskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_disk_type SiteRecoveryVmwareReplicatedVm#target_disk_type}
    */
    readonly targetDiskType: string;
}
export declare function siteRecoveryVmwareReplicatedVmManagedDiskToTerraform(struct?: SiteRecoveryVmwareReplicatedVmManagedDisk | cdktf.IResolvable): any;
export declare function siteRecoveryVmwareReplicatedVmManagedDiskToHclTerraform(struct?: SiteRecoveryVmwareReplicatedVmManagedDisk | cdktf.IResolvable): any;
export declare class SiteRecoveryVmwareReplicatedVmManagedDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryVmwareReplicatedVmManagedDisk | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryVmwareReplicatedVmManagedDisk | cdktf.IResolvable | undefined);
    private _diskId?;
    get diskId(): string;
    set diskId(value: string);
    get diskIdInput(): string | undefined;
    private _logStorageAccountId?;
    get logStorageAccountId(): string;
    set logStorageAccountId(value: string);
    resetLogStorageAccountId(): void;
    get logStorageAccountIdInput(): string | undefined;
    private _targetDiskEncryptionSetId?;
    get targetDiskEncryptionSetId(): string;
    set targetDiskEncryptionSetId(value: string);
    resetTargetDiskEncryptionSetId(): void;
    get targetDiskEncryptionSetIdInput(): string | undefined;
    private _targetDiskType?;
    get targetDiskType(): string;
    set targetDiskType(value: string);
    get targetDiskTypeInput(): string | undefined;
}
export declare class SiteRecoveryVmwareReplicatedVmManagedDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryVmwareReplicatedVmManagedDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryVmwareReplicatedVmManagedDiskOutputReference;
}
export interface SiteRecoveryVmwareReplicatedVmNetworkInterface {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#is_primary SiteRecoveryVmwareReplicatedVm#is_primary}
    */
    readonly isPrimary: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#source_mac_address SiteRecoveryVmwareReplicatedVm#source_mac_address}
    */
    readonly sourceMacAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_static_ip SiteRecoveryVmwareReplicatedVm#target_static_ip}
    */
    readonly targetStaticIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#target_subnet_name SiteRecoveryVmwareReplicatedVm#target_subnet_name}
    */
    readonly targetSubnetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#test_subnet_name SiteRecoveryVmwareReplicatedVm#test_subnet_name}
    */
    readonly testSubnetName?: string;
}
export declare function siteRecoveryVmwareReplicatedVmNetworkInterfaceToTerraform(struct?: SiteRecoveryVmwareReplicatedVmNetworkInterface | cdktf.IResolvable): any;
export declare function siteRecoveryVmwareReplicatedVmNetworkInterfaceToHclTerraform(struct?: SiteRecoveryVmwareReplicatedVmNetworkInterface | cdktf.IResolvable): any;
export declare class SiteRecoveryVmwareReplicatedVmNetworkInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SiteRecoveryVmwareReplicatedVmNetworkInterface | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryVmwareReplicatedVmNetworkInterface | cdktf.IResolvable | undefined);
    private _isPrimary?;
    get isPrimary(): boolean | cdktf.IResolvable;
    set isPrimary(value: boolean | cdktf.IResolvable);
    get isPrimaryInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceMacAddress?;
    get sourceMacAddress(): string;
    set sourceMacAddress(value: string);
    get sourceMacAddressInput(): string | undefined;
    private _targetStaticIp?;
    get targetStaticIp(): string;
    set targetStaticIp(value: string);
    resetTargetStaticIp(): void;
    get targetStaticIpInput(): string | undefined;
    private _targetSubnetName?;
    get targetSubnetName(): string;
    set targetSubnetName(value: string);
    resetTargetSubnetName(): void;
    get targetSubnetNameInput(): string | undefined;
    private _testSubnetName?;
    get testSubnetName(): string;
    set testSubnetName(value: string);
    resetTestSubnetName(): void;
    get testSubnetNameInput(): string | undefined;
}
export declare class SiteRecoveryVmwareReplicatedVmNetworkInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SiteRecoveryVmwareReplicatedVmNetworkInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SiteRecoveryVmwareReplicatedVmNetworkInterfaceOutputReference;
}
export interface SiteRecoveryVmwareReplicatedVmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#create SiteRecoveryVmwareReplicatedVm#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#delete SiteRecoveryVmwareReplicatedVm#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#read SiteRecoveryVmwareReplicatedVm#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#update SiteRecoveryVmwareReplicatedVm#update}
    */
    readonly update?: string;
}
export declare function siteRecoveryVmwareReplicatedVmTimeoutsToTerraform(struct?: SiteRecoveryVmwareReplicatedVmTimeouts | cdktf.IResolvable): any;
export declare function siteRecoveryVmwareReplicatedVmTimeoutsToHclTerraform(struct?: SiteRecoveryVmwareReplicatedVmTimeouts | cdktf.IResolvable): any;
export declare class SiteRecoveryVmwareReplicatedVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SiteRecoveryVmwareReplicatedVmTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SiteRecoveryVmwareReplicatedVmTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm azurerm_site_recovery_vmware_replicated_vm}
*/
export declare class SiteRecoveryVmwareReplicatedVm extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_site_recovery_vmware_replicated_vm";
    /**
    * Generates CDKTF code for importing a SiteRecoveryVmwareReplicatedVm resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SiteRecoveryVmwareReplicatedVm to import
    * @param importFromId The id of the existing SiteRecoveryVmwareReplicatedVm that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SiteRecoveryVmwareReplicatedVm to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/site_recovery_vmware_replicated_vm azurerm_site_recovery_vmware_replicated_vm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SiteRecoveryVmwareReplicatedVmConfig
    */
    constructor(scope: Construct, id: string, config: SiteRecoveryVmwareReplicatedVmConfig);
    private _applianceName?;
    get applianceName(): string;
    set applianceName(value: string);
    get applianceNameInput(): string | undefined;
    private _defaultLogStorageAccountId?;
    get defaultLogStorageAccountId(): string;
    set defaultLogStorageAccountId(value: string);
    resetDefaultLogStorageAccountId(): void;
    get defaultLogStorageAccountIdInput(): string | undefined;
    private _defaultRecoveryDiskType?;
    get defaultRecoveryDiskType(): string;
    set defaultRecoveryDiskType(value: string);
    resetDefaultRecoveryDiskType(): void;
    get defaultRecoveryDiskTypeInput(): string | undefined;
    private _defaultTargetDiskEncryptionSetId?;
    get defaultTargetDiskEncryptionSetId(): string;
    set defaultTargetDiskEncryptionSetId(value: string);
    resetDefaultTargetDiskEncryptionSetId(): void;
    get defaultTargetDiskEncryptionSetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _multiVmGroupName?;
    get multiVmGroupName(): string;
    set multiVmGroupName(value: string);
    resetMultiVmGroupName(): void;
    get multiVmGroupNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _physicalServerCredentialName?;
    get physicalServerCredentialName(): string;
    set physicalServerCredentialName(value: string);
    get physicalServerCredentialNameInput(): string | undefined;
    private _recoveryReplicationPolicyId?;
    get recoveryReplicationPolicyId(): string;
    set recoveryReplicationPolicyId(value: string);
    get recoveryReplicationPolicyIdInput(): string | undefined;
    private _recoveryVaultId?;
    get recoveryVaultId(): string;
    set recoveryVaultId(value: string);
    get recoveryVaultIdInput(): string | undefined;
    private _sourceVmName?;
    get sourceVmName(): string;
    set sourceVmName(value: string);
    get sourceVmNameInput(): string | undefined;
    private _targetAvailabilitySetId?;
    get targetAvailabilitySetId(): string;
    set targetAvailabilitySetId(value: string);
    resetTargetAvailabilitySetId(): void;
    get targetAvailabilitySetIdInput(): string | undefined;
    private _targetBootDiagnosticsStorageAccountId?;
    get targetBootDiagnosticsStorageAccountId(): string;
    set targetBootDiagnosticsStorageAccountId(value: string);
    resetTargetBootDiagnosticsStorageAccountId(): void;
    get targetBootDiagnosticsStorageAccountIdInput(): string | undefined;
    private _targetNetworkId?;
    get targetNetworkId(): string;
    set targetNetworkId(value: string);
    resetTargetNetworkId(): void;
    get targetNetworkIdInput(): string | undefined;
    private _targetProximityPlacementGroupId?;
    get targetProximityPlacementGroupId(): string;
    set targetProximityPlacementGroupId(value: string);
    resetTargetProximityPlacementGroupId(): void;
    get targetProximityPlacementGroupIdInput(): string | undefined;
    private _targetResourceGroupId?;
    get targetResourceGroupId(): string;
    set targetResourceGroupId(value: string);
    get targetResourceGroupIdInput(): string | undefined;
    private _targetVmName?;
    get targetVmName(): string;
    set targetVmName(value: string);
    get targetVmNameInput(): string | undefined;
    private _targetVmSize?;
    get targetVmSize(): string;
    set targetVmSize(value: string);
    resetTargetVmSize(): void;
    get targetVmSizeInput(): string | undefined;
    private _targetZone?;
    get targetZone(): string;
    set targetZone(value: string);
    resetTargetZone(): void;
    get targetZoneInput(): string | undefined;
    private _testNetworkId?;
    get testNetworkId(): string;
    set testNetworkId(value: string);
    resetTestNetworkId(): void;
    get testNetworkIdInput(): string | undefined;
    private _managedDisk;
    get managedDisk(): SiteRecoveryVmwareReplicatedVmManagedDiskList;
    putManagedDisk(value: SiteRecoveryVmwareReplicatedVmManagedDisk[] | cdktf.IResolvable): void;
    resetManagedDisk(): void;
    get managedDiskInput(): cdktf.IResolvable | SiteRecoveryVmwareReplicatedVmManagedDisk[] | undefined;
    private _networkInterface;
    get networkInterface(): SiteRecoveryVmwareReplicatedVmNetworkInterfaceList;
    putNetworkInterface(value: SiteRecoveryVmwareReplicatedVmNetworkInterface[] | cdktf.IResolvable): void;
    resetNetworkInterface(): void;
    get networkInterfaceInput(): cdktf.IResolvable | SiteRecoveryVmwareReplicatedVmNetworkInterface[] | undefined;
    private _timeouts;
    get timeouts(): SiteRecoveryVmwareReplicatedVmTimeoutsOutputReference;
    putTimeouts(value: SiteRecoveryVmwareReplicatedVmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SiteRecoveryVmwareReplicatedVmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
