/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudAppDynamicsApplicationPerformanceMonitoringConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#agent_account_access_key SpringCloudAppDynamicsApplicationPerformanceMonitoring#agent_account_access_key}
    */
    readonly agentAccountAccessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#agent_account_name SpringCloudAppDynamicsApplicationPerformanceMonitoring#agent_account_name}
    */
    readonly agentAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#agent_application_name SpringCloudAppDynamicsApplicationPerformanceMonitoring#agent_application_name}
    */
    readonly agentApplicationName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#agent_node_name SpringCloudAppDynamicsApplicationPerformanceMonitoring#agent_node_name}
    */
    readonly agentNodeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#agent_tier_name SpringCloudAppDynamicsApplicationPerformanceMonitoring#agent_tier_name}
    */
    readonly agentTierName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#agent_unique_host_id SpringCloudAppDynamicsApplicationPerformanceMonitoring#agent_unique_host_id}
    */
    readonly agentUniqueHostId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#controller_host_name SpringCloudAppDynamicsApplicationPerformanceMonitoring#controller_host_name}
    */
    readonly controllerHostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#controller_port SpringCloudAppDynamicsApplicationPerformanceMonitoring#controller_port}
    */
    readonly controllerPort?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#controller_ssl_enabled SpringCloudAppDynamicsApplicationPerformanceMonitoring#controller_ssl_enabled}
    */
    readonly controllerSslEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#globally_enabled SpringCloudAppDynamicsApplicationPerformanceMonitoring#globally_enabled}
    */
    readonly globallyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#id SpringCloudAppDynamicsApplicationPerformanceMonitoring#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#name SpringCloudAppDynamicsApplicationPerformanceMonitoring#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#spring_cloud_service_id SpringCloudAppDynamicsApplicationPerformanceMonitoring#spring_cloud_service_id}
    */
    readonly springCloudServiceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#timeouts SpringCloudAppDynamicsApplicationPerformanceMonitoring#timeouts}
    */
    readonly timeouts?: SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts;
}
export interface SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#create SpringCloudAppDynamicsApplicationPerformanceMonitoring#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#delete SpringCloudAppDynamicsApplicationPerformanceMonitoring#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#read SpringCloudAppDynamicsApplicationPerformanceMonitoring#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#update SpringCloudAppDynamicsApplicationPerformanceMonitoring#update}
    */
    readonly update?: string;
}
export declare function springCloudAppDynamicsApplicationPerformanceMonitoringTimeoutsToTerraform(struct?: SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts | cdktf.IResolvable): any;
export declare function springCloudAppDynamicsApplicationPerformanceMonitoringTimeoutsToHclTerraform(struct?: SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring azurerm_spring_cloud_app_dynamics_application_performance_monitoring}
*/
export declare class SpringCloudAppDynamicsApplicationPerformanceMonitoring extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_app_dynamics_application_performance_monitoring";
    /**
    * Generates CDKTF code for importing a SpringCloudAppDynamicsApplicationPerformanceMonitoring resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudAppDynamicsApplicationPerformanceMonitoring to import
    * @param importFromId The id of the existing SpringCloudAppDynamicsApplicationPerformanceMonitoring that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudAppDynamicsApplicationPerformanceMonitoring to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/spring_cloud_app_dynamics_application_performance_monitoring azurerm_spring_cloud_app_dynamics_application_performance_monitoring} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudAppDynamicsApplicationPerformanceMonitoringConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudAppDynamicsApplicationPerformanceMonitoringConfig);
    private _agentAccountAccessKey?;
    get agentAccountAccessKey(): string;
    set agentAccountAccessKey(value: string);
    get agentAccountAccessKeyInput(): string | undefined;
    private _agentAccountName?;
    get agentAccountName(): string;
    set agentAccountName(value: string);
    get agentAccountNameInput(): string | undefined;
    private _agentApplicationName?;
    get agentApplicationName(): string;
    set agentApplicationName(value: string);
    resetAgentApplicationName(): void;
    get agentApplicationNameInput(): string | undefined;
    private _agentNodeName?;
    get agentNodeName(): string;
    set agentNodeName(value: string);
    resetAgentNodeName(): void;
    get agentNodeNameInput(): string | undefined;
    private _agentTierName?;
    get agentTierName(): string;
    set agentTierName(value: string);
    resetAgentTierName(): void;
    get agentTierNameInput(): string | undefined;
    private _agentUniqueHostId?;
    get agentUniqueHostId(): string;
    set agentUniqueHostId(value: string);
    resetAgentUniqueHostId(): void;
    get agentUniqueHostIdInput(): string | undefined;
    private _controllerHostName?;
    get controllerHostName(): string;
    set controllerHostName(value: string);
    get controllerHostNameInput(): string | undefined;
    private _controllerPort?;
    get controllerPort(): number;
    set controllerPort(value: number);
    resetControllerPort(): void;
    get controllerPortInput(): number | undefined;
    private _controllerSslEnabled?;
    get controllerSslEnabled(): boolean | cdktf.IResolvable;
    set controllerSslEnabled(value: boolean | cdktf.IResolvable);
    resetControllerSslEnabled(): void;
    get controllerSslEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _globallyEnabled?;
    get globallyEnabled(): boolean | cdktf.IResolvable;
    set globallyEnabled(value: boolean | cdktf.IResolvable);
    resetGloballyEnabled(): void;
    get globallyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _springCloudServiceId?;
    get springCloudServiceId(): string;
    set springCloudServiceId(value: string);
    get springCloudServiceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeoutsOutputReference;
    putTimeouts(value: SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudAppDynamicsApplicationPerformanceMonitoringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
