/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamAnalyticsJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#compatibility_level StreamAnalyticsJob#compatibility_level}
    */
    readonly compatibilityLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#content_storage_policy StreamAnalyticsJob#content_storage_policy}
    */
    readonly contentStoragePolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#data_locale StreamAnalyticsJob#data_locale}
    */
    readonly dataLocale?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#events_late_arrival_max_delay_in_seconds StreamAnalyticsJob#events_late_arrival_max_delay_in_seconds}
    */
    readonly eventsLateArrivalMaxDelayInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#events_out_of_order_max_delay_in_seconds StreamAnalyticsJob#events_out_of_order_max_delay_in_seconds}
    */
    readonly eventsOutOfOrderMaxDelayInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#events_out_of_order_policy StreamAnalyticsJob#events_out_of_order_policy}
    */
    readonly eventsOutOfOrderPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#id StreamAnalyticsJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#location StreamAnalyticsJob#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#name StreamAnalyticsJob#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#output_error_policy StreamAnalyticsJob#output_error_policy}
    */
    readonly outputErrorPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#resource_group_name StreamAnalyticsJob#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#sku_name StreamAnalyticsJob#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#stream_analytics_cluster_id StreamAnalyticsJob#stream_analytics_cluster_id}
    */
    readonly streamAnalyticsClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#streaming_units StreamAnalyticsJob#streaming_units}
    */
    readonly streamingUnits?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#tags StreamAnalyticsJob#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#transformation_query StreamAnalyticsJob#transformation_query}
    */
    readonly transformationQuery: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#type StreamAnalyticsJob#type}
    */
    readonly type?: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#identity StreamAnalyticsJob#identity}
    */
    readonly identity?: StreamAnalyticsJobIdentity;
    /**
    * job_storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#job_storage_account StreamAnalyticsJob#job_storage_account}
    */
    readonly jobStorageAccount?: StreamAnalyticsJobJobStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#timeouts StreamAnalyticsJob#timeouts}
    */
    readonly timeouts?: StreamAnalyticsJobTimeouts;
}
export interface StreamAnalyticsJobIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#identity_ids StreamAnalyticsJob#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#type StreamAnalyticsJob#type}
    */
    readonly type: string;
}
export declare function streamAnalyticsJobIdentityToTerraform(struct?: StreamAnalyticsJobIdentityOutputReference | StreamAnalyticsJobIdentity): any;
export declare function streamAnalyticsJobIdentityToHclTerraform(struct?: StreamAnalyticsJobIdentityOutputReference | StreamAnalyticsJobIdentity): any;
export declare class StreamAnalyticsJobIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsJobIdentity | undefined;
    set internalValue(value: StreamAnalyticsJobIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StreamAnalyticsJobJobStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#account_key StreamAnalyticsJob#account_key}
    */
    readonly accountKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#account_name StreamAnalyticsJob#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#authentication_mode StreamAnalyticsJob#authentication_mode}
    */
    readonly authenticationMode?: string;
}
export declare function streamAnalyticsJobJobStorageAccountToTerraform(struct?: StreamAnalyticsJobJobStorageAccount | cdktf.IResolvable): any;
export declare function streamAnalyticsJobJobStorageAccountToHclTerraform(struct?: StreamAnalyticsJobJobStorageAccount | cdktf.IResolvable): any;
export declare class StreamAnalyticsJobJobStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StreamAnalyticsJobJobStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsJobJobStorageAccount | cdktf.IResolvable | undefined);
    private _accountKey?;
    get accountKey(): string;
    set accountKey(value: string);
    get accountKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _authenticationMode?;
    get authenticationMode(): string;
    set authenticationMode(value: string);
    resetAuthenticationMode(): void;
    get authenticationModeInput(): string | undefined;
}
export declare class StreamAnalyticsJobJobStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StreamAnalyticsJobJobStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StreamAnalyticsJobJobStorageAccountOutputReference;
}
export interface StreamAnalyticsJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#create StreamAnalyticsJob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#delete StreamAnalyticsJob#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#read StreamAnalyticsJob#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#update StreamAnalyticsJob#update}
    */
    readonly update?: string;
}
export declare function streamAnalyticsJobTimeoutsToTerraform(struct?: StreamAnalyticsJobTimeouts | cdktf.IResolvable): any;
export declare function streamAnalyticsJobTimeoutsToHclTerraform(struct?: StreamAnalyticsJobTimeouts | cdktf.IResolvable): any;
export declare class StreamAnalyticsJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StreamAnalyticsJobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StreamAnalyticsJobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job azurerm_stream_analytics_job}
*/
export declare class StreamAnalyticsJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_stream_analytics_job";
    /**
    * Generates CDKTF code for importing a StreamAnalyticsJob resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StreamAnalyticsJob to import
    * @param importFromId The id of the existing StreamAnalyticsJob that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StreamAnalyticsJob to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/stream_analytics_job azurerm_stream_analytics_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamAnalyticsJobConfig
    */
    constructor(scope: Construct, id: string, config: StreamAnalyticsJobConfig);
    private _compatibilityLevel?;
    get compatibilityLevel(): string;
    set compatibilityLevel(value: string);
    resetCompatibilityLevel(): void;
    get compatibilityLevelInput(): string | undefined;
    private _contentStoragePolicy?;
    get contentStoragePolicy(): string;
    set contentStoragePolicy(value: string);
    resetContentStoragePolicy(): void;
    get contentStoragePolicyInput(): string | undefined;
    private _dataLocale?;
    get dataLocale(): string;
    set dataLocale(value: string);
    resetDataLocale(): void;
    get dataLocaleInput(): string | undefined;
    private _eventsLateArrivalMaxDelayInSeconds?;
    get eventsLateArrivalMaxDelayInSeconds(): number;
    set eventsLateArrivalMaxDelayInSeconds(value: number);
    resetEventsLateArrivalMaxDelayInSeconds(): void;
    get eventsLateArrivalMaxDelayInSecondsInput(): number | undefined;
    private _eventsOutOfOrderMaxDelayInSeconds?;
    get eventsOutOfOrderMaxDelayInSeconds(): number;
    set eventsOutOfOrderMaxDelayInSeconds(value: number);
    resetEventsOutOfOrderMaxDelayInSeconds(): void;
    get eventsOutOfOrderMaxDelayInSecondsInput(): number | undefined;
    private _eventsOutOfOrderPolicy?;
    get eventsOutOfOrderPolicy(): string;
    set eventsOutOfOrderPolicy(value: string);
    resetEventsOutOfOrderPolicy(): void;
    get eventsOutOfOrderPolicyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get jobId(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outputErrorPolicy?;
    get outputErrorPolicy(): string;
    set outputErrorPolicy(value: string);
    resetOutputErrorPolicy(): void;
    get outputErrorPolicyInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _streamAnalyticsClusterId?;
    get streamAnalyticsClusterId(): string;
    set streamAnalyticsClusterId(value: string);
    resetStreamAnalyticsClusterId(): void;
    get streamAnalyticsClusterIdInput(): string | undefined;
    private _streamingUnits?;
    get streamingUnits(): number;
    set streamingUnits(value: number);
    resetStreamingUnits(): void;
    get streamingUnitsInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _transformationQuery?;
    get transformationQuery(): string;
    set transformationQuery(value: string);
    get transformationQueryInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _identity;
    get identity(): StreamAnalyticsJobIdentityOutputReference;
    putIdentity(value: StreamAnalyticsJobIdentity): void;
    resetIdentity(): void;
    get identityInput(): StreamAnalyticsJobIdentity | undefined;
    private _jobStorageAccount;
    get jobStorageAccount(): StreamAnalyticsJobJobStorageAccountList;
    putJobStorageAccount(value: StreamAnalyticsJobJobStorageAccount[] | cdktf.IResolvable): void;
    resetJobStorageAccount(): void;
    get jobStorageAccountInput(): cdktf.IResolvable | StreamAnalyticsJobJobStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): StreamAnalyticsJobTimeoutsOutputReference;
    putTimeouts(value: StreamAnalyticsJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StreamAnalyticsJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
