/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#availability_set_id VirtualMachine#availability_set_id}
    */
    readonly availabilitySetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#delete_data_disks_on_termination VirtualMachine#delete_data_disks_on_termination}
    */
    readonly deleteDataDisksOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#delete_os_disk_on_termination VirtualMachine#delete_os_disk_on_termination}
    */
    readonly deleteOsDiskOnTermination?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#id VirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#license_type VirtualMachine#license_type}
    */
    readonly licenseType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#location VirtualMachine#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#name VirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#network_interface_ids VirtualMachine#network_interface_ids}
    */
    readonly networkInterfaceIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#primary_network_interface_id VirtualMachine#primary_network_interface_id}
    */
    readonly primaryNetworkInterfaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#proximity_placement_group_id VirtualMachine#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#resource_group_name VirtualMachine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#tags VirtualMachine#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#vm_size VirtualMachine#vm_size}
    */
    readonly vmSize: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#zones VirtualMachine#zones}
    */
    readonly zones?: string[];
    /**
    * additional_capabilities block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#additional_capabilities VirtualMachine#additional_capabilities}
    */
    readonly additionalCapabilities?: VirtualMachineAdditionalCapabilities;
    /**
    * boot_diagnostics block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#boot_diagnostics VirtualMachine#boot_diagnostics}
    */
    readonly bootDiagnostics?: VirtualMachineBootDiagnostics;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#identity VirtualMachine#identity}
    */
    readonly identity?: VirtualMachineIdentity;
    /**
    * os_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#os_profile VirtualMachine#os_profile}
    */
    readonly osProfile?: VirtualMachineOsProfile;
    /**
    * os_profile_linux_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#os_profile_linux_config VirtualMachine#os_profile_linux_config}
    */
    readonly osProfileLinuxConfig?: VirtualMachineOsProfileLinuxConfig;
    /**
    * os_profile_secrets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#os_profile_secrets VirtualMachine#os_profile_secrets}
    */
    readonly osProfileSecrets?: VirtualMachineOsProfileSecrets[] | cdktf.IResolvable;
    /**
    * os_profile_windows_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#os_profile_windows_config VirtualMachine#os_profile_windows_config}
    */
    readonly osProfileWindowsConfig?: VirtualMachineOsProfileWindowsConfig;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#plan VirtualMachine#plan}
    */
    readonly plan?: VirtualMachinePlan;
    /**
    * storage_data_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#storage_data_disk VirtualMachine#storage_data_disk}
    */
    readonly storageDataDisk?: VirtualMachineStorageDataDisk[] | cdktf.IResolvable;
    /**
    * storage_image_reference block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#storage_image_reference VirtualMachine#storage_image_reference}
    */
    readonly storageImageReference?: VirtualMachineStorageImageReference;
    /**
    * storage_os_disk block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#storage_os_disk VirtualMachine#storage_os_disk}
    */
    readonly storageOsDisk: VirtualMachineStorageOsDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#timeouts VirtualMachine#timeouts}
    */
    readonly timeouts?: VirtualMachineTimeouts;
}
export interface VirtualMachineAdditionalCapabilities {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#ultra_ssd_enabled VirtualMachine#ultra_ssd_enabled}
    */
    readonly ultraSsdEnabled: boolean | cdktf.IResolvable;
}
export declare function virtualMachineAdditionalCapabilitiesToTerraform(struct?: VirtualMachineAdditionalCapabilitiesOutputReference | VirtualMachineAdditionalCapabilities): any;
export declare function virtualMachineAdditionalCapabilitiesToHclTerraform(struct?: VirtualMachineAdditionalCapabilitiesOutputReference | VirtualMachineAdditionalCapabilities): any;
export declare class VirtualMachineAdditionalCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineAdditionalCapabilities | undefined;
    set internalValue(value: VirtualMachineAdditionalCapabilities | undefined);
    private _ultraSsdEnabled?;
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface VirtualMachineBootDiagnostics {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#enabled VirtualMachine#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#storage_uri VirtualMachine#storage_uri}
    */
    readonly storageUri: string;
}
export declare function virtualMachineBootDiagnosticsToTerraform(struct?: VirtualMachineBootDiagnosticsOutputReference | VirtualMachineBootDiagnostics): any;
export declare function virtualMachineBootDiagnosticsToHclTerraform(struct?: VirtualMachineBootDiagnosticsOutputReference | VirtualMachineBootDiagnostics): any;
export declare class VirtualMachineBootDiagnosticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineBootDiagnostics | undefined;
    set internalValue(value: VirtualMachineBootDiagnostics | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageUri?;
    get storageUri(): string;
    set storageUri(value: string);
    get storageUriInput(): string | undefined;
}
export interface VirtualMachineIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#identity_ids VirtualMachine#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#type VirtualMachine#type}
    */
    readonly type: string;
}
export declare function virtualMachineIdentityToTerraform(struct?: VirtualMachineIdentityOutputReference | VirtualMachineIdentity): any;
export declare function virtualMachineIdentityToHclTerraform(struct?: VirtualMachineIdentityOutputReference | VirtualMachineIdentity): any;
export declare class VirtualMachineIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineIdentity | undefined;
    set internalValue(value: VirtualMachineIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface VirtualMachineOsProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#admin_password VirtualMachine#admin_password}
    */
    readonly adminPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#admin_username VirtualMachine#admin_username}
    */
    readonly adminUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#computer_name VirtualMachine#computer_name}
    */
    readonly computerName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#custom_data VirtualMachine#custom_data}
    */
    readonly customData?: string;
}
export declare function virtualMachineOsProfileToTerraform(struct?: VirtualMachineOsProfileOutputReference | VirtualMachineOsProfile): any;
export declare function virtualMachineOsProfileToHclTerraform(struct?: VirtualMachineOsProfileOutputReference | VirtualMachineOsProfile): any;
export declare class VirtualMachineOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineOsProfile | undefined;
    set internalValue(value: VirtualMachineOsProfile | undefined);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    resetAdminPassword(): void;
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    get adminUsername(): string;
    set adminUsername(value: string);
    get adminUsernameInput(): string | undefined;
    private _computerName?;
    get computerName(): string;
    set computerName(value: string);
    get computerNameInput(): string | undefined;
    private _customData?;
    get customData(): string;
    set customData(value: string);
    resetCustomData(): void;
    get customDataInput(): string | undefined;
}
export interface VirtualMachineOsProfileLinuxConfigSshKeys {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#key_data VirtualMachine#key_data}
    */
    readonly keyData: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#path VirtualMachine#path}
    */
    readonly path: string;
}
export declare function virtualMachineOsProfileLinuxConfigSshKeysToTerraform(struct?: VirtualMachineOsProfileLinuxConfigSshKeys | cdktf.IResolvable): any;
export declare function virtualMachineOsProfileLinuxConfigSshKeysToHclTerraform(struct?: VirtualMachineOsProfileLinuxConfigSshKeys | cdktf.IResolvable): any;
export declare class VirtualMachineOsProfileLinuxConfigSshKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineOsProfileLinuxConfigSshKeys | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineOsProfileLinuxConfigSshKeys | cdktf.IResolvable | undefined);
    private _keyData?;
    get keyData(): string;
    set keyData(value: string);
    get keyDataInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class VirtualMachineOsProfileLinuxConfigSshKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineOsProfileLinuxConfigSshKeysOutputReference;
}
export interface VirtualMachineOsProfileLinuxConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#disable_password_authentication VirtualMachine#disable_password_authentication}
    */
    readonly disablePasswordAuthentication: boolean | cdktf.IResolvable;
    /**
    * ssh_keys block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#ssh_keys VirtualMachine#ssh_keys}
    */
    readonly sshKeys?: VirtualMachineOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable;
}
export declare function virtualMachineOsProfileLinuxConfigToTerraform(struct?: VirtualMachineOsProfileLinuxConfigOutputReference | VirtualMachineOsProfileLinuxConfig): any;
export declare function virtualMachineOsProfileLinuxConfigToHclTerraform(struct?: VirtualMachineOsProfileLinuxConfigOutputReference | VirtualMachineOsProfileLinuxConfig): any;
export declare class VirtualMachineOsProfileLinuxConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineOsProfileLinuxConfig | undefined;
    set internalValue(value: VirtualMachineOsProfileLinuxConfig | undefined);
    private _disablePasswordAuthentication?;
    get disablePasswordAuthentication(): boolean | cdktf.IResolvable;
    set disablePasswordAuthentication(value: boolean | cdktf.IResolvable);
    get disablePasswordAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _sshKeys;
    get sshKeys(): VirtualMachineOsProfileLinuxConfigSshKeysList;
    putSshKeys(value: VirtualMachineOsProfileLinuxConfigSshKeys[] | cdktf.IResolvable): void;
    resetSshKeys(): void;
    get sshKeysInput(): cdktf.IResolvable | VirtualMachineOsProfileLinuxConfigSshKeys[] | undefined;
}
export interface VirtualMachineOsProfileSecretsVaultCertificates {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#certificate_store VirtualMachine#certificate_store}
    */
    readonly certificateStore?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#certificate_url VirtualMachine#certificate_url}
    */
    readonly certificateUrl: string;
}
export declare function virtualMachineOsProfileSecretsVaultCertificatesToTerraform(struct?: VirtualMachineOsProfileSecretsVaultCertificates | cdktf.IResolvable): any;
export declare function virtualMachineOsProfileSecretsVaultCertificatesToHclTerraform(struct?: VirtualMachineOsProfileSecretsVaultCertificates | cdktf.IResolvable): any;
export declare class VirtualMachineOsProfileSecretsVaultCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineOsProfileSecretsVaultCertificates | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineOsProfileSecretsVaultCertificates | cdktf.IResolvable | undefined);
    private _certificateStore?;
    get certificateStore(): string;
    set certificateStore(value: string);
    resetCertificateStore(): void;
    get certificateStoreInput(): string | undefined;
    private _certificateUrl?;
    get certificateUrl(): string;
    set certificateUrl(value: string);
    get certificateUrlInput(): string | undefined;
}
export declare class VirtualMachineOsProfileSecretsVaultCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineOsProfileSecretsVaultCertificates[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineOsProfileSecretsVaultCertificatesOutputReference;
}
export interface VirtualMachineOsProfileSecrets {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#source_vault_id VirtualMachine#source_vault_id}
    */
    readonly sourceVaultId: string;
    /**
    * vault_certificates block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#vault_certificates VirtualMachine#vault_certificates}
    */
    readonly vaultCertificates?: VirtualMachineOsProfileSecretsVaultCertificates[] | cdktf.IResolvable;
}
export declare function virtualMachineOsProfileSecretsToTerraform(struct?: VirtualMachineOsProfileSecrets | cdktf.IResolvable): any;
export declare function virtualMachineOsProfileSecretsToHclTerraform(struct?: VirtualMachineOsProfileSecrets | cdktf.IResolvable): any;
export declare class VirtualMachineOsProfileSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineOsProfileSecrets | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineOsProfileSecrets | cdktf.IResolvable | undefined);
    private _sourceVaultId?;
    get sourceVaultId(): string;
    set sourceVaultId(value: string);
    get sourceVaultIdInput(): string | undefined;
    private _vaultCertificates;
    get vaultCertificates(): VirtualMachineOsProfileSecretsVaultCertificatesList;
    putVaultCertificates(value: VirtualMachineOsProfileSecretsVaultCertificates[] | cdktf.IResolvable): void;
    resetVaultCertificates(): void;
    get vaultCertificatesInput(): cdktf.IResolvable | VirtualMachineOsProfileSecretsVaultCertificates[] | undefined;
}
export declare class VirtualMachineOsProfileSecretsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineOsProfileSecrets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineOsProfileSecretsOutputReference;
}
export interface VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#component VirtualMachine#component}
    */
    readonly component: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#content VirtualMachine#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#pass VirtualMachine#pass}
    */
    readonly pass: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#setting_name VirtualMachine#setting_name}
    */
    readonly settingName: string;
}
export declare function virtualMachineOsProfileWindowsConfigAdditionalUnattendConfigToTerraform(struct?: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig | cdktf.IResolvable): any;
export declare function virtualMachineOsProfileWindowsConfigAdditionalUnattendConfigToHclTerraform(struct?: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig | cdktf.IResolvable): any;
export declare class VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig | cdktf.IResolvable | undefined);
    private _component?;
    get component(): string;
    set component(value: string);
    get componentInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _pass?;
    get pass(): string;
    set pass(value: string);
    get passInput(): string | undefined;
    private _settingName?;
    get settingName(): string;
    set settingName(value: string);
    get settingNameInput(): string | undefined;
}
export declare class VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfigOutputReference;
}
export interface VirtualMachineOsProfileWindowsConfigWinrm {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#certificate_url VirtualMachine#certificate_url}
    */
    readonly certificateUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#protocol VirtualMachine#protocol}
    */
    readonly protocol: string;
}
export declare function virtualMachineOsProfileWindowsConfigWinrmToTerraform(struct?: VirtualMachineOsProfileWindowsConfigWinrm | cdktf.IResolvable): any;
export declare function virtualMachineOsProfileWindowsConfigWinrmToHclTerraform(struct?: VirtualMachineOsProfileWindowsConfigWinrm | cdktf.IResolvable): any;
export declare class VirtualMachineOsProfileWindowsConfigWinrmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineOsProfileWindowsConfigWinrm | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineOsProfileWindowsConfigWinrm | cdktf.IResolvable | undefined);
    private _certificateUrl?;
    get certificateUrl(): string;
    set certificateUrl(value: string);
    resetCertificateUrl(): void;
    get certificateUrlInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class VirtualMachineOsProfileWindowsConfigWinrmList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineOsProfileWindowsConfigWinrm[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineOsProfileWindowsConfigWinrmOutputReference;
}
export interface VirtualMachineOsProfileWindowsConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#enable_automatic_upgrades VirtualMachine#enable_automatic_upgrades}
    */
    readonly enableAutomaticUpgrades?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#provision_vm_agent VirtualMachine#provision_vm_agent}
    */
    readonly provisionVmAgent?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#timezone VirtualMachine#timezone}
    */
    readonly timezone?: string;
    /**
    * additional_unattend_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#additional_unattend_config VirtualMachine#additional_unattend_config}
    */
    readonly additionalUnattendConfig?: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable;
    /**
    * winrm block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#winrm VirtualMachine#winrm}
    */
    readonly winrm?: VirtualMachineOsProfileWindowsConfigWinrm[] | cdktf.IResolvable;
}
export declare function virtualMachineOsProfileWindowsConfigToTerraform(struct?: VirtualMachineOsProfileWindowsConfigOutputReference | VirtualMachineOsProfileWindowsConfig): any;
export declare function virtualMachineOsProfileWindowsConfigToHclTerraform(struct?: VirtualMachineOsProfileWindowsConfigOutputReference | VirtualMachineOsProfileWindowsConfig): any;
export declare class VirtualMachineOsProfileWindowsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineOsProfileWindowsConfig | undefined;
    set internalValue(value: VirtualMachineOsProfileWindowsConfig | undefined);
    private _enableAutomaticUpgrades?;
    get enableAutomaticUpgrades(): boolean | cdktf.IResolvable;
    set enableAutomaticUpgrades(value: boolean | cdktf.IResolvable);
    resetEnableAutomaticUpgrades(): void;
    get enableAutomaticUpgradesInput(): boolean | cdktf.IResolvable | undefined;
    private _provisionVmAgent?;
    get provisionVmAgent(): boolean | cdktf.IResolvable;
    set provisionVmAgent(value: boolean | cdktf.IResolvable);
    resetProvisionVmAgent(): void;
    get provisionVmAgentInput(): boolean | cdktf.IResolvable | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _additionalUnattendConfig;
    get additionalUnattendConfig(): VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfigList;
    putAdditionalUnattendConfig(value: VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[] | cdktf.IResolvable): void;
    resetAdditionalUnattendConfig(): void;
    get additionalUnattendConfigInput(): cdktf.IResolvable | VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig[] | undefined;
    private _winrm;
    get winrm(): VirtualMachineOsProfileWindowsConfigWinrmList;
    putWinrm(value: VirtualMachineOsProfileWindowsConfigWinrm[] | cdktf.IResolvable): void;
    resetWinrm(): void;
    get winrmInput(): cdktf.IResolvable | VirtualMachineOsProfileWindowsConfigWinrm[] | undefined;
}
export interface VirtualMachinePlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#name VirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#product VirtualMachine#product}
    */
    readonly product: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#publisher VirtualMachine#publisher}
    */
    readonly publisher: string;
}
export declare function virtualMachinePlanToTerraform(struct?: VirtualMachinePlanOutputReference | VirtualMachinePlan): any;
export declare function virtualMachinePlanToHclTerraform(struct?: VirtualMachinePlanOutputReference | VirtualMachinePlan): any;
export declare class VirtualMachinePlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachinePlan | undefined;
    set internalValue(value: VirtualMachinePlan | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _product?;
    get product(): string;
    set product(value: string);
    get productInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
}
export interface VirtualMachineStorageDataDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#caching VirtualMachine#caching}
    */
    readonly caching?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#create_option VirtualMachine#create_option}
    */
    readonly createOption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#disk_size_gb VirtualMachine#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#lun VirtualMachine#lun}
    */
    readonly lun: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#managed_disk_id VirtualMachine#managed_disk_id}
    */
    readonly managedDiskId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#managed_disk_type VirtualMachine#managed_disk_type}
    */
    readonly managedDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#name VirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#vhd_uri VirtualMachine#vhd_uri}
    */
    readonly vhdUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#write_accelerator_enabled VirtualMachine#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function virtualMachineStorageDataDiskToTerraform(struct?: VirtualMachineStorageDataDisk | cdktf.IResolvable): any;
export declare function virtualMachineStorageDataDiskToHclTerraform(struct?: VirtualMachineStorageDataDisk | cdktf.IResolvable): any;
export declare class VirtualMachineStorageDataDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineStorageDataDisk | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineStorageDataDisk | cdktf.IResolvable | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    resetCaching(): void;
    get cachingInput(): string | undefined;
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    get createOptionInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _lun?;
    get lun(): number;
    set lun(value: number);
    get lunInput(): number | undefined;
    private _managedDiskId?;
    get managedDiskId(): string;
    set managedDiskId(value: string);
    resetManagedDiskId(): void;
    get managedDiskIdInput(): string | undefined;
    private _managedDiskType?;
    get managedDiskType(): string;
    set managedDiskType(value: string);
    resetManagedDiskType(): void;
    get managedDiskTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _vhdUri?;
    get vhdUri(): string;
    set vhdUri(value: string);
    resetVhdUri(): void;
    get vhdUriInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class VirtualMachineStorageDataDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineStorageDataDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineStorageDataDiskOutputReference;
}
export interface VirtualMachineStorageImageReference {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#id VirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#offer VirtualMachine#offer}
    */
    readonly offer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#publisher VirtualMachine#publisher}
    */
    readonly publisher?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#sku VirtualMachine#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#version VirtualMachine#version}
    */
    readonly version?: string;
}
export declare function virtualMachineStorageImageReferenceToTerraform(struct?: VirtualMachineStorageImageReferenceOutputReference | VirtualMachineStorageImageReference): any;
export declare function virtualMachineStorageImageReferenceToHclTerraform(struct?: VirtualMachineStorageImageReferenceOutputReference | VirtualMachineStorageImageReference): any;
export declare class VirtualMachineStorageImageReferenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineStorageImageReference | undefined;
    set internalValue(value: VirtualMachineStorageImageReference | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    resetOffer(): void;
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    resetPublisher(): void;
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface VirtualMachineStorageOsDisk {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#caching VirtualMachine#caching}
    */
    readonly caching?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#create_option VirtualMachine#create_option}
    */
    readonly createOption: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#disk_size_gb VirtualMachine#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#image_uri VirtualMachine#image_uri}
    */
    readonly imageUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#managed_disk_id VirtualMachine#managed_disk_id}
    */
    readonly managedDiskId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#managed_disk_type VirtualMachine#managed_disk_type}
    */
    readonly managedDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#name VirtualMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#os_type VirtualMachine#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#vhd_uri VirtualMachine#vhd_uri}
    */
    readonly vhdUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#write_accelerator_enabled VirtualMachine#write_accelerator_enabled}
    */
    readonly writeAcceleratorEnabled?: boolean | cdktf.IResolvable;
}
export declare function virtualMachineStorageOsDiskToTerraform(struct?: VirtualMachineStorageOsDiskOutputReference | VirtualMachineStorageOsDisk): any;
export declare function virtualMachineStorageOsDiskToHclTerraform(struct?: VirtualMachineStorageOsDiskOutputReference | VirtualMachineStorageOsDisk): any;
export declare class VirtualMachineStorageOsDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineStorageOsDisk | undefined;
    set internalValue(value: VirtualMachineStorageOsDisk | undefined);
    private _caching?;
    get caching(): string;
    set caching(value: string);
    resetCaching(): void;
    get cachingInput(): string | undefined;
    private _createOption?;
    get createOption(): string;
    set createOption(value: string);
    get createOptionInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _imageUri?;
    get imageUri(): string;
    set imageUri(value: string);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    private _managedDiskId?;
    get managedDiskId(): string;
    set managedDiskId(value: string);
    resetManagedDiskId(): void;
    get managedDiskIdInput(): string | undefined;
    private _managedDiskType?;
    get managedDiskType(): string;
    set managedDiskType(value: string);
    resetManagedDiskType(): void;
    get managedDiskTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _vhdUri?;
    get vhdUri(): string;
    set vhdUri(value: string);
    resetVhdUri(): void;
    get vhdUriInput(): string | undefined;
    private _writeAcceleratorEnabled?;
    get writeAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set writeAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetWriteAcceleratorEnabled(): void;
    get writeAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface VirtualMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#create VirtualMachine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#delete VirtualMachine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#read VirtualMachine#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#update VirtualMachine#update}
    */
    readonly update?: string;
}
export declare function virtualMachineTimeoutsToTerraform(struct?: VirtualMachineTimeouts | cdktf.IResolvable): any;
export declare function virtualMachineTimeoutsToHclTerraform(struct?: VirtualMachineTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine azurerm_virtual_machine}
*/
export declare class VirtualMachine extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_machine";
    /**
    * Generates CDKTF code for importing a VirtualMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachine to import
    * @param importFromId The id of the existing VirtualMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_machine azurerm_virtual_machine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineConfig);
    private _availabilitySetId?;
    get availabilitySetId(): string;
    set availabilitySetId(value: string);
    resetAvailabilitySetId(): void;
    get availabilitySetIdInput(): string | undefined;
    private _deleteDataDisksOnTermination?;
    get deleteDataDisksOnTermination(): boolean | cdktf.IResolvable;
    set deleteDataDisksOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteDataDisksOnTermination(): void;
    get deleteDataDisksOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteOsDiskOnTermination?;
    get deleteOsDiskOnTermination(): boolean | cdktf.IResolvable;
    set deleteOsDiskOnTermination(value: boolean | cdktf.IResolvable);
    resetDeleteOsDiskOnTermination(): void;
    get deleteOsDiskOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _licenseType?;
    get licenseType(): string;
    set licenseType(value: string);
    resetLicenseType(): void;
    get licenseTypeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkInterfaceIds?;
    get networkInterfaceIds(): string[];
    set networkInterfaceIds(value: string[]);
    get networkInterfaceIdsInput(): string[] | undefined;
    private _primaryNetworkInterfaceId?;
    get primaryNetworkInterfaceId(): string;
    set primaryNetworkInterfaceId(value: string);
    resetPrimaryNetworkInterfaceId(): void;
    get primaryNetworkInterfaceIdInput(): string | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _additionalCapabilities;
    get additionalCapabilities(): VirtualMachineAdditionalCapabilitiesOutputReference;
    putAdditionalCapabilities(value: VirtualMachineAdditionalCapabilities): void;
    resetAdditionalCapabilities(): void;
    get additionalCapabilitiesInput(): VirtualMachineAdditionalCapabilities | undefined;
    private _bootDiagnostics;
    get bootDiagnostics(): VirtualMachineBootDiagnosticsOutputReference;
    putBootDiagnostics(value: VirtualMachineBootDiagnostics): void;
    resetBootDiagnostics(): void;
    get bootDiagnosticsInput(): VirtualMachineBootDiagnostics | undefined;
    private _identity;
    get identity(): VirtualMachineIdentityOutputReference;
    putIdentity(value: VirtualMachineIdentity): void;
    resetIdentity(): void;
    get identityInput(): VirtualMachineIdentity | undefined;
    private _osProfile;
    get osProfile(): VirtualMachineOsProfileOutputReference;
    putOsProfile(value: VirtualMachineOsProfile): void;
    resetOsProfile(): void;
    get osProfileInput(): VirtualMachineOsProfile | undefined;
    private _osProfileLinuxConfig;
    get osProfileLinuxConfig(): VirtualMachineOsProfileLinuxConfigOutputReference;
    putOsProfileLinuxConfig(value: VirtualMachineOsProfileLinuxConfig): void;
    resetOsProfileLinuxConfig(): void;
    get osProfileLinuxConfigInput(): VirtualMachineOsProfileLinuxConfig | undefined;
    private _osProfileSecrets;
    get osProfileSecrets(): VirtualMachineOsProfileSecretsList;
    putOsProfileSecrets(value: VirtualMachineOsProfileSecrets[] | cdktf.IResolvable): void;
    resetOsProfileSecrets(): void;
    get osProfileSecretsInput(): cdktf.IResolvable | VirtualMachineOsProfileSecrets[] | undefined;
    private _osProfileWindowsConfig;
    get osProfileWindowsConfig(): VirtualMachineOsProfileWindowsConfigOutputReference;
    putOsProfileWindowsConfig(value: VirtualMachineOsProfileWindowsConfig): void;
    resetOsProfileWindowsConfig(): void;
    get osProfileWindowsConfigInput(): VirtualMachineOsProfileWindowsConfig | undefined;
    private _plan;
    get plan(): VirtualMachinePlanOutputReference;
    putPlan(value: VirtualMachinePlan): void;
    resetPlan(): void;
    get planInput(): VirtualMachinePlan | undefined;
    private _storageDataDisk;
    get storageDataDisk(): VirtualMachineStorageDataDiskList;
    putStorageDataDisk(value: VirtualMachineStorageDataDisk[] | cdktf.IResolvable): void;
    resetStorageDataDisk(): void;
    get storageDataDiskInput(): cdktf.IResolvable | VirtualMachineStorageDataDisk[] | undefined;
    private _storageImageReference;
    get storageImageReference(): VirtualMachineStorageImageReferenceOutputReference;
    putStorageImageReference(value: VirtualMachineStorageImageReference): void;
    resetStorageImageReference(): void;
    get storageImageReferenceInput(): VirtualMachineStorageImageReference | undefined;
    private _storageOsDisk;
    get storageOsDisk(): VirtualMachineStorageOsDiskOutputReference;
    putStorageOsDisk(value: VirtualMachineStorageOsDisk): void;
    get storageOsDiskInput(): VirtualMachineStorageOsDisk | undefined;
    private _timeouts;
    get timeouts(): VirtualMachineTimeoutsOutputReference;
    putTimeouts(value: VirtualMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualMachineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
