/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualWanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#allow_branch_to_branch_traffic VirtualWan#allow_branch_to_branch_traffic}
    */
    readonly allowBranchToBranchTraffic?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#disable_vpn_encryption VirtualWan#disable_vpn_encryption}
    */
    readonly disableVpnEncryption?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#id VirtualWan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#location VirtualWan#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#name VirtualWan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#office365_local_breakout_category VirtualWan#office365_local_breakout_category}
    */
    readonly office365LocalBreakoutCategory?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#resource_group_name VirtualWan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#tags VirtualWan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#type VirtualWan#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#timeouts VirtualWan#timeouts}
    */
    readonly timeouts?: VirtualWanTimeouts;
}
export interface VirtualWanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#create VirtualWan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#delete VirtualWan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#read VirtualWan#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#update VirtualWan#update}
    */
    readonly update?: string;
}
export declare function virtualWanTimeoutsToTerraform(struct?: VirtualWanTimeouts | cdktf.IResolvable): any;
export declare function virtualWanTimeoutsToHclTerraform(struct?: VirtualWanTimeouts | cdktf.IResolvable): any;
export declare class VirtualWanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualWanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualWanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan azurerm_virtual_wan}
*/
export declare class VirtualWan extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_wan";
    /**
    * Generates CDKTF code for importing a VirtualWan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualWan to import
    * @param importFromId The id of the existing VirtualWan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualWan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/virtual_wan azurerm_virtual_wan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualWanConfig
    */
    constructor(scope: Construct, id: string, config: VirtualWanConfig);
    private _allowBranchToBranchTraffic?;
    get allowBranchToBranchTraffic(): boolean | cdktf.IResolvable;
    set allowBranchToBranchTraffic(value: boolean | cdktf.IResolvable);
    resetAllowBranchToBranchTraffic(): void;
    get allowBranchToBranchTrafficInput(): boolean | cdktf.IResolvable | undefined;
    private _disableVpnEncryption?;
    get disableVpnEncryption(): boolean | cdktf.IResolvable;
    set disableVpnEncryption(value: boolean | cdktf.IResolvable);
    resetDisableVpnEncryption(): void;
    get disableVpnEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _office365LocalBreakoutCategory?;
    get office365LocalBreakoutCategory(): string;
    set office365LocalBreakoutCategory(value: string);
    resetOffice365LocalBreakoutCategory(): void;
    get office365LocalBreakoutCategoryInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): VirtualWanTimeoutsOutputReference;
    putTimeouts(value: VirtualWanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualWanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
