/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebPubsubHubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#anonymous_connections_enabled WebPubsubHub#anonymous_connections_enabled}
    */
    readonly anonymousConnectionsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#id WebPubsubHub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#name WebPubsubHub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#web_pubsub_id WebPubsubHub#web_pubsub_id}
    */
    readonly webPubsubId: string;
    /**
    * event_handler block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#event_handler WebPubsubHub#event_handler}
    */
    readonly eventHandler?: WebPubsubHubEventHandler[] | cdktf.IResolvable;
    /**
    * event_listener block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#event_listener WebPubsubHub#event_listener}
    */
    readonly eventListener?: WebPubsubHubEventListener[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#timeouts WebPubsubHub#timeouts}
    */
    readonly timeouts?: WebPubsubHubTimeouts;
}
export interface WebPubsubHubEventHandlerAuth {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#managed_identity_id WebPubsubHub#managed_identity_id}
    */
    readonly managedIdentityId: string;
}
export declare function webPubsubHubEventHandlerAuthToTerraform(struct?: WebPubsubHubEventHandlerAuthOutputReference | WebPubsubHubEventHandlerAuth): any;
export declare function webPubsubHubEventHandlerAuthToHclTerraform(struct?: WebPubsubHubEventHandlerAuthOutputReference | WebPubsubHubEventHandlerAuth): any;
export declare class WebPubsubHubEventHandlerAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubHubEventHandlerAuth | undefined;
    set internalValue(value: WebPubsubHubEventHandlerAuth | undefined);
    private _managedIdentityId?;
    get managedIdentityId(): string;
    set managedIdentityId(value: string);
    get managedIdentityIdInput(): string | undefined;
}
export interface WebPubsubHubEventHandler {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#system_events WebPubsubHub#system_events}
    */
    readonly systemEvents?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#url_template WebPubsubHub#url_template}
    */
    readonly urlTemplate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#user_event_pattern WebPubsubHub#user_event_pattern}
    */
    readonly userEventPattern?: string;
    /**
    * auth block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#auth WebPubsubHub#auth}
    */
    readonly auth?: WebPubsubHubEventHandlerAuth;
}
export declare function webPubsubHubEventHandlerToTerraform(struct?: WebPubsubHubEventHandler | cdktf.IResolvable): any;
export declare function webPubsubHubEventHandlerToHclTerraform(struct?: WebPubsubHubEventHandler | cdktf.IResolvable): any;
export declare class WebPubsubHubEventHandlerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebPubsubHubEventHandler | cdktf.IResolvable | undefined;
    set internalValue(value: WebPubsubHubEventHandler | cdktf.IResolvable | undefined);
    private _systemEvents?;
    get systemEvents(): string[];
    set systemEvents(value: string[]);
    resetSystemEvents(): void;
    get systemEventsInput(): string[] | undefined;
    private _urlTemplate?;
    get urlTemplate(): string;
    set urlTemplate(value: string);
    get urlTemplateInput(): string | undefined;
    private _userEventPattern?;
    get userEventPattern(): string;
    set userEventPattern(value: string);
    resetUserEventPattern(): void;
    get userEventPatternInput(): string | undefined;
    private _auth;
    get auth(): WebPubsubHubEventHandlerAuthOutputReference;
    putAuth(value: WebPubsubHubEventHandlerAuth): void;
    resetAuth(): void;
    get authInput(): WebPubsubHubEventHandlerAuth | undefined;
}
export declare class WebPubsubHubEventHandlerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebPubsubHubEventHandler[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebPubsubHubEventHandlerOutputReference;
}
export interface WebPubsubHubEventListener {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#eventhub_name WebPubsubHub#eventhub_name}
    */
    readonly eventhubName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#eventhub_namespace_name WebPubsubHub#eventhub_namespace_name}
    */
    readonly eventhubNamespaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#system_event_name_filter WebPubsubHub#system_event_name_filter}
    */
    readonly systemEventNameFilter?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#user_event_name_filter WebPubsubHub#user_event_name_filter}
    */
    readonly userEventNameFilter?: string[];
}
export declare function webPubsubHubEventListenerToTerraform(struct?: WebPubsubHubEventListener | cdktf.IResolvable): any;
export declare function webPubsubHubEventListenerToHclTerraform(struct?: WebPubsubHubEventListener | cdktf.IResolvable): any;
export declare class WebPubsubHubEventListenerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WebPubsubHubEventListener | cdktf.IResolvable | undefined;
    set internalValue(value: WebPubsubHubEventListener | cdktf.IResolvable | undefined);
    private _eventhubName?;
    get eventhubName(): string;
    set eventhubName(value: string);
    get eventhubNameInput(): string | undefined;
    private _eventhubNamespaceName?;
    get eventhubNamespaceName(): string;
    set eventhubNamespaceName(value: string);
    get eventhubNamespaceNameInput(): string | undefined;
    private _systemEventNameFilter?;
    get systemEventNameFilter(): string[];
    set systemEventNameFilter(value: string[]);
    resetSystemEventNameFilter(): void;
    get systemEventNameFilterInput(): string[] | undefined;
    private _userEventNameFilter?;
    get userEventNameFilter(): string[];
    set userEventNameFilter(value: string[]);
    resetUserEventNameFilter(): void;
    get userEventNameFilterInput(): string[] | undefined;
}
export declare class WebPubsubHubEventListenerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WebPubsubHubEventListener[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WebPubsubHubEventListenerOutputReference;
}
export interface WebPubsubHubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#create WebPubsubHub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#delete WebPubsubHub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#read WebPubsubHub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#update WebPubsubHub#update}
    */
    readonly update?: string;
}
export declare function webPubsubHubTimeoutsToTerraform(struct?: WebPubsubHubTimeouts | cdktf.IResolvable): any;
export declare function webPubsubHubTimeoutsToHclTerraform(struct?: WebPubsubHubTimeouts | cdktf.IResolvable): any;
export declare class WebPubsubHubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubHubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WebPubsubHubTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub azurerm_web_pubsub_hub}
*/
export declare class WebPubsubHub extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_web_pubsub_hub";
    /**
    * Generates CDKTF code for importing a WebPubsubHub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WebPubsubHub to import
    * @param importFromId The id of the existing WebPubsubHub that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WebPubsubHub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.17.0/docs/resources/web_pubsub_hub azurerm_web_pubsub_hub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebPubsubHubConfig
    */
    constructor(scope: Construct, id: string, config: WebPubsubHubConfig);
    private _anonymousConnectionsEnabled?;
    get anonymousConnectionsEnabled(): boolean | cdktf.IResolvable;
    set anonymousConnectionsEnabled(value: boolean | cdktf.IResolvable);
    resetAnonymousConnectionsEnabled(): void;
    get anonymousConnectionsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _webPubsubId?;
    get webPubsubId(): string;
    set webPubsubId(value: string);
    get webPubsubIdInput(): string | undefined;
    private _eventHandler;
    get eventHandler(): WebPubsubHubEventHandlerList;
    putEventHandler(value: WebPubsubHubEventHandler[] | cdktf.IResolvable): void;
    resetEventHandler(): void;
    get eventHandlerInput(): cdktf.IResolvable | WebPubsubHubEventHandler[] | undefined;
    private _eventListener;
    get eventListener(): WebPubsubHubEventListenerList;
    putEventListener(value: WebPubsubHubEventListener[] | cdktf.IResolvable): void;
    resetEventListener(): void;
    get eventListenerInput(): cdktf.IResolvable | WebPubsubHubEventListener[] | undefined;
    private _timeouts;
    get timeouts(): WebPubsubHubTimeoutsOutputReference;
    putTimeouts(value: WebPubsubHubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WebPubsubHubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
