# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOnPremiseVantagePointWorkerResult',
    'AwaitableGetOnPremiseVantagePointWorkerResult',
    'get_on_premise_vantage_point_worker',
    'get_on_premise_vantage_point_worker_output',
]

@pulumi.output_type
class GetOnPremiseVantagePointWorkerResult:
    """
    A collection of values returned by getOnPremiseVantagePointWorker.
    """
    def __init__(__self__, apm_domain_id=None, configuration_details=None, defined_tags=None, display_name=None, freeform_tags=None, geo_info=None, id=None, identity_infos=None, monitor_lists=None, name=None, on_premise_vantage_point_id=None, opvp_id=None, opvp_name=None, priority=None, resource_principal_token_public_key=None, runtime_id=None, status=None, time_created=None, time_last_sync_up=None, time_updated=None, version=None, version_details=None, worker_id=None, worker_type=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if configuration_details and not isinstance(configuration_details, str):
            raise TypeError("Expected argument 'configuration_details' to be a str")
        pulumi.set(__self__, "configuration_details", configuration_details)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if geo_info and not isinstance(geo_info, str):
            raise TypeError("Expected argument 'geo_info' to be a str")
        pulumi.set(__self__, "geo_info", geo_info)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity_infos and not isinstance(identity_infos, list):
            raise TypeError("Expected argument 'identity_infos' to be a list")
        pulumi.set(__self__, "identity_infos", identity_infos)
        if monitor_lists and not isinstance(monitor_lists, list):
            raise TypeError("Expected argument 'monitor_lists' to be a list")
        pulumi.set(__self__, "monitor_lists", monitor_lists)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if on_premise_vantage_point_id and not isinstance(on_premise_vantage_point_id, str):
            raise TypeError("Expected argument 'on_premise_vantage_point_id' to be a str")
        pulumi.set(__self__, "on_premise_vantage_point_id", on_premise_vantage_point_id)
        if opvp_id and not isinstance(opvp_id, str):
            raise TypeError("Expected argument 'opvp_id' to be a str")
        pulumi.set(__self__, "opvp_id", opvp_id)
        if opvp_name and not isinstance(opvp_name, str):
            raise TypeError("Expected argument 'opvp_name' to be a str")
        pulumi.set(__self__, "opvp_name", opvp_name)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if resource_principal_token_public_key and not isinstance(resource_principal_token_public_key, str):
            raise TypeError("Expected argument 'resource_principal_token_public_key' to be a str")
        pulumi.set(__self__, "resource_principal_token_public_key", resource_principal_token_public_key)
        if runtime_id and not isinstance(runtime_id, str):
            raise TypeError("Expected argument 'runtime_id' to be a str")
        pulumi.set(__self__, "runtime_id", runtime_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_sync_up and not isinstance(time_last_sync_up, str):
            raise TypeError("Expected argument 'time_last_sync_up' to be a str")
        pulumi.set(__self__, "time_last_sync_up", time_last_sync_up)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if version_details and not isinstance(version_details, list):
            raise TypeError("Expected argument 'version_details' to be a list")
        pulumi.set(__self__, "version_details", version_details)
        if worker_id and not isinstance(worker_id, str):
            raise TypeError("Expected argument 'worker_id' to be a str")
        pulumi.set(__self__, "worker_id", worker_id)
        if worker_type and not isinstance(worker_type, str):
            raise TypeError("Expected argument 'worker_type' to be a str")
        pulumi.set(__self__, "worker_type", worker_type)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> str:
        """
        Configuration details of the On-premise VP worker.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Unique name that can be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="geoInfo")
    def geo_info(self) -> str:
        """
        Geographical information of the On-premise VP worker.
        """
        return pulumi.get(self, "geo_info")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the monitor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="identityInfos")
    def identity_infos(self) -> Sequence['outputs.GetOnPremiseVantagePointWorkerIdentityInfoResult']:
        """
        Domain details of the On-premise VP worker.
        """
        return pulumi.get(self, "identity_infos")

    @property
    @pulumi.getter(name="monitorLists")
    def monitor_lists(self) -> Sequence['outputs.GetOnPremiseVantagePointWorkerMonitorListResult']:
        """
        Monitors list assigned to the On-premise VP worker.
        """
        return pulumi.get(self, "monitor_lists")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique permanent name of the On-premise VP worker. This is the same as the displayName.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onPremiseVantagePointId")
    def on_premise_vantage_point_id(self) -> str:
        return pulumi.get(self, "on_premise_vantage_point_id")

    @property
    @pulumi.getter(name="opvpId")
    def opvp_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the On-premise vantage point.
        """
        return pulumi.get(self, "opvp_id")

    @property
    @pulumi.getter(name="opvpName")
    def opvp_name(self) -> str:
        """
        On-premise vantage point name.
        """
        return pulumi.get(self, "opvp_name")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Priority of the On-premise VP worker to schedule monitors.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="resourcePrincipalTokenPublicKey")
    def resource_principal_token_public_key(self) -> str:
        return pulumi.get(self, "resource_principal_token_public_key")

    @property
    @pulumi.getter(name="runtimeId")
    def runtime_id(self) -> str:
        """
        The runtime assigned id of the On-premise VP worker.
        """
        return pulumi.get(self, "runtime_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Enables or disables the On-premise VP worker.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastSyncUp")
    def time_last_sync_up(self) -> str:
        """
        The time the resource was last synced, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_last_sync_up")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Current image version of the On-premise VP worker.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionDetails")
    def version_details(self) -> Sequence['outputs.GetOnPremiseVantagePointWorkerVersionDetailResult']:
        """
        Image version details of the On-premise VP worker.
        """
        return pulumi.get(self, "version_details")

    @property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> str:
        return pulumi.get(self, "worker_id")

    @property
    @pulumi.getter(name="workerType")
    def worker_type(self) -> str:
        """
        Type of the On-premise VP worker.
        """
        return pulumi.get(self, "worker_type")


class AwaitableGetOnPremiseVantagePointWorkerResult(GetOnPremiseVantagePointWorkerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOnPremiseVantagePointWorkerResult(
            apm_domain_id=self.apm_domain_id,
            configuration_details=self.configuration_details,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            geo_info=self.geo_info,
            id=self.id,
            identity_infos=self.identity_infos,
            monitor_lists=self.monitor_lists,
            name=self.name,
            on_premise_vantage_point_id=self.on_premise_vantage_point_id,
            opvp_id=self.opvp_id,
            opvp_name=self.opvp_name,
            priority=self.priority,
            resource_principal_token_public_key=self.resource_principal_token_public_key,
            runtime_id=self.runtime_id,
            status=self.status,
            time_created=self.time_created,
            time_last_sync_up=self.time_last_sync_up,
            time_updated=self.time_updated,
            version=self.version,
            version_details=self.version_details,
            worker_id=self.worker_id,
            worker_type=self.worker_type)


def get_on_premise_vantage_point_worker(apm_domain_id: Optional[str] = None,
                                        on_premise_vantage_point_id: Optional[str] = None,
                                        worker_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOnPremiseVantagePointWorkerResult:
    """
    This data source provides details about a specific On Premise Vantage Point Worker resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the details of the worker identified by the OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_on_premise_vantage_point_worker = oci.ApmSynthetics.get_on_premise_vantage_point_worker(apm_domain_id=test_apm_domain["id"],
        on_premise_vantage_point_id=test_on_premise_vantage_point["id"],
        worker_id=test_worker["id"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str on_premise_vantage_point_id: The OCID of the On-premise vantage point.
    :param str worker_id: The OCID of the On-premise vantage point worker.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['onPremiseVantagePointId'] = on_premise_vantage_point_id
    __args__['workerId'] = worker_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getOnPremiseVantagePointWorker:getOnPremiseVantagePointWorker', __args__, opts=opts, typ=GetOnPremiseVantagePointWorkerResult).value

    return AwaitableGetOnPremiseVantagePointWorkerResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        configuration_details=pulumi.get(__ret__, 'configuration_details'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        geo_info=pulumi.get(__ret__, 'geo_info'),
        id=pulumi.get(__ret__, 'id'),
        identity_infos=pulumi.get(__ret__, 'identity_infos'),
        monitor_lists=pulumi.get(__ret__, 'monitor_lists'),
        name=pulumi.get(__ret__, 'name'),
        on_premise_vantage_point_id=pulumi.get(__ret__, 'on_premise_vantage_point_id'),
        opvp_id=pulumi.get(__ret__, 'opvp_id'),
        opvp_name=pulumi.get(__ret__, 'opvp_name'),
        priority=pulumi.get(__ret__, 'priority'),
        resource_principal_token_public_key=pulumi.get(__ret__, 'resource_principal_token_public_key'),
        runtime_id=pulumi.get(__ret__, 'runtime_id'),
        status=pulumi.get(__ret__, 'status'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_sync_up=pulumi.get(__ret__, 'time_last_sync_up'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        version=pulumi.get(__ret__, 'version'),
        version_details=pulumi.get(__ret__, 'version_details'),
        worker_id=pulumi.get(__ret__, 'worker_id'),
        worker_type=pulumi.get(__ret__, 'worker_type'))
def get_on_premise_vantage_point_worker_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                                               on_premise_vantage_point_id: Optional[pulumi.Input[str]] = None,
                                               worker_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOnPremiseVantagePointWorkerResult]:
    """
    This data source provides details about a specific On Premise Vantage Point Worker resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the details of the worker identified by the OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_on_premise_vantage_point_worker = oci.ApmSynthetics.get_on_premise_vantage_point_worker(apm_domain_id=test_apm_domain["id"],
        on_premise_vantage_point_id=test_on_premise_vantage_point["id"],
        worker_id=test_worker["id"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str on_premise_vantage_point_id: The OCID of the On-premise vantage point.
    :param str worker_id: The OCID of the On-premise vantage point worker.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['onPremiseVantagePointId'] = on_premise_vantage_point_id
    __args__['workerId'] = worker_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApmSynthetics/getOnPremiseVantagePointWorker:getOnPremiseVantagePointWorker', __args__, opts=opts, typ=GetOnPremiseVantagePointWorkerResult)
    return __ret__.apply(lambda __response__: GetOnPremiseVantagePointWorkerResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        configuration_details=pulumi.get(__response__, 'configuration_details'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        geo_info=pulumi.get(__response__, 'geo_info'),
        id=pulumi.get(__response__, 'id'),
        identity_infos=pulumi.get(__response__, 'identity_infos'),
        monitor_lists=pulumi.get(__response__, 'monitor_lists'),
        name=pulumi.get(__response__, 'name'),
        on_premise_vantage_point_id=pulumi.get(__response__, 'on_premise_vantage_point_id'),
        opvp_id=pulumi.get(__response__, 'opvp_id'),
        opvp_name=pulumi.get(__response__, 'opvp_name'),
        priority=pulumi.get(__response__, 'priority'),
        resource_principal_token_public_key=pulumi.get(__response__, 'resource_principal_token_public_key'),
        runtime_id=pulumi.get(__response__, 'runtime_id'),
        status=pulumi.get(__response__, 'status'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_last_sync_up=pulumi.get(__response__, 'time_last_sync_up'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        version=pulumi.get(__response__, 'version'),
        version_details=pulumi.get(__response__, 'version_details'),
        worker_id=pulumi.get(__response__, 'worker_id'),
        worker_type=pulumi.get(__response__, 'worker_type')))
