# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetRepositoriesResult',
    'AwaitableGetRepositoriesResult',
    'get_repositories',
    'get_repositories_output',
]

@pulumi.output_type
class GetRepositoriesResult:
    """
    A collection of values returned by getRepositories.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, is_immutable=None, repository_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_immutable and not isinstance(is_immutable, bool):
            raise TypeError("Expected argument 'is_immutable' to be a bool")
        pulumi.set(__self__, "is_immutable", is_immutable)
        if repository_collections and not isinstance(repository_collections, list):
            raise TypeError("Expected argument 'repository_collections' to be a list")
        pulumi.set(__self__, "repository_collections", repository_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the repository's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The repository name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRepositoriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the repository.  Example: `ocid1.artifactrepository.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isImmutable")
    def is_immutable(self) -> Optional[bool]:
        """
        Whether the repository is immutable. The artifacts of an immutable repository cannot be overwritten.
        """
        return pulumi.get(self, "is_immutable")

    @property
    @pulumi.getter(name="repositoryCollections")
    def repository_collections(self) -> Sequence['outputs.GetRepositoriesRepositoryCollectionResult']:
        """
        The list of repository_collection.
        """
        return pulumi.get(self, "repository_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the repository.
        """
        return pulumi.get(self, "state")


class AwaitableGetRepositoriesResult(GetRepositoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoriesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_immutable=self.is_immutable,
            repository_collections=self.repository_collections,
            state=self.state)


def get_repositories(compartment_id: Optional[str] = None,
                     display_name: Optional[str] = None,
                     filters: Optional[Sequence[Union['GetRepositoriesFilterArgs', 'GetRepositoriesFilterArgsDict']]] = None,
                     id: Optional[str] = None,
                     is_immutable: Optional[bool] = None,
                     state: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoriesResult:
    """
    This data source provides the list of Repositories in Oracle Cloud Infrastructure Artifacts service.

    Lists repositories in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repositories = oci.Artifacts.get_repositories(compartment_id=compartment_id,
        display_name=repository_display_name,
        id=repository_id,
        is_immutable=repository_is_immutable,
        state=repository_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str id: A filter to return the resources for the specified OCID.
    :param bool is_immutable: A filter to return resources that match the isImmutable value.
    :param str state: A filter to return only resources that match the given lifecycle state name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isImmutable'] = is_immutable
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Artifacts/getRepositories:getRepositories', __args__, opts=opts, typ=GetRepositoriesResult).value

    return AwaitableGetRepositoriesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_immutable=pulumi.get(__ret__, 'is_immutable'),
        repository_collections=pulumi.get(__ret__, 'repository_collections'),
        state=pulumi.get(__ret__, 'state'))
def get_repositories_output(compartment_id: Optional[pulumi.Input[str]] = None,
                            display_name: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetRepositoriesFilterArgs', 'GetRepositoriesFilterArgsDict']]]]] = None,
                            id: Optional[pulumi.Input[Optional[str]]] = None,
                            is_immutable: Optional[pulumi.Input[Optional[bool]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoriesResult]:
    """
    This data source provides the list of Repositories in Oracle Cloud Infrastructure Artifacts service.

    Lists repositories in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repositories = oci.Artifacts.get_repositories(compartment_id=compartment_id,
        display_name=repository_display_name,
        id=repository_id,
        is_immutable=repository_is_immutable,
        state=repository_state)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str id: A filter to return the resources for the specified OCID.
    :param bool is_immutable: A filter to return resources that match the isImmutable value.
    :param str state: A filter to return only resources that match the given lifecycle state name exactly.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isImmutable'] = is_immutable
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Artifacts/getRepositories:getRepositories', __args__, opts=opts, typ=GetRepositoriesResult)
    return __ret__.apply(lambda __response__: GetRepositoriesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        is_immutable=pulumi.get(__response__, 'is_immutable'),
        repository_collections=pulumi.get(__response__, 'repository_collections'),
        state=pulumi.get(__response__, 'state')))
