# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkspacesResult',
    'AwaitableGetWorkspacesResult',
    'get_workspaces',
    'get_workspaces_output',
]

@pulumi.output_type
class GetWorkspacesResult:
    """
    A collection of values returned by getWorkspaces.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, workspaces=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if workspaces and not isinstance(workspaces, list):
            raise TypeError("Expected argument 'workspaces' to be a list")
        pulumi.set(__self__, "workspaces", workspaces)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the workspace.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWorkspacesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Lifecycle states for workspaces in Data Integration Service CREATING - The resource is being created and may not be usable until the entire metadata is defined UPDATING - The resource is being updated and may not be usable until all changes are commited DELETING - The resource is being deleted and might require deep cleanup of children. ACTIVE   - The resource is valid and available for access INACTIVE - The resource might be incomplete in its definition or might have been made unavailable for administrative reasons DELETED  - The resource has been deleted and isn't available FAILED   - The resource is in a failed state due to validation or other errors STARTING - The resource is being started and may not be usable until becomes ACTIVE again STOPPING - The resource is in the process of Stopping and may not be usable until it Stops or fails STOPPED  - The resource is in Stopped state due to stop operation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def workspaces(self) -> Sequence['outputs.GetWorkspacesWorkspaceResult']:
        """
        The list of workspaces.
        """
        return pulumi.get(self, "workspaces")


class AwaitableGetWorkspacesResult(GetWorkspacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspacesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            workspaces=self.workspaces)


def get_workspaces(compartment_id: Optional[str] = None,
                   filters: Optional[Sequence[Union['GetWorkspacesFilterArgs', 'GetWorkspacesFilterArgsDict']]] = None,
                   name: Optional[str] = None,
                   state: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspacesResult:
    """
    This data source provides the list of Workspaces in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a list of Data Integration workspaces.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspaces = oci.DataIntegration.get_workspaces(compartment_id=compartment_id,
        name=workspace_name,
        state=workspace_state)
    ```


    :param str compartment_id: The OCID of the compartment containing the resources you want to list.
    :param str name: Used to filter by the name of the object.
    :param str state: The lifecycle state of a resource. When specified, the operation only returns resources that match the given lifecycle state. When not specified, all lifecycle states are processed as a match.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaces:getWorkspaces', __args__, opts=opts, typ=GetWorkspacesResult).value

    return AwaitableGetWorkspacesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        workspaces=pulumi.get(__ret__, 'workspaces'))
def get_workspaces_output(compartment_id: Optional[pulumi.Input[str]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkspacesFilterArgs', 'GetWorkspacesFilterArgsDict']]]]] = None,
                          name: Optional[pulumi.Input[Optional[str]]] = None,
                          state: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspacesResult]:
    """
    This data source provides the list of Workspaces in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a list of Data Integration workspaces.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspaces = oci.DataIntegration.get_workspaces(compartment_id=compartment_id,
        name=workspace_name,
        state=workspace_state)
    ```


    :param str compartment_id: The OCID of the compartment containing the resources you want to list.
    :param str name: Used to filter by the name of the object.
    :param str state: The lifecycle state of a resource. When specified, the operation only returns resources that match the given lifecycle state. When not specified, all lifecycle states are processed as a match.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataIntegration/getWorkspaces:getWorkspaces', __args__, opts=opts, typ=GetWorkspacesResult)
    return __ret__.apply(lambda __response__: GetWorkspacesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        workspaces=pulumi.get(__response__, 'workspaces')))
