# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRepositoryResult',
    'AwaitableGetRepositoryResult',
    'get_repository',
    'get_repository_output',
]

@pulumi.output_type
class GetRepositoryResult:
    """
    A collection of values returned by getRepository.
    """
    def __init__(__self__, branch_count=None, commit_count=None, compartment_id=None, default_branch=None, defined_tags=None, description=None, fields=None, freeform_tags=None, http_url=None, id=None, lifecyle_details=None, mirror_repository_configs=None, name=None, namespace=None, parent_repository_id=None, project_id=None, project_name=None, repository_id=None, repository_type=None, size_in_bytes=None, ssh_url=None, state=None, system_tags=None, time_created=None, time_updated=None, trigger_build_events=None):
        if branch_count and not isinstance(branch_count, int):
            raise TypeError("Expected argument 'branch_count' to be a int")
        pulumi.set(__self__, "branch_count", branch_count)
        if commit_count and not isinstance(commit_count, int):
            raise TypeError("Expected argument 'commit_count' to be a int")
        pulumi.set(__self__, "commit_count", commit_count)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if default_branch and not isinstance(default_branch, str):
            raise TypeError("Expected argument 'default_branch' to be a str")
        pulumi.set(__self__, "default_branch", default_branch)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if http_url and not isinstance(http_url, str):
            raise TypeError("Expected argument 'http_url' to be a str")
        pulumi.set(__self__, "http_url", http_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecyle_details and not isinstance(lifecyle_details, str):
            raise TypeError("Expected argument 'lifecyle_details' to be a str")
        pulumi.set(__self__, "lifecyle_details", lifecyle_details)
        if mirror_repository_configs and not isinstance(mirror_repository_configs, list):
            raise TypeError("Expected argument 'mirror_repository_configs' to be a list")
        pulumi.set(__self__, "mirror_repository_configs", mirror_repository_configs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if parent_repository_id and not isinstance(parent_repository_id, str):
            raise TypeError("Expected argument 'parent_repository_id' to be a str")
        pulumi.set(__self__, "parent_repository_id", parent_repository_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if repository_type and not isinstance(repository_type, str):
            raise TypeError("Expected argument 'repository_type' to be a str")
        pulumi.set(__self__, "repository_type", repository_type)
        if size_in_bytes and not isinstance(size_in_bytes, str):
            raise TypeError("Expected argument 'size_in_bytes' to be a str")
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if ssh_url and not isinstance(ssh_url, str):
            raise TypeError("Expected argument 'ssh_url' to be a str")
        pulumi.set(__self__, "ssh_url", ssh_url)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if trigger_build_events and not isinstance(trigger_build_events, list):
            raise TypeError("Expected argument 'trigger_build_events' to be a list")
        pulumi.set(__self__, "trigger_build_events", trigger_build_events)

    @property
    @pulumi.getter(name="branchCount")
    def branch_count(self) -> int:
        """
        The count of the branches present in the repository.
        """
        return pulumi.get(self, "branch_count")

    @property
    @pulumi.getter(name="commitCount")
    def commit_count(self) -> int:
        """
        The count of the commits present in the repository.
        """
        return pulumi.get(self, "commit_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the repository's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        """
        The default branch of the repository.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Details of the repository. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> str:
        """
        HTTP URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "http_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the repository. This value is unique and immutable.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecyleDetails")
    def lifecyle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecyle_details")

    @property
    @pulumi.getter(name="mirrorRepositoryConfigs")
    def mirror_repository_configs(self) -> Sequence['outputs.GetRepositoryMirrorRepositoryConfigResult']:
        """
        Configuration information for mirroring the repository.
        """
        return pulumi.get(self, "mirror_repository_configs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the repository. Should be unique within the project. This value is mutable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Tenancy unique namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="parentRepositoryId")
    def parent_repository_id(self) -> str:
        """
        The OCID of the parent repository.
        """
        return pulumi.get(self, "parent_repository_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The OCID of the DevOps project containing the repository.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        Unique project name in a namespace.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> str:
        """
        Type of repository: MIRRORED - Repository created by mirroring an existing repository. HOSTED - Repository created and hosted using Oracle Cloud Infrastructure DevOps code repository. FORKED - Repository created by forking an existing repository.
        """
        return pulumi.get(self, "repository_type")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        """
        The size of the repository in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="sshUrl")
    def ssh_url(self) -> str:
        """
        SSH URL that you use to git clone, pull and push.
        """
        return pulumi.get(self, "ssh_url")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the repository.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the repository was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the repository was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="triggerBuildEvents")
    def trigger_build_events(self) -> Sequence[str]:
        """
        Trigger build events supported for this repository: PUSH - Build is triggered when a push event occurs. PULL_REQUEST_CREATED - Build is triggered when a pull request is created in the repository. PULL_REQUEST_UPDATED - Build is triggered when a push is made to a branch with an open pull request. COMMIT_UPDATES - Build is triggered when new commits are mirrored into a repository.
        """
        return pulumi.get(self, "trigger_build_events")


class AwaitableGetRepositoryResult(GetRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryResult(
            branch_count=self.branch_count,
            commit_count=self.commit_count,
            compartment_id=self.compartment_id,
            default_branch=self.default_branch,
            defined_tags=self.defined_tags,
            description=self.description,
            fields=self.fields,
            freeform_tags=self.freeform_tags,
            http_url=self.http_url,
            id=self.id,
            lifecyle_details=self.lifecyle_details,
            mirror_repository_configs=self.mirror_repository_configs,
            name=self.name,
            namespace=self.namespace,
            parent_repository_id=self.parent_repository_id,
            project_id=self.project_id,
            project_name=self.project_name,
            repository_id=self.repository_id,
            repository_type=self.repository_type,
            size_in_bytes=self.size_in_bytes,
            ssh_url=self.ssh_url,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            trigger_build_events=self.trigger_build_events)


def get_repository(fields: Optional[Sequence[str]] = None,
                   repository_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryResult:
    """
    This data source provides details about a specific Repository resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a repository by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository = oci.DevOps.get_repository(repository_id=test_repository_oci_devops_repository["id"],
        fields=repository_fields)
    ```


    :param Sequence[str] fields: Fields parameter can contain multiple flags useful in deciding the API functionality.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['fields'] = fields
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult).value

    return AwaitableGetRepositoryResult(
        branch_count=pulumi.get(__ret__, 'branch_count'),
        commit_count=pulumi.get(__ret__, 'commit_count'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        default_branch=pulumi.get(__ret__, 'default_branch'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        fields=pulumi.get(__ret__, 'fields'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        http_url=pulumi.get(__ret__, 'http_url'),
        id=pulumi.get(__ret__, 'id'),
        lifecyle_details=pulumi.get(__ret__, 'lifecyle_details'),
        mirror_repository_configs=pulumi.get(__ret__, 'mirror_repository_configs'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        parent_repository_id=pulumi.get(__ret__, 'parent_repository_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        project_name=pulumi.get(__ret__, 'project_name'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        repository_type=pulumi.get(__ret__, 'repository_type'),
        size_in_bytes=pulumi.get(__ret__, 'size_in_bytes'),
        ssh_url=pulumi.get(__ret__, 'ssh_url'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        trigger_build_events=pulumi.get(__ret__, 'trigger_build_events'))
def get_repository_output(fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          repository_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryResult]:
    """
    This data source provides details about a specific Repository resource in Oracle Cloud Infrastructure Devops service.

    Retrieves a repository by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository = oci.DevOps.get_repository(repository_id=test_repository_oci_devops_repository["id"],
        fields=repository_fields)
    ```


    :param Sequence[str] fields: Fields parameter can contain multiple flags useful in deciding the API functionality.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['fields'] = fields
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DevOps/getRepository:getRepository', __args__, opts=opts, typ=GetRepositoryResult)
    return __ret__.apply(lambda __response__: GetRepositoryResult(
        branch_count=pulumi.get(__response__, 'branch_count'),
        commit_count=pulumi.get(__response__, 'commit_count'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        default_branch=pulumi.get(__response__, 'default_branch'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        fields=pulumi.get(__response__, 'fields'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        http_url=pulumi.get(__response__, 'http_url'),
        id=pulumi.get(__response__, 'id'),
        lifecyle_details=pulumi.get(__response__, 'lifecyle_details'),
        mirror_repository_configs=pulumi.get(__response__, 'mirror_repository_configs'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        parent_repository_id=pulumi.get(__response__, 'parent_repository_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        project_name=pulumi.get(__response__, 'project_name'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        repository_type=pulumi.get(__response__, 'repository_type'),
        size_in_bytes=pulumi.get(__response__, 'size_in_bytes'),
        ssh_url=pulumi.get(__response__, 'ssh_url'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        trigger_build_events=pulumi.get(__response__, 'trigger_build_events')))
