# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTagDefaultResult',
    'AwaitableGetTagDefaultResult',
    'get_tag_default',
    'get_tag_default_output',
]

@pulumi.output_type
class GetTagDefaultResult:
    """
    A collection of values returned by getTagDefault.
    """
    def __init__(__self__, compartment_id=None, id=None, is_required=None, state=None, tag_default_id=None, tag_definition_id=None, tag_definition_name=None, tag_namespace_id=None, time_created=None, value=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_required and not isinstance(is_required, bool):
            raise TypeError("Expected argument 'is_required' to be a bool")
        pulumi.set(__self__, "is_required", is_required)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tag_default_id and not isinstance(tag_default_id, str):
            raise TypeError("Expected argument 'tag_default_id' to be a str")
        pulumi.set(__self__, "tag_default_id", tag_default_id)
        if tag_definition_id and not isinstance(tag_definition_id, str):
            raise TypeError("Expected argument 'tag_definition_id' to be a str")
        pulumi.set(__self__, "tag_definition_id", tag_definition_id)
        if tag_definition_name and not isinstance(tag_definition_name, str):
            raise TypeError("Expected argument 'tag_definition_name' to be a str")
        pulumi.set(__self__, "tag_definition_name", tag_definition_name)
        if tag_namespace_id and not isinstance(tag_namespace_id, str):
            raise TypeError("Expected argument 'tag_namespace_id' to be a str")
        pulumi.set(__self__, "tag_namespace_id", tag_namespace_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment. The tag default applies to all new resources that get created in the compartment. Resources that existed before the tag default was created are not tagged.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the tag default.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> bool:
        """
        If you specify that a value is required, a value is set during resource creation (either by the user creating the resource or another tag defualt). If no value is set, resource creation is blocked.
        * If the `isRequired` flag is set to "true", the value is set during resource creation.
        * If the `isRequired` flag is set to "false", the value you enter is set during resource creation.
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The tag default's current state. After creating a `TagDefault`, make sure its `lifecycleState` is ACTIVE before using it.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tagDefaultId")
    def tag_default_id(self) -> str:
        return pulumi.get(self, "tag_default_id")

    @property
    @pulumi.getter(name="tagDefinitionId")
    def tag_definition_id(self) -> str:
        """
        The OCID of the tag definition. The tag default will always assign a default value for this tag definition.
        """
        return pulumi.get(self, "tag_definition_id")

    @property
    @pulumi.getter(name="tagDefinitionName")
    def tag_definition_name(self) -> str:
        """
        The name used in the tag definition. This field is informational in the context of the tag default.
        """
        return pulumi.get(self, "tag_definition_name")

    @property
    @pulumi.getter(name="tagNamespaceId")
    def tag_namespace_id(self) -> str:
        """
        The OCID of the tag namespace that contains the tag definition.
        """
        return pulumi.get(self, "tag_namespace_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the `TagDefault` object was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The default value for the tag definition. This will be applied to all new resources created in the compartment.
        """
        return pulumi.get(self, "value")


class AwaitableGetTagDefaultResult(GetTagDefaultResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTagDefaultResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_required=self.is_required,
            state=self.state,
            tag_default_id=self.tag_default_id,
            tag_definition_id=self.tag_definition_id,
            tag_definition_name=self.tag_definition_name,
            tag_namespace_id=self.tag_namespace_id,
            time_created=self.time_created,
            value=self.value)


def get_tag_default(tag_default_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTagDefaultResult:
    """
    This data source provides details about a specific Tag Default resource in Oracle Cloud Infrastructure Identity service.

    Retrieves the specified tag default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag_default = oci.Identity.get_tag_default(tag_default_id=test_tag_default_oci_identity_tag_default["id"])
    ```


    :param str tag_default_id: The OCID of the tag default.
    """
    __args__ = dict()
    __args__['tagDefaultId'] = tag_default_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getTagDefault:getTagDefault', __args__, opts=opts, typ=GetTagDefaultResult).value

    return AwaitableGetTagDefaultResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_required=pulumi.get(__ret__, 'is_required'),
        state=pulumi.get(__ret__, 'state'),
        tag_default_id=pulumi.get(__ret__, 'tag_default_id'),
        tag_definition_id=pulumi.get(__ret__, 'tag_definition_id'),
        tag_definition_name=pulumi.get(__ret__, 'tag_definition_name'),
        tag_namespace_id=pulumi.get(__ret__, 'tag_namespace_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        value=pulumi.get(__ret__, 'value'))
def get_tag_default_output(tag_default_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTagDefaultResult]:
    """
    This data source provides details about a specific Tag Default resource in Oracle Cloud Infrastructure Identity service.

    Retrieves the specified tag default.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tag_default = oci.Identity.get_tag_default(tag_default_id=test_tag_default_oci_identity_tag_default["id"])
    ```


    :param str tag_default_id: The OCID of the tag default.
    """
    __args__ = dict()
    __args__['tagDefaultId'] = tag_default_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getTagDefault:getTagDefault', __args__, opts=opts, typ=GetTagDefaultResult)
    return __ret__.apply(lambda __response__: GetTagDefaultResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        is_required=pulumi.get(__response__, 'is_required'),
        state=pulumi.get(__response__, 'state'),
        tag_default_id=pulumi.get(__response__, 'tag_default_id'),
        tag_definition_id=pulumi.get(__response__, 'tag_definition_id'),
        tag_definition_name=pulumi.get(__response__, 'tag_definition_name'),
        tag_namespace_id=pulumi.get(__response__, 'tag_namespace_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        value=pulumi.get(__response__, 'value')))
