# This is an automatically generated R code. Don't edit.
# Generated by 
# /home/sokol/.local/bin/ftbl2optR.py --tblimit 0 --ropts "TIMEIT=TRUE" e_coli.ftbl
# at Tue Apr  7 16:38:19 2020.

# Copyright 2011-2020, INRAE, France.

# working dir
dirw="/home/sokol/gbarec_home/insa/sysbio/dev/ftbl2sys/influx_si/test/ok"

# installation dir (where influx_si/R/*.R live)
dirr="/home/sokol/.local/lib/python3.7/site-packages/influx_si/R"
# short base name of the FTBL (withount '.ftbl')
baseshort="e_coli"

fcerr=file(file.path(dirw, sprintf("%s.err", baseshort)), "ab")
fclog=file(file.path(dirw, sprintf("%s.log", baseshort)), "ab")

options(warn=1)
options(digits.secs=2)

case_i=F

if (length(find("bitwAnd"))==0L) {
   suppressPackageStartupMessages(library(bitops))
   bitwAnd=bitAnd
}
source(file.path(dirr, "libs.R"))

# define matprod for simple_triplet_matrix
`%stm%` = slam::matprod_simple_triplet_matrix

# default options
version=FALSE
noopt=FALSE
noscale=FALSE
meth="nlsic"
fullsys=FALSE
emu=FALSE
irand=FALSE
sens=""
cupx=0.999
cupn=1.e3
cupp=1.e5
clownr=0
cinout=0
clowp=1.e-8
np=0
ln=FALSE
tikhreg=FALSE
sln=FALSE
lim=FALSE
zc=-.Machine$double.xmax
ffguess=FALSE
fdfit=FALSE
addnoise=FALSE
fseries=""
iseries=""
seed=-.Machine$integer.max
excl_outliers=FALSE
TIMEIT=FALSE
prof=FALSE
time_order="1"

# get runtime arguments
TIMEIT=TRUE

# synonymous
myver=version
optimize=!noopt
method=meth
sensitive=sens
least_norm=ln
initrand=irand

vernum="5.1.0"

# sanity check for command line parameters
if (substring(sensitive, 1, 3)=="mc=") {
   # read the mc iteration number
   nmc=as.integer(substring(sensitive, 4))
   sensitive="mc"
} else if (sensitive=="mc") {
   nmc=10
}
# cupx==0 means no upper limit => cupx=1
cupx=ifelse(cupx, cupx, 1)
if (cupx < 0 || cupx > 1) {
   stop_mes(paste("Option '--cupx N' must have N in the interval [0,1]
",
      "Instead, the value ", cupx, " si given.", sep=""), file=fcerr)
}
if (cinout < 0) {
   stop_mes(paste("Option '--cinout N' must have N non negative
",
      "Instead, the value ", cinout, " is given.", sep=""), file=fcerr)
}
# minimization method
validmethods=list("BFGS", "Nelder-Mead", "SANN", "ipopt", "nlsic")
if (! method %in% validmethods) {
   cat(paste("Wraning: method", method, "is not known. 'nlsic' is used instead."), "\n", sep="", file=fcerr)
   method="nlsic"
}
if (method == "ipopt") {
   installed=suppressPackageStartupMessages(library(ipoptr, logical.return=T))
   if (!installed) {
      stop_mes("An optimization method ipopt is requested but available in this R installation", file=fcerr)
   }
}
if (least_norm && sln) {
   stop_mes("Options --ln and --sln cannot be activated simultaniously.", file=fcerr)
}

avaco=try(detectCores(), silent=T)
if (inherits(avaco, "try-error")) {
   avaco=NULL
}
if (np > 0L && np < 1L) {
   np=round(avaco*np)
} else if (np >= 1L) {
   np=round(np)
} else {
   np=avaco
}
if (is.null(np) || np <= 0L) {
   np=1L
}
if (sensitive=="mc") {
   np=min(np, nmc)
}
options(mc.cores=np)

if (least_norm+tikhreg+lim > 1) {
   stop_mes("Options --ln, --lim and --tikhreg cannot be activated simultaneously. Use only one of them at a time.", file=fcerr)
}
lsi_fun=lsi
if (least_norm || sln) {
   lsi_fun=lsi_ln
} else if (tikhreg) {
   lsi_fun=lsi_reg
} else if (lim) {
   suppressPackageStartupMessages(library(limSolve));
   lsi_fun=lsi_lim
}
if (zc==-.Machine$double.xmax) {
   # no zero scrossing to apply
   zerocross=F
} else {
   if (zc < 0.) {
      stop_mes(paste("Zero crossing value ZC must be non negative, instead ", zc, " is given.", sep=""), file=fcerr)
   }
   zerocross=T
}
if (seed==-.Machine$integer.max) {
   # no seed to apply
   set_seed=F
} else {
   set_seed=T
   set.seed(seed)
}
time_order=gsub("\\s", "", time_order) # remove spaces if any
if (!(time_order %in% c("1", "2", "1,2"))) {
   stop_mes(sprintf("time_order must be '1', '2' or '1,2'. Instead got '%s'"))
}
opts=commandArgs()
# end command line argument proceeding

# get some cumomer tools
source(file.path(dirr, "opt_cumo_tools.R"))
#loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))

lab_resid=cumo_resid
lab_sim=param2fl_x
jx_f=new.env()

if (TIMEIT) {
   cat("rinit   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# R profiling
if (prof) {
   Rprof(sprintf("%s.Rprof", baseshort))
}

nm_list=list()
nb_f=list()

if (TIMEIT) {
   cat("r_flux  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# fwd-rev flux names
nm_fwrv=c("fwd.Glucupt_1", "fwd.Glucupt_U", "fwd.akgdh", "fwd.ald", "fwd.bs_DHAP", "fwd.bs_accoa", "fwd.bs_accoa_aux", "fwd.bs_akg", "fwd.bs_akg1", "fwd.bs_akg2", "fwd.bs_akg3", "fwd.bs_akg4", "fwd.bs_akg4_aux", "fwd.bs_e4p", "fwd.bs_fru6P", "fwd.bs_glc6P", "fwd.bs_oaa", "fwd.bs_oaa1", "fwd.bs_oaa1_aux", "fwd.bs_oaa2", "fwd.bs_oaa2_aux", "fwd.bs_oaa3_aux", "fwd.bs_oaa3a", "fwd.bs_oaa3b", "fwd.bs_oaa4", "fwd.bs_oaa5", "fwd.bs_oaa5_aux", "fwd.bs_oaa6", "fwd.bs_oaa6_aux", "fwd.bs_oaa7", "fwd.bs_oaa7_aux", "fwd.bs_pep", "fwd.bs_pep1", "fwd.bs_pep2", "fwd.bs_pep3_aux", "fwd.bs_pep3a", "fwd.bs_pep3b", "fwd.bs_pep4_aux", "fwd.bs_pep4a", "fwd.bs_pep4b", "fwd.bs_pep5", "fwd.bs_pep6", "fwd.bs_pep6_aux", "fwd.bs_pep7", "fwd.bs_pga", "fwd.bs_pga1", "fwd.bs_pga1_aux", "fwd.bs_pga2", "fwd.bs_pga2_aux", "fwd.bs_pga3", "fwd.bs_pga3_aux", "fwd.bs_pga_aux", "fwd.bs_pyr", "fwd.bs_pyr1", "fwd.bs_pyr1_aux", "fwd.bs_pyr2", "fwd.bs_pyr3", "fwd.bs_pyr3_aux", "fwd.bs_pyr4", "fwd.bs_pyr4_aux", "fwd.bs_rib5p", "fwd.bs_rib5p1", "fwd.bs_rib5p1_aux", "fwd.bs_rib5p2", "fwd.citsynth", "fwd.edd", "fwd.eno", "fwd.fum_a", "fwd.fum_b", "fwd.gnd", "fwd.idh", "fwd.mae", "fwd.maldh", "fwd.out_Ac", "fwd.out_FTHF", "fwd.out_co2", "fwd.pdh", "fwd.pfk", "fwd.pgi", "fwd.pgk", "fwd.ppc", "fwd.pyk", "fwd.ta", "fwd.tk1", "fwd.tk2", "fwd.zwf", "rev.Glucupt_1", "rev.Glucupt_U", "rev.akgdh", "rev.ald", "rev.bs_DHAP", "rev.bs_accoa", "rev.bs_accoa_aux", "rev.bs_akg", "rev.bs_akg1", "rev.bs_akg2", "rev.bs_akg3", "rev.bs_akg4", "rev.bs_akg4_aux", "rev.bs_e4p", "rev.bs_fru6P", "rev.bs_glc6P", "rev.bs_oaa", "rev.bs_oaa1", "rev.bs_oaa1_aux", "rev.bs_oaa2", "rev.bs_oaa2_aux", "rev.bs_oaa3_aux", "rev.bs_oaa3a", "rev.bs_oaa3b", "rev.bs_oaa4", "rev.bs_oaa5", "rev.bs_oaa5_aux", "rev.bs_oaa6", "rev.bs_oaa6_aux", "rev.bs_oaa7", "rev.bs_oaa7_aux", "rev.bs_pep", "rev.bs_pep1", "rev.bs_pep2", "rev.bs_pep3_aux", "rev.bs_pep3a", "rev.bs_pep3b", "rev.bs_pep4_aux", "rev.bs_pep4a", "rev.bs_pep4b", "rev.bs_pep5", "rev.bs_pep6", "rev.bs_pep6_aux", "rev.bs_pep7", "rev.bs_pga", "rev.bs_pga1", "rev.bs_pga1_aux", "rev.bs_pga2", "rev.bs_pga2_aux", "rev.bs_pga3", "rev.bs_pga3_aux", "rev.bs_pga_aux", "rev.bs_pyr", "rev.bs_pyr1", "rev.bs_pyr1_aux", "rev.bs_pyr2", "rev.bs_pyr3", "rev.bs_pyr3_aux", "rev.bs_pyr4", "rev.bs_pyr4_aux", "rev.bs_rib5p", "rev.bs_rib5p1", "rev.bs_rib5p1_aux", "rev.bs_rib5p2", "rev.citsynth", "rev.edd", "rev.eno", "rev.fum_a", "rev.fum_b", "rev.gnd", "rev.idh", "rev.mae", "rev.maldh", "rev.out_Ac", "rev.out_FTHF", "rev.out_co2", "rev.pdh", "rev.pfk", "rev.pgi", "rev.pgk", "rev.ppc", "rev.pyk", "rev.ta", "rev.tk1", "rev.tk2", "rev.zwf")

# edge to netflux name translator
edge2fl=c("f.n.Glucupt_1", "d.n.Glucupt_U", "d.n.pgi", "d.n.pfk", "d.n.ald", "d.n.ald", "d.n.ald", "d.n.pgk", "d.n.eno", "f.n.pyk", "f.n.zwf", "f.n.gnd", "f.n.gnd", "f.n.gnd", "d.n.edd", "d.n.edd", "d.n.edd", "d.n.ta", "d.n.ta", "d.n.ta", "d.n.ta", "d.n.tk1", "d.n.tk1", "d.n.tk1", "d.n.tk1", "d.n.tk2", "d.n.tk2", "d.n.tk2", "d.n.tk2", "d.n.pdh", "d.n.pdh", "d.n.pdh", "d.n.citsynth", "d.n.citsynth", "d.n.citsynth", "d.n.idh", "d.n.idh", "d.n.idh", "d.n.akgdh", "d.n.akgdh", "d.n.akgdh", "d.n.fum_a", "d.n.fum_b", "d.n.maldh", "d.n.ppc", "d.n.ppc", "d.n.ppc", "d.n.mae", "d.n.mae", "d.n.mae", "c.n.bs_glc6P", "c.n.bs_fru6P", "c.n.bs_pga", "d.n.bs_pga_aux", "d.n.bs_pga1", "c.n.bs_pga1_aux", "d.n.bs_pga2", "c.n.bs_pga2_aux", "d.n.bs_pga3", "d.n.bs_pga3", "d.n.bs_pga3", "c.n.bs_pga3_aux", "c.n.bs_DHAP", "c.n.bs_pyr", "d.n.bs_pyr1", "d.n.bs_pyr1_aux", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr4", "c.n.bs_pyr4_aux", "d.n.bs_pyr3", "d.n.bs_pyr3", "d.n.bs_pyr3", "d.n.bs_pyr3", "c.n.bs_pyr3_aux", "d.n.bs_e4p", "c.n.bs_rib5p", "d.n.bs_rib5p1", "d.n.bs_rib5p1", "d.n.bs_rib5p1", "c.n.bs_rib5p1_aux", "d.n.bs_rib5p2", "c.n.bs_pep", "d.n.bs_pep1", "d.n.bs_pep1", "d.n.bs_pep1", "d.n.bs_pep2", "d.n.bs_pep2", "d.n.bs_pep2", "d.n.bs_pep3a", "d.n.bs_pep3a", "d.n.bs_pep3a", "d.n.bs_pep3b", "d.n.bs_pep3b", "d.n.bs_pep3b", "c.n.bs_pep3_aux", "d.n.bs_pep4a", "d.n.bs_pep4a", "d.n.bs_pep4a", "d.n.bs_pep4b", "d.n.bs_pep4b", "d.n.bs_pep4b", "c.n.bs_pep4_aux", "c.n.bs_pep5", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6_aux", "d.n.bs_pep7", "d.n.bs_pep7", "d.n.bs_pep7", "c.n.bs_accoa", "d.n.bs_accoa_aux", "c.n.bs_akg", "d.n.bs_akg1", "c.n.bs_akg2", "c.n.bs_akg3", "d.n.bs_akg4", "d.n.bs_akg4", "d.n.bs_akg4", "d.n.bs_akg4_aux", "c.n.bs_oaa", "d.n.bs_oaa1", "c.n.bs_oaa1_aux", "d.n.bs_oaa2", "d.n.bs_oaa2", "d.n.bs_oaa2", "d.n.bs_oaa2", "c.n.bs_oaa2_aux", "d.n.bs_oaa3a", "d.n.bs_oaa3a", "d.n.bs_oaa3a", "d.n.bs_oaa3a", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "c.n.bs_oaa3_aux", "d.n.bs_oaa4", "d.n.bs_oaa5", "c.n.bs_oaa5_aux", "d.n.bs_oaa6", "d.n.bs_oaa6", "d.n.bs_oaa6", "c.n.bs_oaa6_aux", "d.n.bs_oaa7", "c.n.bs_oaa7_aux", "d.n.out_co2", "f.n.out_Ac", "d.n.out_FTHF")
names(edge2fl)=c("Gluc_1 (Glucupt_1) Glc6P", "Gluc_U (Glucupt_U) Glc6P", "Glc6P (pgi) Fru6P", "Fru6P (pfk) FruBP", "FruBP (ald) ald", "ald (ald1) GA3P", "ald (ald2) GA3P", "GA3P (pgk) PGA", "PGA (eno) PEP", "PEP (pyk) Pyr", "Glc6P (zwf) Gnt6P", "Gnt6P (gnd) gnd", "gnd (gnd) CO2", "gnd (gnd) Rib5P", "Gnt6P (edd) edd", "edd (edd) Pyr", "edd (edd) GA3P", "GA3P (ta) ta", "Sed7P (ta) ta", "ta (ta) Ery4P", "ta (ta) Fru6P", "Rib5P (tk11) tk1", "Rib5P (tk12) tk1", "tk1 (tk1) GA3P", "tk1 (tk1) Sed7P", "Rib5P (tk2) tk2", "Ery4P (tk2) tk2", "tk2 (tk2) GA3P", "tk2 (tk2) Fru6P", "Pyr (pdh) pdh", "pdh (pdh) AcCoA", "pdh (pdh) CO2", "AcCoA (citsynth) citsynth", "OAA (citsynth) citsynth", "citsynth (citsynth) ICit", "ICit (idh) idh", "idh (idh) AKG", "idh (idh) CO2", "AKG (akgdh) akgdh", "akgdh (akgdh) Suc", "akgdh (akgdh) CO2", "Suc (fum_a) Mal", "Suc (fum_b) Mal", "Mal (maldh) OAA", "PEP (ppc) ppc", "CO2 (ppc) ppc", "ppc (ppc) OAA", "Mal (mae) mae", "mae (mae) Pyr", "mae (mae) CO2", "Glc6P (bs_glc6P) BM_Glc6P", "Fru6P (bs_fru6P) BM_Fru6P", "PGA (bs_pga) BM_PGA", "BM_PGA (bs_pga_aux) PGA_Aux", "BM_PGA (bs_pga1) Ser", "Ser (bs_pga1_aux) Ser_Aux", "Ser (bs_pga2) Cys", "Cys (bs_pga2_aux) Cys_Aux", "Ser (bs_pga3) bs_pga3", "bs_pga3 (bs_pga3) Gly", "bs_pga3 (bs_pga3) FTHF", "Gly (bs_pga3_aux) Gly_Aux", "GA3P (bs_DHAP) Glp", "Pyr (bs_pyr) BM_Pyr", "BM_Pyr (bs_pyr1) Ala", "Ala (bs_pyr1_aux) Ala_Aux", "BM_Pyr (bs_pyr21) bs_pyr2", "BM_Pyr (bs_pyr22) bs_pyr2", "bs_pyr2 (bs_pyr2) AKV", "bs_pyr2 (bs_pyr2) CO2", "AKV (bs_pyr4) Val", "Val (bs_pyr4_aux) Val_Aux", "AKV (bs_pyr3) bs_pyr3", "BM_AcCoA (bs_pyr3) bs_pyr3", "bs_pyr3 (bs_pyr3) Leu", "bs_pyr3 (bs_pyr3) CO2", "Leu (bs_pyr3_aux) Leu_Aux", "Ery4P (bs_e4p) BM_Ery4P", "Rib5P (bs_rib5p) BM_Rib5P", "BM_Rib5P (bs_rib5p1) bs_rib5p1", "FTHF (bs_rib5p1) bs_rib5p1", "bs_rib5p1 (bs_rib5p1) His", "His (bs_rib5p1_aux) His_Aux", "BM_Rib5P (bs_rib5p2) Ri5P_Aux", "PEP (bs_pep) BM_PEP", "BM_PEP (bs_pep1) bs_pep1", "BM_Ery4P (bs_pep1) bs_pep1", "bs_pep1 (bs_pep1) DAHP", "BM_PEP (bs_pep2) bs_pep2", "DAHP (bs_pep2) bs_pep2", "bs_pep2 (bs_pep2) Chor", "Chor (bs_pep3a) bs_pep3a", "bs_pep3a (bs_pep3a) Phe", "bs_pep3a (bs_pep3a) CO2", "Chor (bs_pep3b) bs_pep3b", "bs_pep3b (bs_pep3b) Phe", "bs_pep3b (bs_pep3b) CO2", "Phe (bs_pep3_aux) Phe_Aux", "Chor (bs_pep4a) bs_pep4a", "bs_pep4a (bs_pep4a) Tyr", "bs_pep4a (bs_pep4a) CO2", "Chor (bs_pep4b) bs_pep4b", "bs_pep4b (bs_pep4b) Tyr", "bs_pep4b (bs_pep4b) CO2", "Tyr (bs_pep4_aux) Tyr_Aux", "BM_PEP (bs_pep5) PEP_Aux", "Chor (bs_pep6) bs_pep6", "BM_Rib5P (bs_pep6) bs_pep6", "bs_pep6 (bs_pep6) Trp", "bs_pep6 (bs_pep6) PyrCO2", "Trp (bs_pep6_aux) Trp_Aux", "PyrCO2 (bs_pep7) bs_pep7", "bs_pep7 (bs_pep7) Pyr", "bs_pep7 (bs_pep7) CO2", "AcCoA (bs_accoa) BM_AcCoA", "BM_AcCoA (bs_accoa_aux) AcCoA_Aux", "AKG (bs_akg) BM_AKG", "BM_AKG (bs_akg1) Glu", "Glu (bs_akg2) Pro", "Glu (bs_akg3) Gln", "Glu (bs_akg4) bs_akg4", "CO2 (bs_akg4) bs_akg4", "bs_akg4 (bs_akg4) Arg", "Arg (bs_akg4_aux) Arg_Aux", "OAA (bs_oaa) BM_OAA", "BM_OAA (bs_oaa1) Asp", "Asp (bs_oaa1_aux) Asp_Aux", "Thr (bs_oaa2) bs_oaa2", "BM_Pyr (bs_oaa2) bs_oaa2", "bs_oaa2 (bs_oaa2) Ile", "bs_oaa2 (bs_oaa2) CO2", "Ile (bs_oaa2_aux) Ile_Aux", "BM_OAA (bs_oaa3a) bs_oaa3a", "BM_Pyr (bs_oaa3a) bs_oaa3a", "bs_oaa3a (bs_oaa3a) Lys", "bs_oaa3a (bs_oaa3a) CO2", "BM_OAA (bs_oaa3b) bs_oaa3b", "BM_Pyr (bs_oaa3b) bs_oaa3b", "bs_oaa3b (bs_oaa3b) Lys", "bs_oaa3b (bs_oaa3b) CO2", "Lys (bs_oaa3_aux) Lys_Aux", "BM_OAA (bs_oaa4) OAA_Aux", "BM_OAA (bs_oaa5) Thr", "Thr (bs_oaa5_aux) Thr_Aux", "BM_OAA (bs_oaa6) bs_oaa6", "FTHF (bs_oaa6) bs_oaa6", "bs_oaa6 (bs_oaa6) Met", "Met (bs_oaa6_aux) Met_Aux", "BM_OAA (bs_oaa7) Asn", "Asn (bs_oaa7_aux) Asn_Aux", "CO2 (out_co2) CO2_out", "AcCoA (out_Ac) Acetate", "FTHF (out_FTHF) FTHF_out")

# initialize the linear system Afl*flnx=bfl (0-weight cumomers)
# unknown net flux names
nm_fln=c("d.n.Glucupt_U", "d.n.akgdh", "d.n.ald", "d.n.bs_accoa_aux", "d.n.bs_akg1", "d.n.bs_akg4", "d.n.bs_akg4_aux", "d.n.bs_e4p", "d.n.bs_oaa1", "d.n.bs_oaa2", "d.n.bs_oaa3a", "d.n.bs_oaa3b", "d.n.bs_oaa4", "d.n.bs_oaa5", "d.n.bs_oaa6", "d.n.bs_oaa7", "d.n.bs_pep1", "d.n.bs_pep2", "d.n.bs_pep3a", "d.n.bs_pep3b", "d.n.bs_pep4a", "d.n.bs_pep4b", "d.n.bs_pep6", "d.n.bs_pep6_aux", "d.n.bs_pep7", "d.n.bs_pga1", "d.n.bs_pga2", "d.n.bs_pga3", "d.n.bs_pga_aux", "d.n.bs_pyr1", "d.n.bs_pyr1_aux", "d.n.bs_pyr2", "d.n.bs_pyr3", "d.n.bs_pyr4", "d.n.bs_rib5p1", "d.n.bs_rib5p2", "d.n.citsynth", "d.n.edd", "d.n.eno", "d.n.fum_a", "d.n.fum_b", "d.n.idh", "d.n.mae", "d.n.maldh", "d.n.out_FTHF", "d.n.out_co2", "d.n.pdh", "d.n.pfk", "d.n.pgi", "d.n.pgk", "d.n.ppc", "d.n.ta", "d.n.tk1", "d.n.tk2")
nb_fln=length(nm_fln)
fln=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
names(fln)=nm_fln
# unknown xch flux names
nm_flx=c("d.x.fum_b")
nb_flx=length(nm_flx)
flx=c(0.0)
names(flx)=nm_flx
nm_fl=c(nm_fln, nm_flx)
nb_fl=nb_fln+nb_flx
fl=c(fln, flx)
# gather flux names in a list
nm_list$flnx=nm_fl
nm_list$fwrv=nm_fwrv

# carbon length of metabolites
clen=c(6,6,6,6,6,3,3,3,3,6,1,5,7,4,2,4,6,5,4,4,6,6,3,3,3,3,3,3,2,1,2,3,3,3,3,5,5,5,2,6,6,4,5,6,6,5,3,7,10,9,9,9,9,3,11,4,11,2,5,5,5,5,6,6,4,4,4,4,6,6,6,6,4,4,5,5,4,4,1,2,1)
names(clen)=c("Gluc_1","Glc6P","Gluc_U","Fru6P","FruBP","GA3P","PGA","PEP","Pyr","Gnt6P","CO2","Rib5P","Sed7P","Ery4P","AcCoA","OAA","ICit","AKG","Suc","Mal","BM_Glc6P","BM_Fru6P","BM_PGA","PGA_Aux","Ser","Ser_Aux","Cys","Cys_Aux","Gly","FTHF","Gly_Aux","Glp","BM_Pyr","Ala","Ala_Aux","AKV","Val","Val_Aux","BM_AcCoA","Leu","Leu_Aux","BM_Ery4P","BM_Rib5P","His","His_Aux","Ri5P_Aux","BM_PEP","DAHP","Chor","Phe","Phe_Aux","Tyr","Tyr_Aux","PEP_Aux","Trp","PyrCO2","Trp_Aux","AcCoA_Aux","BM_AKG","Glu","Pro","Gln","Arg","Arg_Aux","BM_OAA","Asp","Asp_Aux","Thr","Ile","Ile_Aux","Lys","Lys_Aux","OAA_Aux","Thr_Aux","Met","Met_Aux","Asn","Asn_Aux","CO2_out","Acetate","FTHF_out")

# metabolite pools are : all (poolall) which is divided in free (poolf) and
# constrained (poolc)

# constrained pool
poolc=c()
nm_poolc=c()
if (length(nm_poolc)) {
   names(nm_poolc)=substring(nm_poolc, 4)
}
names(poolc)=nm_poolc

# starting values for free pool (the same number and the same alphabetic order than free growth fluxes, if present)
poolf=c()
nm_poolf=c()
if (length(nm_poolf)) {
   names(nm_poolf)=substring(nm_poolf, 4)
}
names(poolf)=nm_poolf
nb_poolf=length(poolf)
nb_f$nb_poolf=nb_poolf

nm_poolall=c(nm_poolf, nm_poolc)
poolall=as.numeric(c(poolf, poolc))
names(poolall)=nm_poolall
pool=poolall
nm_list$poolf=nm_poolf
nm_list$poolc=nm_poolc
nm_list$poolall=nm_poolall

# flux matrix
nb_flr=55
if (nb_fl) {
   Afl=matrix(0, nrow=nb_flr, ncol=nb_fl)
   Afl[1, c(1, 49)]=c(1.0, -1.0)
   Afl[2, c(48, 49, 52, 54)]=c(-1.0, 1.0, 1.0, 1.0)
   Afl[3, c(3, 48)]=c(-1.0, 1.0)
   Afl[4, c(3, 38, 50, 52, 53, 54)]=c(2.0, 1.0, -1.0, -1.0, 1.0, 1.0)
   Afl[5, c(39, 50)]=c(-1.0, 1.0)
   Afl[6, c(39, 51)]=c(1.0, -1.0)
   Afl[7, c(25, 38, 43, 47)]=c(1.0, 1.0, 1.0, -1.0)
   Afl[8, c(38)]=c(-1.0)
   Afl[9, c(2, 6, 10, 11, 12, 19, 20, 21, 22, 25, 32, 33, 42, 43, 46, 47, 51)]=c(1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, 1.0, -1.0)
   Afl[10, c(53, 54)]=c(-2.0, -1.0)
   Afl[11, c(52, 53)]=c(-1.0, 1.0)
   Afl[12, c(8, 52, 54)]=c(-1.0, 1.0, -1.0)
   Afl[13, c(37, 47)]=c(-1.0, 1.0)
   Afl[14, c(37, 44, 51)]=c(-1.0, 1.0, 1.0)
   Afl[15, c(37, 42)]=c(1.0, -1.0)
   Afl[16, c(2, 42)]=c(-1.0, 1.0)
   Afl[17, c(2, 40, 41)]=c(1.0, -1.0, -1.0)
   Afl[18, c(40, 41, 43, 44)]=c(1.0, 1.0, -1.0, -1.0)
   Afl[19, c(26, 29)]=c(-1.0, -1.0)
   Afl[20, c(26, 27, 28)]=c(1.0, -1.0, -1.0)
   Afl[21, c(27)]=c(1.0)
   Afl[22, c(28)]=c(1.0)
   Afl[23, c(15, 28, 35, 45)]=c(-1.0, 1.0, -1.0, -1.0)
   Afl[24, c(10, 11, 12, 30, 32)]=c(-1.0, -1.0, -1.0, -1.0, -2.0)
   Afl[25, c(30, 31)]=c(1.0, -1.0)
   Afl[26, c(32, 33, 34)]=c(1.0, -1.0, -1.0)
   Afl[27, c(34)]=c(1.0)
   Afl[28, c(4, 33)]=c(-1.0, -1.0)
   Afl[29, c(33)]=c(1.0)
   Afl[30, c(8, 17)]=c(1.0, -1.0)
   Afl[31, c(23, 35, 36)]=c(-1.0, -1.0, -1.0)
   Afl[32, c(35)]=c(1.0)
   Afl[33, c(17, 18)]=c(-1.0, -1.0)
   Afl[34, c(17, 18)]=c(1.0, -1.0)
   Afl[35, c(18, 19, 20, 21, 22, 23)]=c(1.0, -1.0, -1.0, -1.0, -1.0, -1.0)
   Afl[36, c(19, 20)]=c(1.0, 1.0)
   Afl[37, c(21, 22)]=c(1.0, 1.0)
   Afl[38, c(23, 24)]=c(1.0, -1.0)
   Afl[39, c(23, 25)]=c(1.0, -1.0)
   Afl[40, c(5)]=c(-1.0)
   Afl[41, c(5, 6)]=c(1.0, -1.0)
   Afl[42, c(6, 7)]=c(1.0, -1.0)
   Afl[43, c(9, 11, 12, 13, 14, 15, 16)]=c(-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0)
   Afl[44, c(9)]=c(1.0)
   Afl[45, c(10, 14)]=c(-1.0, 1.0)
   Afl[46, c(10)]=c(1.0)
   Afl[47, c(11, 12)]=c(1.0, 1.0)
   Afl[48, c(15)]=c(1.0)
   Afl[49, c(16)]=c(1.0)
   Afl[50, c(40, 41)]=c(1.0, -1.0)
   Afl[51, c(1)]=c(1.0)
   Afl[52, c(11, 12)]=c(1.0, -1.0)
   Afl[53, c(19, 20)]=c(1.0, -1.0)
   Afl[54, c(21, 22)]=c(1.0, -1.0)
   Afl[55, c(55)]=c(-1.0)
} else {
   Afl=matrix(0., nb_fl, nb_fl)
}
dimnames(Afl)=list(c("Glc6P", "Fru6P", "FruBP", "GA3P", "PGA", "PEP", "Pyr", "Gnt6P", "CO2", "Rib5P", "Sed7P", "Ery4P", "AcCoA", "OAA", "ICit", "AKG", "Suc", "Mal", "BM_PGA", "Ser", "Cys", "Gly", "FTHF", "BM_Pyr", "Ala", "AKV", "Val", "BM_AcCoA", "Leu", "BM_Ery4P", "BM_Rib5P", "His", "BM_PEP", "DAHP", "Chor", "Phe", "Tyr", "Trp", "PyrCO2", "BM_AKG", "Glu", "Arg", "BM_OAA", "Asp", "Thr", "Ile", "Lys", "Met", "Asn", "eq net: fum_a-fum_b=0: 588", "eq net: Glucupt_1+Glucupt_U=1: 589", "eq net: bs_oaa3a-bs_oaa3b=0: 590", "eq net: bs_pep3a-bs_pep3b=0: 591", "eq net: bs_pep4a-bs_pep4b=0: 592", "eq xch: fum_a-fum_b=0: 597"), nm_fl)
#browser()
# prepare param (\Theta) vector
# order: free flux net, free flux xch, scale label, scale mass, scale peak
param=numeric(0)
nm_par=c()
# free net fluxes
nb_ffn=5
nm_ffn=c("f.n.Glucupt_1", "f.n.gnd", "f.n.out_Ac", "f.n.pyk", "f.n.zwf")
# starting values for iterations
param=c(param, c(0.7, 0.15062, 0.213, 1.4, 0.2))
if (nb_ffn) {
   nm_par=c(nm_par, nm_ffn)
}
# free xch fluxes
nb_ffx=7
nm_ffx=c("f.x.ald", "f.x.eno", "f.x.fum_a", "f.x.ppc", "f.x.ta", "f.x.tk1", "f.x.tk2")
# starting values for iterations
param=c(param, c(0.413926, 0.800962, 0.395958, 0.256772, 0.359468, 0.166316, 0.00211559))
if (nb_ffx) {
   nm_par=c(nm_par, nm_ffx)
}
names(param)=nm_par
ff=param
nm_ff=c(nm_ffn, nm_ffx)
nm_list$ff=nm_ff
nb_param=length(param)
# scaling factors are added to param later

nb_ff=nb_ffn+nb_ffx

# constrained fluxes
# net
nb_fcn=27
nm_fcn=c("c.n.bs_DHAP", "c.n.bs_accoa", "c.n.bs_akg", "c.n.bs_akg2", "c.n.bs_akg3", "c.n.bs_fru6P", "c.n.bs_glc6P", "c.n.bs_oaa", "c.n.bs_oaa1_aux", "c.n.bs_oaa2_aux", "c.n.bs_oaa3_aux", "c.n.bs_oaa5_aux", "c.n.bs_oaa6_aux", "c.n.bs_oaa7_aux", "c.n.bs_pep", "c.n.bs_pep3_aux", "c.n.bs_pep4_aux", "c.n.bs_pep5", "c.n.bs_pga", "c.n.bs_pga1_aux", "c.n.bs_pga2_aux", "c.n.bs_pga3_aux", "c.n.bs_pyr", "c.n.bs_pyr3_aux", "c.n.bs_pyr4_aux", "c.n.bs_rib5p", "c.n.bs_rib5p1_aux")
fcn=c(0.0068, 0.1565, 0.0571, 0.0111, 0.0132, 0.0038, 0.0109, 0.0947, 0.0121, 0.0146, 0.0173, 0.0128, 0.0077, 0.0121, 0.0381, 0.0093, 0.0069, 0.0027, 0.0791, 0.0109, 0.0046, 0.0308, 0.1501, 0.0227, 0.0213, 0.0476, 0.0048)
# xch
nb_fcx=78
nm_fcx=c("c.x.Glucupt_1", "c.x.Glucupt_U", "c.x.akgdh", "c.x.bs_DHAP", "c.x.bs_accoa", "c.x.bs_accoa_aux", "c.x.bs_akg", "c.x.bs_akg1", "c.x.bs_akg2", "c.x.bs_akg3", "c.x.bs_akg4", "c.x.bs_akg4_aux", "c.x.bs_e4p", "c.x.bs_fru6P", "c.x.bs_glc6P", "c.x.bs_oaa", "c.x.bs_oaa1", "c.x.bs_oaa1_aux", "c.x.bs_oaa2", "c.x.bs_oaa2_aux", "c.x.bs_oaa3_aux", "c.x.bs_oaa3a", "c.x.bs_oaa3b", "c.x.bs_oaa4", "c.x.bs_oaa5", "c.x.bs_oaa5_aux", "c.x.bs_oaa6", "c.x.bs_oaa6_aux", "c.x.bs_oaa7", "c.x.bs_oaa7_aux", "c.x.bs_pep", "c.x.bs_pep1", "c.x.bs_pep2", "c.x.bs_pep3_aux", "c.x.bs_pep3a", "c.x.bs_pep3b", "c.x.bs_pep4_aux", "c.x.bs_pep4a", "c.x.bs_pep4b", "c.x.bs_pep5", "c.x.bs_pep6", "c.x.bs_pep6_aux", "c.x.bs_pep7", "c.x.bs_pga", "c.x.bs_pga1", "c.x.bs_pga1_aux", "c.x.bs_pga2", "c.x.bs_pga2_aux", "c.x.bs_pga3", "c.x.bs_pga3_aux", "c.x.bs_pga_aux", "c.x.bs_pyr", "c.x.bs_pyr1", "c.x.bs_pyr1_aux", "c.x.bs_pyr2", "c.x.bs_pyr3", "c.x.bs_pyr3_aux", "c.x.bs_pyr4", "c.x.bs_pyr4_aux", "c.x.bs_rib5p", "c.x.bs_rib5p1", "c.x.bs_rib5p1_aux", "c.x.bs_rib5p2", "c.x.citsynth", "c.x.edd", "c.x.gnd", "c.x.idh", "c.x.mae", "c.x.maldh", "c.x.out_Ac", "c.x.out_FTHF", "c.x.out_co2", "c.x.pdh", "c.x.pfk", "c.x.pgi", "c.x.pgk", "c.x.pyk", "c.x.zwf")
fcx=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.011799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.647115, 0.0, 0.0, 0.0, 0.0322745, 0.0, 0.752386, 0.984718, 0.0109591, 0.0)
fc=c(fcn, fcx)
nm_fc=c(nm_fcn, nm_fcx)
names(fc)=nm_fc
nb_fc=nb_fcn+nb_fcx

# variable growth fluxes (constant are already accounted in constrained fluxes)
nb_fgr=0
nm_fgr=c()
fgr=c()
nm_list$fgr=nm_fgr
nb_f$nb_fgr=nb_fgr

# total flux vector fallnx dimension
nb_fallnx=nb_fl+nb_ff+nb_fc+nb_fgr+nb_fgr
nb_fwrv=nb_fallnx

# net dependent and free fluxes
nm_dfn=c(nm_fln, nm_ffn)
names(nm_dfn)=substring(nm_dfn, 5)

# all flux cardinals
nb_f=append(nb_f, list(nb_fln=nb_fln, nb_flx=nb_flx, nb_fl=nb_fl,
   nb_ffn=nb_ffn, nb_ffx=nb_ffx, nb_ff=nb_ff,
   nb_fcn=nb_fcn, nb_fcx=nb_fcx, nb_fc=nb_fc,
   nb_fallnx=nb_fallnx, nb_fwrv=nb_fwrv,
   nb_fgr=nb_fgr,
   include_growth_flux=FALSE,
   mu=NULL))

# prepare p2bfl, c2bfl, g2bfl, cnst2bfl matrices such that p2bfl%*%param[1:nb_ff]+
# c2bfl%*%fc+g2bfl%*%fgr+cnst2bfl=bfl
# replace f.[nx].flx by corresponding param coefficient
p2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_ff)
# replace c.[nx].flx by corresponding fc coefficient
c2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fc)
# variable growth fluxes
g2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fgr)
cnst2bfl=numeric(nb_flr); # may be coming from equalities
colnames(p2bfl)=nm_par
colnames(c2bfl)=nm_fc
colnames(g2bfl)=nm_fgr

p2bfl[1, pmatch(c("f.n.zwf", "f.n.Glucupt_1"), nm_par)]=c(1.0, -1.0);
c2bfl[1, pmatch(c("c.n.bs_glc6P"), nm_fc)]=c(1.0);

c2bfl[2, pmatch(c("c.n.bs_fru6P"), nm_fc)]=c(1.0);

c2bfl[4, pmatch(c("c.n.bs_DHAP"), nm_fc)]=c(1.0);

c2bfl[5, pmatch(c("c.n.bs_pga"), nm_fc)]=c(1.0);

p2bfl[6, pmatch(c("f.n.pyk"), nm_par)]=c(1.0);
c2bfl[6, pmatch(c("c.n.bs_pep"), nm_fc)]=c(1.0);

p2bfl[7, pmatch(c("f.n.pyk"), nm_par)]=c(-1.0);
c2bfl[7, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(1.0);

p2bfl[8, pmatch(c("f.n.gnd", "f.n.zwf"), nm_par)]=c(1.0, -1.0);

p2bfl[9, pmatch(c("f.n.gnd"), nm_par)]=c(-1.0);

p2bfl[10, pmatch(c("f.n.gnd"), nm_par)]=c(-1.0);
c2bfl[10, pmatch(c("c.n.bs_rib5p"), nm_fc)]=c(1.0);

p2bfl[13, pmatch(c("f.n.out_Ac"), nm_par)]=c(1.0);
c2bfl[13, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(1.0);

c2bfl[14, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(1.0);

c2bfl[16, pmatch(c("c.n.bs_akg"), nm_fc)]=c(1.0);

c2bfl[19, pmatch(c("c.n.bs_pga"), nm_fc)]=c(-1.0);

c2bfl[20, pmatch(c("c.n.bs_pga1_aux"), nm_fc)]=c(1.0);

c2bfl[21, pmatch(c("c.n.bs_pga2_aux"), nm_fc)]=c(1.0);

c2bfl[22, pmatch(c("c.n.bs_pga3_aux"), nm_fc)]=c(1.0);

c2bfl[24, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(-1.0);

c2bfl[27, pmatch(c("c.n.bs_pyr4_aux"), nm_fc)]=c(1.0);

c2bfl[28, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(-1.0);

c2bfl[29, pmatch(c("c.n.bs_pyr3_aux"), nm_fc)]=c(1.0);

c2bfl[31, pmatch(c("c.n.bs_rib5p"), nm_fc)]=c(-1.0);

c2bfl[32, pmatch(c("c.n.bs_rib5p1_aux"), nm_fc)]=c(1.0);

c2bfl[33, pmatch(c("c.n.bs_pep5", "c.n.bs_pep"), nm_fc)]=c(1.0, -1.0);

c2bfl[36, pmatch(c("c.n.bs_pep3_aux"), nm_fc)]=c(1.0);

c2bfl[37, pmatch(c("c.n.bs_pep4_aux"), nm_fc)]=c(1.0);

c2bfl[40, pmatch(c("c.n.bs_akg"), nm_fc)]=c(-1.0);

c2bfl[41, pmatch(c("c.n.bs_akg2", "c.n.bs_akg3"), nm_fc)]=c(1.0, 1.0);

c2bfl[43, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(-1.0);

c2bfl[44, pmatch(c("c.n.bs_oaa1_aux"), nm_fc)]=c(1.0);

c2bfl[45, pmatch(c("c.n.bs_oaa5_aux"), nm_fc)]=c(1.0);

c2bfl[46, pmatch(c("c.n.bs_oaa2_aux"), nm_fc)]=c(1.0);

c2bfl[47, pmatch(c("c.n.bs_oaa3_aux"), nm_fc)]=c(1.0);

c2bfl[48, pmatch(c("c.n.bs_oaa6_aux"), nm_fc)]=c(1.0);

c2bfl[49, pmatch(c("c.n.bs_oaa7_aux"), nm_fc)]=c(1.0);


p2bfl[51, pmatch(c("f.n.Glucupt_1"), nm_par)]=c(-1.0);
cnst2bfl[51]=1;




p2bfl[55, pmatch(c("f.x.fum_a"), nm_par)]=c(-1.0);

bp=as.numeric(c2bfl%stm%fc+cnst2bfl)

if (ffguess) {
   # make an automatic guess for free/dependent flux partition
   afd=as.matrix(cBind(Afl, -p2bfl))
   qafd=qr(afd, LAPACK=T)
   d=abs(diag(qafd$qr))
   rank=sum(d > d[1]*1.e-10)
   qrow=qr(t(afd))
   rankr=qrow$rank
   if (rank != rankr) {
      mes="Weird error: column and row ranks are not equal.\n"
      stop_mes(mes, file=fcerr)
   }
   irows=qrow$pivot[seq_len(rankr)]
   if (rank==0) {
      stop_mes("Error: No free/dependent flux partition could be made. Stoechiometric matrix has rank=0.\n", file=fcerr)
   }
   Afl=afd[irows, qafd$pivot[1L:rank], drop=FALSE]
   ka=kappa(Afl)
   if (ka > 1.e7) {
      mes=sprintf("Error: No working free/dependent flux partition could be proposed. Stoechiometric matrix has condition number %g.\n", ka)
      stop_mes(mes, file=fcerr)
   }
   p2bfl=-as.simple_triplet_matrix(afd[irows, qafd$pivot[-seq_len(rank)], drop=FALSE])
   c2bfl=c2bfl[irows, , drop=FALSE]
   g2bfl=g2bfl[irows, , drop=FALSE]
   cnst2bfl=cnst2bfl[irows]
   bp=bp[irows]
   
   # replace names
   nm_fl=sub("f.", "d.", colnames(Afl), fixed=T)
   colnames(Afl)=nm_fl # both net and xch
   nm_fln=sort(grep("^d.n.", nm_fl, v=T))
   nm_flx=sort(grep("^d.x.", nm_fl, v=T))
   nm_fl=c(nm_fln, nm_flx)
   Afl=Afl[, nm_fl, drop=FALSE]
   
   nm_ff=sub("d.", "f.", colnames(p2bfl), fixed=T) # both net and xch
   colnames(p2bfl)=nm_ff
   nm_ffn=sort(grep("^f.n.", nm_ff, v=T))
   nm_ffx=sort(grep("^f.x.", nm_ff, v=T))
   nm_ff=c(nm_ffn, nm_ffx)
   p2bfl=p2bfl[, nm_ff, drop=FALSE]
   
   # remake param vector
   if (!fdfit)
      param=c(runif(length(nm_ff)), if (nb_ff == 0) param else param[-seq_len(nb_ff)])
   names(param)[seq(along=nm_ff)]=nm_ff
#browser()
}
nm_list$flnx=nm_fl
nm_fallnx=c(nm_fln, nm_ffn, nm_fcn, nm_fgr, nm_flx, nm_ffx, nm_fcx, sub(".n.", ".x.", nm_fgr, fixed=T))
nm_list$fallnx=nm_fallnx
nm_net=c(nm_fln, nm_ffn, nm_fcn)
names(nm_net)=substring(nm_net, 5)
nm_xch=c(nm_flx, nm_ffx, nm_fcx)
names(nm_xch)=substring(nm_xch, 5)
edge2fl[]=nm_net[substring(edge2fl, 5)]
nm_list$ff=nm_ff

# accounting numbers
nb_flr=nrow(Afl)
nb_param=length(param)
nb_ffn=length(nm_ffn)
nb_ffx=length(nm_ffx)
nb_ff=nb_ffn+nb_ffx
nb_fln=length(nm_fln)
nb_flx=length(nm_flx)
nb_fl=nb_fln+nb_flx
nm_par=names(param)

for (item in c("nb_fln", "nb_flx", "nb_fl", "nb_ffn", "nb_ffx", "nb_ff")) {
   nb_f[item]=get(item)
}
# translation from n-x to fw-rv
sh_fwrv=substring(nm_fwrv[1:(nb_fwrv/2)], 5)
sh_nx=substring(nm_fallnx, 2)
nb_f$inet2ifwrv=pmatch(paste(".n.", sh_fwrv, sep=""), sh_nx)
nb_f$ixch2ifwrv=pmatch(paste(".x.", sh_fwrv, sep=""), sh_nx)
#nb_f$inet2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.n\\.%s$", substring(f, 5)), nm_fallnx))
#nb_f$ixch2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.x\\.%s$", substring(f, 5)), nm_fallnx))

if (TIMEIT) {
   cat("Afl qr(): ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

qrAfl=qr(Afl, LAPACK=T)
d=abs(diag(qrAfl$qr))
qrAfl$rank=sum(d > d[1]*1.e-10)
rank=qrAfl$rank
aful=as.matrix(cBind(Afl, -p2bfl, -c2bfl))
qrow=qr(t(aful))
rankr=qrow$rank
#browser()
# first check the presence of lindep rows
if (nrow(Afl) > rankr) {
   prop=sprintf("Error: Among %d equations (rows), %d are redundant and must be eliminated by hand.\n", nrow(Afl), nrow(Afl)-rankr)
   prop=paste(prop, "Candidate(s) for elimination is (are):\n",
      paste(rownames(Afl)[qrow$pivot[-(1:rankr)]], sep="", collapse="\n"),
               "\n", sep="")
   stop_mes(prop, file=fcerr)
}
if (nrow(Afl) != rank || nrow(Afl) != ncol(Afl)) {
   #write.table(Afl)
   mes=NULL
   if (nrow(Afl) <= rank) {
      mes=paste("Candidate(s) for free or constrained flux(es):\n",
         paste(colnames(Afl)[-qrAfl$pivot[1L:nrow(Afl)]], collapse="\n"),
         "\nFor this choice, condition number of stoechiometric matrix will be ",
         kappa(Afl[,qrAfl$pivot[1L:nrow(Afl)],drop=FALSE]), "\n", sep="")
   } else if (nrow(Afl) > rank) {
      nextra=nrow(Afl)-rank
      comb=combn(c(nm_ffn, colnames(Afl)[-qrAfl$pivot[1L:rank]]), nextra)
      aextra=cBind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl)
      colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl))
      ara=Afl[,qrAfl$pivot[1L:rank],drop=FALSE]
      i=which.min(apply(comb, 2, function(i) kappa(cBind(ara, aextra[,i]))))[1L]
      nm_tmp=comb[,i]
      ka=kappa(cBind(ara, aextra[,nm_tmp]))
      if (ka < 1.e7) {
         prop=paste("Proposal to declare dependent flux(es) is:\n",
            paste(nm_tmp, collapse="\n"), "\n", sep="")
         if (rank < ncol(Afl)) {
            prop=prop%s+%"While the following dependent flux(es) should be declared free or constrained:\n"%s+%join("\n", colnames(Afl)[-qrAfl$pivot[1L:rank]])%s+%"\n"
         }
         prop=paste(prop, "For this choice, condition number of stoechiometric matrix will be ", ka, "\n", sep="")
      } else {
         # add constraint fluxes to candidate list
         if (nb_fcn > 0) {
            aextra=as.matrix(cBind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl, -c2bfl))
            colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl), colnames(c2bfl))
         }
         aextended=aful
         qae=qr(aextended, LAPACK=T)
         d=abs(diag(qae$qr))
         ranke=sum(d > d[1L]*1.e-10)
         if (ranke == nrow(Afl)) {
            prop=paste("Proposal to declare dependent flux(es) is:\n",
            join("\n", colnames(aextended)[qae$pivot[1L:ranke]]), "\n",
            "while free and constrained fluxes should be:\n",
            join("\n", colnames(aextended)[-qae$pivot[1L:ranke]]), "\n",
            sep="")
            ka=kappa(aextended[,qae$pivot[1L:ranke]])
            prop=paste(prop, "For this choice, condition number of stoechiometric matrix will be ", ka, "\n", sep="")
         } else {
            prop="No proposal for partition dependent/free fluxes could be made.\n"
         }
      }
      mes=paste("There is (are) probably ", nextra,
         " extra free flux(es) among the following:\n",
         paste(nm_ffn, collapse="\n"), "\n",
         prop,
         sep="")
   }
   stop_mes(paste("Flux matrix is not square or is singular: (", nrow(Afl), "eq x ", ncol(Afl), "unk)\n",
      "You have to change your choice of free fluxes in the 'e_coli.ftbl' file.\n",
      mes, sep=""), file=fcerr)
}

# make sure that free params choice leads to not singular matrix
if (qrAfl$rank != nb_fl) {
   #write.table(Afl)
   # make a suggestion of new free fluxes
   A=cBind(Afl, -p2bfl, -c2bfl)
   colnames(A)=c(colnames(Afl), nm_ff, nm_fc)
   qa=qr(A, LAPACK=T)
   d=diag(qa$qr)
   qa$rank=sum(abs(d)>=abs(d[1]*1.e-10))
   
   mes=paste("Error: Dependent flux matrix is singular.\n",
      "Change your partition on free/dependent/constrained fluxes in the 'e_coli.ftbl' file.\n",
      "Can not resolve dependent fluxe(s):\n",
      paste(colnames(Afl)[-qrAfl$pivot[(1:qrAfl$rank)]], collapse="\n"),
      sep="")
   if (qa$rank==nb_fl) {
      mes=paste(mes,
      "\n\nSuggested dependent fluxes:\n",
      paste(colnames(A)[qa$pivot[(1:qa$rank)]], collapse="\n"),
      "\n\nWhich would give the following free and constrained fluxes:\n",
      paste(colnames(A)[-qa$pivot[(1:qa$rank)]], collapse="\n"), "\n",
      sep="")
   } else {
      mes=paste(mes, "\nNo suggested free fluxes could be found", sep="")
   }
   stop_mes(mes, file=fcerr)
}

# inverse flux matrix
invAfl=solve(qrAfl)

if (fdfit) {
#browser()
   # choose free fluxe values such that they fit starting values from ftbl
   #dep=invAfl%*%(p2bfl%*%ff+bp)
   #ff=ff
   ff=qr.solve(rbind(invAfl%stm%p2bfl, diag(ncol(p2bfl))), c(fl-invAfl%*%bp, param))
}
# intermediate jacobian
if (TIMEIT) {
   cat("dfl_dffg: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

dfl_dffg=invAfl%stm%p2bfl
if (nb_fgr > 0L) {
   dfl_dffg=cBind(dfl_dffg, invAfl%stm%g2bfl)
}
dimnames(dfl_dffg)=list(nm_fl, c(nm_ff, nm_fgr))
dfl_dffg[abs(dfl_dffg) < 1.e-14]=0.
nb_f$dfl_dffg=as.simple_triplet_matrix(dfl_dffg)

# prepare mf, md, mc and mg matrices
# such that mf%*%ff+md%*%fl+mc%*%fc+mg%*%fgr gives fallnx
# here ff free fluxes (param), fl are dependent fluxes, fc are constrained
# fluxes and fgr are variable growth fluxes
mf=matrix(0., nb_fallnx, nb_ff)
dimnames(mf)=list(nm_fallnx, nm_ff)
md=matrix(0., nb_fallnx, nb_fl)
dimnames(md)=list(nm_fallnx, nm_fl)
mc=matrix(0., nb_fallnx, nb_fc)
dimnames(mc)=list(nm_fallnx, nm_fc)
mg=matrix(0., nb_fallnx, nb_fgr)
dimnames(mg)=list(nm_fallnx, nm_fgr)

if (nb_ff > 0) {
   mf[nm_ff, nm_ff]=diag(1., nb_ff)
}
if (nb_fl > 0) {
   md[nm_fl, nm_fl]=diag(1., nb_fl)
}
if (nb_fc > 0) {
   mc[nm_fc, nm_fc]=diag(1., nb_fc)
}
if (nb_fgr > 0) {
   mg[nm_fgr, nm_fgr]=diag(1., nb_fgr)
}

# sparse matrix static parts
# $varname fields:
#  ind_fa - flux index in a_pre$vfwrv[ind_fa]
#  a_pre - sparse matrix whose colsum() gives the a$v vector
#  prodx - dense matrix whose colprod() will give x[ind_x1]*x[ind_x2]*...
#  ind_fb - flux index in b_pre$v=fwrv[ind_fb1]*colprod(prodx)
#  ind_b - dense matrix of indexes for  b_pre$v=f[ind_b[,"indf"]*x[ind_b[,2+1]]*x[ind_b[,2+2]], ...]
#  b_pre - sparse matrix whose colsum gives b@x

#  a - unsigned sparse cumomer A matrix (off-diagonal part)
#  b - unsigned sparse vector of right hand side

if (TIMEIT) {
   cat("spAbr   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

nb_fwrv=172
nb_w=6
spAbr=list()

if (TIMEIT) {
   cat("weight 1: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=1
nb_c=231
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=0 # number of lighter cumomers
maxprod=1
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(3, 0, 0, 154, 0, 0, 155, 0, 0, 3, 0, 69, 154, 0, 101, 155, 0, 102, 3, 1, 1, 154, 1, 1, 155, 1, 1, 3, 1, 70, 154, 1, 103, 155, 1, 104, 3, 2, 2, 154, 2, 2, 155, 2, 2, 3, 2, 71, 154, 2, 104, 155, 2, 103, 3, 3, 3, 154, 3, 3, 155, 3, 3, 3, 3, 72, 154, 3, 102, 155, 3, 101, 65, 4, 4, 157, 4, 4, 65, 4, 46, 157, 4, 69, 65, 5, 5, 157, 5, 5, 65, 5, 47, 157, 5, 70, 65, 6, 6, 157, 6, 6, 65, 6, 59, 157, 6, 45, 65, 7, 7, 157, 7, 7, 65, 7, 60, 157, 7, 71, 65, 8, 8, 157, 8, 8, 65, 8, 61, 157, 8, 72, 65, 9, 9, 157, 9, 9, 65, 9, 62, 157, 9, 73, 67, 10, 10, 168, 10, 10, 167, 10, 10, 118, 10, 10, 67, 10, 13, 168, 10, 54, 167, 10, 61, 118, 10, 58, 67, 11, 11, 168, 11, 11, 167, 11, 11, 118, 11, 11, 67, 11, 14, 168, 11, 55, 167, 11, 60, 118, 11, 88, 67, 12, 12, 168, 12, 12, 167, 12, 12, 118, 12, 12, 67, 12, 15, 168, 12, 56, 167, 12, 59, 118, 12, 105, 80, 13, 13, 153, 13, 13, 131, 13, 13, 80, 13, 50, 153, 13, 10, 131, 13, 106, 80, 14, 14, 153, 14, 14, 131, 14, 14, 80, 14, 49, 153, 14, 11, 131, 14, 107, 80, 15, 15, 153, 15, 15, 131, 15, 15, 80, 15, 48, 153, 15, 12, 131, 15, 108, 78, 16, 16, 90, 16, 16, 78, 16, 28, 90, 16, 50, 78, 17, 17, 90, 17, 17, 78, 17, 29, 90, 17, 49, 78, 18, 18, 90, 18, 18, 78, 18, 30, 90, 18, 48, 78, 19, 19, 90, 19, 19, 78, 19, 31, 90, 19, 48, 78, 20, 20, 90, 20, 20, 78, 20, 32, 90, 20, 49, 78, 21, 21, 90, 21, 21, 78, 21, 33, 90, 21, 50, 165, 22, 22, 172, 22, 22, 1, 22, 22, 2, 22, 22, 165, 22, 28, 172, 22, 39, 165, 23, 23, 172, 23, 23, 1, 23, 23, 2, 23, 23, 165, 23, 29, 172, 23, 40, 165, 24, 24, 172, 24, 24, 1, 24, 24, 2, 24, 24, 165, 24, 30, 172, 24, 41, 165, 25, 25, 172, 25, 25, 1, 25, 25, 2, 25, 25, 165, 25, 31, 172, 25, 42, 165, 26, 26, 172, 26, 26, 1, 26, 26, 2, 26, 26, 165, 26, 32, 172, 26, 43, 165, 27, 27, 172, 27, 27, 1, 27, 27, 2, 27, 27, 165, 27, 33, 172, 27, 44, 79, 28, 28, 83, 28, 28, 85, 28, 28, 164, 28, 28, 79, 28, 22, 83, 28, 50, 85, 28, 63, 164, 28, 16, 79, 29, 29, 83, 29, 29, 85, 29, 29, 164, 29, 29, 79, 29, 23, 83, 29, 49, 85, 29, 64, 164, 29, 17, 79, 30, 30, 83, 30, 30, 85, 30, 30, 164, 30, 30, 79, 30, 24, 83, 30, 48, 85, 30, 65, 164, 30, 18, 79, 31, 31, 83, 31, 31, 85, 31, 31, 164, 31, 31, 79, 31, 25, 83, 31, 51, 85, 31, 66, 164, 31, 19, 79, 32, 32, 83, 32, 32, 85, 32, 32, 164, 32, 32, 79, 32, 26, 83, 32, 52, 85, 32, 37, 164, 32, 20, 79, 33, 33, 83, 33, 33, 85, 33, 33, 164, 33, 33, 79, 33, 27, 83, 33, 53, 85, 33, 38, 164, 33, 21, 70, 34, 34, 170, 34, 34, 171, 34, 34, 170, 34, 34, 147, 34, 34, 70, 34, 39, 170, 34, 50, 171, 34, 50, 170, 34, 109, 147, 34, 110, 70, 35, 35, 170, 35, 35, 171, 35, 35, 170, 35, 35, 147, 35, 35, 70, 35, 40, 170, 35, 49, 171, 35, 49, 170, 35, 111, 147, 35, 112, 70, 36, 36, 170, 36, 36, 171, 36, 36, 170, 36, 36, 147, 36, 36, 70, 36, 41, 170, 36, 48, 171, 36, 48, 170, 36, 113, 147, 36, 114, 70, 37, 37, 170, 37, 37, 170, 37, 37, 171, 37, 37, 147, 37, 37, 70, 37, 42, 170, 37, 52, 170, 37, 115, 171, 37, 32, 147, 37, 116, 70, 38, 38, 170, 38, 38, 170, 38, 38, 171, 38, 38, 147, 38, 38, 70, 38, 43, 170, 38, 53, 170, 38, 51, 171, 38, 33, 147, 38, 117, 86, 39, 39, 156, 39, 39, 152, 39, 39, 86, 39, 22, 156, 39, 34, 152, 39, 50, 86, 40, 40, 156, 40, 40, 152, 40, 40, 86, 40, 23, 156, 40, 35, 152, 40, 49, 86, 41, 41, 156, 41, 41, 152, 41, 41, 86, 41, 24, 156, 41, 36, 152, 41, 48, 86, 42, 42, 156, 42, 42, 152, 42, 42, 86, 42, 25, 156, 42, 37, 152, 42, 54, 86, 43, 43, 156, 43, 43, 152, 43, 43, 86, 43, 26, 156, 43, 38, 152, 43, 55, 86, 44, 44, 156, 44, 44, 152, 44, 44, 86, 44, 27, 156, 44, 45, 152, 44, 56, 70, 45, 45, 77, 45, 45, 71, 45, 45, 3, 45, 45, 72, 45, 45, 56, 45, 45, 20, 45, 45, 23, 45, 45, 57, 45, 45, 36, 45, 45, 37, 45, 45, 39, 45, 45, 40, 45, 45, 44, 45, 45, 24, 45, 45, 167, 45, 45, 98, 45, 45, 70, 45, 44, 77, 45, 56, 71, 45, 6, 3, 45, 73, 72, 45, 101, 56, 45, 87, 20, 45, 87, 23, 45, 87, 57, 45, 118, 36, 45, 119, 37, 45, 119, 39, 45, 119, 40, 45, 119, 44, 45, 68, 24, 45, 120, 167, 45, 62, 98, 45, 121, 77, 46, 46, 151, 46, 46, 92, 46, 46, 77, 46, 55, 151, 46, 4, 92, 46, 122, 77, 47, 47, 151, 47, 47, 92, 47, 47, 77, 47, 54, 151, 47, 5, 92, 47, 123, 4, 48, 48, 4, 48, 48, 66, 48, 48, 84, 48, 48, 85, 48, 48, 166, 48, 48, 169, 48, 48, 4, 48, 19, 4, 48, 18, 66, 48, 41, 84, 48, 36, 85, 48, 36, 166, 48, 15, 169, 48, 30, 4, 49, 49, 4, 49, 49, 66, 49, 49, 84, 49, 49, 85, 49, 49, 166, 49, 49, 169, 49, 49, 4, 49, 20, 4, 49, 17, 66, 49, 40, 84, 49, 35, 85, 49, 35, 166, 49, 14, 169, 49, 29, 4, 50, 50, 4, 50, 50, 66, 50, 50, 84, 50, 50, 85, 50, 50, 166, 50, 50, 169, 50, 50, 4, 50, 21, 4, 50, 16, 66, 50, 39, 84, 50, 34, 85, 50, 34, 166, 50, 13, 169, 50, 28, 84, 51, 51, 169, 51, 51, 84, 51, 38, 169, 51, 31, 84, 52, 52, 169, 52, 52, 84, 52, 37, 169, 52, 32, 84, 53, 53, 169, 53, 53, 84, 53, 38, 169, 53, 33, 82, 54, 54, 66, 54, 54, 72, 54, 54, 44, 54, 54, 163, 54, 54, 139, 54, 54, 82, 54, 10, 66, 54, 42, 72, 54, 103, 44, 54, 124, 163, 54, 47, 139, 54, 75, 82, 55, 55, 66, 55, 55, 72, 55, 55, 44, 55, 55, 163, 55, 55, 139, 55, 55, 82, 55, 11, 66, 55, 43, 72, 55, 104, 44, 55, 125, 163, 55, 46, 139, 55, 74, 82, 56, 56, 66, 56, 56, 72, 56, 56, 44, 56, 56, 163, 56, 56, 139, 56, 56, 82, 56, 12, 66, 56, 44, 72, 56, 102, 44, 56, 126, 163, 56, 45, 139, 56, 87, 17, 57, 57, 104, 57, 57, 109, 57, 57, 110, 57, 57, 112, 57, 57, 114, 57, 57, 116, 57, 57, 17, 57, 62, 104, 57, 127, 109, 57, 82, 110, 57, 82, 112, 57, 128, 114, 57, 129, 116, 57, 130, 32, 58, 58, 119, 58, 58, 120, 58, 58, 32, 58, 10, 119, 58, 131, 120, 58, 132, 73, 59, 59, 81, 59, 59, 151, 59, 59, 103, 59, 59, 73, 59, 102, 81, 59, 12, 151, 59, 6, 103, 59, 120, 73, 60, 60, 81, 60, 60, 151, 60, 60, 103, 60, 60, 73, 60, 104, 81, 60, 11, 151, 60, 7, 103, 60, 133, 73, 61, 61, 81, 61, 61, 151, 61, 61, 103, 61, 61, 73, 61, 103, 81, 61, 10, 151, 61, 8, 103, 61, 134, 73, 62, 62, 81, 62, 62, 151, 62, 62, 103, 62, 62, 73, 62, 101, 81, 62, 45, 151, 62, 9, 103, 62, 57, 83, 63, 63, 171, 63, 63, 100, 63, 63, 83, 63, 109, 171, 63, 28, 100, 63, 89, 83, 64, 64, 171, 64, 64, 100, 64, 64, 83, 64, 111, 171, 64, 29, 100, 64, 100, 83, 65, 65, 171, 65, 65, 100, 65, 65, 83, 65, 113, 171, 65, 30, 100, 65, 99, 83, 66, 66, 171, 66, 66, 100, 66, 66, 83, 66, 115, 171, 66, 31, 100, 66, 98, 50, 67, 67, 148, 67, 67, 114, 67, 67, 50, 67, 135, 148, 67, 136, 114, 67, 137, 42, 68, 68, 130, 68, 68, 42, 68, 119, 130, 68, 45, 71, 69, 69, 89, 69, 69, 94, 69, 69, 71, 69, 4, 89, 69, 0, 94, 69, 138, 71, 70, 70, 89, 70, 70, 94, 70, 70, 71, 70, 5, 89, 70, 1, 94, 70, 139, 71, 71, 71, 89, 71, 71, 94, 71, 71, 71, 71, 7, 89, 71, 2, 94, 71, 140, 71, 72, 72, 89, 72, 72, 94, 72, 72, 71, 72, 8, 89, 72, 3, 94, 72, 141, 71, 73, 73, 89, 73, 73, 94, 73, 73, 71, 73, 9, 89, 73, 45, 94, 73, 142, 53, 74, 74, 140, 74, 74, 142, 74, 74, 142, 74, 74, 106, 74, 74, 109, 74, 74, 110, 74, 74, 53, 74, 55, 140, 74, 143, 142, 74, 144, 142, 74, 76, 106, 74, 77, 109, 74, 78, 110, 74, 145, 53, 75, 75, 140, 75, 75, 142, 75, 75, 142, 75, 75, 106, 75, 75, 109, 75, 75, 110, 75, 75, 53, 75, 54, 140, 75, 146, 142, 75, 147, 142, 75, 79, 106, 75, 80, 109, 75, 81, 110, 75, 148, 56, 76, 76, 145, 76, 76, 143, 76, 76, 56, 76, 74, 145, 76, 149, 143, 76, 150, 20, 77, 77, 20, 77, 74, 23, 78, 78, 24, 78, 78, 23, 78, 74, 24, 78, 133, 56, 79, 79, 145, 79, 79, 143, 79, 79, 56, 79, 75, 145, 79, 151, 143, 79, 152, 20, 80, 80, 20, 80, 75, 23, 81, 81, 24, 81, 81, 23, 81, 75, 24, 81, 134, 23, 82, 82, 24, 82, 82, 23, 82, 57, 24, 82, 57, 57, 83, 83, 57, 83, 144, 57, 84, 84, 57, 84, 147, 50, 85, 85, 50, 85, 153, 50, 86, 86, 50, 86, 154, 53, 87, 87, 140, 87, 87, 142, 87, 87, 142, 87, 87, 106, 87, 87, 109, 87, 87, 110, 87, 87, 53, 87, 56, 140, 87, 155, 142, 87, 118, 142, 87, 45, 106, 87, 45, 109, 87, 45, 110, 87, 156, 32, 88, 88, 119, 88, 88, 120, 88, 88, 32, 88, 11, 119, 88, 157, 120, 88, 158, 14, 89, 89, 119, 89, 89, 14, 89, 63, 119, 89, 159, 36, 90, 90, 37, 90, 90, 36, 90, 160, 37, 90, 161, 36, 91, 91, 37, 91, 91, 36, 91, 161, 37, 91, 160, 39, 92, 92, 40, 92, 92, 39, 92, 160, 40, 92, 161, 39, 93, 93, 40, 93, 93, 39, 93, 161, 40, 93, 160, 42, 94, 94, 42, 94, 160, 36, 95, 95, 37, 95, 95, 36, 95, 162, 37, 95, 162, 39, 96, 96, 40, 96, 96, 39, 96, 162, 40, 96, 162, 42, 97, 97, 42, 97, 162, 14, 98, 98, 119, 98, 98, 14, 98, 66, 119, 98, 163, 14, 99, 99, 119, 99, 99, 14, 99, 65, 119, 99, 164, 14, 100, 100, 119, 100, 100, 14, 100, 64, 119, 100, 165, 68, 101, 101, 69, 101, 101, 159, 101, 101, 158, 101, 101, 68, 101, 0, 69, 101, 3, 159, 101, 62, 158, 101, 45, 68, 102, 102, 69, 102, 102, 159, 102, 102, 158, 102, 102, 68, 102, 3, 69, 102, 0, 159, 102, 59, 158, 102, 56, 68, 103, 103, 69, 103, 103, 159, 103, 103, 158, 103, 103, 68, 103, 1, 69, 103, 2, 159, 103, 61, 158, 103, 54, 68, 104, 104, 69, 104, 104, 159, 104, 104, 158, 104, 104, 68, 104, 2, 69, 104, 1, 159, 104, 60, 158, 104, 55, 32, 105, 105, 119, 105, 105, 120, 105, 105, 32, 105, 12, 119, 105, 166, 120, 105, 167, 45, 106, 106, 132, 106, 106, 45, 106, 13, 132, 106, 135, 45, 107, 107, 132, 107, 107, 45, 107, 14, 132, 107, 153, 45, 108, 108, 132, 108, 108, 45, 108, 15, 132, 108, 154, 84, 109, 109, 169, 109, 109, 84, 109, 34, 169, 109, 63, 61, 110, 110, 148, 110, 110, 128, 110, 110, 61, 110, 34, 148, 110, 168, 128, 110, 169, 84, 111, 111, 169, 111, 111, 84, 111, 35, 169, 111, 64, 61, 112, 112, 148, 112, 112, 128, 112, 112, 61, 112, 35, 148, 112, 170, 128, 112, 171, 84, 113, 113, 169, 113, 113, 84, 113, 36, 169, 113, 65, 61, 114, 114, 148, 114, 114, 128, 114, 114, 61, 114, 36, 148, 114, 172, 128, 114, 173, 84, 115, 115, 169, 115, 115, 84, 115, 37, 169, 115, 66, 61, 116, 116, 148, 116, 116, 128, 116, 116, 61, 116, 37, 148, 116, 174, 128, 116, 175, 61, 117, 117, 148, 117, 117, 128, 117, 117, 61, 117, 38, 148, 117, 176, 128, 117, 177, 56, 118, 118, 145, 118, 118, 143, 118, 118, 56, 118, 87, 145, 118, 178, 143, 118, 45, 34, 119, 119, 122, 119, 119, 123, 119, 119, 125, 119, 119, 126, 119, 119, 128, 119, 119, 34, 119, 166, 122, 119, 45, 123, 119, 45, 125, 119, 45, 126, 119, 45, 128, 119, 68, 17, 120, 120, 104, 120, 120, 109, 120, 120, 110, 120, 120, 112, 120, 120, 114, 120, 120, 116, 120, 120, 17, 120, 59, 104, 120, 179, 109, 120, 156, 110, 120, 45, 112, 120, 180, 114, 120, 181, 116, 120, 182, 12, 121, 121, 12, 121, 45, 6, 122, 122, 143, 122, 122, 6, 122, 46, 143, 122, 183, 6, 123, 123, 143, 123, 123, 6, 123, 47, 143, 123, 184, 42, 124, 124, 130, 124, 124, 42, 124, 132, 130, 124, 54, 42, 125, 125, 130, 125, 125, 42, 125, 158, 130, 125, 55, 42, 126, 126, 130, 126, 126, 42, 126, 167, 130, 126, 56, 18, 127, 127, 18, 127, 57, 26, 128, 128, 106, 128, 128, 26, 128, 57, 106, 128, 185, 28, 129, 129, 28, 129, 57, 30, 130, 130, 30, 130, 57, 33, 131, 131, 120, 131, 131, 33, 131, 58, 120, 131, 160, 34, 132, 132, 122, 132, 132, 123, 132, 132, 125, 132, 132, 126, 132, 132, 128, 132, 132, 34, 132, 58, 122, 132, 186, 123, 132, 186, 125, 132, 187, 126, 132, 187, 128, 132, 124, 17, 133, 133, 104, 133, 133, 109, 133, 133, 110, 133, 133, 112, 133, 133, 114, 133, 133, 116, 133, 133, 17, 133, 60, 104, 133, 188, 109, 133, 145, 110, 133, 78, 112, 133, 189, 114, 133, 190, 116, 133, 191, 17, 134, 134, 104, 134, 134, 109, 134, 134, 110, 134, 134, 112, 134, 134, 114, 134, 134, 116, 134, 134, 17, 134, 61, 104, 134, 192, 109, 134, 148, 110, 134, 81, 112, 134, 193, 114, 134, 194, 116, 134, 195, 46, 135, 135, 134, 135, 135, 136, 135, 135, 46, 135, 106, 134, 135, 196, 136, 135, 67, 62, 136, 136, 62, 136, 67, 28, 137, 137, 28, 137, 67, 8, 138, 138, 95, 138, 138, 8, 138, 69, 95, 138, 197, 8, 139, 139, 95, 139, 139, 8, 139, 70, 95, 139, 198, 8, 140, 140, 95, 140, 140, 8, 140, 71, 95, 140, 199, 8, 141, 141, 95, 141, 141, 8, 141, 72, 95, 141, 200, 8, 142, 142, 95, 142, 142, 8, 142, 73, 95, 142, 201, 54, 143, 143, 54, 143, 74, 56, 144, 144, 145, 144, 144, 143, 144, 144, 56, 144, 74, 145, 144, 202, 143, 144, 83, 23, 145, 145, 24, 145, 145, 23, 145, 133, 24, 145, 74, 54, 146, 146, 54, 146, 75, 56, 147, 147, 145, 147, 147, 143, 147, 147, 56, 147, 75, 145, 147, 203, 143, 147, 84, 23, 148, 148, 24, 148, 148, 23, 148, 134, 24, 148, 75, 59, 149, 149, 59, 149, 76, 57, 150, 150, 57, 150, 76, 59, 151, 151, 59, 151, 79, 57, 152, 152, 57, 152, 79, 46, 153, 153, 134, 153, 153, 136, 153, 153, 46, 153, 107, 134, 153, 204, 136, 153, 85, 46, 154, 154, 134, 154, 154, 136, 154, 154, 46, 154, 108, 134, 154, 205, 136, 154, 86, 54, 155, 155, 54, 155, 87, 23, 156, 156, 24, 156, 156, 23, 156, 120, 24, 156, 87, 33, 157, 157, 120, 157, 157, 33, 157, 88, 120, 157, 162, 34, 158, 158, 122, 158, 158, 123, 158, 158, 125, 158, 158, 126, 158, 158, 128, 158, 158, 34, 158, 88, 122, 158, 206, 123, 158, 206, 125, 158, 207, 126, 158, 207, 128, 158, 125, 33, 159, 159, 120, 159, 159, 33, 159, 89, 120, 159, 161, 34, 160, 160, 122, 160, 160, 123, 160, 160, 125, 160, 160, 126, 160, 160, 128, 160, 160, 34, 160, 131, 122, 160, 90, 123, 160, 91, 125, 160, 92, 126, 160, 93, 128, 160, 94, 34, 161, 161, 122, 161, 161, 123, 161, 161, 125, 161, 161, 126, 161, 161, 128, 161, 161, 34, 161, 159, 122, 161, 91, 123, 161, 90, 125, 161, 93, 126, 161, 92, 128, 161, 208, 34, 162, 162, 122, 162, 162, 123, 162, 162, 125, 162, 162, 126, 162, 162, 128, 162, 162, 34, 162, 157, 122, 162, 95, 123, 162, 95, 125, 162, 96, 126, 162, 96, 128, 162, 97, 33, 163, 163, 120, 163, 163, 33, 163, 98, 120, 163, 209, 33, 164, 164, 120, 164, 164, 33, 164, 99, 120, 164, 210, 33, 165, 165, 120, 165, 165, 33, 165, 100, 120, 165, 211, 33, 166, 166, 120, 166, 166, 33, 166, 105, 120, 166, 119, 34, 167, 167, 122, 167, 167, 123, 167, 167, 125, 167, 167, 126, 167, 167, 128, 167, 167, 34, 167, 105, 122, 167, 212, 123, 167, 212, 125, 167, 213, 126, 167, 213, 128, 167, 126, 62, 168, 168, 62, 168, 110, 42, 169, 169, 42, 169, 110, 62, 170, 170, 62, 170, 112, 42, 171, 171, 42, 171, 112, 62, 172, 172, 62, 172, 114, 42, 173, 173, 42, 173, 114, 62, 174, 174, 62, 174, 116, 42, 175, 175, 42, 175, 116, 62, 176, 176, 62, 176, 117, 42, 177, 177, 42, 177, 117, 59, 178, 178, 59, 178, 118, 18, 179, 179, 18, 179, 120, 26, 180, 180, 106, 180, 180, 26, 180, 120, 106, 180, 214, 28, 181, 181, 28, 181, 120, 30, 182, 182, 30, 182, 120, 57, 183, 183, 57, 183, 122, 57, 184, 184, 57, 184, 123, 20, 185, 185, 20, 185, 128, 36, 186, 186, 37, 186, 186, 36, 186, 132, 37, 186, 132, 39, 187, 187, 40, 187, 187, 39, 187, 132, 40, 187, 132, 18, 188, 188, 18, 188, 133, 26, 189, 189, 106, 189, 189, 26, 189, 133, 106, 189, 215, 28, 190, 190, 28, 190, 133, 30, 191, 191, 30, 191, 133, 18, 192, 192, 18, 192, 134, 26, 193, 193, 106, 193, 193, 26, 193, 134, 106, 193, 216, 28, 194, 194, 28, 194, 134, 30, 195, 195, 30, 195, 134, 48, 196, 196, 48, 196, 135, 9, 197, 197, 98, 197, 197, 9, 197, 138, 98, 197, 217, 9, 198, 198, 98, 198, 198, 9, 198, 139, 98, 198, 218, 9, 199, 199, 98, 199, 199, 9, 199, 140, 98, 199, 219, 9, 200, 200, 98, 200, 200, 9, 200, 141, 98, 200, 220, 9, 201, 201, 98, 201, 201, 9, 201, 142, 98, 201, 221, 59, 202, 202, 59, 202, 144, 59, 203, 203, 59, 203, 147, 48, 204, 204, 48, 204, 153, 48, 205, 205, 48, 205, 154, 36, 206, 206, 37, 206, 206, 36, 206, 158, 37, 206, 158, 39, 207, 207, 40, 207, 207, 39, 207, 158, 40, 207, 158, 42, 208, 208, 42, 208, 161, 34, 209, 209, 122, 209, 209, 123, 209, 209, 125, 209, 209, 126, 209, 209, 128, 209, 209, 34, 209, 163, 122, 209, 222, 123, 209, 223, 125, 209, 224, 126, 209, 225, 128, 209, 226, 34, 210, 210, 122, 210, 210, 123, 210, 210, 125, 210, 210, 126, 210, 210, 128, 210, 210, 34, 210, 164, 122, 210, 227, 123, 210, 227, 125, 210, 228, 126, 210, 228, 128, 210, 229, 34, 211, 211, 122, 211, 211, 123, 211, 211, 125, 211, 211, 126, 211, 211, 128, 211, 211, 34, 211, 165, 122, 211, 223, 123, 211, 222, 125, 211, 225, 126, 211, 224, 128, 211, 230, 36, 212, 212, 37, 212, 212, 36, 212, 167, 37, 212, 167, 39, 213, 213, 40, 213, 213, 39, 213, 167, 40, 213, 167, 20, 214, 214, 20, 214, 180, 20, 215, 215, 20, 215, 189, 20, 216, 216, 20, 216, 193, 12, 217, 217, 12, 217, 197, 12, 218, 218, 12, 218, 198, 12, 219, 219, 12, 219, 199, 12, 220, 220, 12, 220, 200, 12, 221, 221, 12, 221, 201, 36, 222, 222, 37, 222, 222, 36, 222, 209, 37, 222, 211, 36, 223, 223, 37, 223, 223, 36, 223, 211, 37, 223, 209, 39, 224, 224, 40, 224, 224, 39, 224, 209, 40, 224, 211, 39, 225, 225, 40, 225, 225, 39, 225, 211, 40, 225, 209, 42, 226, 226, 42, 226, 209, 36, 227, 227, 37, 227, 227, 36, 227, 210, 37, 227, 210, 39, 228, 228, 40, 228, 228, 39, 228, 210, 40, 228, 210, 42, 229, 229, 42, 229, 210, 42, 230, 230, 42, 230, 211)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(1, 23, 116, 2, 23, 117, 1, 24, 118, 2, 24, 119, 1, 25, 120, 2, 25, 121, 1, 26, 122, 2, 26, 123, 1, 27, 124, 2, 27, 125, 1, 28, 126, 2, 28, 127)), ncol=2+1, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(1), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 2: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=2
nb_c=359
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=231 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(3, 0, 0, 154, 0, 0, 155, 0, 0, 3, 0, 119, 154, 0, 147, 155, 0, 148, 3, 1, 1, 154, 1, 1, 155, 1, 1, 3, 1, 120, 154, 1, 149, 155, 1, 150, 3, 2, 2, 154, 2, 2, 155, 2, 2, 3, 2, 122, 154, 2, 151, 155, 2, 151, 3, 3, 3, 154, 3, 3, 155, 3, 3, 3, 3, 121, 154, 3, 152, 155, 3, 152, 3, 4, 4, 154, 4, 4, 155, 4, 4, 3, 4, 123, 154, 4, 150, 155, 4, 149, 3, 5, 5, 154, 5, 5, 155, 5, 5, 3, 5, 124, 154, 5, 148, 155, 5, 147, 65, 6, 6, 157, 6, 6, 65, 6, 97, 157, 6, 119, 65, 7, 7, 157, 7, 7, 65, 8, 8, 157, 8, 8, 157, 9, 9, 65, 9, 9, 157, 9, 120, 157, 10, 10, 65, 10, 10, 157, 10, 121, 65, 11, 11, 157, 11, 11, 65, 11, 107, 157, 12, 12, 65, 12, 12, 157, 12, 122, 157, 13, 13, 65, 13, 13, 157, 13, 123, 65, 14, 14, 157, 14, 14, 65, 14, 108, 65, 15, 15, 157, 15, 15, 65, 15, 109, 157, 15, 124, 157, 16, 16, 65, 16, 16, 157, 16, 125, 157, 17, 17, 65, 17, 17, 157, 17, 126, 65, 18, 18, 157, 18, 18, 65, 18, 110, 65, 19, 19, 157, 19, 19, 65, 19, 111, 157, 19, 127, 65, 20, 20, 157, 20, 20, 65, 20, 112, 157, 20, 128, 67, 21, 21, 168, 21, 21, 167, 21, 21, 118, 21, 21, 67, 21, 24, 168, 21, 104, 167, 21, 109, 118, 21, 153, 67, 22, 22, 168, 22, 22, 167, 22, 22, 118, 22, 22, 67, 22, 25, 168, 22, 105, 167, 22, 108, 118, 22, 154, 67, 23, 23, 168, 23, 23, 167, 23, 23, 118, 23, 23, 67, 23, 26, 168, 23, 106, 167, 23, 107, 118, 23, 155, 80, 24, 24, 153, 24, 24, 131, 24, 24, 80, 24, 100, 153, 24, 21, 131, 24, 156, 80, 25, 25, 153, 25, 25, 131, 25, 25, 80, 25, 99, 153, 25, 22, 131, 25, 157, 80, 26, 26, 153, 26, 26, 131, 26, 26, 80, 26, 98, 153, 26, 23, 131, 26, 158, 78, 27, 27, 90, 27, 27, 78, 27, 57, 90, 27, 100, 78, 28, 28, 90, 28, 28, 78, 28, 58, 90, 28, 99, 78, 29, 29, 90, 29, 29, 78, 29, 59, 90, 29, 98, 78, 30, 30, 90, 30, 30, 78, 30, 60, 78, 31, 31, 90, 31, 31, 78, 31, 61, 78, 32, 32, 90, 32, 32, 78, 32, 62, 78, 33, 33, 90, 33, 33, 78, 33, 63, 78, 34, 34, 90, 34, 34, 78, 34, 64, 78, 35, 35, 90, 35, 35, 78, 35, 65, 78, 36, 36, 90, 36, 36, 78, 36, 66, 90, 36, 98, 78, 37, 37, 90, 37, 37, 78, 37, 67, 78, 38, 38, 90, 38, 38, 78, 38, 68, 78, 39, 39, 90, 39, 39, 78, 39, 69, 78, 40, 40, 90, 40, 40, 78, 40, 70, 90, 40, 99, 78, 41, 41, 90, 41, 41, 78, 41, 71, 90, 41, 100, 165, 42, 42, 172, 42, 42, 1, 42, 42, 2, 42, 42, 165, 42, 57, 172, 42, 82, 165, 43, 43, 172, 43, 43, 1, 43, 43, 2, 43, 43, 165, 43, 58, 172, 43, 83, 165, 44, 44, 172, 44, 44, 1, 44, 44, 2, 44, 44, 165, 44, 59, 172, 44, 84, 165, 45, 45, 172, 45, 45, 1, 45, 45, 2, 45, 45, 165, 45, 60, 172, 45, 85, 165, 46, 46, 172, 46, 46, 1, 46, 46, 2, 46, 46, 165, 46, 61, 172, 46, 86, 165, 47, 47, 172, 47, 47, 1, 47, 47, 2, 47, 47, 165, 47, 62, 172, 47, 87, 165, 48, 48, 172, 48, 48, 1, 48, 48, 2, 48, 48, 165, 48, 63, 172, 48, 88, 165, 49, 49, 172, 49, 49, 1, 49, 49, 2, 49, 49, 165, 49, 64, 172, 49, 89, 165, 50, 50, 172, 50, 50, 1, 50, 50, 2, 50, 50, 165, 50, 65, 172, 50, 90, 165, 51, 51, 172, 51, 51, 1, 51, 51, 2, 51, 51, 165, 51, 66, 172, 51, 91, 165, 52, 52, 172, 52, 52, 1, 52, 52, 2, 52, 52, 165, 52, 67, 172, 52, 92, 165, 53, 53, 172, 53, 53, 1, 53, 53, 2, 53, 53, 165, 53, 68, 172, 53, 93, 165, 54, 54, 172, 54, 54, 1, 54, 54, 2, 54, 54, 165, 54, 69, 172, 54, 94, 165, 55, 55, 172, 55, 55, 1, 55, 55, 2, 55, 55, 165, 55, 70, 172, 55, 95, 165, 56, 56, 172, 56, 56, 1, 56, 56, 2, 56, 56, 165, 56, 71, 172, 56, 96, 79, 57, 57, 83, 57, 57, 85, 57, 57, 164, 57, 57, 79, 57, 42, 83, 57, 100, 85, 57, 113, 164, 57, 27, 79, 58, 58, 83, 58, 58, 85, 58, 58, 164, 58, 58, 79, 58, 43, 83, 58, 99, 85, 58, 114, 164, 58, 28, 79, 59, 59, 83, 59, 59, 85, 59, 59, 164, 59, 59, 79, 59, 44, 83, 59, 98, 85, 59, 115, 164, 59, 29, 79, 60, 60, 85, 60, 60, 164, 60, 60, 83, 60, 60, 79, 60, 45, 85, 60, 116, 164, 60, 30, 79, 61, 61, 85, 61, 61, 164, 61, 61, 83, 61, 61, 79, 61, 46, 85, 61, 117, 164, 61, 31, 79, 62, 62, 85, 62, 62, 164, 62, 62, 83, 62, 62, 79, 62, 47, 85, 62, 118, 164, 62, 32, 79, 63, 63, 164, 63, 63, 83, 63, 63, 85, 63, 63, 79, 63, 48, 164, 63, 33, 79, 64, 64, 164, 64, 64, 83, 64, 64, 85, 64, 64, 79, 64, 49, 164, 64, 34, 79, 65, 65, 164, 65, 65, 83, 65, 65, 85, 65, 65, 79, 65, 50, 164, 65, 35, 79, 66, 66, 83, 66, 66, 164, 66, 66, 85, 66, 66, 79, 66, 51, 83, 66, 101, 164, 66, 36, 79, 67, 67, 164, 67, 67, 83, 67, 67, 85, 67, 67, 79, 67, 52, 164, 67, 37, 79, 68, 68, 164, 68, 68, 83, 68, 68, 85, 68, 68, 79, 68, 53, 164, 68, 38, 79, 69, 69, 164, 69, 69, 83, 69, 69, 85, 69, 69, 79, 69, 54, 164, 69, 39, 79, 70, 70, 83, 70, 70, 164, 70, 70, 85, 70, 70, 79, 70, 55, 83, 70, 102, 164, 70, 40, 79, 71, 71, 83, 71, 71, 85, 71, 71, 164, 71, 71, 79, 71, 56, 83, 71, 103, 85, 71, 81, 164, 71, 41, 70, 72, 72, 170, 72, 72, 171, 72, 72, 170, 72, 72, 147, 72, 72, 70, 72, 82, 170, 72, 100, 171, 72, 100, 170, 72, 159, 147, 72, 160, 70, 73, 73, 170, 73, 73, 171, 73, 73, 170, 73, 73, 147, 73, 73, 70, 73, 83, 170, 73, 99, 171, 73, 99, 170, 73, 161, 147, 73, 162, 70, 74, 74, 170, 74, 74, 171, 74, 74, 170, 74, 74, 147, 74, 74, 70, 74, 84, 170, 74, 98, 171, 74, 98, 170, 74, 163, 147, 74, 164, 70, 75, 75, 170, 75, 75, 147, 75, 75, 170, 75, 75, 171, 75, 75, 70, 75, 85, 170, 75, 165, 147, 75, 166, 70, 76, 76, 170, 76, 76, 147, 76, 76, 170, 76, 76, 171, 76, 76, 70, 76, 86, 170, 76, 167, 147, 76, 168, 70, 77, 77, 170, 77, 77, 147, 77, 77, 170, 77, 77, 171, 77, 77, 70, 77, 87, 170, 77, 169, 147, 77, 170, 70, 78, 78, 170, 78, 78, 147, 78, 78, 170, 78, 78, 171, 78, 78, 70, 78, 88, 170, 78, 171, 147, 78, 172, 70, 79, 79, 170, 79, 79, 147, 79, 79, 170, 79, 79, 171, 79, 79, 70, 79, 89, 170, 79, 173, 147, 79, 174, 70, 80, 80, 170, 80, 80, 147, 80, 80, 170, 80, 80, 171, 80, 80, 70, 80, 90, 170, 80, 175, 147, 80, 176, 70, 81, 81, 170, 81, 81, 170, 81, 81, 171, 81, 81, 147, 81, 81, 70, 81, 91, 170, 81, 103, 170, 81, 177, 171, 81, 71, 147, 81, 178, 86, 82, 82, 156, 82, 82, 152, 82, 82, 86, 82, 42, 156, 82, 72, 152, 82, 100, 86, 83, 83, 156, 83, 83, 152, 83, 83, 86, 83, 43, 156, 83, 73, 152, 83, 99, 86, 84, 84, 156, 84, 84, 152, 84, 84, 86, 84, 44, 156, 84, 74, 152, 84, 98, 86, 85, 85, 156, 85, 85, 152, 85, 85, 86, 85, 45, 156, 85, 75, 86, 86, 86, 156, 86, 86, 152, 86, 86, 86, 86, 46, 156, 86, 76, 86, 87, 87, 156, 87, 87, 152, 87, 87, 86, 87, 47, 156, 87, 77, 86, 88, 88, 156, 88, 88, 152, 88, 88, 86, 88, 48, 156, 88, 78, 86, 89, 89, 156, 89, 89, 152, 89, 89, 86, 89, 49, 156, 89, 79, 86, 90, 90, 156, 90, 90, 152, 90, 90, 86, 90, 50, 156, 90, 80, 86, 91, 91, 156, 91, 91, 152, 91, 91, 86, 91, 51, 156, 91, 81, 152, 91, 104, 86, 92, 92, 156, 92, 92, 152, 92, 92, 86, 92, 52, 86, 93, 93, 156, 93, 93, 152, 93, 93, 86, 93, 53, 86, 94, 94, 156, 94, 94, 152, 94, 94, 86, 94, 54, 86, 95, 95, 152, 95, 95, 156, 95, 95, 86, 95, 55, 152, 95, 105, 86, 96, 96, 152, 96, 96, 156, 96, 96, 86, 96, 56, 152, 96, 106, 77, 97, 97, 151, 97, 97, 92, 97, 97, 77, 97, 104, 151, 97, 6, 92, 97, 179, 4, 98, 98, 4, 98, 98, 66, 98, 98, 84, 98, 98, 85, 98, 98, 166, 98, 98, 169, 98, 98, 4, 98, 36, 4, 98, 29, 66, 98, 84, 84, 98, 74, 85, 98, 74, 166, 98, 26, 169, 98, 59, 4, 99, 99, 4, 99, 99, 66, 99, 99, 84, 99, 99, 85, 99, 99, 166, 99, 99, 169, 99, 99, 4, 99, 40, 4, 99, 28, 66, 99, 83, 84, 99, 73, 85, 99, 73, 166, 99, 25, 169, 99, 58, 4, 100, 100, 4, 100, 100, 66, 100, 100, 84, 100, 100, 85, 100, 100, 166, 100, 100, 169, 100, 100, 4, 100, 41, 4, 100, 27, 66, 100, 82, 84, 100, 72, 85, 100, 72, 166, 100, 24, 169, 100, 57, 169, 101, 101, 84, 101, 101, 169, 101, 66, 169, 102, 102, 84, 102, 102, 169, 102, 70, 84, 103, 103, 169, 103, 103, 84, 103, 81, 169, 103, 71, 82, 104, 104, 66, 104, 104, 72, 104, 104, 44, 104, 104, 163, 104, 104, 139, 104, 104, 82, 104, 21, 66, 104, 91, 72, 104, 152, 44, 104, 180, 163, 104, 97, 139, 104, 129, 82, 105, 105, 66, 105, 105, 72, 105, 105, 44, 105, 105, 139, 105, 105, 163, 105, 105, 82, 105, 22, 66, 105, 95, 72, 105, 150, 44, 105, 181, 139, 105, 138, 82, 106, 106, 66, 106, 106, 72, 106, 106, 44, 106, 106, 139, 106, 106, 163, 106, 106, 82, 106, 23, 66, 106, 96, 72, 106, 148, 44, 106, 182, 139, 106, 137, 73, 107, 107, 81, 107, 107, 151, 107, 107, 103, 107, 107, 73, 107, 148, 81, 107, 23, 151, 107, 11, 103, 107, 183, 73, 108, 108, 81, 108, 108, 151, 108, 108, 103, 108, 108, 73, 108, 150, 81, 108, 22, 151, 108, 14, 103, 108, 184, 73, 109, 109, 81, 109, 109, 151, 109, 109, 103, 109, 109, 73, 109, 152, 81, 109, 21, 151, 109, 15, 103, 109, 185, 73, 110, 110, 151, 110, 110, 103, 110, 110, 81, 110, 110, 73, 110, 151, 151, 110, 18, 103, 110, 186, 73, 111, 111, 151, 111, 111, 103, 111, 111, 81, 111, 111, 73, 111, 149, 151, 111, 19, 103, 111, 187, 73, 112, 112, 151, 112, 112, 103, 112, 112, 81, 112, 112, 73, 112, 147, 151, 112, 20, 103, 112, 188, 83, 113, 113, 171, 113, 113, 100, 113, 113, 83, 113, 159, 171, 113, 57, 100, 113, 189, 83, 114, 114, 171, 114, 114, 100, 114, 114, 83, 114, 161, 171, 114, 58, 100, 114, 190, 83, 115, 115, 171, 115, 115, 100, 115, 115, 83, 115, 163, 171, 115, 59, 100, 115, 146, 83, 116, 116, 171, 116, 116, 100, 116, 116, 83, 116, 165, 171, 116, 60, 100, 116, 191, 83, 117, 117, 171, 117, 117, 100, 117, 117, 83, 117, 167, 171, 117, 61, 100, 117, 145, 83, 118, 118, 171, 118, 118, 100, 118, 118, 83, 118, 169, 171, 118, 62, 100, 118, 144, 71, 119, 119, 89, 119, 119, 94, 119, 119, 71, 119, 6, 89, 119, 0, 94, 119, 192, 71, 120, 120, 89, 120, 120, 94, 120, 120, 71, 120, 9, 89, 120, 1, 94, 120, 193, 71, 121, 121, 89, 121, 121, 94, 121, 121, 71, 121, 10, 89, 121, 3, 94, 121, 194, 71, 122, 122, 89, 122, 122, 94, 122, 122, 71, 122, 12, 89, 122, 2, 94, 122, 195, 71, 123, 123, 89, 123, 123, 94, 123, 123, 71, 123, 13, 89, 123, 4, 94, 123, 196, 71, 124, 124, 89, 124, 124, 94, 124, 124, 71, 124, 15, 89, 124, 5, 94, 124, 197, 71, 125, 125, 94, 125, 125, 89, 125, 125, 71, 125, 16, 94, 125, 198, 71, 126, 126, 94, 126, 126, 89, 126, 126, 71, 126, 17, 94, 126, 199, 71, 127, 127, 94, 127, 127, 89, 127, 127, 71, 127, 19, 94, 127, 200, 71, 128, 128, 94, 128, 128, 89, 128, 128, 71, 128, 20, 94, 128, 201, 53, 129, 129, 140, 129, 129, 142, 129, 129, 142, 129, 129, 106, 129, 129, 109, 129, 129, 110, 129, 129, 53, 129, 104, 140, 129, 202, 142, 129, 203, 142, 129, 130, 106, 129, 131, 109, 129, 132, 110, 129, 204, 56, 130, 130, 145, 130, 130, 143, 130, 130, 56, 130, 129, 145, 130, 205, 143, 130, 206, 20, 131, 131, 20, 131, 129, 23, 132, 132, 24, 132, 132, 23, 132, 129, 24, 132, 185, 24, 133, 133, 23, 133, 133, 24, 133, 187, 24, 134, 134, 23, 134, 134, 24, 134, 188, 57, 135, 135, 57, 135, 203, 50, 136, 136, 50, 136, 207, 53, 137, 137, 140, 137, 137, 142, 137, 137, 110, 137, 137, 142, 137, 137, 106, 137, 137, 109, 137, 137, 53, 137, 106, 140, 137, 208, 142, 137, 209, 110, 137, 210, 53, 138, 138, 140, 138, 138, 142, 138, 138, 110, 138, 138, 142, 138, 138, 106, 138, 138, 109, 138, 138, 53, 138, 105, 140, 138, 211, 142, 138, 212, 110, 138, 213, 36, 139, 139, 37, 139, 139, 36, 139, 214, 37, 139, 215, 36, 140, 140, 37, 140, 140, 36, 140, 215, 37, 140, 214, 39, 141, 141, 40, 141, 141, 39, 141, 214, 40, 141, 215, 39, 142, 142, 40, 142, 142, 39, 142, 215, 40, 142, 214, 42, 143, 143, 42, 143, 214, 14, 144, 144, 119, 144, 144, 14, 144, 118, 119, 144, 216, 14, 145, 145, 119, 145, 145, 14, 145, 117, 119, 145, 217, 14, 146, 146, 119, 146, 146, 14, 146, 115, 119, 146, 218, 68, 147, 147, 69, 147, 147, 159, 147, 147, 158, 147, 147, 68, 147, 0, 69, 147, 5, 159, 147, 112, 68, 148, 148, 69, 148, 148, 159, 148, 148, 158, 148, 148, 68, 148, 5, 69, 148, 0, 159, 148, 107, 158, 148, 106, 68, 149, 149, 69, 149, 149, 159, 149, 149, 158, 149, 149, 68, 149, 1, 69, 149, 4, 159, 149, 111, 68, 150, 150, 69, 150, 150, 159, 150, 150, 158, 150, 150, 68, 150, 4, 69, 150, 1, 159, 150, 108, 158, 150, 105, 68, 151, 151, 69, 151, 151, 159, 151, 151, 158, 151, 151, 68, 151, 2, 69, 151, 2, 159, 151, 110, 68, 152, 152, 69, 152, 152, 159, 152, 152, 158, 152, 152, 68, 152, 3, 69, 152, 3, 159, 152, 109, 158, 152, 104, 32, 153, 153, 119, 153, 153, 120, 153, 153, 32, 153, 21, 119, 153, 219, 120, 153, 220, 32, 154, 154, 119, 154, 154, 120, 154, 154, 32, 154, 22, 119, 154, 221, 120, 154, 222, 32, 155, 155, 119, 155, 155, 120, 155, 155, 32, 155, 23, 119, 155, 223, 120, 155, 224, 45, 156, 156, 132, 156, 156, 45, 156, 24, 132, 156, 225, 45, 157, 157, 132, 157, 157, 45, 157, 25, 132, 157, 226, 45, 158, 158, 132, 158, 158, 45, 158, 26, 132, 158, 207, 84, 159, 159, 169, 159, 159, 84, 159, 72, 169, 159, 113, 61, 160, 160, 148, 160, 160, 128, 160, 160, 61, 160, 72, 148, 160, 227, 128, 160, 228, 84, 161, 161, 169, 161, 161, 84, 161, 73, 169, 161, 114, 61, 162, 162, 148, 162, 162, 128, 162, 162, 61, 162, 73, 148, 162, 229, 128, 162, 230, 84, 163, 163, 169, 163, 163, 84, 163, 74, 169, 163, 115, 61, 164, 164, 148, 164, 164, 128, 164, 164, 61, 164, 74, 148, 164, 231, 128, 164, 232, 84, 165, 165, 169, 165, 165, 84, 165, 75, 169, 165, 116, 61, 166, 166, 148, 166, 166, 128, 166, 166, 61, 166, 75, 148, 166, 233, 128, 166, 234, 84, 167, 167, 169, 167, 167, 84, 167, 76, 169, 167, 117, 61, 168, 168, 148, 168, 168, 128, 168, 168, 61, 168, 76, 148, 168, 235, 128, 168, 236, 84, 169, 169, 169, 169, 169, 84, 169, 77, 169, 169, 118, 61, 170, 170, 148, 170, 170, 128, 170, 170, 61, 170, 77, 148, 170, 237, 128, 170, 238, 84, 171, 171, 169, 171, 171, 84, 171, 78, 61, 172, 172, 148, 172, 172, 128, 172, 172, 61, 172, 78, 148, 172, 239, 128, 172, 240, 84, 173, 173, 169, 173, 173, 84, 173, 79, 61, 174, 174, 148, 174, 174, 128, 174, 174, 61, 174, 79, 148, 174, 241, 128, 174, 242, 84, 175, 175, 169, 175, 175, 84, 175, 80, 61, 176, 176, 148, 176, 176, 128, 176, 176, 61, 176, 80, 148, 176, 243, 128, 176, 244, 84, 177, 177, 169, 177, 177, 84, 177, 81, 61, 178, 178, 148, 178, 178, 128, 178, 178, 61, 178, 81, 148, 178, 245, 128, 178, 246, 6, 179, 179, 143, 179, 179, 6, 179, 97, 143, 179, 247, 42, 180, 180, 130, 180, 180, 42, 180, 220, 130, 180, 104, 42, 181, 181, 130, 181, 181, 42, 181, 222, 130, 181, 105, 42, 182, 182, 130, 182, 182, 42, 182, 224, 130, 182, 106, 17, 183, 183, 104, 183, 183, 109, 183, 183, 112, 183, 183, 114, 183, 183, 116, 183, 183, 110, 183, 183, 17, 183, 107, 104, 183, 248, 109, 183, 210, 112, 183, 249, 114, 183, 250, 116, 183, 251, 17, 184, 184, 104, 184, 184, 109, 184, 184, 112, 184, 184, 114, 184, 184, 116, 184, 184, 110, 184, 184, 17, 184, 108, 104, 184, 252, 109, 184, 213, 112, 184, 253, 114, 184, 254, 116, 184, 255, 17, 185, 185, 104, 185, 185, 109, 185, 185, 110, 185, 185, 112, 185, 185, 114, 185, 185, 116, 185, 185, 17, 185, 109, 104, 185, 256, 109, 185, 204, 110, 185, 132, 112, 185, 257, 114, 185, 258, 116, 185, 259, 17, 186, 186, 104, 186, 186, 109, 186, 186, 112, 186, 186, 114, 186, 186, 116, 186, 186, 110, 186, 186, 17, 186, 110, 104, 186, 260, 109, 186, 261, 112, 186, 262, 114, 186, 263, 116, 186, 264, 17, 187, 187, 104, 187, 187, 109, 187, 187, 110, 187, 187, 112, 187, 187, 114, 187, 187, 116, 187, 187, 17, 187, 111, 104, 187, 265, 109, 187, 266, 110, 187, 133, 112, 187, 267, 114, 187, 268, 116, 187, 269, 17, 188, 188, 104, 188, 188, 109, 188, 188, 110, 188, 188, 112, 188, 188, 114, 188, 188, 116, 188, 188, 17, 188, 112, 104, 188, 270, 109, 188, 271, 110, 188, 134, 112, 188, 272, 114, 188, 273, 116, 188, 274, 14, 189, 189, 119, 189, 189, 14, 189, 113, 119, 189, 275, 14, 190, 190, 119, 190, 190, 14, 190, 114, 119, 190, 276, 14, 191, 191, 119, 191, 191, 14, 191, 116, 119, 191, 277, 8, 192, 192, 95, 192, 192, 8, 192, 119, 95, 192, 278, 8, 193, 193, 95, 193, 193, 8, 193, 120, 95, 193, 279, 8, 194, 194, 95, 194, 194, 8, 194, 121, 95, 194, 280, 8, 195, 195, 95, 195, 195, 8, 195, 122, 95, 195, 281, 8, 196, 196, 95, 196, 196, 8, 196, 123, 95, 196, 282, 8, 197, 197, 95, 197, 197, 8, 197, 124, 95, 197, 283, 8, 198, 198, 95, 198, 198, 8, 198, 125, 95, 198, 284, 8, 199, 199, 95, 199, 199, 8, 199, 126, 95, 199, 285, 8, 200, 200, 95, 200, 200, 8, 200, 127, 95, 200, 286, 8, 201, 201, 95, 201, 201, 8, 201, 128, 95, 201, 287, 54, 202, 202, 54, 202, 129, 56, 203, 203, 145, 203, 203, 143, 203, 203, 56, 203, 129, 145, 203, 288, 143, 203, 135, 23, 204, 204, 24, 204, 204, 23, 204, 185, 24, 204, 129, 59, 205, 205, 59, 205, 130, 57, 206, 206, 57, 206, 130, 46, 207, 207, 134, 207, 207, 136, 207, 207, 46, 207, 158, 134, 207, 289, 136, 207, 136, 54, 208, 208, 54, 208, 137, 56, 209, 209, 145, 209, 209, 143, 209, 209, 56, 209, 137, 145, 209, 290, 23, 210, 210, 24, 210, 210, 23, 210, 183, 24, 210, 137, 54, 211, 211, 54, 211, 138, 56, 212, 212, 145, 212, 212, 143, 212, 212, 56, 212, 138, 145, 212, 291, 23, 213, 213, 24, 213, 213, 23, 213, 184, 24, 213, 138, 34, 214, 214, 122, 214, 214, 123, 214, 214, 125, 214, 214, 126, 214, 214, 128, 214, 214, 34, 214, 219, 122, 214, 139, 123, 214, 140, 125, 214, 141, 126, 214, 142, 128, 214, 143, 34, 215, 215, 122, 215, 215, 123, 215, 215, 125, 215, 215, 126, 215, 215, 128, 215, 215, 34, 215, 292, 122, 215, 140, 123, 215, 139, 125, 215, 142, 126, 215, 141, 128, 215, 293, 33, 216, 216, 120, 216, 216, 33, 216, 144, 120, 216, 294, 33, 217, 217, 120, 217, 217, 33, 217, 145, 120, 217, 295, 33, 218, 218, 120, 218, 218, 33, 218, 146, 120, 218, 296, 33, 219, 219, 120, 219, 219, 33, 219, 153, 120, 219, 214, 34, 220, 220, 122, 220, 220, 123, 220, 220, 125, 220, 220, 126, 220, 220, 128, 220, 220, 34, 220, 153, 122, 220, 297, 123, 220, 297, 125, 220, 298, 126, 220, 298, 128, 220, 180, 33, 221, 221, 120, 221, 221, 33, 221, 154, 120, 221, 299, 34, 222, 222, 122, 222, 222, 123, 222, 222, 125, 222, 222, 126, 222, 222, 128, 222, 222, 34, 222, 154, 122, 222, 300, 123, 222, 300, 125, 222, 301, 126, 222, 301, 128, 222, 181, 33, 223, 223, 120, 223, 223, 33, 223, 155, 120, 223, 302, 34, 224, 224, 122, 224, 224, 123, 224, 224, 125, 224, 224, 126, 224, 224, 128, 224, 224, 34, 224, 155, 122, 224, 303, 123, 224, 303, 125, 224, 304, 126, 224, 304, 128, 224, 182, 46, 225, 225, 134, 225, 225, 136, 225, 225, 46, 225, 156, 134, 225, 305, 46, 226, 226, 134, 226, 226, 136, 226, 226, 46, 226, 157, 134, 226, 306, 62, 227, 227, 62, 227, 160, 42, 228, 228, 42, 228, 160, 62, 229, 229, 62, 229, 162, 42, 230, 230, 42, 230, 162, 62, 231, 231, 62, 231, 164, 42, 232, 232, 42, 232, 164, 62, 233, 233, 62, 233, 166, 42, 234, 234, 42, 234, 166, 62, 235, 235, 62, 235, 168, 42, 236, 236, 42, 236, 168, 62, 237, 237, 62, 237, 170, 42, 238, 238, 42, 238, 170, 62, 239, 239, 62, 239, 172, 42, 240, 240, 42, 240, 172, 62, 241, 241, 62, 241, 174, 42, 242, 242, 42, 242, 174, 62, 243, 243, 62, 243, 176, 42, 244, 244, 42, 244, 176, 62, 245, 245, 62, 245, 178, 42, 246, 246, 42, 246, 178, 57, 247, 247, 57, 247, 179, 18, 248, 248, 18, 248, 183, 26, 249, 249, 106, 249, 249, 26, 249, 183, 106, 249, 307, 28, 250, 250, 28, 250, 183, 30, 251, 251, 30, 251, 183, 18, 252, 252, 18, 252, 184, 26, 253, 253, 106, 253, 253, 26, 253, 184, 106, 253, 308, 28, 254, 254, 28, 254, 184, 30, 255, 255, 30, 255, 184, 18, 256, 256, 18, 256, 185, 26, 257, 257, 106, 257, 257, 26, 257, 185, 106, 257, 309, 28, 258, 258, 28, 258, 185, 30, 259, 259, 30, 259, 185, 18, 260, 260, 18, 260, 186, 23, 261, 261, 24, 261, 261, 23, 261, 186, 26, 262, 262, 106, 262, 262, 26, 262, 186, 106, 262, 310, 28, 263, 263, 28, 263, 186, 30, 264, 264, 30, 264, 186, 18, 265, 265, 18, 265, 187, 23, 266, 266, 24, 266, 266, 23, 266, 187, 26, 267, 267, 106, 267, 267, 26, 267, 187, 106, 267, 311, 28, 268, 268, 28, 268, 187, 30, 269, 269, 30, 269, 187, 18, 270, 270, 18, 270, 188, 23, 271, 271, 24, 271, 271, 23, 271, 188, 26, 272, 272, 106, 272, 272, 26, 272, 188, 106, 272, 312, 28, 273, 273, 28, 273, 188, 30, 274, 274, 30, 274, 188, 33, 275, 275, 120, 275, 275, 33, 275, 189, 120, 275, 313, 33, 276, 276, 120, 276, 276, 33, 276, 190, 120, 276, 314, 33, 277, 277, 120, 277, 277, 33, 277, 191, 120, 277, 315, 9, 278, 278, 98, 278, 278, 9, 278, 192, 98, 278, 316, 9, 279, 279, 98, 279, 279, 9, 279, 193, 98, 279, 317, 9, 280, 280, 98, 280, 280, 9, 280, 194, 98, 280, 318, 9, 281, 281, 98, 281, 281, 9, 281, 195, 98, 281, 319, 9, 282, 282, 98, 282, 282, 9, 282, 196, 98, 282, 320, 9, 283, 283, 98, 283, 283, 9, 283, 197, 98, 283, 321, 9, 284, 284, 98, 284, 284, 9, 284, 198, 98, 284, 322, 9, 285, 285, 98, 285, 285, 9, 285, 199, 98, 285, 323, 9, 286, 286, 98, 286, 286, 9, 286, 200, 98, 286, 324, 9, 287, 287, 98, 287, 287, 9, 287, 201, 98, 287, 325, 59, 288, 288, 59, 288, 203, 48, 289, 289, 48, 289, 207, 59, 290, 290, 59, 290, 209, 59, 291, 291, 59, 291, 212, 120, 292, 292, 33, 292, 292, 120, 292, 215, 42, 293, 293, 42, 293, 215, 34, 294, 294, 122, 294, 294, 123, 294, 294, 125, 294, 294, 126, 294, 294, 128, 294, 294, 34, 294, 216, 122, 294, 326, 123, 294, 327, 125, 294, 328, 126, 294, 329, 128, 294, 330, 34, 295, 295, 122, 295, 295, 123, 295, 295, 125, 295, 295, 126, 295, 295, 128, 295, 295, 34, 295, 217, 122, 295, 331, 123, 295, 331, 125, 295, 332, 126, 295, 332, 128, 295, 333, 34, 296, 296, 122, 296, 296, 123, 296, 296, 125, 296, 296, 126, 296, 296, 128, 296, 296, 34, 296, 218, 122, 296, 327, 123, 296, 326, 125, 296, 329, 126, 296, 328, 128, 296, 334, 36, 297, 297, 37, 297, 297, 36, 297, 220, 37, 297, 220, 39, 298, 298, 40, 298, 298, 39, 298, 220, 40, 298, 220, 34, 299, 299, 122, 299, 299, 123, 299, 299, 125, 299, 299, 126, 299, 299, 128, 299, 299, 34, 299, 221, 36, 300, 300, 37, 300, 300, 36, 300, 222, 37, 300, 222, 39, 301, 301, 40, 301, 301, 39, 301, 222, 40, 301, 222, 34, 302, 302, 122, 302, 302, 123, 302, 302, 125, 302, 302, 126, 302, 302, 128, 302, 302, 34, 302, 223, 36, 303, 303, 37, 303, 303, 36, 303, 224, 37, 303, 224, 39, 304, 304, 40, 304, 304, 39, 304, 224, 40, 304, 224, 48, 305, 305, 48, 305, 225, 48, 306, 306, 48, 306, 226, 20, 307, 307, 20, 307, 249, 20, 308, 308, 20, 308, 253, 20, 309, 309, 20, 309, 257, 20, 310, 310, 20, 310, 262, 20, 311, 311, 20, 311, 267, 20, 312, 312, 20, 312, 272, 34, 313, 313, 122, 313, 313, 123, 313, 313, 125, 313, 313, 126, 313, 313, 128, 313, 313, 34, 313, 275, 122, 313, 335, 123, 313, 336, 125, 313, 337, 126, 313, 338, 128, 313, 339, 34, 314, 314, 122, 314, 314, 123, 314, 314, 125, 314, 314, 126, 314, 314, 128, 314, 314, 34, 314, 276, 122, 314, 340, 123, 314, 341, 125, 314, 342, 126, 314, 343, 128, 314, 344, 34, 315, 315, 122, 315, 315, 123, 315, 315, 125, 315, 315, 126, 315, 315, 128, 315, 315, 34, 315, 277, 122, 315, 345, 123, 315, 346, 125, 315, 347, 126, 315, 348, 128, 315, 349, 12, 316, 316, 12, 316, 278, 12, 317, 317, 12, 317, 279, 12, 318, 318, 12, 318, 280, 12, 319, 319, 12, 319, 281, 12, 320, 320, 12, 320, 282, 12, 321, 321, 12, 321, 283, 12, 322, 322, 12, 322, 284, 12, 323, 323, 12, 323, 285, 12, 324, 324, 12, 324, 286, 12, 325, 325, 12, 325, 287, 36, 326, 326, 37, 326, 326, 36, 326, 294, 37, 326, 296, 36, 327, 327, 37, 327, 327, 36, 327, 296, 37, 327, 294, 39, 328, 328, 40, 328, 328, 39, 328, 294, 40, 328, 296, 39, 329, 329, 40, 329, 329, 39, 329, 296, 40, 329, 294, 42, 330, 330, 42, 330, 294, 36, 331, 331, 37, 331, 331, 36, 331, 295, 37, 331, 295, 39, 332, 332, 40, 332, 332, 39, 332, 295, 40, 332, 295, 42, 333, 333, 42, 333, 295, 42, 334, 334, 42, 334, 296, 36, 335, 335, 37, 335, 335, 36, 335, 313, 37, 335, 350, 36, 336, 336, 37, 336, 336, 36, 336, 350, 37, 336, 313, 39, 337, 337, 40, 337, 337, 39, 337, 313, 40, 337, 350, 39, 338, 338, 40, 338, 338, 39, 338, 350, 40, 338, 313, 42, 339, 339, 42, 339, 313, 36, 340, 340, 37, 340, 340, 36, 340, 314, 37, 340, 351, 36, 341, 341, 37, 341, 341, 36, 341, 351, 37, 341, 314, 39, 342, 342, 40, 342, 342, 39, 342, 314, 40, 342, 351, 39, 343, 343, 40, 343, 343, 39, 343, 351, 40, 343, 314, 42, 344, 344, 42, 344, 314, 36, 345, 345, 37, 345, 345, 36, 345, 315, 37, 345, 352, 36, 346, 346, 37, 346, 346, 36, 346, 352, 37, 346, 315, 39, 347, 347, 40, 347, 347, 39, 347, 315, 40, 347, 352, 39, 348, 348, 40, 348, 348, 39, 348, 352, 40, 348, 315, 42, 349, 349, 42, 349, 315, 34, 350, 350, 122, 350, 350, 123, 350, 350, 125, 350, 350, 126, 350, 350, 128, 350, 350, 34, 350, 353, 122, 350, 336, 123, 350, 335, 125, 350, 338, 126, 350, 337, 128, 350, 354, 34, 351, 351, 122, 351, 351, 123, 351, 351, 125, 351, 351, 126, 351, 351, 128, 351, 351, 34, 351, 355, 122, 351, 341, 123, 351, 340, 125, 351, 343, 126, 351, 342, 128, 351, 356, 34, 352, 352, 122, 352, 352, 123, 352, 352, 125, 352, 352, 126, 352, 352, 128, 352, 352, 34, 352, 357, 122, 352, 346, 123, 352, 345, 125, 352, 348, 126, 352, 347, 128, 352, 358, 120, 353, 353, 33, 353, 353, 120, 353, 350, 42, 354, 354, 42, 354, 350, 120, 355, 355, 33, 355, 355, 120, 355, 351, 42, 356, 356, 42, 356, 351, 120, 357, 357, 33, 357, 357, 120, 357, 352, 42, 358, 358, 42, 358, 352)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(65, 8, 174, 187, 157, 8, 197, 173, 65, 9, 175, 187, 157, 9, 198, 173, 65, 10, 174, 188, 65, 11, 175, 188, 157, 12, 199, 173, 65, 13, 174, 189, 65, 14, 175, 189, 157, 15, 200, 173, 65, 17, 174, 190, 65, 18, 175, 190, 157, 19, 201, 173, 90, 31, 176, 178, 90, 32, 176, 177, 90, 33, 176, 176, 90, 34, 177, 178, 90, 35, 177, 177, 90, 36, 177, 176, 90, 38, 178, 178, 90, 39, 178, 177, 90, 40, 178, 176, 1, 43, 86, 1, 2, 43, 87, 1, 1, 44, 88, 1, 2, 44, 89, 1, 1, 45, 90, 1, 2, 45, 91, 1, 1, 46, 92, 1, 2, 46, 93, 1, 1, 47, 94, 1, 2, 47, 95, 1, 1, 48, 96, 1, 2, 48, 97, 1, 1, 49, 98, 1, 2, 49, 99, 1, 1, 50, 100, 1, 2, 50, 101, 1, 1, 51, 102, 1, 2, 51, 103, 1, 1, 52, 104, 1, 2, 52, 105, 1, 1, 53, 106, 1, 2, 53, 107, 1, 1, 54, 108, 1, 2, 54, 109, 1, 1, 55, 110, 1, 2, 55, 111, 1, 1, 56, 112, 1, 2, 56, 113, 1, 1, 57, 114, 1, 2, 57, 115, 1, 83, 61, 178, 179, 83, 62, 177, 179, 83, 63, 176, 179, 83, 64, 178, 180, 85, 64, 165, 191, 83, 65, 177, 180, 85, 65, 165, 192, 83, 66, 176, 180, 85, 66, 165, 193, 85, 67, 165, 194, 83, 68, 178, 181, 85, 68, 166, 191, 83, 69, 177, 181, 85, 69, 166, 192, 83, 70, 176, 181, 85, 70, 166, 193, 85, 71, 166, 194, 170, 76, 178, 180, 171, 76, 178, 160, 170, 77, 177, 180, 171, 77, 177, 160, 170, 78, 176, 180, 171, 78, 176, 160, 170, 79, 178, 181, 171, 79, 178, 161, 170, 80, 177, 181, 171, 80, 177, 161, 170, 81, 176, 181, 171, 81, 176, 161, 152, 86, 182, 178, 152, 87, 182, 177, 152, 88, 182, 176, 152, 89, 183, 178, 152, 90, 183, 177, 152, 91, 183, 176, 156, 93, 173, 162, 152, 93, 184, 178, 156, 94, 173, 163, 152, 94, 184, 177, 156, 95, 173, 164, 152, 95, 184, 176, 156, 96, 173, 165, 156, 97, 173, 166, 84, 102, 165, 166, 84, 103, 166, 166, 163, 106, 175, 173, 163, 107, 174, 173, 81, 111, 140, 173, 81, 112, 139, 173, 81, 113, 138, 173, 89, 126, 128, 173, 89, 127, 129, 173, 89, 128, 130, 173, 89, 129, 131, 173, 23, 134, 185, 202, 23, 135, 185, 203, 142, 138, 204, 173, 106, 138, 205, 173, 109, 138, 206, 173, 142, 139, 207, 173, 106, 139, 208, 173, 109, 139, 209, 173, 158, 148, 182, 173, 158, 150, 183, 173, 158, 152, 184, 173, 169, 172, 191, 159, 169, 174, 192, 159, 169, 176, 193, 159, 169, 178, 194, 159, 110, 184, 206, 173, 110, 185, 209, 173, 110, 187, 210, 173, 143, 210, 211, 173, 143, 213, 212, 173, 136, 226, 213, 195, 136, 227, 214, 195, 24, 262, 185, 215, 24, 267, 185, 202, 24, 272, 185, 203, 33, 293, 216, 217, 122, 300, 218, 173, 123, 300, 219, 173, 125, 300, 220, 173, 126, 300, 221, 173, 128, 300, 222, 196, 122, 303, 223, 173, 123, 303, 223, 173, 125, 303, 224, 173, 126, 303, 224, 173, 128, 303, 225, 196, 33, 354, 186, 226, 33, 356, 186, 227, 33, 358, 186, 228)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 3: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=3
nb_c=293
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=590 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(3, 0, 0, 154, 0, 0, 155, 0, 0, 3, 0, 127, 154, 0, 140, 155, 0, 141, 3, 1, 1, 154, 1, 1, 155, 1, 1, 3, 1, 128, 154, 1, 142, 155, 1, 143, 3, 2, 2, 154, 2, 2, 155, 2, 2, 3, 2, 129, 154, 2, 143, 155, 2, 142, 3, 3, 3, 154, 3, 3, 155, 3, 3, 3, 3, 130, 154, 3, 141, 155, 3, 140, 65, 4, 4, 157, 4, 4, 157, 5, 5, 65, 5, 5, 157, 5, 127, 65, 6, 6, 157, 6, 6, 65, 7, 7, 157, 7, 7, 157, 8, 8, 65, 8, 8, 157, 8, 128, 65, 9, 9, 157, 9, 9, 65, 10, 10, 157, 10, 10, 157, 11, 11, 65, 11, 11, 157, 11, 129, 157, 12, 12, 65, 12, 12, 157, 12, 130, 65, 13, 13, 157, 13, 13, 65, 13, 119, 157, 14, 14, 65, 14, 14, 157, 14, 131, 65, 15, 15, 157, 15, 15, 65, 16, 16, 157, 16, 16, 157, 17, 17, 65, 17, 17, 157, 17, 132, 157, 18, 18, 65, 18, 18, 157, 18, 133, 65, 19, 19, 157, 19, 19, 65, 19, 120, 157, 20, 20, 65, 20, 20, 157, 20, 134, 157, 21, 21, 65, 21, 21, 157, 21, 135, 65, 22, 22, 157, 22, 22, 65, 22, 121, 65, 23, 23, 157, 23, 23, 65, 23, 122, 157, 23, 136, 67, 24, 24, 168, 24, 24, 167, 24, 24, 118, 24, 24, 67, 24, 25, 168, 24, 118, 167, 24, 119, 118, 24, 144, 80, 25, 25, 153, 25, 25, 131, 25, 25, 80, 25, 116, 153, 25, 24, 131, 25, 145, 78, 26, 26, 90, 26, 26, 78, 26, 66, 90, 26, 116, 78, 27, 27, 90, 27, 27, 78, 27, 67, 78, 28, 28, 90, 28, 28, 78, 28, 68, 78, 29, 29, 90, 29, 29, 78, 29, 69, 78, 30, 30, 90, 30, 30, 78, 30, 70, 78, 31, 31, 90, 31, 31, 78, 31, 71, 78, 32, 32, 90, 32, 32, 78, 32, 72, 78, 33, 33, 90, 33, 33, 78, 33, 73, 78, 34, 34, 90, 34, 34, 78, 34, 74, 78, 35, 35, 90, 35, 35, 78, 35, 75, 78, 36, 36, 90, 36, 36, 78, 36, 76, 78, 37, 37, 90, 37, 37, 78, 37, 77, 78, 38, 38, 90, 38, 38, 78, 38, 78, 78, 39, 39, 90, 39, 39, 78, 39, 79, 78, 40, 40, 90, 40, 40, 78, 40, 80, 78, 41, 41, 90, 41, 41, 78, 41, 81, 78, 42, 42, 90, 42, 42, 78, 42, 82, 78, 43, 43, 90, 43, 43, 78, 43, 83, 78, 44, 44, 90, 44, 44, 78, 44, 84, 78, 45, 45, 90, 45, 45, 78, 45, 85, 90, 45, 116, 165, 46, 46, 172, 46, 46, 1, 46, 46, 2, 46, 46, 165, 46, 66, 172, 46, 96, 165, 47, 47, 172, 47, 47, 1, 47, 47, 2, 47, 47, 165, 47, 67, 172, 47, 97, 165, 48, 48, 172, 48, 48, 1, 48, 48, 2, 48, 48, 165, 48, 68, 172, 48, 98, 165, 49, 49, 172, 49, 49, 1, 49, 49, 2, 49, 49, 165, 49, 69, 172, 49, 99, 165, 50, 50, 172, 50, 50, 1, 50, 50, 2, 50, 50, 165, 50, 70, 172, 50, 100, 165, 51, 51, 172, 51, 51, 1, 51, 51, 2, 51, 51, 165, 51, 71, 172, 51, 101, 165, 52, 52, 172, 52, 52, 1, 52, 52, 2, 52, 52, 165, 52, 72, 172, 52, 102, 165, 53, 53, 172, 53, 53, 1, 53, 53, 2, 53, 53, 165, 53, 73, 172, 53, 103, 165, 54, 54, 172, 54, 54, 1, 54, 54, 2, 54, 54, 165, 54, 74, 172, 54, 104, 165, 55, 55, 172, 55, 55, 1, 55, 55, 2, 55, 55, 165, 55, 75, 172, 55, 105, 165, 56, 56, 172, 56, 56, 1, 56, 56, 2, 56, 56, 165, 56, 76, 172, 56, 106, 165, 57, 57, 172, 57, 57, 1, 57, 57, 2, 57, 57, 165, 57, 77, 172, 57, 107, 165, 58, 58, 172, 58, 58, 1, 58, 58, 2, 58, 58, 165, 58, 78, 172, 58, 108, 165, 59, 59, 172, 59, 59, 1, 59, 59, 2, 59, 59, 165, 59, 79, 172, 59, 109, 165, 60, 60, 172, 60, 60, 1, 60, 60, 2, 60, 60, 165, 60, 80, 172, 60, 110, 165, 61, 61, 172, 61, 61, 1, 61, 61, 2, 61, 61, 165, 61, 81, 172, 61, 111, 165, 62, 62, 172, 62, 62, 1, 62, 62, 2, 62, 62, 165, 62, 82, 172, 62, 112, 165, 63, 63, 172, 63, 63, 1, 63, 63, 2, 63, 63, 165, 63, 83, 172, 63, 113, 165, 64, 64, 172, 64, 64, 1, 64, 64, 2, 64, 64, 165, 64, 84, 172, 64, 114, 165, 65, 65, 172, 65, 65, 1, 65, 65, 2, 65, 65, 165, 65, 85, 172, 65, 115, 79, 66, 66, 83, 66, 66, 85, 66, 66, 164, 66, 66, 79, 66, 46, 83, 66, 116, 85, 66, 123, 164, 66, 26, 79, 67, 67, 85, 67, 67, 164, 67, 67, 83, 67, 67, 79, 67, 47, 85, 67, 124, 164, 67, 27, 79, 68, 68, 85, 68, 68, 164, 68, 68, 83, 68, 68, 79, 68, 48, 85, 68, 125, 164, 68, 28, 79, 69, 69, 85, 69, 69, 164, 69, 69, 83, 69, 69, 79, 69, 49, 85, 69, 126, 164, 69, 29, 79, 70, 70, 164, 70, 70, 83, 70, 70, 85, 70, 70, 79, 70, 50, 164, 70, 30, 79, 71, 71, 164, 71, 71, 83, 71, 71, 85, 71, 71, 79, 71, 51, 164, 71, 31, 79, 72, 72, 164, 72, 72, 83, 72, 72, 85, 72, 72, 79, 72, 52, 164, 72, 32, 79, 73, 73, 164, 73, 73, 83, 73, 73, 85, 73, 73, 79, 73, 53, 164, 73, 33, 79, 74, 74, 164, 74, 74, 83, 74, 74, 85, 74, 74, 79, 74, 54, 164, 74, 34, 79, 75, 75, 164, 75, 75, 83, 75, 75, 85, 75, 75, 79, 75, 55, 164, 75, 35, 79, 76, 76, 164, 76, 76, 83, 76, 76, 85, 76, 76, 79, 76, 56, 164, 76, 36, 79, 77, 77, 164, 77, 77, 83, 77, 77, 85, 77, 77, 79, 77, 57, 164, 77, 37, 79, 78, 78, 164, 78, 78, 83, 78, 78, 85, 78, 78, 79, 78, 58, 164, 78, 38, 79, 79, 79, 164, 79, 79, 83, 79, 79, 85, 79, 79, 79, 79, 59, 164, 79, 39, 79, 80, 80, 164, 80, 80, 83, 80, 80, 85, 80, 80, 79, 80, 60, 164, 80, 40, 79, 81, 81, 164, 81, 81, 83, 81, 81, 85, 81, 81, 79, 81, 61, 164, 81, 41, 79, 82, 82, 164, 82, 82, 83, 82, 82, 85, 82, 82, 79, 82, 62, 164, 82, 42, 79, 83, 83, 164, 83, 83, 83, 83, 83, 85, 83, 83, 79, 83, 63, 164, 83, 43, 79, 84, 84, 164, 84, 84, 83, 84, 84, 85, 84, 84, 79, 84, 64, 164, 84, 44, 79, 85, 85, 83, 85, 85, 164, 85, 85, 85, 85, 85, 79, 85, 65, 83, 85, 117, 164, 85, 45, 70, 86, 86, 170, 86, 86, 171, 86, 86, 170, 86, 86, 147, 86, 86, 70, 86, 96, 170, 86, 116, 171, 86, 116, 170, 86, 146, 147, 86, 147, 70, 87, 87, 170, 87, 87, 147, 87, 87, 170, 87, 87, 171, 87, 87, 70, 87, 97, 170, 87, 148, 147, 87, 149, 70, 88, 88, 170, 88, 88, 147, 88, 88, 170, 88, 88, 171, 88, 88, 70, 88, 98, 170, 88, 150, 147, 88, 151, 70, 89, 89, 170, 89, 89, 147, 89, 89, 170, 89, 89, 171, 89, 89, 70, 89, 99, 170, 89, 152, 147, 89, 153, 70, 90, 90, 170, 90, 90, 147, 90, 90, 170, 90, 90, 171, 90, 90, 70, 90, 100, 170, 90, 154, 147, 90, 155, 70, 91, 91, 170, 91, 91, 147, 91, 91, 170, 91, 91, 171, 91, 91, 70, 91, 101, 170, 91, 156, 147, 91, 157, 70, 92, 92, 170, 92, 92, 147, 92, 92, 170, 92, 92, 171, 92, 92, 70, 92, 102, 170, 92, 158, 147, 92, 159, 70, 93, 93, 170, 93, 93, 147, 93, 93, 170, 93, 93, 171, 93, 93, 70, 93, 103, 170, 93, 160, 147, 93, 161, 70, 94, 94, 170, 94, 94, 147, 94, 94, 170, 94, 94, 171, 94, 94, 70, 94, 104, 170, 94, 162, 147, 94, 163, 70, 95, 95, 170, 95, 95, 147, 95, 95, 170, 95, 95, 171, 95, 95, 70, 95, 105, 170, 95, 164, 147, 95, 165, 86, 96, 96, 156, 96, 96, 152, 96, 96, 86, 96, 46, 156, 96, 86, 152, 96, 116, 86, 97, 97, 156, 97, 97, 152, 97, 97, 86, 97, 47, 156, 97, 87, 86, 98, 98, 156, 98, 98, 152, 98, 98, 86, 98, 48, 156, 98, 88, 86, 99, 99, 156, 99, 99, 152, 99, 99, 86, 99, 49, 156, 99, 89, 86, 100, 100, 156, 100, 100, 152, 100, 100, 86, 100, 50, 156, 100, 90, 86, 101, 101, 156, 101, 101, 152, 101, 101, 86, 101, 51, 156, 101, 91, 86, 102, 102, 156, 102, 102, 152, 102, 102, 86, 102, 52, 156, 102, 92, 86, 103, 103, 156, 103, 103, 152, 103, 103, 86, 103, 53, 156, 103, 93, 86, 104, 104, 156, 104, 104, 152, 104, 104, 86, 104, 54, 156, 104, 94, 86, 105, 105, 156, 105, 105, 152, 105, 105, 86, 105, 55, 156, 105, 95, 86, 106, 106, 156, 106, 106, 152, 106, 106, 86, 106, 56, 86, 107, 107, 156, 107, 107, 152, 107, 107, 86, 107, 57, 86, 108, 108, 156, 108, 108, 152, 108, 108, 86, 108, 58, 86, 109, 109, 156, 109, 109, 152, 109, 109, 86, 109, 59, 86, 110, 110, 156, 110, 110, 152, 110, 110, 86, 110, 60, 86, 111, 111, 156, 111, 111, 152, 111, 111, 86, 111, 61, 86, 112, 112, 156, 112, 112, 152, 112, 112, 86, 112, 62, 86, 113, 113, 156, 113, 113, 152, 113, 113, 86, 113, 63, 86, 114, 114, 156, 114, 114, 152, 114, 114, 86, 114, 64, 86, 115, 115, 152, 115, 115, 156, 115, 115, 86, 115, 65, 152, 115, 118, 4, 116, 116, 4, 116, 116, 66, 116, 116, 84, 116, 116, 85, 116, 116, 166, 116, 116, 169, 116, 116, 4, 116, 45, 4, 116, 26, 66, 116, 96, 84, 116, 86, 85, 116, 86, 166, 116, 25, 169, 116, 66, 169, 117, 117, 84, 117, 117, 169, 117, 85, 82, 118, 118, 66, 118, 118, 72, 118, 118, 44, 118, 118, 139, 118, 118, 163, 118, 118, 82, 118, 24, 66, 118, 115, 72, 118, 141, 44, 118, 166, 139, 118, 138, 73, 119, 119, 81, 119, 119, 151, 119, 119, 103, 119, 119, 73, 119, 141, 81, 119, 24, 151, 119, 13, 103, 119, 167, 73, 120, 120, 151, 120, 120, 103, 120, 120, 81, 120, 120, 73, 120, 143, 151, 120, 19, 103, 120, 168, 73, 121, 121, 151, 121, 121, 103, 121, 121, 81, 121, 121, 73, 121, 142, 151, 121, 22, 103, 121, 169, 73, 122, 122, 151, 122, 122, 103, 122, 122, 81, 122, 122, 73, 122, 140, 151, 122, 23, 103, 122, 170, 83, 123, 123, 171, 123, 123, 100, 123, 123, 83, 123, 146, 171, 123, 66, 100, 123, 171, 83, 124, 124, 171, 124, 124, 100, 124, 124, 83, 124, 148, 171, 124, 67, 100, 124, 172, 83, 125, 125, 171, 125, 125, 100, 125, 125, 83, 125, 150, 171, 125, 68, 100, 125, 173, 83, 126, 126, 171, 126, 126, 100, 126, 126, 83, 126, 152, 171, 126, 69, 100, 126, 139, 71, 127, 127, 89, 127, 127, 94, 127, 127, 71, 127, 5, 89, 127, 0, 94, 127, 174, 71, 128, 128, 89, 128, 128, 94, 128, 128, 71, 128, 8, 89, 128, 1, 94, 128, 175, 71, 129, 129, 89, 129, 129, 94, 129, 129, 71, 129, 11, 89, 129, 2, 94, 129, 176, 71, 130, 130, 89, 130, 130, 94, 130, 130, 71, 130, 12, 89, 130, 3, 94, 130, 177, 71, 131, 131, 94, 131, 131, 89, 131, 131, 71, 131, 14, 94, 131, 178, 71, 132, 132, 94, 132, 132, 89, 132, 132, 71, 132, 17, 94, 132, 179, 71, 133, 133, 94, 133, 133, 89, 133, 133, 71, 133, 18, 94, 133, 180, 71, 134, 134, 94, 134, 134, 89, 134, 134, 71, 134, 20, 94, 134, 181, 71, 135, 135, 94, 135, 135, 89, 135, 135, 71, 135, 21, 94, 135, 182, 71, 136, 136, 94, 136, 136, 89, 136, 136, 71, 136, 23, 94, 136, 183, 24, 137, 137, 23, 137, 137, 24, 137, 170, 53, 138, 138, 140, 138, 138, 142, 138, 138, 110, 138, 138, 142, 138, 138, 106, 138, 138, 109, 138, 138, 53, 138, 118, 140, 138, 184, 142, 138, 185, 110, 138, 186, 14, 139, 139, 119, 139, 139, 14, 139, 126, 119, 139, 187, 68, 140, 140, 69, 140, 140, 159, 140, 140, 158, 140, 140, 68, 140, 0, 69, 140, 3, 159, 140, 122, 68, 141, 141, 69, 141, 141, 159, 141, 141, 158, 141, 141, 68, 141, 3, 69, 141, 0, 159, 141, 119, 158, 141, 118, 68, 142, 142, 69, 142, 142, 159, 142, 142, 158, 142, 142, 68, 142, 1, 69, 142, 2, 159, 142, 121, 68, 143, 143, 69, 143, 143, 159, 143, 143, 158, 143, 143, 68, 143, 2, 69, 143, 1, 159, 143, 120, 32, 144, 144, 119, 144, 144, 120, 144, 144, 32, 144, 24, 119, 144, 188, 120, 144, 189, 45, 145, 145, 132, 145, 145, 45, 145, 25, 132, 145, 190, 84, 146, 146, 169, 146, 146, 84, 146, 86, 169, 146, 123, 61, 147, 147, 148, 147, 147, 128, 147, 147, 61, 147, 86, 148, 147, 191, 128, 147, 192, 84, 148, 148, 169, 148, 148, 84, 148, 87, 169, 148, 124, 61, 149, 149, 148, 149, 149, 128, 149, 149, 61, 149, 87, 148, 149, 193, 128, 149, 194, 84, 150, 150, 169, 150, 150, 84, 150, 88, 169, 150, 125, 61, 151, 151, 148, 151, 151, 128, 151, 151, 61, 151, 88, 148, 151, 195, 128, 151, 196, 84, 152, 152, 169, 152, 152, 84, 152, 89, 169, 152, 126, 61, 153, 153, 148, 153, 153, 128, 153, 153, 61, 153, 89, 148, 153, 197, 128, 153, 198, 84, 154, 154, 169, 154, 154, 84, 154, 90, 61, 155, 155, 148, 155, 155, 128, 155, 155, 61, 155, 90, 148, 155, 199, 128, 155, 200, 84, 156, 156, 169, 156, 156, 84, 156, 91, 61, 157, 157, 148, 157, 157, 128, 157, 157, 61, 157, 91, 148, 157, 201, 128, 157, 202, 84, 158, 158, 169, 158, 158, 84, 158, 92, 61, 159, 159, 148, 159, 159, 128, 159, 159, 61, 159, 92, 148, 159, 203, 128, 159, 204, 84, 160, 160, 169, 160, 160, 84, 160, 93, 61, 161, 161, 148, 161, 161, 128, 161, 161, 61, 161, 93, 148, 161, 205, 128, 161, 206, 84, 162, 162, 169, 162, 162, 84, 162, 94, 61, 163, 163, 148, 163, 163, 128, 163, 163, 61, 163, 94, 148, 163, 207, 128, 163, 208, 84, 164, 164, 169, 164, 164, 84, 164, 95, 61, 165, 165, 148, 165, 165, 128, 165, 165, 61, 165, 95, 148, 165, 209, 128, 165, 210, 42, 166, 166, 130, 166, 166, 42, 166, 189, 130, 166, 118, 17, 167, 167, 104, 167, 167, 109, 167, 167, 112, 167, 167, 114, 167, 167, 116, 167, 167, 110, 167, 167, 17, 167, 119, 104, 167, 211, 109, 167, 186, 112, 167, 212, 114, 167, 213, 116, 167, 214, 17, 168, 168, 104, 168, 168, 109, 168, 168, 112, 168, 168, 114, 168, 168, 116, 168, 168, 110, 168, 168, 17, 168, 120, 104, 168, 215, 109, 168, 216, 112, 168, 217, 114, 168, 218, 116, 168, 219, 17, 169, 169, 104, 169, 169, 109, 169, 169, 112, 169, 169, 114, 169, 169, 116, 169, 169, 110, 169, 169, 17, 169, 121, 104, 169, 220, 109, 169, 221, 112, 169, 222, 114, 169, 223, 116, 169, 224, 17, 170, 170, 104, 170, 170, 109, 170, 170, 110, 170, 170, 112, 170, 170, 114, 170, 170, 116, 170, 170, 17, 170, 122, 104, 170, 225, 109, 170, 226, 110, 170, 137, 112, 170, 227, 114, 170, 228, 116, 170, 229, 14, 171, 171, 119, 171, 171, 14, 171, 123, 119, 171, 230, 14, 172, 172, 119, 172, 172, 14, 172, 124, 119, 172, 231, 14, 173, 173, 119, 173, 173, 14, 173, 125, 119, 173, 232, 8, 174, 174, 95, 174, 174, 8, 174, 127, 95, 174, 233, 8, 175, 175, 95, 175, 175, 8, 175, 128, 95, 175, 234, 8, 176, 176, 95, 176, 176, 8, 176, 129, 95, 176, 235, 8, 177, 177, 95, 177, 177, 8, 177, 130, 95, 177, 236, 8, 178, 178, 95, 178, 178, 8, 178, 131, 95, 178, 237, 8, 179, 179, 95, 179, 179, 8, 179, 132, 95, 179, 238, 8, 180, 180, 95, 180, 180, 8, 180, 133, 95, 180, 239, 8, 181, 181, 95, 181, 181, 8, 181, 134, 95, 181, 240, 8, 182, 182, 95, 182, 182, 8, 182, 135, 95, 182, 241, 8, 183, 183, 95, 183, 183, 8, 183, 136, 95, 183, 242, 54, 184, 184, 54, 184, 138, 56, 185, 185, 145, 185, 185, 143, 185, 185, 56, 185, 138, 145, 185, 243, 23, 186, 186, 24, 186, 186, 23, 186, 167, 24, 186, 138, 33, 187, 187, 120, 187, 187, 33, 187, 139, 120, 187, 244, 33, 188, 188, 120, 188, 188, 33, 188, 144, 120, 188, 245, 34, 189, 189, 122, 189, 189, 123, 189, 189, 125, 189, 189, 126, 189, 189, 128, 189, 189, 34, 189, 144, 122, 189, 246, 123, 189, 246, 125, 189, 247, 126, 189, 247, 128, 189, 166, 46, 190, 190, 134, 190, 190, 136, 190, 190, 46, 190, 145, 134, 190, 248, 62, 191, 191, 62, 191, 147, 42, 192, 192, 42, 192, 147, 62, 193, 193, 62, 193, 149, 42, 194, 194, 42, 194, 149, 62, 195, 195, 62, 195, 151, 42, 196, 196, 42, 196, 151, 62, 197, 197, 62, 197, 153, 42, 198, 198, 42, 198, 153, 62, 199, 199, 62, 199, 155, 42, 200, 200, 42, 200, 155, 62, 201, 201, 62, 201, 157, 42, 202, 202, 42, 202, 157, 62, 203, 203, 62, 203, 159, 42, 204, 204, 42, 204, 159, 62, 205, 205, 62, 205, 161, 42, 206, 206, 42, 206, 161, 62, 207, 207, 62, 207, 163, 42, 208, 208, 42, 208, 163, 62, 209, 209, 62, 209, 165, 42, 210, 210, 42, 210, 165, 18, 211, 211, 18, 211, 167, 26, 212, 212, 106, 212, 212, 26, 212, 167, 106, 212, 249, 28, 213, 213, 28, 213, 167, 30, 214, 214, 30, 214, 167, 18, 215, 215, 18, 215, 168, 23, 216, 216, 24, 216, 216, 23, 216, 168, 26, 217, 217, 106, 217, 217, 26, 217, 168, 106, 217, 250, 28, 218, 218, 28, 218, 168, 30, 219, 219, 30, 219, 168, 18, 220, 220, 18, 220, 169, 23, 221, 221, 24, 221, 221, 23, 221, 169, 26, 222, 222, 106, 222, 222, 26, 222, 169, 106, 222, 251, 28, 223, 223, 28, 223, 169, 30, 224, 224, 30, 224, 169, 18, 225, 225, 18, 225, 170, 23, 226, 226, 24, 226, 226, 23, 226, 170, 26, 227, 227, 106, 227, 227, 26, 227, 170, 106, 227, 252, 28, 228, 228, 28, 228, 170, 30, 229, 229, 30, 229, 170, 33, 230, 230, 120, 230, 230, 33, 230, 171, 120, 230, 253, 33, 231, 231, 120, 231, 231, 33, 231, 172, 120, 231, 254, 33, 232, 232, 120, 232, 232, 33, 232, 173, 120, 232, 255, 9, 233, 233, 98, 233, 233, 9, 233, 174, 98, 233, 256, 9, 234, 234, 98, 234, 234, 9, 234, 175, 98, 234, 257, 9, 235, 235, 98, 235, 235, 9, 235, 176, 98, 235, 258, 9, 236, 236, 98, 236, 236, 9, 236, 177, 98, 236, 259, 9, 237, 237, 98, 237, 237, 9, 237, 178, 98, 237, 260, 9, 238, 238, 98, 238, 238, 9, 238, 179, 98, 238, 261, 9, 239, 239, 98, 239, 239, 9, 239, 180, 98, 239, 262, 9, 240, 240, 98, 240, 240, 9, 240, 181, 98, 240, 263, 9, 241, 241, 98, 241, 241, 9, 241, 182, 98, 241, 264, 9, 242, 242, 98, 242, 242, 9, 242, 183, 98, 242, 265, 59, 243, 243, 59, 243, 185, 34, 244, 244, 122, 244, 244, 123, 244, 244, 125, 244, 244, 126, 244, 244, 128, 244, 244, 34, 244, 187, 122, 244, 266, 123, 244, 266, 125, 244, 267, 126, 244, 267, 128, 244, 268, 34, 245, 245, 122, 245, 245, 123, 245, 245, 125, 245, 245, 126, 245, 245, 128, 245, 245, 34, 245, 188, 36, 246, 246, 37, 246, 246, 36, 246, 189, 37, 246, 189, 39, 247, 247, 40, 247, 247, 39, 247, 189, 40, 247, 189, 48, 248, 248, 48, 248, 190, 20, 249, 249, 20, 249, 212, 20, 250, 250, 20, 250, 217, 20, 251, 251, 20, 251, 222, 20, 252, 252, 20, 252, 227, 34, 253, 253, 122, 253, 253, 123, 253, 253, 125, 253, 253, 126, 253, 253, 128, 253, 253, 34, 253, 230, 122, 253, 269, 123, 253, 270, 125, 253, 271, 126, 253, 272, 128, 253, 273, 34, 254, 254, 122, 254, 254, 123, 254, 254, 125, 254, 254, 126, 254, 254, 128, 254, 254, 34, 254, 231, 122, 254, 274, 123, 254, 275, 125, 254, 276, 126, 254, 277, 128, 254, 278, 34, 255, 255, 122, 255, 255, 123, 255, 255, 125, 255, 255, 126, 255, 255, 128, 255, 255, 34, 255, 232, 122, 255, 279, 123, 255, 280, 125, 255, 281, 126, 255, 282, 128, 255, 283, 12, 256, 256, 12, 256, 233, 12, 257, 257, 12, 257, 234, 12, 258, 258, 12, 258, 235, 12, 259, 259, 12, 259, 236, 12, 260, 260, 12, 260, 237, 12, 261, 261, 12, 261, 238, 12, 262, 262, 12, 262, 239, 12, 263, 263, 12, 263, 240, 12, 264, 264, 12, 264, 241, 12, 265, 265, 12, 265, 242, 36, 266, 266, 37, 266, 266, 36, 266, 244, 37, 266, 244, 39, 267, 267, 40, 267, 267, 39, 267, 244, 40, 267, 244, 42, 268, 268, 42, 268, 244, 36, 269, 269, 37, 269, 269, 36, 269, 253, 37, 269, 284, 36, 270, 270, 37, 270, 270, 36, 270, 284, 37, 270, 253, 39, 271, 271, 40, 271, 271, 39, 271, 253, 40, 271, 284, 39, 272, 272, 40, 272, 272, 39, 272, 284, 40, 272, 253, 42, 273, 273, 42, 273, 253, 36, 274, 274, 37, 274, 274, 36, 274, 254, 37, 274, 285, 36, 275, 275, 37, 275, 275, 36, 275, 285, 37, 275, 254, 39, 276, 276, 40, 276, 276, 39, 276, 254, 40, 276, 285, 39, 277, 277, 40, 277, 277, 39, 277, 285, 40, 277, 254, 42, 278, 278, 42, 278, 254, 36, 279, 279, 37, 279, 279, 36, 279, 255, 37, 279, 286, 36, 280, 280, 37, 280, 280, 36, 280, 286, 37, 280, 255, 39, 281, 281, 40, 281, 281, 39, 281, 255, 40, 281, 286, 39, 282, 282, 40, 282, 282, 39, 282, 286, 40, 282, 255, 42, 283, 283, 42, 283, 255, 34, 284, 284, 122, 284, 284, 123, 284, 284, 125, 284, 284, 126, 284, 284, 128, 284, 284, 34, 284, 287, 122, 284, 270, 123, 284, 269, 125, 284, 272, 126, 284, 271, 128, 284, 288, 34, 285, 285, 122, 285, 285, 123, 285, 285, 125, 285, 285, 126, 285, 285, 128, 285, 285, 34, 285, 289, 122, 285, 275, 123, 285, 274, 125, 285, 277, 126, 285, 276, 128, 285, 290, 34, 286, 286, 122, 286, 286, 123, 286, 286, 125, 286, 286, 126, 286, 286, 128, 286, 286, 34, 286, 291, 122, 286, 280, 123, 286, 279, 125, 286, 282, 126, 286, 281, 128, 286, 292, 120, 287, 287, 33, 287, 287, 120, 287, 284, 42, 288, 288, 42, 288, 284, 120, 289, 289, 33, 289, 289, 120, 289, 285, 42, 290, 290, 42, 290, 285, 120, 291, 291, 33, 291, 291, 120, 291, 286, 42, 292, 292, 42, 292, 286)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(65, 5, 456, 187, 157, 5, 478, 173, 65, 6, 456, 188, 65, 7, 174, 466, 157, 7, 479, 173, 65, 8, 175, 466, 157, 8, 480, 173, 65, 9, 456, 189, 65, 10, 174, 467, 157, 10, 481, 173, 65, 11, 175, 467, 157, 11, 482, 173, 65, 12, 174, 468, 65, 13, 175, 468, 157, 14, 483, 173, 65, 15, 456, 190, 65, 16, 174, 469, 157, 16, 484, 173, 65, 17, 175, 469, 157, 17, 485, 173, 65, 18, 174, 470, 65, 19, 175, 470, 157, 20, 486, 173, 65, 21, 174, 471, 65, 22, 175, 471, 157, 23, 487, 173, 90, 28, 176, 459, 90, 29, 176, 458, 90, 30, 176, 457, 90, 31, 177, 459, 90, 32, 177, 458, 90, 33, 177, 457, 90, 34, 457, 178, 90, 35, 457, 177, 90, 36, 457, 176, 90, 37, 178, 459, 90, 38, 178, 458, 90, 39, 178, 457, 90, 40, 458, 178, 90, 41, 458, 177, 90, 42, 458, 176, 90, 43, 459, 178, 90, 44, 459, 177, 90, 45, 459, 176, 1, 47, 46, 1, 2, 47, 47, 1, 1, 48, 48, 1, 2, 48, 49, 1, 1, 49, 50, 1, 2, 49, 51, 1, 1, 50, 52, 1, 2, 50, 53, 1, 1, 51, 54, 1, 2, 51, 55, 1, 1, 52, 56, 1, 2, 52, 57, 1, 1, 53, 58, 1, 2, 53, 59, 1, 1, 54, 60, 1, 2, 54, 61, 1, 1, 55, 62, 1, 2, 55, 63, 1, 1, 56, 64, 1, 2, 56, 65, 1, 1, 57, 66, 1, 2, 57, 67, 1, 1, 58, 68, 1, 2, 58, 69, 1, 1, 59, 70, 1, 2, 59, 71, 1, 1, 60, 72, 1, 2, 60, 73, 1, 1, 61, 74, 1, 2, 61, 75, 1, 1, 62, 76, 1, 2, 62, 77, 1, 1, 63, 78, 1, 2, 63, 79, 1, 1, 64, 80, 1, 2, 64, 81, 1, 1, 65, 82, 1, 2, 65, 83, 1, 1, 66, 84, 1, 2, 66, 85, 1, 83, 68, 459, 179, 83, 69, 458, 179, 83, 70, 457, 179, 83, 71, 459, 180, 85, 71, 165, 472, 83, 72, 458, 180, 85, 72, 165, 473, 83, 73, 457, 180, 85, 73, 165, 474, 83, 74, 178, 460, 85, 74, 165, 475, 83, 75, 177, 460, 85, 75, 165, 476, 83, 76, 176, 460, 85, 76, 165, 477, 83, 77, 459, 181, 85, 77, 166, 472, 83, 78, 458, 181, 85, 78, 166, 473, 83, 79, 457, 181, 85, 79, 166, 474, 83, 80, 178, 461, 85, 80, 166, 475, 83, 81, 177, 461, 85, 81, 166, 476, 83, 82, 176, 461, 85, 82, 166, 477, 83, 83, 178, 462, 85, 83, 440, 191, 83, 84, 177, 462, 85, 84, 440, 192, 83, 85, 176, 462, 85, 85, 440, 193, 85, 86, 440, 194, 170, 88, 459, 180, 171, 88, 459, 160, 170, 89, 458, 180, 171, 89, 458, 160, 170, 90, 457, 180, 171, 90, 457, 160, 170, 91, 459, 181, 171, 91, 459, 161, 170, 92, 458, 181, 171, 92, 458, 161, 170, 93, 457, 181, 171, 93, 457, 161, 170, 94, 178, 462, 171, 94, 178, 430, 170, 95, 177, 462, 171, 95, 177, 430, 170, 96, 176, 462, 171, 96, 176, 430, 152, 98, 182, 459, 152, 99, 182, 458, 152, 100, 182, 457, 152, 101, 183, 459, 152, 102, 183, 458, 152, 103, 183, 457, 152, 104, 463, 178, 152, 105, 463, 177, 152, 106, 463, 176, 156, 107, 173, 431, 152, 107, 184, 459, 156, 108, 173, 432, 152, 108, 184, 458, 156, 109, 173, 433, 152, 109, 184, 457, 156, 110, 173, 434, 152, 110, 464, 178, 156, 111, 173, 435, 152, 111, 464, 177, 156, 112, 173, 436, 152, 112, 464, 176, 156, 113, 173, 437, 152, 113, 465, 178, 156, 114, 173, 438, 152, 114, 465, 177, 156, 115, 173, 439, 152, 115, 465, 176, 156, 116, 173, 440, 84, 118, 440, 166, 163, 119, 456, 173, 81, 121, 382, 173, 81, 122, 381, 173, 81, 123, 380, 173, 89, 132, 359, 173, 89, 133, 360, 173, 89, 134, 362, 173, 89, 135, 361, 173, 89, 136, 363, 173, 89, 137, 364, 173, 23, 138, 185, 488, 142, 139, 489, 173, 106, 139, 490, 173, 109, 139, 491, 173, 158, 141, 463, 173, 158, 143, 464, 173, 158, 144, 465, 173, 169, 155, 472, 159, 169, 157, 473, 159, 169, 159, 474, 159, 169, 161, 475, 159, 169, 163, 476, 159, 169, 165, 477, 159, 110, 168, 491, 173, 110, 169, 492, 173, 110, 170, 493, 173, 143, 186, 494, 173, 136, 191, 495, 195, 24, 217, 185, 496, 24, 222, 185, 497, 24, 227, 185, 488, 122, 246, 498, 173, 123, 246, 499, 173, 125, 246, 500, 173, 126, 246, 501, 173, 128, 246, 502, 196, 33, 288, 186, 503, 33, 290, 186, 504, 33, 292, 186, 505)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 4: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=4
nb_c=142
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=883 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(3, 0, 0, 154, 0, 0, 155, 0, 0, 3, 0, 83, 154, 0, 88, 155, 0, 88, 65, 1, 1, 157, 1, 1, 65, 2, 2, 157, 2, 2, 157, 3, 3, 65, 3, 3, 157, 3, 83, 65, 4, 4, 157, 4, 4, 65, 5, 5, 157, 5, 5, 65, 6, 6, 157, 6, 6, 157, 7, 7, 65, 7, 7, 157, 7, 84, 65, 8, 8, 157, 8, 8, 65, 9, 9, 157, 9, 9, 157, 10, 10, 65, 10, 10, 157, 10, 85, 65, 11, 11, 157, 11, 11, 65, 12, 12, 157, 12, 12, 157, 13, 13, 65, 13, 13, 157, 13, 86, 157, 14, 14, 65, 14, 14, 157, 14, 87, 65, 15, 15, 157, 15, 15, 65, 15, 81, 78, 16, 16, 90, 16, 16, 78, 16, 46, 78, 17, 17, 90, 17, 17, 78, 17, 47, 78, 18, 18, 90, 18, 18, 78, 18, 48, 78, 19, 19, 90, 19, 19, 78, 19, 49, 78, 20, 20, 90, 20, 20, 78, 20, 50, 78, 21, 21, 90, 21, 21, 78, 21, 51, 78, 22, 22, 90, 22, 22, 78, 22, 52, 78, 23, 23, 90, 23, 23, 78, 23, 53, 78, 24, 24, 90, 24, 24, 78, 24, 54, 78, 25, 25, 90, 25, 25, 78, 25, 55, 78, 26, 26, 90, 26, 26, 78, 26, 56, 78, 27, 27, 90, 27, 27, 78, 27, 57, 78, 28, 28, 90, 28, 28, 78, 28, 58, 78, 29, 29, 90, 29, 29, 78, 29, 59, 78, 30, 30, 90, 30, 30, 78, 30, 60, 165, 31, 31, 172, 31, 31, 1, 31, 31, 2, 31, 31, 165, 31, 46, 172, 31, 66, 165, 32, 32, 172, 32, 32, 1, 32, 32, 2, 32, 32, 165, 32, 47, 172, 32, 67, 165, 33, 33, 172, 33, 33, 1, 33, 33, 2, 33, 33, 165, 33, 48, 172, 33, 68, 165, 34, 34, 172, 34, 34, 1, 34, 34, 2, 34, 34, 165, 34, 49, 172, 34, 69, 165, 35, 35, 172, 35, 35, 1, 35, 35, 2, 35, 35, 165, 35, 50, 172, 35, 70, 165, 36, 36, 172, 36, 36, 1, 36, 36, 2, 36, 36, 165, 36, 51, 172, 36, 71, 165, 37, 37, 172, 37, 37, 1, 37, 37, 2, 37, 37, 165, 37, 52, 172, 37, 72, 165, 38, 38, 172, 38, 38, 1, 38, 38, 2, 38, 38, 165, 38, 53, 172, 38, 73, 165, 39, 39, 172, 39, 39, 1, 39, 39, 2, 39, 39, 165, 39, 54, 172, 39, 74, 165, 40, 40, 172, 40, 40, 1, 40, 40, 2, 40, 40, 165, 40, 55, 172, 40, 75, 165, 41, 41, 172, 41, 41, 1, 41, 41, 2, 41, 41, 165, 41, 56, 172, 41, 76, 165, 42, 42, 172, 42, 42, 1, 42, 42, 2, 42, 42, 165, 42, 57, 172, 42, 77, 165, 43, 43, 172, 43, 43, 1, 43, 43, 2, 43, 43, 165, 43, 58, 172, 43, 78, 165, 44, 44, 172, 44, 44, 1, 44, 44, 2, 44, 44, 165, 44, 59, 172, 44, 79, 165, 45, 45, 172, 45, 45, 1, 45, 45, 2, 45, 45, 165, 45, 60, 172, 45, 80, 79, 46, 46, 85, 46, 46, 164, 46, 46, 83, 46, 46, 79, 46, 31, 85, 46, 82, 164, 46, 16, 79, 47, 47, 164, 47, 47, 83, 47, 47, 85, 47, 47, 79, 47, 32, 164, 47, 17, 79, 48, 48, 164, 48, 48, 83, 48, 48, 85, 48, 48, 79, 48, 33, 164, 48, 18, 79, 49, 49, 164, 49, 49, 83, 49, 49, 85, 49, 49, 79, 49, 34, 164, 49, 19, 79, 50, 50, 164, 50, 50, 83, 50, 50, 85, 50, 50, 79, 50, 35, 164, 50, 20, 79, 51, 51, 164, 51, 51, 83, 51, 51, 85, 51, 51, 79, 51, 36, 164, 51, 21, 79, 52, 52, 164, 52, 52, 83, 52, 52, 85, 52, 52, 79, 52, 37, 164, 52, 22, 79, 53, 53, 164, 53, 53, 83, 53, 53, 85, 53, 53, 79, 53, 38, 164, 53, 23, 79, 54, 54, 164, 54, 54, 83, 54, 54, 85, 54, 54, 79, 54, 39, 164, 54, 24, 79, 55, 55, 164, 55, 55, 83, 55, 55, 85, 55, 55, 79, 55, 40, 164, 55, 25, 79, 56, 56, 164, 56, 56, 83, 56, 56, 85, 56, 56, 79, 56, 41, 164, 56, 26, 79, 57, 57, 164, 57, 57, 83, 57, 57, 85, 57, 57, 79, 57, 42, 164, 57, 27, 79, 58, 58, 164, 58, 58, 83, 58, 58, 85, 58, 58, 79, 58, 43, 164, 58, 28, 79, 59, 59, 164, 59, 59, 83, 59, 59, 85, 59, 59, 79, 59, 44, 164, 59, 29, 79, 60, 60, 164, 60, 60, 83, 60, 60, 85, 60, 60, 79, 60, 45, 164, 60, 30, 70, 61, 61, 170, 61, 61, 147, 61, 61, 170, 61, 61, 171, 61, 61, 70, 61, 66, 170, 61, 89, 147, 61, 90, 70, 62, 62, 170, 62, 62, 147, 62, 62, 170, 62, 62, 171, 62, 62, 70, 62, 67, 170, 62, 91, 147, 62, 92, 70, 63, 63, 170, 63, 63, 147, 63, 63, 170, 63, 63, 171, 63, 63, 70, 63, 68, 170, 63, 93, 147, 63, 94, 70, 64, 64, 170, 64, 64, 147, 64, 64, 170, 64, 64, 171, 64, 64, 70, 64, 69, 170, 64, 95, 147, 64, 96, 70, 65, 65, 170, 65, 65, 147, 65, 65, 170, 65, 65, 171, 65, 65, 70, 65, 70, 170, 65, 97, 147, 65, 98, 86, 66, 66, 156, 66, 66, 152, 66, 66, 86, 66, 31, 156, 66, 61, 86, 67, 67, 156, 67, 67, 152, 67, 67, 86, 67, 32, 156, 67, 62, 86, 68, 68, 156, 68, 68, 152, 68, 68, 86, 68, 33, 156, 68, 63, 86, 69, 69, 156, 69, 69, 152, 69, 69, 86, 69, 34, 156, 69, 64, 86, 70, 70, 156, 70, 70, 152, 70, 70, 86, 70, 35, 156, 70, 65, 86, 71, 71, 156, 71, 71, 152, 71, 71, 86, 71, 36, 86, 72, 72, 156, 72, 72, 152, 72, 72, 86, 72, 37, 86, 73, 73, 156, 73, 73, 152, 73, 73, 86, 73, 38, 86, 74, 74, 156, 74, 74, 152, 74, 74, 86, 74, 39, 86, 75, 75, 156, 75, 75, 152, 75, 75, 86, 75, 40, 86, 76, 76, 156, 76, 76, 152, 76, 76, 86, 76, 41, 86, 77, 77, 156, 77, 77, 152, 77, 77, 86, 77, 42, 86, 78, 78, 156, 78, 78, 152, 78, 78, 86, 78, 43, 86, 79, 79, 156, 79, 79, 152, 79, 79, 86, 79, 44, 86, 80, 80, 156, 80, 80, 152, 80, 80, 86, 80, 45, 73, 81, 81, 151, 81, 81, 103, 81, 81, 81, 81, 81, 73, 81, 88, 151, 81, 15, 103, 81, 99, 83, 82, 82, 171, 82, 82, 100, 82, 82, 83, 82, 89, 171, 82, 46, 100, 82, 100, 71, 83, 83, 89, 83, 83, 94, 83, 83, 71, 83, 3, 89, 83, 0, 94, 83, 101, 71, 84, 84, 94, 84, 84, 89, 84, 84, 71, 84, 7, 94, 84, 102, 71, 85, 85, 94, 85, 85, 89, 85, 85, 71, 85, 10, 94, 85, 103, 71, 86, 86, 94, 86, 86, 89, 86, 86, 71, 86, 13, 94, 86, 104, 71, 87, 87, 94, 87, 87, 89, 87, 87, 71, 87, 14, 94, 87, 105, 68, 88, 88, 69, 88, 88, 159, 88, 88, 158, 88, 88, 68, 88, 0, 69, 88, 0, 159, 88, 81, 84, 89, 89, 169, 89, 89, 84, 89, 61, 169, 89, 82, 61, 90, 90, 148, 90, 90, 128, 90, 90, 61, 90, 61, 148, 90, 106, 128, 90, 107, 84, 91, 91, 169, 91, 91, 84, 91, 62, 61, 92, 92, 148, 92, 92, 128, 92, 92, 61, 92, 62, 148, 92, 108, 128, 92, 109, 84, 93, 93, 169, 93, 93, 84, 93, 63, 61, 94, 94, 148, 94, 94, 128, 94, 94, 61, 94, 63, 148, 94, 110, 128, 94, 111, 84, 95, 95, 169, 95, 95, 84, 95, 64, 61, 96, 96, 148, 96, 96, 128, 96, 96, 61, 96, 64, 148, 96, 112, 128, 96, 113, 84, 97, 97, 169, 97, 97, 84, 97, 65, 61, 98, 98, 148, 98, 98, 128, 98, 98, 61, 98, 65, 148, 98, 114, 128, 98, 115, 17, 99, 99, 104, 99, 99, 109, 99, 99, 112, 99, 99, 114, 99, 99, 116, 99, 99, 110, 99, 99, 17, 99, 81, 104, 99, 116, 109, 99, 117, 112, 99, 118, 114, 99, 119, 116, 99, 120, 14, 100, 100, 119, 100, 100, 14, 100, 82, 119, 100, 121, 8, 101, 101, 95, 101, 101, 8, 101, 83, 95, 101, 122, 8, 102, 102, 95, 102, 102, 8, 102, 84, 95, 102, 123, 8, 103, 103, 95, 103, 103, 8, 103, 85, 95, 103, 124, 8, 104, 104, 95, 104, 104, 8, 104, 86, 95, 104, 125, 8, 105, 105, 95, 105, 105, 8, 105, 87, 95, 105, 126, 62, 106, 106, 62, 106, 90, 42, 107, 107, 42, 107, 90, 62, 108, 108, 62, 108, 92, 42, 109, 109, 42, 109, 92, 62, 110, 110, 62, 110, 94, 42, 111, 111, 42, 111, 94, 62, 112, 112, 62, 112, 96, 42, 113, 113, 42, 113, 96, 62, 114, 114, 62, 114, 98, 42, 115, 115, 42, 115, 98, 18, 116, 116, 18, 116, 99, 23, 117, 117, 24, 117, 117, 23, 117, 99, 26, 118, 118, 106, 118, 118, 26, 118, 99, 106, 118, 127, 28, 119, 119, 28, 119, 99, 30, 120, 120, 30, 120, 99, 33, 121, 121, 120, 121, 121, 33, 121, 100, 120, 121, 128, 9, 122, 122, 98, 122, 122, 9, 122, 101, 98, 122, 129, 9, 123, 123, 98, 123, 123, 9, 123, 102, 98, 123, 130, 9, 124, 124, 98, 124, 124, 9, 124, 103, 98, 124, 131, 9, 125, 125, 98, 125, 125, 9, 125, 104, 98, 125, 132, 9, 126, 126, 98, 126, 126, 9, 126, 105, 98, 126, 133, 20, 127, 127, 20, 127, 118, 34, 128, 128, 122, 128, 128, 123, 128, 128, 125, 128, 128, 126, 128, 128, 128, 128, 128, 34, 128, 121, 122, 128, 134, 123, 128, 135, 125, 128, 136, 126, 128, 137, 128, 128, 138, 12, 129, 129, 12, 129, 122, 12, 130, 130, 12, 130, 123, 12, 131, 131, 12, 131, 124, 12, 132, 132, 12, 132, 125, 12, 133, 133, 12, 133, 126, 36, 134, 134, 37, 134, 134, 36, 134, 128, 37, 134, 139, 36, 135, 135, 37, 135, 135, 36, 135, 139, 37, 135, 128, 39, 136, 136, 40, 136, 136, 39, 136, 128, 40, 136, 139, 39, 137, 137, 40, 137, 137, 39, 137, 139, 40, 137, 128, 42, 138, 138, 42, 138, 128, 34, 139, 139, 122, 139, 139, 123, 139, 139, 125, 139, 139, 126, 139, 139, 128, 139, 139, 34, 139, 140, 122, 139, 135, 123, 139, 134, 125, 139, 137, 126, 139, 136, 128, 139, 141, 120, 140, 140, 33, 140, 140, 120, 140, 139, 42, 141, 141, 42, 141, 139)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(65, 2, 456, 466, 157, 2, 845, 173, 65, 3, 456, 467, 157, 3, 846, 173, 65, 4, 456, 468, 65, 5, 174, 837, 157, 5, 847, 173, 65, 6, 175, 837, 157, 6, 848, 173, 65, 7, 456, 469, 157, 7, 849, 173, 65, 8, 456, 470, 65, 9, 174, 838, 157, 9, 850, 173, 65, 10, 175, 838, 157, 10, 851, 173, 65, 11, 456, 471, 65, 12, 174, 839, 157, 12, 852, 173, 65, 13, 175, 839, 157, 13, 853, 173, 65, 14, 174, 840, 65, 15, 175, 840, 157, 16, 854, 173, 90, 17, 176, 834, 90, 18, 177, 834, 90, 19, 457, 459, 90, 20, 457, 458, 90, 21, 457, 457, 90, 22, 178, 834, 90, 23, 458, 459, 90, 24, 458, 458, 90, 25, 458, 457, 90, 26, 459, 459, 90, 27, 459, 458, 90, 28, 459, 457, 90, 29, 834, 178, 90, 30, 834, 177, 90, 31, 834, 176, 1, 32, 16, 1, 2, 32, 17, 1, 1, 33, 18, 1, 2, 33, 19, 1, 1, 34, 20, 1, 2, 34, 21, 1, 1, 35, 22, 1, 2, 35, 23, 1, 1, 36, 24, 1, 2, 36, 25, 1, 1, 37, 26, 1, 2, 37, 27, 1, 1, 38, 28, 1, 2, 38, 29, 1, 1, 39, 30, 1, 2, 39, 31, 1, 1, 40, 32, 1, 2, 40, 33, 1, 1, 41, 34, 1, 2, 41, 35, 1, 1, 42, 36, 1, 2, 42, 37, 1, 1, 43, 38, 1, 2, 43, 39, 1, 1, 44, 40, 1, 2, 44, 41, 1, 1, 45, 42, 1, 2, 45, 43, 1, 1, 46, 44, 1, 2, 46, 45, 1, 83, 47, 834, 179, 83, 48, 834, 180, 85, 48, 165, 841, 83, 49, 459, 460, 85, 49, 165, 842, 83, 50, 458, 460, 85, 50, 165, 843, 83, 51, 457, 460, 85, 51, 165, 844, 83, 52, 834, 181, 85, 52, 166, 841, 83, 53, 459, 461, 85, 53, 166, 842, 83, 54, 458, 461, 85, 54, 166, 843, 83, 55, 457, 461, 85, 55, 166, 844, 83, 56, 459, 462, 85, 56, 440, 472, 83, 57, 458, 462, 85, 57, 440, 473, 83, 58, 457, 462, 85, 58, 440, 474, 83, 59, 178, 835, 85, 59, 440, 475, 83, 60, 177, 835, 85, 60, 440, 476, 83, 61, 176, 835, 85, 61, 440, 477, 170, 62, 834, 180, 171, 62, 834, 160, 170, 63, 834, 181, 171, 63, 834, 161, 170, 64, 459, 462, 171, 64, 459, 430, 170, 65, 458, 462, 171, 65, 458, 430, 170, 66, 457, 462, 171, 66, 457, 430, 152, 67, 182, 834, 152, 68, 183, 834, 152, 69, 463, 459, 152, 70, 463, 458, 152, 71, 463, 457, 156, 72, 173, 804, 152, 72, 184, 834, 156, 73, 173, 805, 152, 73, 464, 459, 156, 74, 173, 806, 152, 74, 464, 458, 156, 75, 173, 807, 152, 75, 464, 457, 156, 76, 173, 808, 152, 76, 465, 459, 156, 77, 173, 809, 152, 77, 465, 458, 156, 78, 173, 810, 152, 78, 465, 457, 156, 79, 173, 811, 152, 79, 836, 178, 156, 80, 173, 812, 152, 80, 836, 177, 156, 81, 173, 813, 152, 81, 836, 176, 81, 82, 742, 173, 89, 85, 718, 173, 89, 86, 719, 173, 89, 87, 720, 173, 89, 88, 721, 173, 158, 89, 836, 173, 169, 92, 841, 159, 169, 94, 842, 159, 169, 96, 843, 159, 169, 98, 844, 159, 110, 100, 855, 173, 24, 118, 185, 856, 33, 141, 186, 857)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 5: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=5
nb_c=39
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=1025 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(65, 0, 0, 157, 0, 0, 65, 1, 1, 157, 1, 1, 65, 2, 2, 157, 2, 2, 157, 3, 3, 65, 3, 3, 157, 3, 31, 65, 4, 4, 157, 4, 4, 65, 5, 5, 157, 5, 5, 78, 6, 6, 90, 6, 6, 78, 6, 18, 78, 7, 7, 90, 7, 7, 78, 7, 19, 78, 8, 8, 90, 8, 8, 78, 8, 20, 78, 9, 9, 90, 9, 9, 78, 9, 21, 78, 10, 10, 90, 10, 10, 78, 10, 22, 78, 11, 11, 90, 11, 11, 78, 11, 23, 165, 12, 12, 172, 12, 12, 1, 12, 12, 2, 12, 12, 165, 12, 18, 172, 12, 25, 165, 13, 13, 172, 13, 13, 1, 13, 13, 2, 13, 13, 165, 13, 19, 172, 13, 26, 165, 14, 14, 172, 14, 14, 1, 14, 14, 2, 14, 14, 165, 14, 20, 172, 14, 27, 165, 15, 15, 172, 15, 15, 1, 15, 15, 2, 15, 15, 165, 15, 21, 172, 15, 28, 165, 16, 16, 172, 16, 16, 1, 16, 16, 2, 16, 16, 165, 16, 22, 172, 16, 29, 165, 17, 17, 172, 17, 17, 1, 17, 17, 2, 17, 17, 165, 17, 23, 172, 17, 30, 79, 18, 18, 164, 18, 18, 83, 18, 18, 85, 18, 18, 79, 18, 12, 164, 18, 6, 79, 19, 19, 164, 19, 19, 83, 19, 19, 85, 19, 19, 79, 19, 13, 164, 19, 7, 79, 20, 20, 164, 20, 20, 83, 20, 20, 85, 20, 20, 79, 20, 14, 164, 20, 8, 79, 21, 21, 164, 21, 21, 83, 21, 21, 85, 21, 21, 79, 21, 15, 164, 21, 9, 79, 22, 22, 164, 22, 22, 83, 22, 22, 85, 22, 22, 79, 22, 16, 164, 22, 10, 79, 23, 23, 164, 23, 23, 83, 23, 23, 85, 23, 23, 79, 23, 17, 164, 23, 11, 70, 24, 24, 170, 24, 24, 147, 24, 24, 170, 24, 24, 171, 24, 24, 70, 24, 25, 170, 24, 32, 147, 24, 33, 86, 25, 25, 156, 25, 25, 152, 25, 25, 86, 25, 12, 156, 25, 24, 86, 26, 26, 156, 26, 26, 152, 26, 26, 86, 26, 13, 86, 27, 27, 156, 27, 27, 152, 27, 27, 86, 27, 14, 86, 28, 28, 156, 28, 28, 152, 28, 28, 86, 28, 15, 86, 29, 29, 156, 29, 29, 152, 29, 29, 86, 29, 16, 86, 30, 30, 156, 30, 30, 152, 30, 30, 86, 30, 17, 71, 31, 31, 94, 31, 31, 89, 31, 31, 71, 31, 3, 94, 31, 34, 84, 32, 32, 169, 32, 32, 84, 32, 24, 61, 33, 33, 148, 33, 33, 128, 33, 33, 61, 33, 24, 148, 33, 35, 128, 33, 36, 8, 34, 34, 95, 34, 34, 8, 34, 31, 95, 34, 37, 62, 35, 35, 62, 35, 33, 42, 36, 36, 42, 36, 33, 9, 37, 37, 98, 37, 37, 9, 37, 34, 98, 37, 38, 12, 38, 38, 12, 38, 37)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(65, 1, 456, 837, 157, 1, 1094, 173, 65, 2, 456, 838, 157, 2, 1095, 173, 65, 3, 456, 839, 157, 3, 1096, 173, 65, 4, 456, 840, 65, 5, 174, 1092, 157, 5, 1097, 173, 65, 6, 175, 1092, 157, 6, 1098, 173, 90, 7, 457, 834, 90, 8, 458, 834, 90, 9, 459, 834, 90, 10, 834, 459, 90, 11, 834, 458, 90, 12, 834, 457, 1, 13, 4, 1, 2, 13, 5, 1, 1, 14, 6, 1, 2, 14, 7, 1, 1, 15, 8, 1, 2, 15, 9, 1, 1, 16, 10, 1, 2, 16, 11, 1, 1, 17, 12, 1, 2, 17, 13, 1, 1, 18, 14, 1, 2, 18, 15, 1, 83, 19, 834, 460, 85, 19, 165, 1093, 83, 20, 834, 461, 85, 20, 166, 1093, 83, 21, 834, 462, 85, 21, 440, 841, 83, 22, 459, 835, 85, 22, 440, 842, 83, 23, 458, 835, 85, 23, 440, 843, 83, 24, 457, 835, 85, 24, 440, 844, 170, 25, 834, 462, 171, 25, 834, 430, 152, 26, 463, 834, 156, 27, 173, 1072, 152, 27, 464, 834, 156, 28, 173, 1073, 152, 28, 465, 834, 156, 29, 173, 1074, 152, 29, 836, 459, 156, 30, 173, 1075, 152, 30, 836, 458, 156, 31, 173, 1076, 152, 31, 836, 457, 89, 32, 1011, 173, 169, 33, 1093, 159)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 6: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=6
nb_c=5
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=1064 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(65, 0, 0, 157, 0, 0, 78, 1, 1, 90, 1, 1, 78, 1, 3, 165, 2, 2, 172, 2, 2, 1, 2, 2, 2, 2, 2, 165, 2, 3, 172, 2, 4, 79, 3, 3, 164, 3, 3, 83, 3, 3, 85, 3, 3, 79, 3, 2, 164, 3, 1, 86, 4, 4, 156, 4, 4, 152, 4, 4, 86, 4, 2)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(65, 1, 456, 1092, 157, 1, 1184, 173, 90, 2, 834, 834, 1, 3, 2, 1, 2, 3, 3, 1, 83, 4, 834, 835, 85, 4, 440, 1093, 156, 5, 173, 1177, 152, 5, 836, 834)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

# weight count
nb_rw=6
# cumomer count by weight
nb_rcumos=c(231, 359, 293, 142, 39, 5)
nbc_cumos=c(0, cumsum(nb_rcumos))
# cumo names
nm_rcumo=c("Suc:1", "Suc:2", "Suc:4", "Suc:8", "ICit:1", "ICit:2", "ICit:4", "ICit:8", "ICit:16", "ICit:32", "PEP:1", "PEP:2", "PEP:4", "PGA:1", "PGA:2", "PGA:4", "FruBP:1", "FruBP:2", "FruBP:4", "FruBP:8", "FruBP:16", "FruBP:32", "Glc6P:1", "Glc6P:2", "Glc6P:4", "Glc6P:8", "Glc6P:16", "Glc6P:32", "Fru6P:1", "Fru6P:2", "Fru6P:4", "Fru6P:8", "Fru6P:16", "Fru6P:32", "Rib5P:1", "Rib5P:2", "Rib5P:4", "Rib5P:8", "Rib5P:16", "Gnt6P:1", "Gnt6P:2", "Gnt6P:4", "Gnt6P:8", "Gnt6P:16", "Gnt6P:32", "CO2:1", "AcCoA:2", "AcCoA:1", "GA3P:4", "GA3P:2", "GA3P:1", "Sed7P:16", "Sed7P:32", "Sed7P:64", "Pyr:1", "Pyr:2", "Pyr:4", "BM_OAA:1", "BM_PEP:1", "OAA:8", "OAA:4", "OAA:2", "OAA:1", "Ery4P:1", "Ery4P:2", "Ery4P:4", "Ery4P:8", "FTHF:1", "PyrCO2:1", "AKG:1", "AKG:2", "AKG:4", "AKG:8", "AKG:16", "BM_Pyr:2", "BM_Pyr:1", "AKV:4", "Ile:8", "Lys:1", "AKV:2", "Ile:1", "Lys:2", "Lys:4", "Leu:8", "Leu:1", "Gly:1", "Gly:2", "BM_Pyr:4", "BM_PEP:2", "BM_Ery4P:1", "Phe:16", "Phe:1", "Tyr:16", "Tyr:1", "Trp:8", "Phe:32", "Tyr:32", "Trp:16", "BM_Ery4P:8", "BM_Ery4P:4", "BM_Ery4P:2", "Mal:1", "Mal:8", "Mal:2", "Mal:4", "BM_PEP:4", "BM_PGA:1", "BM_PGA:2", "BM_PGA:4", "Sed7P:1", "BM_Rib5P:1", "Sed7P:2", "BM_Rib5P:2", "Sed7P:4", "BM_Rib5P:4", "Sed7P:8", "BM_Rib5P:8", "BM_Rib5P:16", "AKV:16", "Chor:64", "BM_OAA:8", "Arg:1", "BM_AcCoA:2", "BM_AcCoA:1", "PyrCO2:2", "PyrCO2:4", "PyrCO2:8", "Asp:1", "Thr:1", "Met:2", "Asn:1", "DAHP:16", "Chor:128", "BM_OAA:4", "BM_OAA:2", "Ser:1", "His:1", "Met:1", "BM_AKG:1", "BM_AKG:2", "BM_AKG:4", "BM_AKG:8", "BM_AKG:16", "Ala:2", "AKV:8", "Lys:16", "Ala:1", "AKV:1", "Lys:8", "Val:4", "Leu:4", "Val:2", "Leu:2", "Ser:2", "Ser:4", "Ala:4", "Lys:32", "DAHP:32", "Chor:256", "DAHP:1", "Chor:16", "Chor:1", "Chor:32", "DAHP:8", "DAHP:4", "DAHP:2", "DAHP:64", "Chor:512", "His:32", "Trp:1024", "His:16", "Trp:512", "His:8", "Trp:256", "His:4", "Trp:128", "His:2", "Trp:64", "Val:16", "Asp:8", "Thr:8", "Met:16", "Asn:8", "Leu:32", "Leu:16", "Ile:2", "Phe:64", "Tyr:64", "Asp:4", "Thr:4", "Met:8", "Asn:4", "Asp:2", "Thr:2", "Met:4", "Asn:2", "Cys:1", "Glu:1", "Glu:2", "Glu:4", "Glu:8", "Glu:16", "Val:8", "Val:1", "Cys:2", "Cys:4", "Phe:128", "Tyr:128", "Trp:32", "Chor:8", "Chor:4", "Chor:2", "Phe:256", "Tyr:256", "Ile:32", "Ile:16", "Ile:4", "Arg:2", "Arg:4", "Arg:8", "Arg:16", "Arg:32", "Phe:8", "Phe:2", "Tyr:8", "Tyr:2", "Trp:4", "Phe:4", "Tyr:4", "Trp:2", "Trp:1", "Suc:3", "Suc:5", "Suc:9", "Suc:6", "Suc:10", "Suc:12", "ICit:3", "ICit:5", "ICit:6", "ICit:9", "ICit:10", "ICit:12", "ICit:17", "ICit:18", "ICit:20", "ICit:24", "ICit:33", "ICit:34", "ICit:36", "ICit:40", "ICit:48", "PEP:3", "PEP:5", "PEP:6", "PGA:3", "PGA:5", "PGA:6", "FruBP:3", "FruBP:5", "FruBP:6", "FruBP:9", "FruBP:10", "FruBP:12", "FruBP:17", "FruBP:18", "FruBP:20", "FruBP:24", "FruBP:33", "FruBP:34", "FruBP:36", "FruBP:40", "FruBP:48", "Glc6P:3", "Glc6P:5", "Glc6P:6", "Glc6P:9", "Glc6P:10", "Glc6P:12", "Glc6P:17", "Glc6P:18", "Glc6P:20", "Glc6P:24", "Glc6P:33", "Glc6P:34", "Glc6P:36", "Glc6P:40", "Glc6P:48", "Fru6P:3", "Fru6P:5", "Fru6P:6", "Fru6P:9", "Fru6P:10", "Fru6P:12", "Fru6P:17", "Fru6P:18", "Fru6P:20", "Fru6P:24", "Fru6P:33", "Fru6P:34", "Fru6P:36", "Fru6P:40", "Fru6P:48", "Rib5P:3", "Rib5P:5", "Rib5P:6", "Rib5P:9", "Rib5P:10", "Rib5P:12", "Rib5P:17", "Rib5P:18", "Rib5P:20", "Rib5P:24", "Gnt6P:3", "Gnt6P:5", "Gnt6P:6", "Gnt6P:9", "Gnt6P:10", "Gnt6P:12", "Gnt6P:17", "Gnt6P:18", "Gnt6P:20", "Gnt6P:24", "Gnt6P:33", "Gnt6P:34", "Gnt6P:36", "Gnt6P:40", "Gnt6P:48", "AcCoA:3", "GA3P:6", "GA3P:5", "GA3P:3", "Sed7P:48", "Sed7P:80", "Sed7P:96", "Pyr:3", "Pyr:5", "Pyr:6", "OAA:12", "OAA:10", "OAA:6", "OAA:9", "OAA:5", "OAA:3", "Ery4P:3", "Ery4P:5", "Ery4P:6", "Ery4P:9", "Ery4P:10", "Ery4P:12", "AKG:3", "AKG:5", "AKG:6", "AKG:9", "AKG:10", "AKG:12", "AKG:17", "AKG:18", "AKG:20", "AKG:24", "BM_Pyr:3", "AKV:6", "Ile:9", "Lys:3", "Lys:5", "Lys:6", "Leu:9", "Gly:3", "BM_Pyr:6", "BM_Pyr:5", "Phe:48", "Phe:33", "Tyr:48", "Tyr:33", "Trp:24", "BM_Ery4P:12", "BM_Ery4P:10", "BM_Ery4P:6", "Mal:3", "Mal:12", "Mal:5", "Mal:10", "Mal:9", "Mal:6", "BM_PEP:3", "BM_PEP:5", "BM_PEP:6", "BM_PGA:3", "BM_PGA:5", "BM_PGA:6", "Sed7P:3", "BM_Rib5P:3", "Sed7P:5", "BM_Rib5P:5", "Sed7P:6", "BM_Rib5P:6", "Sed7P:9", "BM_Rib5P:9", "Sed7P:10", "BM_Rib5P:10", "Sed7P:12", "BM_Rib5P:12", "Sed7P:17", "BM_Rib5P:17", "Sed7P:18", "BM_Rib5P:18", "Sed7P:20", "BM_Rib5P:20", "Sed7P:24", "BM_Rib5P:24", "BM_AcCoA:3", "PyrCO2:6", "PyrCO2:10", "PyrCO2:12", "BM_OAA:12", "BM_OAA:10", "BM_OAA:6", "BM_OAA:9", "BM_OAA:5", "BM_OAA:3", "BM_Ery4P:3", "BM_Ery4P:5", "BM_Ery4P:9", "BM_AKG:3", "BM_AKG:5", "BM_AKG:6", "BM_AKG:9", "BM_AKG:10", "BM_AKG:12", "BM_AKG:17", "BM_AKG:18", "BM_AKG:20", "BM_AKG:24", "Ala:3", "AKV:9", "Lys:24", "Val:6", "Leu:6", "Ser:6", "Ala:6", "AKV:24", "Lys:48", "Ala:5", "AKV:17", "Lys:40", "Chor:48", "Chor:33", "DAHP:12", "DAHP:10", "DAHP:6", "DAHP:48", "Chor:384", "DAHP:80", "Chor:640", "DAHP:96", "Chor:768", "Ser:3", "Ser:5", "His:48", "Trp:1536", "His:40", "Trp:1280", "His:24", "Trp:768", "His:36", "Trp:1152", "His:20", "Trp:640", "His:12", "Trp:384", "His:34", "Trp:1088", "His:18", "Trp:576", "His:10", "Trp:320", "His:6", "Trp:192", "Leu:48", "Asp:12", "Thr:12", "Met:24", "Asn:12", "Asp:10", "Thr:10", "Met:20", "Asn:10", "Asp:6", "Thr:6", "Met:12", "Asn:6", "Asp:9", "Lys:36", "Thr:9", "Met:18", "Asn:9", "Asp:5", "Lys:20", "Thr:5", "Met:10", "Asn:5", "Asp:3", "Lys:12", "Thr:3", "Met:6", "Asn:3", "DAHP:3", "DAHP:5", "DAHP:9", "Glu:3", "Glu:5", "Glu:6", "Glu:9", "Glu:10", "Glu:12", "Glu:17", "Glu:18", "Glu:20", "Glu:24", "Val:9", "Cys:6", "Val:24", "Val:17", "DAHP:33", "Trp:48", "Chor:12", "Chor:10", "Chor:6", "Phe:192", "Tyr:192", "Chor:80", "Phe:320", "Tyr:320", "Chor:96", "Phe:384", "Tyr:384", "Cys:3", "Cys:5", "Ile:48", "Ile:36", "Ile:20", "Ile:34", "Ile:18", "Ile:6", "Chor:3", "Chor:5", "Chor:9", "Arg:6", "Arg:10", "Arg:12", "Arg:18", "Arg:20", "Arg:24", "Arg:34", "Arg:36", "Arg:40", "Arg:48", "Phe:12", "Phe:6", "Tyr:12", "Tyr:6", "Trp:6", "Phe:10", "Tyr:10", "Trp:5", "Trp:3", "Phe:3", "Phe:24", "Tyr:3", "Tyr:24", "Trp:33", "Phe:5", "Phe:20", "Tyr:5", "Tyr:20", "Trp:34", "Phe:9", "Phe:18", "Tyr:9", "Tyr:18", "Trp:36", "Chor:24", "Chor:20", "Chor:18", "DAHP:24", "Trp:12", "DAHP:20", "Trp:10", "DAHP:18", "Trp:9", "Suc:7", "Suc:11", "Suc:13", "Suc:14", "ICit:7", "ICit:11", "ICit:13", "ICit:14", "ICit:19", "ICit:21", "ICit:22", "ICit:25", "ICit:26", "ICit:28", "ICit:35", "ICit:37", "ICit:38", "ICit:41", "ICit:42", "ICit:44", "ICit:49", "ICit:50", "ICit:52", "ICit:56", "PEP:7", "PGA:7", "FruBP:7", "FruBP:11", "FruBP:13", "FruBP:14", "FruBP:19", "FruBP:21", "FruBP:22", "FruBP:25", "FruBP:26", "FruBP:28", "FruBP:35", "FruBP:37", "FruBP:38", "FruBP:41", "FruBP:42", "FruBP:44", "FruBP:49", "FruBP:50", "FruBP:52", "FruBP:56", "Glc6P:7", "Glc6P:11", "Glc6P:13", "Glc6P:14", "Glc6P:19", "Glc6P:21", "Glc6P:22", "Glc6P:25", "Glc6P:26", "Glc6P:28", "Glc6P:35", "Glc6P:37", "Glc6P:38", "Glc6P:41", "Glc6P:42", "Glc6P:44", "Glc6P:49", "Glc6P:50", "Glc6P:52", "Glc6P:56", "Fru6P:7", "Fru6P:11", "Fru6P:13", "Fru6P:14", "Fru6P:19", "Fru6P:21", "Fru6P:22", "Fru6P:25", "Fru6P:26", "Fru6P:28", "Fru6P:35", "Fru6P:37", "Fru6P:38", "Fru6P:41", "Fru6P:42", "Fru6P:44", "Fru6P:49", "Fru6P:50", "Fru6P:52", "Fru6P:56", "Rib5P:7", "Rib5P:11", "Rib5P:13", "Rib5P:14", "Rib5P:19", "Rib5P:21", "Rib5P:22", "Rib5P:25", "Rib5P:26", "Rib5P:28", "Gnt6P:7", "Gnt6P:11", "Gnt6P:13", "Gnt6P:14", "Gnt6P:19", "Gnt6P:21", "Gnt6P:22", "Gnt6P:25", "Gnt6P:26", "Gnt6P:28", "Gnt6P:35", "Gnt6P:37", "Gnt6P:38", "Gnt6P:41", "Gnt6P:42", "Gnt6P:44", "Gnt6P:49", "Gnt6P:50", "Gnt6P:52", "Gnt6P:56", "GA3P:7", "Sed7P:112", "Pyr:7", "OAA:14", "OAA:13", "OAA:11", "OAA:7", "Ery4P:7", "Ery4P:11", "Ery4P:13", "Ery4P:14", "AKG:7", "AKG:11", "AKG:13", "AKG:14", "AKG:19", "AKG:21", "AKG:22", "AKG:25", "AKG:26", "AKG:28", "Lys:7", "BM_Pyr:7", "BM_Ery4P:14", "Mal:7", "Mal:14", "Mal:11", "Mal:13", "BM_PEP:7", "BM_PGA:7", "Sed7P:7", "BM_Rib5P:7", "Sed7P:11", "BM_Rib5P:11", "Sed7P:13", "BM_Rib5P:13", "Sed7P:14", "BM_Rib5P:14", "Sed7P:19", "BM_Rib5P:19", "Sed7P:21", "BM_Rib5P:21", "Sed7P:22", "BM_Rib5P:22", "Sed7P:25", "BM_Rib5P:25", "Sed7P:26", "BM_Rib5P:26", "Sed7P:28", "BM_Rib5P:28", "PyrCO2:14", "BM_OAA:14", "BM_OAA:13", "BM_OAA:11", "BM_OAA:7", "BM_Ery4P:7", "BM_Ery4P:11", "BM_Ery4P:13", "BM_AKG:7", "BM_AKG:11", "BM_AKG:13", "BM_AKG:14", "BM_AKG:19", "BM_AKG:21", "BM_AKG:22", "BM_AKG:25", "BM_AKG:26", "BM_AKG:28", "Ala:7", "AKV:25", "Lys:56", "DAHP:14", "DAHP:112", "Chor:896", "Ser:7", "His:56", "Trp:1792", "His:52", "Trp:1664", "His:44", "Trp:1408", "His:28", "Trp:896", "His:50", "Trp:1600", "His:42", "Trp:1344", "His:26", "Trp:832", "His:38", "Trp:1216", "His:22", "Trp:704", "His:14", "Trp:448", "Asp:14", "Thr:14", "Met:28", "Asn:14", "Asp:13", "Lys:52", "Thr:13", "Met:26", "Asn:13", "Asp:11", "Lys:44", "Thr:11", "Met:22", "Asn:11", "Asp:7", "Lys:28", "Thr:7", "Met:14", "Asn:7", "DAHP:7", "DAHP:11", "DAHP:13", "Glu:7", "Glu:11", "Glu:13", "Glu:14", "Glu:19", "Glu:21", "Glu:22", "Glu:25", "Glu:26", "Glu:28", "Val:25", "Chor:14", "Chor:112", "Phe:448", "Tyr:448", "Cys:7", "Ile:52", "Ile:50", "Ile:38", "Ile:22", "Chor:7", "Chor:11", "Chor:13", "Arg:14", "Arg:22", "Arg:26", "Arg:28", "Arg:38", "Arg:42", "Arg:44", "Arg:50", "Arg:52", "Arg:56", "Phe:14", "Tyr:14", "Trp:7", "Phe:7", "Phe:28", "Tyr:7", "Tyr:28", "Trp:35", "Phe:11", "Phe:26", "Tyr:11", "Tyr:26", "Trp:37", "Phe:13", "Phe:22", "Tyr:13", "Tyr:22", "Trp:38", "Chor:28", "Chor:26", "Chor:22", "DAHP:28", "Trp:14", "DAHP:26", "Trp:13", "DAHP:22", "Trp:11", "Suc:15", "ICit:15", "ICit:23", "ICit:27", "ICit:29", "ICit:30", "ICit:39", "ICit:43", "ICit:45", "ICit:46", "ICit:51", "ICit:53", "ICit:54", "ICit:57", "ICit:58", "ICit:60", "FruBP:15", "FruBP:23", "FruBP:27", "FruBP:29", "FruBP:30", "FruBP:39", "FruBP:43", "FruBP:45", "FruBP:46", "FruBP:51", "FruBP:53", "FruBP:54", "FruBP:57", "FruBP:58", "FruBP:60", "Glc6P:15", "Glc6P:23", "Glc6P:27", "Glc6P:29", "Glc6P:30", "Glc6P:39", "Glc6P:43", "Glc6P:45", "Glc6P:46", "Glc6P:51", "Glc6P:53", "Glc6P:54", "Glc6P:57", "Glc6P:58", "Glc6P:60", "Fru6P:15", "Fru6P:23", "Fru6P:27", "Fru6P:29", "Fru6P:30", "Fru6P:39", "Fru6P:43", "Fru6P:45", "Fru6P:46", "Fru6P:51", "Fru6P:53", "Fru6P:54", "Fru6P:57", "Fru6P:58", "Fru6P:60", "Rib5P:15", "Rib5P:23", "Rib5P:27", "Rib5P:29", "Rib5P:30", "Gnt6P:15", "Gnt6P:23", "Gnt6P:27", "Gnt6P:29", "Gnt6P:30", "Gnt6P:39", "Gnt6P:43", "Gnt6P:45", "Gnt6P:46", "Gnt6P:51", "Gnt6P:53", "Gnt6P:54", "Gnt6P:57", "Gnt6P:58", "Gnt6P:60", "OAA:15", "Ery4P:15", "AKG:15", "AKG:23", "AKG:27", "AKG:29", "AKG:30", "Mal:15", "Sed7P:15", "BM_Rib5P:15", "Sed7P:23", "BM_Rib5P:23", "Sed7P:27", "BM_Rib5P:27", "Sed7P:29", "BM_Rib5P:29", "Sed7P:30", "BM_Rib5P:30", "BM_OAA:15", "BM_Ery4P:15", "BM_AKG:15", "BM_AKG:23", "BM_AKG:27", "BM_AKG:29", "BM_AKG:30", "His:60", "Trp:1920", "His:58", "Trp:1856", "His:54", "Trp:1728", "His:46", "Trp:1472", "His:30", "Trp:960", "Asp:15", "Lys:60", "Thr:15", "Met:30", "Asn:15", "DAHP:15", "Glu:15", "Glu:23", "Glu:27", "Glu:29", "Glu:30", "Ile:54", "Chor:15", "Arg:30", "Arg:46", "Arg:54", "Arg:58", "Arg:60", "Phe:15", "Phe:30", "Tyr:15", "Tyr:30", "Trp:39", "Chor:30", "DAHP:30", "Trp:15", "ICit:31", "ICit:47", "ICit:55", "ICit:59", "ICit:61", "ICit:62", "FruBP:31", "FruBP:47", "FruBP:55", "FruBP:59", "FruBP:61", "FruBP:62", "Glc6P:31", "Glc6P:47", "Glc6P:55", "Glc6P:59", "Glc6P:61", "Glc6P:62", "Fru6P:31", "Fru6P:47", "Fru6P:55", "Fru6P:59", "Fru6P:61", "Fru6P:62", "Rib5P:31", "Gnt6P:31", "Gnt6P:47", "Gnt6P:55", "Gnt6P:59", "Gnt6P:61", "Gnt6P:62", "AKG:31", "Sed7P:31", "BM_Rib5P:31", "BM_AKG:31", "His:62", "Trp:1984", "Glu:31", "Arg:62", "ICit:63", "FruBP:63", "Glc6P:63", "Fru6P:63", "Gnt6P:63")
nm_list$rcumo=nm_rcumo

if (case_i) {
   # check the coherence of metabolites/cumomers
   met_net=unique(matrix(unlist(strsplit(nm_rcumo, ":", fixed=TRUE)), nrow=2)[1,])
   net_pool=sort(setdiff(met_net, names(nm_poolall)))
   if (length(net_pool) > 0) {
      stop_mes("The following metabolites are internal in NETWORK section but not in METABOLITE_POOLS one:\n"%s+%paste(net_pool, collapse="\n"), file=fcerr)
   }
}

nb_exp=1
nm_exp=c("e_coli")
nm_list$nm_exp=nm_exp
# input cumomer vectors
xi=c(0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1.0, 1)
if (length(xi)) {
   dim(xi)=c(length(xi)/nb_exp, nb_exp)
} else {
   stop_mes("No reduced label entry is defined (may be because no measurement defined in FTBL). Cannot continue.", file=fcerr)
}
nm_xi=c("Gluc_1:63", "Gluc_U:63", "Gluc_1:31", "Gluc_U:31", "Gluc_1:47", "Gluc_U:47", "Gluc_1:55", "Gluc_U:55", "Gluc_1:59", "Gluc_U:59", "Gluc_1:61", "Gluc_U:61", "Gluc_1:62", "Gluc_U:62", "Gluc_1:15", "Gluc_U:15", "Gluc_1:23", "Gluc_U:23", "Gluc_1:27", "Gluc_U:27", "Gluc_1:29", "Gluc_U:29", "Gluc_1:30", "Gluc_U:30", "Gluc_1:39", "Gluc_U:39", "Gluc_1:43", "Gluc_U:43", "Gluc_1:45", "Gluc_U:45", "Gluc_1:46", "Gluc_U:46", "Gluc_1:51", "Gluc_U:51", "Gluc_1:53", "Gluc_U:53", "Gluc_1:54", "Gluc_U:54", "Gluc_1:57", "Gluc_U:57", "Gluc_1:58", "Gluc_U:58", "Gluc_1:60", "Gluc_U:60", "Gluc_1:7", "Gluc_U:7", "Gluc_1:11", "Gluc_U:11", "Gluc_1:13", "Gluc_U:13", "Gluc_1:14", "Gluc_U:14", "Gluc_1:19", "Gluc_U:19", "Gluc_1:21", "Gluc_U:21", "Gluc_1:22", "Gluc_U:22", "Gluc_1:25", "Gluc_U:25", "Gluc_1:26", "Gluc_U:26", "Gluc_1:28", "Gluc_U:28", "Gluc_1:35", "Gluc_U:35", "Gluc_1:37", "Gluc_U:37", "Gluc_1:38", "Gluc_U:38", "Gluc_1:41", "Gluc_U:41", "Gluc_1:42", "Gluc_U:42", "Gluc_1:44", "Gluc_U:44", "Gluc_1:49", "Gluc_U:49", "Gluc_1:50", "Gluc_U:50", "Gluc_1:52", "Gluc_U:52", "Gluc_1:56", "Gluc_U:56", "Gluc_1:3", "Gluc_U:3", "Gluc_1:5", "Gluc_U:5", "Gluc_1:6", "Gluc_U:6", "Gluc_1:9", "Gluc_U:9", "Gluc_1:10", "Gluc_U:10", "Gluc_1:12", "Gluc_U:12", "Gluc_1:17", "Gluc_U:17", "Gluc_1:18", "Gluc_U:18", "Gluc_1:20", "Gluc_U:20", "Gluc_1:24", "Gluc_U:24", "Gluc_1:33", "Gluc_U:33", "Gluc_1:34", "Gluc_U:34", "Gluc_1:36", "Gluc_U:36", "Gluc_1:40", "Gluc_U:40", "Gluc_1:48", "Gluc_U:48", "Gluc_1:1", "Gluc_U:1", "Gluc_1:2", "Gluc_U:2", "Gluc_1:4", "Gluc_U:4", "Gluc_1:8", "Gluc_U:8", "Gluc_1:16", "Gluc_U:16", "Gluc_1:32", "Gluc_U:32")
rownames(xi)=nm_xi
nm_list$xi=nm_xi
nb_xi=length(nm_xi)
nb_f$xi=nb_xi
nb_cumoi=nb_xi
nm_inp=nm_xi
nm_incu=c("one", nm_xi, nm_rcumo)
nm_inlab=nm_incu
spa=spAbr
nm_x=nm_rcumo
nb_x=nb_rcumos
nb_f$rcumos=nb_rcumos
nb_f$cumoi=nb_cumoi
if (emu) {
   nm_emu=c()
   nb_emus=nb_rcumos*(seq_len(nb_rw)+1)
   nb_f$emus=nb_emus
   nm_list$emu=nm_emu
   nm_x=nm_emu
   nb_x=nb_emus
   xiemu=matrix(c(), ncol=nb_exp)
   nm_xiemu=c()
   nm_list$xiemu=nm_xiemu
   rownames(xiemu)=nm_xiemu
   nb_xiemu=length(nm_xiemu)
   nb_f$xiemu=nb_xiemu
   nb_f$xi=nb_xiemu
   nb_xi=nb_xiemu
   nm_inp=nm_xiemu
   xi=xiemu
   nm_inemu=c("one", nm_xiemu, nm_emu)
   nm_inlab=nm_inemu
   spa=spr2emu(spAbr, nm_incu, nm_inemu, nb_f)
}
# reorder indexes to accelerate sparse matrix construction
spa=sparse2spa(spa)
#browser()
# composite labeling vector incu c(1, xi, xc) names
nm_inlab=c("one", nm_inp, nm_x); # the constant 1 has name "one"
nm_list$x=nm_x
nm_list$inp=nm_inp
nb_f$x=nb_x
nm_cumo=NULL

if (TIMEIT) {
   cat("measure : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
if (!noscale) {
   # make place for scaling factors
   nb_sc=vector("integer", 1)
# experiment: 1

   # mass
   # initial values for scales are set later
   param=c(param,0, 0, 0, 0, 0, 0, 0, 0, 0)
   nm_par=c(nm_par,c("1:mass;Fru6P;111111;686", "1:mass;FruBP;111111;672", "1:mass;Glc6P;111111;679", "1:mass;Gnt6P;111111;699", "1:mass;ICit;111111;657", "1:mass;PEP;111;664", "1:mass;PGA;111;668", "1:mass;Rib5P;11111;693", "1:mass;Suc;1111;648"))
   names(param)=nm_par

   nb_param=length(param)
   nb_sc[1]=nb_param-nb_ff # at this moment it is cumulated sum. diff() is taken later

   # indices mapping from scaling to measure matrix row
   # c(1,par)[ir2isc[[iexp]]] replicates scale parameters
   # for corresponding rows of measure matrix
   ir2isc=vector("list", 1)

   # 1:mass
   ir2isc[[1]]=c(ir2isc[[1]],c(22, 22, 22, 22, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 14, 14, 14, 14, 14, 14, 14, 21, 21, 21, 21, 21, 21, 17, 17, 17, 17, 17, 17, 17))

   # cumulated base for nb_sc
   nb_sc_base=c(0, nb_sc[-nb_exp])
   nb_sc=diff(c(0, nb_sc))
   nb_sc_tot=sum(nb_sc)
   nb_f$nb_sc=nb_sc
   nb_f$nb_sc_tot=nb_sc_tot
   nb_f$nb_sc_base=nb_sc_base
#browser()
} else {
   # no scaling
   ir2isc=list()
   nb_sc=integer(nb_exp)
   nb_sc_tot=0
}
nb_f$nb_sc=nb_sc
nb_f$nb_sc_tot=nb_sc_tot
nm_list$par=nm_par

# make a list of sparse measurement matrices
# measmat*xr+memaone gives a vector of simulated not-yet-pooled and not-yet-scaled measurements
# all but 0. Coefficients of 0-cumomers (by defenition equal to 1)
# are all regrouped in the memaone.
nm_measmat=nm_meas=nb_meas=nb_measmat=measmat=memaone=measvec=measdev=ipooled=vector("list", 1)

nm_measmat[[1]]=c("m:Suc:1,2,3,4:1:648", "m:Suc:1,2,3,4:2:649", "m:Suc:1,2,3,4:3:650", "m:Suc:1,2,3,4:4:651", "m:ICit:1,2,3,4,5,6:0:657", "m:ICit:1,2,3,4,5,6:1:658", "m:ICit:1,2,3,4,5,6:2:659", "m:ICit:1,2,3,4,5,6:3:660", "m:ICit:1,2,3,4,5,6:4:661", "m:ICit:1,2,3,4,5,6:5:662", "m:ICit:1,2,3,4,5,6:6:663", "m:PEP:1,2,3:0:664", "m:PEP:1,2,3:1:665", "m:PEP:1,2,3:2:666", "m:PEP:1,2,3:3:667", "m:PGA:1,2,3:0:668", "m:PGA:1,2,3:1:669", "m:PGA:1,2,3:2:670", "m:PGA:1,2,3:3:671", "m:FruBP:1,2,3,4,5,6:0:672", "m:FruBP:1,2,3,4,5,6:1:673", "m:FruBP:1,2,3,4,5,6:2:674", "m:FruBP:1,2,3,4,5,6:3:675", "m:FruBP:1,2,3,4,5,6:4:676", "m:FruBP:1,2,3,4,5,6:5:677", "m:FruBP:1,2,3,4,5,6:6:678", "m:Glc6P:1,2,3,4,5,6:0:679", "m:Glc6P:1,2,3,4,5,6:1:680", "m:Glc6P:1,2,3,4,5,6:2:681", "m:Glc6P:1,2,3,4,5,6:3:682", "m:Glc6P:1,2,3,4,5,6:4:683", "m:Glc6P:1,2,3,4,5,6:5:684", "m:Glc6P:1,2,3,4,5,6:6:685", "m:Fru6P:1,2,3,4,5,6:0:686", "m:Fru6P:1,2,3,4,5,6:1:687", "m:Fru6P:1,2,3,4,5,6:2:688", "m:Fru6P:1,2,3,4,5,6:3:689", "m:Fru6P:1,2,3,4,5,6:4:690", "m:Fru6P:1,2,3,4,5,6:5:691", "m:Fru6P:1,2,3,4,5,6:6:692", "m:Rib5P:1,2,3,4,5:0:693", "m:Rib5P:1,2,3,4,5:1:694", "m:Rib5P:1,2,3,4,5:2:695", "m:Rib5P:1,2,3,4,5:3:696", "m:Rib5P:1,2,3,4,5:4:697", "m:Rib5P:1,2,3,4,5:5:698", "m:Gnt6P:1,2,3,4,5,6:0:699", "m:Gnt6P:1,2,3,4,5,6:1:700", "m:Gnt6P:1,2,3,4,5,6:2:701", "m:Gnt6P:1,2,3,4,5,6:3:702", "m:Gnt6P:1,2,3,4,5,6:4:703", "m:Gnt6P:1,2,3,4,5,6:5:704", "m:Gnt6P:1,2,3,4,5,6:6:705")
nm_meas[[1]]=c("m:Suc:1,2,3,4:1:648", "m:Suc:1,2,3,4:2:649", "m:Suc:1,2,3,4:3:650", "m:Suc:1,2,3,4:4:651", "m:ICit:1,2,3,4,5,6:0:657", "m:ICit:1,2,3,4,5,6:1:658", "m:ICit:1,2,3,4,5,6:2:659", "m:ICit:1,2,3,4,5,6:3:660", "m:ICit:1,2,3,4,5,6:4:661", "m:ICit:1,2,3,4,5,6:5:662", "m:ICit:1,2,3,4,5,6:6:663", "m:PEP:1,2,3:0:664", "m:PEP:1,2,3:1:665", "m:PEP:1,2,3:2:666", "m:PEP:1,2,3:3:667", "m:PGA:1,2,3:0:668", "m:PGA:1,2,3:1:669", "m:PGA:1,2,3:2:670", "m:PGA:1,2,3:3:671", "m:FruBP:1,2,3,4,5,6:0:672", "m:FruBP:1,2,3,4,5,6:1:673", "m:FruBP:1,2,3,4,5,6:2:674", "m:FruBP:1,2,3,4,5,6:3:675", "m:FruBP:1,2,3,4,5,6:4:676", "m:FruBP:1,2,3,4,5,6:5:677", "m:FruBP:1,2,3,4,5,6:6:678", "m:Glc6P:1,2,3,4,5,6:0:679", "m:Glc6P:1,2,3,4,5,6:1:680", "m:Glc6P:1,2,3,4,5,6:2:681", "m:Glc6P:1,2,3,4,5,6:3:682", "m:Glc6P:1,2,3,4,5,6:4:683", "m:Glc6P:1,2,3,4,5,6:5:684", "m:Glc6P:1,2,3,4,5,6:6:685", "m:Fru6P:1,2,3,4,5,6:0:686", "m:Fru6P:1,2,3,4,5,6:1:687", "m:Fru6P:1,2,3,4,5,6:2:688", "m:Fru6P:1,2,3,4,5,6:3:689", "m:Fru6P:1,2,3,4,5,6:4:690", "m:Fru6P:1,2,3,4,5,6:5:691", "m:Fru6P:1,2,3,4,5,6:6:692", "m:Rib5P:1,2,3,4,5:0:693", "m:Rib5P:1,2,3,4,5:1:694", "m:Rib5P:1,2,3,4,5:2:695", "m:Rib5P:1,2,3,4,5:3:696", "m:Rib5P:1,2,3,4,5:4:697", "m:Rib5P:1,2,3,4,5:5:698", "m:Gnt6P:1,2,3,4,5,6:0:699", "m:Gnt6P:1,2,3,4,5,6:1:700", "m:Gnt6P:1,2,3,4,5,6:2:701", "m:Gnt6P:1,2,3,4,5,6:3:702", "m:Gnt6P:1,2,3,4,5,6:4:703", "m:Gnt6P:1,2,3,4,5,6:5:704", "m:Gnt6P:1,2,3,4,5,6:6:705")
nb_meas[[1]]=length(nm_meas[[1]])
nb_measmat[[1]]=length(nm_measmat[[1]])
measmat[[1]]=simple_triplet_zero_matrix(nrow=nb_measmat[[1]], ncol=1069)
dimnames(measmat[[1]])=list(nm_measmat[[1]], nm_x)
memaone[[1]]=numeric(nb_measmat[[1]])
measvec[[1]]=c(0.371605319, 0.360829749, 0.208425325, 0.059139607, 0.131864539419667, 0.225857638569, 0.256421170949333, 0.209230210478667, 0.116863585449667, 0.0457727744643333, 0.0139900806697867, 0.421359839367667, 0.358998301162333, 0.0348521859365667, 0.184789673534, 0.434335785072667, 0.352829683224667, 0.0323479804176, 0.180486551285333, 0.0738121029259333, 0.454450017158667, 0.160823529969333, 0.0944468077710667, 0.105281338489667, 0.0155016033633, 0.0956846003217333, 0.0160587173349, 0.673510772480667, 0.0930110047641, 0.0280359937297, 0.0397315614067667, 0.0145524520950667, 0.135099498189, 0.0235029951295, 0.624253565357667, 0.113068441282333, 0.0456605631765, 0.0516089447155667, 0.0185881765378333, 0.123317313800333, 0.341615670498667, 0.25454117519, 0.159027180368333, 0.113789577528667, 0.0615266612553333, 0.0694997351590667, 0.0249552273874, 0.672556163913, 0.0866890773125333, 0.0313987199704333, 0.0314691889898667, 0.0138168327362333, 0.139114789690333)
measdev[[1]]=c(0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
names(measvec[[1]])=nm_meas[[1]]
names(measdev[[1]])=nm_meas[[1]]
ipooled[[1]]=list(ishort=pmatch(nm_meas[[1]], nm_measmat[[1]]))

nm_meas_tot=unlist(nm_meas)
nb_meas=unlist(nb_meas)
nb_meas_cumo=c(0., cumsum(nb_meas[-nb_exp]))
iexp_meas=lapply(seq_len(nb_exp), function(iexp) seq_len(nb_meas[iexp])+nb_meas_cumo[iexp])
nm_list$meas=nm_meas
nm_list$measmat=nm_measmat
nm_list$meas_tot=nm_meas_tot
nb_f$nb_meas=nb_meas

names(measvec)=names(measdev)=nm_exp

if (!noscale) {
   for (iexp in seq_len(nb_exp))
      ir2isc[[iexp]]=ir2isc[[iexp]][ipooled[[iexp]]$ishort]

   # prepare indexes of dispatching scale params in jacobian
   if (nb_sc_tot > 0) {
      nb_f$is2m=vector("list", nb_exp)
      for (iexp in seq_len(nb_exp)) {
         ipaire=matrix(0, nrow=0, ncol=2)
         tmp=lapply(seq_len(nb_sc[[iexp]]), function(isc) {
            i=which(ir2isc[[iexp]]==isc+nb_sc_base[iexp]+1+nb_ff)
            ipaire <<- rbind(ipaire, cbind(i, isc+nb_sc_base[iexp]))
            return(NULL)
         })
         nb_f$is2m[[iexp]]=ipaire
         # place holder for scale part of jacobian
         jx_f$dr_dsc[[iexp]]=simple_triplet_zero_matrix(nrow=length(ir2isc[[iexp]]), ncol=nb_sc_tot)
      }
   }
}
# prepare measmat indexes and values : ir, ic, val

ind_mema=matrix(c(
1, 1, 1, 1, 591, 3, 1, 592, 3, 1, 593, 3, 1, 232, -2, 1, 233, -2, 1, 234, -2, 1, 884, -4, 1, 2, 1, 1, 594, 3, 1, 235, -2, 1, 236, -2, 1, 3, 1, 1, 237, -2, 1, 4, 1,
2, 232, 1, 2, 884, 6, 2, 591, -3, 2, 592, -3, 2, 233, 1, 2, 593, -3, 2, 235, 1, 2, 594, -3, 2, 234, 1, 2, 236, 1, 2, 237, 1,
3, 591, 1, 3, 884, -4, 3, 592, 1, 3, 593, 1, 3, 594, 1,
4, 884, 1,
5, 238, 1, 5, 239, 1, 5, 240, 1, 5, 241, 1, 5, 242, 1, 5, 243, 1, 5, 885, 1, 5, 244, 1, 5, 245, 1, 5, 246, 1, 5, 886, 1, 5, 247, 1, 5, 887, 1, 5, 888, 1, 5, 889, 1, 5, 248, 1, 5, 249, 1, 5, 250, 1, 5, 890, 1, 5, 251, 1, 5, 891, 1, 5, 892, 1, 5, 893, 1, 5, 252, 1, 5, 894, 1, 5, 895, 1, 5, 896, 1, 5, 897, 1, 5, 898, 1, 5, 899, 1, 5, 1065, 1, 5, 5, -1, 5, 6, -1, 5, 7, -1, 5, 595, -1, 5, 8, -1, 5, 596, -1, 5, 597, -1, 5, 598, -1, 5, 9, -1, 5, 599, -1, 5, 600, -1, 5, 601, -1, 5, 602, -1, 5, 603, -1, 5, 604, -1, 5, 1026, -1, 5, 10, -1, 5, 605, -1, 5, 606, -1, 5, 607, -1, 5, 608, -1, 5, 609, -1, 5, 610, -1, 5, 1027, -1, 5, 611, -1, 5, 612, -1, 5, 613, -1, 5, 1028, -1, 5, 614, -1, 5, 1029, -1, 5, 1030, -1, 5, 1031, -1,
6, 5, 1, 6, 595, 3, 6, 596, 3, 6, 597, 3, 6, 599, 3, 6, 600, 3, 6, 602, 3, 6, 1026, 5, 6, 605, 3, 6, 606, 3, 6, 608, 3, 6, 1027, 5, 6, 611, 3, 6, 1028, 5, 6, 1029, 5, 6, 1030, 5, 6, 238, -2, 6, 239, -2, 6, 241, -2, 6, 885, -4, 6, 244, -2, 6, 886, -4, 6, 887, -4, 6, 888, -4, 6, 248, -2, 6, 890, -4, 6, 891, -4, 6, 892, -4, 6, 894, -4, 6, 895, -4, 6, 897, -4, 6, 1065, -6, 6, 6, 1, 6, 598, 3, 6, 601, 3, 6, 603, 3, 6, 607, 3, 6, 609, 3, 6, 612, 3, 6, 1031, 5, 6, 240, -2, 6, 242, -2, 6, 245, -2, 6, 889, -4, 6, 249, -2, 6, 893, -4, 6, 896, -4, 6, 898, -4, 6, 7, 1, 6, 604, 3, 6, 610, 3, 6, 613, 3, 6, 243, -2, 6, 246, -2, 6, 250, -2, 6, 899, -4, 6, 8, 1, 6, 614, 3, 6, 247, -2, 6, 251, -2, 6, 9, 1, 6, 252, -2, 6, 10, 1,
7, 238, 1, 7, 885, 6, 7, 886, 6, 7, 887, 6, 7, 890, 6, 7, 891, 6, 7, 894, 6, 7, 1065, 15, 7, 595, -3, 7, 596, -3, 7, 599, -3, 7, 1026, -10, 7, 605, -3, 7, 1027, -10, 7, 1028, -10, 7, 1029, -10, 7, 239, 1, 7, 888, 6, 7, 892, 6, 7, 895, 6, 7, 597, -3, 7, 600, -3, 7, 606, -3, 7, 1030, -10, 7, 240, 1, 7, 889, 6, 7, 893, 6, 7, 896, 6, 7, 598, -3, 7, 601, -3, 7, 607, -3, 7, 1031, -10, 7, 241, 1, 7, 897, 6, 7, 602, -3, 7, 608, -3, 7, 242, 1, 7, 898, 6, 7, 603, -3, 7, 609, -3, 7, 243, 1, 7, 899, 6, 7, 604, -3, 7, 610, -3, 7, 244, 1, 7, 611, -3, 7, 245, 1, 7, 612, -3, 7, 246, 1, 7, 613, -3, 7, 247, 1, 7, 614, -3, 7, 248, 1, 7, 249, 1, 7, 250, 1, 7, 251, 1, 7, 252, 1,
8, 595, 1, 8, 1026, 10, 8, 1027, 10, 8, 1028, 10, 8, 885, -4, 8, 886, -4, 8, 890, -4, 8, 1065, -20, 8, 596, 1, 8, 1029, 10, 8, 887, -4, 8, 891, -4, 8, 597, 1, 8, 1030, 10, 8, 888, -4, 8, 892, -4, 8, 598, 1, 8, 1031, 10, 8, 889, -4, 8, 893, -4, 8, 599, 1, 8, 894, -4, 8, 600, 1, 8, 895, -4, 8, 601, 1, 8, 896, -4, 8, 602, 1, 8, 897, -4, 8, 603, 1, 8, 898, -4, 8, 604, 1, 8, 899, -4, 8, 605, 1, 8, 606, 1, 8, 607, 1, 8, 608, 1, 8, 609, 1, 8, 610, 1, 8, 611, 1, 8, 612, 1, 8, 613, 1, 8, 614, 1,
9, 885, 1, 9, 1065, 15, 9, 1026, -5, 9, 1027, -5, 9, 886, 1, 9, 1028, -5, 9, 887, 1, 9, 1029, -5, 9, 888, 1, 9, 1030, -5, 9, 889, 1, 9, 1031, -5, 9, 890, 1, 9, 891, 1, 9, 892, 1, 9, 893, 1, 9, 894, 1, 9, 895, 1, 9, 896, 1, 9, 897, 1, 9, 898, 1, 9, 899, 1,
10, 1026, 1, 10, 1065, -6, 10, 1027, 1, 10, 1028, 1, 10, 1029, 1, 10, 1030, 1, 10, 1031, 1,
11, 1065, 1,
12, 253, 1, 12, 254, 1, 12, 255, 1, 12, 11, -1, 12, 12, -1, 12, 13, -1, 12, 615, -1,
13, 11, 1, 13, 615, 3, 13, 253, -2, 13, 254, -2, 13, 12, 1, 13, 255, -2, 13, 13, 1,
14, 253, 1, 14, 615, -3, 14, 254, 1, 14, 255, 1,
15, 615, 1,
16, 256, 1, 16, 257, 1, 16, 258, 1, 16, 14, -1, 16, 15, -1, 16, 16, -1, 16, 616, -1,
17, 14, 1, 17, 616, 3, 17, 256, -2, 17, 257, -2, 17, 15, 1, 17, 258, -2, 17, 16, 1,
18, 256, 1, 18, 616, -3, 18, 257, 1, 18, 258, 1,
19, 616, 1,
20, 259, 1, 20, 260, 1, 20, 261, 1, 20, 262, 1, 20, 263, 1, 20, 264, 1, 20, 900, 1, 20, 265, 1, 20, 266, 1, 20, 267, 1, 20, 901, 1, 20, 268, 1, 20, 902, 1, 20, 903, 1, 20, 904, 1, 20, 269, 1, 20, 270, 1, 20, 271, 1, 20, 905, 1, 20, 272, 1, 20, 906, 1, 20, 907, 1, 20, 908, 1, 20, 273, 1, 20, 909, 1, 20, 910, 1, 20, 911, 1, 20, 912, 1, 20, 913, 1, 20, 914, 1, 20, 1066, 1, 20, 17, -1, 20, 18, -1, 20, 19, -1, 20, 617, -1, 20, 20, -1, 20, 618, -1, 20, 619, -1, 20, 620, -1, 20, 21, -1, 20, 621, -1, 20, 622, -1, 20, 623, -1, 20, 624, -1, 20, 625, -1, 20, 626, -1, 20, 1032, -1, 20, 22, -1, 20, 627, -1, 20, 628, -1, 20, 629, -1, 20, 630, -1, 20, 631, -1, 20, 632, -1, 20, 1033, -1, 20, 633, -1, 20, 634, -1, 20, 635, -1, 20, 1034, -1, 20, 636, -1, 20, 1035, -1, 20, 1036, -1, 20, 1037, -1,
21, 17, 1, 21, 617, 3, 21, 618, 3, 21, 619, 3, 21, 621, 3, 21, 622, 3, 21, 624, 3, 21, 1032, 5, 21, 627, 3, 21, 628, 3, 21, 630, 3, 21, 1033, 5, 21, 633, 3, 21, 1034, 5, 21, 1035, 5, 21, 1036, 5, 21, 259, -2, 21, 260, -2, 21, 262, -2, 21, 900, -4, 21, 265, -2, 21, 901, -4, 21, 902, -4, 21, 903, -4, 21, 269, -2, 21, 905, -4, 21, 906, -4, 21, 907, -4, 21, 909, -4, 21, 910, -4, 21, 912, -4, 21, 1066, -6, 21, 18, 1, 21, 620, 3, 21, 623, 3, 21, 625, 3, 21, 629, 3, 21, 631, 3, 21, 634, 3, 21, 1037, 5, 21, 261, -2, 21, 263, -2, 21, 266, -2, 21, 904, -4, 21, 270, -2, 21, 908, -4, 21, 911, -4, 21, 913, -4, 21, 19, 1, 21, 626, 3, 21, 632, 3, 21, 635, 3, 21, 264, -2, 21, 267, -2, 21, 271, -2, 21, 914, -4, 21, 20, 1, 21, 636, 3, 21, 268, -2, 21, 272, -2, 21, 21, 1, 21, 273, -2, 21, 22, 1,
22, 259, 1, 22, 900, 6, 22, 901, 6, 22, 902, 6, 22, 905, 6, 22, 906, 6, 22, 909, 6, 22, 1066, 15, 22, 617, -3, 22, 618, -3, 22, 621, -3, 22, 1032, -10, 22, 627, -3, 22, 1033, -10, 22, 1034, -10, 22, 1035, -10, 22, 260, 1, 22, 903, 6, 22, 907, 6, 22, 910, 6, 22, 619, -3, 22, 622, -3, 22, 628, -3, 22, 1036, -10, 22, 261, 1, 22, 904, 6, 22, 908, 6, 22, 911, 6, 22, 620, -3, 22, 623, -3, 22, 629, -3, 22, 1037, -10, 22, 262, 1, 22, 912, 6, 22, 624, -3, 22, 630, -3, 22, 263, 1, 22, 913, 6, 22, 625, -3, 22, 631, -3, 22, 264, 1, 22, 914, 6, 22, 626, -3, 22, 632, -3, 22, 265, 1, 22, 633, -3, 22, 266, 1, 22, 634, -3, 22, 267, 1, 22, 635, -3, 22, 268, 1, 22, 636, -3, 22, 269, 1, 22, 270, 1, 22, 271, 1, 22, 272, 1, 22, 273, 1,
23, 617, 1, 23, 1032, 10, 23, 1033, 10, 23, 1034, 10, 23, 900, -4, 23, 901, -4, 23, 905, -4, 23, 1066, -20, 23, 618, 1, 23, 1035, 10, 23, 902, -4, 23, 906, -4, 23, 619, 1, 23, 1036, 10, 23, 903, -4, 23, 907, -4, 23, 620, 1, 23, 1037, 10, 23, 904, -4, 23, 908, -4, 23, 621, 1, 23, 909, -4, 23, 622, 1, 23, 910, -4, 23, 623, 1, 23, 911, -4, 23, 624, 1, 23, 912, -4, 23, 625, 1, 23, 913, -4, 23, 626, 1, 23, 914, -4, 23, 627, 1, 23, 628, 1, 23, 629, 1, 23, 630, 1, 23, 631, 1, 23, 632, 1, 23, 633, 1, 23, 634, 1, 23, 635, 1, 23, 636, 1,
24, 900, 1, 24, 1066, 15, 24, 1032, -5, 24, 1033, -5, 24, 901, 1, 24, 1034, -5, 24, 902, 1, 24, 1035, -5, 24, 903, 1, 24, 1036, -5, 24, 904, 1, 24, 1037, -5, 24, 905, 1, 24, 906, 1, 24, 907, 1, 24, 908, 1, 24, 909, 1, 24, 910, 1, 24, 911, 1, 24, 912, 1, 24, 913, 1, 24, 914, 1,
25, 1032, 1, 25, 1066, -6, 25, 1033, 1, 25, 1034, 1, 25, 1035, 1, 25, 1036, 1, 25, 1037, 1,
26, 1066, 1,
27, 274, 1, 27, 275, 1, 27, 276, 1, 27, 277, 1, 27, 278, 1, 27, 279, 1, 27, 915, 1, 27, 280, 1, 27, 281, 1, 27, 282, 1, 27, 916, 1, 27, 283, 1, 27, 917, 1, 27, 918, 1, 27, 919, 1, 27, 284, 1, 27, 285, 1, 27, 286, 1, 27, 920, 1, 27, 287, 1, 27, 921, 1, 27, 922, 1, 27, 923, 1, 27, 288, 1, 27, 924, 1, 27, 925, 1, 27, 926, 1, 27, 927, 1, 27, 928, 1, 27, 929, 1, 27, 1067, 1, 27, 23, -1, 27, 24, -1, 27, 25, -1, 27, 637, -1, 27, 26, -1, 27, 638, -1, 27, 639, -1, 27, 640, -1, 27, 27, -1, 27, 641, -1, 27, 642, -1, 27, 643, -1, 27, 644, -1, 27, 645, -1, 27, 646, -1, 27, 1038, -1, 27, 28, -1, 27, 647, -1, 27, 648, -1, 27, 649, -1, 27, 650, -1, 27, 651, -1, 27, 652, -1, 27, 1039, -1, 27, 653, -1, 27, 654, -1, 27, 655, -1, 27, 1040, -1, 27, 656, -1, 27, 1041, -1, 27, 1042, -1, 27, 1043, -1,
28, 23, 1, 28, 637, 3, 28, 638, 3, 28, 639, 3, 28, 641, 3, 28, 642, 3, 28, 644, 3, 28, 1038, 5, 28, 647, 3, 28, 648, 3, 28, 650, 3, 28, 1039, 5, 28, 653, 3, 28, 1040, 5, 28, 1041, 5, 28, 1042, 5, 28, 274, -2, 28, 275, -2, 28, 277, -2, 28, 915, -4, 28, 280, -2, 28, 916, -4, 28, 917, -4, 28, 918, -4, 28, 284, -2, 28, 920, -4, 28, 921, -4, 28, 922, -4, 28, 924, -4, 28, 925, -4, 28, 927, -4, 28, 1067, -6, 28, 24, 1, 28, 640, 3, 28, 643, 3, 28, 645, 3, 28, 649, 3, 28, 651, 3, 28, 654, 3, 28, 1043, 5, 28, 276, -2, 28, 278, -2, 28, 281, -2, 28, 919, -4, 28, 285, -2, 28, 923, -4, 28, 926, -4, 28, 928, -4, 28, 25, 1, 28, 646, 3, 28, 652, 3, 28, 655, 3, 28, 279, -2, 28, 282, -2, 28, 286, -2, 28, 929, -4, 28, 26, 1, 28, 656, 3, 28, 283, -2, 28, 287, -2, 28, 27, 1, 28, 288, -2, 28, 28, 1,
29, 274, 1, 29, 915, 6, 29, 916, 6, 29, 917, 6, 29, 920, 6, 29, 921, 6, 29, 924, 6, 29, 1067, 15, 29, 637, -3, 29, 638, -3, 29, 641, -3, 29, 1038, -10, 29, 647, -3, 29, 1039, -10, 29, 1040, -10, 29, 1041, -10, 29, 275, 1, 29, 918, 6, 29, 922, 6, 29, 925, 6, 29, 639, -3, 29, 642, -3, 29, 648, -3, 29, 1042, -10, 29, 276, 1, 29, 919, 6, 29, 923, 6, 29, 926, 6, 29, 640, -3, 29, 643, -3, 29, 649, -3, 29, 1043, -10, 29, 277, 1, 29, 927, 6, 29, 644, -3, 29, 650, -3, 29, 278, 1, 29, 928, 6, 29, 645, -3, 29, 651, -3, 29, 279, 1, 29, 929, 6, 29, 646, -3, 29, 652, -3, 29, 280, 1, 29, 653, -3, 29, 281, 1, 29, 654, -3, 29, 282, 1, 29, 655, -3, 29, 283, 1, 29, 656, -3, 29, 284, 1, 29, 285, 1, 29, 286, 1, 29, 287, 1, 29, 288, 1,
30, 637, 1, 30, 1038, 10, 30, 1039, 10, 30, 1040, 10, 30, 915, -4, 30, 916, -4, 30, 920, -4, 30, 1067, -20, 30, 638, 1, 30, 1041, 10, 30, 917, -4, 30, 921, -4, 30, 639, 1, 30, 1042, 10, 30, 918, -4, 30, 922, -4, 30, 640, 1, 30, 1043, 10, 30, 919, -4, 30, 923, -4, 30, 641, 1, 30, 924, -4, 30, 642, 1, 30, 925, -4, 30, 643, 1, 30, 926, -4, 30, 644, 1, 30, 927, -4, 30, 645, 1, 30, 928, -4, 30, 646, 1, 30, 929, -4, 30, 647, 1, 30, 648, 1, 30, 649, 1, 30, 650, 1, 30, 651, 1, 30, 652, 1, 30, 653, 1, 30, 654, 1, 30, 655, 1, 30, 656, 1,
31, 915, 1, 31, 1067, 15, 31, 1038, -5, 31, 1039, -5, 31, 916, 1, 31, 1040, -5, 31, 917, 1, 31, 1041, -5, 31, 918, 1, 31, 1042, -5, 31, 919, 1, 31, 1043, -5, 31, 920, 1, 31, 921, 1, 31, 922, 1, 31, 923, 1, 31, 924, 1, 31, 925, 1, 31, 926, 1, 31, 927, 1, 31, 928, 1, 31, 929, 1,
32, 1038, 1, 32, 1067, -6, 32, 1039, 1, 32, 1040, 1, 32, 1041, 1, 32, 1042, 1, 32, 1043, 1,
33, 1067, 1,
34, 289, 1, 34, 290, 1, 34, 291, 1, 34, 292, 1, 34, 293, 1, 34, 294, 1, 34, 930, 1, 34, 295, 1, 34, 296, 1, 34, 297, 1, 34, 931, 1, 34, 298, 1, 34, 932, 1, 34, 933, 1, 34, 934, 1, 34, 299, 1, 34, 300, 1, 34, 301, 1, 34, 935, 1, 34, 302, 1, 34, 936, 1, 34, 937, 1, 34, 938, 1, 34, 303, 1, 34, 939, 1, 34, 940, 1, 34, 941, 1, 34, 942, 1, 34, 943, 1, 34, 944, 1, 34, 1068, 1, 34, 29, -1, 34, 30, -1, 34, 31, -1, 34, 657, -1, 34, 32, -1, 34, 658, -1, 34, 659, -1, 34, 660, -1, 34, 33, -1, 34, 661, -1, 34, 662, -1, 34, 663, -1, 34, 664, -1, 34, 665, -1, 34, 666, -1, 34, 1044, -1, 34, 34, -1, 34, 667, -1, 34, 668, -1, 34, 669, -1, 34, 670, -1, 34, 671, -1, 34, 672, -1, 34, 1045, -1, 34, 673, -1, 34, 674, -1, 34, 675, -1, 34, 1046, -1, 34, 676, -1, 34, 1047, -1, 34, 1048, -1, 34, 1049, -1,
35, 29, 1, 35, 657, 3, 35, 658, 3, 35, 659, 3, 35, 661, 3, 35, 662, 3, 35, 664, 3, 35, 1044, 5, 35, 667, 3, 35, 668, 3, 35, 670, 3, 35, 1045, 5, 35, 673, 3, 35, 1046, 5, 35, 1047, 5, 35, 1048, 5, 35, 289, -2, 35, 290, -2, 35, 292, -2, 35, 930, -4, 35, 295, -2, 35, 931, -4, 35, 932, -4, 35, 933, -4, 35, 299, -2, 35, 935, -4, 35, 936, -4, 35, 937, -4, 35, 939, -4, 35, 940, -4, 35, 942, -4, 35, 1068, -6, 35, 30, 1, 35, 660, 3, 35, 663, 3, 35, 665, 3, 35, 669, 3, 35, 671, 3, 35, 674, 3, 35, 1049, 5, 35, 291, -2, 35, 293, -2, 35, 296, -2, 35, 934, -4, 35, 300, -2, 35, 938, -4, 35, 941, -4, 35, 943, -4, 35, 31, 1, 35, 666, 3, 35, 672, 3, 35, 675, 3, 35, 294, -2, 35, 297, -2, 35, 301, -2, 35, 944, -4, 35, 32, 1, 35, 676, 3, 35, 298, -2, 35, 302, -2, 35, 33, 1, 35, 303, -2, 35, 34, 1,
36, 289, 1, 36, 930, 6, 36, 931, 6, 36, 932, 6, 36, 935, 6, 36, 936, 6, 36, 939, 6, 36, 1068, 15, 36, 657, -3, 36, 658, -3, 36, 661, -3, 36, 1044, -10, 36, 667, -3, 36, 1045, -10, 36, 1046, -10, 36, 1047, -10, 36, 290, 1, 36, 933, 6, 36, 937, 6, 36, 940, 6, 36, 659, -3, 36, 662, -3, 36, 668, -3, 36, 1048, -10, 36, 291, 1, 36, 934, 6, 36, 938, 6, 36, 941, 6, 36, 660, -3, 36, 663, -3, 36, 669, -3, 36, 1049, -10, 36, 292, 1, 36, 942, 6, 36, 664, -3, 36, 670, -3, 36, 293, 1, 36, 943, 6, 36, 665, -3, 36, 671, -3, 36, 294, 1, 36, 944, 6, 36, 666, -3, 36, 672, -3, 36, 295, 1, 36, 673, -3, 36, 296, 1, 36, 674, -3, 36, 297, 1, 36, 675, -3, 36, 298, 1, 36, 676, -3, 36, 299, 1, 36, 300, 1, 36, 301, 1, 36, 302, 1, 36, 303, 1,
37, 657, 1, 37, 1044, 10, 37, 1045, 10, 37, 1046, 10, 37, 930, -4, 37, 931, -4, 37, 935, -4, 37, 1068, -20, 37, 658, 1, 37, 1047, 10, 37, 932, -4, 37, 936, -4, 37, 659, 1, 37, 1048, 10, 37, 933, -4, 37, 937, -4, 37, 660, 1, 37, 1049, 10, 37, 934, -4, 37, 938, -4, 37, 661, 1, 37, 939, -4, 37, 662, 1, 37, 940, -4, 37, 663, 1, 37, 941, -4, 37, 664, 1, 37, 942, -4, 37, 665, 1, 37, 943, -4, 37, 666, 1, 37, 944, -4, 37, 667, 1, 37, 668, 1, 37, 669, 1, 37, 670, 1, 37, 671, 1, 37, 672, 1, 37, 673, 1, 37, 674, 1, 37, 675, 1, 37, 676, 1,
38, 930, 1, 38, 1068, 15, 38, 1044, -5, 38, 1045, -5, 38, 931, 1, 38, 1046, -5, 38, 932, 1, 38, 1047, -5, 38, 933, 1, 38, 1048, -5, 38, 934, 1, 38, 1049, -5, 38, 935, 1, 38, 936, 1, 38, 937, 1, 38, 938, 1, 38, 939, 1, 38, 940, 1, 38, 941, 1, 38, 942, 1, 38, 943, 1, 38, 944, 1,
39, 1044, 1, 39, 1068, -6, 39, 1045, 1, 39, 1046, 1, 39, 1047, 1, 39, 1048, 1, 39, 1049, 1,
40, 1068, 1,
41, 304, 1, 41, 305, 1, 41, 306, 1, 41, 307, 1, 41, 308, 1, 41, 309, 1, 41, 945, 1, 41, 310, 1, 41, 311, 1, 41, 312, 1, 41, 946, 1, 41, 313, 1, 41, 947, 1, 41, 948, 1, 41, 949, 1, 41, 35, -1, 41, 36, -1, 41, 37, -1, 41, 677, -1, 41, 38, -1, 41, 678, -1, 41, 679, -1, 41, 680, -1, 41, 39, -1, 41, 681, -1, 41, 682, -1, 41, 683, -1, 41, 684, -1, 41, 685, -1, 41, 686, -1, 41, 1050, -1,
42, 35, 1, 42, 677, 3, 42, 678, 3, 42, 679, 3, 42, 681, 3, 42, 682, 3, 42, 684, 3, 42, 1050, 5, 42, 304, -2, 42, 305, -2, 42, 307, -2, 42, 945, -4, 42, 310, -2, 42, 946, -4, 42, 947, -4, 42, 948, -4, 42, 36, 1, 42, 680, 3, 42, 683, 3, 42, 685, 3, 42, 306, -2, 42, 308, -2, 42, 311, -2, 42, 949, -4, 42, 37, 1, 42, 686, 3, 42, 309, -2, 42, 312, -2, 42, 38, 1, 42, 313, -2, 42, 39, 1,
43, 304, 1, 43, 945, 6, 43, 946, 6, 43, 947, 6, 43, 677, -3, 43, 678, -3, 43, 681, -3, 43, 1050, -10, 43, 305, 1, 43, 948, 6, 43, 679, -3, 43, 682, -3, 43, 306, 1, 43, 949, 6, 43, 680, -3, 43, 683, -3, 43, 307, 1, 43, 684, -3, 43, 308, 1, 43, 685, -3, 43, 309, 1, 43, 686, -3, 43, 310, 1, 43, 311, 1, 43, 312, 1, 43, 313, 1,
44, 677, 1, 44, 1050, 10, 44, 945, -4, 44, 946, -4, 44, 678, 1, 44, 947, -4, 44, 679, 1, 44, 948, -4, 44, 680, 1, 44, 949, -4, 44, 681, 1, 44, 682, 1, 44, 683, 1, 44, 684, 1, 44, 685, 1, 44, 686, 1,
45, 945, 1, 45, 1050, -5, 45, 946, 1, 45, 947, 1, 45, 948, 1, 45, 949, 1,
46, 1050, 1,
47, 314, 1, 47, 315, 1, 47, 316, 1, 47, 317, 1, 47, 318, 1, 47, 319, 1, 47, 950, 1, 47, 320, 1, 47, 321, 1, 47, 322, 1, 47, 951, 1, 47, 323, 1, 47, 952, 1, 47, 953, 1, 47, 954, 1, 47, 324, 1, 47, 325, 1, 47, 326, 1, 47, 955, 1, 47, 327, 1, 47, 956, 1, 47, 957, 1, 47, 958, 1, 47, 328, 1, 47, 959, 1, 47, 960, 1, 47, 961, 1, 47, 962, 1, 47, 963, 1, 47, 964, 1, 47, 1069, 1, 47, 40, -1, 47, 41, -1, 47, 42, -1, 47, 687, -1, 47, 43, -1, 47, 688, -1, 47, 689, -1, 47, 690, -1, 47, 44, -1, 47, 691, -1, 47, 692, -1, 47, 693, -1, 47, 694, -1, 47, 695, -1, 47, 696, -1, 47, 1051, -1, 47, 45, -1, 47, 697, -1, 47, 698, -1, 47, 699, -1, 47, 700, -1, 47, 701, -1, 47, 702, -1, 47, 1052, -1, 47, 703, -1, 47, 704, -1, 47, 705, -1, 47, 1053, -1, 47, 706, -1, 47, 1054, -1, 47, 1055, -1, 47, 1056, -1,
48, 40, 1, 48, 687, 3, 48, 688, 3, 48, 689, 3, 48, 691, 3, 48, 692, 3, 48, 694, 3, 48, 1051, 5, 48, 697, 3, 48, 698, 3, 48, 700, 3, 48, 1052, 5, 48, 703, 3, 48, 1053, 5, 48, 1054, 5, 48, 1055, 5, 48, 314, -2, 48, 315, -2, 48, 317, -2, 48, 950, -4, 48, 320, -2, 48, 951, -4, 48, 952, -4, 48, 953, -4, 48, 324, -2, 48, 955, -4, 48, 956, -4, 48, 957, -4, 48, 959, -4, 48, 960, -4, 48, 962, -4, 48, 1069, -6, 48, 41, 1, 48, 690, 3, 48, 693, 3, 48, 695, 3, 48, 699, 3, 48, 701, 3, 48, 704, 3, 48, 1056, 5, 48, 316, -2, 48, 318, -2, 48, 321, -2, 48, 954, -4, 48, 325, -2, 48, 958, -4, 48, 961, -4, 48, 963, -4, 48, 42, 1, 48, 696, 3, 48, 702, 3, 48, 705, 3, 48, 319, -2, 48, 322, -2, 48, 326, -2, 48, 964, -4, 48, 43, 1, 48, 706, 3, 48, 323, -2, 48, 327, -2, 48, 44, 1, 48, 328, -2, 48, 45, 1,
49, 314, 1, 49, 950, 6, 49, 951, 6, 49, 952, 6, 49, 955, 6, 49, 956, 6, 49, 959, 6, 49, 1069, 15, 49, 687, -3, 49, 688, -3, 49, 691, -3, 49, 1051, -10, 49, 697, -3, 49, 1052, -10, 49, 1053, -10, 49, 1054, -10, 49, 315, 1, 49, 953, 6, 49, 957, 6, 49, 960, 6, 49, 689, -3, 49, 692, -3, 49, 698, -3, 49, 1055, -10, 49, 316, 1, 49, 954, 6, 49, 958, 6, 49, 961, 6, 49, 690, -3, 49, 693, -3, 49, 699, -3, 49, 1056, -10, 49, 317, 1, 49, 962, 6, 49, 694, -3, 49, 700, -3, 49, 318, 1, 49, 963, 6, 49, 695, -3, 49, 701, -3, 49, 319, 1, 49, 964, 6, 49, 696, -3, 49, 702, -3, 49, 320, 1, 49, 703, -3, 49, 321, 1, 49, 704, -3, 49, 322, 1, 49, 705, -3, 49, 323, 1, 49, 706, -3, 49, 324, 1, 49, 325, 1, 49, 326, 1, 49, 327, 1, 49, 328, 1,
50, 687, 1, 50, 1051, 10, 50, 1052, 10, 50, 1053, 10, 50, 950, -4, 50, 951, -4, 50, 955, -4, 50, 1069, -20, 50, 688, 1, 50, 1054, 10, 50, 952, -4, 50, 956, -4, 50, 689, 1, 50, 1055, 10, 50, 953, -4, 50, 957, -4, 50, 690, 1, 50, 1056, 10, 50, 954, -4, 50, 958, -4, 50, 691, 1, 50, 959, -4, 50, 692, 1, 50, 960, -4, 50, 693, 1, 50, 961, -4, 50, 694, 1, 50, 962, -4, 50, 695, 1, 50, 963, -4, 50, 696, 1, 50, 964, -4, 50, 697, 1, 50, 698, 1, 50, 699, 1, 50, 700, 1, 50, 701, 1, 50, 702, 1, 50, 703, 1, 50, 704, 1, 50, 705, 1, 50, 706, 1,
51, 950, 1, 51, 1069, 15, 51, 1051, -5, 51, 1052, -5, 51, 951, 1, 51, 1053, -5, 51, 952, 1, 51, 1054, -5, 51, 953, 1, 51, 1055, -5, 51, 954, 1, 51, 1056, -5, 51, 955, 1, 51, 956, 1, 51, 957, 1, 51, 958, 1, 51, 959, 1, 51, 960, 1, 51, 961, 1, 51, 962, 1, 51, 963, 1, 51, 964, 1,
52, 1051, 1, 52, 1069, -6, 52, 1052, 1, 52, 1053, 1, 52, 1054, 1, 52, 1055, 1, 52, 1056, 1,
53, 1069, 1,

NULL), ncol=3, byrow=T); # close ind_mema creation
measmat[[1]][ind_mema[,1:2,drop=FALSE]]=ind_mema[,3]
memaone[[1]]=c(0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

pwe=ipwe=ip2ipwe=pool_factor=ijpwef=dp_ones=meas2sum=dpw_dpf=ipf_in_ppw=vector("list", nb_exp)
mets_in_res=vector("list", nb_exp)
for (iexp in seq_len(nb_exp)) {
   names(memaone[[iexp]])=nm_measmat[[iexp]]

   # prepare weights of label data for pooled metabs
   # prepare ipwe and ip2ipwe such that pwe[ipwe]=pool[ip2ipwe]
   # gives a good base for weight sum and normalization
   pwe[[iexp]]=double(nb_measmat[[iexp]])+1.
   mets_in_res[[iexp]]=sapply(nm_measmat[[iexp]], function(m) strsplit(m, ":")[[1L]][2L])
   for (po in names(ipooled[[iexp]])) {
      if (po == "ishort") next
      nm_sum=strsplit(po, ":")[[1L]][2L]
      mets=strsplit(nm_sum, "\\+")[[1L]]
      irpo=ipooled[[iexp]][[po]]
      ipwe[[iexp]]=c(ipwe[[iexp]], irpo) # where weighting is
      i=pmatch(mets, names(nm_poolf))
      if (any(!is.na(i))) {
         for (ir in i) {
            if (is.na(ir)) next
            ijpwef[[iexp]]=rbind(ijpwef[[iexp]], cbind(irpo, ir)) # where free pools matter
         }
      }
      ip2ipwe[[iexp]]=c(ip2ipwe[[iexp]], pmatch(mets, names(nm_poolall)))
      mets_in_res[[iexp]][irpo]=mets
   }
   # order ijpwef for sparse matrix ordering
   if (!is.null(ijpwef[[iexp]])) {
      o=order(ijpwef[[iexp]][,2L], ijpwef[[iexp]][,1L])
      ijpwef[[iexp]]=ijpwef[[iexp]][o,,drop=FALSE]
   }
   pool_factor[[iexp]]=as.factor(nm_measmat[[iexp]])
   # free pool in principal pool weight
   ipf_in_ppw[[iexp]]=apply(outer(mets_in_res[[iexp]], names(nm_poolf), "=="), 1, function(v) if(length(w <-which(v))) w else NA)
   ipf_in_ppw[[iexp]][is.na(ipf_in_ppw[[iexp]])]=0L
   dp_ones[[iexp]]=matrix(0., nb_measmat[[iexp]], nb_poolf)
   dp_ones[[iexp]][cbind(ipwe[[iexp]], ipf_in_ppw[[iexp]][ipwe[[iexp]]])]=1.
   
   # matrix for summing weighted measurements
   meas2sum[[iexp]]=simple_triplet_zero_matrix(length(ipooled[[iexp]]$ishort), nb_measmat[[iexp]])
   meas2sum[[iexp]][cbind(pmatch(nm_measmat[[iexp]], nm_measmat[[iexp]][ipooled[[iexp]]$ishort], dup=T),       seq_len(nb_measmat[[iexp]]))]=1.
   dimnames(meas2sum[[iexp]])=list(nm_meas[[iexp]], nm_measmat[[iexp]])
   
   # dpw_dpf - matrix for derivation of pool weights by free pools
   if (nb_poolf > 0L && length(ijpwef[[iexp]]) > 0) {
      # indeed, we'll have to do weight derivation by free pools
      dpw_dpf[[iexp]]=simple_triplet_zero_matrix(nb_measmat[[iexp]], nb_poolf)
      dpw_dpf[[iexp]][ijpwef[[iexp]]]=1.
   }
}


# prepare flux measurements
nm_fmn=nm_net[c("out_Ac")]
nm_list$fmn=nm_fmn
nb_fmn=length(nm_fmn)
nb_f$nb_fmn=nb_fmn

# measured values
fmn=c(0.213)

# SD for flux measurements
fmndev=c(0.0001)
if (nb_fmn)
   names(fmndev)=names(fmn)=nm_fmn

# indices for measured fluxes
# fallnx[ifmn]=>fmn, here fallnx is complete net|xch flux vector
# combining unknown (dependent), free, constrainded and groth fluxes
ifmn=match(nm_fmn, nm_fallnx)

if (TIMEIT) {
   cat("ineq    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
# prepare mi matrix and li vector
# such that mi*fallnx>=li corresponds
# to the inequalities given in ftbl file
nb_ineq=6
mi=matrix(0., nrow=nb_ineq, ncol=nb_fallnx)
li=numeric(nb_ineq)
nm_i=c(c("n:1<=pyk", "n:0.0001<=edd", "n:0.0001<=gnd", "n:0.0001<=zwf", "n:0.0001<=ppc", "n:0.0001<=mae"), c())
dimnames(mi)=list(nm_i, nm_fallnx)
mi[1, nm_net[c("pyk")]]=c(1.0)
li[1]=1
mi[2, nm_net[c("edd")]]=c(1.0)
li[2]=0.0001
mi[3, nm_net[c("gnd")]]=c(1.0)
li[3]=0.0001
mi[4, nm_net[c("zwf")]]=c(1.0)
li[4]=0.0001
mi[5, nm_net[c("ppc")]]=c(1.0)
li[5]=0.0001
mi[6, nm_net[c("mae")]]=c(1.0)
li[6]=0.0001

# add standard limits on [df].xch [0;cupx]
nb_tmp=nrow(mi)
nb_fx=nb_flx+nb_ffx
if (nb_fx) {
   mi=rbind(mi, matrix(0, nrow=2*nb_fx, ncol=nb_fallnx))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, ">=0", sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, ">=0", sep=""))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, "<=", cupx, sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, "<=", cupx, sep=""))
   li=c(li, rep(0, nb_fx), rep(-cupx, nb_fx))
   mi[nb_tmp+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(1., nb_fx)
   mi[nb_tmp+nb_fx+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(-1., nb_fx)
}

nm_inout=grep("^[^c]\\.", nm_net[c("bs_glc6P", "bs_fru6P", "bs_pga_aux", "bs_pga1_aux", "bs_pga2_aux", "bs_pga3_aux", "bs_DHAP", "bs_pyr1_aux", "bs_pyr4_aux", "bs_pyr3_aux", "bs_rib5p1_aux", "bs_rib5p2", "bs_pep3_aux", "bs_pep4_aux", "bs_pep5", "bs_pep6_aux", "bs_accoa_aux", "bs_akg2", "bs_akg3", "bs_akg4_aux", "bs_oaa1_aux", "bs_oaa2_aux", "bs_oaa3_aux", "bs_oaa4", "bs_oaa5_aux", "bs_oaa6_aux", "bs_oaa7_aux", "out_co2", "out_Ac", "out_FTHF", "Glucupt_1", "Glucupt_U")], v=T) # strip out constrained fluxes
nb_inout=length(nm_inout)
if (nb_inout > 0) {
   # add cinout low limits on inout net fluxes
   nb_tmp=nrow(mi)
   # explicit inequalities take precedence over generic ones
   # so eliminate inout fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_inout, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_inout[-i]
   } else {
      nm_tmp=nm_inout
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste("inout ", nm_tmp, ">=", cinout, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(cinout, len_tmp))
   }
}
if (clownr!=0.) {
   # add low limits on net >= clownr for not reversible reactions
   nb_tmp=nrow(mi)
   nm_tmp=nm_net[c("Glucupt_1", "Glucupt_U", "bs_oaa3a", "bs_oaa3b", "bs_pep3a", "bs_pep3b", "bs_pep4a", "bs_pep4b", "bs_glc6P", "bs_fru6P", "bs_pga_aux", "bs_pga1_aux", "bs_pga2_aux", "bs_pga3_aux", "bs_DHAP", "bs_pyr1_aux", "bs_pyr4_aux", "bs_pyr3_aux", "bs_rib5p1_aux", "bs_rib5p2", "bs_pep3_aux", "bs_pep4_aux", "bs_pep5", "bs_pep6_aux", "bs_accoa_aux", "bs_akg2", "bs_akg3", "bs_akg4_aux", "bs_oaa1_aux", "bs_oaa2_aux", "bs_oaa3_aux", "bs_oaa4", "bs_oaa5_aux", "bs_oaa6_aux", "bs_oaa7_aux", "out_co2", "out_Ac", "out_FTHF", "pfk", "zwf", "gnd", "edd", "citsynth", "idh", "akgdh", "mae", "bs_pga", "bs_pga1", "bs_pga2", "bs_pyr", "bs_pyr1", "bs_pyr2", "bs_pyr4", "bs_pyr3", "bs_e4p", "bs_rib5p", "bs_rib5p1", "bs_pep", "bs_pep1", "bs_pep2", "bs_pep6", "bs_pep7", "bs_accoa", "bs_akg", "bs_akg1", "bs_akg4", "bs_oaa", "bs_oaa1", "bs_oaa2", "bs_oaa5", "bs_oaa6", "bs_oaa7")]
   # explicit inequalities take precedence over generic ones
   # so eliminate notrev fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   # search for inout too
   nm_itmp=paste("inout ", nm_tmp, ">=", sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i, fix=T)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }

   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste(nm_tmp, ">=", clownr, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(clownr, len_tmp))
   }
}
nb_fn=nb_fln+nb_ffn
if (cupn != 0 && nb_fn > 0) {
   # add absolute upper limits on -cupn <= [df].net <= cupn for net fluxes
   # explicit inequalities take precedence over generic ones
   # so eliminate net fluxes which are already in inequalities
   ## proceed n:smth>=flux
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+>=", substring(nm_tmp, 5), sep="")
   i=sapply(vgrep(nm_itmp, nm_i), length)
   i=which(i!=0)
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste0(nm_tmp, "<=", cupn))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(-1., len_tmp)
   }
   ## proceed n:smth<=flux
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(vgrep(nm_itmp, nm_i), length)
   i=which(i!=0)
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste0(nm_tmp, ">=", -cupn))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(1., len_tmp)
   }
}
#browser()
nb_ineq=NROW(li);

dimnames(mi)=list(nm_i, nm_fallnx)
names(li)=nm_i
# prepare ui matrix and ci vector for optimisation
# ui%*%param-ci>=0
# it is composed of explicite inequalities from ftbl
# and permanent inequalities 0<=xch<=0.999 and scale>=0

# constraints such that ui%*%param-ci>=0
# first flux part
ui=mi%*%(md%*%invAfl%stm%p2bfl+mf)
mic=(md%*%invAfl%*%(c2bfl%stm%fc+cnst2bfl) + mc%*%fc)
ci=as.numeric(li-mi%*%mic)

# finaly, metab part
uip=matrix(0., 0, ncol=nb_poolf)
colnames(uip)=nm_poolf
cip=c()
# ind: irow, metab, coef, rhs, name
uip_ind=c(

)
if (length(uip_ind) > 0) {
   uip_ind=matrix(uip_ind, byrow=T, ncol=5L)
} else {
   uip_ind=matrix(0, 0L, 5L)
}
colnames(uip_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(uip_ind) > 0) {
   # rhs are summed up for the same irow by aggregate()
   irow=as.integer(uip_ind[,"irow"])
   cip=aggregate(as.double(uip_ind[,"rhs"]), by=list(irow), sum)[,"x"]
   for (i in seq_len(nrow(uip_ind))) {
      row=uip_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      uip[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(uip) > 0) {
      rownames(uip)=paste("m:", uip_ind[pmatch(seq_len(nrow(uip)), irow),"name"], sep="")
   }
}
names(cip)=rownames(uip)

#browser() # before null inequality removing
# remove all zero rows in ui (constrained fluxes with fixed values)
# find zero indexes
#print(dim(ui))
if (ncol(ui)) {
   zi=apply(ui,1,function(v){return(max(abs(v))<=1.e-14)})
} else {
   # remove all flux inequalities as there is no free fluxe
   zi=rep(TRUE, nrow(ui))
}

if (!all(ci[zi]<=1.e-10)) {
   cat("The following constant inequalities are not satisfied:\n", file=fcerr)
   cat(nm_i[zi][ci[zi]>1.e-10], sep="\n", file=fcerr)
   cat("They are simply ignored.\n", file=fcerr)
   #stop_mes("", file=fcerr)
}
ui=ui[!zi,,drop=FALSE]
ci=ci[!zi]
nm_i=nm_i[!zi]

# complete ui by zero columns corresponding to scale params
if (nb_sc_tot) {
   ui=cBind(as.matrix(ui), matrix(0., NROW(ui), nb_sc_tot))
   # complete ui by scales >=0
   ui=rBind(ui, cBind(matrix(0, nb_sc_tot, nb_ff), diag(1, nb_sc_tot)))
   ci=c(ci,rep(0., nb_sc_tot))
   nm_i=c(nm_i, paste(nm_par[nb_ff+seq_len(nb_sc_tot)], ">=0", sep=""))
   rownames(ui)=nm_i
   names(ci)=nm_i
}

# remove redundant inequalities
#browser()
nb_i=nrow(ui)
ired=c()
if (nb_i > 1L) {
   for (i in 1L:(nb_i-1L)) {
      nmref=nm_i[i]
      for (j in setdiff((i+1L):nb_i, ired)) {
         if (all(ui[j,]==ui[i,]) && ci[i]==ci[j]) {
            # redundancy
            cat("inequality '", nm_i[j], "' redundant with '", nmref, "' is removed.
", sep="", file=fclog)
            ired=c(ired, j)
         }
      }
   }
}
if (!is.null(ired)) {
   # remove all ired inequalities
   ui=ui[-ired,,drop=FALSE]
   ci=ci[-ired]
   nm_i=nm_i[-ired]
}

# metabolite equalities
ep=matrix(0., 0, ncol=nb_poolf)
cp=c()
colnames(ep)=nm_poolf
# ind: irow, metab, coef, rhs, name
ep_ind=c(

)
if (length(ep_ind) > 0) {
   ep_ind=matrix(ep_ind, byrow=T, ncol=5L)
} else {
   ep_ind=matrix(0, 0L, 5L)
}
colnames(ep_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(ep_ind) > 0) {
   # rhs are summed up for the same irow by aggregate
   irow=as.integer(ep_ind[,"irow"])
   cp=aggregate(as.double(ep_ind[,"rhs"]), by=list(irow))[,"x"]
   for (i in seq_len(nrow(ep_ind))) {
      row=ep_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      ep[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(ep) > 0) {
      rownames(ep)=paste("m:", ep_ind[pmatch(seq_len(nrow(ep)), irow),"name"], sep="")
   }
}
ep=as.matrix(ep)
names(cp)=rownames(ep)

nb_sys=list(
   reactions=list(
      reversible=14,
      non_reversible=72
   ),
   fluxes=list(
      free=12,
      dependent=55,
      constrained=105
   ),
   metabolites=list(
      input=2,
      output=30,
      intra=49
   ),
   measurements=list(
      flux=1,
      mass=53,
      peak=0,
      label=0,
      metab=0
   ),
   equations=list(
      equalities=6,
      inequalities=6
   ),
   label_variables=list(
      full=c(0,0,0,0,0,0,0,0,0,0,0),
      reduced_cumomers=c(231,359,293,142,39,5)
   ),
   parallel_experiments=1
)
if (sum(nb_sys$label_variables$full)==0) {
   nb_sys$label_variables$full=NULL
}
if (emu) {
   x=nb_sys$label_variables$reduced_cumomers
   nb_sys$label_variables$reduced_cumomers=NULL
   nb_sys$label_variables$emu=paste(x, "*", seq_len(length(x)), "=", x*seq_len(length(x)))
}

#browser()

# extend param vector by free pools
if (nb_poolf > 0) {
   param=c(param, poolf)
   nm_par=c(nm_par, nm_poolf)
   nb_param=length(param)
}
nm_list$par=nm_par

#browser()
if (nb_poolf > 0) {
   # extend inequalities ui, ci by uip, cip
   nb_row=nrow(ui)
   nb_col=ncol(ui)
   ui=cbind(ui, matrix (0., nrow=nb_row, ncol=nb_poolf)) # add 0-columns
   ui=rbind(ui, cbind(matrix(0., nrow(uip), ncol=nb_col), uip))
   ci=c(ci, cip)
   
   # extend inequalities ui, ci by cupp>= poolf >= clowp
   # but exclude metabolites that are individually set in the uip (FTBL)
   met_low=met_up=c()
   if (nrow(uip) > 0) {
      # number of non zero entries per row in uip
      i_nz=rowSums(abs(uip) != 0.)
      # number of positive coeffs for alone metabs (i.e. low limit is set)
      i_pos=colSums(uip[i_nz > 0,,drop=FALSE] > 0)
      met_low=nm_poolf[i_pos > 0]
      # number of negative coeffs for alone metabs (i.e. upper limit is set)
      i_neg=colSums(uip[i_nz > 0,,drop=FALSE] < 0)
      met_up=nm_poolf[i_neg > 0]
   }

   # add low limit
   nb_add=nb_poolf-length(met_low)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_low]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(1., nb_add)
      rownames(ui_add)=paste(nm_add, ">=", clowp, sep="")
      if (nrow(ui)) {
         ui=rbind(ui, ui_add)
      } else {
         ui=ui_add
      }
      ci=c(ci, rep(clowp, nb_add))
   }

   # add upper limit
   nb_add=nb_poolf-length(met_up)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_up]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(-1., nb_add)
      rownames(ui_add)=paste(nm_add, "<=", cupp, sep="")
      ui=rbind(ui, ui_add)
      ci=c(ci, rep(-cupp, nb_add))
   }

   nm_i=names(ci)=rownames(ui)
   colnames(ui)=nm_par
}
# extend the matrix of metabolite equalities
ep=cbind(matrix(0., nrow(ep), nb_param-nb_poolf), ep)
colnames(ep)=nm_par

# prepare metabolite pools measurements
nb_poolm=0
nb_f$nb_poolm=nb_poolm
nm_poolm=c()
nm_list$poolm=nm_poolm

# measured values
vecpoolm=c()
names(vecpoolm)=nm_poolm

# inverse of variance for pool measurements
poolmdev=c()
names(poolmdev)=nm_poolm

# simulated metabolite measurements are calculated as
# measmatpool*poolall=>poolm
measmatpool=matrix(0., nrow=nb_poolm, ncol=length(poolall))
dimnames(measmatpool)=list(nm_poolm, nm_poolall)
i=matrix(1+c(), ncol=2, byrow=T)
measmatpool[i]=1.


# gather all measurement information
measurements=list(
   vec=list(labeled=measvec, flux=fmn, pool=vecpoolm, kin=if (case_i) measvecti else NULL),
   dev=list(labeled=measdev, flux=fmndev, pool=poolmdev, kin=if (case_i) rep(measdev, nb_ti-1) else NULL),
   mat=list(labeled=measmat, flux=ifmn, pool=measmatpool),
   one=list(labeled=memaone)
)
nm_resid=c(if (case_i) unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, outer(nm_meas[[iexp]], ti[[iexp]][-1L], paste, sep=", t="), sep=":"))) else unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, nm_meas[[iexp]], sep=":"))), nm_fmn, nm_poolm)
nm_list$resid=nm_resid

if (TIMEIT) {
   cat("preopt  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
#browser()
names(param)=nm_par
# prepare series of starting points
if (nchar(fseries) > 0) {
   pstart=as.matrix(read.table(fseries, header=T, row.n=1, sep="\t"))
   # skip parameters (rows) who's name is not in nm_par
   i=rownames(pstart) %in% nm_par
   if (!any(i)) {
      stop_mes("Option --fseries is used but no free parameter with known name is found.\n")
   }
   pstart=pstart[i,,drop=FALSE]
   cat("Using starting values form '", fseries, "' for the following free parameters:\n", paste(rownames(pstart), collapse="\n"), "\n", sep="", file=fclog)
   nseries=ncol(pstart)
   if (initrand) {
      # fill the rest of rows with random values
      i=nm_par %in% rownames(pstart)
      n=sum(!i)
      pstart=rbind(pstart, matrix(runif(n*nseries), n, nseries))
      rownames(pstart)=c(rownames(pstart)[seq_len(nb_param-n)], nm_par[!i])
   }
   if (nchar(iseries) > 0) {
      iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
      iseries=iseries[iseries<=nseries]
      # subsample
      pstart=pstart[,iseries, drop=FALSE]
      nseries=ncol(pstart)
   } else {
      iseries=seq_len(nseries)
   }
} else if (nchar(iseries) > 0) {
   # first construct pstart then if needed fill it with random values
   # and only then subsample
   iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
   nseries=max(iseries)
   pstart=matrix(rep(param, nseries), nrow=nb_param, ncol=nseries)
   dimnames(pstart)=list(nm_par, paste("V", seq_len(nseries), sep=""))
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
   # subsample
   pstart=pstart[,iseries, drop=FALSE]
   nseries=ncol(pstart)
} else {
   iseries=1L
   pstart=as.matrix(param)
   nseries=1L
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
}
nm_pseries=rownames(pstart)

if (is.null(nseries) || nseries==0) {
   stop_mes(sprintf("No starting values in the series file '%s' or --iseries is empty.", fseries),  file=fcerr)
}

pres=matrix(NA, nb_param, nseries)
rownames(pres)=nm_par
colnames(pres)=colnames(pstart)
costres=rep.int(NA, nseries)

# prepare flux index conversion
ifwrv=1:nb_fwrv
names(ifwrv)=nm_fwrv
ifl_in_fw=if (nb_fln) ifwrv[paste("fwd", substring(c(nm_fln, nm_flx), 4), sep="")] else integer(0)
iff_in_fw=if (nb_ff > 0) ifwrv[paste("fwd", substring(c(nm_ffn, nm_ffx), 4), sep="")] else integer(0)
ifg_in_fw=if (nb_fgr > 0) ifwrv[paste("fwd", substring(nm_fgr, 4), sep="")] else integer(0)

# index couples for jacobian df_dfl, df_dffd
cfw_fl=crv_fl=cbind(ifl_in_fw, seq_len(nb_fl))
cfw_ff=crv_ff=cbind(iff_in_fw, seq_len(nb_ff))
cfw_fg=crv_fg=cbind(ifg_in_fw, nb_ff+seq_len(nb_fgr))
crv_fl[,1L]=(nb_fwrv/2)+crv_fl[,1L]
crv_ff[,1L]=(nb_fwrv/2)+crv_ff[,1L]
crv_fg[,1L]=(nb_fwrv/2)+crv_fg[,1L]

# store it in nb_f
nb_f=append(nb_f, list(cfw_fl=cfw_fl, crv_fl=crv_fl, cfw_ff=cfw_ff,
   crv_ff=crv_ff, cfw_fg=cfw_fg, crv_fg=crv_fg))
nb_f=as.environment(nb_f)

nbc_x=c(0, cumsum(nb_x))
nb_f$nbc_x=nbc_x

# fixed part of jacobian (unreduced by SD)
# measured fluxes
dufm_dp=cbind(dufm_dff(nb_f, nm_list), matrix(0, nrow=nb_fmn, ncol=nb_sc_tot+nb_poolf))
dimnames(dufm_dp)=list(nm_fmn, nm_par)

# measured pools
dupm_dp=matrix(0., nb_poolm, nb_ff+nb_sc_tot)
if (nb_poolf > 0L) {
   dupm_dp=cbind(dupm_dp, measurements$mat$pool[,nm_list$poolf, drop=FALSE])
}
dimnames(dupm_dp)=list(rownames(measurements$mat$pool), nm_par)

#browser()
# prepare argument list for passing to label simulating functions
nm_labargs=c("jx_f", "nb_f", "nm_list", "nb_x", "invAfl", "p2bfl", "g2bfl", "bp", "fc", "xi", "spa", "emu", "pool", "measurements", "ipooled", "ir2isc",  "nb_w", "nbc_x", "measmat", "memaone", "dufm_dp", "dupm_dp", "pwe", "ipwe", "ip2ipwe", "pool_factor", "ijpwef", "ipf_in_ppw", "meas2sum", "dp_ones", "clen", "dirr", "dirw", "baseshort", "case_i", "nb_exp", "noscale", "dpw_dpf")

if (TIMEIT) {
   cat("labargs : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
labargs=new.env()
tmp=lapply(nm_labargs, function(nm) assign(nm, get(nm), labargs))
#for (nm in nm_labargs) {
#   labargs[[nm]]=get(nm)
#}
labargs[["nm"]]=labargs[["nm_list"]]

# prepare labargs2 if time_order includes 2
if (case_i && (time_order == "2" || time_order == "1,2")) {
   labargs2=as.environment(as.list(labargs))
   labargs2$nb_f=as.environment(as.list(labargs$nb_f))
   labargs2$tifull=tifull2
   labargs2$jx_f=new.env()
   labargs2$nb_f$ipf2ircumo=nb_f$ipf2ircumo2
   labargs2$nb_f$tifu=nb_f$tifu2
   labargs[["labargs2"]]=labargs2
}

# formated output in kvh file
fkvh_saved=file.path(dirw, sprintf("%s_res.kvh", baseshort))

control_ftbl=list()

retcode=numeric(nseries)
cl_type="PSOCK"
cl=NULL
if ((case_i && (time_order %in% c("1,2", "2"))) || sensitive == "mc") {
   if (np > 1L) {
      # prepare cluster
      nodes=if (sensitive == "mc") np else 2

      # prepare cluster
      cl=makeCluster(nodes, cl_type) #, outfile="cl.log")
#cat("make cluster=")
#print(cl[[1]])
      labargs[["cl"]]=cl
      nodes=length(cl)
      if (TIMEIT) {
         cat("cl expor: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterExport(cl, c("lsi_fun", "df_dffp", "lab_sim", "is.diff", "lab_resid", "ui", "ci", "ep", "cp", "control_ftbl", "method", "sln", "labargs", "dirr", "emu", "%stm%", "case_i", "time_order"))
      if (TIMEIT) {
         cat("cl sourc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterEvalQ(cl, {
         #idth=myinfo$id
         suppressPackageStartupMessages(library(nnls))
         suppressPackageStartupMessages(library(slam)) # for quick sparse matrices
         suppressPackageStartupMessages(library(Rcpp))
         suppressPackageStartupMessages(library(RcppArmadillo))
         suppressPackageStartupMessages(library(rmumps))
         suppressPackageStartupMessages(library(arrApply)) # for fast apply() on arrays
         suppressPackageStartupMessages(library(multbxxc))
         compiler::enableJIT(0)
         source(file.path(dirr, "tools_ssg.R"))
         source(file.path(dirr, "nlsic.R"))
         source(file.path(dirr, "opt_cumo_tools.R"))
         source(file.path(dirr, "opt_icumo_tools.R"))
         #loadcmp(file.path(dirr, "tools_ssg.Rc"))
         #loadcmp(file.path(dirr, "nlsic.Rc"))
         #loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))
         #loadcmp(file.path(dirr, "opt_icumo_tools.Rc"))
         labargs$spa=sparse2spa(labargs$spa)
         if (case_i && (time_order == "2" || time_order == "1,2")) {
            labargs$labargs2$spa=labargs$spa
         }
#cat("evalQ idth=", idth, "\n")
#print(labargs)
#print(labargs$labargs2)
#print(labargs$spa)
#print(labargs$labargs2$spa)
         NULL
      })
      clusterSetRNGStream(cl)
      # set worker id
      idw=parLapply(cl, seq_along(cl), function(i) assign("idw", i, envir=.GlobalEnv))
   } else {
      labargs$cl=NULL
   }
}
for (irun in seq_len(nseries)) {
   if (TIMEIT) {
      cat(sprintf("run %4d: %s cpu=%g\n", irun, format(Sys.time()), proc.time()[1], "\n", sep=""), file=fclog)
   }
   param[nm_pseries]=pstart[nm_pseries, irun]
#browser()
   # prepare kvh file name
   if (nseries > 1) {
      runsuf="." %s+% colnames(pstart)[irun]
   } else {
      runsuf=""
   }
   if (length(nseries) > 0) {
      cat("Starting point", runsuf, "\n", sep="", file=fclog)
   }
   fkvh=file(substring(fkvh_saved, 1, nchar(fkvh_saved)-4) %s+% runsuf %s+% ".kvh", "w");

   # remove zc inequalities from previous runs
   izc=grep("^zc ", nm_i)
   if (length(izc)) {
      ui=ui[-izc,,drop=FALSE]
      ci=ci[-izc]
      nm_i=rownames(ui)
   }
   # check if initial approximation is feasible
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   if (any(ineq <= -1.e-10)) {
      cat("The following ", sum(ineq<= -1.e-10), " ineqalities are not respected at starting point", runsuf, ":\n", sep="", file=fclog)
      i=ineq[ineq<= -1.e-10]
      cat(paste(names(i), i, sep="\t", collapse="\n"), "\n", sep="", file=fclog)
      # put them inside
      capture.output(pinside <- put_inside(param, ui, ci), file=fclog)
      if (any(is.na(pinside))) {
         if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
            # fatal error occured
            cat("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n",
               file=fcerr, sep="")
            close(fkvh)
            retcode[irun]=attr(pinside, "err")
            next;
         }
      } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0) {
         # non fatal problem
         cat(paste("put_inside: ", attr(pinside, "mes"), collapse=""), "\n", file=fcerr)
      }
      param[]=pinside
   }

   # prepare zero crossing strategy
   # inequalities to keep sens of net flux on first call to opt_wrapper()
   # if active they are removed on the second call to opt_wrapper()
   # and finaly all zc constraints are relaxed on the last call to opt_wrapper()
   fallnx=param2fl(param, labargs)$fallnx
   mi_zc=NULL
   li_zc=NULL
   if (zerocross && length(grep("^[df]\\.n\\.", nm_fallnx))>0) {
      if (TIMEIT) {
         cat("zc ineq : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
#browser()
      # prepare fluxes that are already in inequalities in alone mode
      ige=names(which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==1) & li>=0))
      ige=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ige, v=T)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ige, v=T)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ige, v=T))
      ))]
      ile=which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==-1)&li>=0)
      ile=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ile, v=T)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ile, v=T)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ile, v=T))
      ))]
      # add lower limits on [df].net >= zc for positive net fluxes
      # and upper limits on [df].net <= -zc for negative net fluxes
      nm_izc=c()
      ipos=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]>=0.)), ige)
      ineg=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]<0.)), ile)
      mi_zc=matrix(0, nrow=length(ipos)+length(ineg), ncol=nb_fallnx)
      colnames(mi_zc)=nm_fallnx
      if (length(ipos)) {
         nm_izc=c(nm_izc, paste("zc ", ipos, ">=", zc, sep=""))
         mi_zc[(1:length(ipos)),ipos]=diag(1., length(ipos))
      }
      if (length(ineg)) {
         nm_izc=c(nm_izc, paste("zc ", ineg, "<=", -zc, sep=""))
         mi_zc[length(ipos)+(1:length(ineg)),ineg]=diag(-1., length(ineg))
      }
      rownames(mi_zc)=nm_izc
      li_zc=rep(zc, length(nm_izc)) # that's ok for both pos and neg constraints
      ui_zc=cbind(mi_zc%*%(md%*%invAfl%stm%p2bfl+mf),
         matrix(0., nrow=nrow(mi_zc), ncol=nb_sc_tot))
      if (nb_fgr > 0) {
         ui_zc=cbind(ui_zc, mi_zc%*%((md%*%invAfl%stm%g2bfl)+mg*nb_f$mu))
      } else if (nb_poolf > 0) {
         ui_zc=cbind(ui_zc, matrix(0., nrow=nrow(mi_zc), ncol=nb_poolf))
      }
      ci_zc=li_zc-mi_zc%*%mic
      # remove constant inequalities
      if (ncol(ui_zc)) {
         zi=apply(ui_zc,1,function(v){return(max(abs(v))<=1.e-14)})
      } else {
         # remove all flux inequalities as there is no free params
         zi=rep(TRUE, nrow(ui_zc))
      }

      inotsat=ci_zc[zi]>1.e-10
      if (any(inotsat)) {
         cat("Warning: The following constant zc inequalities are not satisfied:\n", file=fcerr)
         cat(nm_izc[zi][inotsat], sep="\n", file=fcerr)
      }
      ui_zc=ui_zc[!zi,,drop=FALSE]
      ci_zc=ci_zc[!zi]
      nm_izc=nm_izc[!zi]
      mi_zc=mi_zc[!zi,,drop=FALSE]

      # remove redundant/contradictory inequalities
      nb_zc=nrow(ui_zc)
      nb_i=nrow(ui)
      ired=c()
      tui=t(ui)
      uzcd=sapply(seq_len(nb_zc), function(i) apply(abs(tui-ui_zc[i,]), 2L, max))
      uzcs=sapply(seq_len(nb_zc), function(i) apply(abs(tui+ui_zc[i,]), 2L, max))
      czcd=abs(outer(abs(ci), abs(ci_zc), "-"))
      ired=which(apply((uzcd < 1.e-10 | uzcs < 1.e-10) & czcd <= 1.e-2, 2, any))
      
      if (length(ired) > 0L) {
         # remove all ired inequalities
         cat("The following ", length(ired), " zerocross inequalities are redundant and are removed:\n", paste(nm_izc[ired], collapse="\n"), "\n", sep="", file=fclog)
         ui_zc=ui_zc[-ired,,drop=FALSE]
         ci_zc=ci_zc[-ired]
         nm_izc=nm_izc[-ired]
         mi_zc=mi_zc[-ired,,drop=FALSE]
      }
      if (nrow(ui_zc)) {
         # add zc inequalities
         ui=rbind(ui, ui_zc)
         ci=c(ci, ci_zc)
         nm_i=c(nm_i, nm_izc)
      }
      rm(ui_zc, ci_zc, uzcd, uzcs, czcd)
   }
   rres=NULL

   # set initial scale values to sum(measvec*simlab/dev**2)/sum(simlab**2/dev**2)
   # for corresponding measurements
   if (nb_sc_tot > 0) {
      if (optimize) {
         if (TIMEIT) {
            cat("res esti: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         capture.output(rres <- lab_resid(param, cjac=FALSE, labargs), file=fclog)
         if (!is.null(rres$err) && rres$err) {
            cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
            close(fkvh)
            retcode[irun]=rres$err
            next
         }
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at init scale values)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         for (iexp in seq_len(nb_exp)) {
            simlab=jx_f$usimlab[[iexp]]
            measinvvar=1./measurements$dev$labeled[[iexp]]**2
            ms=measvec[[iexp]]*simlab*measinvvar
            ss=simlab*simlab*measinvvar
            # get only valid measurements
            iva=!is.na(ms)
            for (i in nb_ff+nb_sc_base[iexp]+seq_len(nb_sc[[iexp]])) {
               im=(ir2isc[[iexp]]==(i+1)) & iva
               if (sum(im) < 2) {
                  mes=sprintf("scaling: no sufficient valid data for scaling factor '%s'\n", nm_par[i])
                  stop_mes(mes, fcerr)
               }
               param[i]=sum(ms[im])/sum(ss[im])
            }
         }
      } else {
         # if no optimization, set all scaling params to 1.
         param[nb_ff+seq_len(nb_sc_tot)]=1.
      }
   }

   # see if there are any active inequalities at starting point
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   if (any(abs(ineq)<=1.e-10)) {
      cat("The following ", sum(abs(ineq)<=1.e-10), " ineqalitie(s) are active at starting point", runsuf, ":\n",
         paste(names(ineq[abs(ineq)<=1.e-10]), collapse="\n"), "\n", sep="", file=fclog)
   }

   if (TIMEIT) {
      cat("kvh init: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }

   cat("influx\n", file=fkvh)
   cat("\tversion\t", vernum, "\n", file=fkvh, sep="")
   cat("\tlabeling\t", if (case_i) "instationary" else "stationary", "\n", file=fkvh, sep="")
   # save options of command line
   cat("\truntime options\n", file=fkvh)
   cat("\t\tTIMEIT=TRUE\n", file=fkvh)
   
   obj2kvh(R.Version(), "R.Version", fkvh, indent=1)
   cat("\tR command line\n", file=fkvh)
   obj2kvh(opts, "opts", fkvh, indent=2)
   cat("\t\texecution date	", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fkvh)

   # resume system sizes
   obj2kvh(nb_sys, "system sizes", fkvh)

   # save initial param
   cat("starting point\n", file=fkvh)
   names(param)=nm_par
   obj2kvh(param, "starting free parameters", fkvh, indent=1)
#browser()
   if (!length(rres)) {
      capture.output(rres <- lab_resid(param, cjac=FALSE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
      if (sum(is.infinite(rres$res))) {
         cat("Infinite values appeared in residual vector (at starting point)", file=fcerr)
         retcode[irun]=1
         close(fkvh)
         next
      }
   }
   rcost=if (length(rres$res) && !all(ina <- is.na(rres$res))) sum(crossprod(rres$res[!ina])) else NA
   obj2kvh(rcost, "starting cost value", fkvh, indent=1)

   obj2kvh(Afl, "flux system (Afl)", fkvh, indent=1)
   fg=numeric(nb_f$nb_fgr)
   names(fg)=nm_list$fgr
   if (nb_f$nb_fgr > 0) {
      fg[paste("g.n.", substring(nm_list$poolf, 4), "_gr", sep="")]=nb_f$mu*param[nm_list$poolf]
   }
   btmp=as.numeric(p2bfl%stm%param[seq_len(nb_f$nb_ff)]+bp+g2bfl%stm%fg)
   names(btmp)=dimnames(Afl)[[1]]
   obj2kvh(btmp, "flux system (bfl)", fkvh, indent=1)

   #cat("mass vector:\n", file=fclog)
   #print_mass(x)

   names(param)=nm_par

#browser()
   if (optimize && nb_ff+nb_poolf > 0L) {
      if (!(least_norm || sln || method!="nlsic")) {
         # check if at starting position all fluxes can be resolved
         if (TIMEIT) {
            cat("check ja: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         rres=lab_resid(param, cjac=TRUE, labargs)
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at identifiability check)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         if (sum(is.infinite(rres$jacobian))) {
            cat("Infinite values appeared in Jacobian (at identifiability check)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         qrj=qr(jx_f$dr_dff, LAPACK=T)
         d=diag(qrj$qr)
         qrj$rank=sum(abs(d)>abs(d[1])*1.e-10)
         if (is.na(qrj$rank)) {
            cat("Rank of starting jacobian could not be estimated.", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         if (qrj$rank) {
            nm_uns=nm_ff[qrj$pivot[-(1:qrj$rank)]]
         } else {
            nm_uns=nm_ff
         }
         if (qrj$rank < nb_ff) {
            # Too bad. The jacobian of free fluxes is not of full rank.
            dimnames(jx_f$dr_dff)[[2]]=c(nm_ffn, nm_ffx)
            fname="dbg_dr_dff_singular" %s+% runsuf %s+% ".csv"
            cat(sprintf("Provided measurements (labeling and fluxes) are not sufficient to resolve all free fluxes.\nUnsolvable fluxes may be:\n%s\nJacobian dr_dff is written in the result kvh file.\n",
               paste(nm_uns, sep=", ", collapse=", ")),
               file=fcerr)
            obj2kvh(jx_f$dr_dff, "Jacobian dr_dff", fkvh, indent=0)
            close(fkvh)
            retcode[irun]=1
            next
         }
      }
      if (TIMEIT) {
         cat("optim   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      # pass control to the chosen optimization method
      if (time_order=="1,2")
         labargs$time_order="1" # start with order 1, later continue with 2
      capture.output(res <- opt_wrapper(param, measurements, jx_f, labargs), file=fclog)
      if ((!is.null(res$err) && res$err) || is.null(res$par)) {
         cat("first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fcerr)
         res$par=rep(NA, length(param))
         res$cost=NA
      } else if (!is.null(res$mes) && nchar(res$mes)) {
         cat("first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fcerr)
      }
      if (any(is.na(res$par))) {
         res$retres$jx_f=NULL # to avoid writing of huge data
         obj2kvh(res, "failed first pass optimization process information", fkvh)
         cat("Optimization failed", runsuf, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=max(res$err, 1)
         next
      }
      param=res$par
#browser()
      if (zerocross && !is.null(mi_zc)) {
         if (TIMEIT) {
            cat("secondzc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         # inverse active "zc" inequalities
         nm_inv=names(which((ui%*%res$par-ci)[,1]<=1.e-10))
         i=grep("^zc ", nm_inv, v=T)
         if (length(i) > 0) {
            i=str2ind(i, nm_i)
            cat("The following inequalities are active after first pass
of zero crossing strategy and will be inverted", runsuf, ":\n", paste(nm_i[i], collapse="\n"), "\n", sep="", file=fclog)
            ipos=grep(">=", nm_i[i], v=T)
            ineg=grep("<=", nm_i[i], v=T)
            ui[i,]=-ui[i,,drop=FALSE]
            if (length(ipos)) {
               ipzc=str2ind(ipos, nm_izc)
               ipos=str2ind(ipos, nm_i)
               ci[ipos]=as.numeric(zc+mi_zc[ipzc,,drop=FALSE]%*%mic)
               nm_i[ipos]=sub(">=", "<=-", nm_i[ipos])
            }
            if (length(ineg)) {
               inzc=str2ind(ineg, nm_izc)
               ineg=str2ind(ineg, nm_i)
               ci[ineg]=as.numeric(zc+mi_zc[inzc,,drop=FALSE]%*%mic)
               nm_i[ineg]=sub("<=-", ">=", nm_i[ineg])
            }
            rownames(ui)=nm_i
            names(ci)=nm_i
            # enforce new inequalities
            reopt=TRUE
            capture.output(pinside <- put_inside(res$par, ui, ci), file=fclog)
            if (any(is.na(pinside))) {
               if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
                  # fatal error occured, don't reoptimize
                  cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
                  reopt=FALSE
               }
            } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0){
               # non fatal problem
               cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
            }
            # reoptimize
            if (reopt) {
               cat("Second zero crossing pass", runsuf, "\n", sep="", file=fclog)
               capture.output(reso <- opt_wrapper(pinside, measurements, new.env(), labargs), file=fclog)
               if (reso$err || is.null(reso$par)) {
                  cat("second zero crossing pass: ", reso$mes, "\n", sep="", file=fcerr)
               } else if (!is.null(reso$mes) && nchar(reso$mes)) {
                  cat("second zero crossing pass", runsuf, ": ", reso$mes, "\n", sep="", file=fcerr)
               }
               if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                  param=reso$par
                  res=reso
                  jx_f=labargs$jx_f
               }
               if (any(is.na(reso$par))) {
                  reso$retres$jx_f=NULL # to avoid writing of huge data
                  obj2kvh(reso, "failed second pass optimization process information", fkvh)
                  cat("Second zero crossing pass failed. Keep free parameters from previous pass", runsuf, "\n", file=fcerr, sep="")
               }
            }
            # last pass, free all zc constraints
            i=grep("^zc ", nm_i)
            if (length(i) > 0) {
               if (TIMEIT) {
                  cat("last zc : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
               }
               ui=ui[-i,,drop=FALSE]
               ci=ci[-i]
               nm_i=nm_i[-i]
               cat("Last zero crossing pass (free of zc constraints)", runsuf, "\n", sep="", file=fclog)
               capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
               if (reso$err || is.null(reso$par) || (!is.null(res$mes) && nchar(res$mes))) {
                  cat("last zero crossing (free of zc)", runsuf, ": ", reso$mes, "\n", sep="", file=fcerr)
               }
               if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                  param=reso$par
                  res=reso
                  jx_f=labargs$jx_f
               }
               if (any(is.na(res$par))) {
                  res$retres$jx_f=NULL # to avoid writing of huge data
                  obj2kvh(res, "failed last pass optimization process information", fkvh)
                  cat("Last zero crossing pass failed. Keep free parameters from previous passes", runsuf, "\n", file=fcerr, sep="")
               }
            }
         } else {
            cat("After the first optimization, no zero crossing inequality was activated. So no reoptimization", runsuf, "\n", sep="", file=fclog)
         }
      } # end if zero crossing
      param=res$par
      names(param)=nm_par
      if (excl_outliers != F) {
         # detect outliers
         if (TIMEIT) {
            cat("outliers: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         iva=!is.na(res$res)
         zpval=rz.pval.bi(res$res)
         iout=which(zpval <= excl_outliers & iva)
         #cat("iout=", iout, "\n", file=fclog)
         if (length(iout)) {
            measurements$outlier=iout
            outtab=cbind(residual=res$res[iout], `p-value`=zpval[iout])
            row.names(outtab)=nm_resid[iout]
            cat("Excluded outliers at p-value ", excl_outliers, ":\n", sep="", file=fclog)
            write.table(outtab, file=fclog, append=TRUE, quote=FALSE, sep="\t", col.names=FALSE)
            
            capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
            if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
               cat("wo outliers: ", reso$mes, "\n", sep="", file=fcerr)
            }
            if (any(is.na(reso$par))) {
               cat("Optimization with outliers excluded has failed, run= ", runsuf, "\n", file=fcerr, sep="")
               # continue without outlier exclusion
               measurements$outlier=NULL
            } else {
               res=reso
               param=reso$par
               names(param)=nm_par
               jx_f=labargs$jx_f
               labargs$measurements=measurements # store outliers
               obj2kvh(outtab, "excluded outliers", fkvh)
            }
         } else {
            cat("Outlier exclusion at p-value "%s+%excl_outliers%s+%" has been requested but no outlier was detected at this level.", "\n", sep="", file=fcerr)
         }
      }
      if (case_i && time_order=="1,2") {
         if (TIMEIT) {
            cat("order 2 : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         labargs$time_order="2" # continue with the 2-nd order
         capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
         if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
            cat("order2: ", reso$mes, "\n", sep="", file=fcerr)
         }
         if (any(is.na(reso$par))) {
            cat("Optimization time_order 2 (in '1,2' suite) has failed, run=", runsuf, "\n", file=fcerr, sep="")
         } else {
            res=reso
            param=reso$par
            names(param)=nm_par
            jx_f=labargs$jx_f
         }
      }
#browser()
      optinfo=list(
         "fitted parameters"=param,
         "last increment before backtracking"=res$lastp,
         "last increment after backtracking"=res$laststep,
         "iteration number"=res$it,
         "convergence history"=res$hist,
         "exit message"=res$mes
      )
      obj2kvh(optinfo, "optimization process information", fkvh)
      rres=res$retres
   } else {
      rres=lab_resid(param, TRUE, labargs)
   }
   if (TIMEIT) {
      cat("postopt : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # active constraints
   ine=as.numeric(abs(ui%*%param-ci))<1.e-10
   if (any(ine)) {
      obj2kvh(nm_i[ine], "active inequality constraints", fkvh)
   }
   poolall[nm_poolf]=param[nm_poolf]

#browser()
   if (is.null(jx_f$jacobian)) {
      # final jacobian calculation
      capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
   }
   rcost=cumo_cost(param, labargs, rres)
   pres[,irun]=param
   costres[irun]=rcost
   obj2kvh(rcost, "final cost", fkvh)
#browser()
   # get z p-values on residual vector
   zpval=rz.pval.bi(rres$res)
   resid=list()
   if (sum(nb_meas)) {
      resid[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) if (is.matrix(jx_f$reslab[[iexp]])) jx_f$reslab[[iexp]] else cbind(residual=jx_f$reslab[[iexp]], `p-value`=zpval[seq_along(jx_f$reslab[[iexp]])]))
      names(resid[["labeled data"]])=nm_exp
   
      if (case_i) {
         resid[["labeled data p-value"]]=vector("list", nb_exp)
         names(resid[["labeled data p-value"]])=nm_exp
         for (iexp in seq_len(nb_exp)) {
            mtmp=zpval[seq_along(jx_f$reslab[[iexp]])]
            dim(mtmp)=dim(jx_f$reslab[[iexp]])
            dimnames(mtmp)=dimnames(jx_f$reslab[[iexp]])
            resid[["labeled data p-value"]][[iexp]]=mtmp
            rm(mtmp)
         }
      }
   }
   nb_reslab_tot=sum(sapply(jx_f$reslab, length))
   if (length(jx_f$resflu))
      resid[["measured fluxes"]]=cbind(residual=jx_f$resflu, `p-value`=zpval[nb_reslab_tot+seq_along(jx_f$resflu)])
   if (length(jx_f$respool))
      resid[["measured pools"]]=cbind(residual=if (is.matrix(jx_f$respool)) jx_f$respool[,1] else jx_f$respool, `p-value`=zpval[nb_reslab_tot+length(jx_f$resflu)+seq_along(jx_f$respool)])
   obj2kvh(resid, "(simulated-measured)/sd_exp", fkvh)
   rm(resid, zpval)

   # simulated measurements -> kvh
   simul=list()
#browser()
   if (case_i) {
      if (sum(nb_meas)) {
         if (addnoise) {
            simul[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) jx_f$usm[[iexp]]+rnorm(length(jx_f$usm[[iexp]]))*measurements$dev$labeled[[iexp]])
            names(simul[["labeled data"]])=nm_exp
         } else {
            simul[["labeled data"]]=jx_f$usm
         }
      }
   } else {
      if (sum(nb_meas)) {
         if (addnoise) {
            simlab=lapply(seq_len(nb_exp), function(iexp) jx_f$simlab[[iexp]]+rnorm(length(jx_f$simlab[[iexp]]))*measurements$dev$labeled[[iexp]])
            names(simlab)=nm_exp
         } else {
            simlab=jx_f$simlab
         }
         if (nb_sc_tot > 0) {
            simul[["labeled data (unscaled)"]]=jx_f$usimlab
            simul[["labeled data (scaled)"]]=simlab
         } else {
            simul[["labeled data"]]=simlab
         }
      }
   }
   if (nb_fmn) {
      if (addnoise)
         simul[["measured fluxes"]]=jx_f$simfmn+rnorm(length(jx_f$simfm))*measurements$dev$flux
      else
         simul[["measured fluxes"]]=jx_f$simfmn
   }
   if (nb_poolm) {
      if (addnoise)
         simul[["measured pools"]]=jx_f$simpool+rnorm(length(jx_f$simpool))*measurements$dev$pool
      else
         simul[["measured pools"]]=jx_f$simpool
   }
   obj2kvh(simul, "simulated measurements", fkvh)
   
   # SD -> kvh
   # get index of non null components
   iget=sapply(names(measurements$dev), function(nm) !is.null(measurements$dev[[nm]]) & nm %in% c("labeled", "flux", "pool"))
   obj2kvh(measurements$dev[iget], "measurement SD", fkvh)

   # gradient -> kvh
   if (length(jx_f$res) && !all(ina <- is.na(jx_f$res))) {
      if (any(ina)) {
         gr=2*as.numeric(crossprod(jx_f$res[!ina], jx_f$jacobian[!ina,,drop=FALSE]))
      } else {
         gr=2*as.numeric(crossprod(jx_f$res, jx_f$jacobian))
      }
      names(gr)=nm_par
      obj2kvh(gr, "gradient vector", fkvh)
   }
   colnames(jx_f$udr_dp)=nm_par
   obj2kvh(jx_f$udr_dp, "jacobian dr_dp (without 1/sd_exp)", fkvh)
   # generalized inverse of non reduced jacobian
   svj=svd(jx_f$udr_dp)
   invj=svj$v%*%(t(svj$u)/svj$d)
   dimnames(invj)=rev(dimnames(jx_f$udr_dp))
   obj2kvh(invj, "generalized inverse of jacobian dr_dp (without 1/sd_exp)", fkvh)

   labargs$getx=TRUE
   labargs$labargs2getx=TRUE
   if (fullsys) {
      nm_flist=nm_list
      nm_flist$rcumo=nm_cumo
      nm_flist$rcumo_in_cumo=match(nm_rcumo, nm_cumo)
      nb_f$cumos=nb_cumos
      nm_xi_f=c()
      xi_f=matrix(c(), ncol=nb_exp)
      dimnames(xi_f)[[1]]=nm_xi_f
      nm_flist$xi=nm_xi_f
      labargs$emu=F
      v=lab_sim(param, cjac=FALSE, labargs)
      labargs$emu=emu
      x=if (case_i) v$xf else v$x
   } else {
      v=lab_sim(param, cjac=FALSE, labargs)
      x=if (case_i) v$xf else v$x
   }

   # write some info in result kvh
   mid=cumo2mass(x)
   if (case_i) {
      mid=lapply(mid, function(m) m[sort(rownames(m)),,drop=FALSE])
   } else if (length(mid)) {
      mid=mid[sort(rownames(mid)),,drop=FALSE]
   }
   obj2kvh(mid, "MID vector", fkvh)
   
   # constrained fluxes to kvh
   obj2kvh(fallnx[nm_fc], "constrained net-xch01 fluxes", fkvh)

   fwrv=v$lf$fwrv
   fallnx=v$lf$fallnx
   flnx=v$lf$flnx
   fgr=fallnx[nm_fgr]

   # keep last jx_f in jx_f_last
#browser()
   while (sensitive=="mc") {
      if (TIMEIT) {
         cat("monte-ca: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      if (set_seed) {
         set.seed(seed)
      }
      # reference simulation corresponding to the final param
      refsim=new.env()
      for (nm_it in c("simlab", "simfmn", "simpool", "usm")) {
         assign(nm_it, jx_f[[nm_it]], envir=refsim)
      }
      # Monte-Carlo simulation in parallel way (if asked and possible)
      if (np > 1L) {
         spli=splitIndices(nmc, nodes);
         clusterExport(cl, c("param", "refsim", "runsuf", "spli"))
         #clusterEvalQ(cl, labargs$spa[[1]]$a <- NULL) # to rebuild sparse matrices on cores ## now, they are build once, at the cluster init
         cl_res=clusterEvalQ(cl, {mc_iter=TRUE; labargs$getx=FALSE; mc_res=lapply(spli[[idw]], mc_sim); rm(mc_iter); mc_res})
         mc_res=vector(nmc, mode="list")
         for (i in seq(nodes))
            mc_res[spli[[i]]]=cl_res[[i]]
         #mc_res=parLapplyLB(cl, seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      } else {
         mc_res=lapply(seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      }
      free_mc=sapply(mc_res, function(l) {if (class(l)=="character" || is.null(l) || is.na(l$cost) || l$err) { ret=rep(NA, nb_param+3) } else { ret=c(l$cost, l$it, l$normp, l$par) }; ret })
      if (length(free_mc)==0) {
         cat("Parallel exectution of Monte-Carlo simulations has failed.", "\n", sep="", file=fcerr)
         free_mc=matrix(NA, nb_param+2, 0)
      }
      cost_mc=free_mc[1,]
      nmc_real=nmc-sum(is.na(free_mc[4,]))
      cat("monte-carlo\n", file=fkvh)
      indent=1
      obj2kvh(cl_type, "cluster type", fkvh, indent)
      obj2kvh(avaco, "detected cores", fkvh, indent)
      avaco=max(1, avaco, na.rm=T)
      obj2kvh(min(avaco, np, na.rm=T), "used cores", fkvh, indent)
      cat("\tfitting samples\n", file=fkvh)
      indent=2
      obj2kvh(nmc, "requested number", fkvh, indent)
      obj2kvh(nmc_real, "calculated number", fkvh, indent)
      obj2kvh(nmc-nmc_real, "failed to calculate", fkvh, indent)
      # convergence section in kvh
      indent=1
      mout=rbind(round(free_mc[1:2,,drop=FALSE], 2),
         format(free_mc[3,,drop=FALSE], di=2, sci=T))
      dimnames(mout)=list(c("cost", "it.numb", "normp"), seq_len(ncol(free_mc)))
      obj2kvh(mout, "convergence per sample", fkvh, indent)
      # remove failed m-c iterations
      free_mc=free_mc[-(1:3),,drop=FALSE]
      ifa=which(is.na(free_mc[1,]))
      if (length(ifa)) {
         if (ncol(free_mc) > length(ifa)) {
            cat("Some Monte-Carlo iterations failed.", "\n", sep="", file=fcerr)
         }
         free_mc=free_mc[,-ifa,drop=FALSE]
         cost_mc=cost_mc[-ifa]
      }
      if (nmc_real <= 1) {
         cat("No sufficient Monter-Carlo samples were successfully calculated to do any statistics.", "\n", sep="", file=fcerr)
         retcode[irun]=1
         break
      }
#browser()
      rownames(free_mc)=nm_par
      
      # cost section in kvh
      cat("\tcost\n", file=fkvh)
      indent=2
      obj2kvh(mean(cost_mc), "mean", fkvh, indent)
      obj2kvh(median(cost_mc), "median", fkvh, indent)
      obj2kvh(sd(cost_mc), "sd", fkvh, indent)
      obj2kvh(sd(cost_mc)*100/mean(cost_mc), "rsd (%)", fkvh, indent)
      obj2kvh(quantile(cost_mc, c(0.025, 0.95, 0.975)), "ci", fkvh, indent)
      
      # free parameters section in kvh
      cat("\tStatistics\n", file=fkvh)
      mout=c()
      indent=2
      # param stats
      # mean
      parmean=apply(free_mc, 1, mean)
      # median
      parmed=apply(free_mc, 1, median)
#browser()
      # covariance matrix
      covmc=cov(t(free_mc))
      obj2kvh(covmc, "covariance", fkvh, indent)
      # sd
      sdmc=sqrt(diag(covmc))
      # confidence intervals
      ci_mc=t(apply(free_mc, 1, quantile, probs=c(0.025, 0.975)))
      ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
      colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI length")
      mout=cbind(mout, mean=parmean, median=parmed, sd=sdmc,
         "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
      obj2kvh(mout, "free parameters", fkvh, indent)

      # net-xch01 stats
      fallnx_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fallnx)
      fallnx=param2fl(param, labargs)$fallnx
      if (length(fallnx_mc)) {
         dimnames(fallnx_mc)[[1]]=nm_fallnx
         # form a matrix output
         fallout=matrix(0, nrow=nrow(fallnx_mc), ncol=0)
         # mean
#browser()
         parmean=apply(fallnx_mc, 1, mean)
         # median
         parmed=apply(fallnx_mc, 1, median)
         # covariance matrix
         covmc=cov(t(fallnx_mc))
         dimnames(covmc)=list(nm_fallnx, nm_fallnx)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(fallnx_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         ci_mc=cbind(ci_mc, ci_mc[,3]*100/abs(parmean))
         colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
         fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(fallnx), ci_mc)
         o=order(nm_fallnx)
         obj2kvh(fallout[o,,drop=FALSE], "all net-xch01 fluxes", fkvh, indent)
         obj2kvh(covmc[o,o], "covariance of all net-xch01 fluxes", fkvh, indent)

         # fwd-rev stats
         fwrv_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fwrv)
         dimnames(fwrv_mc)[[1]]=nm_fwrv
         fallout=matrix(0, nrow=nrow(fwrv_mc), ncol=0)
         # mean
         parmean=apply(fwrv_mc, 1, mean)
         # median
         parmed=apply(fwrv_mc, 1, median)
         # covariance matrix
         covmc=cov(t(fwrv_mc))
         dimnames(covmc)=list(nm_fwrv, nm_fwrv)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(fwrv_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         ci_mc=cbind(ci_mc, ci_mc[,3]*100/abs(fwrv))
         dimnames(ci_mc)[[2]]=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
         fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
         o=order(nm_fwrv)
         obj2kvh(fallout[o,,drop=FALSE], "forward-reverse fluxes", fkvh, indent)
         obj2kvh(covmc[o,o], "covariance of forward-reverse fluxes", fkvh, indent)
      }
      break
   }
#browser()
   if (length(sensitive) && nchar(sensitive) && sensitive != "mc") {
      cat(paste("Unknown sensitivity '", sensitive, "' method chosen.", sep=""), "\n", sep="", file=fcerr)
      retcode[irun]=1
   }

   if (TIMEIT) {
      cat("linstats: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # Linear method based on jacobian x_f
   # reset fluxes and jacobians according to param
   if (is.null(jx_f$jacobian)) {
      capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
   } # else use the last calculated jacobian

   # covariance matrix of free fluxes
   svj=svd(jx_f$jacobian)
   if (svj$d[1] == 0.) {
      i=rep(TRUE, length(svj$d))
   } else {
      i=svj$d/svj$d[1]<1.e-10
      if (all(!i) && svj$d[1]<1.e-10) {
         # we could not find very small d, take just the last
         i[length(i)]=TRUE
      }
   }
   ibad=apply(svj$v[, i, drop=FALSE], 2, which.contrib)
   ibad=unique(unlist(ibad))
   if (length(ibad) > 0) {
      cat(paste(if (nchar(runsuf)) runsuf%s+%": " else "", "Inverse of covariance matrix is numerically singular.\nStatistically undefined parameter(s) seems to be:\n",
         paste(sort(nm_par[ibad]), collapse="\n"), "\nFor more complete list, see sd columns in '/linear stats'\nin the result file.", sep=""), "\n", sep="", file=fcerr)
   }
   # "square root" of covariance matrix (to preserve numerical positive definitness)
   rtcov=(svj$u)%*%(t(svj$v)/svj$d)
   # standart deviations of free fluxes
   cat("linear stats\n", file=fkvh)

   # sd free+dependent+growth net-xch01 fluxes
   nm_flfd=c(nm_ff, nm_fgr, nm_fl)
   if (nb_ff > 0 || nb_fgr > 0) {
      i=1:nb_param
      i=c(head(i, nb_ff), tail(i, nb_fgr))
      covfl=crossprod(rtcov[, i, drop=FALSE]%mmt%(rbind(diag(nb_ff+nb_fgr), dfl_dffg)%mrv%c(rep.int(1., nb_ff), fgr)))
      dimnames(covfl)=list(nm_flfd, nm_flfd)
      sdfl=sqrt(diag(covfl))
   } else {
      sdfl=rep(0., nb_fl)
      covfl=matrix(0., nb_fl, nb_fl)
   }
   fl=c(head(param, nb_ff), fgr, flnx)
   stats_nx=cbind("value"=fl, "sd"=sdfl, "rsd"=sdfl/abs(fl))
   rownames(stats_nx)=nm_flfd
   o=order(nm_flfd)
   obj2kvh(stats_nx[o,,drop=FALSE], "net-xch01 fluxes (sorted by name)", fkvh, indent=1)
   obj2kvh(covfl[o, o], "covariance net-xch01 fluxes", fkvh, indent=1)

   # sd of all fwd-rev
   if (nb_ff > 0 || nb_fgr > 0) {
      i=1:nb_param
      i=c(head(i, nb_ff), tail(i, nb_fgr))
      covf=crossprod(tcrossprod_simple_triplet_matrix(rtcov[,i, drop=FALSE], jx_f$df_dffp%mrv%c(rep.int(1., nb_ff), head(poolall[nm_poolf], nb_fgr))))
      dimnames(covf)=list(nm_fwrv, nm_fwrv)
      sdf=sqrt(diag(covf))
   } else {
      sdf=rep(0., length(fwrv))
   }
   mtmp=cbind(fwrv, sdf, sdf/abs(fwrv))
   dimnames(mtmp)[[2]]=c("value", "sd", "rsd")
   o=order(nm_fwrv)
   obj2kvh(mtmp[o,], "fwd-rev fluxes (sorted by name)", fkvh, indent=1)
   if (nb_ff > 0 || nb_fgr > 0) {
      obj2kvh(covf, "covariance fwd-rev fluxes", fkvh, indent=1)
   }
   # pool -> kvh
   sdpf=poolall
   sdpf[]=0.

   if (nb_poolf > 0) {
      # covariance matrix of free pools
      # "square root" of covariance matrix (to preserve numerical positive definitness)
      poolall[nm_poolf]=param[nm_poolf]
      # cov poolf
      covpf=crossprod(rtcov[,nb_ff+nb_sc_tot+seq_len(nb_poolf), drop=FALSE])
      dimnames(covpf)=list(nm_poolf, nm_poolf)
      sdpf[nm_poolf]=sqrt(diag(covpf))
   }
   if (length(poolall) > 0) {
      mtmp=cbind("value"=poolall, "sd"=sdpf, "rsd"=sdpf/poolall)
      rownames(mtmp)=nm_poolall
      o=order(nm_poolall)
      obj2kvh(mtmp[o,,drop=FALSE], "metabolite pools (sorted by name)", fkvh, indent=1)
      if (nb_poolf > 0) {
         o=order(nm_poolf)
         obj2kvh(covpf[o, o], "covariance free pools", fkvh, indent=1)
      }
   }

   # khi2 test for goodness of fit
   # goodness of fit (khi2 test)
   if (length(jx_f$res)) {
      nvres=sum(!is.na(jx_f$res))
      if (nvres >= nb_param) {
         khi2test=list("khi2 value"=rcost, "data points"=nvres,
            "fitted parameters"=nb_param, "degrees of freedom"=nvres-nb_param)
         khi2test$`khi2 reduced value`=khi2test$`khi2 value`/khi2test$`degrees of freedom`
         khi2test$`p-value, i.e. P(X^2<=value)`=pchisq(khi2test$`khi2 value`, df=khi2test$`degrees of freedom`)
         khi2test$conclusion=if (khi2test$`p-value, i.e. P(X^2<=value)` > 0.95) "At level of 95% confidence, the model does not fit the data good enough with respect to the provided measurement SD" else "At level of 95% confidence, the model fits the data good enough with respect to the provided measurement SD"
         obj2kvh(khi2test, "goodness of fit (khi2 test)", fkvh, indent=1)
      } else {
         cat(sprintf("khi2: Measurement number %d is lower than parameter number %d. Khi2 test cannot be done.\n", nvres, nb_param), sep="", file=fcerr)
      }
   }
   if (prof) {
      Rprof(NULL)
   }
   close(fkvh)
   # write edge.netflux property
   fedge=file(file.path(dirw, sprintf("edge.netflux.%s%s.attrs", baseshort,  runsuf)), "w")
   cat("netflux (class=Double)\n", sep="", file=fedge)
   nm_edge=names(edge2fl)
   cat(paste(nm_edge, fallnx[edge2fl], sep=" = "), sep="\n" , file=fedge)
   close(fedge)

   # write edge.xchflux property
   fedge=file(file.path(dirw, sprintf("edge.xchflux.%s%s.attrs", baseshort,  runsuf)), "w")
   flxch=paste(".x", substring(edge2fl, 4), sep="")
   ifl=charmatch(flxch, substring(names(fallnx), 2))
   cat("xchflux (class=Double)\n", sep="", file=fedge)
   cat(paste(nm_edge, fallnx[ifl], sep=" = "), sep="\n" , file=fedge)
   close(fedge)

   # write node.log2pool property
   if (length(poolall)> 0) {
      fnode=file(file.path(dirw, sprintf("node.log2pool.%s%s.attrs", baseshort,  runsuf)), "w")
      cat("log2pool (class=Double)\n", sep="", file=fnode)
      nm_node=substring(names(poolall), 4)
      cat(paste(nm_node, log2(poolall), sep=" = "), sep="\n" , file=fnode)
      close(fnode)
   }
}
if (!is.null(cl)) {
   stopCluster(cl)
   labargs$cl=cl=NULL
}

pres=rbind(cost=costres, pres)
fco=file(file.path(dirw, sprintf("%s.pres.csv", baseshort)), open="w")
cat("row_col	", file=fco)
write.table(file=fco, pres, row.n=T, quot=F, sep="\t")
close(fco)
if (TIMEIT) {
   cat("rend    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# source files from FTBL/posttreat_R
postlist=strsplit("plot_smeas.R", " *; *")[[1]]
for (post in postlist) {
   fpostR=file.path(dirw, post)
   if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
      source(fpostR)
   } else {
      # not found in 'dirw', try 'dirr'
      fpostR=file.path(dirr, post)
      if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
         source(fpostR)
      } else {
         cat(sprintf("Posttreatment R file '%s' does not exist in ftbl directory neither in influx_si one. Ignored.\n", post), file=fcerr)
      }
   }
}
xgc=gc(verbose=FALSE) # to avoid the message "Error in (function (x)  : tentative d'appliquer un objet qui n'est pas une fonction"
close(fclog)
close(fcerr)
retcode=max(retcode)
if (format(parent.frame()) == format(.GlobalEnv)) {
   q("no", status=retcode)
}
