# This is an automatically generated R code. Don't edit.
# Generated by 
# /home/sokol/.local/bin/ftbl2optR.py --tblimit 0 --ropts "TIMEIT=TRUE" e_coli_growth.ftbl
# at Wed Dec 11 15:50:08 2019.

# Copyright 2011-2019, INRA, France.

# working dir
dirw="/home/sokol/insa/sysbio/dev/ftbl2sys/influx_si/test"

# installation dir (where influx_si/R/*.R live)
dirr="/home/sokol/.local/lib/python3.7/site-packages/influx_si/R"
# short base name of the FTBL (withount '.ftbl')
baseshort="e_coli_growth"

fcerr=file(file.path(dirw, sprintf("%s.err", baseshort)), "ab")
fclog=file(file.path(dirw, sprintf("%s.log", baseshort)), "ab")

options(warn=1)
options(digits.secs=2)

case_i=F

if (length(find("bitwAnd"))==0L) {
   suppressPackageStartupMessages(library(bitops))
   bitwAnd=bitAnd
}
source(file.path(dirr, "libs.R"))

# define matprod for simple_triplet_matrix
`%stm%` = slam::matprod_simple_triplet_matrix

# default options
version=FALSE
noopt=FALSE
noscale=FALSE
meth="nlsic"
fullsys=FALSE
emu=FALSE
irand=FALSE
sens=""
cupx=0.999
cupn=1.e3
cupp=1.e5
clownr=0
cinout=0
clowp=1.e-8
np=0
ln=FALSE
tikhreg=FALSE
sln=FALSE
lim=FALSE
zc=-.Machine$double.xmax
ffguess=FALSE
fdfit=FALSE
addnoise=FALSE
fseries=""
iseries=""
seed=-.Machine$integer.max
excl_outliers=FALSE
TIMEIT=FALSE
prof=FALSE
time_order="1"

# get runtime arguments
TIMEIT=TRUE

# synonymous
myver=version
optimize=!noopt
method=meth
sensitive=sens
least_norm=ln
initrand=irand

vernum="5.0"

# sanity check for command line parameters
if (substring(sensitive, 1, 3)=="mc=") {
   # read the mc iteration number
   nmc=as.integer(substring(sensitive, 4))
   sensitive="mc"
} else if (sensitive=="mc") {
   nmc=10
}
# cupx==0 means no upper limit => cupx=1
cupx=ifelse(cupx, cupx, 1)
if (cupx < 0 || cupx > 1) {
   stop_mes(paste("Option '--cupx N' must have N in the interval [0,1]
",
      "Instead, the value ", cupx, " si given.", sep=""), file=fcerr)
}
if (cinout < 0) {
   stop_mes(paste("Option '--cinout N' must have N non negative
",
      "Instead, the value ", cinout, " is given.", sep=""), file=fcerr)
}
# minimization method
validmethods=list("BFGS", "Nelder-Mead", "SANN", "ipopt", "nlsic")
if (! method %in% validmethods) {
   cat(paste("Wraning: method", method, "is not known. 'nlsic' is used instead."), "\n", sep="", file=fcerr)
   method="nlsic"
}
if (method == "ipopt") {
   installed=suppressPackageStartupMessages(library(ipoptr, logical.return=T))
   if (!installed) {
      stop_mes("An optimization method ipopt is requested but available in this R installation", file=fcerr)
   }
}
if (least_norm && sln) {
   stop_mes("Options --ln and --sln cannot be activated simultaniously.", file=fcerr)
}

avaco=try(detectCores(), silent=T)
if (inherits(avaco, "try-error")) {
   avaco=NULL
}
if (np > 0L && np < 1L) {
   np=round(avaco*np)
} else if (np >= 1L) {
   np=round(np)
} else {
   np=avaco
}
if (is.null(np) || np <= 0L) {
   np=1L
}
if (sensitive=="mc") {
   np=min(np, nmc)
}
options(mc.cores=np)

if (least_norm+tikhreg+lim > 1) {
   stop_mes("Options --ln, --lim and --tikhreg cannot be activated simultaneously. Use only one of them at a time.", file=fcerr)
}
lsi_fun=lsi
if (least_norm || sln) {
   lsi_fun=lsi_ln
} else if (tikhreg) {
   lsi_fun=lsi_reg
} else if (lim) {
   suppressPackageStartupMessages(library(limSolve));
   lsi_fun=lsi_lim
}
if (zc==-.Machine$double.xmax) {
   # no zero scrossing to apply
   zerocross=F
} else {
   if (zc < 0.) {
      stop_mes(paste("Zero crossing value ZC must be non negative, instead ", zc, " is given.", sep=""), file=fcerr)
   }
   zerocross=T
}
if (seed==-.Machine$integer.max) {
   # no seed to apply
   set_seed=F
} else {
   set_seed=T
   set.seed(seed)
}
time_order=gsub("\\s", "", time_order) # remove spaces if any
if (!(time_order %in% c("1", "2", "1,2"))) {
   stop_mes(sprintf("time_order must be '1', '2' or '1,2'. Instead got '%s'"))
}
opts=commandArgs()
# end command line argument proceeding

# get some cumomer tools
source(file.path(dirr, "opt_cumo_tools.R"))
#loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))

lab_resid=cumo_resid
lab_sim=param2fl_x
jx_f=new.env()

if (TIMEIT) {
   cat("rinit   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# R profiling
if (prof) {
   Rprof(sprintf("%s.Rprof", baseshort))
}

nm_list=list()
nb_f=list()

if (TIMEIT) {
   cat("r_flux  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# fwd-rev flux names
nm_fwrv=c("fwd.CO2upt", "fwd.Cit_gr", "fwd.Fru6P_gr", "fwd.FruBP_gr", "fwd.Glc6P_gr", "fwd.Glucupt", "fwd.Glucupt_1", "fwd.Glucupt_U", "fwd.Gnt6P_gr", "fwd.HR1", "fwd.HR2", "fwd.HR3", "fwd.HR4", "fwd.HR5", "fwd.Mal_gr", "fwd.PEP_gr", "fwd.PGA_gr", "fwd.Rib5P_gr", "fwd.Rub5P_gr", "fwd.Suc_gr", "fwd.Xul5P_gr", "fwd.akgdh", "fwd.ald", "fwd.bs_DHAP", "fwd.bs_accoa", "fwd.bs_akg", "fwd.bs_e4p", "fwd.bs_fru6P", "fwd.bs_glc6P", "fwd.bs_oaa", "fwd.bs_pep", "fwd.bs_pga", "fwd.bs_pyr", "fwd.bs_rib5P", "fwd.citsynth", "fwd.edd", "fwd.eno", "fwd.fum_a", "fwd.fum_b", "fwd.gnd", "fwd.idh", "fwd.maldh", "fwd.out_Ac", "fwd.out_co2", "fwd.pdh", "fwd.pfk", "fwd.pgi", "fwd.pgk", "fwd.ppc", "fwd.pyk", "fwd.rib", "fwd.xul", "fwd.zwf", "rev.CO2upt", "rev.Cit_gr", "rev.Fru6P_gr", "rev.FruBP_gr", "rev.Glc6P_gr", "rev.Glucupt", "rev.Glucupt_1", "rev.Glucupt_U", "rev.Gnt6P_gr", "rev.HR1", "rev.HR2", "rev.HR3", "rev.HR4", "rev.HR5", "rev.Mal_gr", "rev.PEP_gr", "rev.PGA_gr", "rev.Rib5P_gr", "rev.Rub5P_gr", "rev.Suc_gr", "rev.Xul5P_gr", "rev.akgdh", "rev.ald", "rev.bs_DHAP", "rev.bs_accoa", "rev.bs_akg", "rev.bs_e4p", "rev.bs_fru6P", "rev.bs_glc6P", "rev.bs_oaa", "rev.bs_pep", "rev.bs_pga", "rev.bs_pyr", "rev.bs_rib5P", "rev.citsynth", "rev.edd", "rev.eno", "rev.fum_a", "rev.fum_b", "rev.gnd", "rev.idh", "rev.maldh", "rev.out_Ac", "rev.out_co2", "rev.pdh", "rev.pfk", "rev.pgi", "rev.pgk", "rev.ppc", "rev.pyk", "rev.rib", "rev.xul", "rev.zwf")

# edge to netflux name translator
edge2fl=c("d.n.fum_a", "d.n.idh", "d.n.idh", "d.n.idh", "f.n.out_Ac", "f.n.pgi", "d.n.eno", "c.n.bs_oaa", "d.n.akgdh", "d.n.akgdh", "d.n.akgdh", "d.n.HR1", "d.n.HR1", "d.n.HR1", "c.n.bs_pyr", "d.n.Glucupt_U", "f.n.edd", "f.n.edd", "f.n.edd", "c.n.bs_pep", "c.n.bs_e4p", "d.n.xul", "c.n.bs_accoa", "d.n.HR4", "d.n.HR4", "d.n.HR4", "d.n.maldh", "d.n.ald", "d.n.ald", "d.n.ald", "c.n.bs_akg", "d.n.zwf", "c.n.bs_rib5P", "c.n.CO2upt", "d.n.ppc", "d.n.ppc", "d.n.ppc", "c.n.bs_glc6P", "d.n.rib", "c.n.bs_DHAP", "d.n.pdh", "d.n.pdh", "d.n.pdh", "d.n.HR5", "d.n.HR5", "d.n.HR5", "f.n.Glucupt_1", "d.n.Glucupt", "d.n.out_co2", "d.n.fum_b", "c.n.bs_fru6P", "c.n.bs_pga", "d.n.HR2", "d.n.HR2", "d.n.HR2", "d.n.HR3", "d.n.HR3", "d.n.HR3", "d.n.gnd", "d.n.gnd", "d.n.gnd", "d.n.citsynth", "d.n.citsynth", "d.n.citsynth", "d.n.pyk", "d.n.pfk", "d.n.pgk", "g.n.Suc_gr", "g.n.Mal_gr", "g.n.PEP_gr", "g.n.PGA_gr", "g.n.Cit_gr", "g.n.Gnt6P_gr", "g.n.FruBP_gr", "g.n.Fru6P_gr", "g.n.Glc6P_gr", "g.n.Rub5P_gr", "c.n.Rib5P_gr", "g.n.Xul5P_gr")
names(edge2fl)=c("Suc (fum_a) Mal", "Cit (idh) idh", "idh (idh) AKG", "idh (idh) CO2", "AcCoA (out_Ac) Acetate", "Glc6P (pgi) Fru6P", "PGA (eno) PEP", "OAA (bs_oaa) BM_OAA", "AKG (akgdh) akgdh", "akgdh (akgdh) Suc", "akgdh (akgdh) CO2", "GA3P (HR1) HR1", "E2 (HR1) HR1", "HR1 (HR1) Xul5P", "Pyr (bs_pyr) BM_Pyr", "Gluc_U (Glucupt_U) Glc", "Gnt6P (edd) edd", "edd (edd) Pyr", "edd (edd) GA3P", "PEP (bs_pep) BM_PEP", "Ery4P (bs_e4p) BM_Ery4P", "Rub5P (xul) Xul5P", "AcCoA (bs_accoa) BM_AcCoA", "Sed7P (HR4) HR4", "HR4 (HR4) Rib5P", "HR4 (HR4) E2", "Mal (maldh) OAA", "FruBP (ald) ald", "ald (ald1) GA3P", "ald (ald2) GA3P", "AKG (bs_akg) BM_AKG", "Glc6P (zwf) Gnt6P", "Rib5P (bs_rib5P) BM_Rib5P", "CO2_ext (CO2upt) CO2", "PEP (ppc) ppc", "CO2 (ppc) ppc", "ppc (ppc) OAA", "Glc6P (bs_glc6P) BM_Glc6P", "Rub5P (rib) Rib5P", "GA3P (bs_DHAP) Glp", "Pyr (pdh) pdh", "pdh (pdh) AcCoA", "pdh (pdh) CO2", "Ery4P (HR5) HR5", "E3 (HR5) HR5", "HR5 (HR5) Sed7P", "Gluc_1 (Glucupt_1) Glc", "Glc (Glucupt) Glc6P", "CO2 (out_co2) CO2_out", "Suc (fum_b) Mal", "Fru6P (bs_fru6P) BM_Fru6P", "PGA (bs_pga) BM_PGA", "Fru6P (HR2) HR2", "HR2 (HR2) Ery4P", "HR2 (HR2) E2", "Fru6P (HR3) HR3", "HR3 (HR3) GA3P", "HR3 (HR3) E3", "Gnt6P (gnd) gnd", "gnd (gnd) CO2", "gnd (gnd) Rub5P", "AcCoA (citsynth) citsynth", "OAA (citsynth) citsynth", "citsynth (citsynth) Cit", "PEP (pyk) Pyr", "Fru6P (pfk) FruBP", "GA3P (pgk) PGA", "Suc (Suc_gr) Suc_gr", "Mal (Mal_gr) Mal_gr", "PEP (PEP_gr) PEP_gr", "PGA (PGA_gr) PGA_gr", "Cit (Cit_gr) Cit_gr", "Gnt6P (Gnt6P_gr) Gnt6P_gr", "FruBP (FruBP_gr) FruBP_gr", "Fru6P (Fru6P_gr) Fru6P_gr", "Glc6P (Glc6P_gr) Glc6P_gr", "Rub5P (Rub5P_gr) Rub5P_gr", "Rib5P (Rib5P_gr) Rib5P_gr", "Xul5P (Xul5P_gr) Xul5P_gr")

# initialize the linear system Afl*flnx=bfl (0-weight cumomers)
# unknown net flux names
nm_fln=c("d.n.Glucupt", "d.n.Glucupt_U", "d.n.HR1", "d.n.HR2", "d.n.HR3", "d.n.HR4", "d.n.HR5", "d.n.akgdh", "d.n.ald", "d.n.citsynth", "d.n.eno", "d.n.fum_a", "d.n.fum_b", "d.n.gnd", "d.n.idh", "d.n.maldh", "d.n.out_co2", "d.n.pdh", "d.n.pfk", "d.n.pgk", "d.n.ppc", "d.n.pyk", "d.n.rib", "d.n.xul", "d.n.zwf")
nb_fln=length(nm_fln)
fln=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.0, 0.1, 0.0, 1.21144, 0.0, 0.0, 0.4)
names(fln)=nm_fln
# unknown xch flux names
nm_flx=c("d.x.fum_b")
nb_flx=length(nm_flx)
flx=c(0.0)
names(flx)=nm_flx
nm_fl=c(nm_fln, nm_flx)
nb_fl=nb_fln+nb_flx
fl=c(fln, flx)
# gather flux names in a list
nm_list$flnx=nm_fl
nm_list$fwrv=nm_fwrv

# carbon length of metabolites
clen=c(4,4,6,5,1,2,2,6,6,3,3,4,4,3,2,5,3,3,6,6,6,3,4,4,5,2,7,5,6,5,5,1,6,3,3,6,1,6,3)
names(clen)=c("Suc","Mal","Cit","AKG","CO2","AcCoA","Acetate","Glc6P","Fru6P","PGA","PEP","OAA","BM_OAA","GA3P","E2","Xul5P","Pyr","BM_Pyr","Gluc_U","Glc","Gnt6P","BM_PEP","Ery4P","BM_Ery4P","Rub5P","BM_AcCoA","Sed7P","Rib5P","FruBP","BM_AKG","BM_Rib5P","CO2_ext","BM_Glc6P","Glp","E3","Gluc_1","CO2_out","BM_Fru6P","BM_PGA")

# metabolite pools are : all (poolall) which is divided in free (poolf) and
# constrained (poolc)

# constrained pool
poolc=c(1e-07)
nm_poolc=c("pc:Rib5P")
if (length(nm_poolc)) {
   names(nm_poolc)=substring(nm_poolc, 4)
}
names(poolc)=nm_poolc

# starting values for free pool (the same number and the same alphabetic order than free growth fluxes, if present)
poolf=c(0.001630397300073748, 0.00010006707551232429, 0.0004927839907571225, 0.0004905098655004916, 0.00014480899018442714, 0.0006054470296805187, 5.501298486110693e-05, 0.0005008619523631337, 5.172415742935172e-05, 0.0014849826568155515, 0.0002068966297174069)
nm_poolf=c("pf:Cit", "pf:Fru6P", "pf:FruBP", "pf:Glc6P", "pf:Gnt6P", "pf:Mal", "pf:PEP", "pf:PGA", "pf:Rub5P", "pf:Suc", "pf:Xul5P")
if (length(nm_poolf)) {
   names(nm_poolf)=substring(nm_poolf, 4)
}
names(poolf)=nm_poolf
nb_poolf=length(poolf)
nb_f$nb_poolf=nb_poolf

nm_poolall=c(nm_poolf, nm_poolc)
poolall=as.numeric(c(poolf, poolc))
names(poolall)=nm_poolall
pool=poolall
nm_list$poolf=nm_poolf
nm_list$poolc=nm_poolc
nm_list$poolall=nm_poolall

# flux matrix
nb_flr=26
if (nb_fl) {
   Afl=matrix(0, nrow=nb_flr, ncol=nb_fl)
   Afl[1, c(8, 12, 13)]=c(1.0, -1.0, -1.0)
   Afl[2, c(12, 13, 16)]=c(1.0, 1.0, -1.0)
   Afl[3, c(10, 15)]=c(1.0, -1.0)
   Afl[4, c(8, 15)]=c(-1.0, 1.0)
   Afl[5, c(8, 14, 15, 17, 18, 21)]=c(1.0, 1.0, 1.0, -1.0, 1.0, -1.0)
   Afl[6, c(10, 18)]=c(-1.0, 1.0)
   Afl[7, c(1, 25)]=c(1.0, -1.0)
   Afl[8, c(4, 5, 19)]=c(-1.0, -1.0, -1.0)
   Afl[9, c(11, 20)]=c(-1.0, 1.0)
   Afl[10, c(11, 21, 22)]=c(1.0, -1.0, -1.0)
   Afl[11, c(10, 16, 21)]=c(-1.0, 1.0, 1.0)
   Afl[12, c(3, 5, 9, 20)]=c(-1.0, 1.0, 2.0, -1.0)
   Afl[13, c(3, 4, 6)]=c(-1.0, 1.0, 1.0)
   Afl[14, c(3, 24)]=c(1.0, 1.0)
   Afl[15, c(18, 22)]=c(-1.0, 1.0)
   Afl[16, c(1, 2)]=c(-1.0, 1.0)
   Afl[17, c(14, 25)]=c(-1.0, 1.0)
   Afl[18, c(4, 7)]=c(1.0, -1.0)
   Afl[19, c(14, 23, 24)]=c(1.0, -1.0, -1.0)
   Afl[20, c(6, 7)]=c(-1.0, 1.0)
   Afl[21, c(6, 23)]=c(1.0, 1.0)
   Afl[22, c(9, 19)]=c(-1.0, 1.0)
   Afl[23, c(5, 7)]=c(1.0, -1.0)
   Afl[24, c(12, 13)]=c(1.0, -1.0)
   Afl[25, c(2)]=c(1.0)
   Afl[26, c(26)]=c(-1.0)
} else {
   Afl=matrix(0., nb_fl, nb_fl)
}
dimnames(Afl)=list(c("Suc", "Mal", "Cit", "AKG", "CO2", "AcCoA", "Glc6P", "Fru6P", "PGA", "PEP", "OAA", "GA3P", "E2", "Xul5P", "Pyr", "Glc", "Gnt6P", "Ery4P", "Rub5P", "Sed7P", "Rib5P", "FruBP", "E3", "eq net: fum_a-fum_b=0: 624", "eq net: Glucupt_1+Glucupt_U=1: 625", "eq xch: fum_a-fum_b=0: 633"), nm_fl)
#browser()
# prepare param (\Theta) vector
# order: free flux net, free flux xch, scale label, scale mass, scale peak
param=numeric(0)
nm_par=c()
# free net fluxes
nb_ffn=4
nm_ffn=c("f.n.Glucupt_1", "f.n.edd", "f.n.out_Ac", "f.n.pgi")
# starting values for iterations
param=c(param, c(0.8128, 0.1, 0.48, 0.1))
if (nb_ffn) {
   nm_par=c(nm_par, nm_ffn)
}
# free xch fluxes
nb_ffx=11
nm_ffx=c("f.x.HR2", "f.x.HR3", "f.x.HR5", "f.x.ald", "f.x.eno", "f.x.pfk", "f.x.pgi", "f.x.pgk", "f.x.ppc", "f.x.pyk", "f.x.xul")
# starting values for iterations
param=c(param, c(0.0151117, 0.14, 0.02, 0.4, 0.99, 0.01, 0.4, 0.99, 0.2, 0.4, 0.0))
if (nb_ffx) {
   nm_par=c(nm_par, nm_ffx)
}
names(param)=nm_par
ff=param
nm_ff=c(nm_ffn, nm_ffx)
nm_list$ff=nm_ff
nb_param=length(param)
# scaling factors are added to param later

nb_ff=nb_ffn+nb_ffx

# constrained fluxes
# net
nb_fcn=13
nm_fcn=c("c.n.CO2upt", "c.n.Rib5P_gr", "c.n.bs_DHAP", "c.n.bs_accoa", "c.n.bs_akg", "c.n.bs_e4p", "c.n.bs_fru6P", "c.n.bs_glc6P", "c.n.bs_oaa", "c.n.bs_pep", "c.n.bs_pga", "c.n.bs_pyr", "c.n.bs_rib5P")
fcn=c(0.77, 8e-08, 0.0083, 0.1895, 0.0692, 0.0247, 0.0045, 0.0132, 0.1146, 0.0461, 0.0958, 0.1818, 0.0576)
# xch
nb_fcx=30
nm_fcx=c("c.x.CO2upt", "c.x.Glucupt", "c.x.Glucupt_1", "c.x.Glucupt_U", "c.x.HR1", "c.x.HR4", "c.x.Rib5P_gr", "c.x.akgdh", "c.x.bs_DHAP", "c.x.bs_accoa", "c.x.bs_akg", "c.x.bs_e4p", "c.x.bs_fru6P", "c.x.bs_glc6P", "c.x.bs_oaa", "c.x.bs_pep", "c.x.bs_pga", "c.x.bs_pyr", "c.x.bs_rib5P", "c.x.citsynth", "c.x.edd", "c.x.fum_a", "c.x.gnd", "c.x.idh", "c.x.maldh", "c.x.out_Ac", "c.x.out_co2", "c.x.pdh", "c.x.rib", "c.x.zwf")
fcx=c(0.0, 0.0, 0.0, 0.0, 0.24, 0.04, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01, 0.0, 0.0, 0.42, 0.0, 0.0, 0.01, 0.99, 0.0)
fc=c(fcn, fcx)
nm_fc=c(nm_fcn, nm_fcx)
names(fc)=nm_fc
nb_fc=nb_fcn+nb_fcx

# variable growth fluxes (constant are already accounted in constrained fluxes)
nb_fgr=11
nm_fgr=c("g.n.Cit_gr", "g.n.Fru6P_gr", "g.n.FruBP_gr", "g.n.Glc6P_gr", "g.n.Gnt6P_gr", "g.n.Mal_gr", "g.n.PEP_gr", "g.n.PGA_gr", "g.n.Rub5P_gr", "g.n.Suc_gr", "g.n.Xul5P_gr")
fgr=c(0.0013043178400589984, 8.005366040985944e-05, 0.000394227192605698, 0.00039240789240039327, 0.00011584719214754172, 0.000484357623744415, 4.401038788888554e-05, 0.00040068956189050697, 4.137932594348138e-05, 0.0011879861254524412, 0.0001655173037739255)
nm_list$fgr=nm_fgr
nb_f$nb_fgr=nb_fgr

# total flux vector fallnx dimension
nb_fallnx=nb_fl+nb_ff+nb_fc+nb_fgr+nb_fgr
nb_fwrv=nb_fallnx

# net dependent and free fluxes
nm_dfn=c(nm_fln, nm_ffn)
names(nm_dfn)=substring(nm_dfn, 5)

# all flux cardinals
nb_f=append(nb_f, list(nb_fln=nb_fln, nb_flx=nb_flx, nb_fl=nb_fl,
   nb_ffn=nb_ffn, nb_ffx=nb_ffx, nb_ff=nb_ff,
   nb_fcn=nb_fcn, nb_fcx=nb_fcx, nb_fc=nb_fc,
   nb_fallnx=nb_fallnx, nb_fwrv=nb_fwrv,
   nb_fgr=nb_fgr,
   include_growth_flux=TRUE,
   mu=0.8))

# prepare p2bfl, c2bfl, g2bfl, cnst2bfl matrices such that p2bfl%*%param[1:nb_ff]+
# c2bfl%*%fc+g2bfl%*%fgr+cnst2bfl=bfl
# replace f.[nx].flx by corresponding param coefficient
p2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_ff)
# replace c.[nx].flx by corresponding fc coefficient
c2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fc)
# variable growth fluxes
g2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fgr)
cnst2bfl=numeric(nb_flr); # may be coming from equalities
colnames(p2bfl)=nm_par
colnames(c2bfl)=nm_fc
colnames(g2bfl)=nm_fgr

g2bfl[1, pmatch(c("g.n.Suc_gr"), nm_fgr)]=c(1.0);

g2bfl[2, pmatch(c("g.n.Mal_gr"), nm_fgr)]=c(1.0);

g2bfl[3, pmatch(c("g.n.Cit_gr"), nm_fgr)]=c(1.0);

c2bfl[4, pmatch(c("c.n.bs_akg"), nm_fc)]=c(1.0);

c2bfl[5, pmatch(c("c.n.CO2upt"), nm_fc)]=c(-1.0);

p2bfl[6, pmatch(c("f.n.out_Ac"), nm_par)]=c(1.0);
c2bfl[6, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(1.0);

p2bfl[7, pmatch(c("f.n.pgi"), nm_par)]=c(1.0);
c2bfl[7, pmatch(c("c.n.bs_glc6P"), nm_fc)]=c(1.0);
g2bfl[7, pmatch(c("g.n.Glc6P_gr"), nm_fgr)]=c(1.0);

p2bfl[8, pmatch(c("f.n.pgi"), nm_par)]=c(-1.0);
c2bfl[8, pmatch(c("c.n.bs_fru6P"), nm_fc)]=c(1.0);
g2bfl[8, pmatch(c("g.n.Fru6P_gr"), nm_fgr)]=c(1.0);

c2bfl[9, pmatch(c("c.n.bs_pga"), nm_fc)]=c(1.0);
g2bfl[9, pmatch(c("g.n.PGA_gr"), nm_fgr)]=c(1.0);

c2bfl[10, pmatch(c("c.n.bs_pep"), nm_fc)]=c(1.0);
g2bfl[10, pmatch(c("g.n.PEP_gr"), nm_fgr)]=c(1.0);

c2bfl[11, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(1.0);

p2bfl[12, pmatch(c("f.n.edd"), nm_par)]=c(-1.0);
c2bfl[12, pmatch(c("c.n.bs_DHAP"), nm_fc)]=c(1.0);

g2bfl[14, pmatch(c("g.n.Xul5P_gr"), nm_fgr)]=c(1.0);

p2bfl[15, pmatch(c("f.n.edd"), nm_par)]=c(-1.0);
c2bfl[15, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(1.0);

p2bfl[16, pmatch(c("f.n.Glucupt_1"), nm_par)]=c(-1.0);

p2bfl[17, pmatch(c("f.n.edd"), nm_par)]=c(1.0);
g2bfl[17, pmatch(c("g.n.Gnt6P_gr"), nm_fgr)]=c(1.0);

c2bfl[18, pmatch(c("c.n.bs_e4p"), nm_fc)]=c(1.0);

g2bfl[19, pmatch(c("g.n.Rub5P_gr"), nm_fgr)]=c(1.0);

c2bfl[21, pmatch(c("c.n.bs_rib5P", "c.n.Rib5P_gr"), nm_fc)]=c(1.0, 1.0);

g2bfl[22, pmatch(c("g.n.FruBP_gr"), nm_fgr)]=c(1.0);


p2bfl[25, pmatch(c("f.n.Glucupt_1"), nm_par)]=c(-1.0);
cnst2bfl[25]=1;

c2bfl[26, pmatch(c("c.x.fum_a"), nm_fc)]=c(-1.0);

bp=as.numeric(c2bfl%stm%fc+cnst2bfl)

if (ffguess) {
   # make an automatic guess for free/dependent flux partition
   afd=as.matrix(cBind(Afl, -p2bfl))
   qafd=qr(afd, LAPACK=T)
   d=abs(diag(qafd$qr))
   rank=sum(d > d[1]*1.e-10)
   qrow=qr(t(afd))
   rankr=qrow$rank
   if (rank != rankr) {
      mes="Weird error: column and row ranks are not equal.\n"
      stop_mes(mes, file=fcerr)
   }
   irows=qrow$pivot[seq_len(rankr)]
   if (rank==0) {
      stop_mes("Error: No free/dependent flux partition could be made. Stoechiometric matrix has rank=0.\n", file=fcerr)
   }
   Afl=afd[irows, qafd$pivot[1L:rank], drop=FALSE]
   ka=kappa(Afl)
   if (ka > 1.e7) {
      mes=sprintf("Error: No working free/dependent flux partition could be proposed. Stoechiometric matrix has condition number %g.\n", ka)
      stop_mes(mes, file=fcerr)
   }
   p2bfl=-as.simple_triplet_matrix(afd[irows, qafd$pivot[-seq_len(rank)], drop=FALSE])
   c2bfl=c2bfl[irows, , drop=FALSE]
   g2bfl=g2bfl[irows, , drop=FALSE]
   cnst2bfl=cnst2bfl[irows]
   bp=bp[irows]
   
   # replace names
   nm_fl=sub("f.", "d.", colnames(Afl), fixed=T)
   colnames(Afl)=nm_fl # both net and xch
   nm_fln=sort(grep("^d.n.", nm_fl, v=T))
   nm_flx=sort(grep("^d.x.", nm_fl, v=T))
   nm_fl=c(nm_fln, nm_flx)
   Afl=Afl[, nm_fl, drop=FALSE]
   
   nm_ff=sub("d.", "f.", colnames(p2bfl), fixed=T) # both net and xch
   colnames(p2bfl)=nm_ff
   nm_ffn=sort(grep("^f.n.", nm_ff, v=T))
   nm_ffx=sort(grep("^f.x.", nm_ff, v=T))
   nm_ff=c(nm_ffn, nm_ffx)
   p2bfl=p2bfl[, nm_ff, drop=FALSE]
   
   # remake param vector
   if (!fdfit)
      param=c(runif(length(nm_ff)), if (nb_ff == 0) param else param[-seq_len(nb_ff)])
   names(param)[seq(along=nm_ff)]=nm_ff
#browser()
}
nm_list$flnx=nm_fl
nm_fallnx=c(nm_fln, nm_ffn, nm_fcn, nm_fgr, nm_flx, nm_ffx, nm_fcx, sub(".n.", ".x.", nm_fgr, fixed=T))
nm_list$fallnx=nm_fallnx
nm_net=c(nm_fln, nm_ffn, nm_fcn)
names(nm_net)=substring(nm_net, 5)
nm_xch=c(nm_flx, nm_ffx, nm_fcx)
names(nm_xch)=substring(nm_xch, 5)
edge2fl[]=nm_net[substring(edge2fl, 5)]
nm_list$ff=nm_ff

# accounting numbers
nb_flr=nrow(Afl)
nb_param=length(param)
nb_ffn=length(nm_ffn)
nb_ffx=length(nm_ffx)
nb_ff=nb_ffn+nb_ffx
nb_fln=length(nm_fln)
nb_flx=length(nm_flx)
nb_fl=nb_fln+nb_flx
nm_par=names(param)

for (item in c("nb_fln", "nb_flx", "nb_fl", "nb_ffn", "nb_ffx", "nb_ff")) {
   nb_f[item]=get(item)
}
# translation from n-x to fw-rv
sh_fwrv=substring(nm_fwrv[1:(nb_fwrv/2)], 5)
sh_nx=substring(nm_fallnx, 2)
nb_f$inet2ifwrv=pmatch(paste(".n.", sh_fwrv, sep=""), sh_nx)
nb_f$ixch2ifwrv=pmatch(paste(".x.", sh_fwrv, sep=""), sh_nx)
#nb_f$inet2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.n\\.%s$", substring(f, 5)), nm_fallnx))
#nb_f$ixch2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.x\\.%s$", substring(f, 5)), nm_fallnx))

if (TIMEIT) {
   cat("Afl qr(): ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

qrAfl=qr(Afl, LAPACK=T)
d=abs(diag(qrAfl$qr))
qrAfl$rank=sum(d > d[1]*1.e-10)
rank=qrAfl$rank
aful=as.matrix(cBind(Afl, -p2bfl, -c2bfl))
qrow=qr(t(aful))
rankr=qrow$rank
#browser()
# first check the presence of lindep rows
if (nrow(Afl) > rankr) {
   prop=sprintf("Error: Among %d equations (rows), %d are redundant and must be eliminated by hand.\n", nrow(Afl), nrow(Afl)-rankr)
   prop=paste(prop, "Candidate(s) for elimination is (are):\n",
      paste(rownames(Afl)[qrow$pivot[-(1:rankr)]], sep="", collapse="\n"),
               "\n", sep="")
   stop_mes(prop, file=fcerr)
}
if (nrow(Afl) != rank || nrow(Afl) != ncol(Afl)) {
   #write.table(Afl)
   mes=NULL
   if (nrow(Afl) <= rank) {
      mes=paste("Candidate(s) for free or constrained flux(es):\n",
         paste(colnames(Afl)[-qrAfl$pivot[1L:nrow(Afl)]], collapse="\n"),
         "\nFor this choice, condition number of stoechiometric matrix will be ",
         kappa(Afl[,qrAfl$pivot[1L:nrow(Afl)],drop=FALSE]), "\n", sep="")
   } else if (nrow(Afl) > rank) {
      nextra=nrow(Afl)-rank
      comb=combn(c(nm_ffn, colnames(Afl)[-qrAfl$pivot[1L:rank]]), nextra)
      aextra=cBind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl)
      colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl))
      ara=Afl[,qrAfl$pivot[1L:rank],drop=FALSE]
      i=which.min(apply(comb, 2, function(i) kappa(cBind(ara, aextra[,i]))))[1L]
      nm_tmp=comb[,i]
      ka=kappa(cBind(ara, aextra[,nm_tmp]))
      if (ka < 1.e7) {
         prop=paste("Proposal to declare dependent flux(es) is:\n",
            paste(nm_tmp, collapse="\n"), "\n", sep="")
         if (rank < ncol(Afl)) {
            prop=prop%s+%"While the following dependent flux(es) should be declared free or constrained:\n"%s+%join("\n", colnames(Afl)[-qrAfl$pivot[1L:rank]])%s+%"\n"
         }
         prop=paste(prop, "For this choice, condition number of stoechiometric matrix will be ", ka, "\n", sep="")
      } else {
         # add constraint fluxes to candidate list
         if (nb_fcn > 0) {
            aextra=as.matrix(cBind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl, -c2bfl))
            colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl), colnames(c2bfl))
         }
         aextended=aful
         qae=qr(aextended, LAPACK=T)
         d=abs(diag(qae$qr))
         ranke=sum(d > d[1L]*1.e-10)
         if (ranke == nrow(Afl)) {
            prop=paste("Proposal to declare dependent flux(es) is:\n",
            join("\n", colnames(aextended)[qae$pivot[1L:ranke]]), "\n",
            "while free and constrained fluxes should be:\n",
            join("\n", colnames(aextended)[-qae$pivot[1L:ranke]]), "\n",
            sep="")
            ka=kappa(aextended[,qae$pivot[1L:ranke]])
            prop=paste(prop, "For this choice, condition number of stoechiometric matrix will be ", ka, "\n", sep="")
         } else {
            prop="No proposal for partition dependent/free fluxes could be made.\n"
         }
      }
      mes=paste("There is (are) probably ", nextra,
         " extra free flux(es) among the following:\n",
         paste(nm_ffn, collapse="\n"), "\n",
         prop,
         sep="")
   }
   stop_mes(paste("Flux matrix is not square or is singular: (", nrow(Afl), "eq x ", ncol(Afl), "unk)\n",
      "You have to change your choice of free fluxes in the 'e_coli_growth.ftbl' file.\n",
      mes, sep=""), file=fcerr)
}

# make sure that free params choice leads to not singular matrix
if (qrAfl$rank != nb_fl) {
   #write.table(Afl)
   # make a suggestion of new free fluxes
   A=cBind(Afl, -p2bfl, -c2bfl)
   colnames(A)=c(colnames(Afl), nm_ff, nm_fc)
   qa=qr(A, LAPACK=T)
   d=diag(qa$qr)
   qa$rank=sum(abs(d)>=abs(d[1]*1.e-10))
   
   mes=paste("Error: Dependent flux matrix is singular.\n",
      "Change your partition on free/dependent/constrained fluxes in the 'e_coli_growth.ftbl' file.\n",
      "Can not resolve dependent fluxe(s):\n",
      paste(colnames(Afl)[-qrAfl$pivot[(1:qrAfl$rank)]], collapse="\n"),
      sep="")
   if (qa$rank==nb_fl) {
      mes=paste(mes,
      "\n\nSuggested dependent fluxes:\n",
      paste(colnames(A)[qa$pivot[(1:qa$rank)]], collapse="\n"),
      "\n\nWhich would give the following free and constrained fluxes:\n",
      paste(colnames(A)[-qa$pivot[(1:qa$rank)]], collapse="\n"), "\n",
      sep="")
   } else {
      mes=paste(mes, "\nNo suggested free fluxes could be found", sep="")
   }
   stop_mes(mes, file=fcerr)
}

# inverse flux matrix
invAfl=solve(qrAfl)

if (fdfit) {
#browser()
   # choose free fluxe values such that they fit starting values from ftbl
   #dep=invAfl%*%(p2bfl%*%ff+bp)
   #ff=ff
   ff=qr.solve(rbind(invAfl%stm%p2bfl, diag(ncol(p2bfl))), c(fl-invAfl%*%bp, param))
}
# intermediate jacobian
if (TIMEIT) {
   cat("dfl_dffg: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

dfl_dffg=invAfl%stm%p2bfl
if (nb_fgr > 0L) {
   dfl_dffg=cBind(dfl_dffg, invAfl%stm%g2bfl)
}
dimnames(dfl_dffg)=list(nm_fl, c(nm_ff, nm_fgr))
dfl_dffg[abs(dfl_dffg) < 1.e-14]=0.
nb_f$dfl_dffg=as.simple_triplet_matrix(dfl_dffg)

# prepare mf, md, mc and mg matrices
# such that mf%*%ff+md%*%fl+mc%*%fc+mg%*%fgr gives fallnx
# here ff free fluxes (param), fl are dependent fluxes, fc are constrained
# fluxes and fgr are variable growth fluxes
mf=matrix(0., nb_fallnx, nb_ff)
dimnames(mf)=list(nm_fallnx, nm_ff)
md=matrix(0., nb_fallnx, nb_fl)
dimnames(md)=list(nm_fallnx, nm_fl)
mc=matrix(0., nb_fallnx, nb_fc)
dimnames(mc)=list(nm_fallnx, nm_fc)
mg=matrix(0., nb_fallnx, nb_fgr)
dimnames(mg)=list(nm_fallnx, nm_fgr)

if (nb_ff > 0) {
   mf[nm_ff, nm_ff]=diag(1., nb_ff)
}
if (nb_fl > 0) {
   md[nm_fl, nm_fl]=diag(1., nb_fl)
}
if (nb_fc > 0) {
   mc[nm_fc, nm_fc]=diag(1., nb_fc)
}
if (nb_fgr > 0) {
   mg[nm_fgr, nm_fgr]=diag(1., nb_fgr)
}

# sparse matrix static parts
# $varname fields:
#  ind_fa - flux index in a_pre$vfwrv[ind_fa]
#  a_pre - sparse matrix whose colsum() gives the a$v vector
#  prodx - dense matrix whose colprod() will give x[ind_x1]*x[ind_x2]*...
#  ind_fb - flux index in b_pre$v=fwrv[ind_fb1]*colprod(prodx)
#  ind_b - dense matrix of indexes for  b_pre$v=f[ind_b[,"indf"]*x[ind_b[,2+1]]*x[ind_b[,2+2]], ...]
#  b_pre - sparse matrix whose colsum gives b@x

#  a - unsigned sparse cumomer A matrix (off-diagonal part)
#  b - unsigned sparse vector of right hand side

if (TIMEIT) {
   cat("spAbr   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

nb_fwrv=106
nb_w=7
spAbr=list()

if (TIMEIT) {
   cat("weight 1: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=1
nb_c=99
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=0 # number of lighter cumomers
maxprod=1
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(40, 0, 0, 104, 0, 0, 105, 0, 0, 40, 0, 57, 104, 0, 22, 105, 0, 32, 6, 1, 1, 100, 1, 1, 106, 1, 1, 6, 1, 93, 100, 1, 44, 106, 1, 47, 48, 2, 2, 90, 2, 2, 48, 2, 75, 90, 2, 54, 14, 3, 3, 66, 3, 3, 14, 3, 68, 66, 3, 66, 52, 4, 4, 10, 4, 4, 52, 4, 20, 10, 4, 70, 47, 5, 5, 99, 5, 5, 64, 5, 5, 65, 5, 5, 47, 5, 34, 99, 5, 55, 64, 5, 73, 65, 5, 71, 46, 6, 6, 76, 6, 6, 46, 6, 46, 76, 6, 70, 46, 7, 7, 76, 7, 7, 46, 7, 60, 76, 7, 71, 38, 8, 8, 39, 8, 8, 95, 8, 8, 38, 8, 91, 39, 8, 89, 95, 8, 81, 51, 9, 9, 13, 9, 9, 51, 9, 41, 13, 9, 53, 45, 10, 10, 88, 10, 10, 45, 10, 78, 88, 10, 15, 35, 11, 11, 94, 11, 11, 35, 11, 81, 94, 11, 85, 52, 12, 12, 10, 12, 12, 52, 12, 48, 10, 12, 75, 51, 13, 13, 13, 13, 13, 51, 13, 20, 13, 13, 63, 51, 14, 14, 13, 14, 14, 51, 14, 48, 13, 14, 24, 35, 15, 15, 94, 15, 15, 35, 15, 10, 94, 15, 86, 38, 16, 16, 39, 16, 16, 95, 16, 16, 38, 16, 92, 39, 16, 90, 95, 16, 82, 45, 17, 17, 88, 17, 17, 45, 17, 74, 88, 17, 35, 14, 18, 18, 66, 18, 18, 14, 18, 69, 66, 18, 64, 35, 19, 19, 94, 19, 19, 35, 19, 83, 94, 19, 88, 40, 20, 20, 104, 20, 20, 105, 20, 20, 40, 20, 33, 104, 20, 13, 105, 20, 4, 47, 21, 21, 99, 21, 21, 64, 21, 21, 65, 21, 21, 47, 21, 29, 99, 21, 51, 64, 21, 64, 65, 21, 69, 51, 22, 22, 13, 22, 22, 51, 22, 0, 13, 22, 50, 6, 23, 23, 100, 23, 23, 106, 23, 23, 6, 23, 94, 100, 23, 62, 106, 23, 58, 14, 24, 24, 66, 24, 24, 14, 24, 77, 66, 24, 14, 35, 25, 25, 94, 25, 25, 35, 25, 80, 94, 25, 87, 6, 26, 26, 100, 26, 26, 106, 26, 26, 6, 26, 95, 100, 26, 46, 106, 26, 33, 38, 27, 27, 39, 27, 27, 95, 27, 27, 38, 27, 90, 39, 27, 92, 95, 27, 83, 46, 28, 28, 76, 28, 28, 46, 28, 62, 76, 28, 75, 6, 29, 29, 100, 29, 29, 106, 29, 29, 6, 29, 96, 100, 29, 21, 106, 29, 57, 37, 30, 30, 102, 30, 30, 103, 30, 30, 37, 30, 49, 102, 30, 82, 103, 30, 79, 52, 31, 31, 10, 31, 31, 52, 31, 59, 10, 31, 64, 52, 32, 32, 10, 32, 32, 52, 32, 0, 10, 32, 66, 53, 33, 33, 89, 33, 33, 93, 33, 33, 53, 33, 26, 89, 33, 70, 93, 33, 20, 6, 34, 34, 100, 34, 34, 106, 34, 34, 6, 34, 97, 100, 34, 5, 106, 34, 52, 35, 35, 35, 94, 35, 35, 35, 35, 17, 94, 35, 84, 6, 36, 36, 100, 36, 36, 106, 36, 36, 6, 36, 98, 100, 36, 60, 106, 36, 38, 38, 37, 37, 39, 37, 37, 95, 37, 37, 38, 37, 89, 39, 37, 91, 95, 37, 80, 53, 38, 38, 89, 38, 38, 93, 38, 38, 53, 38, 36, 89, 38, 79, 93, 38, 65, 35, 39, 39, 94, 39, 39, 35, 39, 82, 94, 39, 65, 48, 40, 40, 90, 40, 40, 48, 40, 71, 90, 40, 61, 40, 41, 41, 104, 41, 41, 105, 41, 41, 40, 41, 52, 104, 41, 9, 105, 41, 43, 14, 42, 42, 66, 42, 42, 14, 42, 72, 66, 42, 45, 52, 43, 43, 10, 43, 43, 52, 43, 41, 10, 43, 71, 47, 44, 44, 99, 44, 44, 64, 44, 44, 65, 44, 44, 47, 44, 1, 99, 44, 56, 64, 44, 72, 65, 44, 67, 51, 45, 45, 13, 45, 45, 51, 45, 59, 13, 45, 42, 47, 46, 46, 99, 46, 46, 64, 46, 46, 65, 46, 46, 47, 46, 26, 99, 46, 6, 64, 46, 76, 65, 46, 70, 53, 47, 47, 89, 47, 47, 93, 47, 47, 53, 47, 1, 89, 47, 78, 93, 47, 59, 40, 48, 48, 104, 48, 48, 105, 48, 48, 40, 48, 58, 104, 48, 14, 105, 48, 12, 48, 49, 49, 90, 49, 49, 48, 49, 70, 90, 49, 30, 14, 50, 50, 66, 50, 50, 14, 50, 67, 66, 50, 22, 46, 51, 51, 76, 51, 51, 46, 51, 21, 76, 51, 75, 53, 52, 52, 89, 52, 52, 93, 52, 52, 53, 52, 34, 89, 52, 71, 93, 52, 41, 14, 53, 53, 66, 53, 53, 14, 53, 73, 66, 53, 9, 37, 54, 54, 102, 54, 54, 103, 54, 54, 37, 54, 2, 102, 54, 80, 103, 54, 74, 46, 55, 55, 76, 55, 55, 46, 55, 5, 76, 55, 71, 46, 56, 56, 76, 56, 56, 46, 56, 44, 76, 56, 70, 53, 57, 57, 89, 57, 57, 93, 57, 57, 53, 57, 29, 89, 57, 74, 93, 57, 0, 53, 58, 58, 89, 58, 58, 93, 58, 58, 53, 58, 23, 89, 58, 75, 93, 58, 48, 40, 59, 59, 104, 59, 59, 105, 59, 59, 40, 59, 47, 104, 59, 45, 105, 59, 31, 47, 60, 60, 99, 60, 60, 64, 60, 60, 65, 60, 60, 47, 60, 36, 99, 60, 7, 64, 60, 66, 65, 60, 68, 37, 61, 61, 102, 61, 61, 103, 61, 61, 37, 61, 40, 102, 61, 81, 103, 61, 78, 47, 62, 62, 99, 62, 62, 64, 62, 62, 65, 62, 62, 47, 62, 23, 99, 62, 28, 64, 62, 77, 65, 62, 75, 14, 63, 63, 66, 63, 63, 14, 63, 76, 66, 63, 13, 11, 64, 64, 13, 64, 64, 63, 64, 64, 11, 64, 21, 13, 64, 18, 63, 64, 31, 22, 65, 65, 41, 65, 65, 45, 65, 65, 40, 65, 65, 102, 65, 65, 1, 65, 65, 22, 65, 88, 41, 65, 39, 45, 65, 79, 40, 65, 38, 102, 65, 83, 11, 66, 66, 13, 66, 66, 63, 66, 66, 11, 66, 60, 13, 66, 3, 63, 66, 32, 12, 67, 67, 67, 67, 67, 12, 67, 44, 67, 67, 50, 12, 68, 68, 67, 68, 68, 12, 68, 60, 67, 68, 3, 12, 69, 69, 67, 69, 69, 12, 69, 21, 67, 69, 18, 12, 70, 70, 36, 70, 70, 23, 70, 70, 23, 70, 70, 63, 70, 70, 101, 70, 70, 12, 70, 46, 36, 70, 33, 23, 70, 56, 23, 70, 6, 63, 70, 4, 101, 70, 49, 12, 71, 71, 36, 71, 71, 23, 71, 71, 23, 71, 71, 63, 71, 71, 101, 71, 71, 12, 71, 5, 36, 71, 52, 23, 71, 7, 23, 71, 55, 63, 71, 43, 101, 71, 40, 11, 72, 72, 67, 72, 72, 11, 72, 44, 67, 72, 42, 11, 73, 73, 67, 73, 73, 11, 73, 5, 67, 73, 53, 50, 74, 74, 36, 74, 74, 98, 74, 74, 50, 74, 54, 36, 74, 57, 98, 74, 17, 12, 75, 75, 36, 75, 75, 23, 75, 75, 23, 75, 75, 63, 75, 75, 101, 75, 75, 12, 75, 62, 36, 75, 58, 23, 75, 51, 23, 75, 28, 63, 75, 12, 101, 75, 2, 11, 76, 76, 67, 76, 76, 11, 76, 46, 67, 76, 63, 11, 77, 77, 67, 77, 77, 11, 77, 62, 67, 77, 24, 50, 78, 78, 36, 78, 78, 98, 78, 78, 50, 78, 61, 36, 78, 47, 98, 78, 10, 50, 79, 79, 36, 79, 79, 98, 79, 79, 50, 79, 30, 36, 79, 38, 98, 79, 65, 49, 80, 80, 42, 80, 80, 88, 80, 80, 49, 80, 54, 42, 80, 37, 88, 80, 25, 49, 81, 81, 42, 81, 81, 88, 81, 81, 49, 81, 61, 42, 81, 8, 88, 81, 11, 49, 82, 82, 42, 82, 82, 88, 82, 82, 49, 82, 30, 42, 82, 16, 88, 82, 39, 49, 83, 83, 42, 83, 83, 88, 83, 83, 49, 83, 65, 42, 83, 27, 88, 83, 19, 41, 84, 84, 75, 84, 84, 41, 84, 35, 75, 84, 90, 41, 85, 85, 75, 85, 85, 41, 85, 11, 75, 85, 92, 41, 86, 86, 75, 86, 86, 41, 86, 15, 75, 86, 91, 41, 87, 87, 75, 87, 87, 41, 87, 25, 75, 87, 89, 41, 88, 88, 75, 88, 88, 41, 88, 19, 75, 88, 65, 22, 89, 89, 91, 89, 89, 92, 89, 89, 22, 89, 87, 91, 89, 37, 92, 89, 8, 22, 90, 90, 91, 90, 90, 92, 90, 90, 22, 90, 84, 91, 90, 27, 92, 90, 16, 22, 91, 91, 91, 91, 91, 92, 91, 91, 22, 91, 86, 91, 91, 8, 92, 91, 37, 22, 92, 92, 91, 92, 92, 92, 92, 92, 22, 92, 85, 91, 92, 16, 92, 92, 27, 59, 93, 93, 7, 93, 93, 8, 93, 93, 59, 93, 1, 59, 94, 94, 7, 94, 94, 8, 94, 94, 59, 94, 23, 59, 95, 95, 7, 95, 95, 8, 95, 95, 59, 95, 26, 59, 96, 96, 7, 96, 96, 8, 96, 96, 59, 96, 29, 59, 97, 97, 7, 97, 97, 8, 97, 97, 59, 97, 34, 59, 98, 98, 7, 98, 98, 8, 98, 98, 59, 98, 36)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(1, 66, 116, 7, 94, 117, 8, 94, 118, 7, 95, 119, 8, 95, 120, 7, 96, 121, 8, 96, 122, 7, 97, 123, 8, 97, 124, 7, 98, 125, 8, 98, 126, 7, 99, 127, 8, 99, 128)), ncol=2+1, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(1), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 2: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=2
nb_c=192
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=99 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(40, 0, 0, 104, 0, 0, 105, 0, 0, 40, 0, 32, 104, 0, 77, 105, 0, 70, 52, 1, 1, 10, 1, 1, 52, 1, 127, 10, 1, 139, 53, 2, 2, 89, 2, 2, 93, 2, 2, 53, 2, 114, 53, 3, 3, 89, 3, 3, 93, 3, 3, 53, 3, 71, 89, 3, 148, 93, 3, 4, 40, 4, 4, 104, 4, 4, 105, 4, 4, 40, 4, 3, 104, 4, 34, 105, 4, 21, 38, 5, 5, 39, 5, 5, 95, 5, 5, 38, 5, 172, 39, 5, 172, 95, 5, 156, 35, 6, 6, 94, 6, 6, 35, 6, 134, 94, 6, 164, 66, 7, 7, 14, 7, 7, 66, 7, 66, 94, 8, 8, 35, 8, 8, 94, 8, 165, 46, 9, 9, 76, 9, 9, 46, 9, 86, 94, 10, 10, 35, 10, 10, 94, 10, 168, 66, 11, 11, 14, 11, 11, 66, 11, 19, 46, 12, 12, 76, 12, 12, 46, 12, 117, 52, 13, 13, 10, 13, 13, 52, 13, 125, 14, 14, 14, 66, 14, 14, 47, 15, 15, 99, 15, 15, 64, 15, 15, 65, 15, 15, 47, 15, 22, 99, 15, 93, 6, 16, 16, 100, 16, 16, 106, 16, 16, 6, 16, 177, 100, 16, 131, 106, 16, 136, 37, 17, 17, 102, 17, 17, 103, 17, 17, 37, 17, 135, 102, 17, 157, 103, 17, 150, 40, 18, 18, 104, 18, 18, 105, 18, 18, 40, 18, 101, 104, 18, 19, 105, 18, 62, 51, 19, 19, 13, 19, 19, 51, 19, 18, 13, 19, 11, 94, 20, 20, 35, 20, 20, 94, 20, 170, 52, 21, 21, 10, 21, 21, 52, 21, 4, 10, 21, 148, 6, 22, 22, 100, 22, 22, 106, 22, 22, 6, 22, 178, 100, 22, 15, 106, 22, 24, 14, 23, 23, 66, 23, 23, 53, 24, 24, 89, 24, 24, 93, 24, 24, 53, 24, 22, 14, 25, 25, 66, 25, 25, 14, 25, 153, 66, 25, 39, 47, 26, 26, 99, 26, 26, 64, 26, 26, 65, 26, 26, 47, 26, 65, 99, 26, 61, 64, 26, 145, 53, 27, 27, 93, 27, 27, 89, 27, 27, 53, 27, 65, 93, 27, 100, 48, 28, 28, 90, 28, 28, 48, 28, 147, 90, 28, 119, 52, 29, 29, 10, 29, 29, 52, 29, 30, 40, 30, 30, 104, 30, 30, 105, 30, 30, 40, 30, 57, 104, 30, 35, 105, 30, 29, 14, 31, 31, 66, 31, 31, 14, 31, 145, 66, 31, 45, 53, 32, 32, 93, 32, 32, 89, 32, 32, 53, 32, 97, 93, 32, 0, 6, 33, 33, 100, 33, 33, 106, 33, 33, 6, 33, 179, 100, 33, 112, 106, 33, 41, 51, 34, 34, 13, 34, 34, 51, 34, 4, 13, 34, 80, 51, 35, 35, 13, 35, 35, 51, 35, 30, 13, 35, 106, 53, 36, 36, 89, 36, 36, 93, 36, 36, 53, 36, 107, 89, 36, 143, 93, 36, 52, 35, 37, 37, 94, 37, 37, 46, 38, 38, 76, 38, 38, 46, 38, 112, 51, 39, 39, 13, 39, 39, 51, 39, 52, 13, 39, 25, 6, 40, 40, 100, 40, 40, 106, 40, 40, 6, 40, 180, 100, 40, 56, 106, 40, 59, 53, 41, 41, 93, 41, 41, 89, 41, 41, 53, 41, 33, 93, 41, 92, 35, 42, 42, 94, 42, 42, 35, 42, 159, 46, 43, 43, 76, 43, 43, 46, 43, 124, 46, 44, 44, 76, 44, 44, 46, 44, 56, 76, 44, 143, 51, 45, 45, 13, 45, 45, 51, 45, 100, 13, 45, 31, 52, 46, 46, 10, 46, 46, 52, 46, 92, 6, 47, 47, 100, 47, 47, 106, 47, 47, 6, 47, 181, 100, 47, 99, 106, 47, 84, 51, 48, 48, 13, 48, 48, 51, 48, 92, 13, 48, 129, 35, 49, 49, 94, 49, 49, 14, 50, 50, 66, 50, 50, 52, 51, 51, 10, 51, 51, 52, 51, 52, 10, 51, 143, 40, 52, 52, 104, 52, 52, 105, 52, 52, 40, 52, 36, 104, 52, 39, 105, 52, 51, 14, 53, 53, 66, 53, 53, 35, 54, 54, 94, 54, 54, 35, 54, 157, 47, 55, 55, 99, 55, 55, 64, 55, 55, 65, 55, 55, 47, 55, 123, 99, 55, 68, 47, 56, 56, 99, 56, 56, 65, 56, 56, 64, 56, 56, 47, 56, 40, 99, 56, 44, 65, 56, 142, 53, 57, 57, 93, 57, 57, 89, 57, 57, 53, 57, 132, 93, 57, 30, 35, 58, 58, 94, 58, 58, 35, 58, 160, 94, 58, 161, 53, 59, 59, 89, 59, 59, 93, 59, 59, 53, 59, 40, 89, 59, 151, 94, 60, 60, 35, 60, 60, 94, 60, 162, 46, 61, 61, 76, 61, 61, 46, 61, 26, 52, 62, 62, 10, 62, 62, 52, 62, 18, 46, 63, 63, 76, 63, 63, 46, 63, 131, 76, 63, 147, 14, 64, 64, 66, 64, 64, 14, 64, 140, 6, 65, 65, 100, 65, 65, 106, 65, 65, 6, 65, 182, 100, 65, 26, 106, 65, 27, 51, 66, 66, 13, 66, 66, 51, 66, 127, 13, 66, 7, 46, 67, 67, 76, 67, 67, 46, 67, 99, 46, 68, 68, 76, 68, 68, 46, 68, 55, 35, 69, 69, 94, 69, 69, 35, 69, 155, 94, 69, 169, 52, 70, 70, 10, 70, 70, 52, 70, 0, 6, 71, 71, 100, 71, 71, 106, 71, 71, 6, 71, 183, 100, 71, 122, 106, 71, 3, 47, 72, 72, 99, 72, 72, 64, 72, 72, 65, 72, 72, 47, 72, 114, 99, 72, 79, 46, 73, 73, 76, 73, 73, 46, 73, 102, 76, 73, 147, 53, 74, 74, 89, 74, 74, 93, 74, 74, 53, 74, 126, 37, 75, 75, 102, 75, 75, 103, 75, 75, 37, 75, 89, 102, 75, 159, 103, 75, 151, 46, 76, 76, 76, 76, 76, 46, 76, 122, 76, 76, 148, 51, 77, 77, 13, 77, 77, 51, 77, 0, 13, 77, 95, 51, 78, 78, 13, 78, 78, 51, 78, 105, 13, 78, 85, 46, 79, 79, 76, 79, 79, 46, 79, 72, 14, 80, 80, 66, 80, 80, 14, 80, 146, 66, 80, 34, 38, 81, 81, 39, 81, 81, 95, 81, 81, 38, 81, 173, 39, 81, 171, 95, 81, 157, 38, 82, 82, 39, 82, 82, 95, 82, 82, 38, 82, 174, 39, 82, 176, 95, 82, 160, 53, 83, 83, 89, 83, 83, 93, 83, 83, 53, 83, 103, 89, 83, 144, 93, 83, 127, 53, 84, 84, 93, 84, 84, 89, 84, 84, 53, 84, 47, 93, 84, 125, 14, 85, 85, 66, 85, 85, 14, 85, 154, 66, 85, 78, 47, 86, 86, 99, 86, 86, 64, 86, 86, 65, 86, 86, 47, 86, 97, 99, 86, 9, 64, 86, 152, 35, 87, 87, 94, 87, 87, 35, 87, 158, 94, 87, 167, 6, 88, 88, 100, 88, 88, 106, 88, 88, 6, 88, 184, 100, 88, 102, 106, 88, 91, 48, 89, 89, 90, 89, 89, 48, 89, 143, 90, 89, 75, 14, 90, 90, 66, 90, 90, 53, 91, 91, 89, 91, 91, 93, 91, 91, 53, 91, 88, 89, 91, 150, 40, 92, 92, 104, 92, 92, 105, 92, 92, 40, 92, 41, 104, 92, 48, 105, 92, 46, 46, 93, 93, 76, 93, 93, 46, 93, 15, 38, 94, 94, 39, 94, 94, 95, 94, 94, 38, 94, 175, 39, 94, 175, 95, 94, 158, 14, 95, 95, 66, 95, 95, 14, 95, 152, 66, 95, 77, 52, 96, 96, 10, 96, 96, 52, 96, 100, 6, 97, 97, 100, 97, 97, 106, 97, 97, 6, 97, 185, 100, 97, 86, 106, 97, 32, 38, 98, 98, 39, 98, 98, 95, 98, 98, 38, 98, 171, 39, 98, 173, 95, 98, 155, 47, 99, 99, 99, 99, 99, 64, 99, 99, 65, 99, 99, 47, 99, 47, 99, 99, 67, 64, 99, 149, 40, 100, 100, 104, 100, 100, 105, 100, 100, 40, 100, 27, 104, 100, 45, 105, 100, 96, 53, 101, 101, 93, 101, 101, 89, 101, 101, 53, 101, 123, 93, 101, 18, 47, 102, 102, 99, 102, 102, 64, 102, 102, 65, 102, 102, 47, 102, 88, 99, 102, 73, 64, 102, 139, 65, 102, 141, 6, 103, 103, 100, 103, 103, 106, 103, 103, 6, 103, 186, 100, 103, 115, 106, 103, 83, 14, 104, 104, 66, 104, 104, 14, 104, 149, 66, 104, 111, 40, 105, 105, 104, 105, 105, 105, 105, 105, 40, 105, 136, 104, 105, 78, 105, 105, 137, 66, 106, 106, 14, 106, 106, 66, 106, 35, 6, 107, 107, 100, 107, 107, 106, 107, 107, 6, 107, 187, 100, 107, 116, 106, 107, 36, 94, 108, 108, 35, 108, 108, 94, 108, 163, 14, 109, 109, 66, 109, 109, 35, 110, 110, 94, 110, 110, 35, 110, 156, 51, 111, 111, 13, 111, 111, 51, 111, 125, 13, 111, 104, 47, 112, 112, 99, 112, 112, 64, 112, 112, 65, 112, 112, 47, 112, 33, 99, 112, 38, 94, 113, 113, 35, 113, 113, 94, 113, 166, 6, 114, 114, 100, 114, 114, 106, 114, 114, 6, 114, 188, 100, 114, 72, 106, 114, 2, 47, 115, 115, 99, 115, 115, 65, 115, 115, 64, 115, 115, 47, 115, 103, 99, 115, 138, 65, 115, 140, 47, 116, 116, 99, 116, 116, 64, 116, 116, 65, 116, 116, 47, 116, 107, 99, 116, 118, 64, 116, 153, 65, 116, 143, 47, 117, 117, 99, 117, 117, 64, 117, 117, 65, 117, 117, 47, 117, 132, 99, 117, 12, 46, 118, 118, 76, 118, 118, 46, 118, 116, 76, 118, 143, 37, 119, 119, 102, 119, 119, 103, 119, 119, 37, 119, 28, 102, 119, 158, 103, 119, 144, 14, 120, 120, 66, 120, 120, 14, 120, 142, 14, 121, 121, 66, 121, 121, 47, 122, 122, 99, 122, 122, 64, 122, 122, 65, 122, 122, 47, 122, 71, 99, 122, 76, 64, 122, 146, 65, 122, 148, 6, 123, 123, 100, 123, 123, 106, 123, 123, 6, 123, 189, 100, 123, 55, 106, 123, 101, 47, 124, 124, 99, 124, 124, 64, 124, 124, 65, 124, 124, 47, 124, 126, 99, 124, 43, 40, 125, 125, 104, 125, 125, 105, 125, 125, 40, 125, 84, 104, 125, 111, 105, 125, 13, 6, 126, 126, 100, 126, 126, 106, 126, 126, 6, 126, 190, 100, 126, 124, 106, 126, 74, 40, 127, 127, 104, 127, 127, 105, 127, 127, 40, 127, 83, 104, 127, 66, 105, 127, 1, 14, 128, 128, 66, 128, 128, 66, 129, 129, 14, 129, 129, 66, 129, 48, 14, 130, 130, 66, 130, 130, 14, 130, 141, 66, 130, 139, 47, 131, 131, 99, 131, 131, 64, 131, 131, 65, 131, 131, 47, 131, 16, 99, 131, 63, 64, 131, 154, 65, 131, 147, 6, 132, 132, 100, 132, 132, 106, 132, 132, 6, 132, 191, 100, 132, 117, 106, 132, 57, 38, 133, 133, 39, 133, 133, 95, 133, 133, 38, 133, 176, 39, 133, 174, 95, 133, 159, 45, 134, 134, 88, 134, 134, 45, 134, 144, 88, 134, 6, 48, 135, 135, 90, 135, 135, 48, 135, 148, 90, 135, 17, 53, 136, 136, 89, 136, 136, 93, 136, 136, 53, 136, 16, 89, 136, 147, 93, 136, 105, 52, 137, 137, 10, 137, 137, 52, 137, 105, 10, 137, 147, 46, 138, 138, 76, 138, 138, 46, 138, 115, 76, 138, 148, 11, 139, 139, 13, 139, 139, 63, 139, 139, 11, 139, 102, 13, 139, 130, 63, 139, 1, 12, 140, 140, 67, 140, 140, 12, 140, 115, 67, 140, 64, 12, 141, 141, 67, 141, 141, 12, 141, 102, 67, 141, 130, 12, 142, 142, 67, 142, 142, 12, 142, 56, 67, 142, 120, 12, 143, 143, 36, 143, 143, 23, 143, 143, 23, 143, 143, 63, 143, 143, 101, 143, 143, 12, 143, 116, 36, 143, 36, 23, 143, 44, 23, 143, 118, 63, 143, 51, 101, 143, 89, 50, 144, 144, 36, 144, 144, 98, 144, 144, 50, 144, 119, 36, 144, 83, 98, 144, 134, 11, 145, 145, 67, 145, 145, 11, 145, 26, 67, 145, 31, 11, 146, 146, 67, 146, 146, 11, 146, 122, 67, 146, 80, 12, 147, 147, 36, 147, 147, 23, 147, 147, 23, 147, 147, 63, 147, 147, 101, 147, 147, 12, 147, 131, 36, 147, 136, 23, 147, 73, 23, 147, 63, 63, 147, 137, 101, 147, 28, 12, 148, 148, 36, 148, 148, 23, 148, 148, 23, 148, 148, 63, 148, 148, 101, 148, 148, 12, 148, 122, 36, 148, 3, 23, 148, 138, 23, 148, 76, 63, 148, 21, 101, 148, 135, 11, 149, 149, 67, 149, 149, 11, 149, 99, 67, 149, 104, 50, 150, 150, 36, 150, 150, 98, 150, 150, 50, 150, 17, 36, 150, 91, 50, 151, 151, 36, 151, 151, 98, 151, 151, 50, 151, 75, 36, 151, 59, 11, 152, 152, 67, 152, 152, 11, 152, 86, 67, 152, 95, 11, 153, 153, 67, 153, 153, 11, 153, 116, 67, 153, 25, 11, 154, 154, 67, 154, 154, 11, 154, 131, 67, 154, 85, 42, 155, 155, 88, 155, 155, 49, 155, 155, 42, 155, 98, 88, 155, 69, 42, 156, 156, 88, 156, 156, 49, 156, 156, 42, 156, 5, 88, 156, 110, 49, 157, 157, 42, 157, 157, 88, 157, 157, 49, 157, 17, 42, 157, 81, 88, 157, 54, 49, 158, 158, 42, 158, 158, 88, 158, 158, 49, 158, 119, 42, 158, 94, 88, 158, 87, 49, 159, 159, 42, 159, 159, 88, 159, 159, 49, 159, 75, 42, 159, 133, 88, 159, 42, 42, 160, 160, 88, 160, 160, 49, 160, 160, 42, 160, 82, 88, 160, 58, 41, 161, 161, 75, 161, 161, 41, 161, 58, 41, 162, 162, 75, 162, 162, 41, 162, 60, 41, 163, 163, 75, 163, 163, 41, 163, 108, 75, 163, 176, 41, 164, 164, 75, 164, 164, 41, 164, 6, 75, 164, 171, 41, 165, 165, 75, 165, 165, 41, 165, 8, 41, 166, 166, 75, 166, 166, 41, 166, 113, 75, 166, 175, 41, 167, 167, 75, 167, 167, 41, 167, 87, 75, 167, 173, 41, 168, 168, 75, 168, 168, 41, 168, 10, 75, 168, 174, 41, 169, 169, 75, 169, 169, 41, 169, 69, 41, 170, 170, 75, 170, 170, 41, 170, 20, 75, 170, 172, 22, 171, 171, 91, 171, 171, 92, 171, 171, 22, 171, 164, 91, 171, 98, 92, 171, 81, 22, 172, 172, 91, 172, 172, 92, 172, 172, 22, 172, 170, 91, 172, 5, 92, 172, 5, 22, 173, 173, 91, 173, 173, 92, 173, 173, 22, 173, 167, 91, 173, 81, 92, 173, 98, 22, 174, 174, 91, 174, 174, 92, 174, 174, 22, 174, 168, 91, 174, 82, 92, 174, 133, 22, 175, 175, 91, 175, 175, 92, 175, 175, 22, 175, 166, 91, 175, 94, 92, 175, 94, 22, 176, 176, 91, 176, 176, 92, 176, 176, 22, 176, 163, 91, 176, 133, 92, 176, 82, 59, 177, 177, 7, 177, 177, 8, 177, 177, 59, 177, 16, 59, 178, 178, 7, 178, 178, 8, 178, 178, 59, 178, 22, 59, 179, 179, 7, 179, 179, 8, 179, 179, 59, 179, 33, 59, 180, 180, 7, 180, 180, 8, 180, 180, 59, 180, 40, 59, 181, 181, 7, 181, 181, 8, 181, 181, 59, 181, 47, 59, 182, 182, 7, 182, 182, 8, 182, 182, 59, 182, 65, 59, 183, 183, 7, 183, 183, 8, 183, 183, 59, 183, 71, 59, 184, 184, 7, 184, 184, 8, 184, 184, 59, 184, 88, 59, 185, 185, 7, 185, 185, 8, 185, 185, 59, 185, 97, 59, 186, 186, 7, 186, 186, 8, 186, 186, 59, 186, 103, 59, 187, 187, 7, 187, 187, 8, 187, 187, 59, 187, 107, 59, 188, 188, 7, 188, 188, 8, 188, 188, 59, 188, 114, 59, 189, 189, 7, 189, 189, 8, 189, 189, 59, 189, 123, 59, 190, 190, 7, 190, 190, 8, 190, 190, 59, 190, 126, 59, 191, 191, 7, 191, 191, 8, 191, 191, 59, 191, 132)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(89, 3, 208, 204, 93, 3, 194, 177, 14, 8, 201, 196, 35, 9, 139, 212, 76, 10, 199, 199, 35, 11, 146, 209, 14, 12, 206, 196, 76, 13, 204, 200, 10, 14, 200, 193, 14, 15, 201, 198, 66, 15, 174, 193, 64, 16, 205, 195, 65, 16, 199, 197, 35, 21, 146, 210, 14, 24, 205, 197, 66, 24, 142, 195, 89, 25, 208, 199, 93, 25, 194, 149, 65, 27, 204, 196, 89, 28, 207, 204, 10, 30, 200, 195, 89, 33, 207, 199, 35, 38, 146, 211, 94, 38, 213, 194, 76, 39, 204, 199, 89, 42, 203, 199, 94, 43, 214, 194, 76, 44, 200, 200, 10, 47, 199, 195, 35, 50, 139, 211, 94, 50, 215, 194, 14, 51, 201, 197, 66, 51, 174, 195, 14, 54, 206, 198, 66, 54, 143, 193, 94, 55, 216, 194, 64, 56, 206, 193, 65, 56, 204, 198, 64, 57, 201, 195, 89, 58, 203, 200, 93, 60, 194, 188, 35, 61, 146, 212, 76, 62, 199, 204, 10, 63, 204, 195, 66, 65, 151, 193, 76, 68, 199, 200, 76, 69, 204, 204, 10, 71, 199, 193, 64, 73, 206, 195, 65, 73, 204, 197, 89, 75, 208, 200, 93, 75, 194, 170, 76, 80, 200, 204, 89, 85, 207, 200, 65, 87, 199, 196, 14, 91, 202, 197, 66, 91, 138, 195, 93, 92, 194, 129, 76, 94, 200, 199, 10, 97, 204, 193, 65, 100, 200, 196, 89, 102, 203, 204, 14, 107, 202, 196, 35, 109, 139, 210, 14, 110, 205, 198, 66, 110, 142, 193, 94, 111, 217, 194, 64, 113, 205, 193, 65, 113, 199, 198, 35, 114, 139, 209, 64, 116, 201, 193, 64, 118, 202, 193, 65, 118, 200, 198, 66, 121, 151, 195, 14, 122, 206, 197, 66, 122, 143, 195, 64, 125, 202, 195, 65, 125, 200, 197, 14, 129, 202, 198, 66, 129, 138, 193, 14, 130, 205, 196, 98, 151, 146, 194, 98, 152, 139, 194, 49, 156, 190, 194, 49, 157, 159, 194, 49, 161, 183, 194, 75, 162, 218, 194, 75, 163, 219, 194, 75, 166, 220, 194, 75, 170, 221, 194, 7, 178, 86, 1, 8, 178, 87, 1, 7, 179, 88, 1, 8, 179, 89, 1, 7, 180, 90, 1, 8, 180, 91, 1, 7, 181, 92, 1, 8, 181, 93, 1, 7, 182, 94, 1, 8, 182, 95, 1, 7, 183, 96, 1, 8, 183, 97, 1, 7, 184, 98, 1, 8, 184, 99, 1, 7, 185, 100, 1, 8, 185, 101, 1, 7, 186, 102, 1, 8, 186, 103, 1, 7, 187, 104, 1, 8, 187, 105, 1, 7, 188, 106, 1, 8, 188, 107, 1, 7, 189, 108, 1, 8, 189, 109, 1, 7, 190, 110, 1, 8, 190, 111, 1, 7, 191, 112, 1, 8, 191, 113, 1, 7, 192, 114, 1, 8, 192, 115, 1)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 3: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=3
nb_c=216
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=291 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(47, 0, 0, 99, 0, 0, 64, 0, 0, 65, 0, 0, 47, 0, 148, 99, 0, 145, 51, 1, 1, 13, 1, 1, 51, 1, 90, 13, 1, 111, 47, 2, 2, 99, 2, 2, 64, 2, 2, 65, 2, 2, 47, 2, 53, 99, 2, 110, 46, 3, 3, 76, 3, 3, 46, 3, 20, 76, 3, 174, 46, 4, 4, 76, 4, 4, 46, 4, 118, 35, 5, 5, 94, 5, 5, 35, 5, 179, 94, 6, 6, 35, 6, 6, 94, 6, 191, 47, 7, 7, 99, 7, 7, 64, 7, 7, 65, 7, 7, 47, 7, 55, 99, 7, 138, 47, 8, 8, 99, 8, 8, 64, 8, 8, 65, 8, 8, 47, 8, 132, 99, 8, 139, 52, 9, 9, 10, 9, 9, 52, 9, 89, 10, 9, 174, 6, 10, 10, 100, 10, 10, 106, 10, 10, 6, 10, 196, 100, 10, 85, 106, 10, 27, 46, 11, 11, 76, 11, 11, 46, 11, 60, 6, 12, 12, 100, 12, 12, 106, 12, 12, 6, 12, 197, 100, 12, 126, 106, 12, 51, 40, 13, 13, 104, 13, 13, 105, 13, 13, 40, 13, 41, 104, 13, 123, 105, 13, 64, 14, 14, 14, 66, 14, 14, 53, 15, 15, 89, 15, 15, 93, 15, 15, 53, 15, 156, 14, 16, 16, 66, 16, 16, 40, 17, 17, 104, 17, 17, 105, 17, 17, 40, 17, 49, 104, 17, 100, 105, 17, 142, 53, 18, 18, 93, 18, 18, 89, 18, 18, 53, 18, 136, 93, 18, 59, 66, 19, 19, 14, 19, 19, 66, 19, 103, 47, 20, 20, 99, 20, 20, 65, 20, 20, 64, 20, 20, 47, 20, 94, 99, 20, 3, 65, 20, 171, 51, 21, 21, 13, 21, 21, 51, 21, 141, 13, 21, 108, 53, 22, 22, 93, 22, 22, 89, 22, 22, 53, 22, 42, 93, 22, 159, 53, 23, 23, 93, 23, 23, 89, 23, 23, 53, 23, 66, 93, 23, 44, 46, 24, 24, 76, 24, 24, 46, 24, 97, 51, 25, 25, 13, 25, 25, 51, 25, 44, 13, 25, 39, 52, 26, 26, 10, 26, 26, 52, 26, 169, 53, 27, 27, 89, 27, 27, 93, 27, 27, 53, 27, 10, 53, 28, 28, 89, 28, 28, 93, 28, 28, 53, 28, 94, 89, 28, 173, 47, 29, 29, 99, 29, 29, 64, 29, 29, 65, 29, 29, 47, 29, 106, 99, 29, 47, 52, 30, 30, 10, 30, 30, 52, 30, 87, 14, 31, 31, 66, 31, 31, 53, 32, 32, 89, 32, 32, 93, 32, 32, 53, 32, 148, 14, 33, 33, 66, 33, 33, 35, 34, 34, 94, 34, 34, 66, 35, 35, 14, 35, 35, 66, 35, 68, 46, 36, 36, 76, 36, 36, 46, 36, 126, 48, 37, 37, 90, 37, 37, 48, 37, 174, 90, 37, 130, 94, 38, 38, 35, 38, 38, 94, 38, 190, 14, 39, 39, 66, 39, 39, 14, 39, 175, 66, 39, 25, 51, 40, 40, 13, 40, 40, 51, 40, 87, 13, 40, 72, 53, 41, 41, 93, 41, 41, 89, 41, 41, 53, 41, 62, 93, 41, 13, 6, 42, 42, 100, 42, 42, 106, 42, 42, 6, 42, 198, 100, 42, 75, 106, 42, 22, 46, 43, 43, 76, 43, 43, 46, 43, 170, 76, 43, 174, 40, 44, 44, 104, 44, 44, 105, 44, 44, 40, 44, 23, 104, 44, 25, 105, 44, 146, 53, 45, 45, 93, 45, 45, 89, 45, 45, 53, 45, 73, 93, 45, 87, 14, 46, 46, 66, 46, 46, 46, 47, 47, 76, 47, 47, 46, 47, 29, 94, 48, 48, 35, 48, 48, 94, 48, 183, 53, 49, 49, 93, 49, 49, 89, 49, 49, 53, 49, 157, 93, 49, 17, 94, 50, 50, 35, 50, 50, 94, 50, 184, 53, 51, 51, 93, 51, 51, 89, 51, 51, 53, 51, 12, 93, 51, 141, 46, 52, 52, 76, 52, 52, 46, 52, 135, 6, 53, 53, 100, 53, 53, 106, 53, 53, 6, 53, 199, 100, 53, 2, 106, 53, 91, 47, 54, 54, 99, 54, 54, 64, 54, 54, 65, 54, 54, 47, 54, 157, 99, 54, 95, 6, 55, 55, 100, 55, 55, 106, 55, 55, 6, 55, 200, 100, 55, 7, 106, 55, 153, 14, 56, 56, 66, 56, 56, 53, 57, 57, 89, 57, 57, 93, 57, 57, 53, 57, 107, 14, 58, 58, 66, 58, 58, 40, 59, 59, 104, 59, 59, 105, 59, 59, 40, 59, 18, 104, 59, 103, 105, 59, 86, 47, 60, 60, 99, 60, 60, 64, 60, 60, 65, 60, 60, 47, 60, 107, 99, 60, 11, 94, 61, 61, 35, 61, 61, 94, 61, 186, 6, 62, 62, 100, 62, 62, 106, 62, 62, 6, 62, 201, 100, 62, 135, 106, 62, 41, 53, 63, 63, 89, 63, 63, 93, 63, 63, 53, 63, 106, 52, 64, 64, 10, 64, 64, 52, 64, 13, 38, 65, 65, 39, 65, 65, 95, 65, 65, 38, 65, 193, 39, 65, 194, 95, 65, 181, 6, 66, 66, 100, 66, 66, 106, 66, 66, 6, 66, 202, 100, 66, 112, 106, 66, 23, 38, 67, 67, 39, 67, 67, 95, 67, 67, 38, 67, 195, 39, 67, 192, 95, 67, 179, 51, 68, 68, 13, 68, 68, 51, 68, 159, 13, 68, 35, 35, 69, 69, 94, 69, 69, 52, 70, 70, 10, 70, 70, 52, 70, 159, 14, 71, 71, 66, 71, 71, 66, 72, 72, 14, 72, 72, 66, 72, 40, 6, 73, 73, 100, 73, 73, 106, 73, 73, 6, 73, 203, 100, 73, 144, 106, 73, 45, 14, 74, 74, 66, 74, 74, 47, 75, 75, 99, 75, 75, 64, 75, 75, 65, 75, 75, 47, 75, 42, 99, 75, 80, 14, 76, 76, 66, 76, 76, 14, 77, 77, 66, 77, 77, 35, 78, 78, 94, 78, 78, 35, 79, 79, 94, 79, 79, 35, 79, 180, 94, 79, 187, 46, 80, 80, 76, 80, 80, 46, 80, 75, 51, 81, 81, 13, 81, 81, 51, 81, 89, 13, 81, 105, 94, 82, 82, 35, 82, 82, 94, 82, 182, 35, 83, 83, 94, 83, 83, 53, 84, 84, 93, 84, 84, 89, 84, 84, 53, 84, 133, 93, 84, 90, 47, 85, 85, 99, 85, 85, 64, 85, 85, 65, 85, 85, 47, 85, 10, 99, 85, 116, 52, 86, 86, 10, 86, 86, 52, 86, 59, 40, 87, 87, 104, 87, 87, 105, 87, 87, 40, 87, 45, 104, 87, 40, 105, 87, 30, 14, 88, 88, 66, 88, 88, 40, 89, 89, 104, 89, 89, 105, 89, 89, 40, 89, 122, 104, 89, 81, 105, 89, 9, 40, 90, 90, 104, 90, 90, 105, 90, 90, 40, 90, 84, 104, 90, 1, 105, 90, 96, 53, 91, 91, 89, 91, 91, 93, 91, 91, 53, 91, 53, 46, 92, 92, 76, 92, 92, 46, 92, 112, 14, 93, 93, 66, 93, 93, 6, 94, 94, 100, 94, 94, 106, 94, 94, 6, 94, 204, 100, 94, 20, 106, 94, 28, 46, 95, 95, 76, 95, 95, 46, 95, 54, 52, 96, 96, 10, 96, 96, 52, 96, 90, 47, 97, 97, 99, 97, 97, 64, 97, 97, 65, 97, 97, 47, 97, 156, 99, 97, 24, 14, 98, 98, 66, 98, 98, 14, 98, 171, 52, 99, 99, 10, 99, 99, 52, 99, 141, 51, 100, 100, 13, 100, 100, 51, 100, 17, 13, 100, 115, 38, 101, 101, 39, 101, 101, 95, 101, 101, 38, 101, 192, 39, 101, 195, 95, 101, 178, 46, 102, 102, 76, 102, 102, 46, 102, 144, 51, 103, 103, 13, 103, 103, 51, 103, 59, 13, 103, 19, 35, 104, 104, 94, 104, 104, 14, 105, 105, 66, 105, 105, 14, 105, 172, 66, 105, 81, 6, 106, 106, 100, 106, 106, 106, 106, 106, 6, 106, 205, 100, 106, 29, 106, 106, 63, 6, 107, 107, 100, 107, 107, 106, 107, 107, 6, 107, 206, 100, 107, 60, 106, 107, 57, 66, 108, 108, 14, 108, 108, 66, 108, 21, 35, 109, 109, 94, 109, 109, 35, 109, 181, 46, 110, 110, 76, 110, 110, 46, 110, 2, 14, 111, 111, 66, 111, 111, 14, 111, 177, 66, 111, 1, 47, 112, 112, 99, 112, 112, 64, 112, 112, 65, 112, 112, 47, 112, 66, 99, 112, 92, 64, 112, 175, 35, 113, 113, 94, 113, 113, 47, 114, 114, 99, 114, 114, 64, 114, 114, 65, 114, 114, 47, 114, 136, 99, 114, 150, 66, 115, 115, 14, 115, 115, 66, 115, 100, 46, 116, 116, 76, 116, 116, 46, 116, 85, 14, 117, 117, 66, 117, 117, 47, 118, 118, 99, 118, 118, 64, 118, 118, 65, 118, 118, 47, 118, 131, 99, 118, 4, 53, 119, 119, 89, 119, 119, 93, 119, 119, 53, 119, 131, 66, 120, 120, 14, 120, 120, 66, 120, 123, 35, 121, 121, 94, 121, 121, 35, 121, 178, 53, 122, 122, 89, 122, 122, 93, 122, 122, 53, 122, 151, 89, 122, 174, 93, 122, 89, 51, 123, 123, 13, 123, 123, 51, 123, 13, 13, 123, 120, 94, 124, 124, 35, 124, 124, 94, 124, 185, 47, 125, 125, 99, 125, 125, 64, 125, 125, 65, 125, 125, 47, 125, 133, 99, 125, 168, 64, 125, 177, 47, 126, 126, 99, 126, 126, 64, 126, 126, 65, 126, 126, 47, 126, 12, 99, 126, 36, 14, 127, 127, 66, 127, 127, 35, 128, 128, 94, 128, 128, 14, 129, 129, 66, 129, 129, 37, 130, 130, 102, 130, 130, 103, 130, 130, 37, 130, 37, 102, 130, 181, 103, 130, 173, 6, 131, 131, 100, 131, 131, 106, 131, 131, 6, 131, 207, 100, 131, 118, 106, 131, 119, 6, 132, 132, 100, 132, 132, 106, 132, 132, 6, 132, 208, 100, 132, 8, 106, 132, 158, 6, 133, 133, 100, 133, 133, 106, 133, 133, 6, 133, 209, 100, 133, 125, 106, 133, 84, 14, 134, 134, 66, 134, 134, 47, 135, 135, 99, 135, 135, 64, 135, 135, 65, 135, 135, 47, 135, 62, 99, 135, 52, 6, 136, 136, 100, 136, 136, 106, 136, 136, 6, 136, 210, 100, 136, 114, 106, 136, 18, 53, 137, 137, 93, 137, 137, 89, 137, 137, 53, 137, 164, 93, 137, 169, 46, 138, 138, 76, 138, 138, 46, 138, 7, 46, 139, 139, 76, 139, 139, 46, 139, 8, 47, 140, 140, 99, 140, 140, 64, 140, 140, 65, 140, 140, 47, 140, 164, 99, 140, 143, 64, 140, 176, 40, 141, 141, 104, 141, 141, 105, 141, 141, 40, 141, 51, 104, 141, 21, 105, 141, 99, 52, 142, 142, 10, 142, 142, 52, 142, 17, 46, 143, 143, 76, 143, 143, 46, 143, 140, 47, 144, 144, 99, 144, 144, 64, 144, 144, 65, 144, 144, 47, 144, 73, 99, 144, 102, 46, 145, 145, 76, 145, 145, 46, 145, 0, 52, 146, 146, 10, 146, 146, 52, 146, 44, 14, 147, 147, 66, 147, 147, 6, 148, 148, 100, 148, 148, 106, 148, 148, 6, 148, 211, 100, 148, 0, 106, 148, 32, 14, 149, 149, 66, 149, 149, 14, 149, 176, 66, 149, 165, 46, 150, 150, 76, 150, 150, 46, 150, 114, 6, 151, 151, 100, 151, 151, 106, 151, 151, 6, 151, 212, 100, 151, 170, 106, 151, 122, 94, 152, 152, 35, 152, 152, 94, 152, 188, 53, 153, 153, 89, 153, 153, 93, 153, 153, 53, 153, 55, 14, 154, 154, 66, 154, 154, 14, 155, 155, 66, 155, 155, 6, 156, 156, 100, 156, 156, 106, 156, 156, 6, 156, 213, 100, 156, 97, 106, 156, 15, 6, 157, 157, 100, 157, 157, 106, 157, 157, 6, 157, 214, 100, 157, 54, 106, 157, 49, 53, 158, 158, 89, 158, 158, 93, 158, 158, 53, 158, 132, 40, 159, 159, 104, 159, 159, 105, 159, 159, 40, 159, 22, 104, 159, 68, 105, 159, 70, 14, 160, 160, 66, 160, 160, 38, 161, 161, 39, 161, 161, 95, 161, 161, 38, 161, 194, 39, 161, 193, 95, 161, 180, 14, 162, 162, 66, 162, 162, 94, 163, 163, 35, 163, 163, 94, 163, 189, 6, 164, 164, 100, 164, 164, 106, 164, 164, 6, 164, 215, 100, 164, 140, 106, 164, 137, 51, 165, 165, 13, 165, 165, 51, 165, 169, 13, 165, 149, 14, 166, 166, 66, 166, 166, 14, 167, 167, 66, 167, 167, 46, 168, 168, 76, 168, 168, 46, 168, 125, 40, 169, 169, 104, 169, 169, 105, 169, 169, 40, 169, 137, 104, 169, 165, 105, 169, 26, 47, 170, 170, 99, 170, 170, 64, 170, 170, 65, 170, 170, 47, 170, 151, 99, 170, 43, 64, 170, 172, 65, 170, 174, 12, 171, 171, 67, 171, 171, 12, 171, 20, 67, 171, 98, 11, 172, 172, 67, 172, 172, 11, 172, 170, 67, 172, 105, 50, 173, 173, 36, 173, 173, 98, 173, 173, 50, 173, 130, 36, 173, 28, 12, 174, 174, 36, 174, 174, 23, 174, 174, 23, 174, 174, 63, 174, 174, 101, 174, 174, 12, 174, 170, 36, 174, 122, 23, 174, 3, 23, 174, 43, 63, 174, 9, 101, 174, 37, 11, 175, 175, 67, 175, 175, 11, 175, 112, 67, 175, 39, 11, 176, 176, 67, 176, 176, 11, 176, 140, 67, 176, 149, 11, 177, 177, 67, 177, 177, 11, 177, 125, 67, 177, 111, 42, 178, 178, 88, 178, 178, 49, 178, 178, 42, 178, 101, 88, 178, 121, 42, 179, 179, 88, 179, 179, 49, 179, 179, 42, 179, 67, 88, 179, 5, 42, 180, 180, 88, 180, 180, 49, 180, 180, 42, 180, 161, 88, 180, 79, 49, 181, 181, 42, 181, 181, 88, 181, 181, 49, 181, 130, 42, 181, 65, 88, 181, 109, 41, 182, 182, 75, 182, 182, 41, 182, 82, 41, 183, 183, 75, 183, 183, 41, 183, 48, 75, 183, 194, 41, 184, 184, 75, 184, 184, 41, 184, 50, 75, 184, 192, 41, 185, 185, 75, 185, 185, 41, 185, 124, 41, 186, 186, 75, 186, 186, 41, 186, 61, 75, 186, 193, 41, 187, 187, 75, 187, 187, 41, 187, 79, 41, 188, 188, 75, 188, 188, 41, 188, 152, 41, 189, 189, 75, 189, 189, 41, 189, 163, 41, 190, 190, 75, 190, 190, 41, 190, 38, 75, 190, 195, 41, 191, 191, 75, 191, 191, 41, 191, 6, 22, 192, 192, 91, 192, 192, 92, 192, 192, 22, 192, 184, 91, 192, 101, 92, 192, 67, 22, 193, 193, 91, 193, 193, 92, 193, 193, 22, 193, 186, 91, 193, 65, 92, 193, 161, 22, 194, 194, 91, 194, 194, 92, 194, 194, 22, 194, 183, 91, 194, 161, 92, 194, 65, 22, 195, 195, 91, 195, 195, 92, 195, 195, 22, 195, 190, 91, 195, 67, 92, 195, 101, 59, 196, 196, 7, 196, 196, 8, 196, 196, 59, 196, 10, 59, 197, 197, 7, 197, 197, 8, 197, 197, 59, 197, 12, 59, 198, 198, 7, 198, 198, 8, 198, 198, 59, 198, 42, 59, 199, 199, 7, 199, 199, 8, 199, 199, 59, 199, 53, 59, 200, 200, 7, 200, 200, 8, 200, 200, 59, 200, 55, 59, 201, 201, 7, 201, 201, 8, 201, 201, 59, 201, 62, 59, 202, 202, 7, 202, 202, 8, 202, 202, 59, 202, 66, 59, 203, 203, 7, 203, 203, 8, 203, 203, 59, 203, 73, 59, 204, 204, 7, 204, 204, 8, 204, 204, 59, 204, 94, 59, 205, 205, 7, 205, 205, 8, 205, 205, 59, 205, 106, 59, 206, 206, 7, 206, 206, 8, 206, 206, 59, 206, 107, 59, 207, 207, 7, 207, 207, 8, 207, 207, 59, 207, 131, 59, 208, 208, 7, 208, 208, 8, 208, 208, 59, 208, 132, 59, 209, 209, 7, 209, 209, 8, 209, 209, 59, 209, 133, 59, 210, 210, 7, 210, 210, 8, 210, 210, 59, 210, 136, 59, 211, 211, 7, 211, 211, 8, 211, 211, 59, 211, 148, 59, 212, 212, 7, 212, 212, 8, 212, 212, 59, 212, 151, 59, 213, 213, 7, 213, 213, 8, 213, 213, 59, 213, 156, 59, 214, 214, 7, 214, 214, 8, 214, 214, 59, 214, 157, 59, 215, 215, 7, 215, 215, 8, 215, 215, 59, 215, 164)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(64, 1, 382, 195, 65, 1, 375, 197, 64, 3, 373, 195, 65, 3, 204, 370, 76, 5, 371, 200, 94, 6, 389, 194, 35, 7, 139, 383, 64, 8, 374, 195, 65, 8, 376, 197, 64, 9, 205, 367, 65, 9, 199, 369, 76, 12, 375, 204, 14, 15, 381, 198, 66, 15, 267, 193, 89, 16, 379, 199, 93, 16, 194, 228, 14, 17, 374, 197, 66, 17, 262, 195, 89, 19, 372, 200, 14, 20, 377, 196, 64, 21, 201, 367, 89, 23, 372, 199, 89, 24, 207, 375, 76, 25, 371, 199, 10, 27, 371, 193, 89, 28, 378, 200, 93, 28, 194, 258, 93, 29, 194, 355, 64, 30, 381, 195, 65, 30, 371, 197, 10, 31, 376, 195, 14, 32, 377, 197, 66, 32, 339, 195, 89, 33, 208, 375, 93, 33, 194, 333, 14, 34, 374, 198, 66, 34, 262, 193, 35, 35, 146, 384, 94, 35, 390, 194, 14, 36, 380, 196, 76, 37, 376, 204, 35, 39, 146, 386, 89, 42, 203, 371, 89, 46, 203, 376, 14, 47, 201, 369, 66, 47, 174, 367, 76, 48, 200, 371, 35, 49, 362, 209, 89, 50, 203, 375, 35, 51, 362, 210, 89, 52, 372, 204, 76, 53, 204, 371, 64, 55, 382, 193, 65, 55, 375, 198, 14, 57, 377, 198, 66, 57, 339, 193, 89, 58, 378, 204, 93, 58, 194, 246, 14, 59, 373, 198, 66, 59, 273, 193, 64, 61, 206, 367, 65, 61, 204, 369, 35, 62, 139, 386, 89, 64, 208, 371, 93, 64, 194, 280, 10, 65, 371, 195, 35, 70, 139, 387, 94, 70, 391, 194, 10, 71, 199, 367, 14, 72, 205, 368, 66, 72, 276, 193, 14, 73, 374, 196, 14, 75, 206, 370, 66, 75, 247, 195, 64, 76, 380, 193, 65, 76, 199, 368, 14, 77, 202, 368, 66, 77, 263, 193, 14, 78, 205, 369, 66, 78, 142, 367, 35, 79, 362, 211, 94, 79, 392, 194, 76, 81, 376, 199, 35, 83, 362, 212, 35, 84, 139, 384, 94, 84, 393, 194, 89, 85, 207, 376, 64, 86, 202, 367, 65, 86, 200, 369, 10, 87, 200, 367, 14, 89, 202, 369, 66, 89, 138, 367, 89, 92, 379, 204, 93, 92, 194, 328, 76, 93, 199, 375, 14, 94, 382, 197, 66, 94, 306, 195, 76, 96, 204, 375, 10, 97, 376, 193, 64, 98, 380, 195, 65, 98, 199, 370, 66, 99, 151, 367, 10, 100, 204, 367, 76, 103, 204, 376, 35, 105, 139, 385, 94, 105, 394, 194, 14, 109, 373, 196, 94, 110, 395, 194, 76, 111, 371, 204, 65, 113, 375, 196, 35, 114, 146, 385, 94, 114, 396, 194, 64, 115, 377, 193, 65, 115, 200, 368, 14, 116, 382, 196, 76, 117, 375, 200, 14, 118, 202, 370, 66, 118, 263, 195, 64, 119, 377, 195, 65, 119, 200, 370, 89, 120, 379, 200, 93, 120, 194, 353, 14, 121, 381, 196, 94, 122, 397, 194, 35, 125, 146, 383, 65, 126, 376, 196, 64, 127, 373, 193, 65, 127, 204, 368, 14, 128, 382, 198, 66, 128, 306, 193, 35, 129, 146, 387, 94, 129, 398, 194, 14, 130, 201, 368, 66, 130, 294, 193, 14, 135, 380, 197, 66, 135, 305, 195, 64, 136, 381, 193, 65, 136, 371, 198, 89, 138, 207, 371, 76, 139, 200, 376, 76, 140, 375, 199, 65, 141, 371, 196, 10, 143, 375, 195, 76, 144, 199, 371, 64, 145, 374, 193, 65, 145, 376, 198, 76, 146, 200, 375, 10, 147, 375, 193, 14, 148, 380, 198, 66, 148, 305, 193, 76, 151, 376, 200, 35, 153, 146, 388, 89, 154, 208, 376, 93, 154, 194, 232, 14, 155, 373, 197, 66, 155, 273, 195, 14, 156, 201, 370, 66, 156, 294, 195, 89, 159, 378, 199, 93, 159, 194, 320, 14, 161, 381, 197, 66, 161, 267, 195, 14, 163, 206, 369, 66, 163, 143, 367, 35, 164, 139, 388, 14, 167, 205, 370, 66, 167, 276, 195, 14, 168, 206, 368, 66, 168, 247, 193, 76, 169, 199, 376, 98, 174, 362, 194, 49, 179, 303, 194, 49, 180, 245, 194, 49, 181, 347, 194, 75, 183, 399, 194, 75, 186, 400, 194, 75, 188, 401, 194, 75, 189, 402, 194, 75, 190, 403, 194, 75, 192, 404, 194, 7, 197, 46, 1, 8, 197, 47, 1, 7, 198, 48, 1, 8, 198, 49, 1, 7, 199, 50, 1, 8, 199, 51, 1, 7, 200, 52, 1, 8, 200, 53, 1, 7, 201, 54, 1, 8, 201, 55, 1, 7, 202, 56, 1, 8, 202, 57, 1, 7, 203, 58, 1, 8, 203, 59, 1, 7, 204, 60, 1, 8, 204, 61, 1, 7, 205, 62, 1, 8, 205, 63, 1, 7, 206, 64, 1, 8, 206, 65, 1, 7, 207, 66, 1, 8, 207, 67, 1, 7, 208, 68, 1, 8, 208, 69, 1, 7, 209, 70, 1, 8, 209, 71, 1, 7, 210, 72, 1, 8, 210, 73, 1, 7, 211, 74, 1, 8, 211, 75, 1, 7, 212, 76, 1, 8, 212, 77, 1, 7, 213, 78, 1, 8, 213, 79, 1, 7, 214, 80, 1, 8, 214, 81, 1, 7, 215, 82, 1, 8, 215, 83, 1, 7, 216, 84, 1, 8, 216, 85, 1)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 4: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=4
nb_c=149
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=507 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(14, 0, 0, 66, 0, 0, 46, 1, 1, 76, 1, 1, 46, 1, 28, 53, 2, 2, 89, 2, 2, 93, 2, 2, 53, 2, 67, 14, 3, 3, 66, 3, 3, 46, 4, 4, 76, 4, 4, 46, 4, 113, 94, 5, 5, 35, 5, 5, 94, 5, 128, 46, 6, 6, 76, 6, 6, 46, 6, 59, 46, 7, 7, 76, 7, 7, 46, 7, 38, 46, 8, 8, 76, 8, 8, 46, 8, 47, 40, 9, 9, 104, 9, 9, 105, 9, 9, 40, 9, 45, 104, 9, 111, 105, 9, 50, 14, 10, 10, 66, 10, 10, 6, 11, 11, 100, 11, 11, 106, 11, 11, 6, 11, 134, 100, 11, 105, 106, 11, 95, 53, 12, 12, 89, 12, 12, 93, 12, 12, 53, 12, 92, 35, 13, 13, 94, 13, 13, 14, 14, 14, 66, 14, 14, 14, 15, 15, 66, 15, 15, 6, 16, 16, 100, 16, 16, 106, 16, 16, 6, 16, 135, 100, 16, 113, 106, 16, 75, 46, 17, 17, 76, 17, 17, 46, 17, 105, 53, 18, 18, 93, 18, 18, 89, 18, 18, 53, 18, 48, 93, 18, 26, 47, 19, 19, 99, 19, 19, 64, 19, 19, 65, 19, 19, 47, 19, 42, 99, 19, 103, 14, 20, 20, 66, 20, 20, 14, 21, 21, 66, 21, 21, 14, 22, 22, 66, 22, 22, 40, 23, 23, 104, 23, 23, 105, 23, 23, 40, 23, 64, 104, 23, 70, 105, 23, 112, 35, 24, 24, 94, 24, 24, 46, 25, 25, 76, 25, 25, 46, 25, 66, 40, 26, 26, 104, 26, 26, 105, 26, 26, 40, 26, 18, 104, 26, 98, 105, 26, 62, 66, 27, 27, 14, 27, 27, 66, 27, 98, 47, 28, 28, 99, 28, 28, 64, 28, 28, 65, 28, 28, 47, 28, 73, 99, 28, 1, 14, 29, 29, 66, 29, 29, 94, 30, 30, 35, 30, 30, 94, 30, 132, 14, 31, 31, 66, 31, 31, 40, 32, 32, 104, 32, 32, 105, 32, 32, 40, 32, 75, 104, 32, 80, 105, 32, 110, 35, 33, 33, 94, 33, 33, 14, 34, 34, 66, 34, 34, 47, 35, 35, 99, 35, 35, 64, 35, 35, 65, 35, 35, 47, 35, 124, 99, 35, 89, 94, 36, 36, 35, 36, 36, 94, 36, 129, 46, 37, 37, 76, 37, 37, 46, 37, 76, 47, 38, 38, 99, 38, 38, 64, 38, 38, 65, 38, 38, 47, 38, 68, 99, 38, 7, 46, 39, 39, 76, 39, 39, 46, 39, 44, 53, 40, 40, 89, 40, 40, 93, 40, 40, 53, 40, 58, 6, 41, 41, 100, 41, 41, 106, 41, 41, 6, 41, 136, 100, 41, 86, 106, 41, 123, 6, 42, 42, 100, 42, 42, 106, 42, 42, 6, 42, 137, 100, 42, 19, 106, 42, 82, 14, 43, 43, 66, 43, 43, 47, 44, 44, 99, 44, 44, 64, 44, 44, 65, 44, 44, 47, 44, 92, 99, 44, 39, 53, 45, 45, 93, 45, 45, 89, 45, 45, 53, 45, 79, 93, 45, 9, 35, 46, 46, 94, 46, 46, 47, 47, 47, 99, 47, 47, 64, 47, 47, 65, 47, 47, 47, 47, 67, 99, 47, 8, 6, 48, 48, 100, 48, 48, 106, 48, 48, 6, 48, 138, 100, 48, 76, 106, 48, 18, 14, 49, 49, 66, 49, 49, 52, 50, 50, 10, 50, 50, 52, 50, 9, 40, 51, 51, 104, 51, 51, 105, 51, 51, 40, 51, 121, 104, 51, 99, 105, 51, 101, 94, 52, 52, 35, 52, 52, 94, 52, 131, 14, 53, 53, 66, 53, 53, 47, 54, 54, 99, 54, 54, 64, 54, 54, 65, 54, 54, 47, 54, 79, 99, 54, 81, 14, 55, 55, 66, 55, 55, 14, 56, 56, 66, 56, 56, 38, 57, 57, 39, 57, 57, 95, 57, 57, 38, 57, 133, 39, 57, 133, 95, 57, 127, 6, 58, 58, 100, 58, 58, 106, 58, 58, 6, 58, 139, 100, 58, 59, 106, 58, 40, 47, 59, 59, 99, 59, 59, 64, 59, 59, 65, 59, 59, 47, 59, 58, 99, 59, 6, 46, 60, 60, 76, 60, 60, 46, 60, 61, 47, 61, 61, 99, 61, 61, 64, 61, 61, 65, 61, 61, 47, 61, 85, 99, 61, 60, 52, 62, 62, 10, 62, 62, 52, 62, 26, 35, 63, 63, 94, 63, 63, 53, 64, 64, 93, 64, 64, 89, 64, 64, 53, 64, 73, 93, 64, 23, 53, 65, 65, 89, 65, 65, 93, 65, 65, 53, 65, 109, 47, 66, 66, 99, 66, 66, 64, 66, 66, 65, 66, 66, 47, 66, 109, 99, 66, 25, 6, 67, 67, 100, 67, 67, 106, 67, 67, 6, 67, 140, 100, 67, 47, 106, 67, 2, 6, 68, 68, 100, 68, 68, 106, 68, 68, 6, 68, 141, 100, 68, 38, 106, 68, 83, 35, 69, 69, 94, 69, 69, 35, 69, 127, 51, 70, 70, 13, 70, 70, 51, 70, 23, 13, 70, 93, 66, 71, 71, 14, 71, 71, 66, 71, 111, 14, 72, 72, 66, 72, 72, 6, 73, 73, 100, 73, 73, 106, 73, 73, 6, 73, 142, 100, 73, 28, 106, 73, 64, 35, 74, 74, 94, 74, 74, 53, 75, 75, 93, 75, 75, 89, 75, 75, 53, 75, 16, 93, 75, 32, 47, 76, 76, 99, 76, 76, 64, 76, 76, 65, 76, 76, 47, 76, 48, 99, 76, 37, 14, 77, 77, 66, 77, 77, 35, 78, 78, 94, 78, 78, 6, 79, 79, 100, 79, 79, 106, 79, 79, 6, 79, 143, 100, 79, 54, 106, 79, 45, 51, 80, 80, 13, 80, 80, 51, 80, 32, 13, 80, 97, 46, 81, 81, 76, 81, 81, 46, 81, 54, 53, 82, 82, 89, 82, 82, 93, 82, 82, 53, 82, 42, 53, 83, 83, 89, 83, 83, 93, 83, 83, 53, 83, 68, 14, 84, 84, 66, 84, 84, 6, 85, 85, 100, 85, 85, 106, 85, 85, 6, 85, 144, 100, 85, 61, 106, 85, 104, 47, 86, 86, 99, 86, 86, 64, 86, 86, 65, 86, 86, 47, 86, 41, 99, 86, 120, 14, 87, 87, 66, 87, 87, 6, 88, 88, 100, 88, 88, 106, 88, 88, 6, 88, 145, 100, 88, 94, 106, 88, 96, 46, 89, 89, 76, 89, 89, 46, 89, 35, 46, 90, 90, 76, 90, 90, 46, 90, 94, 14, 91, 91, 66, 91, 91, 6, 92, 92, 100, 92, 92, 106, 92, 92, 6, 92, 146, 100, 92, 44, 106, 92, 12, 66, 93, 93, 14, 93, 93, 66, 93, 70, 47, 94, 94, 99, 94, 94, 64, 94, 94, 65, 94, 94, 47, 94, 88, 99, 94, 90, 53, 95, 95, 89, 95, 95, 93, 95, 95, 53, 95, 11, 53, 96, 96, 89, 96, 96, 93, 96, 96, 53, 96, 88, 14, 97, 97, 66, 97, 97, 14, 97, 126, 66, 97, 80, 51, 98, 98, 13, 98, 98, 51, 98, 26, 13, 98, 27, 51, 99, 99, 13, 99, 99, 51, 99, 51, 13, 99, 102, 14, 100, 100, 66, 100, 100, 52, 101, 101, 10, 101, 101, 52, 101, 51, 66, 102, 102, 14, 102, 102, 66, 102, 99, 46, 103, 103, 76, 103, 103, 46, 103, 19, 53, 104, 104, 89, 104, 104, 93, 104, 104, 53, 104, 85, 47, 105, 105, 99, 105, 105, 64, 105, 105, 65, 105, 105, 47, 105, 11, 99, 105, 17, 14, 106, 106, 66, 106, 106, 14, 107, 107, 66, 107, 107, 14, 108, 108, 66, 108, 108, 6, 109, 109, 100, 109, 109, 106, 109, 109, 6, 109, 147, 100, 109, 66, 106, 109, 65, 52, 110, 110, 10, 110, 110, 52, 110, 32, 51, 111, 111, 13, 111, 111, 51, 111, 9, 13, 111, 71, 52, 112, 112, 10, 112, 112, 52, 112, 23, 47, 113, 113, 99, 113, 113, 64, 113, 113, 65, 113, 113, 47, 113, 16, 99, 113, 4, 64, 113, 126, 14, 114, 114, 66, 114, 114, 14, 115, 115, 66, 115, 115, 94, 116, 116, 35, 116, 116, 94, 116, 130, 35, 117, 117, 94, 117, 117, 14, 118, 118, 66, 118, 118, 35, 119, 119, 94, 119, 119, 46, 120, 120, 76, 120, 120, 46, 120, 86, 53, 121, 121, 93, 121, 121, 89, 121, 121, 53, 121, 124, 93, 121, 51, 14, 122, 122, 66, 122, 122, 53, 123, 123, 89, 123, 123, 93, 123, 123, 53, 123, 41, 6, 124, 124, 100, 124, 124, 106, 124, 124, 6, 124, 148, 100, 124, 35, 106, 124, 121, 14, 125, 125, 66, 125, 125, 11, 126, 126, 67, 126, 126, 11, 126, 113, 67, 126, 97, 42, 127, 127, 88, 127, 127, 49, 127, 127, 42, 127, 57, 88, 127, 69, 41, 128, 128, 75, 128, 128, 41, 128, 5, 41, 129, 129, 75, 129, 129, 41, 129, 36, 41, 130, 130, 75, 130, 130, 41, 130, 116, 41, 131, 131, 75, 131, 131, 41, 131, 52, 41, 132, 132, 75, 132, 132, 41, 132, 30, 75, 132, 133, 22, 133, 133, 91, 133, 133, 92, 133, 133, 22, 133, 132, 91, 133, 57, 92, 133, 57, 59, 134, 134, 7, 134, 134, 8, 134, 134, 59, 134, 11, 59, 135, 135, 7, 135, 135, 8, 135, 135, 59, 135, 16, 59, 136, 136, 7, 136, 136, 8, 136, 136, 59, 136, 41, 59, 137, 137, 7, 137, 137, 8, 137, 137, 59, 137, 42, 59, 138, 138, 7, 138, 138, 8, 138, 138, 59, 138, 48, 59, 139, 139, 7, 139, 139, 8, 139, 139, 59, 139, 58, 59, 140, 140, 7, 140, 140, 8, 140, 140, 59, 140, 67, 59, 141, 141, 7, 141, 141, 8, 141, 141, 59, 141, 68, 59, 142, 142, 7, 142, 142, 8, 142, 142, 59, 142, 73, 59, 143, 143, 7, 143, 143, 8, 143, 143, 59, 143, 79, 59, 144, 144, 7, 144, 144, 8, 144, 144, 59, 144, 85, 59, 145, 145, 7, 145, 145, 8, 145, 145, 59, 145, 88, 59, 146, 146, 7, 146, 146, 8, 146, 146, 59, 146, 92, 59, 147, 147, 7, 147, 147, 8, 147, 147, 59, 147, 109, 59, 148, 148, 7, 148, 148, 8, 148, 148, 59, 148, 124)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(14, 1, 381, 368, 66, 1, 543, 193, 76, 2, 376, 371, 89, 3, 593, 199, 93, 3, 194, 579, 14, 4, 374, 369, 66, 4, 262, 367, 76, 5, 199, 594, 35, 6, 362, 383, 76, 7, 371, 371, 76, 8, 594, 200, 76, 9, 594, 199, 14, 11, 201, 591, 66, 11, 294, 367, 89, 13, 378, 371, 93, 13, 194, 433, 35, 14, 362, 384, 94, 14, 602, 194, 14, 15, 202, 591, 66, 15, 263, 367, 14, 16, 381, 369, 66, 16, 267, 367, 76, 18, 200, 594, 89, 19, 203, 594, 64, 20, 373, 367, 65, 20, 204, 591, 14, 21, 380, 369, 66, 21, 305, 367, 14, 22, 373, 368, 66, 22, 441, 193, 14, 23, 373, 369, 66, 23, 273, 367, 35, 25, 362, 385, 94, 25, 603, 194, 76, 26, 371, 375, 14, 28, 592, 196, 64, 29, 596, 193, 65, 29, 371, 368, 14, 30, 592, 198, 66, 30, 501, 193, 35, 31, 362, 386, 14, 32, 597, 197, 66, 32, 421, 195, 35, 34, 362, 387, 94, 34, 604, 194, 14, 35, 374, 368, 66, 35, 460, 193, 64, 36, 597, 193, 65, 36, 376, 368, 35, 37, 139, 600, 76, 38, 204, 594, 64, 39, 377, 367, 65, 39, 200, 591, 76, 40, 375, 371, 89, 41, 379, 371, 93, 41, 194, 589, 14, 44, 205, 591, 66, 44, 276, 367, 64, 45, 381, 367, 65, 45, 371, 369, 89, 46, 372, 375, 35, 47, 146, 598, 94, 47, 605, 194, 64, 48, 380, 367, 65, 48, 199, 591, 14, 50, 382, 370, 66, 50, 520, 195, 10, 51, 375, 367, 35, 53, 146, 600, 14, 54, 596, 198, 66, 54, 585, 193, 64, 55, 595, 193, 65, 55, 375, 368, 14, 56, 206, 591, 66, 56, 247, 367, 14, 57, 380, 370, 66, 57, 488, 195, 64, 60, 596, 195, 65, 60, 371, 370, 76, 61, 375, 375, 64, 62, 382, 367, 65, 62, 375, 369, 10, 63, 594, 195, 35, 64, 139, 601, 94, 64, 606, 194, 89, 65, 372, 371, 89, 66, 379, 375, 93, 66, 194, 464, 64, 67, 595, 195, 65, 67, 375, 370, 94, 70, 607, 194, 14, 72, 595, 196, 14, 73, 373, 370, 66, 73, 441, 195, 35, 75, 146, 599, 94, 75, 608, 194, 89, 76, 207, 594, 64, 77, 592, 193, 65, 77, 594, 198, 14, 78, 596, 197, 66, 78, 585, 195, 35, 79, 139, 599, 94, 79, 609, 194, 76, 82, 376, 375, 89, 83, 593, 204, 93, 83, 194, 561, 89, 84, 593, 200, 93, 84, 194, 479, 14, 85, 382, 369, 66, 85, 306, 367, 64, 87, 374, 367, 65, 87, 376, 369, 14, 88, 592, 197, 66, 88, 501, 195, 76, 90, 376, 376, 76, 91, 371, 376, 14, 92, 377, 369, 66, 92, 339, 367, 14, 94, 596, 196, 64, 95, 597, 195, 65, 95, 376, 370, 89, 96, 208, 594, 93, 96, 194, 509, 89, 97, 379, 376, 93, 97, 194, 510, 14, 101, 381, 370, 66, 101, 543, 195, 10, 102, 376, 367, 14, 103, 597, 196, 76, 104, 594, 204, 89, 105, 378, 375, 93, 105, 194, 437, 64, 106, 592, 195, 65, 106, 594, 197, 14, 107, 377, 368, 66, 107, 523, 193, 14, 108, 597, 198, 66, 108, 421, 193, 14, 109, 374, 370, 66, 109, 460, 195, 10, 111, 594, 193, 10, 113, 371, 367, 65, 114, 594, 196, 14, 115, 382, 368, 66, 115, 520, 193, 14, 116, 595, 197, 66, 116, 445, 195, 35, 117, 362, 388, 35, 118, 146, 601, 94, 118, 610, 194, 14, 119, 595, 198, 66, 119, 445, 193, 35, 120, 139, 598, 94, 120, 611, 194, 76, 121, 375, 376, 89, 122, 372, 376, 14, 123, 380, 368, 66, 123, 488, 193, 89, 124, 378, 376, 93, 124, 194, 507, 14, 126, 377, 370, 66, 126, 523, 195, 49, 128, 550, 194, 75, 129, 612, 194, 75, 130, 613, 194, 75, 131, 614, 194, 75, 132, 615, 194, 7, 135, 16, 1, 8, 135, 17, 1, 7, 136, 18, 1, 8, 136, 19, 1, 7, 137, 20, 1, 8, 137, 21, 1, 7, 138, 22, 1, 8, 138, 23, 1, 7, 139, 24, 1, 8, 139, 25, 1, 7, 140, 26, 1, 8, 140, 27, 1, 7, 141, 28, 1, 8, 141, 29, 1, 7, 142, 30, 1, 8, 142, 31, 1, 7, 143, 32, 1, 8, 143, 33, 1, 7, 144, 34, 1, 8, 144, 35, 1, 7, 145, 36, 1, 8, 145, 37, 1, 7, 146, 38, 1, 8, 146, 39, 1, 7, 147, 40, 1, 8, 147, 41, 1, 7, 148, 42, 1, 8, 148, 43, 1, 7, 149, 44, 1, 8, 149, 45, 1)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 5: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=5
nb_c=61
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=656 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(46, 0, 0, 76, 0, 0, 46, 0, 42, 51, 1, 1, 13, 1, 1, 51, 1, 40, 13, 1, 4, 14, 2, 2, 66, 2, 2, 35, 3, 3, 94, 3, 3, 66, 4, 4, 14, 4, 4, 66, 4, 1, 14, 5, 5, 66, 5, 5, 14, 6, 6, 66, 6, 6, 14, 7, 7, 66, 7, 7, 35, 8, 8, 94, 8, 8, 14, 9, 9, 66, 9, 9, 14, 10, 10, 66, 10, 10, 47, 11, 11, 99, 11, 11, 64, 11, 11, 65, 11, 11, 47, 11, 24, 99, 11, 21, 53, 12, 12, 89, 12, 12, 93, 12, 12, 53, 12, 23, 53, 13, 13, 93, 13, 13, 89, 13, 13, 53, 13, 24, 93, 13, 40, 14, 14, 14, 66, 14, 14, 14, 15, 15, 66, 15, 15, 14, 16, 16, 66, 16, 16, 53, 17, 17, 89, 17, 17, 93, 17, 17, 53, 17, 32, 14, 18, 18, 66, 18, 18, 14, 19, 19, 66, 19, 19, 46, 20, 20, 76, 20, 20, 46, 20, 45, 46, 21, 21, 76, 21, 21, 46, 21, 11, 14, 22, 22, 66, 22, 22, 6, 23, 23, 100, 23, 23, 106, 23, 23, 6, 23, 55, 100, 23, 42, 106, 23, 12, 6, 24, 24, 100, 24, 24, 106, 24, 24, 6, 24, 56, 100, 24, 11, 106, 24, 13, 35, 25, 25, 94, 25, 25, 94, 26, 26, 35, 26, 26, 94, 26, 54, 47, 27, 27, 99, 27, 27, 64, 27, 27, 65, 27, 27, 47, 27, 29, 99, 27, 48, 53, 28, 28, 89, 28, 28, 93, 28, 28, 53, 28, 33, 6, 29, 29, 100, 29, 29, 106, 29, 29, 6, 29, 57, 100, 29, 27, 106, 29, 31, 53, 30, 30, 89, 30, 30, 93, 30, 30, 53, 30, 46, 53, 31, 31, 89, 31, 31, 93, 31, 31, 53, 31, 29, 6, 32, 32, 100, 32, 32, 106, 32, 32, 6, 32, 58, 100, 32, 50, 106, 32, 17, 6, 33, 33, 100, 33, 33, 106, 33, 33, 6, 33, 59, 100, 33, 45, 106, 33, 28, 14, 34, 34, 66, 34, 34, 35, 35, 35, 94, 35, 35, 14, 36, 36, 66, 36, 36, 14, 37, 37, 66, 37, 37, 14, 38, 38, 66, 38, 38, 46, 39, 39, 76, 39, 39, 46, 39, 53, 40, 40, 40, 104, 40, 40, 105, 40, 40, 40, 40, 13, 104, 40, 1, 105, 40, 44, 14, 41, 41, 66, 41, 41, 47, 42, 42, 99, 42, 42, 64, 42, 42, 65, 42, 42, 47, 42, 23, 99, 42, 0, 35, 43, 43, 94, 43, 43, 52, 44, 44, 10, 44, 44, 52, 44, 40, 47, 45, 45, 99, 45, 45, 64, 45, 45, 65, 45, 45, 47, 45, 33, 99, 45, 20, 6, 46, 46, 100, 46, 46, 106, 46, 46, 6, 46, 60, 100, 46, 53, 106, 46, 30, 14, 47, 47, 66, 47, 47, 46, 48, 48, 76, 48, 48, 46, 48, 27, 14, 49, 49, 66, 49, 49, 47, 50, 50, 99, 50, 50, 64, 50, 50, 65, 50, 50, 47, 50, 32, 99, 50, 51, 46, 51, 51, 76, 51, 51, 46, 51, 50, 14, 52, 52, 66, 52, 52, 47, 53, 53, 99, 53, 53, 64, 53, 53, 65, 53, 53, 47, 53, 46, 99, 53, 39, 41, 54, 54, 75, 54, 54, 41, 54, 26, 59, 55, 55, 7, 55, 55, 8, 55, 55, 59, 55, 23, 59, 56, 56, 7, 56, 56, 8, 56, 56, 59, 56, 24, 59, 57, 57, 7, 57, 57, 8, 57, 57, 59, 57, 29, 59, 58, 58, 7, 58, 58, 8, 58, 58, 59, 58, 32, 59, 59, 59, 7, 59, 59, 8, 59, 59, 59, 59, 33, 59, 60, 60, 7, 60, 60, 8, 60, 60, 59, 60, 46)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(76, 1, 594, 371, 14, 3, 592, 370, 66, 3, 734, 195, 35, 4, 362, 598, 94, 4, 764, 194, 14, 5, 762, 196, 14, 6, 597, 369, 66, 6, 421, 367, 14, 7, 596, 369, 66, 7, 585, 367, 14, 8, 762, 197, 66, 8, 716, 195, 35, 9, 139, 763, 94, 9, 765, 194, 14, 10, 597, 368, 66, 10, 735, 193, 14, 11, 596, 370, 66, 11, 706, 195, 64, 12, 762, 193, 65, 12, 594, 368, 89, 13, 593, 371, 93, 13, 194, 659, 89, 14, 372, 594, 14, 15, 373, 591, 66, 15, 441, 367, 14, 16, 374, 591, 66, 16, 460, 367, 14, 17, 596, 368, 66, 17, 706, 193, 89, 18, 593, 375, 93, 18, 194, 645, 14, 19, 595, 368, 66, 19, 747, 193, 14, 20, 595, 370, 66, 20, 747, 195, 76, 21, 594, 376, 76, 22, 376, 594, 14, 23, 377, 591, 66, 23, 523, 367, 35, 26, 362, 599, 94, 26, 766, 194, 35, 27, 362, 600, 64, 28, 762, 195, 65, 28, 594, 370, 89, 29, 593, 376, 93, 29, 194, 687, 89, 31, 378, 594, 93, 31, 194, 662, 89, 32, 379, 594, 93, 32, 194, 668, 14, 35, 592, 369, 66, 35, 501, 367, 35, 36, 146, 763, 94, 36, 767, 194, 14, 37, 380, 591, 66, 37, 488, 367, 14, 38, 762, 198, 66, 38, 716, 193, 14, 39, 597, 370, 66, 39, 735, 195, 76, 40, 375, 594, 14, 42, 381, 591, 66, 42, 543, 367, 64, 43, 596, 367, 65, 43, 371, 591, 35, 44, 362, 601, 94, 44, 768, 194, 10, 45, 594, 367, 64, 46, 597, 367, 65, 46, 376, 591, 14, 48, 595, 369, 66, 48, 445, 367, 76, 49, 371, 594, 14, 50, 592, 368, 66, 50, 734, 193, 64, 51, 595, 367, 65, 51, 375, 591, 76, 52, 594, 375, 14, 53, 382, 591, 66, 53, 520, 367, 64, 54, 592, 367, 65, 54, 594, 369, 75, 55, 769, 194, 7, 56, 4, 1, 8, 56, 5, 1, 7, 57, 6, 1, 8, 57, 7, 1, 7, 58, 8, 1, 8, 58, 9, 1, 7, 59, 10, 1, 8, 59, 11, 1, 7, 60, 12, 1, 8, 60, 13, 1, 7, 61, 14, 1, 8, 61, 15, 1)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 6: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=6
nb_c=13
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=717 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(14, 0, 0, 66, 0, 0, 14, 1, 1, 66, 1, 1, 35, 2, 2, 94, 2, 2, 53, 3, 3, 89, 3, 3, 93, 3, 3, 53, 3, 7, 14, 4, 4, 66, 4, 4, 46, 5, 5, 76, 5, 5, 46, 5, 10, 14, 6, 6, 66, 6, 6, 6, 7, 7, 100, 7, 7, 106, 7, 7, 6, 7, 12, 100, 7, 10, 106, 7, 3, 14, 8, 8, 66, 8, 8, 14, 9, 9, 66, 9, 9, 47, 10, 10, 99, 10, 10, 64, 10, 10, 65, 10, 10, 47, 10, 7, 99, 10, 5, 14, 11, 11, 66, 11, 11, 59, 12, 12, 7, 12, 12, 8, 12, 12, 59, 12, 7)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(14, 1, 762, 368, 66, 1, 786, 193, 14, 2, 592, 591, 66, 2, 734, 367, 35, 3, 362, 763, 94, 3, 839, 194, 89, 4, 593, 594, 93, 4, 194, 825, 14, 5, 762, 369, 66, 5, 716, 367, 76, 6, 594, 594, 14, 7, 762, 370, 66, 7, 786, 195, 14, 9, 595, 591, 66, 9, 747, 367, 14, 10, 596, 591, 66, 10, 706, 367, 64, 11, 762, 367, 65, 11, 594, 591, 14, 12, 597, 591, 66, 12, 735, 367, 7, 13, 2, 1, 8, 13, 3, 1)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 7: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=7
nb_c=1
ba_x=128; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=730 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(14, 0, 0, 66, 0, 0)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(14, 1, 762, 591, 66, 1, 786, 367)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

# weight count
nb_rw=7
# cumomer count by weight
nb_rcumos=c(99, 192, 216, 149, 61, 13, 1)
nbc_cumos=c(0, cumsum(nb_rcumos))
# cumo names
nm_rcumo=c("Rub5P:16", "Glc6P:8", "PGA:2", "Sed7P:64", "Xul5P:4", "Fru6P:1", "FruBP:4", "FruBP:32", "Mal:2", "Rib5P:1", "AcCoA:1", "Cit:16", "Xul5P:2", "Rib5P:4", "Rib5P:2", "Cit:2", "Mal:8", "AcCoA:2", "Sed7P:32", "Cit:32", "Rub5P:4", "Fru6P:16", "Rib5P:16", "Glc6P:2", "Sed7P:2", "Cit:8", "Glc6P:4", "Mal:1", "FruBP:2", "Glc6P:16", "PEP:4", "Xul5P:8", "Xul5P:16", "Gnt6P:4", "Glc6P:1", "Cit:1", "Glc6P:32", "Mal:4", "Gnt6P:32", "Cit:4", "PGA:1", "Rub5P:1", "Sed7P:8", "Xul5P:1", "Fru6P:8", "Rib5P:8", "Fru6P:4", "Gnt6P:8", "Rub5P:2", "PGA:4", "Sed7P:16", "FruBP:16", "Gnt6P:1", "Sed7P:1", "PEP:2", "FruBP:1", "FruBP:8", "Gnt6P:16", "Gnt6P:2", "Rub5P:8", "Fru6P:32", "PEP:1", "Fru6P:2", "Sed7P:4", "E2:1", "CO2:1", "E2:2", "E3:1", "E3:4", "E3:2", "GA3P:4", "GA3P:1", "Ery4P:8", "Ery4P:1", "Pyr:2", "GA3P:2", "Ery4P:4", "Ery4P:2", "Pyr:1", "Pyr:4", "OAA:4", "OAA:2", "OAA:8", "OAA:1", "AKG:1", "AKG:8", "AKG:2", "AKG:4", "AKG:16", "Suc:4", "Suc:1", "Suc:2", "Suc:8", "Glc:8", "Glc:2", "Glc:4", "Glc:16", "Glc:1", "Glc:32", "Rub5P:12", "Xul5P:24", "Gnt6P:34", "Gnt6P:6", "Rub5P:6", "Mal:9", "Cit:3", "Sed7P:24", "Cit:34", "FruBP:12", "Cit:9", "Sed7P:18", "FruBP:17", "Xul5P:9", "Sed7P:40", "Fru6P:36", "Glc6P:3", "PEP:6", "Rub5P:18", "Rib5P:18", "Cit:17", "Xul5P:6", "Glc6P:36", "Sed7P:68", "Gnt6P:36", "Sed7P:5", "Fru6P:10", "Gnt6P:10", "PGA:3", "Xul5P:17", "Rub5P:17", "Sed7P:10", "Gnt6P:12", "Glc6P:20", "Rib5P:6", "Rib5P:17", "Gnt6P:5", "Cit:5", "FruBP:20", "Rib5P:5", "Glc6P:40", "Gnt6P:20", "Cit:20", "FruBP:33", "FruBP:40", "Rib5P:10", "Xul5P:20", "Glc6P:9", "Rib5P:20", "Cit:6", "Sed7P:72", "Xul5P:5", "Rub5P:5", "Sed7P:34", "Cit:12", "Fru6P:18", "Fru6P:40", "Gnt6P:17", "Cit:40", "Gnt6P:40", "Cit:33", "FruBP:10", "Xul5P:18", "FruBP:3", "Sed7P:48", "Glc6P:10", "Rib5P:24", "FruBP:9", "FruBP:18", "Cit:48", "Xul5P:12", "Glc6P:6", "Fru6P:34", "FruBP:48", "Gnt6P:33", "PEP:5", "FruBP:6", "Rib5P:12", "Rib5P:3", "FruBP:34", "Sed7P:6", "Mal:12", "Mal:5", "Gnt6P:24", "Gnt6P:9", "Sed7P:3", "Fru6P:12", "Cit:24", "Glc6P:48", "PGA:5", "Sed7P:65", "Gnt6P:48", "Rub5P:20", "FruBP:36", "Mal:6", "Sed7P:12", "Xul5P:10", "Glc6P:12", "Mal:3", "Fru6P:9", "Rub5P:10", "Gnt6P:18", "Fru6P:48", "Glc6P:24", "Sed7P:9", "Rub5P:3", "Sed7P:17", "Glc6P:5", "Cit:18", "Sed7P:36", "Cit:36", "Rib5P:9", "Fru6P:20", "Cit:10", "Glc6P:34", "Fru6P:24", "Fru6P:5", "Fru6P:17", "FruBP:5", "PEP:3", "Sed7P:80", "Sed7P:66", "Fru6P:6", "Glc6P:18", "Fru6P:33", "Rub5P:9", "Glc6P:33", "Rub5P:24", "Sed7P:33", "Sed7P:20", "Sed7P:96", "Fru6P:3", "Glc6P:17", "Mal:10", "AcCoA:3", "PGA:6", "Gnt6P:3", "Xul5P:3", "FruBP:24", "E2:3", "E3:3", "E3:6", "E3:5", "GA3P:5", "Pyr:3", "Ery4P:10", "Ery4P:6", "GA3P:3", "GA3P:6", "Ery4P:9", "Pyr:6", "Pyr:5", "Ery4P:12", "Ery4P:5", "Ery4P:3", "OAA:3", "OAA:9", "OAA:12", "OAA:6", "OAA:10", "OAA:5", "AKG:20", "AKG:17", "AKG:10", "AKG:3", "AKG:18", "AKG:6", "AKG:12", "AKG:5", "AKG:24", "AKG:9", "Suc:3", "Suc:9", "Suc:12", "Suc:5", "Suc:6", "Suc:10", "Glc:3", "Glc:36", "Glc:20", "Glc:40", "Glc:9", "Glc:10", "Glc:6", "Glc:48", "Glc:12", "Glc:24", "Glc:5", "Glc:34", "Glc:18", "Glc:33", "Glc:17", "Fru6P:35", "Rib5P:14", "Fru6P:42", "FruBP:56", "FruBP:41", "Cit:44", "Cit:50", "Fru6P:38", "Fru6P:52", "Xul5P:7", "Glc6P:49", "FruBP:50", "Glc6P:26", "Rub5P:21", "Sed7P:37", "Gnt6P:44", "Sed7P:70", "Rub5P:19", "Gnt6P:25", "Sed7P:25", "Fru6P:56", "Rib5P:26", "Gnt6P:28", "Gnt6P:11", "FruBP:44", "Rib5P:11", "Xul5P:13", "Gnt6P:49", "Gnt6P:56", "Fru6P:37", "Xul5P:22", "Sed7P:73", "Gnt6P:35", "Sed7P:38", "Cit:37", "Sed7P:28", "FruBP:26", "PGA:7", "Cit:25", "Sed7P:11", "Rib5P:22", "Gnt6P:21", "Glc6P:28", "FruBP:7", "Rub5P:11", "Gnt6P:22", "Sed7P:104", "FruBP:37", "Cit:11", "Gnt6P:19", "Cit:19", "Gnt6P:26", "FruBP:21", "Glc6P:42", "Fru6P:19", "Glc6P:38", "Sed7P:41", "Gnt6P:50", "Sed7P:42", "Rub5P:25", "Fru6P:50", "Cit:26", "Glc6P:21", "Gnt6P:37", "Xul5P:21", "Mal:14", "Glc6P:11", "Mal:13", "Rib5P:28", "Cit:22", "Xul5P:28", "Sed7P:52", "Sed7P:22", "Glc6P:22", "Sed7P:82", "Fru6P:28", "Sed7P:49", "Sed7P:100", "Cit:7", "Cit:56", "FruBP:28", "Rib5P:7", "Cit:35", "Cit:38", "Gnt6P:14", "Fru6P:49", "Xul5P:25", "Rub5P:22", "Sed7P:97", "Rub5P:7", "Rub5P:14", "Gnt6P:42", "FruBP:11", "Sed7P:67", "Glc6P:56", "FruBP:19", "Xul5P:14", "Fru6P:44", "Sed7P:112", "Xul5P:26", "Rib5P:19", "Mal:11", "FruBP:22", "Rib5P:25", "Cit:14", "Sed7P:7", "Glc6P:37", "Glc6P:50", "Sed7P:26", "Cit:28", "FruBP:42", "Sed7P:14", "Fru6P:11", "Cit:13", "Fru6P:25", "Sed7P:19", "FruBP:49", "Sed7P:81", "Fru6P:41", "Gnt6P:41", "Sed7P:21", "Cit:52", "Gnt6P:7", "Rib5P:21", "Cit:49", "Fru6P:14", "Fru6P:26", "Sed7P:35", "Cit:21", "Sed7P:56", "PEP:7", "Glc6P:41", "Glc6P:52", "Glc6P:14", "Sed7P:76", "Fru6P:21", "Glc6P:25", "Gnt6P:13", "FruBP:38", "FruBP:52", "Fru6P:13", "Rub5P:26", "Xul5P:19", "FruBP:13", "Fru6P:22", "FruBP:35", "Xul5P:11", "Sed7P:44", "Glc6P:35", "Sed7P:13", "FruBP:25", "Glc6P:7", "Cit:41", "Gnt6P:38", "Sed7P:74", "Sed7P:88", "Glc6P:44", "Glc6P:19", "Gnt6P:52", "Rub5P:28", "Sed7P:69", "Mal:7", "Sed7P:98", "Cit:42", "Glc6P:13", "Rib5P:13", "Sed7P:84", "Sed7P:50", "FruBP:14", "Rub5P:13", "Fru6P:7", "E3:7", "Ery4P:7", "Pyr:7", "GA3P:7", "Ery4P:11", "Ery4P:13", "Ery4P:14", "OAA:11", "OAA:13", "OAA:7", "OAA:14", "AKG:19", "AKG:7", "AKG:11", "AKG:25", "AKG:14", "AKG:28", "AKG:21", "AKG:22", "AKG:13", "AKG:26", "Suc:11", "Suc:14", "Suc:7", "Suc:13", "Glc:49", "Glc:26", "Glc:28", "Glc:42", "Glc:38", "Glc:21", "Glc:11", "Glc:22", "Glc:56", "Glc:37", "Glc:50", "Glc:41", "Glc:52", "Glc:14", "Glc:25", "Glc:35", "Glc:7", "Glc:44", "Glc:19", "Glc:13", "Sed7P:53", "FruBP:29", "Gnt6P:60", "Sed7P:102", "FruBP:15", "Cit:51", "FruBP:45", "FruBP:57", "FruBP:60", "Rub5P:27", "Sed7P:120", "Glc6P:39", "Gnt6P:53", "Cit:39", "Sed7P:113", "Sed7P:101", "Glc6P:15", "FruBP:39", "Gnt6P:23", "Fru6P:58", "Sed7P:108", "Sed7P:58", "Sed7P:106", "Rub5P:29", "Cit:15", "FruBP:43", "Rub5P:23", "Sed7P:23", "Fru6P:29", "Sed7P:39", "Cit:27", "Sed7P:78", "Rub5P:15", "Cit:23", "Sed7P:54", "Fru6P:30", "Cit:58", "FruBP:23", "Fru6P:57", "FruBP:53", "Gnt6P:45", "Glc6P:54", "Glc6P:58", "Sed7P:116", "Fru6P:53", "Gnt6P:27", "Cit:53", "Fru6P:60", "Glc6P:23", "Sed7P:83", "Xul5P:27", "Rub5P:30", "Cit:57", "Sed7P:45", "Fru6P:27", "Sed7P:114", "Sed7P:92", "Mal:15", "Glc6P:45", "Fru6P:45", "FruBP:51", "Fru6P:51", "Xul5P:23", "Cit:30", "Gnt6P:29", "Gnt6P:43", "Fru6P:43", "Glc6P:60", "Glc6P:57", "Cit:60", "Rib5P:29", "Sed7P:27", "Sed7P:90", "Glc6P:29", "Cit:45", "Gnt6P:15", "Fru6P:23", "Sed7P:77", "Cit:46", "Glc6P:27", "Rib5P:15", "FruBP:27", "Gnt6P:58", "Gnt6P:57", "Sed7P:99", "Glc6P:51", "Fru6P:54", "Sed7P:71", "Glc6P:46", "FruBP:30", "FruBP:46", "Sed7P:105", "Glc6P:53", "Sed7P:29", "Fru6P:46", "Gnt6P:39", "Gnt6P:46", "Sed7P:15", "Rib5P:23", "Rib5P:30", "Sed7P:85", "Xul5P:30", "Sed7P:30", "FruBP:58", "Gnt6P:51", "Fru6P:39", "Sed7P:57", "Sed7P:46", "Sed7P:86", "Glc6P:43", "Xul5P:15", "Rib5P:27", "Xul5P:29", "Fru6P:15", "Sed7P:51", "Sed7P:75", "Cit:43", "Cit:29", "Sed7P:43", "Cit:54", "FruBP:54", "Gnt6P:30", "Sed7P:60", "Gnt6P:54", "Glc6P:30", "Sed7P:89", "Ery4P:15", "OAA:15", "AKG:27", "AKG:30", "AKG:23", "AKG:29", "AKG:15", "Suc:15", "Glc:39", "Glc:15", "Glc:54", "Glc:58", "Glc:23", "Glc:45", "Glc:60", "Glc:57", "Glc:29", "Glc:27", "Glc:51", "Glc:46", "Glc:53", "Glc:43", "Glc:30", "FruBP:61", "Rib5P:31", "Sed7P:87", "Cit:55", "Sed7P:31", "Sed7P:110", "Sed7P:109", "Sed7P:79", "Cit:62", "Sed7P:62", "Sed7P:93", "Fru6P:31", "Gnt6P:61", "Gnt6P:31", "Sed7P:122", "Sed7P:118", "Sed7P:61", "Gnt6P:59", "Sed7P:59", "Sed7P:91", "FruBP:62", "FruBP:31", "Sed7P:121", "Glc6P:61", "Glc6P:31", "Cit:47", "Cit:59", "Fru6P:47", "Gnt6P:62", "Glc6P:47", "Gnt6P:55", "Gnt6P:47", "Glc6P:59", "Glc6P:62", "Sed7P:103", "Cit:61", "Sed7P:124", "Sed7P:47", "Sed7P:94", "FruBP:55", "Rub5P:31", "Sed7P:117", "Fru6P:61", "Cit:31", "Xul5P:31", "Fru6P:62", "Glc6P:55", "Sed7P:107", "FruBP:47", "Sed7P:55", "Fru6P:59", "FruBP:59", "Sed7P:115", "Fru6P:55", "AKG:31", "Glc:61", "Glc:31", "Glc:47", "Glc:59", "Glc:62", "Glc:55", "Sed7P:63", "Sed7P:119", "Cit:63", "Gnt6P:63", "Sed7P:111", "FruBP:63", "Sed7P:95", "Glc6P:63", "Sed7P:123", "Sed7P:125", "Fru6P:63", "Sed7P:126", "Glc:63", "Sed7P:127")
nm_list$rcumo=nm_rcumo

if (case_i) {
   # check the coherence of metabolites/cumomers
   met_net=unique(matrix(unlist(strsplit(nm_rcumo, ":", fixed=TRUE)), nrow=2)[1,])
   net_pool=sort(setdiff(met_net, names(nm_poolall)))
   if (length(net_pool) > 0) {
      stop_mes("The following metabolites are internal in NETWORK section but not in METABOLITE_POOLS one:\n"%s+%paste(net_pool, collapse="\n"), file=fcerr)
   }
}

nb_exp=1
nm_exp=c("e_coli_growth")
nm_list$nm_exp=nm_exp
# input cumomer vectors
xi=c(0, 0.952, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.96, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.968, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.976, 0, 0.984, 0.0107, 0.984, 0, 0.984, 0.0107, 0.984, 0, 0.984, 0, 0.984, 0, 0.984, 0.0107, 0.984, 0, 0.984, 0, 0.984, 0, 0.984, 0.0107, 0.984, 0, 0.984, 0.0107, 0.984, 0, 0.984, 0.0107, 0.0107, 0.992, 0.0107, 0.992, 0.0107, 0.992, 0.0107, 0.992, 0.0107, 0.992, 1.0000000000000002, 0.992)
if (length(xi)) {
   dim(xi)=c(length(xi)/nb_exp, nb_exp)
} else {
   stop_mes("No reduced label entry is defined (may be because no measurement defined in FTBL). Cannot continue.", file=fcerr)
}
nm_xi=c("Gluc_1:63", "Gluc_U:63", "Gluc_1:61", "Gluc_U:61", "Gluc_1:31", "Gluc_U:31", "Gluc_1:47", "Gluc_U:47", "Gluc_1:59", "Gluc_U:59", "Gluc_1:62", "Gluc_U:62", "Gluc_1:55", "Gluc_U:55", "Gluc_1:39", "Gluc_U:39", "Gluc_1:15", "Gluc_U:15", "Gluc_1:54", "Gluc_U:54", "Gluc_1:58", "Gluc_U:58", "Gluc_1:23", "Gluc_U:23", "Gluc_1:45", "Gluc_U:45", "Gluc_1:60", "Gluc_U:60", "Gluc_1:57", "Gluc_U:57", "Gluc_1:29", "Gluc_U:29", "Gluc_1:27", "Gluc_U:27", "Gluc_1:51", "Gluc_U:51", "Gluc_1:46", "Gluc_U:46", "Gluc_1:53", "Gluc_U:53", "Gluc_1:43", "Gluc_U:43", "Gluc_1:30", "Gluc_U:30", "Gluc_1:49", "Gluc_U:49", "Gluc_1:26", "Gluc_U:26", "Gluc_1:28", "Gluc_U:28", "Gluc_1:42", "Gluc_U:42", "Gluc_1:38", "Gluc_U:38", "Gluc_1:21", "Gluc_U:21", "Gluc_1:11", "Gluc_U:11", "Gluc_1:22", "Gluc_U:22", "Gluc_1:56", "Gluc_U:56", "Gluc_1:37", "Gluc_U:37", "Gluc_1:50", "Gluc_U:50", "Gluc_1:41", "Gluc_U:41", "Gluc_1:52", "Gluc_U:52", "Gluc_1:14", "Gluc_U:14", "Gluc_1:25", "Gluc_U:25", "Gluc_1:35", "Gluc_U:35", "Gluc_1:7", "Gluc_U:7", "Gluc_1:44", "Gluc_U:44", "Gluc_1:19", "Gluc_U:19", "Gluc_1:13", "Gluc_U:13", "Gluc_1:3", "Gluc_U:3", "Gluc_1:36", "Gluc_U:36", "Gluc_1:20", "Gluc_U:20", "Gluc_1:40", "Gluc_U:40", "Gluc_1:9", "Gluc_U:9", "Gluc_1:10", "Gluc_U:10", "Gluc_1:6", "Gluc_U:6", "Gluc_1:48", "Gluc_U:48", "Gluc_1:12", "Gluc_U:12", "Gluc_1:24", "Gluc_U:24", "Gluc_1:5", "Gluc_U:5", "Gluc_1:34", "Gluc_U:34", "Gluc_1:18", "Gluc_U:18", "Gluc_1:33", "Gluc_U:33", "Gluc_1:17", "Gluc_U:17", "CO2_ext:1", "Gluc_1:8", "Gluc_U:8", "Gluc_1:2", "Gluc_U:2", "Gluc_1:4", "Gluc_U:4", "Gluc_1:16", "Gluc_U:16", "Gluc_1:1", "Gluc_U:1", "Gluc_1:32", "Gluc_U:32")
dimnames(xi)[[1]]=nm_xi
nm_list$xi=nm_xi
nb_xi=length(nm_xi)
nb_f$xi=nb_xi
nb_cumoi=nb_xi
nm_inp=nm_xi
nm_incu=c("one", nm_xi, nm_rcumo)
nm_inlab=nm_incu
spa=spAbr
nm_x=nm_rcumo
nb_x=nb_rcumos
nb_f$rcumos=nb_rcumos
nb_f$cumoi=nb_cumoi
if (emu) {
   nm_emu=c()
   nb_emus=nb_rcumos*(seq_len(nb_rw)+1)
   nb_f$emus=nb_emus
   nm_list$emu=nm_emu
   nm_x=nm_emu
   nb_x=nb_emus
   xiemu=matrix(c(), ncol=nb_exp)
   nm_xiemu=c()
   nm_list$xiemu=nm_xiemu
   dimnames(xiemu)[[1]]=nm_xiemu
   nb_xiemu=length(nm_xiemu)
   nb_f$xiemu=nb_xiemu
   nb_f$xi=nb_xiemu
   nb_xi=nb_xiemu
   nm_inp=nm_xiemu
   xi=xiemu
   nm_inemu=c("one", nm_xiemu, nm_emu)
   nm_inlab=nm_inemu
   spa=spr2emu(spAbr, nm_incu, nm_inemu, nb_f)
}
# reorder indexes to accelerate sparse matrix construction
spa=sparse2spa(spa)
#browser()
# composite labeling vector incu c(1, xi, xc) names
nm_inlab=c("one", nm_inp, nm_x); # the constant 1 has name "one"
nm_list$x=nm_x
nm_list$inp=nm_inp
nb_f$x=nb_x
nm_cumo=NULL

if (TIMEIT) {
   cat("measure : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
if (!noscale) {
   # make place for scaling factors
   nb_sc=vector("integer", 1)
# experiment: 1

   # mass
   # initial values for scales are set later
   param=c(param,0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
   nm_par=c(nm_par,c("1:mass;Cit;111111;762", "1:mass;Fru6P;111111;754", "1:mass;FruBP;111111;734", "1:mass;Glc6P;111111;747", "1:mass;Gnt6P;111111;719", "1:mass;Mal;1111;707", "1:mass;PEP;111;711", "1:mass;PGA;111;715", "1:mass;Rib5P+Xul5P+Rub5P;11111;741", "1:mass;Sed7P;1111111;726"))
   names(param)=nm_par

   nb_param=length(param)
   nb_sc[1]=nb_param-nb_ff # at this moment it is cumulated sum. diff() is taken later

   # indices mapping from scaling to measure matrix row
   # c(1,par)[ir2isc[[iexp]]] replicates scale parameters
   # for corresponding rows of measure matrix
   ir2isc=vector("list", 1)

   # 1:label
   ir2isc[[1]]=c(ir2isc[[1]],c(1, 1, 1, 1))

   # 1:mass
   ir2isc[[1]]=c(ir2isc[[1]],c(22, 22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 21, 21, 21, 21, 21, 21, 21, 26, 26, 26, 26, 26, 26, 26, 26, 19, 19, 19, 19, 19, 19, 19, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 20, 20, 20, 20, 20, 20, 18, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17))

   # cumulated base for nb_sc
   nb_sc_base=c(0, nb_sc[-nb_exp])
   nb_sc=diff(c(0, nb_sc))
   nb_sc_tot=sum(nb_sc)
   nb_f$nb_sc=nb_sc
   nb_f$nb_sc_tot=nb_sc_tot
   nb_f$nb_sc_base=nb_sc_base
#browser()
} else {
   # no scaling
   ir2isc=list()
   nb_sc=integer(nb_exp)
   nb_sc_tot=0
}
nb_f$nb_sc=nb_sc
nb_f$nb_sc_tot=nb_sc_tot
nm_list$par=nm_par

# make a list of sparse measurement matrices
# measmat*xr+memaone gives a vector of simulated not-yet-pooled and not-yet-scaled measurements
# all but 0. Coefficients of 0-cumomers (by defenition equal to 1)
# are all regrouped in the memaone.
nm_measmat=nm_meas=nb_meas=nb_measmat=measmat=memaone=measvec=measdev=ipooled=vector("list", 1)

nm_measmat[[1]]=c("l:AcCoA:#00:682", "l:AcCoA:#01:683", "l:AcCoA:#10:684", "l:AcCoA:#11:685", "m:Mal:1,2,3,4:1:707", "m:Mal:1,2,3,4:2:708", "m:Mal:1,2,3,4:3:709", "m:Mal:1,2,3,4:4:710", "m:PEP:1,2,3:0:711", "m:PEP:1,2,3:1:712", "m:PEP:1,2,3:2:713", "m:PEP:1,2,3:3:714", "m:PGA:1,2,3:0:715", "m:PGA:1,2,3:1:716", "m:PGA:1,2,3:2:717", "m:PGA:1,2,3:3:718", "m:Gnt6P:1,2,3,4,5,6:0:719", "m:Gnt6P:1,2,3,4,5,6:1:720", "m:Gnt6P:1,2,3,4,5,6:2:721", "m:Gnt6P:1,2,3,4,5,6:3:722", "m:Gnt6P:1,2,3,4,5,6:4:723", "m:Gnt6P:1,2,3,4,5,6:5:724", "m:Gnt6P:1,2,3,4,5,6:6:725", "m:Sed7P:1,2,3,4,5,6,7:0:726", "m:Sed7P:1,2,3,4,5,6,7:1:727", "m:Sed7P:1,2,3,4,5,6,7:2:728", "m:Sed7P:1,2,3,4,5,6,7:3:729", "m:Sed7P:1,2,3,4,5,6,7:4:730", "m:Sed7P:1,2,3,4,5,6,7:5:731", "m:Sed7P:1,2,3,4,5,6,7:6:732", "m:Sed7P:1,2,3,4,5,6,7:7:733", "m:FruBP:1,2,3,4,5,6:0:734", "m:FruBP:1,2,3,4,5,6:1:735", "m:FruBP:1,2,3,4,5,6:2:736", "m:FruBP:1,2,3,4,5,6:3:737", "m:FruBP:1,2,3,4,5,6:4:738", "m:FruBP:1,2,3,4,5,6:5:739", "m:FruBP:1,2,3,4,5,6:6:740", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:0:741", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:0:741", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:0:741", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:1:742", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:1:742", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:1:742", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:2:743", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:2:743", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:2:743", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:3:744", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:3:744", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:3:744", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:4:745", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:4:745", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:4:745", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:5:746", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:5:746", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:5:746", "m:Glc6P:1,2,3,4,5,6:0:747", "m:Glc6P:1,2,3,4,5,6:1:748", "m:Glc6P:1,2,3,4,5,6:2:749", "m:Glc6P:1,2,3,4,5,6:3:750", "m:Glc6P:1,2,3,4,5,6:4:751", "m:Glc6P:1,2,3,4,5,6:5:752", "m:Glc6P:1,2,3,4,5,6:6:753", "m:Fru6P:1,2,3,4,5,6:0:754", "m:Fru6P:1,2,3,4,5,6:1:755", "m:Fru6P:1,2,3,4,5,6:2:756", "m:Fru6P:1,2,3,4,5,6:3:757", "m:Fru6P:1,2,3,4,5,6:4:758", "m:Fru6P:1,2,3,4,5,6:5:759", "m:Fru6P:1,2,3,4,5,6:6:760", "m:Cit:1,2,3,4,5,6:1:762", "m:Cit:1,2,3,4,5,6:2:763", "m:Cit:1,2,3,4,5,6:3:764", "m:Cit:1,2,3,4,5,6:4:765", "m:Cit:1,2,3,4,5,6:5:766", "m:Cit:1,2,3,4,5,6:6:767")
nm_meas[[1]]=c("l:AcCoA:#00:682", "l:AcCoA:#01:683", "l:AcCoA:#10:684", "l:AcCoA:#11:685", "m:Mal:1,2,3,4:1:707", "m:Mal:1,2,3,4:2:708", "m:Mal:1,2,3,4:3:709", "m:Mal:1,2,3,4:4:710", "m:PEP:1,2,3:0:711", "m:PEP:1,2,3:1:712", "m:PEP:1,2,3:2:713", "m:PEP:1,2,3:3:714", "m:PGA:1,2,3:0:715", "m:PGA:1,2,3:1:716", "m:PGA:1,2,3:2:717", "m:PGA:1,2,3:3:718", "m:Gnt6P:1,2,3,4,5,6:0:719", "m:Gnt6P:1,2,3,4,5,6:1:720", "m:Gnt6P:1,2,3,4,5,6:2:721", "m:Gnt6P:1,2,3,4,5,6:3:722", "m:Gnt6P:1,2,3,4,5,6:4:723", "m:Gnt6P:1,2,3,4,5,6:5:724", "m:Gnt6P:1,2,3,4,5,6:6:725", "m:Sed7P:1,2,3,4,5,6,7:0:726", "m:Sed7P:1,2,3,4,5,6,7:1:727", "m:Sed7P:1,2,3,4,5,6,7:2:728", "m:Sed7P:1,2,3,4,5,6,7:3:729", "m:Sed7P:1,2,3,4,5,6,7:4:730", "m:Sed7P:1,2,3,4,5,6,7:5:731", "m:Sed7P:1,2,3,4,5,6,7:6:732", "m:Sed7P:1,2,3,4,5,6,7:7:733", "m:FruBP:1,2,3,4,5,6:0:734", "m:FruBP:1,2,3,4,5,6:1:735", "m:FruBP:1,2,3,4,5,6:2:736", "m:FruBP:1,2,3,4,5,6:3:737", "m:FruBP:1,2,3,4,5,6:4:738", "m:FruBP:1,2,3,4,5,6:5:739", "m:FruBP:1,2,3,4,5,6:6:740", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:0:741", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:1:742", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:2:743", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:3:744", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:4:745", "m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:5:746", "m:Glc6P:1,2,3,4,5,6:0:747", "m:Glc6P:1,2,3,4,5,6:1:748", "m:Glc6P:1,2,3,4,5,6:2:749", "m:Glc6P:1,2,3,4,5,6:3:750", "m:Glc6P:1,2,3,4,5,6:4:751", "m:Glc6P:1,2,3,4,5,6:5:752", "m:Glc6P:1,2,3,4,5,6:6:753", "m:Fru6P:1,2,3,4,5,6:0:754", "m:Fru6P:1,2,3,4,5,6:1:755", "m:Fru6P:1,2,3,4,5,6:2:756", "m:Fru6P:1,2,3,4,5,6:3:757", "m:Fru6P:1,2,3,4,5,6:4:758", "m:Fru6P:1,2,3,4,5,6:5:759", "m:Fru6P:1,2,3,4,5,6:6:760", "m:Cit:1,2,3,4,5,6:1:762", "m:Cit:1,2,3,4,5,6:2:763", "m:Cit:1,2,3,4,5,6:3:764", "m:Cit:1,2,3,4,5,6:4:765", "m:Cit:1,2,3,4,5,6:5:766", "m:Cit:1,2,3,4,5,6:6:767")
nb_meas[[1]]=length(nm_meas[[1]])
nb_measmat[[1]]=length(nm_measmat[[1]])
measmat[[1]]=simple_triplet_zero_matrix(nrow=nb_measmat[[1]], ncol=731)
dimnames(measmat[[1]])=list(nm_measmat[[1]], nm_x)
memaone[[1]]=numeric(nb_measmat[[1]])
measvec[[1]]=c(0.495, 0.303, 0.012, 0.19, 0.587391867374382, 0.216493214407424, 0.159494782909672, 0.0366201353085213, 0.462166666666667, 0.340003333333333, 0.0273166666666667, 0.170513333333333, 0.447066666666667, 0.34127, 0.02441, 0.187253333333333, 0.0195533333333333, 0.72562, 0.0571233333333333, 0.0135033333333333, 0.01331, 0.0131033333333333, 0.157793333333333, 0.272433333333333, 0.23752, 0.180446666666667, 0.12744, 0.06321, 0.0839233333333333, 0.01751, 0.0175266666666667, 0.0853733333333333, 0.482283333333333, 0.140086666666667, 0.0953466666666667, 0.09712, 0.0120166666666667, 0.0877666666666667, 0.433956666666667, 0.215956666666667, 0.09658, 0.129033333333333, 0.0272733333333333, 0.0971933333333333, 0.0167633333333333, 0.716826666666667, 0.0578233333333333, 0.0122433333333333, 0.01151, 0.01089, 0.173946666666667, 0.04716, 0.623343333333333, 0.0820266666666667, 0.03604, 0.0315766666666667, 0.0149133333333333, 0.164943333333333, 0.322208057034832, 0.288291305558056, 0.212855540659154, 0.117626468347467, 0.0484839619377435, 0.0105346664627478)
measdev[[1]]=c(0.02, 0.02, 0.02, 0.02, 0.0493159626907812, 0.0306546571894417, 0.03, 0.03, 0.01, 0.01, 0.01, 0.01, 0.0180848260520618, 0.018075350619006, 0.01, 0.01, 0.01, 0.0120547874307264, 0.01, 0.01, 0.01, 0.01, 0.01, 0.0122309539012022, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.0115292555411585, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.0106878170518274, 0.01, 0.01, 0.01, 0.01, 0.0111688555068697, 0.03, 0.03, 0.03, 0.03, 0.03, 0.03)
names(measvec[[1]])=nm_meas[[1]]
names(measdev[[1]])=nm_meas[[1]]
ipooled[[1]]=list(ishort=pmatch(nm_meas[[1]], nm_measmat[[1]]))

nm_meas_tot=unlist(nm_meas)
nb_meas=unlist(nb_meas)
nb_meas_cumo=c(0., cumsum(nb_meas[-nb_exp]))
iexp_meas=lapply(seq_len(nb_exp), function(iexp) seq_len(nb_meas[iexp])+nb_meas_cumo[iexp])
nm_list$meas=nm_meas
nm_list$measmat=nm_measmat
nm_list$meas_tot=nm_meas_tot
nb_f$nb_meas=nb_meas

# prepare indices of pooled measurements
ipooled[[1]][["m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:0:741"]]=1+4+c(34, 35, 36)

# prepare indices of pooled measurements
ipooled[[1]][["m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:1:742"]]=1+4+c(37, 38, 39)

# prepare indices of pooled measurements
ipooled[[1]][["m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:2:743"]]=1+4+c(40, 41, 42)

# prepare indices of pooled measurements
ipooled[[1]][["m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:3:744"]]=1+4+c(43, 44, 45)

# prepare indices of pooled measurements
ipooled[[1]][["m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:4:745"]]=1+4+c(46, 47, 48)

# prepare indices of pooled measurements
ipooled[[1]][["m:Rib5P+Xul5P+Rub5P:1,2,3,4,5:5:746"]]=1+4+c(49, 50, 51)

names(measvec)=names(measdev)=nm_exp

if (!noscale) {
   for (iexp in seq_len(nb_exp))
      ir2isc[[iexp]]=ir2isc[[iexp]][ipooled[[iexp]]$ishort]

   # prepare indexes of dispatching scale params in jacobian
   if (nb_sc_tot > 0) {
      nb_f$is2m=vector("list", nb_exp)
      for (iexp in seq_len(nb_exp)) {
         ipaire=matrix(0, nrow=0, ncol=2)
         tmp=lapply(seq_len(nb_sc[[iexp]]), function(isc) {
            i=which(ir2isc[[iexp]]==isc+nb_sc_base[iexp]+1+nb_ff)
            ipaire <<- rbind(ipaire, cbind(i, isc+nb_sc_base[iexp]))
            return(NULL)
         })
         nb_f$is2m[[iexp]]=ipaire
         # place holder for scale part of jacobian
         jx_f$dr_dsc[[iexp]]=simple_triplet_zero_matrix(nrow=length(ir2isc[[iexp]]), ncol=nb_sc_tot)
      }
   }
}
# prepare measmat indexes and values : ir, ic, val

ind_mema=matrix(c(
1, 234, 1, 1, 11, -1, 1, 18, -1,
2, 11, 1, 2, 234, -1,
3, 18, 1, 3, 234, -1,
4, 234, 1,
5, 28, 1, 5, 453, 3, 5, 393, 3, 5, 359, 3, 5, 198, -2, 5, 182, -2, 5, 105, -2, 5, 565, -4, 5, 9, 1, 5, 357, 3, 5, 194, -2, 5, 233, -2, 5, 38, 1, 5, 181, -2, 5, 17, 1,
6, 198, 1, 6, 565, 6, 6, 453, -3, 6, 393, -3, 6, 182, 1, 6, 359, -3, 6, 194, 1, 6, 357, -3, 6, 105, 1, 6, 233, 1, 6, 181, 1,
7, 453, 1, 7, 565, -4, 7, 393, 1, 7, 359, 1, 7, 357, 1,
8, 565, 1,
9, 219, 1, 9, 175, 1, 9, 117, 1, 9, 62, -1, 9, 55, -1, 9, 31, -1, 9, 422, -1,
10, 62, 1, 10, 422, 3, 10, 219, -2, 10, 175, -2, 10, 55, 1, 10, 117, -2, 10, 31, 1,
11, 219, 1, 11, 422, -3, 11, 175, 1, 11, 117, 1,
12, 422, 1,
13, 128, 1, 13, 189, 1, 13, 235, 1, 13, 41, -1, 13, 3, -1, 13, 50, -1, 13, 329, -1,
14, 41, 1, 14, 329, 3, 14, 128, -2, 14, 189, -2, 14, 3, 1, 14, 235, -2, 14, 50, 1,
15, 128, 1, 15, 329, -3, 15, 189, 1, 15, 235, 1,
16, 329, 1,
17, 236, 1, 17, 136, 1, 17, 103, 1, 17, 184, 1, 17, 127, 1, 17, 132, 1, 17, 583, 1, 17, 157, 1, 17, 201, 1, 17, 141, 1, 17, 526, 1, 17, 183, 1, 17, 553, 1, 17, 572, 1, 17, 629, 1, 17, 174, 1, 17, 102, 1, 17, 124, 1, 17, 603, 1, 17, 159, 1, 17, 573, 1, 17, 548, 1, 17, 604, 1, 17, 191, 1, 17, 612, 1, 17, 520, 1, 17, 631, 1, 17, 591, 1, 17, 590, 1, 17, 510, 1, 17, 721, 1, 17, 53, -1, 17, 59, -1, 17, 34, -1, 17, 414, -1, 17, 48, -1, 17, 315, -1, 17, 429, -1, 17, 376, -1, 17, 58, -1, 17, 341, -1, 17, 333, -1, 17, 337, -1, 17, 310, -1, 17, 343, -1, 17, 314, -1, 17, 670, -1, 17, 39, -1, 17, 324, -1, 17, 355, -1, 17, 445, -1, 17, 411, -1, 17, 383, -1, 17, 307, -1, 17, 688, -1, 17, 319, -1, 17, 349, -1, 17, 450, -1, 17, 687, -1, 17, 320, -1, 17, 674, -1, 17, 669, -1, 17, 685, -1,
18, 53, 1, 18, 414, 3, 18, 315, 3, 18, 429, 3, 18, 341, 3, 18, 333, 3, 18, 310, 3, 18, 670, 5, 18, 324, 3, 18, 355, 3, 18, 411, 3, 18, 688, 5, 18, 319, 3, 18, 687, 5, 18, 674, 5, 18, 669, 5, 18, 236, -2, 18, 136, -2, 18, 184, -2, 18, 583, -4, 18, 157, -2, 18, 526, -4, 18, 553, -4, 18, 572, -4, 18, 174, -2, 18, 603, -4, 18, 573, -4, 18, 548, -4, 18, 612, -4, 18, 520, -4, 18, 591, -4, 18, 721, -6, 18, 59, 1, 18, 376, 3, 18, 337, 3, 18, 343, 3, 18, 445, 3, 18, 383, 3, 18, 349, 3, 18, 685, 5, 18, 103, -2, 18, 127, -2, 18, 201, -2, 18, 629, -4, 18, 102, -2, 18, 604, -4, 18, 631, -4, 18, 590, -4, 18, 34, 1, 18, 314, 3, 18, 307, 3, 18, 450, 3, 18, 132, -2, 18, 141, -2, 18, 124, -2, 18, 510, -4, 18, 48, 1, 18, 320, 3, 18, 183, -2, 18, 159, -2, 18, 58, 1, 18, 191, -2, 18, 39, 1,
19, 236, 1, 19, 583, 6, 19, 526, 6, 19, 553, 6, 19, 603, 6, 19, 573, 6, 19, 612, 6, 19, 721, 15, 19, 414, -3, 19, 315, -3, 19, 341, -3, 19, 670, -10, 19, 324, -3, 19, 688, -10, 19, 687, -10, 19, 674, -10, 19, 136, 1, 19, 572, 6, 19, 548, 6, 19, 520, 6, 19, 429, -3, 19, 333, -3, 19, 355, -3, 19, 669, -10, 19, 103, 1, 19, 629, 6, 19, 604, 6, 19, 631, 6, 19, 376, -3, 19, 337, -3, 19, 445, -3, 19, 685, -10, 19, 184, 1, 19, 591, 6, 19, 310, -3, 19, 411, -3, 19, 127, 1, 19, 590, 6, 19, 343, -3, 19, 383, -3, 19, 132, 1, 19, 510, 6, 19, 314, -3, 19, 307, -3, 19, 157, 1, 19, 319, -3, 19, 201, 1, 19, 349, -3, 19, 141, 1, 19, 450, -3, 19, 183, 1, 19, 320, -3, 19, 174, 1, 19, 102, 1, 19, 124, 1, 19, 159, 1, 19, 191, 1,
20, 414, 1, 20, 670, 10, 20, 688, 10, 20, 687, 10, 20, 583, -4, 20, 526, -4, 20, 603, -4, 20, 721, -20, 20, 315, 1, 20, 674, 10, 20, 553, -4, 20, 573, -4, 20, 429, 1, 20, 669, 10, 20, 572, -4, 20, 548, -4, 20, 376, 1, 20, 685, 10, 20, 629, -4, 20, 604, -4, 20, 341, 1, 20, 612, -4, 20, 333, 1, 20, 520, -4, 20, 337, 1, 20, 631, -4, 20, 310, 1, 20, 591, -4, 20, 343, 1, 20, 590, -4, 20, 314, 1, 20, 510, -4, 20, 324, 1, 20, 355, 1, 20, 445, 1, 20, 411, 1, 20, 383, 1, 20, 307, 1, 20, 319, 1, 20, 349, 1, 20, 450, 1, 20, 320, 1,
21, 583, 1, 21, 721, 15, 21, 670, -5, 21, 688, -5, 21, 526, 1, 21, 687, -5, 21, 553, 1, 21, 674, -5, 21, 572, 1, 21, 669, -5, 21, 629, 1, 21, 685, -5, 21, 603, 1, 21, 573, 1, 21, 548, 1, 21, 604, 1, 21, 612, 1, 21, 520, 1, 21, 631, 1, 21, 591, 1, 21, 590, 1, 21, 510, 1,
22, 670, 1, 22, 721, -6, 22, 688, 1, 22, 687, 1, 22, 674, 1, 22, 669, 1, 22, 685, 1,
23, 721, 1,
24, 185, 1, 24, 125, 1, 24, 180, 1, 24, 204, 1, 24, 131, 1, 24, 195, 1, 24, 605, 1, 24, 206, 1, 24, 111, 1, 24, 229, 1, 24, 535, 1, 24, 107, 1, 24, 579, 1, 24, 601, 1, 24, 610, 1, 24, 228, 1, 24, 153, 1, 24, 209, 1, 24, 537, 1, 24, 114, 1, 24, 626, 1, 24, 561, 1, 24, 615, 1, 24, 164, 1, 24, 622, 1, 24, 508, 1, 24, 542, 1, 24, 614, 1, 24, 529, 1, 24, 630, 1, 24, 718, 1, 24, 190, 1, 24, 221, 1, 24, 123, 1, 24, 595, 1, 24, 150, 1, 24, 623, 1, 24, 585, 1, 24, 539, 1, 24, 220, 1, 24, 557, 1, 24, 608, 1, 24, 616, 1, 24, 633, 1, 24, 580, 1, 24, 564, 1, 24, 724, 1, 24, 230, 1, 24, 592, 1, 24, 523, 1, 24, 511, 1, 24, 599, 1, 24, 530, 1, 24, 528, 1, 24, 722, 1, 24, 522, 1, 24, 563, 1, 24, 551, 1, 24, 719, 1, 24, 518, 1, 24, 726, 1, 24, 727, 1, 24, 729, 1, 24, 54, -1, 24, 25, -1, 24, 64, -1, 24, 397, -1, 24, 43, -1, 24, 331, -1, 24, 441, -1, 24, 403, -1, 24, 51, -1, 24, 407, -1, 24, 412, -1, 24, 364, -1, 24, 311, -1, 24, 400, -1, 24, 327, -1, 24, 661, -1, 24, 19, -1, 24, 419, -1, 24, 306, -1, 24, 325, -1, 24, 348, -1, 24, 350, -1, 24, 439, -1, 24, 694, -1, 24, 368, -1, 24, 459, -1, 24, 363, -1, 24, 706, -1, 24, 421, -1, 24, 675, -1, 24, 673, -1, 24, 666, -1, 24, 4, -1, 24, 385, -1, 24, 452, -1, 24, 308, -1, 24, 323, -1, 24, 446, -1, 24, 426, -1, 24, 664, -1, 24, 409, -1, 24, 366, -1, 24, 458, -1, 24, 659, -1, 24, 447, -1, 24, 676, -1, 24, 667, -1, 24, 695, -1, 24, 380, -1, 24, 454, -1, 24, 369, -1, 24, 691, -1, 24, 338, -1, 24, 704, -1, 24, 663, -1, 24, 662, -1, 24, 390, -1, 24, 709, -1, 24, 698, -1, 24, 672, -1, 24, 679, -1, 24, 671, -1, 24, 693, -1, 24, 731, -1,
25, 54, 1, 25, 397, 3, 25, 331, 3, 25, 441, 3, 25, 407, 3, 25, 412, 3, 25, 311, 3, 25, 661, 5, 25, 419, 3, 25, 306, 3, 25, 348, 3, 25, 694, 5, 25, 368, 3, 25, 706, 5, 25, 675, 5, 25, 673, 5, 25, 385, 3, 25, 452, 3, 25, 323, 3, 25, 664, 5, 25, 409, 3, 25, 659, 5, 25, 676, 5, 25, 667, 5, 25, 380, 3, 25, 691, 5, 25, 704, 5, 25, 663, 5, 25, 709, 5, 25, 698, 5, 25, 679, 5, 25, 731, 7, 25, 185, -2, 25, 125, -2, 25, 204, -2, 25, 605, -4, 25, 206, -2, 25, 535, -4, 25, 579, -4, 25, 601, -4, 25, 228, -2, 25, 537, -4, 25, 626, -4, 25, 561, -4, 25, 622, -4, 25, 508, -4, 25, 614, -4, 25, 718, -6, 25, 190, -2, 25, 595, -4, 25, 623, -4, 25, 585, -4, 25, 557, -4, 25, 608, -4, 25, 633, -4, 25, 724, -6, 25, 592, -4, 25, 523, -4, 25, 599, -4, 25, 722, -6, 25, 522, -4, 25, 719, -6, 25, 726, -6, 25, 727, -6, 25, 25, 1, 25, 403, 3, 25, 364, 3, 25, 400, 3, 25, 325, 3, 25, 350, 3, 25, 459, 3, 25, 666, 5, 25, 308, 3, 25, 446, 3, 25, 366, 3, 25, 695, 5, 25, 454, 3, 25, 662, 5, 25, 672, 5, 25, 671, 5, 25, 180, -2, 25, 131, -2, 25, 111, -2, 25, 610, -4, 25, 153, -2, 25, 615, -4, 25, 542, -4, 25, 529, -4, 25, 221, -2, 25, 539, -4, 25, 616, -4, 25, 580, -4, 25, 511, -4, 25, 530, -4, 25, 563, -4, 25, 729, -6, 25, 64, 1, 25, 327, 3, 25, 439, 3, 25, 363, 3, 25, 426, 3, 25, 458, 3, 25, 369, 3, 25, 693, 5, 25, 195, -2, 25, 229, -2, 25, 209, -2, 25, 630, -4, 25, 123, -2, 25, 564, -4, 25, 528, -4, 25, 551, -4, 25, 43, 1, 25, 421, 3, 25, 447, 3, 25, 338, 3, 25, 107, -2, 25, 114, -2, 25, 150, -2, 25, 518, -4, 25, 51, 1, 25, 390, 3, 25, 164, -2, 25, 220, -2, 25, 19, 1, 25, 230, -2, 25, 4, 1,
26, 185, 1, 26, 605, 6, 26, 535, 6, 26, 579, 6, 26, 537, 6, 26, 626, 6, 26, 622, 6, 26, 718, 15, 26, 595, 6, 26, 623, 6, 26, 557, 6, 26, 724, 15, 26, 592, 6, 26, 722, 15, 26, 719, 15, 26, 726, 15, 26, 397, -3, 26, 331, -3, 26, 407, -3, 26, 661, -10, 26, 419, -3, 26, 694, -10, 26, 706, -10, 26, 675, -10, 26, 385, -3, 26, 664, -10, 26, 659, -10, 26, 676, -10, 26, 691, -10, 26, 704, -10, 26, 709, -10, 26, 731, -21, 26, 125, 1, 26, 601, 6, 26, 561, 6, 26, 508, 6, 26, 585, 6, 26, 608, 6, 26, 523, 6, 26, 727, 15, 26, 441, -3, 26, 412, -3, 26, 306, -3, 26, 673, -10, 26, 452, -3, 26, 667, -10, 26, 663, -10, 26, 698, -10, 26, 180, 1, 26, 610, 6, 26, 615, 6, 26, 542, 6, 26, 539, 6, 26, 616, 6, 26, 511, 6, 26, 729, 15, 26, 403, -3, 26, 364, -3, 26, 325, -3, 26, 666, -10, 26, 308, -3, 26, 695, -10, 26, 662, -10, 26, 672, -10, 26, 204, 1, 26, 614, 6, 26, 633, 6, 26, 599, 6, 26, 311, -3, 26, 348, -3, 26, 323, -3, 26, 679, -10, 26, 131, 1, 26, 529, 6, 26, 580, 6, 26, 530, 6, 26, 400, -3, 26, 350, -3, 26, 446, -3, 26, 671, -10, 26, 195, 1, 26, 630, 6, 26, 564, 6, 26, 528, 6, 26, 327, -3, 26, 439, -3, 26, 426, -3, 26, 693, -10, 26, 206, 1, 26, 522, 6, 26, 368, -3, 26, 409, -3, 26, 111, 1, 26, 563, 6, 26, 459, -3, 26, 366, -3, 26, 229, 1, 26, 551, 6, 26, 363, -3, 26, 458, -3, 26, 107, 1, 26, 518, 6, 26, 421, -3, 26, 447, -3, 26, 228, 1, 26, 380, -3, 26, 153, 1, 26, 454, -3, 26, 209, 1, 26, 369, -3, 26, 114, 1, 26, 338, -3, 26, 164, 1, 26, 390, -3, 26, 190, 1, 26, 221, 1, 26, 123, 1, 26, 150, 1, 26, 220, 1, 26, 230, 1,
27, 397, 1, 27, 661, 10, 27, 694, 10, 27, 706, 10, 27, 664, 10, 27, 659, 10, 27, 691, 10, 27, 731, 35, 27, 605, -4, 27, 535, -4, 27, 537, -4, 27, 718, -20, 27, 595, -4, 27, 724, -20, 27, 722, -20, 27, 719, -20, 27, 331, 1, 27, 675, 10, 27, 676, 10, 27, 704, 10, 27, 579, -4, 27, 626, -4, 27, 623, -4, 27, 726, -20, 27, 441, 1, 27, 673, 10, 27, 667, 10, 27, 663, 10, 27, 601, -4, 27, 561, -4, 27, 585, -4, 27, 727, -20, 27, 403, 1, 27, 666, 10, 27, 695, 10, 27, 662, 10, 27, 610, -4, 27, 615, -4, 27, 539, -4, 27, 729, -20, 27, 407, 1, 27, 709, 10, 27, 622, -4, 27, 557, -4, 27, 412, 1, 27, 698, 10, 27, 508, -4, 27, 608, -4, 27, 364, 1, 27, 672, 10, 27, 542, -4, 27, 616, -4, 27, 311, 1, 27, 679, 10, 27, 614, -4, 27, 633, -4, 27, 400, 1, 27, 671, 10, 27, 529, -4, 27, 580, -4, 27, 327, 1, 27, 693, 10, 27, 630, -4, 27, 564, -4, 27, 419, 1, 27, 592, -4, 27, 306, 1, 27, 523, -4, 27, 325, 1, 27, 511, -4, 27, 348, 1, 27, 599, -4, 27, 350, 1, 27, 530, -4, 27, 439, 1, 27, 528, -4, 27, 368, 1, 27, 522, -4, 27, 459, 1, 27, 563, -4, 27, 363, 1, 27, 551, -4, 27, 421, 1, 27, 518, -4, 27, 385, 1, 27, 452, 1, 27, 308, 1, 27, 323, 1, 27, 446, 1, 27, 426, 1, 27, 409, 1, 27, 366, 1, 27, 458, 1, 27, 447, 1, 27, 380, 1, 27, 454, 1, 27, 369, 1, 27, 338, 1, 27, 390, 1,
28, 605, 1, 28, 718, 15, 28, 724, 15, 28, 722, 15, 28, 661, -5, 28, 694, -5, 28, 664, -5, 28, 731, -35, 28, 535, 1, 28, 719, 15, 28, 706, -5, 28, 659, -5, 28, 579, 1, 28, 726, 15, 28, 675, -5, 28, 676, -5, 28, 601, 1, 28, 727, 15, 28, 673, -5, 28, 667, -5, 28, 610, 1, 28, 729, 15, 28, 666, -5, 28, 695, -5, 28, 537, 1, 28, 691, -5, 28, 626, 1, 28, 704, -5, 28, 561, 1, 28, 663, -5, 28, 615, 1, 28, 662, -5, 28, 622, 1, 28, 709, -5, 28, 508, 1, 28, 698, -5, 28, 542, 1, 28, 672, -5, 28, 614, 1, 28, 679, -5, 28, 529, 1, 28, 671, -5, 28, 630, 1, 28, 693, -5, 28, 595, 1, 28, 623, 1, 28, 585, 1, 28, 539, 1, 28, 557, 1, 28, 608, 1, 28, 616, 1, 28, 633, 1, 28, 580, 1, 28, 564, 1, 28, 592, 1, 28, 523, 1, 28, 511, 1, 28, 599, 1, 28, 530, 1, 28, 528, 1, 28, 522, 1, 28, 563, 1, 28, 551, 1, 28, 518, 1,
29, 661, 1, 29, 731, 21, 29, 718, -6, 29, 724, -6, 29, 694, 1, 29, 722, -6, 29, 706, 1, 29, 719, -6, 29, 675, 1, 29, 726, -6, 29, 673, 1, 29, 727, -6, 29, 666, 1, 29, 729, -6, 29, 664, 1, 29, 659, 1, 29, 676, 1, 29, 667, 1, 29, 695, 1, 29, 691, 1, 29, 704, 1, 29, 663, 1, 29, 662, 1, 29, 709, 1, 29, 698, 1, 29, 672, 1, 29, 679, 1, 29, 671, 1, 29, 693, 1,
30, 718, 1, 30, 731, -7, 30, 724, 1, 30, 722, 1, 30, 719, 1, 30, 726, 1, 30, 727, 1, 30, 729, 1,
31, 731, 1,
32, 163, 1, 32, 218, 1, 32, 176, 1, 32, 167, 1, 32, 161, 1, 32, 109, 1, 32, 512, 1, 32, 112, 1, 32, 168, 1, 32, 138, 1, 32, 545, 1, 32, 238, 1, 32, 589, 1, 32, 509, 1, 32, 597, 1, 32, 143, 1, 32, 179, 1, 32, 193, 1, 32, 525, 1, 32, 144, 1, 32, 533, 1, 32, 514, 1, 32, 598, 1, 32, 173, 1, 32, 568, 1, 32, 547, 1, 32, 628, 1, 32, 515, 1, 32, 611, 1, 32, 516, 1, 32, 723, 1, 32, 56, -1, 32, 29, -1, 32, 7, -1, 32, 335, -1, 32, 57, -1, 32, 384, -1, 32, 435, -1, 32, 460, -1, 32, 52, -1, 32, 387, -1, 32, 344, -1, 32, 394, -1, 32, 442, -1, 32, 328, -1, 32, 372, -1, 32, 678, -1, 32, 8, -1, 32, 437, -1, 32, 339, -1, 32, 430, -1, 32, 296, -1, 32, 402, -1, 32, 316, -1, 32, 705, -1, 32, 408, -1, 32, 303, -1, 32, 431, -1, 32, 696, -1, 32, 295, -1, 32, 708, -1, 32, 657, -1, 32, 677, -1,
33, 56, 1, 33, 335, 3, 33, 384, 3, 33, 435, 3, 33, 387, 3, 33, 344, 3, 33, 442, 3, 33, 678, 5, 33, 437, 3, 33, 339, 3, 33, 296, 3, 33, 705, 5, 33, 408, 3, 33, 696, 5, 33, 708, 5, 33, 657, 5, 33, 163, -2, 33, 218, -2, 33, 167, -2, 33, 512, -4, 33, 112, -2, 33, 545, -4, 33, 589, -4, 33, 509, -4, 33, 143, -2, 33, 525, -4, 33, 533, -4, 33, 514, -4, 33, 568, -4, 33, 547, -4, 33, 515, -4, 33, 723, -6, 33, 29, 1, 33, 460, 3, 33, 394, 3, 33, 328, 3, 33, 430, 3, 33, 402, 3, 33, 303, 3, 33, 677, 5, 33, 176, -2, 33, 161, -2, 33, 168, -2, 33, 597, -4, 33, 179, -2, 33, 598, -4, 33, 628, -4, 33, 611, -4, 33, 7, 1, 33, 372, 3, 33, 316, 3, 33, 431, 3, 33, 109, -2, 33, 138, -2, 33, 193, -2, 33, 516, -4, 33, 57, 1, 33, 295, 3, 33, 238, -2, 33, 144, -2, 33, 52, 1, 33, 173, -2, 33, 8, 1,
34, 163, 1, 34, 512, 6, 34, 545, 6, 34, 589, 6, 34, 525, 6, 34, 533, 6, 34, 568, 6, 34, 723, 15, 34, 335, -3, 34, 384, -3, 34, 387, -3, 34, 678, -10, 34, 437, -3, 34, 705, -10, 34, 696, -10, 34, 708, -10, 34, 218, 1, 34, 509, 6, 34, 514, 6, 34, 547, 6, 34, 435, -3, 34, 344, -3, 34, 339, -3, 34, 657, -10, 34, 176, 1, 34, 597, 6, 34, 598, 6, 34, 628, 6, 34, 460, -3, 34, 394, -3, 34, 430, -3, 34, 677, -10, 34, 167, 1, 34, 515, 6, 34, 442, -3, 34, 296, -3, 34, 161, 1, 34, 611, 6, 34, 328, -3, 34, 402, -3, 34, 109, 1, 34, 516, 6, 34, 372, -3, 34, 316, -3, 34, 112, 1, 34, 408, -3, 34, 168, 1, 34, 303, -3, 34, 138, 1, 34, 431, -3, 34, 238, 1, 34, 295, -3, 34, 143, 1, 34, 179, 1, 34, 193, 1, 34, 144, 1, 34, 173, 1,
35, 335, 1, 35, 678, 10, 35, 705, 10, 35, 696, 10, 35, 512, -4, 35, 545, -4, 35, 525, -4, 35, 723, -20, 35, 384, 1, 35, 708, 10, 35, 589, -4, 35, 533, -4, 35, 435, 1, 35, 657, 10, 35, 509, -4, 35, 514, -4, 35, 460, 1, 35, 677, 10, 35, 597, -4, 35, 598, -4, 35, 387, 1, 35, 568, -4, 35, 344, 1, 35, 547, -4, 35, 394, 1, 35, 628, -4, 35, 442, 1, 35, 515, -4, 35, 328, 1, 35, 611, -4, 35, 372, 1, 35, 516, -4, 35, 437, 1, 35, 339, 1, 35, 430, 1, 35, 296, 1, 35, 402, 1, 35, 316, 1, 35, 408, 1, 35, 303, 1, 35, 431, 1, 35, 295, 1,
36, 512, 1, 36, 723, 15, 36, 678, -5, 36, 705, -5, 36, 545, 1, 36, 696, -5, 36, 589, 1, 36, 708, -5, 36, 509, 1, 36, 657, -5, 36, 597, 1, 36, 677, -5, 36, 525, 1, 36, 533, 1, 36, 514, 1, 36, 598, 1, 36, 568, 1, 36, 547, 1, 36, 628, 1, 36, 515, 1, 36, 611, 1, 36, 516, 1,
37, 678, 1, 37, 723, -6, 37, 705, 1, 37, 696, 1, 37, 708, 1, 37, 657, 1, 37, 677, 1,
38, 723, 1,
39, 178, 1, 39, 139, 1, 39, 134, 1, 39, 211, 1, 39, 145, 1, 39, 177, 1, 39, 588, 1, 39, 135, 1, 39, 119, 1, 39, 148, 1, 39, 606, 1, 39, 166, 1, 39, 619, 1, 39, 578, 1, 39, 607, 1, 39, 10, -1, 39, 15, -1, 39, 14, -1, 39, 373, -1, 39, 46, -1, 39, 317, -1, 39, 457, -1, 39, 293, -1, 39, 23, -1, 39, 392, -1, 39, 415, -1, 39, 332, -1, 39, 395, -1, 39, 313, -1, 39, 360, -1, 39, 658, -1,
40, 237, 1, 40, 151, 1, 40, 121, 1, 40, 113, 1, 40, 196, 1, 40, 170, 1, 40, 618, 1, 40, 129, 1, 40, 162, 1, 40, 146, 1, 40, 570, 1, 40, 101, 1, 40, 558, 1, 40, 620, 1, 40, 609, 1, 40, 44, -1, 40, 13, -1, 40, 5, -1, 40, 301, -1, 40, 32, -1, 40, 438, -1, 40, 318, -1, 40, 388, -1, 40, 33, -1, 40, 434, -1, 40, 356, -1, 40, 322, -1, 40, 378, -1, 40, 391, -1, 40, 362, -1, 40, 701, -1,
41, 205, 1, 41, 152, 1, 41, 104, 1, 41, 225, 1, 41, 200, 1, 41, 100, 1, 41, 540, 1, 41, 130, 1, 41, 118, 1, 41, 192, 1, 41, 534, 1, 41, 227, 1, 41, 517, 1, 41, 531, 1, 41, 559, 1, 41, 42, -1, 41, 49, -1, 41, 21, -1, 41, 381, -1, 41, 60, -1, 41, 336, -1, 41, 461, -1, 41, 382, -1, 41, 1, -1, 41, 309, -1, 41, 305, -1, 41, 379, -1, 41, 351, -1, 41, 433, -1, 41, 451, -1, 41, 697, -1,
42, 10, 1, 42, 373, 3, 42, 317, 3, 42, 457, 3, 42, 392, 3, 42, 415, 3, 42, 395, 3, 42, 658, 5, 42, 178, -2, 42, 139, -2, 42, 211, -2, 42, 588, -4, 42, 135, -2, 42, 606, -4, 42, 619, -4, 42, 578, -4, 42, 15, 1, 42, 293, 3, 42, 332, 3, 42, 313, 3, 42, 134, -2, 42, 145, -2, 42, 119, -2, 42, 607, -4, 42, 14, 1, 42, 360, 3, 42, 177, -2, 42, 148, -2, 42, 46, 1, 42, 166, -2, 42, 23, 1,
43, 44, 1, 43, 301, 3, 43, 438, 3, 43, 318, 3, 43, 434, 3, 43, 356, 3, 43, 378, 3, 43, 701, 5, 43, 237, -2, 43, 151, -2, 43, 113, -2, 43, 618, -4, 43, 129, -2, 43, 570, -4, 43, 558, -4, 43, 620, -4, 43, 13, 1, 43, 388, 3, 43, 322, 3, 43, 391, 3, 43, 121, -2, 43, 196, -2, 43, 162, -2, 43, 609, -4, 43, 5, 1, 43, 362, 3, 43, 170, -2, 43, 146, -2, 43, 32, 1, 43, 101, -2, 43, 33, 1,
44, 42, 1, 44, 381, 3, 44, 336, 3, 44, 461, 3, 44, 309, 3, 44, 305, 3, 44, 351, 3, 44, 697, 5, 44, 205, -2, 44, 152, -2, 44, 225, -2, 44, 540, -4, 44, 130, -2, 44, 534, -4, 44, 517, -4, 44, 531, -4, 44, 49, 1, 44, 382, 3, 44, 379, 3, 44, 433, 3, 44, 104, -2, 44, 200, -2, 44, 118, -2, 44, 559, -4, 44, 21, 1, 44, 451, 3, 44, 100, -2, 44, 192, -2, 44, 60, 1, 44, 227, -2, 44, 1, 1,
45, 178, 1, 45, 588, 6, 45, 606, 6, 45, 619, 6, 45, 373, -3, 45, 317, -3, 45, 392, -3, 45, 658, -10, 45, 139, 1, 45, 578, 6, 45, 457, -3, 45, 415, -3, 45, 134, 1, 45, 607, 6, 45, 293, -3, 45, 332, -3, 45, 211, 1, 45, 395, -3, 45, 145, 1, 45, 313, -3, 45, 177, 1, 45, 360, -3, 45, 135, 1, 45, 119, 1, 45, 148, 1, 45, 166, 1,
46, 237, 1, 46, 618, 6, 46, 570, 6, 46, 558, 6, 46, 301, -3, 46, 438, -3, 46, 434, -3, 46, 701, -10, 46, 151, 1, 46, 620, 6, 46, 318, -3, 46, 356, -3, 46, 121, 1, 46, 609, 6, 46, 388, -3, 46, 322, -3, 46, 113, 1, 46, 378, -3, 46, 196, 1, 46, 391, -3, 46, 170, 1, 46, 362, -3, 46, 129, 1, 46, 162, 1, 46, 146, 1, 46, 101, 1,
47, 205, 1, 47, 540, 6, 47, 534, 6, 47, 517, 6, 47, 381, -3, 47, 336, -3, 47, 309, -3, 47, 697, -10, 47, 152, 1, 47, 531, 6, 47, 461, -3, 47, 305, -3, 47, 104, 1, 47, 559, 6, 47, 382, -3, 47, 379, -3, 47, 225, 1, 47, 351, -3, 47, 200, 1, 47, 433, -3, 47, 100, 1, 47, 451, -3, 47, 130, 1, 47, 118, 1, 47, 192, 1, 47, 227, 1,
48, 373, 1, 48, 658, 10, 48, 588, -4, 48, 606, -4, 48, 317, 1, 48, 619, -4, 48, 457, 1, 48, 578, -4, 48, 293, 1, 48, 607, -4, 48, 392, 1, 48, 415, 1, 48, 332, 1, 48, 395, 1, 48, 313, 1, 48, 360, 1,
49, 301, 1, 49, 701, 10, 49, 618, -4, 49, 570, -4, 49, 438, 1, 49, 558, -4, 49, 318, 1, 49, 620, -4, 49, 388, 1, 49, 609, -4, 49, 434, 1, 49, 356, 1, 49, 322, 1, 49, 378, 1, 49, 391, 1, 49, 362, 1,
50, 381, 1, 50, 697, 10, 50, 540, -4, 50, 534, -4, 50, 336, 1, 50, 517, -4, 50, 461, 1, 50, 531, -4, 50, 382, 1, 50, 559, -4, 50, 309, 1, 50, 305, 1, 50, 379, 1, 50, 351, 1, 50, 433, 1, 50, 451, 1,
51, 588, 1, 51, 658, -5, 51, 606, 1, 51, 619, 1, 51, 578, 1, 51, 607, 1,
52, 618, 1, 52, 701, -5, 52, 570, 1, 52, 558, 1, 52, 620, 1, 52, 609, 1,
53, 540, 1, 53, 697, -5, 53, 534, 1, 53, 517, 1, 53, 531, 1, 53, 559, 1,
54, 658, 1,
55, 701, 1,
56, 697, 1,
57, 116, 1, 57, 207, 1, 57, 171, 1, 57, 147, 1, 57, 165, 1, 57, 197, 1, 57, 524, 1, 57, 232, 1, 57, 223, 1, 57, 133, 1, 57, 556, 1, 57, 203, 1, 57, 587, 1, 57, 581, 1, 57, 632, 1, 57, 226, 1, 57, 214, 1, 57, 122, 1, 57, 519, 1, 57, 140, 1, 57, 617, 1, 57, 566, 1, 57, 596, 1, 57, 188, 1, 57, 593, 1, 57, 600, 1, 57, 549, 1, 57, 576, 1, 57, 550, 1, 57, 575, 1, 57, 725, 1, 57, 35, -1, 57, 24, -1, 57, 27, -1, 57, 443, -1, 57, 2, -1, 57, 358, -1, 57, 456, -1, 57, 425, -1, 57, 30, -1, 57, 449, -1, 57, 354, -1, 57, 365, -1, 57, 428, -1, 57, 304, -1, 57, 334, -1, 57, 681, -1, 57, 37, -1, 57, 440, -1, 57, 398, -1, 57, 347, -1, 57, 423, -1, 57, 345, -1, 57, 448, -1, 57, 686, -1, 57, 302, -1, 57, 399, -1, 57, 424, -1, 57, 703, -1, 57, 386, -1, 57, 689, -1, 57, 680, -1, 57, 690, -1,
58, 35, 1, 58, 443, 3, 58, 358, 3, 58, 456, 3, 58, 449, 3, 58, 354, 3, 58, 428, 3, 58, 681, 5, 58, 440, 3, 58, 398, 3, 58, 423, 3, 58, 686, 5, 58, 302, 3, 58, 703, 5, 58, 689, 5, 58, 680, 5, 58, 116, -2, 58, 207, -2, 58, 147, -2, 58, 524, -4, 58, 232, -2, 58, 556, -4, 58, 587, -4, 58, 581, -4, 58, 226, -2, 58, 519, -4, 58, 617, -4, 58, 566, -4, 58, 593, -4, 58, 600, -4, 58, 576, -4, 58, 725, -6, 58, 24, 1, 58, 425, 3, 58, 365, 3, 58, 304, 3, 58, 347, 3, 58, 345, 3, 58, 399, 3, 58, 690, 5, 58, 171, -2, 58, 165, -2, 58, 223, -2, 58, 632, -4, 58, 214, -2, 58, 596, -4, 58, 549, -4, 58, 550, -4, 58, 27, 1, 58, 334, 3, 58, 448, 3, 58, 424, 3, 58, 197, -2, 58, 133, -2, 58, 122, -2, 58, 575, -4, 58, 2, 1, 58, 386, 3, 58, 203, -2, 58, 140, -2, 58, 30, 1, 58, 188, -2, 58, 37, 1,
59, 116, 1, 59, 524, 6, 59, 556, 6, 59, 587, 6, 59, 519, 6, 59, 617, 6, 59, 593, 6, 59, 725, 15, 59, 443, -3, 59, 358, -3, 59, 449, -3, 59, 681, -10, 59, 440, -3, 59, 686, -10, 59, 703, -10, 59, 689, -10, 59, 207, 1, 59, 581, 6, 59, 566, 6, 59, 600, 6, 59, 456, -3, 59, 354, -3, 59, 398, -3, 59, 680, -10, 59, 171, 1, 59, 632, 6, 59, 596, 6, 59, 549, 6, 59, 425, -3, 59, 365, -3, 59, 347, -3, 59, 690, -10, 59, 147, 1, 59, 576, 6, 59, 428, -3, 59, 423, -3, 59, 165, 1, 59, 550, 6, 59, 304, -3, 59, 345, -3, 59, 197, 1, 59, 575, 6, 59, 334, -3, 59, 448, -3, 59, 232, 1, 59, 302, -3, 59, 223, 1, 59, 399, -3, 59, 133, 1, 59, 424, -3, 59, 203, 1, 59, 386, -3, 59, 226, 1, 59, 214, 1, 59, 122, 1, 59, 140, 1, 59, 188, 1,
60, 443, 1, 60, 681, 10, 60, 686, 10, 60, 703, 10, 60, 524, -4, 60, 556, -4, 60, 519, -4, 60, 725, -20, 60, 358, 1, 60, 689, 10, 60, 587, -4, 60, 617, -4, 60, 456, 1, 60, 680, 10, 60, 581, -4, 60, 566, -4, 60, 425, 1, 60, 690, 10, 60, 632, -4, 60, 596, -4, 60, 449, 1, 60, 593, -4, 60, 354, 1, 60, 600, -4, 60, 365, 1, 60, 549, -4, 60, 428, 1, 60, 576, -4, 60, 304, 1, 60, 550, -4, 60, 334, 1, 60, 575, -4, 60, 440, 1, 60, 398, 1, 60, 347, 1, 60, 423, 1, 60, 345, 1, 60, 448, 1, 60, 302, 1, 60, 399, 1, 60, 424, 1, 60, 386, 1,
61, 524, 1, 61, 725, 15, 61, 681, -5, 61, 686, -5, 61, 556, 1, 61, 703, -5, 61, 587, 1, 61, 689, -5, 61, 581, 1, 61, 680, -5, 61, 632, 1, 61, 690, -5, 61, 519, 1, 61, 617, 1, 61, 566, 1, 61, 596, 1, 61, 593, 1, 61, 600, 1, 61, 549, 1, 61, 576, 1, 61, 550, 1, 61, 575, 1,
62, 681, 1, 62, 725, -6, 62, 686, 1, 62, 703, 1, 62, 689, 1, 62, 680, 1, 62, 690, 1,
63, 725, 1,
64, 231, 1, 64, 216, 1, 64, 222, 1, 64, 199, 1, 64, 126, 1, 64, 186, 1, 64, 621, 1, 64, 217, 1, 64, 155, 1, 64, 212, 1, 64, 584, 1, 64, 215, 1, 64, 562, 1, 64, 536, 1, 64, 543, 1, 64, 224, 1, 64, 172, 1, 64, 115, 1, 64, 613, 1, 64, 156, 1, 64, 574, 1, 64, 567, 1, 64, 602, 1, 64, 202, 1, 64, 569, 1, 64, 552, 1, 64, 594, 1, 64, 546, 1, 64, 527, 1, 64, 555, 1, 64, 728, 1, 64, 6, -1, 64, 63, -1, 64, 47, -1, 64, 462, -1, 64, 45, -1, 64, 404, -1, 64, 432, -1, 64, 417, -1, 64, 22, -1, 64, 346, -1, 64, 427, -1, 64, 436, -1, 64, 406, -1, 64, 418, -1, 64, 367, -1, 64, 668, -1, 64, 61, -1, 64, 292, -1, 64, 321, -1, 64, 299, -1, 64, 410, -1, 64, 294, -1, 64, 389, -1, 64, 684, -1, 64, 377, -1, 64, 352, -1, 64, 300, -1, 64, 710, -1, 64, 312, -1, 64, 707, -1, 64, 699, -1, 64, 702, -1,
65, 6, 1, 65, 462, 3, 65, 404, 3, 65, 432, 3, 65, 346, 3, 65, 427, 3, 65, 406, 3, 65, 668, 5, 65, 292, 3, 65, 321, 3, 65, 410, 3, 65, 684, 5, 65, 377, 3, 65, 710, 5, 65, 707, 5, 65, 699, 5, 65, 231, -2, 65, 216, -2, 65, 199, -2, 65, 621, -4, 65, 217, -2, 65, 584, -4, 65, 562, -4, 65, 536, -4, 65, 224, -2, 65, 613, -4, 65, 574, -4, 65, 567, -4, 65, 569, -4, 65, 552, -4, 65, 546, -4, 65, 728, -6, 65, 63, 1, 65, 417, 3, 65, 436, 3, 65, 418, 3, 65, 299, 3, 65, 294, 3, 65, 352, 3, 65, 702, 5, 65, 222, -2, 65, 126, -2, 65, 155, -2, 65, 543, -4, 65, 172, -2, 65, 602, -4, 65, 594, -4, 65, 527, -4, 65, 47, 1, 65, 367, 3, 65, 389, 3, 65, 300, 3, 65, 186, -2, 65, 212, -2, 65, 115, -2, 65, 555, -4, 65, 45, 1, 65, 312, 3, 65, 215, -2, 65, 156, -2, 65, 22, 1, 65, 202, -2, 65, 61, 1,
66, 231, 1, 66, 621, 6, 66, 584, 6, 66, 562, 6, 66, 613, 6, 66, 574, 6, 66, 569, 6, 66, 728, 15, 66, 462, -3, 66, 404, -3, 66, 346, -3, 66, 668, -10, 66, 292, -3, 66, 684, -10, 66, 710, -10, 66, 707, -10, 66, 216, 1, 66, 536, 6, 66, 567, 6, 66, 552, 6, 66, 432, -3, 66, 427, -3, 66, 321, -3, 66, 699, -10, 66, 222, 1, 66, 543, 6, 66, 602, 6, 66, 594, 6, 66, 417, -3, 66, 436, -3, 66, 299, -3, 66, 702, -10, 66, 199, 1, 66, 546, 6, 66, 406, -3, 66, 410, -3, 66, 126, 1, 66, 527, 6, 66, 418, -3, 66, 294, -3, 66, 186, 1, 66, 555, 6, 66, 367, -3, 66, 389, -3, 66, 217, 1, 66, 377, -3, 66, 155, 1, 66, 352, -3, 66, 212, 1, 66, 300, -3, 66, 215, 1, 66, 312, -3, 66, 224, 1, 66, 172, 1, 66, 115, 1, 66, 156, 1, 66, 202, 1,
67, 462, 1, 67, 668, 10, 67, 684, 10, 67, 710, 10, 67, 621, -4, 67, 584, -4, 67, 613, -4, 67, 728, -20, 67, 404, 1, 67, 707, 10, 67, 562, -4, 67, 574, -4, 67, 432, 1, 67, 699, 10, 67, 536, -4, 67, 567, -4, 67, 417, 1, 67, 702, 10, 67, 543, -4, 67, 602, -4, 67, 346, 1, 67, 569, -4, 67, 427, 1, 67, 552, -4, 67, 436, 1, 67, 594, -4, 67, 406, 1, 67, 546, -4, 67, 418, 1, 67, 527, -4, 67, 367, 1, 67, 555, -4, 67, 292, 1, 67, 321, 1, 67, 299, 1, 67, 410, 1, 67, 294, 1, 67, 389, 1, 67, 377, 1, 67, 352, 1, 67, 300, 1, 67, 312, 1,
68, 621, 1, 68, 728, 15, 68, 668, -5, 68, 684, -5, 68, 584, 1, 68, 710, -5, 68, 562, 1, 68, 707, -5, 68, 536, 1, 68, 699, -5, 68, 543, 1, 68, 702, -5, 68, 613, 1, 68, 574, 1, 68, 567, 1, 68, 602, 1, 68, 569, 1, 68, 552, 1, 68, 594, 1, 68, 546, 1, 68, 527, 1, 68, 555, 1,
69, 668, 1, 69, 728, -6, 69, 684, 1, 69, 710, 1, 69, 707, 1, 69, 699, 1, 69, 702, 1,
70, 728, 1,
71, 36, 1, 71, 370, 3, 71, 340, 3, 71, 405, 3, 71, 342, 3, 71, 420, 3, 71, 330, 3, 71, 700, 5, 71, 374, 3, 71, 326, 3, 71, 444, 3, 71, 682, 5, 71, 416, 3, 71, 660, 5, 71, 683, 5, 71, 692, 5, 71, 106, -2, 71, 137, -2, 71, 110, -2, 71, 532, -4, 71, 120, -2, 71, 541, -4, 71, 538, -4, 71, 625, -4, 71, 160, -2, 71, 521, -4, 71, 624, -4, 71, 582, -4, 71, 513, -4, 71, 554, -4, 71, 560, -4, 71, 720, -6, 71, 16, 1, 71, 396, 3, 71, 361, 3, 71, 353, 3, 71, 375, 3, 71, 455, 3, 71, 298, 3, 71, 665, 5, 71, 149, -2, 71, 213, -2, 71, 208, -2, 71, 571, -4, 71, 108, -2, 71, 586, -4, 71, 627, -4, 71, 544, -4, 71, 40, 1, 71, 401, 3, 71, 297, 3, 71, 413, 3, 71, 154, -2, 71, 142, -2, 71, 210, -2, 71, 577, -4, 71, 26, 1, 71, 371, 3, 71, 187, -2, 71, 158, -2, 71, 12, 1, 71, 169, -2, 71, 20, 1,
72, 106, 1, 72, 532, 6, 72, 541, 6, 72, 538, 6, 72, 521, 6, 72, 624, 6, 72, 513, 6, 72, 720, 15, 72, 370, -3, 72, 340, -3, 72, 342, -3, 72, 700, -10, 72, 374, -3, 72, 682, -10, 72, 660, -10, 72, 683, -10, 72, 137, 1, 72, 625, 6, 72, 582, 6, 72, 554, 6, 72, 405, -3, 72, 420, -3, 72, 326, -3, 72, 692, -10, 72, 149, 1, 72, 571, 6, 72, 586, 6, 72, 627, 6, 72, 396, -3, 72, 361, -3, 72, 375, -3, 72, 665, -10, 72, 110, 1, 72, 560, 6, 72, 330, -3, 72, 444, -3, 72, 213, 1, 72, 544, 6, 72, 353, -3, 72, 455, -3, 72, 154, 1, 72, 577, 6, 72, 401, -3, 72, 297, -3, 72, 120, 1, 72, 416, -3, 72, 208, 1, 72, 298, -3, 72, 142, 1, 72, 413, -3, 72, 187, 1, 72, 371, -3, 72, 160, 1, 72, 108, 1, 72, 210, 1, 72, 158, 1, 72, 169, 1,
73, 370, 1, 73, 700, 10, 73, 682, 10, 73, 660, 10, 73, 532, -4, 73, 541, -4, 73, 521, -4, 73, 720, -20, 73, 340, 1, 73, 683, 10, 73, 538, -4, 73, 624, -4, 73, 405, 1, 73, 692, 10, 73, 625, -4, 73, 582, -4, 73, 396, 1, 73, 665, 10, 73, 571, -4, 73, 586, -4, 73, 342, 1, 73, 513, -4, 73, 420, 1, 73, 554, -4, 73, 361, 1, 73, 627, -4, 73, 330, 1, 73, 560, -4, 73, 353, 1, 73, 544, -4, 73, 401, 1, 73, 577, -4, 73, 374, 1, 73, 326, 1, 73, 375, 1, 73, 444, 1, 73, 455, 1, 73, 297, 1, 73, 416, 1, 73, 298, 1, 73, 413, 1, 73, 371, 1,
74, 532, 1, 74, 720, 15, 74, 700, -5, 74, 682, -5, 74, 541, 1, 74, 660, -5, 74, 538, 1, 74, 683, -5, 74, 625, 1, 74, 692, -5, 74, 571, 1, 74, 665, -5, 74, 521, 1, 74, 624, 1, 74, 582, 1, 74, 586, 1, 74, 513, 1, 74, 554, 1, 74, 627, 1, 74, 560, 1, 74, 544, 1, 74, 577, 1,
75, 700, 1, 75, 720, -6, 75, 682, 1, 75, 660, 1, 75, 683, 1, 75, 692, 1, 75, 665, 1,
76, 720, 1,

NULL), ncol=3, byrow=T); # close ind_mema creation
measmat[[1]][ind_mema[,1:2,drop=FALSE]]=ind_mema[,3]
memaone[[1]]=c(1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 1, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

pwe=ipwe=ip2ipwe=pool_factor=ijpwef=dp_ones=meas2sum=dpw_dpf=ipf_in_ppw=vector("list", nb_exp)
mets_in_res=vector("list", nb_exp)
for (iexp in seq_len(nb_exp)) {
   names(memaone[[iexp]])=nm_measmat[[iexp]]

   # prepare weights of label data for pooled metabs
   # prepare ipwe and ip2ipwe such that pwe[ipwe]=pool[ip2ipwe]
   # gives a good base for weight sum and normalization
   pwe[[iexp]]=double(nb_measmat[[iexp]])+1.
   mets_in_res[[iexp]]=sapply(nm_measmat[[iexp]], function(m) strsplit(m, ":")[[1L]][2L])
   for (po in names(ipooled[[iexp]])) {
      if (po == "ishort") next
      nm_sum=strsplit(po, ":")[[1L]][2L]
      mets=strsplit(nm_sum, "\\+")[[1L]]
      irpo=ipooled[[iexp]][[po]]
      ipwe[[iexp]]=c(ipwe[[iexp]], irpo) # where weighting is
      i=pmatch(mets, names(nm_poolf))
      if (any(!is.na(i))) {
         for (ir in i) {
            if (is.na(ir)) next
            ijpwef[[iexp]]=rbind(ijpwef[[iexp]], cbind(irpo, ir)) # where free pools matter
         }
      }
      ip2ipwe[[iexp]]=c(ip2ipwe[[iexp]], pmatch(mets, names(nm_poolall)))
      mets_in_res[[iexp]][irpo]=mets
   }
   # order ijpwef for sparse matrix ordering
   if (!is.null(ijpwef[[iexp]])) {
      o=order(ijpwef[[iexp]][,2L], ijpwef[[iexp]][,1L])
      ijpwef[[iexp]]=ijpwef[[iexp]][o,,drop=FALSE]
   }
   pool_factor[[iexp]]=as.factor(nm_measmat[[iexp]])
   # free pool in principal pool weight
   ipf_in_ppw[[iexp]]=apply(outer(mets_in_res[[iexp]], names(nm_poolf), "=="), 1, function(v) if(length(w <-which(v))) w else NA)
   ipf_in_ppw[[iexp]][is.na(ipf_in_ppw[[iexp]])]=0L
   dp_ones[[iexp]]=matrix(0., nb_measmat[[iexp]], nb_poolf)
   dp_ones[[iexp]][cbind(ipwe[[iexp]], ipf_in_ppw[[iexp]][ipwe[[iexp]]])]=1.
   
   # matrix for summing weighted measurements
   meas2sum[[iexp]]=simple_triplet_zero_matrix(length(ipooled[[iexp]]$ishort), nb_measmat[[iexp]])
   meas2sum[[iexp]][cbind(pmatch(nm_measmat[[iexp]], nm_measmat[[iexp]][ipooled[[iexp]]$ishort], dup=T),       seq_len(nb_measmat[[iexp]]))]=1.
   dimnames(meas2sum[[iexp]])=list(nm_meas[[iexp]], nm_measmat[[iexp]])
   
   # dpw_dpf - matrix for derivation of pool weights by free pools
   if (nb_poolf > 0L && length(ijpwef[[iexp]]) > 0) {
      # indeed, we'll have to do weight derivation by free pools
      dpw_dpf[[iexp]]=simple_triplet_zero_matrix(nb_measmat[[iexp]], nb_poolf)
      dpw_dpf[[iexp]][ijpwef[[iexp]]]=1.
   }
}


# prepare flux measurements
nm_fmn=nm_net[c("out_Ac")]
nm_list$fmn=nm_fmn
nb_fmn=length(nm_fmn)
nb_f$nb_fmn=nb_fmn

# measured values
fmn=c(0.497)

# SD for flux measurements
fmndev=c(0.04)
if (nb_fmn)
   names(fmndev)=names(fmn)=nm_fmn

# indices for measured fluxes
# fallnx[ifmn]=>fmn, here fallnx is complete net|xch flux vector
# combining unknown (dependent), free, constrainded and groth fluxes
ifmn=match(nm_fmn, nm_fallnx)

if (TIMEIT) {
   cat("ineq    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
# prepare mi matrix and li vector
# such that mi*fallnx>=li corresponds
# to the inequalities given in ftbl file
nb_ineq=6
mi=matrix(0., nrow=nb_ineq, ncol=nb_fallnx)
li=numeric(nb_ineq)
nm_i=c(c("n:0<=edd", "n:0<=gnd", "n:0<=zwf", "n:0<=ppc", "n:0<=idh", "n:0<=akgdh"), c())
dimnames(mi)=list(nm_i, nm_fallnx)
mi[1, nm_net[c("edd")]]=c(1.0)
li[1]=0
mi[2, nm_net[c("gnd")]]=c(1.0)
li[2]=0
mi[3, nm_net[c("zwf")]]=c(1.0)
li[3]=0
mi[4, nm_net[c("ppc")]]=c(1.0)
li[4]=0
mi[5, nm_net[c("idh")]]=c(1.0)
li[5]=0
mi[6, nm_net[c("akgdh")]]=c(1.0)
li[6]=0

# add standard limits on [df].xch [0;cupx]
nb_tmp=nrow(mi)
nb_fx=nb_flx+nb_ffx
if (nb_fx) {
   mi=rbind(mi, matrix(0, nrow=2*nb_fx, ncol=nb_fallnx))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, ">=0", sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, ">=0", sep=""))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, "<=", cupx, sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, "<=", cupx, sep=""))
   li=c(li, rep(0, nb_fx), rep(-cupx, nb_fx))
   mi[nb_tmp+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(1., nb_fx)
   mi[nb_tmp+nb_fx+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(-1., nb_fx)
}

nm_inout=grep("^[^c]\\.", nm_net[c("CO2upt", "out_Ac", "Rub5P_gr", "Xul5P_gr", "FruBP_gr", "bs_oaa", "Suc_gr", "bs_glc6P", "PEP_gr", "Mal_gr", "bs_pyr", "Gnt6P_gr", "Fru6P_gr", "Glucupt_U", "bs_DHAP", "bs_pep", "bs_e4p", "bs_accoa", "Glc6P_gr", "Glucupt_1", "out_co2", "bs_fru6P", "bs_pga", "Cit_gr", "bs_akg", "Rib5P_gr", "PGA_gr", "bs_rib5P")], v=T) # strip out constrained fluxes
nb_inout=length(nm_inout)
if (nb_inout > 0) {
   # add cinout low limits on inout net fluxes
   nb_tmp=nrow(mi)
   # explicit inequalities take precedence over generic ones
   # so eliminate inout fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_inout, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_inout[-i]
   } else {
      nm_tmp=nm_inout
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste("inout ", nm_tmp, ">=", cinout, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(cinout, len_tmp))
   }
}
if (clownr!=0.) {
   # add low limits on net >= clownr for not reversible reactions
   nb_tmp=nrow(mi)
   nm_tmp=nm_net[c("idh", "out_Ac", "Xul5P_gr", "bs_oaa", "akgdh", "Suc_gr", "PEP_gr", "Mal_gr", "bs_pyr", "Glucupt_U", "edd", "bs_pep", "bs_e4p", "bs_accoa", "Cit_gr", "bs_akg", "zwf", "PGA_gr", "bs_rib5P", "CO2upt", "Rub5P_gr", "FruBP_gr", "bs_glc6P", "Gnt6P_gr", "Fru6P_gr", "bs_DHAP", "Glc6P_gr", "Glucupt_1", "Glucupt", "out_co2", "bs_pga", "bs_fru6P", "citsynth", "gnd", "Rib5P_gr")]
   # explicit inequalities take precedence over generic ones
   # so eliminate notrev fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   # search for inout too
   nm_itmp=paste("inout ", nm_tmp, ">=", sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i, fix=T)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }

   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste(nm_tmp, ">=", clownr, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(clownr, len_tmp))
   }
}
nb_fn=nb_fln+nb_ffn
if (cupn != 0 && nb_fn > 0) {
   # add upper limits on [df].net <= cupn for net fluxes
   # explicit inequalities take precedence over generic ones
   # so eliminate net fluxes which are already in inequalities
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+>=", substring(nm_tmp, 5), sep="")
   i=sapply(seq(along=nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste(nm_tmp, "<=", cupn, sep=""))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(-1., len_tmp)
   }
}

nb_ineq=NROW(li);

dimnames(mi)=list(nm_i, nm_fallnx)
names(li)=nm_i
# prepare ui matrix and ci vector for optimisation
# ui%*%param-ci>=0
# it is composed of explicite inequalities from ftbl
# and permanent inequalities 0<=xch<=0.999 and scale>=0

# constraints such that ui%*%param-ci>=0
# first flux part
ui=mi%*%(md%*%invAfl%stm%p2bfl+mf)
mic=(md%*%invAfl%*%(c2bfl%stm%fc+cnst2bfl) + mc%*%fc)
ci=as.numeric(li-mi%*%mic)

# finaly, metab part
uip=matrix(0., 0, ncol=nb_poolf)
colnames(uip)=nm_poolf
cip=c()
# ind: irow, metab, coef, rhs, name
uip_ind=c(

)
if (length(uip_ind) > 0) {
   uip_ind=matrix(uip_ind, byrow=T, ncol=5L)
} else {
   uip_ind=matrix(0, 0L, 5L)
}
colnames(uip_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(uip_ind) > 0) {
   # rhs are summed up for the same irow by aggregate()
   irow=as.integer(uip_ind[,"irow"])
   cip=aggregate(as.double(uip_ind[,"rhs"]), by=list(irow), sum)[,"x"]
   for (i in seq_len(nrow(uip_ind))) {
      row=uip_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      uip[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(uip) > 0) {
      rownames(uip)=paste("m:", uip_ind[pmatch(seq_len(nrow(uip)), irow),"name"], sep="")
   }
}
names(cip)=rownames(uip)

#browser() # before null inequality removing
# remove all zero rows in ui (constrained fluxes with fixed values)
# find zero indexes
#print(dim(ui))
if (ncol(ui)) {
   zi=apply(ui,1,function(v){return(max(abs(v))<=1.e-14)})
} else {
   # remove all flux inequalities as there is no free fluxe
   zi=rep(TRUE, nrow(ui))
}

if (!all(ci[zi]<=1.e-10)) {
   cat("The following constant inequalities are not satisfied:\n", file=fcerr)
   cat(nm_i[zi][ci[zi]>1.e-10], sep="\n", file=fcerr)
   cat("They are simply ignored.\n", file=fcerr)
   #stop_mes("", file=fcerr)
}
ui=ui[!zi,,drop=FALSE]
ci=ci[!zi]
nm_i=nm_i[!zi]

# complete ui by zero columns corresponding to scale params
if (nb_sc_tot) {
   ui=cBind(as.matrix(ui), matrix(0., NROW(ui), nb_sc_tot))
   # complete ui by scales >=0
   ui=rBind(ui, cBind(matrix(0, nb_sc_tot, nb_ff), diag(1, nb_sc_tot)))
   ci=c(ci,rep(0., nb_sc_tot))
   nm_i=c(nm_i, paste(nm_par[nb_ff+seq_len(nb_sc_tot)], ">=0", sep=""))
   rownames(ui)=nm_i
   names(ci)=nm_i
}

# remove redundant inequalities
#browser()
nb_i=nrow(ui)
ired=c()
if (nb_i > 1L) {
   for (i in 1L:(nb_i-1L)) {
      nmref=nm_i[i]
      for (j in setdiff((i+1L):nb_i, ired)) {
         if (all(ui[j,]==ui[i,]) && ci[i]==ci[j]) {
            # redundancy
            cat("inequality '", nm_i[j], "' redundant with '", nmref, "' is removed.
", sep="", file=fclog)
            ired=c(ired, j)
         }
      }
   }
}
if (!is.null(ired)) {
   # remove all ired inequalities
   ui=ui[-ired,,drop=FALSE]
   ci=ci[-ired]
   nm_i=nm_i[-ired]
}

# metabolite equalities
ep=matrix(0., 0, ncol=nb_poolf)
cp=c()
colnames(ep)=nm_poolf
# ind: irow, metab, coef, rhs, name
ep_ind=c(

)
if (length(ep_ind) > 0) {
   ep_ind=matrix(ep_ind, byrow=T, ncol=5L)
} else {
   ep_ind=matrix(0, 0L, 5L)
}
colnames(ep_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(ep_ind) > 0) {
   # rhs are summed up for the same irow by aggregate
   irow=as.integer(ep_ind[,"irow"])
   cp=aggregate(as.double(ep_ind[,"rhs"]), by=list(irow))[,"x"]
   for (i in seq_len(nrow(ep_ind))) {
      row=ep_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      ep[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(ep) > 0) {
      rownames(ep)=paste("m:", ep_ind[pmatch(seq_len(nrow(ep)), irow),"name"], sep="")
   }
}
ep=as.matrix(ep)
names(cp)=rownames(ep)

nb_sys=list(
   reactions=list(
      reversible=18,
      non_reversible=35
   ),
   fluxes=list(
      free=15,
      dependent=26,
      constrained=43
   ),
   metabolites=list(
      input=3,
      output=25,
      intra=11
   ),
   measurements=list(
      flux=1,
      mass=60,
      peak=0,
      label=4,
      metab=10
   ),
   equations=list(
      equalities=3,
      inequalities=6
   ),
   label_variables=list(
      full=c(0,0,0,0,0,0,0),
      reduced_cumomers=c(99,192,216,149,61,13,1)
   ),
   parallel_experiments=1
)
if (sum(nb_sys$label_variables$full)==0) {
   nb_sys$label_variables$full=NULL
}
if (emu) {
   x=nb_sys$label_variables$reduced_cumomers
   nb_sys$label_variables$reduced_cumomers=NULL
   nb_sys$label_variables$emu=paste(x, "*", seq_len(length(x)), "=", x*seq_len(length(x)))
}

#browser()

# extend param vector by free pools
if (nb_poolf > 0) {
   param=c(param, poolf)
   nm_par=c(nm_par, nm_poolf)
   nb_param=length(param)
}
nm_list$par=nm_par

#browser()
if (nb_poolf > 0) {
   # extend inequalities ui, ci by uip, cip
   nb_row=nrow(ui)
   nb_col=ncol(ui)
   ui=cbind(ui, matrix (0., nrow=nb_row, ncol=nb_poolf)) # add 0-columns
   ui=rbind(ui, cbind(matrix(0., nrow(uip), ncol=nb_col), uip))
   ci=c(ci, cip)
   
   # extend inequalities ui, ci by cupp>= poolf >= clowp
   # but exclude metabolites that are individually set in the uip (FTBL)
   met_low=met_up=c()
   if (nrow(uip) > 0) {
      # number of non zero entries per row in uip
      i_nz=rowSums(abs(uip) != 0.)
      # number of positive coeffs for alone metabs (i.e. low limit is set)
      i_pos=colSums(uip[i_nz > 0,,drop=FALSE] > 0)
      met_low=nm_poolf[i_pos > 0]
      # number of negative coeffs for alone metabs (i.e. upper limit is set)
      i_neg=colSums(uip[i_nz > 0,,drop=FALSE] < 0)
      met_up=nm_poolf[i_neg > 0]
   }

   # add low limit
   nb_add=nb_poolf-length(met_low)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_low]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(1., nb_add)
      rownames(ui_add)=paste(nm_add, ">=", clowp, sep="")
      if (nrow(ui)) {
         ui=rbind(ui, ui_add)
      } else {
         ui=ui_add
      }
      ci=c(ci, rep(clowp, nb_add))
   }

   # add upper limit
   nb_add=nb_poolf-length(met_up)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_up]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(-1., nb_add)
      rownames(ui_add)=paste(nm_add, "<=", cupp, sep="")
      ui=rbind(ui, ui_add)
      ci=c(ci, rep(-cupp, nb_add))
   }

   nm_i=names(ci)=rownames(ui)
   colnames(ui)=nm_par
}
# extend the matrix of metabolite equalities
ep=cbind(matrix(0., nrow(ep), nb_param-nb_poolf), ep)
colnames(ep)=nm_par

# prepare metabolite pools measurements
nb_poolm=10
nb_f$nb_poolm=nb_poolm
nm_poolm=c("pm:Suc", "pm:Mal", "pm:PEP", "pm:PGA", "pm:Cit", "pm:Gnt6P", "pm:FruBP", "pm:Fru6P", "pm:Glc6P", "pm:Rub5P+Rib5P+Xul5P")
nm_list$poolm=nm_poolm

# measured values
vecpoolm=c(0.0014849826568155515, 0.0006054470296805187, 5.501298486110693e-05, 0.0005008619523631337, 0.001630397300073748, 0.00014480899018442714, 0.0004927839907571225, 0.00010006707551232429, 0.0004905098655004916, 0.00015517247228805515)
names(vecpoolm)=nm_poolm

# inverse of variance for pool measurements
poolmdev=c(0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
names(poolmdev)=nm_poolm

# simulated metabolite measurements are calculated as
# measmatpool*poolall=>poolm
measmatpool=matrix(0., nrow=nb_poolm, ncol=length(poolall))
dimnames(measmatpool)=list(nm_poolm, nm_poolall)
i=matrix(1+c(0, 9, 1, 5, 2, 6, 3, 7, 4, 0, 5, 4, 6, 2, 7, 1, 8, 3, 9, 8, 9, 11, 9, 10), ncol=2, byrow=T)
measmatpool[i]=1.


# gather all measurement information
measurements=list(
   vec=list(labeled=measvec, flux=fmn, pool=vecpoolm, kin=if (case_i) measvecti else NULL),
   dev=list(labeled=measdev, flux=fmndev, pool=poolmdev, kin=if (case_i) rep(measdev, nb_ti-1) else NULL),
   mat=list(labeled=measmat, flux=ifmn, pool=measmatpool),
   one=list(labeled=memaone)
)
nm_resid=c(if (case_i) unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, outer(nm_meas[[iexp]], ti[[iexp]][-1L], paste, sep=", t="), sep=":"))) else unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, nm_meas[[iexp]], sep=":"))), nm_fmn, nm_poolm)
nm_list$resid=nm_resid

if (TIMEIT) {
   cat("preopt  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
#browser()
names(param)=nm_par
# prepare series of starting points
if (nchar(fseries) > 0) {
   pstart=as.matrix(read.table(fseries, header=T, row.n=1, sep="\t"))
   # skip parameters (rows) who's name is not in nm_par
   i=rownames(pstart) %in% nm_par
   if (!any(i)) {
      stop_mes("Option --fseries is used but no free parameter with known name is found.\n")
   }
   pstart=pstart[i,,drop=FALSE]
   cat("Using starting values form '", fseries, "' for the following free parameters:\n", paste(rownames(pstart), collapse="\n"), "\n", sep="", file=fclog)
   nseries=ncol(pstart)
   if (initrand) {
      # fill the rest of rows with random values
      i=nm_par %in% rownames(pstart)
      n=sum(!i)
      pstart=rbind(pstart, matrix(runif(n*nseries), n, nseries))
      rownames(pstart)=c(rownames(pstart)[seq_len(nb_param-n)], nm_par[!i])
   }
   if (nchar(iseries) > 0) {
      iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
      iseries=iseries[iseries<=nseries]
      # subsample
      pstart=pstart[,iseries, drop=FALSE]
      nseries=ncol(pstart)
   } else {
      iseries=seq_len(nseries)
   }
} else if (nchar(iseries) > 0) {
   # first construct pstart then if needed fill it with random values
   # and only then subsample
   iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
   nseries=max(iseries)
   pstart=matrix(rep(param, nseries), nrow=nb_param, ncol=nseries)
   dimnames(pstart)=list(nm_par, paste("V", seq_len(nseries), sep=""))
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
   # subsample
   pstart=pstart[,iseries, drop=FALSE]
   nseries=ncol(pstart)
} else {
   iseries=1L
   pstart=as.matrix(param)
   nseries=1L
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
}
nm_pseries=rownames(pstart)

if (is.null(nseries) || nseries==0) {
   stop_mes(sprintf("No starting values in the series file '%s' or --iseries is empty.", fseries),  file=fcerr)
}

pres=matrix(NA, nb_param, nseries)
rownames(pres)=nm_par
colnames(pres)=colnames(pstart)
costres=rep.int(NA, nseries)

# prepare flux index conversion
ifwrv=1:nb_fwrv
names(ifwrv)=nm_fwrv
ifl_in_fw=if (nb_fln) ifwrv[paste("fwd", substring(c(nm_fln, nm_flx), 4), sep="")] else integer(0)
iff_in_fw=if (nb_ff > 0) ifwrv[paste("fwd", substring(c(nm_ffn, nm_ffx), 4), sep="")] else integer(0)
ifg_in_fw=if (nb_fgr > 0) ifwrv[paste("fwd", substring(nm_fgr, 4), sep="")] else integer(0)

# index couples for jacobian df_dfl, df_dffd
cfw_fl=crv_fl=cbind(ifl_in_fw, seq_len(nb_fl))
cfw_ff=crv_ff=cbind(iff_in_fw, seq_len(nb_ff))
cfw_fg=crv_fg=cbind(ifg_in_fw, nb_ff+seq_len(nb_fgr))
crv_fl[,1L]=(nb_fwrv/2)+crv_fl[,1L]
crv_ff[,1L]=(nb_fwrv/2)+crv_ff[,1L]
crv_fg[,1L]=(nb_fwrv/2)+crv_fg[,1L]

# store it in nb_f
nb_f=append(nb_f, list(cfw_fl=cfw_fl, crv_fl=crv_fl, cfw_ff=cfw_ff,
   crv_ff=crv_ff, cfw_fg=cfw_fg, crv_fg=crv_fg))
nb_f=as.environment(nb_f)

nbc_x=c(0, cumsum(nb_x))
nb_f$nbc_x=nbc_x

# fixed part of jacobian (unreduced by SD)
# measured fluxes
dufm_dp=cbind(dufm_dff(nb_f, nm_list), matrix(0, nrow=nb_fmn, ncol=nb_sc_tot+nb_poolf))
dimnames(dufm_dp)=list(nm_fmn, nm_par)

# measured pools
dupm_dp=matrix(0., nb_poolm, nb_ff+nb_sc_tot)
if (nb_poolf > 0L) {
   dupm_dp=cbind(dupm_dp, measurements$mat$pool[,nm_list$poolf, drop=FALSE])
}
dimnames(dupm_dp)=list(rownames(measurements$mat$pool), nm_par)

#browser()
# prepare argument list for passing to label simulating functions
nm_labargs=c("jx_f", "nb_f", "nm_list", "nb_x", "invAfl", "p2bfl", "g2bfl", "bp", "fc", "xi", "spa", "emu", "pool", "measurements", "ipooled", "ir2isc",  "nb_w", "nbc_x", "measmat", "memaone", "dufm_dp", "dupm_dp", "pwe", "ipwe", "ip2ipwe", "pool_factor", "ijpwef", "ipf_in_ppw", "meas2sum", "dp_ones", "clen", "dirr", "dirw", "baseshort", "case_i", "nb_exp", "noscale", "dpw_dpf")

if (TIMEIT) {
   cat("labargs : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
labargs=new.env()
tmp=lapply(nm_labargs, function(nm) assign(nm, get(nm), labargs))
#for (nm in nm_labargs) {
#   labargs[[nm]]=get(nm)
#}
labargs[["nm"]]=labargs[["nm_list"]]

# prepare labargs2 if time_order includes 2
if (case_i && (time_order == "2" || time_order == "1,2")) {
   labargs2=as.environment(as.list(labargs))
   labargs2$nb_f=as.environment(as.list(labargs$nb_f))
   labargs2$tifull=tifull2
   labargs2$jx_f=new.env()
   labargs2$nb_f$ipf2ircumo=nb_f$ipf2ircumo2
   labargs2$nb_f$tifu=nb_f$tifu2
   labargs[["labargs2"]]=labargs2
}

# formated output in kvh file
fkvh_saved=file.path(dirw, sprintf("%s_res.kvh", baseshort))

control_ftbl=list(maxit=50)

retcode=numeric(nseries)
cl_type="PSOCK"
cl=NULL
if ((case_i && (time_order %in% c("1,2", "2"))) || sensitive == "mc") {
   if (np > 1L) {
      # prepare cluster
      nodes=if (sensitive == "mc") np else 2

      # prepare cluster
      cl=makeCluster(nodes, cl_type) #, outfile="cl.log")
#cat("make cluster=")
#print(cl[[1]])
      labargs[["cl"]]=cl
      nodes=length(cl)
      if (TIMEIT) {
         cat("cl expor: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterExport(cl, c("lsi_fun", "df_dffp", "lab_sim", "is.diff", "lab_resid", "ui", "ci", "ep", "cp", "control_ftbl", "method", "sln", "labargs", "dirr", "emu", "%stm%", "case_i", "time_order"))
      if (TIMEIT) {
         cat("cl sourc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterEvalQ(cl, {
         #idth=myinfo$id
         suppressPackageStartupMessages(library(nnls))
         suppressPackageStartupMessages(library(slam)) # for quick sparse matrices
         suppressPackageStartupMessages(library(Rcpp))
         suppressPackageStartupMessages(library(RcppArmadillo))
         suppressPackageStartupMessages(library(rmumps))
         suppressPackageStartupMessages(library(arrApply)) # for fast apply() on arrays
         suppressPackageStartupMessages(library(multbxxc))
         compiler::enableJIT(0)
         source(file.path(dirr, "tools_ssg.R"))
         source(file.path(dirr, "nlsic.R"))
         source(file.path(dirr, "opt_cumo_tools.R"))
         source(file.path(dirr, "opt_icumo_tools.R"))
         #loadcmp(file.path(dirr, "tools_ssg.Rc"))
         #loadcmp(file.path(dirr, "nlsic.Rc"))
         #loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))
         #loadcmp(file.path(dirr, "opt_icumo_tools.Rc"))
         labargs$spa=sparse2spa(labargs$spa)
         if (case_i && (time_order == "2" || time_order == "1,2")) {
            labargs$labargs2$spa=labargs$spa
         }
#cat("evalQ idth=", idth, "\n")
#print(labargs)
#print(labargs$labargs2)
#print(labargs$spa)
#print(labargs$labargs2$spa)
         NULL
      })
      clusterSetRNGStream(cl)
      # set worker id
      idw=parLapply(cl, seq_along(cl), function(i) assign("idw", i, envir=.GlobalEnv))
   } else {
      labargs$cl=NULL
   }
}
for (irun in seq_len(nseries)) {
   if (TIMEIT) {
      cat(sprintf("run %4d: %s cpu=%g\n", irun, format(Sys.time()), proc.time()[1], "\n", sep=""), file=fclog)
   }
   param[nm_pseries]=pstart[nm_pseries, irun]
#browser()
   # prepare kvh file name
   if (nseries > 1) {
      runsuf="." %s+% colnames(pstart)[irun]
   } else {
      runsuf=""
   }
   if (length(nseries) > 0) {
      cat("Starting point", runsuf, "\n", sep="", file=fclog)
   }
   fkvh=file(substring(fkvh_saved, 1, nchar(fkvh_saved)-4) %s+% runsuf %s+% ".kvh", "w");

   # remove zc inequalities from previous runs
   izc=grep("^zc ", nm_i)
   if (length(izc)) {
      ui=ui[-izc,,drop=FALSE]
      ci=ci[-izc]
      nm_i=rownames(ui)
   }
   # check if initial approximation is feasible
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   if (any(ineq <= -1.e-10)) {
      cat("The following ", sum(ineq<= -1.e-10), " ineqalities are not respected at starting point", runsuf, ":\n", sep="", file=fclog)
      i=ineq[ineq<= -1.e-10]
      cat(paste(names(i), i, sep="\t", collapse="\n"), "\n", sep="", file=fclog)
      # put them inside
      capture.output(pinside <- put_inside(param, ui, ci), file=fclog)
      if (any(is.na(pinside))) {
         if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
            # fatal error occured
            cat("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n",
               file=fcerr, sep="")
            close(fkvh)
            retcode[irun]=attr(pinside, "err")
            next;
         }
      } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0) {
         # non fatal problem
         cat(paste("put_inside: ", attr(pinside, "mes"), collapse=""), "\n", file=fcerr)
      }
      param[]=pinside
   }

   # prepare zero crossing strategy
   # inequalities to keep sens of net flux on first call to opt_wrapper()
   # if active they are removed on the second call to opt_wrapper()
   # and finaly all zc constraints are relaxed on the last call to opt_wrapper()
   fallnx=param2fl(param, labargs)$fallnx
   mi_zc=NULL
   li_zc=NULL
   if (zerocross && length(grep("^[df]\\.n\\.", nm_fallnx))>0) {
      if (TIMEIT) {
         cat("zc ineq : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
#browser()
      # prepare fluxes that are already in inequalities in alone mode
      ige=names(which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==1) & li>=0))
      ige=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ige, v=T)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ige, v=T)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ige, v=T))
      ))]
      ile=which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==-1)&li>=0)
      ile=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ile, v=T)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ile, v=T)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ile, v=T))
      ))]
      # add lower limits on [df].net >= zc for positive net fluxes
      # and upper limits on [df].net <= -zc for negative net fluxes
      nm_izc=c()
      ipos=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]>=0.)), ige)
      ineg=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]<0.)), ile)
      mi_zc=matrix(0, nrow=length(ipos)+length(ineg), ncol=nb_fallnx)
      colnames(mi_zc)=nm_fallnx
      if (length(ipos)) {
         nm_izc=c(nm_izc, paste("zc ", ipos, ">=", zc, sep=""))
         mi_zc[(1:length(ipos)),ipos]=diag(1., length(ipos))
      }
      if (length(ineg)) {
         nm_izc=c(nm_izc, paste("zc ", ineg, "<=", -zc, sep=""))
         mi_zc[length(ipos)+(1:length(ineg)),ineg]=diag(-1., length(ineg))
      }
      rownames(mi_zc)=nm_izc
      li_zc=rep(zc, length(nm_izc)) # that's ok for both pos and neg constraints
      ui_zc=cbind(mi_zc%*%(md%*%invAfl%stm%p2bfl+mf),
         matrix(0., nrow=nrow(mi_zc), ncol=nb_sc_tot))
      if (nb_fgr > 0) {
         ui_zc=cbind(ui_zc, mi_zc%*%((md%*%invAfl%stm%g2bfl)+mg*nb_f$mu))
      } else if (nb_poolf > 0) {
         ui_zc=cbind(ui_zc, matrix(0., nrow=nrow(mi_zc), ncol=nb_poolf))
      }
      ci_zc=li_zc-mi_zc%*%mic
      # remove constant inequalities
      if (ncol(ui_zc)) {
         zi=apply(ui_zc,1,function(v){return(max(abs(v))<=1.e-14)})
      } else {
         # remove all flux inequalities as there is no free params
         zi=rep(TRUE, nrow(ui_zc))
      }

      inotsat=ci_zc[zi]>1.e-10
      if (any(inotsat)) {
         cat("Warning: The following constant zc inequalities are not satisfied:\n", file=fcerr)
         cat(nm_izc[zi][inotsat], sep="\n", file=fcerr)
      }
      ui_zc=ui_zc[!zi,,drop=FALSE]
      ci_zc=ci_zc[!zi]
      nm_izc=nm_izc[!zi]
      mi_zc=mi_zc[!zi,,drop=FALSE]

      # remove redundant/contradictory inequalities
      nb_zc=nrow(ui_zc)
      nb_i=nrow(ui)
      ired=c()
      tui=t(ui)
      uzcd=sapply(seq_len(nb_zc), function(i) apply(abs(tui-ui_zc[i,]), 2L, max))
      uzcs=sapply(seq_len(nb_zc), function(i) apply(abs(tui+ui_zc[i,]), 2L, max))
      czcd=abs(outer(abs(ci), abs(ci_zc), "-"))
      ired=which(apply((uzcd < 1.e-10 | uzcs < 1.e-10) & czcd <= 1.e-2, 2, any))
      
      if (length(ired) > 0L) {
         # remove all ired inequalities
         cat("The following ", length(ired), " zerocross inequalities are redundant and are removed:\n", paste(nm_izc[ired], collapse="\n"), "\n", sep="", file=fclog)
         ui_zc=ui_zc[-ired,,drop=FALSE]
         ci_zc=ci_zc[-ired]
         nm_izc=nm_izc[-ired]
         mi_zc=mi_zc[-ired,,drop=FALSE]
      }
      if (nrow(ui_zc)) {
         # add zc inequalities
         ui=rbind(ui, ui_zc)
         ci=c(ci, ci_zc)
         nm_i=c(nm_i, nm_izc)
      }
      rm(ui_zc, ci_zc, uzcd, uzcs, czcd)
   }
   rres=NULL

   # set initial scale values to sum(measvec*simlab/dev**2)/sum(simlab**2/dev**2)
   # for corresponding measurements
   if (nb_sc_tot > 0) {
      if (optimize) {
         if (TIMEIT) {
            cat("res esti: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         capture.output(rres <- lab_resid(param, cjac=FALSE, labargs), file=fclog)
         if (!is.null(rres$err) && rres$err) {
            cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
            close(fkvh)
            retcode[irun]=rres$err
            next
         }
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at init scale values)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         for (iexp in seq_len(nb_exp)) {
            simlab=jx_f$usimlab[[iexp]]
            measinvvar=1./measurements$dev$labeled[[iexp]]**2
            ms=measvec[[iexp]]*simlab*measinvvar
            ss=simlab*simlab*measinvvar
            # get only valid measurements
            iva=!is.na(ms)
            for (i in nb_ff+nb_sc_base[iexp]+seq_len(nb_sc[[iexp]])) {
               im=(ir2isc[[iexp]]==(i+1)) & iva
               if (sum(im) < 2) {
                  mes=sprintf("scaling: no sufficient valid data for scaling factor '%s'\n", nm_par[i])
                  stop_mes(mes, fcerr)
               }
               param[i]=sum(ms[im])/sum(ss[im])
            }
         }
      } else {
         # if no optimization, set all scaling params to 1.
         param[nb_ff+seq_len(nb_sc_tot)]=1.
      }
   }

   # see if there are any active inequalities at starting point
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   if (any(abs(ineq)<=1.e-10)) {
      cat("The following ", sum(abs(ineq)<=1.e-10), " ineqalitie(s) are active at starting point", runsuf, ":\n",
         paste(names(ineq[abs(ineq)<=1.e-10]), collapse="\n"), "\n", sep="", file=fclog)
   }

   if (TIMEIT) {
      cat("kvh init: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }

   cat("influx\n", file=fkvh)
   cat("\tversion\t", vernum, "\n", file=fkvh, sep="")
   cat("\tlabeling\t", if (case_i) "instationary" else "stationary", "\n", file=fkvh, sep="")
   # save options of command line
   cat("\truntime options\n", file=fkvh)
   cat("\t\tTIMEIT=TRUE\n", file=fkvh)
   
   obj2kvh(R.Version(), "R.Version", fkvh, indent=1)
   cat("\tR command line\n", file=fkvh)
   obj2kvh(opts, "opts", fkvh, indent=2)
   cat("\t\texecution date	", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fkvh)

   # resume system sizes
   obj2kvh(nb_sys, "system sizes", fkvh)

   # save initial param
   cat("starting point\n", file=fkvh)
   names(param)=nm_par
   obj2kvh(param, "starting free parameters", fkvh, indent=1)
#browser()
   if (!length(rres)) {
      capture.output(rres <- lab_resid(param, cjac=FALSE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
      if (sum(is.infinite(rres$res))) {
         cat("Infinite values appeared in residual vector (at starting point)", file=fcerr)
         retcode[irun]=1
         close(fkvh)
         next
      }
   }
   rcost=if (length(rres$res) && !all(ina <- is.na(rres$res))) sum(crossprod(rres$res[!ina])) else NA
   obj2kvh(rcost, "starting cost value", fkvh, indent=1)

   obj2kvh(Afl, "flux system (Afl)", fkvh, indent=1)
   fg=numeric(nb_f$nb_fgr)
   names(fg)=nm_list$fgr
   if (nb_f$nb_fgr > 0) {
      fg[paste("g.n.", substring(nm_list$poolf, 4), "_gr", sep="")]=nb_f$mu*param[nm_list$poolf]
   }
   btmp=as.numeric(p2bfl%stm%param[seq_len(nb_f$nb_ff)]+bp+g2bfl%stm%fg)
   names(btmp)=dimnames(Afl)[[1]]
   obj2kvh(btmp, "flux system (bfl)", fkvh, indent=1)

   #cat("mass vector:\n", file=fclog)
   #print_mass(x)

   names(param)=nm_par

#browser()
   if (optimize && nb_ff+nb_poolf > 0L) {
      if (!(least_norm || sln || method!="nlsic")) {
         # check if at starting position all fluxes can be resolved
         if (TIMEIT) {
            cat("check ja: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         rres=lab_resid(param, cjac=TRUE, labargs)
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at identifiability check)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         if (sum(is.infinite(rres$jacobian))) {
            cat("Infinite values appeared in Jacobian (at identifiability check)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         qrj=qr(jx_f$dr_dff, LAPACK=T)
         d=diag(qrj$qr)
         qrj$rank=sum(abs(d)>abs(d[1])*1.e-10)
         if (is.na(qrj$rank)) {
            cat("Rank of starting jacobian could not be estimated.", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         if (qrj$rank) {
            nm_uns=nm_ff[qrj$pivot[-(1:qrj$rank)]]
         } else {
            nm_uns=nm_ff
         }
         if (qrj$rank < nb_ff) {
            # Too bad. The jacobian of free fluxes is not of full rank.
            dimnames(jx_f$dr_dff)[[2]]=c(nm_ffn, nm_ffx)
            fname="dbg_dr_dff_singular" %s+% runsuf %s+% ".csv"
            cat(sprintf("Provided measurements (labeling and fluxes) are not sufficient to resolve all free fluxes.\nUnsolvable fluxes may be:\n%s\nJacobian dr_dff is written in the result kvh file.\n",
               paste(nm_uns, sep=", ", collapse=", ")),
               file=fcerr)
            obj2kvh(jx_f$dr_dff, "Jacobian dr_dff", fkvh, indent=0)
            close(fkvh)
            retcode[irun]=1
            next
         }
      }
      if (TIMEIT) {
         cat("optim   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      # pass control to the chosen optimization method
      if (time_order=="1,2")
         labargs$time_order="1" # start with order 1, later continue with 2
      capture.output(res <- opt_wrapper(param, measurements, jx_f, labargs), file=fclog)
      if ((!is.null(res$err) && res$err) || is.null(res$par)) {
         cat("first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fcerr)
         res$par=rep(NA, length(param))
         res$cost=NA
      } else if (!is.null(res$mes) && nchar(res$mes)) {
         cat("first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fcerr)
      }
      if (any(is.na(res$par))) {
         res$retres$jx_f=NULL # to avoid writing of huge data
         obj2kvh(res, "failed first pass optimization process information", fkvh)
         cat("Optimization failed", runsuf, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=max(res$err, 1)
         next
      }
      param=res$par
#browser()
      if (zerocross && !is.null(mi_zc)) {
         if (TIMEIT) {
            cat("secondzc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         # inverse active "zc" inequalities
         nm_inv=names(which((ui%*%res$par-ci)[,1]<=1.e-10))
         i=grep("^zc ", nm_inv, v=T)
         if (length(i) > 0) {
            i=str2ind(i, nm_i)
            cat("The following inequalities are active after first pass
of zero crossing strategy and will be inverted", runsuf, ":\n", paste(nm_i[i], collapse="\n"), "\n", sep="", file=fclog)
            ipos=grep(">=", nm_i[i], v=T)
            ineg=grep("<=", nm_i[i], v=T)
            ui[i,]=-ui[i,,drop=FALSE]
            if (length(ipos)) {
               ipzc=str2ind(ipos, nm_izc)
               ipos=str2ind(ipos, nm_i)
               ci[ipos]=as.numeric(zc+mi_zc[ipzc,,drop=FALSE]%*%mic)
               nm_i[ipos]=sub(">=", "<=-", nm_i[ipos])
            }
            if (length(ineg)) {
               inzc=str2ind(ineg, nm_izc)
               ineg=str2ind(ineg, nm_i)
               ci[ineg]=as.numeric(zc+mi_zc[inzc,,drop=FALSE]%*%mic)
               nm_i[ineg]=sub("<=-", ">=", nm_i[ineg])
            }
            rownames(ui)=nm_i
            names(ci)=nm_i
            # enforce new inequalities
            reopt=TRUE
            capture.output(pinside <- put_inside(res$par, ui, ci), file=fclog)
            if (any(is.na(pinside))) {
               if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
                  # fatal error occured, don't reoptimize
                  cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
                  reopt=FALSE
               }
            } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0){
               # non fatal problem
               cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
            }
            # reoptimize
            if (reopt) {
               cat("Second zero crossing pass", runsuf, "\n", sep="", file=fclog)
               capture.output(reso <- opt_wrapper(pinside, measurements, new.env(), labargs), file=fclog)
               if (reso$err || is.null(reso$par)) {
                  cat("second zero crossing pass: ", reso$mes, "\n", sep="", file=fcerr)
               } else if (!is.null(reso$mes) && nchar(reso$mes)) {
                  cat("second zero crossing pass", runsuf, ": ", reso$mes, "\n", sep="", file=fcerr)
               }
               if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                  param=reso$par
                  res=reso
                  jx_f=labargs$jx_f
               }
               if (any(is.na(reso$par))) {
                  reso$retres$jx_f=NULL # to avoid writing of huge data
                  obj2kvh(reso, "failed second pass optimization process information", fkvh)
                  cat("Second zero crossing pass failed. Keep free parameters from previous pass", runsuf, "\n", file=fcerr, sep="")
               }
            }
            # last pass, free all zc constraints
            i=grep("^zc ", nm_i)
            if (length(i) > 0) {
               if (TIMEIT) {
                  cat("last zc : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
               }
               ui=ui[-i,,drop=FALSE]
               ci=ci[-i]
               nm_i=nm_i[-i]
               cat("Last zero crossing pass (free of zc constraints)", runsuf, "\n", sep="", file=fclog)
               capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
               if (reso$err || is.null(reso$par) || (!is.null(res$mes) && nchar(res$mes))) {
                  cat("last zero crossing (free of zc)", runsuf, ": ", reso$mes, "\n", sep="", file=fcerr)
               }
               if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                  param=reso$par
                  res=reso
                  jx_f=labargs$jx_f
               }
               if (any(is.na(res$par))) {
                  res$retres$jx_f=NULL # to avoid writing of huge data
                  obj2kvh(res, "failed last pass optimization process information", fkvh)
                  cat("Last zero crossing pass failed. Keep free parameters from previous passes", runsuf, "\n", file=fcerr, sep="")
               }
            }
         } else {
            cat("After the first optimization, no zero crossing inequality was activated. So no reoptimization", runsuf, "\n", sep="", file=fclog)
         }
      } # end if zero crossing
      param=res$par
      names(param)=nm_par
      if (excl_outliers != F) {
         # detect outliers
         if (TIMEIT) {
            cat("outliers: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         iva=!is.na(res$res)
         zpval=rz.pval.bi(res$res)
         iout=which(zpval <= excl_outliers & iva)
         #cat("iout=", iout, "\n", file=fclog)
         if (length(iout)) {
            measurements$outlier=iout
            outtab=cbind(residual=res$res[iout], `p-value`=zpval[iout])
            row.names(outtab)=nm_resid[iout]
            cat("Excluded outliers at p-value ", excl_outliers, ":\n", sep="", file=fclog)
            write.table(outtab, file=fclog, append=TRUE, quote=FALSE, sep="\t", col.names=FALSE)
            
            capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
            if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
               cat("wo outliers: ", reso$mes, "\n", sep="", file=fcerr)
            }
            if (any(is.na(reso$par))) {
               cat("Optimization with outliers excluded has failed, run= ", runsuf, "\n", file=fcerr, sep="")
               # continue without outlier exclusion
               measurements$outlier=NULL
            } else {
               res=reso
               param=reso$par
               names(param)=nm_par
               jx_f=labargs$jx_f
               labargs$measurements=measurements # store outliers
               obj2kvh(outtab, "excluded outliers", fkvh)
            }
         } else {
            cat("Outlier exclusion at p-value "%s+%excl_outliers%s+%" has been requested but no outlier was detected at this level.", "\n", sep="", file=fcerr)
         }
      }
      if (case_i && time_order=="1,2") {
         if (TIMEIT) {
            cat("order 2 : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         labargs$time_order="2" # continue with the 2-nd order
         capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
         if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
            cat("order2: ", reso$mes, "\n", sep="", file=fcerr)
         }
         if (any(is.na(reso$par))) {
            cat("Optimization time_order 2 (in '1,2' suite) has failed, run=", runsuf, "\n", file=fcerr, sep="")
         } else {
            res=reso
            param=reso$par
            names(param)=nm_par
            jx_f=labargs$jx_f
         }
      }
#browser()
      optinfo=list(
         "fitted parameters"=param,
         "last increment before backtracking"=res$lastp,
         "last increment after backtracking"=res$laststep,
         "iteration number"=res$it,
         "convergence history"=res$hist,
         "exit message"=res$mes
      )
      obj2kvh(optinfo, "optimization process information", fkvh)
      rres=res$retres
   } else {
      rres=lab_resid(param, TRUE, labargs)
   }
   if (TIMEIT) {
      cat("postopt : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # active constraints
   ine=as.numeric(abs(ui%*%param-ci))<1.e-10
   if (any(ine)) {
      obj2kvh(nm_i[ine], "active inequality constraints", fkvh)
   }
   poolall[nm_poolf]=param[nm_poolf]

#browser()
   if (is.null(jx_f$jacobian)) {
      # final jacobian calculation
      capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
   }
   rcost=cumo_cost(param, labargs, rres)
   pres[,irun]=param
   costres[irun]=rcost
   obj2kvh(rcost, "final cost", fkvh)
#browser()
   # get z p-values on residual vector
   zpval=rz.pval.bi(rres$res)
   resid=list()
   if (sum(nb_meas)) {
      resid[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) if (is.matrix(jx_f$reslab[[iexp]])) jx_f$reslab[[iexp]] else cbind(residual=jx_f$reslab[[iexp]], `p-value`=zpval[seq_along(jx_f$reslab[[iexp]])]))
      names(resid[["labeled data"]])=nm_exp
   
      if (case_i) {
         resid[["labeled data p-value"]]=vector("list", nb_exp)
         names(resid[["labeled data p-value"]])=nm_exp
         for (iexp in seq_len(nb_exp)) {
            mtmp=zpval[seq_along(jx_f$reslab[[iexp]])]
            dim(mtmp)=dim(jx_f$reslab[[iexp]])
            dimnames(mtmp)=dimnames(jx_f$reslab[[iexp]])
            resid[["labeled data p-value"]][[iexp]]=mtmp
            rm(mtmp)
         }
      }
   }
   nb_reslab_tot=sum(sapply(jx_f$reslab, length))
   if (length(jx_f$resflu))
      resid[["measured fluxes"]]=cbind(residual=jx_f$resflu, `p-value`=zpval[nb_reslab_tot+seq_along(jx_f$resflu)])
   if (length(jx_f$respool))
      resid[["measured pools"]]=cbind(residual=if (is.matrix(jx_f$respool)) jx_f$respool[,1] else jx_f$respool, `p-value`=zpval[nb_reslab_tot+length(jx_f$resflu)+seq_along(jx_f$respool)])
   obj2kvh(resid, "(simulated-measured)/sd_exp", fkvh)
   rm(resid, zpval)

   # simulated measurements -> kvh
   simul=list()
#browser()
   if (case_i) {
      if (sum(nb_meas)) {
         if (addnoise) {
            simul[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) jx_f$usm[[iexp]]+rnorm(length(jx_f$usm[[iexp]]))*measurements$dev$labeled[[iexp]])
            names(simul[["labeled data"]])=nm_exp
         } else {
            simul[["labeled data"]]=jx_f$usm
         }
      }
   } else {
      if (sum(nb_meas)) {
         if (addnoise) {
            simlab=lapply(seq_len(nb_exp), function(iexp) jx_f$simlab[[iexp]]+rnorm(length(jx_f$simlab[[iexp]]))*measurements$dev$labeled[[iexp]])
            names(simlab)=nm_exp
         } else {
            simlab=jx_f$simlab
         }
         if (nb_sc_tot > 0) {
            simul[["labeled data (unscaled)"]]=jx_f$usimlab
            simul[["labeled data (scaled)"]]=simlab
         } else {
            simul[["labeled data"]]=simlab
         }
      }
   }
   if (nb_fmn) {
      if (addnoise)
         simul[["measured fluxes"]]=jx_f$simfmn+rnorm(length(jx_f$simfm))*measurements$dev$flux
      else
         simul[["measured fluxes"]]=jx_f$simfmn
   }
   if (nb_poolm) {
      if (addnoise)
         simul[["measured pools"]]=jx_f$simpool+rnorm(length(jx_f$simpool))*measurements$dev$pool
      else
         simul[["measured pools"]]=jx_f$simpool
   }
   obj2kvh(simul, "simulated measurements", fkvh)
   
   # SD -> kvh
   # get index of non null components
   iget=sapply(names(measurements$dev), function(nm) !is.null(measurements$dev[[nm]]) & nm %in% c("labeled", "flux", "pool"))
   obj2kvh(measurements$dev[iget], "measurement SD", fkvh)

   # gradient -> kvh
   if (length(jx_f$res) && !all(ina <- is.na(jx_f$res))) {
      if (any(ina)) {
         gr=2*as.numeric(crossprod(jx_f$res[!ina], jx_f$jacobian[!ina,,drop=FALSE]))
      } else {
         gr=2*as.numeric(crossprod(jx_f$res, jx_f$jacobian))
      }
      names(gr)=nm_par
      obj2kvh(gr, "gradient vector", fkvh)
   }
   colnames(jx_f$udr_dp)=nm_par
   obj2kvh(jx_f$udr_dp, "jacobian dr_dp (without 1/sd_exp)", fkvh)
   # generalized inverse of non reduced jacobian
   svj=svd(jx_f$udr_dp)
   invj=svj$v%*%(t(svj$u)/svj$d)
   dimnames(invj)=rev(dimnames(jx_f$udr_dp))
   obj2kvh(invj, "generalized inverse of jacobian dr_dp (without 1/sd_exp)", fkvh)

   labargs$getx=TRUE
   labargs$labargs2getx=TRUE
   if (fullsys) {
      nm_flist=nm_list
      nm_flist$rcumo=nm_cumo
      nm_flist$rcumo_in_cumo=match(nm_rcumo, nm_cumo)
      nb_f$cumos=nb_cumos
      nm_xi_f=c()
      xi_f=matrix(c(), ncol=nb_exp)
      dimnames(xi_f)[[1]]=nm_xi_f
      nm_flist$xi=nm_xi_f
      labargs$emu=F
      v=lab_sim(param, cjac=FALSE, labargs)
      labargs$emu=emu
      x=if (case_i) v$xf else v$x
   } else {
      v=lab_sim(param, cjac=FALSE, labargs)
      x=if (case_i) v$xf else v$x
   }

   # write some info in result kvh
   mid=cumo2mass(x)
   if (case_i) {
      mid=lapply(mid, function(m) m[sort(rownames(m)),,drop=FALSE])
   } else if (length(mid)) {
      mid=mid[sort(rownames(mid)),,drop=FALSE]
   }
   obj2kvh(mid, "MID vector", fkvh)
   
   # constrained fluxes to kvh
   obj2kvh(fallnx[nm_fc], "constrained net-xch01 fluxes", fkvh)

   fwrv=v$lf$fwrv
   fallnx=v$lf$fallnx
   flnx=v$lf$flnx
   fgr=fallnx[nm_fgr]

   # keep last jx_f in jx_f_last
#browser()
   while (sensitive=="mc") {
      if (TIMEIT) {
         cat("monte-ca: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      if (set_seed) {
         set.seed(seed)
      }
      # reference simulation corresponding to the final param
      refsim=new.env()
      for (nm_it in c("simlab", "simfmn", "simpool", "usm")) {
         assign(nm_it, jx_f[[nm_it]], envir=refsim)
      }
      # Monte-Carlo simulation in parallel way (if asked and possible)
      if (np > 1L) {
         spli=splitIndices(nmc, nodes);
         clusterExport(cl, c("param", "refsim", "runsuf", "spli"))
         #clusterEvalQ(cl, labargs$spa[[1]]$a <- NULL) # to rebuild sparse matrices on cores ## now, they are build once, at the cluster init
         cl_res=clusterEvalQ(cl, {mc_iter=TRUE; labargs$getx=FALSE; mc_res=lapply(spli[[idw]], mc_sim); rm(mc_iter); mc_res})
         mc_res=vector(nmc, mode="list")
         for (i in seq(nodes))
            mc_res[spli[[i]]]=cl_res[[i]]
         #mc_res=parLapplyLB(cl, seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      } else {
         mc_res=lapply(seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      }
      free_mc=sapply(mc_res, function(l) {if (class(l)=="character" || is.null(l) || is.na(l$cost) || l$err) { ret=rep(NA, nb_param+3) } else { ret=c(l$cost, l$it, l$normp, l$par) }; ret })
      if (length(free_mc)==0) {
         cat("Parallel exectution of Monte-Carlo simulations has failed.", "\n", sep="", file=fcerr)
         free_mc=matrix(NA, nb_param+2, 0)
      }
      cost_mc=free_mc[1,]
      nmc_real=nmc-sum(is.na(free_mc[4,]))
      cat("monte-carlo\n", file=fkvh)
      indent=1
      obj2kvh(cl_type, "cluster type", fkvh, indent)
      obj2kvh(avaco, "detected cores", fkvh, indent)
      avaco=max(1, avaco, na.rm=T)
      obj2kvh(min(avaco, np, na.rm=T), "used cores", fkvh, indent)
      cat("\tfitting samples\n", file=fkvh)
      indent=2
      obj2kvh(nmc, "requested number", fkvh, indent)
      obj2kvh(nmc_real, "calculated number", fkvh, indent)
      obj2kvh(nmc-nmc_real, "failed to calculate", fkvh, indent)
      # convergence section in kvh
      indent=1
      mout=rbind(round(free_mc[1:2,,drop=FALSE], 2),
         format(free_mc[3,,drop=FALSE], di=2, sci=T))
      dimnames(mout)=list(c("cost", "it.numb", "normp"), seq_len(ncol(free_mc)))
      obj2kvh(mout, "convergence per sample", fkvh, indent)
      # remove failed m-c iterations
      free_mc=free_mc[-(1:3),,drop=FALSE]
      ifa=which(is.na(free_mc[1,]))
      if (length(ifa)) {
         if (ncol(free_mc) > length(ifa)) {
            cat("Some Monte-Carlo iterations failed.", "\n", sep="", file=fcerr)
         }
         free_mc=free_mc[,-ifa,drop=FALSE]
         cost_mc=cost_mc[-ifa]
      }
      if (nmc_real <= 1) {
         cat("No sufficient Monter-Carlo samples were successfully calculated to do any statistics.", "\n", sep="", file=fcerr)
         retcode[irun]=1
         break
      }
#browser()
      rownames(free_mc)=nm_par
      
      # cost section in kvh
      cat("\tcost\n", file=fkvh)
      indent=2
      obj2kvh(mean(cost_mc), "mean", fkvh, indent)
      obj2kvh(median(cost_mc), "median", fkvh, indent)
      obj2kvh(sd(cost_mc), "sd", fkvh, indent)
      obj2kvh(sd(cost_mc)*100/mean(cost_mc), "rsd (%)", fkvh, indent)
      obj2kvh(quantile(cost_mc, c(0.025, 0.95, 0.975)), "ci", fkvh, indent)
      
      # free parameters section in kvh
      cat("\tStatistics\n", file=fkvh)
      mout=c()
      indent=2
      # param stats
      # mean
      parmean=apply(free_mc, 1, mean)
      # median
      parmed=apply(free_mc, 1, median)
#browser()
      # covariance matrix
      covmc=cov(t(free_mc))
      obj2kvh(covmc, "covariance", fkvh, indent)
      # sd
      sdmc=sqrt(diag(covmc))
      # confidence intervals
      ci_mc=t(apply(free_mc, 1, quantile, probs=c(0.025, 0.975)))
      ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
      colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI length")
      mout=cbind(mout, mean=parmean, median=parmed, sd=sdmc,
         "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
      obj2kvh(mout, "free parameters", fkvh, indent)

      # net-xch01 stats
      fallnx_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fallnx)
      fallnx=param2fl(param, labargs)$fallnx
      if (length(fallnx_mc)) {
         dimnames(fallnx_mc)[[1]]=nm_fallnx
         # form a matrix output
         fallout=matrix(0, nrow=nrow(fallnx_mc), ncol=0)
         # mean
#browser()
         parmean=apply(fallnx_mc, 1, mean)
         # median
         parmed=apply(fallnx_mc, 1, median)
         # covariance matrix
         covmc=cov(t(fallnx_mc))
         dimnames(covmc)=list(nm_fallnx, nm_fallnx)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(fallnx_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         ci_mc=cbind(ci_mc, ci_mc[,3]*100/abs(parmean))
         colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
         fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(fallnx), ci_mc)
         o=order(nm_fallnx)
         obj2kvh(fallout[o,,drop=FALSE], "all net-xch01 fluxes", fkvh, indent)
         obj2kvh(covmc[o,o], "covariance of all net-xch01 fluxes", fkvh, indent)

         # fwd-rev stats
         fwrv_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fwrv)
         dimnames(fwrv_mc)[[1]]=nm_fwrv
         fallout=matrix(0, nrow=nrow(fwrv_mc), ncol=0)
         # mean
         parmean=apply(fwrv_mc, 1, mean)
         # median
         parmed=apply(fwrv_mc, 1, median)
         # covariance matrix
         covmc=cov(t(fwrv_mc))
         dimnames(covmc)=list(nm_fwrv, nm_fwrv)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(fwrv_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         ci_mc=cbind(ci_mc, ci_mc[,3]*100/abs(fwrv))
         dimnames(ci_mc)[[2]]=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
         fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
         o=order(nm_fwrv)
         obj2kvh(fallout[o,,drop=FALSE], "forward-reverse fluxes", fkvh, indent)
         obj2kvh(covmc[o,o], "covariance of forward-reverse fluxes", fkvh, indent)
      }
      break
   }
#browser()
   if (length(sensitive) && nchar(sensitive) && sensitive != "mc") {
      cat(paste("Unknown sensitivity '", sensitive, "' method chosen.", sep=""), "\n", sep="", file=fcerr)
      retcode[irun]=1
   }

   if (TIMEIT) {
      cat("linstats: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # Linear method based on jacobian x_f
   # reset fluxes and jacobians according to param
   if (is.null(jx_f$jacobian)) {
      capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
   } # else use the last calculated jacobian

   # covariance matrix of free fluxes
   svj=svd(jx_f$jacobian)
   if (svj$d[1] == 0.) {
      i=rep(TRUE, length(svj$d))
   } else {
      i=svj$d/svj$d[1]<1.e-10
      if (all(!i) && svj$d[1]<1.e-10) {
         # we could not find very small d, take just the last
         i[length(i)]=TRUE
      }
   }
   ibad=apply(svj$v[, i, drop=FALSE], 2, which.contrib)
   ibad=unique(unlist(ibad))
   if (length(ibad) > 0) {
      cat(paste(if (nchar(runsuf)) runsuf%s+%": " else "", "Inverse of covariance matrix is numerically singular.\nStatistically undefined parameter(s) seems to be:\n",
         paste(sort(nm_par[ibad]), collapse="\n"), "\nFor more complete list, see sd columns in '/linear stats'\nin the result file.", sep=""), "\n", sep="", file=fcerr)
   }
   # "square root" of covariance matrix (to preserve numerical positive definitness)
   rtcov=(svj$u)%*%(t(svj$v)/svj$d)
   # standart deviations of free fluxes
   cat("linear stats\n", file=fkvh)

   # sd free+dependent+growth net-xch01 fluxes
   nm_flfd=c(nm_ff, nm_fgr, nm_fl)
   if (nb_ff > 0 || nb_fgr > 0) {
      i=1:nb_param
      i=c(head(i, nb_ff), tail(i, nb_fgr))
      covfl=crossprod(rtcov[, i, drop=FALSE]%mmt%(rbind(diag(nb_ff+nb_fgr), dfl_dffg)%mrv%c(rep.int(1., nb_ff), fgr)))
      dimnames(covfl)=list(nm_flfd, nm_flfd)
      sdfl=sqrt(diag(covfl))
   } else {
      sdfl=rep(0., nb_fl)
      covfl=matrix(0., nb_fl, nb_fl)
   }
   fl=c(head(param, nb_ff), fgr, flnx)
   stats_nx=cbind("value"=fl, "sd"=sdfl, "rsd"=sdfl/abs(fl))
   rownames(stats_nx)=nm_flfd
   o=order(nm_flfd)
   obj2kvh(stats_nx[o,,drop=FALSE], "net-xch01 fluxes (sorted by name)", fkvh, indent=1)
   obj2kvh(covfl[o, o], "covariance net-xch01 fluxes", fkvh, indent=1)

   # sd of all fwd-rev
   if (nb_ff > 0 || nb_fgr > 0) {
      i=1:nb_param
      i=c(head(i, nb_ff), tail(i, nb_fgr))
      covf=crossprod(tcrossprod_simple_triplet_matrix(rtcov[,i, drop=FALSE], jx_f$df_dffp%mrv%c(rep.int(1., nb_ff), head(poolall[nm_poolf], nb_fgr))))
      dimnames(covf)=list(nm_fwrv, nm_fwrv)
      sdf=sqrt(diag(covf))
   } else {
      sdf=rep(0., length(fwrv))
   }
   mtmp=cbind(fwrv, sdf, sdf/abs(fwrv))
   dimnames(mtmp)[[2]]=c("value", "sd", "rsd")
   o=order(nm_fwrv)
   obj2kvh(mtmp[o,], "fwd-rev fluxes (sorted by name)", fkvh, indent=1)
   if (nb_ff > 0 || nb_fgr > 0) {
      obj2kvh(covf, "covariance fwd-rev fluxes", fkvh, indent=1)
   }
   # pool -> kvh
   sdpf=poolall
   sdpf[]=0.

   if (nb_poolf > 0) {
      # covariance matrix of free pools
      # "square root" of covariance matrix (to preserve numerical positive definitness)
      poolall[nm_poolf]=param[nm_poolf]
      # cov poolf
      covpf=crossprod(rtcov[,nb_ff+nb_sc_tot+seq_len(nb_poolf), drop=FALSE])
      dimnames(covpf)=list(nm_poolf, nm_poolf)
      sdpf[nm_poolf]=sqrt(diag(covpf))
   }
   if (length(poolall) > 0) {
      mtmp=cbind("value"=poolall, "sd"=sdpf, "rsd"=sdpf/poolall)
      rownames(mtmp)=nm_poolall
      o=order(nm_poolall)
      obj2kvh(mtmp[o,,drop=FALSE], "metabolite pools (sorted by name)", fkvh, indent=1)
      if (nb_poolf > 0) {
         o=order(nm_poolf)
         obj2kvh(covpf[o, o], "covariance free pools", fkvh, indent=1)
      }
   }

   # khi2 test for goodness of fit
   # goodness of fit (khi2 test)
   if (length(jx_f$res)) {
      nvres=sum(!is.na(jx_f$res))
      if (nvres >= nb_param) {
         khi2test=list("khi2 value"=rcost, "data points"=nvres,
            "fitted parameters"=nb_param, "degrees of freedom"=nvres-nb_param)
         khi2test$`khi2 reduced value`=khi2test$`khi2 value`/khi2test$`degrees of freedom`
         khi2test$`p-value, i.e. P(X^2<=value)`=pchisq(khi2test$`khi2 value`, df=khi2test$`degrees of freedom`)
         khi2test$conclusion=if (khi2test$`p-value, i.e. P(X^2<=value)` > 0.95) "At level of 95% confidence, the model does not fit the data good enough with respect to the provided measurement SD" else "At level of 95% confidence, the model fits the data good enough with respect to the provided measurement SD"
         obj2kvh(khi2test, "goodness of fit (khi2 test)", fkvh, indent=1)
      } else {
         cat(sprintf("khi2: Measurement number %d is lower than parameter number %d. Khi2 test cannot be done.\n", nvres, nb_param), sep="", file=fcerr)
      }
   }
   if (prof) {
      Rprof(NULL)
   }
   close(fkvh)
   # write edge.netflux property
   fedge=file(file.path(dirw, sprintf("edge.netflux.%s%s.attrs", baseshort,  runsuf)), "w")
   cat("netflux (class=Double)\n", sep="", file=fedge)
   nm_edge=names(edge2fl)
   cat(paste(nm_edge, fallnx[edge2fl], sep=" = "), sep="\n" , file=fedge)
   close(fedge)

   # write edge.xchflux property
   fedge=file(file.path(dirw, sprintf("edge.xchflux.%s%s.attrs", baseshort,  runsuf)), "w")
   flxch=paste(".x", substring(edge2fl, 4), sep="")
   ifl=charmatch(flxch, substring(names(fallnx), 2))
   cat("xchflux (class=Double)\n", sep="", file=fedge)
   cat(paste(nm_edge, fallnx[ifl], sep=" = "), sep="\n" , file=fedge)
   close(fedge)

   # write node.log2pool property
   if (length(poolall)> 0) {
      fnode=file(file.path(dirw, sprintf("node.log2pool.%s%s.attrs", baseshort,  runsuf)), "w")
      cat("log2pool (class=Double)\n", sep="", file=fnode)
      nm_node=substring(names(poolall), 4)
      cat(paste(nm_node, log2(poolall), sep=" = "), sep="\n" , file=fnode)
      close(fnode)
   }
}
if (!is.null(cl)) {
   stopCluster(cl)
   labargs$cl=cl=NULL
}

pres=rbind(cost=costres, pres)
fco=file(file.path(dirw, sprintf("%s.pres.csv", baseshort)), open="w")
cat("row_col	", file=fco)
write.table(file=fco, pres, row.n=T, quot=F, sep="\t")
close(fco)
if (TIMEIT) {
   cat("rend    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# source files from FTBL/posttreat_R
postlist=strsplit("save_all.R; plot_smeas.R", " *; *")[[1]]
for (post in postlist) {
   fpostR=file.path(dirw, post)
   if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
      source(fpostR)
   } else {
      # not found in 'dirw', try 'dirr'
      fpostR=file.path(dirr, post)
      if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
         source(fpostR)
      } else {
         cat(sprintf("Posttreatment R file '%s' does not exist in ftbl directory neither in influx_si one. Ignored.\n", post), file=fcerr)
      }
   }
}
xgc=gc(verbose=FALSE) # to avoid the message "Error in (function (x)  : tentative d'appliquer un objet qui n'est pas une fonction"
close(fclog)
close(fcerr)
retcode=max(retcode)
if (format(parent.frame()) == format(.GlobalEnv)) {
   q("no", status=retcode)
}
