# This is an automatically generated R code. Don't edit.
# Generated by 
# /home/sokol/.local/bin/ftbl2optR.py --tblimit 0 --ropts "noscale=TRUE; clowp=1e-09; zc=0.0; time_order='2'; TIMEIT=TRUE" --case_i e_coli_i.ftbl
# at Thu Nov  7 14:58:20 2019.

# Copyright 2011-2019, INRA, France.

# working dir
dirw="/home/sokol/insa/sysbio/dev/ftbl2sys/tmp/test"

# installation dir (where influx_si/R/*.R live)
dirr="/home/sokol/.local/lib/python3.7/site-packages/influx_si/R"
# short base name of the FTBL (withount '.ftbl')
baseshort="e_coli_i"

fcerr=file(file.path(dirw, sprintf("%s.err", baseshort)), "ab")
fclog=file(file.path(dirw, sprintf("%s.log", baseshort)), "ab")

options(warn=1)
options(digits.secs=2)

case_i=T

if (length(find("bitwAnd"))==0L) {
   suppressPackageStartupMessages(library(bitops))
   bitwAnd=bitAnd
}
source(file.path(dirr, "libs.R"))

# define matprod for simple_triplet_matrix
`%stm%` = slam::matprod_simple_triplet_matrix

# default options
version=FALSE
noopt=FALSE
noscale=FALSE
meth="nlsic"
fullsys=FALSE
emu=FALSE
irand=FALSE
sens=""
cupx=0.999
cupn=1.e3
cupp=1.e5
clownr=0
cinout=0
clowp=1.e-8
np=0
ln=FALSE
tikhreg=FALSE
sln=FALSE
lim=FALSE
zc=-.Machine$double.xmax
ffguess=FALSE
fdfit=FALSE
addnoise=FALSE
fseries=""
iseries=""
seed=-.Machine$integer.max
excl_outliers=FALSE
TIMEIT=FALSE
prof=FALSE
time_order="1"

# get runtime arguments
noscale=TRUE
clowp=1e-09
zc=0.0
time_order='2'
TIMEIT=TRUE

# synonymous
myver=version
optimize=!noopt
method=meth
sensitive=sens
least_norm=ln
initrand=irand

vernum="5.0"

# sanity check for command line parameters
if (substring(sensitive, 1, 3)=="mc=") {
   # read the mc iteration number
   nmc=as.integer(substring(sensitive, 4))
   sensitive="mc"
} else if (sensitive=="mc") {
   nmc=10
}
# cupx==0 means no upper limit => cupx=1
cupx=ifelse(cupx, cupx, 1)
if (cupx < 0 || cupx > 1) {
   stop_mes(paste("Option '--cupx N' must have N in the interval [0,1]
",
      "Instead, the value ", cupx, " si given.", sep=""), file=fcerr)
}
if (cinout < 0) {
   stop_mes(paste("Option '--cinout N' must have N non negative
",
      "Instead, the value ", cinout, " is given.", sep=""), file=fcerr)
}
# minimization method
validmethods=list("BFGS", "Nelder-Mead", "SANN", "ipopt", "nlsic")
if (! method %in% validmethods) {
   cat(paste("Wraning: method", method, "is not known. 'nlsic' is used instead."), "\n", sep="", file=fcerr)
   method="nlsic"
}
if (method == "ipopt") {
   installed=suppressPackageStartupMessages(library(ipoptr, logical.return=T))
   if (!installed) {
      stop_mes("An optimization method ipopt is requested but available in this R installation", file=fcerr)
   }
}
if (least_norm && sln) {
   stop_mes("Options --ln and --sln cannot be activated simultaniously.", file=fcerr)
}

avaco=try(detectCores(), silent=T)
if (inherits(avaco, "try-error")) {
   avaco=NULL
}
if (np > 0L && np < 1L) {
   np=round(avaco*np)
} else if (np >= 1L) {
   np=round(np)
} else {
   np=avaco
}
if (is.null(np) || np <= 0L) {
   np=1L
}
if (sensitive=="mc") {
   np=min(np, nmc)
}
options(mc.cores=np)

if (least_norm+tikhreg+lim > 1) {
   stop_mes("Options --ln, --lim and --tikhreg cannot be activated simultaneously. Use only one of them at a time.", file=fcerr)
}
lsi_fun=lsi
if (least_norm || sln) {
   lsi_fun=lsi_ln
} else if (tikhreg) {
   lsi_fun=lsi_reg
} else if (lim) {
   suppressPackageStartupMessages(library(limSolve));
   lsi_fun=lsi_lim
}
if (zc==-.Machine$double.xmax) {
   # no zero scrossing to apply
   zerocross=F
} else {
   if (zc < 0.) {
      stop_mes(paste("Zero crossing value ZC must be non negative, instead ", zc, " is given.", sep=""), file=fcerr)
   }
   zerocross=T
}
if (seed==-.Machine$integer.max) {
   # no seed to apply
   set_seed=F
} else {
   set_seed=T
   set.seed(seed)
}
time_order=gsub("\\s", "", time_order) # remove spaces if any
if (!(time_order %in% c("1", "2", "1,2"))) {
   stop_mes(sprintf("time_order must be '1', '2' or '1,2'. Instead got '%s'"))
}
opts=commandArgs()
# end command line argument proceeding

# get some cumomer tools
source(file.path(dirr, "opt_cumo_tools.R"))
#loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))

lab_resid=cumo_resid
lab_sim=param2fl_x
jx_f=new.env()

source(file.path(dirr, "opt_icumo_tools.R"))
#loadcmp(file.path(dirr, "opt_icumo_tools.Rc"))

lab_resid=icumo_resid
lab_sim=param2fl_usm_rich

if (TIMEIT) {
   cat("rinit   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# R profiling
if (prof) {
   Rprof(sprintf("%s.Rprof", baseshort))
}

nm_list=list()
nb_f=list()

if (TIMEIT) {
   cat("r_flux  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# fwd-rev flux names
nm_fwrv=c("fwd.Glucupt_1", "fwd.Glucupt_U", "fwd.akgdh", "fwd.ald", "fwd.bs_DHAP", "fwd.bs_accoa", "fwd.bs_accoa_aux", "fwd.bs_akg", "fwd.bs_akg1", "fwd.bs_akg2", "fwd.bs_akg3", "fwd.bs_akg4", "fwd.bs_akg4_aux", "fwd.bs_e4p", "fwd.bs_fru6P", "fwd.bs_glc6P", "fwd.bs_oaa", "fwd.bs_oaa1", "fwd.bs_oaa1_aux", "fwd.bs_oaa2", "fwd.bs_oaa2_aux", "fwd.bs_oaa3_aux", "fwd.bs_oaa3a", "fwd.bs_oaa3b", "fwd.bs_oaa4", "fwd.bs_oaa5", "fwd.bs_oaa5_aux", "fwd.bs_oaa6", "fwd.bs_oaa6_aux", "fwd.bs_oaa7", "fwd.bs_oaa7_aux", "fwd.bs_pep", "fwd.bs_pep1", "fwd.bs_pep2", "fwd.bs_pep3_aux", "fwd.bs_pep3a", "fwd.bs_pep3b", "fwd.bs_pep4_aux", "fwd.bs_pep4a", "fwd.bs_pep4b", "fwd.bs_pep5", "fwd.bs_pep6", "fwd.bs_pep6_aux", "fwd.bs_pep7", "fwd.bs_pga", "fwd.bs_pga1", "fwd.bs_pga1_aux", "fwd.bs_pga2", "fwd.bs_pga2_aux", "fwd.bs_pga3", "fwd.bs_pga3_aux", "fwd.bs_pga_aux", "fwd.bs_pyr", "fwd.bs_pyr1", "fwd.bs_pyr1_aux", "fwd.bs_pyr2", "fwd.bs_pyr3", "fwd.bs_pyr3_aux", "fwd.bs_pyr4", "fwd.bs_pyr4_aux", "fwd.bs_rib5p", "fwd.bs_rib5p1", "fwd.bs_rib5p1_aux", "fwd.bs_rib5p2", "fwd.citsynth", "fwd.edd", "fwd.eno", "fwd.fum_a", "fwd.fum_b", "fwd.gnd", "fwd.idh", "fwd.mae", "fwd.maldh", "fwd.out_Ac", "fwd.out_FTHF", "fwd.out_co2", "fwd.pdh", "fwd.pfk", "fwd.pgi", "fwd.pgk", "fwd.ppc", "fwd.pyk", "fwd.ta", "fwd.tk1", "fwd.tk2", "fwd.zwf", "rev.Glucupt_1", "rev.Glucupt_U", "rev.akgdh", "rev.ald", "rev.bs_DHAP", "rev.bs_accoa", "rev.bs_accoa_aux", "rev.bs_akg", "rev.bs_akg1", "rev.bs_akg2", "rev.bs_akg3", "rev.bs_akg4", "rev.bs_akg4_aux", "rev.bs_e4p", "rev.bs_fru6P", "rev.bs_glc6P", "rev.bs_oaa", "rev.bs_oaa1", "rev.bs_oaa1_aux", "rev.bs_oaa2", "rev.bs_oaa2_aux", "rev.bs_oaa3_aux", "rev.bs_oaa3a", "rev.bs_oaa3b", "rev.bs_oaa4", "rev.bs_oaa5", "rev.bs_oaa5_aux", "rev.bs_oaa6", "rev.bs_oaa6_aux", "rev.bs_oaa7", "rev.bs_oaa7_aux", "rev.bs_pep", "rev.bs_pep1", "rev.bs_pep2", "rev.bs_pep3_aux", "rev.bs_pep3a", "rev.bs_pep3b", "rev.bs_pep4_aux", "rev.bs_pep4a", "rev.bs_pep4b", "rev.bs_pep5", "rev.bs_pep6", "rev.bs_pep6_aux", "rev.bs_pep7", "rev.bs_pga", "rev.bs_pga1", "rev.bs_pga1_aux", "rev.bs_pga2", "rev.bs_pga2_aux", "rev.bs_pga3", "rev.bs_pga3_aux", "rev.bs_pga_aux", "rev.bs_pyr", "rev.bs_pyr1", "rev.bs_pyr1_aux", "rev.bs_pyr2", "rev.bs_pyr3", "rev.bs_pyr3_aux", "rev.bs_pyr4", "rev.bs_pyr4_aux", "rev.bs_rib5p", "rev.bs_rib5p1", "rev.bs_rib5p1_aux", "rev.bs_rib5p2", "rev.citsynth", "rev.edd", "rev.eno", "rev.fum_a", "rev.fum_b", "rev.gnd", "rev.idh", "rev.mae", "rev.maldh", "rev.out_Ac", "rev.out_FTHF", "rev.out_co2", "rev.pdh", "rev.pfk", "rev.pgi", "rev.pgk", "rev.ppc", "rev.pyk", "rev.ta", "rev.tk1", "rev.tk2", "rev.zwf")

# edge to netflux name translator
edge2fl=c("d.n.ta", "d.n.ta", "d.n.ta", "d.n.ta", "d.n.bs_oaa7", "d.n.bs_pga1", "f.n.out_Ac", "d.n.bs_oaa6", "d.n.bs_oaa6", "d.n.bs_oaa6", "d.n.bs_pga2", "d.n.edd", "d.n.edd", "d.n.edd", "f.n.gnd", "f.n.gnd", "f.n.gnd", "d.n.bs_pep7", "d.n.bs_pep7", "d.n.bs_pep7", "c.n.bs_glc6P", "d.n.bs_oaa1", "d.n.bs_e4p", "d.n.bs_accoa_aux", "c.n.bs_pep5", "d.n.bs_pep1", "d.n.bs_pep1", "d.n.bs_pep1", "f.n.Glucupt_1", "d.n.ppc", "d.n.ppc", "d.n.ppc", "c.n.bs_accoa", "c.n.bs_akg3", "d.n.bs_pep2", "d.n.bs_pep2", "d.n.bs_pep2", "c.n.bs_oaa7_aux", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pep6", "d.n.bs_pyr3", "d.n.bs_pyr3", "d.n.bs_pyr3", "d.n.bs_pyr3", "d.n.akgdh", "d.n.akgdh", "d.n.akgdh", "d.n.eno", "d.n.bs_rib5p1", "d.n.bs_rib5p1", "d.n.bs_rib5p1", "c.n.bs_pga", "c.n.bs_oaa", "d.n.ald", "d.n.ald", "d.n.ald", "d.n.tk1", "d.n.tk1", "d.n.tk1", "d.n.tk1", "d.n.maldh", "c.n.bs_oaa3_aux", "d.n.pgk", "c.n.bs_oaa6_aux", "d.n.out_FTHF", "d.n.pdh", "d.n.pdh", "d.n.pdh", "c.n.bs_pyr3_aux", "d.n.bs_pga3", "d.n.bs_pga3", "d.n.bs_pga3", "d.n.bs_pep6_aux", "d.n.fum_b", "d.n.fum_a", "d.n.bs_pga_aux", "d.n.bs_pyr1", "c.n.bs_oaa1_aux", "d.n.bs_pep4a", "d.n.bs_pep4a", "d.n.bs_pep4a", "d.n.bs_pyr1_aux", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "d.n.bs_oaa3b", "d.n.bs_akg4_aux", "c.n.bs_pga2_aux", "c.n.bs_rib5p1_aux", "c.n.bs_pyr", "c.n.bs_pep", "d.n.bs_akg1", "d.n.citsynth", "d.n.citsynth", "d.n.citsynth", "c.n.bs_oaa5_aux", "c.n.bs_pga3_aux", "d.n.bs_pyr4", "d.n.tk2", "d.n.tk2", "d.n.tk2", "d.n.tk2", "c.n.bs_akg2", "d.n.bs_oaa4", "d.n.pfk", "d.n.bs_oaa2", "d.n.bs_oaa2", "d.n.bs_oaa2", "d.n.bs_oaa2", "f.n.zwf", "c.n.bs_akg", "c.n.bs_pep4_aux", "d.n.bs_pep3b", "d.n.bs_pep3b", "d.n.bs_pep3b", "d.n.bs_pep4b", "d.n.bs_pep4b", "d.n.bs_pep4b", "c.n.bs_DHAP", "c.n.bs_fru6P", "d.n.mae", "d.n.mae", "d.n.mae", "d.n.bs_pep3a", "d.n.bs_pep3a", "d.n.bs_pep3a", "d.n.bs_akg4", "d.n.bs_akg4", "d.n.bs_akg4", "c.n.bs_oaa2_aux", "d.n.bs_oaa5", "c.n.bs_pyr4_aux", "d.n.bs_rib5p2", "d.n.bs_oaa3a", "d.n.bs_oaa3a", "d.n.bs_oaa3a", "d.n.bs_oaa3a", "d.n.pgi", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.bs_pyr2", "d.n.out_co2", "c.n.bs_pga1_aux", "f.n.pyk", "c.n.bs_pep3_aux", "d.n.Glucupt_U", "d.n.idh", "d.n.idh", "d.n.idh", "c.n.bs_rib5p")
names(edge2fl)=c("GA3P (ta) ta", "Sed7P (ta) ta", "ta (ta) Ery4P", "ta (ta) Fru6P", "BM_OAA (bs_oaa7) Asn", "BM_PGA (bs_pga1) Ser", "AcCoA (out_Ac) Acetate", "BM_OAA (bs_oaa6) bs_oaa6", "FTHF (bs_oaa6) bs_oaa6", "bs_oaa6 (bs_oaa6) Met", "Ser (bs_pga2) Cys", "Gnt6P (edd) edd", "edd (edd) Pyr", "edd (edd) GA3P", "Gnt6P (gnd) gnd", "gnd (gnd) CO2", "gnd (gnd) Rib5P", "PyrCO2 (bs_pep7) bs_pep7", "bs_pep7 (bs_pep7) Pyr", "bs_pep7 (bs_pep7) CO2", "Glc6P (bs_glc6P) BM_Glc6P", "BM_OAA (bs_oaa1) Asp", "Ery4P (bs_e4p) BM_Ery4P", "BM_AcCoA (bs_accoa_aux) AcCoA_Aux", "BM_PEP (bs_pep5) PEP_Aux", "BM_PEP (bs_pep1) bs_pep1", "BM_Ery4P (bs_pep1) bs_pep1", "bs_pep1 (bs_pep1) DAHP", "Gluc_1 (Glucupt_1) Glc6P", "PEP (ppc) ppc", "CO2 (ppc) ppc", "ppc (ppc) OAA", "AcCoA (bs_accoa) BM_AcCoA", "Glu (bs_akg3) Gln", "BM_PEP (bs_pep2) bs_pep2", "DAHP (bs_pep2) bs_pep2", "bs_pep2 (bs_pep2) Chor", "Asn (bs_oaa7_aux) Asn_Aux", "Chor (bs_pep6) bs_pep6", "BM_Rib5P (bs_pep6) bs_pep6", "bs_pep6 (bs_pep6) Trp", "bs_pep6 (bs_pep6) PyrCO2", "AKV (bs_pyr3) bs_pyr3", "BM_AcCoA (bs_pyr3) bs_pyr3", "bs_pyr3 (bs_pyr3) Leu", "bs_pyr3 (bs_pyr3) CO2", "AKG (akgdh) akgdh", "akgdh (akgdh) Suc", "akgdh (akgdh) CO2", "PGA (eno) PEP", "BM_Rib5P (bs_rib5p1) bs_rib5p1", "FTHF (bs_rib5p1) bs_rib5p1", "bs_rib5p1 (bs_rib5p1) His", "PGA (bs_pga) BM_PGA", "OAA (bs_oaa) BM_OAA", "FruBP (ald) ald", "ald (ald1) GA3P", "ald (ald2) GA3P", "Rib5P (tk11) tk1", "Rib5P (tk12) tk1", "tk1 (tk1) GA3P", "tk1 (tk1) Sed7P", "Mal (maldh) OAA", "Lys (bs_oaa3_aux) Lys_Aux", "GA3P (pgk) PGA", "Met (bs_oaa6_aux) Met_Aux", "FTHF (out_FTHF) FTHF_out", "Pyr (pdh) pdh", "pdh (pdh) AcCoA", "pdh (pdh) CO2", "Leu (bs_pyr3_aux) Leu_Aux", "Ser (bs_pga3) bs_pga3", "bs_pga3 (bs_pga3) Gly", "bs_pga3 (bs_pga3) FTHF", "Trp (bs_pep6_aux) Trp_Aux", "Suc (fum_b) Mal", "Suc (fum_a) Mal", "BM_PGA (bs_pga_aux) PGA_Aux", "BM_Pyr (bs_pyr1) Ala", "Asp (bs_oaa1_aux) Asp_Aux", "Chor (bs_pep4a) bs_pep4a", "bs_pep4a (bs_pep4a) Tyr", "bs_pep4a (bs_pep4a) CO2", "Ala (bs_pyr1_aux) Ala_Aux", "BM_OAA (bs_oaa3b) bs_oaa3b", "BM_Pyr (bs_oaa3b) bs_oaa3b", "bs_oaa3b (bs_oaa3b) Lys", "bs_oaa3b (bs_oaa3b) CO2", "Arg (bs_akg4_aux) Arg_Aux", "Cys (bs_pga2_aux) Cys_Aux", "His (bs_rib5p1_aux) His_Aux", "Pyr (bs_pyr) BM_Pyr", "PEP (bs_pep) BM_PEP", "BM_AKG (bs_akg1) Glu", "AcCoA (citsynth) citsynth", "OAA (citsynth) citsynth", "citsynth (citsynth) ICit", "Thr (bs_oaa5_aux) Thr_Aux", "Gly (bs_pga3_aux) Gly_Aux", "AKV (bs_pyr4) Val", "Rib5P (tk2) tk2", "Ery4P (tk2) tk2", "tk2 (tk2) GA3P", "tk2 (tk2) Fru6P", "Glu (bs_akg2) Pro", "BM_OAA (bs_oaa4) OAA_Aux", "Fru6P (pfk) FruBP", "Thr (bs_oaa2) bs_oaa2", "BM_Pyr (bs_oaa2) bs_oaa2", "bs_oaa2 (bs_oaa2) Ile", "bs_oaa2 (bs_oaa2) CO2", "Glc6P (zwf) Gnt6P", "AKG (bs_akg) BM_AKG", "Tyr (bs_pep4_aux) Tyr_Aux", "Chor (bs_pep3b) bs_pep3b", "bs_pep3b (bs_pep3b) Phe", "bs_pep3b (bs_pep3b) CO2", "Chor (bs_pep4b) bs_pep4b", "bs_pep4b (bs_pep4b) Tyr", "bs_pep4b (bs_pep4b) CO2", "GA3P (bs_DHAP) Glp", "Fru6P (bs_fru6P) BM_Fru6P", "Mal (mae) mae", "mae (mae) Pyr", "mae (mae) CO2", "Chor (bs_pep3a) bs_pep3a", "bs_pep3a (bs_pep3a) Phe", "bs_pep3a (bs_pep3a) CO2", "Glu (bs_akg4) bs_akg4", "CO2 (bs_akg4) bs_akg4", "bs_akg4 (bs_akg4) Arg", "Ile (bs_oaa2_aux) Ile_Aux", "BM_OAA (bs_oaa5) Thr", "Val (bs_pyr4_aux) Val_Aux", "BM_Rib5P (bs_rib5p2) Ri5P_Aux", "BM_OAA (bs_oaa3a) bs_oaa3a", "BM_Pyr (bs_oaa3a) bs_oaa3a", "bs_oaa3a (bs_oaa3a) Lys", "bs_oaa3a (bs_oaa3a) CO2", "Glc6P (pgi) Fru6P", "BM_Pyr (bs_pyr21) bs_pyr2", "BM_Pyr (bs_pyr22) bs_pyr2", "bs_pyr2 (bs_pyr2) AKV", "bs_pyr2 (bs_pyr2) CO2", "CO2 (out_co2) CO2_out", "Ser (bs_pga1_aux) Ser_Aux", "PEP (pyk) Pyr", "Phe (bs_pep3_aux) Phe_Aux", "Gluc_U (Glucupt_U) Glc6P", "ICit (idh) idh", "idh (idh) AKG", "idh (idh) CO2", "Rib5P (bs_rib5p) BM_Rib5P")

# initialize the linear system Afl*flnx=bfl (0-weight cumomers)
# unknown net flux names
nm_fln=c("d.n.Glucupt_U", "d.n.akgdh", "d.n.ald", "d.n.bs_accoa_aux", "d.n.bs_akg1", "d.n.bs_akg4", "d.n.bs_akg4_aux", "d.n.bs_e4p", "d.n.bs_oaa1", "d.n.bs_oaa2", "d.n.bs_oaa3a", "d.n.bs_oaa3b", "d.n.bs_oaa4", "d.n.bs_oaa5", "d.n.bs_oaa6", "d.n.bs_oaa7", "d.n.bs_pep1", "d.n.bs_pep2", "d.n.bs_pep3a", "d.n.bs_pep3b", "d.n.bs_pep4a", "d.n.bs_pep4b", "d.n.bs_pep6", "d.n.bs_pep6_aux", "d.n.bs_pep7", "d.n.bs_pga1", "d.n.bs_pga2", "d.n.bs_pga3", "d.n.bs_pga_aux", "d.n.bs_pyr1", "d.n.bs_pyr1_aux", "d.n.bs_pyr2", "d.n.bs_pyr3", "d.n.bs_pyr4", "d.n.bs_rib5p1", "d.n.bs_rib5p2", "d.n.citsynth", "d.n.edd", "d.n.eno", "d.n.fum_a", "d.n.fum_b", "d.n.idh", "d.n.mae", "d.n.maldh", "d.n.out_FTHF", "d.n.out_co2", "d.n.pdh", "d.n.pfk", "d.n.pgi", "d.n.pgk", "d.n.ppc", "d.n.ta", "d.n.tk1", "d.n.tk2")
nb_fln=length(nm_fln)
fln=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
names(fln)=nm_fln
# unknown xch flux names
nm_flx=c("d.x.fum_b")
nb_flx=length(nm_flx)
flx=c(0.0)
names(flx)=nm_flx
nm_fl=c(nm_fln, nm_flx)
nb_fl=nb_fln+nb_flx
fl=c(fln, flx)
# gather flux names in a list
nm_list$flnx=nm_fl
nm_list$fwrv=nm_fwrv

# carbon length of metabolites
clen=c(3,7,4,6,4,4,3,3,2,2,1,5,3,6,3,1,5,4,6,6,4,4,2,2,3,3,7,6,3,4,5,5,10,4,5,11,5,6,5,4,3,6,6,4,6,6,5,1,6,2,11,3,3,3,4,9,3,6,6,3,6,5,6,4,4,2,5,5,4,6,9,9,3,6,6,5,5,1,3,9,6)
names(clen)=c("GA3P","Sed7P","Ery4P","Fru6P","BM_OAA","Asn","BM_PGA","Ser","AcCoA","Acetate","FTHF","Met","Cys","Gnt6P","Pyr","CO2","Rib5P","PyrCO2","Glc6P","BM_Glc6P","Asp","BM_Ery4P","BM_AcCoA","AcCoA_Aux","BM_PEP","PEP_Aux","DAHP","Gluc_1","PEP","OAA","Glu","Gln","Chor","Asn_Aux","BM_Rib5P","Trp","AKV","Leu","AKG","Suc","PGA","His","FruBP","Mal","Lys","Lys_Aux","Met_Aux","FTHF_out","Leu_Aux","Gly","Trp_Aux","PGA_Aux","BM_Pyr","Ala","Asp_Aux","Tyr","Ala_Aux","Arg","Arg_Aux","Cys_Aux","His_Aux","BM_AKG","ICit","Thr","Thr_Aux","Gly_Aux","Val","Pro","OAA_Aux","Ile","Tyr_Aux","Phe","Glp","BM_Fru6P","Ile_Aux","Val_Aux","Ri5P_Aux","CO2_out","Ser_Aux","Phe_Aux","Gluc_U")

# metabolite pools are : all (poolall) which is divided in free (poolf) and
# constrained (poolc)

# constrained pool
poolc=c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
nm_poolc=c("pc:AKV", "pc:AcCoA", "pc:Ala", "pc:Arg", "pc:Asn", "pc:Asp", "pc:BM_AKG", "pc:BM_AcCoA", "pc:BM_Ery4P", "pc:BM_OAA", "pc:BM_PEP", "pc:BM_PGA", "pc:BM_Pyr", "pc:BM_Rib5P", "pc:CO2", "pc:Chor", "pc:Cys", "pc:DAHP", "pc:FTHF", "pc:Glc6P", "pc:Glu", "pc:Gly", "pc:His", "pc:Ile", "pc:Leu", "pc:Lys", "pc:Mal", "pc:Met", "pc:Phe", "pc:PyrCO2", "pc:Ser", "pc:Thr", "pc:Trp", "pc:Tyr", "pc:Val")
if (length(nm_poolc)) {
   names(nm_poolc)=substring(nm_poolc, 4)
}
names(poolc)=nm_poolc

# starting values for free pool (the same number and the same alphabetic order than free growth fluxes, if present)
poolf=c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
nm_poolf=c("pf:AKG", "pf:Ery4P", "pf:Fru6P", "pf:FruBP", "pf:GA3P", "pf:Gnt6P", "pf:ICit", "pf:OAA", "pf:PEP", "pf:PGA", "pf:Pyr", "pf:Rib5P", "pf:Sed7P", "pf:Suc")
if (length(nm_poolf)) {
   names(nm_poolf)=substring(nm_poolf, 4)
}
names(poolf)=nm_poolf
nb_poolf=length(poolf)
nb_f$nb_poolf=nb_poolf

nm_poolall=c(nm_poolf, nm_poolc)
poolall=as.numeric(c(poolf, poolc))
names(poolall)=nm_poolall
pool=poolall
nm_list$poolf=nm_poolf
nm_list$poolc=nm_poolc
nm_list$poolall=nm_poolall

# flux matrix
nb_flr=55
if (nb_fl) {
   Afl=matrix(0, nrow=nb_flr, ncol=nb_fl)
   Afl[1, c(3, 38, 50, 52, 53, 54)]=c(2.0, 1.0, -1.0, -1.0, 1.0, 1.0)
   Afl[2, c(52, 53)]=c(-1.0, 1.0)
   Afl[3, c(8, 52, 54)]=c(-1.0, 1.0, -1.0)
   Afl[4, c(48, 49, 52, 54)]=c(-1.0, 1.0, 1.0, 1.0)
   Afl[5, c(9, 11, 12, 13, 14, 15, 16)]=c(-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0)
   Afl[6, c(16)]=c(1.0)
   Afl[7, c(26, 29)]=c(-1.0, -1.0)
   Afl[8, c(26, 27, 28)]=c(1.0, -1.0, -1.0)
   Afl[9, c(37, 47)]=c(-1.0, 1.0)
   Afl[10, c(15, 28, 35, 45)]=c(-1.0, 1.0, -1.0, -1.0)
   Afl[11, c(15)]=c(1.0)
   Afl[12, c(27)]=c(1.0)
   Afl[13, c(38)]=c(-1.0)
   Afl[14, c(25, 38, 43, 47)]=c(1.0, 1.0, 1.0, -1.0)
   Afl[15, c(2, 6, 10, 11, 12, 19, 20, 21, 22, 25, 32, 33, 42, 43, 46, 47, 51)]=c(1.0, -1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, -1.0, 1.0, -1.0)
   Afl[16, c(53, 54)]=c(-2.0, -1.0)
   Afl[17, c(23, 25)]=c(1.0, -1.0)
   Afl[18, c(1, 49)]=c(1.0, -1.0)
   Afl[19, c(9)]=c(1.0)
   Afl[20, c(8, 17)]=c(1.0, -1.0)
   Afl[21, c(4, 33)]=c(-1.0, -1.0)
   Afl[22, c(17, 18)]=c(-1.0, -1.0)
   Afl[23, c(17, 18)]=c(1.0, -1.0)
   Afl[24, c(39, 51)]=c(1.0, -1.0)
   Afl[25, c(37, 44, 51)]=c(-1.0, 1.0, 1.0)
   Afl[26, c(5, 6)]=c(1.0, -1.0)
   Afl[27, c(18, 19, 20, 21, 22, 23)]=c(1.0, -1.0, -1.0, -1.0, -1.0, -1.0)
   Afl[28, c(23, 35, 36)]=c(-1.0, -1.0, -1.0)
   Afl[29, c(23, 24)]=c(1.0, -1.0)
   Afl[30, c(32, 33, 34)]=c(1.0, -1.0, -1.0)
   Afl[31, c(33)]=c(1.0)
   Afl[32, c(2, 42)]=c(-1.0, 1.0)
   Afl[33, c(2, 40, 41)]=c(1.0, -1.0, -1.0)
   Afl[34, c(39, 50)]=c(-1.0, 1.0)
   Afl[35, c(35)]=c(1.0)
   Afl[36, c(3, 48)]=c(-1.0, 1.0)
   Afl[37, c(40, 41, 43, 44)]=c(1.0, 1.0, -1.0, -1.0)
   Afl[38, c(11, 12)]=c(1.0, 1.0)
   Afl[39, c(28)]=c(1.0)
   Afl[40, c(10, 11, 12, 30, 32)]=c(-1.0, -1.0, -1.0, -1.0, -2.0)
   Afl[41, c(30, 31)]=c(1.0, -1.0)
   Afl[42, c(21, 22)]=c(1.0, 1.0)
   Afl[43, c(6, 7)]=c(1.0, -1.0)
   Afl[44, c(5)]=c(-1.0)
   Afl[45, c(37, 42)]=c(1.0, -1.0)
   Afl[46, c(10, 14)]=c(-1.0, 1.0)
   Afl[47, c(34)]=c(1.0)
   Afl[48, c(10)]=c(1.0)
   Afl[49, c(19, 20)]=c(1.0, 1.0)
   Afl[50, c(40, 41)]=c(1.0, -1.0)
   Afl[51, c(1)]=c(1.0)
   Afl[52, c(11, 12)]=c(1.0, -1.0)
   Afl[53, c(19, 20)]=c(1.0, -1.0)
   Afl[54, c(21, 22)]=c(1.0, -1.0)
   Afl[55, c(55)]=c(-1.0)
} else {
   Afl=matrix(0., nb_fl, nb_fl)
}
dimnames(Afl)=list(c("GA3P", "Sed7P", "Ery4P", "Fru6P", "BM_OAA", "Asn", "BM_PGA", "Ser", "AcCoA", "FTHF", "Met", "Cys", "Gnt6P", "Pyr", "CO2", "Rib5P", "PyrCO2", "Glc6P", "Asp", "BM_Ery4P", "BM_AcCoA", "BM_PEP", "DAHP", "PEP", "OAA", "Glu", "Chor", "BM_Rib5P", "Trp", "AKV", "Leu", "AKG", "Suc", "PGA", "His", "FruBP", "Mal", "Lys", "Gly", "BM_Pyr", "Ala", "Tyr", "Arg", "BM_AKG", "ICit", "Thr", "Val", "Ile", "Phe", "eq net: fum_a-fum_b=0: 588", "eq net: Glucupt_1+Glucupt_U=1: 589", "eq net: bs_oaa3a-bs_oaa3b=0: 590", "eq net: bs_pep3a-bs_pep3b=0: 591", "eq net: bs_pep4a-bs_pep4b=0: 592", "eq xch: fum_a-fum_b=0: 597"), nm_fl)
#browser()
# prepare param (\Theta) vector
# order: free flux net, free flux xch, scale label, scale mass, scale peak
param=numeric(0)
nm_par=c()
# free net fluxes
nb_ffn=5
nm_ffn=c("f.n.Glucupt_1", "f.n.gnd", "f.n.out_Ac", "f.n.pyk", "f.n.zwf")
# starting values for iterations
param=c(param, c(0.7, 0.15062, 0.213, 1.4, 0.2))
if (nb_ffn) {
   nm_par=c(nm_par, nm_ffn)
}
# free xch fluxes
nb_ffx=7
nm_ffx=c("f.x.ald", "f.x.eno", "f.x.fum_a", "f.x.ppc", "f.x.ta", "f.x.tk1", "f.x.tk2")
# starting values for iterations
param=c(param, c(0.413926, 0.800962, 0.395958, 0.256772, 0.359468, 0.166316, 0.00211559))
if (nb_ffx) {
   nm_par=c(nm_par, nm_ffx)
}
names(param)=nm_par
ff=param
nm_ff=c(nm_ffn, nm_ffx)
nm_list$ff=nm_ff
nb_param=length(param)
# scaling factors are added to param later

nb_ff=nb_ffn+nb_ffx

# constrained fluxes
# net
nb_fcn=27
nm_fcn=c("c.n.bs_DHAP", "c.n.bs_accoa", "c.n.bs_akg", "c.n.bs_akg2", "c.n.bs_akg3", "c.n.bs_fru6P", "c.n.bs_glc6P", "c.n.bs_oaa", "c.n.bs_oaa1_aux", "c.n.bs_oaa2_aux", "c.n.bs_oaa3_aux", "c.n.bs_oaa5_aux", "c.n.bs_oaa6_aux", "c.n.bs_oaa7_aux", "c.n.bs_pep", "c.n.bs_pep3_aux", "c.n.bs_pep4_aux", "c.n.bs_pep5", "c.n.bs_pga", "c.n.bs_pga1_aux", "c.n.bs_pga2_aux", "c.n.bs_pga3_aux", "c.n.bs_pyr", "c.n.bs_pyr3_aux", "c.n.bs_pyr4_aux", "c.n.bs_rib5p", "c.n.bs_rib5p1_aux")
fcn=c(0.0068, 0.1565, 0.0571, 0.0111, 0.0132, 0.0038, 0.0109, 0.0947, 0.0121, 0.0146, 0.0173, 0.0128, 0.0077, 0.0121, 0.0381, 0.0093, 0.0069, 0.0027, 0.0791, 0.0109, 0.0046, 0.0308, 0.1501, 0.0227, 0.0213, 0.0476, 0.0048)
# xch
nb_fcx=78
nm_fcx=c("c.x.Glucupt_1", "c.x.Glucupt_U", "c.x.akgdh", "c.x.bs_DHAP", "c.x.bs_accoa", "c.x.bs_accoa_aux", "c.x.bs_akg", "c.x.bs_akg1", "c.x.bs_akg2", "c.x.bs_akg3", "c.x.bs_akg4", "c.x.bs_akg4_aux", "c.x.bs_e4p", "c.x.bs_fru6P", "c.x.bs_glc6P", "c.x.bs_oaa", "c.x.bs_oaa1", "c.x.bs_oaa1_aux", "c.x.bs_oaa2", "c.x.bs_oaa2_aux", "c.x.bs_oaa3_aux", "c.x.bs_oaa3a", "c.x.bs_oaa3b", "c.x.bs_oaa4", "c.x.bs_oaa5", "c.x.bs_oaa5_aux", "c.x.bs_oaa6", "c.x.bs_oaa6_aux", "c.x.bs_oaa7", "c.x.bs_oaa7_aux", "c.x.bs_pep", "c.x.bs_pep1", "c.x.bs_pep2", "c.x.bs_pep3_aux", "c.x.bs_pep3a", "c.x.bs_pep3b", "c.x.bs_pep4_aux", "c.x.bs_pep4a", "c.x.bs_pep4b", "c.x.bs_pep5", "c.x.bs_pep6", "c.x.bs_pep6_aux", "c.x.bs_pep7", "c.x.bs_pga", "c.x.bs_pga1", "c.x.bs_pga1_aux", "c.x.bs_pga2", "c.x.bs_pga2_aux", "c.x.bs_pga3", "c.x.bs_pga3_aux", "c.x.bs_pga_aux", "c.x.bs_pyr", "c.x.bs_pyr1", "c.x.bs_pyr1_aux", "c.x.bs_pyr2", "c.x.bs_pyr3", "c.x.bs_pyr3_aux", "c.x.bs_pyr4", "c.x.bs_pyr4_aux", "c.x.bs_rib5p", "c.x.bs_rib5p1", "c.x.bs_rib5p1_aux", "c.x.bs_rib5p2", "c.x.citsynth", "c.x.edd", "c.x.gnd", "c.x.idh", "c.x.mae", "c.x.maldh", "c.x.out_Ac", "c.x.out_FTHF", "c.x.out_co2", "c.x.pdh", "c.x.pfk", "c.x.pgi", "c.x.pgk", "c.x.pyk", "c.x.zwf")
fcx=c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.011799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.647115, 0.0, 0.0, 0.0, 0.0322745, 0.0, 0.752386, 0.984718, 0.0109591, 0.0)
fc=c(fcn, fcx)
nm_fc=c(nm_fcn, nm_fcx)
names(fc)=nm_fc
nb_fc=nb_fcn+nb_fcx

# variable growth fluxes (constant are already accounted in constrained fluxes)
nb_fgr=0
nm_fgr=c()
fgr=c()
nm_list$fgr=nm_fgr
nb_f$nb_fgr=nb_fgr

# total flux vector fallnx dimension
nb_fallnx=nb_fl+nb_ff+nb_fc+nb_fgr+nb_fgr
nb_fwrv=nb_fallnx

# net dependent and free fluxes
nm_dfn=c(nm_fln, nm_ffn)
names(nm_dfn)=substring(nm_dfn, 5)

# all flux cardinals
nb_f=append(nb_f, list(nb_fln=nb_fln, nb_flx=nb_flx, nb_fl=nb_fl,
   nb_ffn=nb_ffn, nb_ffx=nb_ffx, nb_ff=nb_ff,
   nb_fcn=nb_fcn, nb_fcx=nb_fcx, nb_fc=nb_fc,
   nb_fallnx=nb_fallnx, nb_fwrv=nb_fwrv,
   nb_fgr=nb_fgr,
   include_growth_flux=FALSE,
   mu=NULL))

# prepare p2bfl, c2bfl, g2bfl, cnst2bfl matrices such that p2bfl%*%param[1:nb_ff]+
# c2bfl%*%fc+g2bfl%*%fgr+cnst2bfl=bfl
# replace f.[nx].flx by corresponding param coefficient
p2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_ff)
# replace c.[nx].flx by corresponding fc coefficient
c2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fc)
# variable growth fluxes
g2bfl=simple_triplet_zero_matrix(nrow=nb_flr, ncol=nb_fgr)
cnst2bfl=numeric(nb_flr); # may be coming from equalities
colnames(p2bfl)=nm_par
colnames(c2bfl)=nm_fc
colnames(g2bfl)=nm_fgr

c2bfl[1, pmatch(c("c.n.bs_DHAP"), nm_fc)]=c(1.0);

c2bfl[4, pmatch(c("c.n.bs_fru6P"), nm_fc)]=c(1.0);

c2bfl[5, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(-1.0);

c2bfl[6, pmatch(c("c.n.bs_oaa7_aux"), nm_fc)]=c(1.0);

c2bfl[7, pmatch(c("c.n.bs_pga"), nm_fc)]=c(-1.0);

c2bfl[8, pmatch(c("c.n.bs_pga1_aux"), nm_fc)]=c(1.0);

p2bfl[9, pmatch(c("f.n.out_Ac"), nm_par)]=c(1.0);
c2bfl[9, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(1.0);

c2bfl[11, pmatch(c("c.n.bs_oaa6_aux"), nm_fc)]=c(1.0);

c2bfl[12, pmatch(c("c.n.bs_pga2_aux"), nm_fc)]=c(1.0);

p2bfl[13, pmatch(c("f.n.gnd", "f.n.zwf"), nm_par)]=c(1.0, -1.0);

p2bfl[14, pmatch(c("f.n.pyk"), nm_par)]=c(-1.0);
c2bfl[14, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(1.0);

p2bfl[15, pmatch(c("f.n.gnd"), nm_par)]=c(-1.0);

p2bfl[16, pmatch(c("f.n.gnd"), nm_par)]=c(-1.0);
c2bfl[16, pmatch(c("c.n.bs_rib5p"), nm_fc)]=c(1.0);

p2bfl[18, pmatch(c("f.n.zwf", "f.n.Glucupt_1"), nm_par)]=c(1.0, -1.0);
c2bfl[18, pmatch(c("c.n.bs_glc6P"), nm_fc)]=c(1.0);

c2bfl[19, pmatch(c("c.n.bs_oaa1_aux"), nm_fc)]=c(1.0);

c2bfl[21, pmatch(c("c.n.bs_accoa"), nm_fc)]=c(-1.0);

c2bfl[22, pmatch(c("c.n.bs_pep5", "c.n.bs_pep"), nm_fc)]=c(1.0, -1.0);

p2bfl[24, pmatch(c("f.n.pyk"), nm_par)]=c(1.0);
c2bfl[24, pmatch(c("c.n.bs_pep"), nm_fc)]=c(1.0);

c2bfl[25, pmatch(c("c.n.bs_oaa"), nm_fc)]=c(1.0);

c2bfl[26, pmatch(c("c.n.bs_akg3", "c.n.bs_akg2"), nm_fc)]=c(1.0, 1.0);

c2bfl[28, pmatch(c("c.n.bs_rib5p"), nm_fc)]=c(-1.0);

c2bfl[31, pmatch(c("c.n.bs_pyr3_aux"), nm_fc)]=c(1.0);

c2bfl[32, pmatch(c("c.n.bs_akg"), nm_fc)]=c(1.0);

c2bfl[34, pmatch(c("c.n.bs_pga"), nm_fc)]=c(1.0);

c2bfl[35, pmatch(c("c.n.bs_rib5p1_aux"), nm_fc)]=c(1.0);

c2bfl[38, pmatch(c("c.n.bs_oaa3_aux"), nm_fc)]=c(1.0);

c2bfl[39, pmatch(c("c.n.bs_pga3_aux"), nm_fc)]=c(1.0);

c2bfl[40, pmatch(c("c.n.bs_pyr"), nm_fc)]=c(-1.0);

c2bfl[42, pmatch(c("c.n.bs_pep4_aux"), nm_fc)]=c(1.0);

c2bfl[44, pmatch(c("c.n.bs_akg"), nm_fc)]=c(-1.0);

c2bfl[46, pmatch(c("c.n.bs_oaa5_aux"), nm_fc)]=c(1.0);

c2bfl[47, pmatch(c("c.n.bs_pyr4_aux"), nm_fc)]=c(1.0);

c2bfl[48, pmatch(c("c.n.bs_oaa2_aux"), nm_fc)]=c(1.0);

c2bfl[49, pmatch(c("c.n.bs_pep3_aux"), nm_fc)]=c(1.0);


p2bfl[51, pmatch(c("f.n.Glucupt_1"), nm_par)]=c(-1.0);
cnst2bfl[51]=1;




p2bfl[55, pmatch(c("f.x.fum_a"), nm_par)]=c(-1.0);

bp=as.numeric(c2bfl%stm%fc+cnst2bfl)

if (ffguess) {
   # make an automatic guess for free/dependent flux partition
   afd=as.matrix(cBind(Afl, -p2bfl))
   qafd=qr(afd, LAPACK=T)
   d=abs(diag(qafd$qr))
   rank=sum(d > d[1]*1.e-10)
   qrow=qr(t(afd))
   rankr=qrow$rank
   if (rank != rankr) {
      mes="Weird error: column and row ranks are not equal.\n"
      stop_mes(mes, file=fcerr)
   }
   irows=qrow$pivot[seq_len(rankr)]
   if (rank==0) {
      stop_mes("Error: No free/dependent flux partition could be made. Stoechiometric matrix has rank=0.\n", file=fcerr)
   }
   Afl=afd[irows, qafd$pivot[1L:rank], drop=FALSE]
   ka=kappa(Afl)
   if (ka > 1.e7) {
      mes=sprintf("Error: No working free/dependent flux partition could be proposed. Stoechiometric matrix has condition number %g.\n", ka)
      stop_mes(mes, file=fcerr)
   }
   p2bfl=-as.simple_triplet_matrix(afd[irows, qafd$pivot[-seq_len(rank)], drop=FALSE])
   c2bfl=c2bfl[irows, , drop=FALSE]
   g2bfl=g2bfl[irows, , drop=FALSE]
   cnst2bfl=cnst2bfl[irows]
   bp=bp[irows]
   
   # replace names
   nm_fl=sub("f.", "d.", colnames(Afl), fixed=T)
   colnames(Afl)=nm_fl # both net and xch
   nm_fln=sort(grep("^d.n.", nm_fl, v=T))
   nm_flx=sort(grep("^d.x.", nm_fl, v=T))
   nm_fl=c(nm_fln, nm_flx)
   Afl=Afl[, nm_fl, drop=FALSE]
   
   nm_ff=sub("d.", "f.", colnames(p2bfl), fixed=T) # both net and xch
   colnames(p2bfl)=nm_ff
   nm_ffn=sort(grep("^f.n.", nm_ff, v=T))
   nm_ffx=sort(grep("^f.x.", nm_ff, v=T))
   nm_ff=c(nm_ffn, nm_ffx)
   p2bfl=p2bfl[, nm_ff, drop=FALSE]
   
   # remake param vector
   if (!fdfit)
      param=c(runif(length(nm_ff)), if (nb_ff == 0) param else param[-seq_len(nb_ff)])
   names(param)[seq(along=nm_ff)]=nm_ff
#browser()
}
nm_list$flnx=nm_fl
nm_fallnx=c(nm_fln, nm_ffn, nm_fcn, nm_fgr, nm_flx, nm_ffx, nm_fcx, sub(".n.", ".x.", nm_fgr, fixed=T))
nm_list$fallnx=nm_fallnx
nm_net=c(nm_fln, nm_ffn, nm_fcn)
names(nm_net)=substring(nm_net, 5)
nm_xch=c(nm_flx, nm_ffx, nm_fcx)
names(nm_xch)=substring(nm_xch, 5)
edge2fl[]=nm_net[substring(edge2fl, 5)]
nm_list$ff=nm_ff

# accounting numbers
nb_flr=nrow(Afl)
nb_param=length(param)
nb_ffn=length(nm_ffn)
nb_ffx=length(nm_ffx)
nb_ff=nb_ffn+nb_ffx
nb_fln=length(nm_fln)
nb_flx=length(nm_flx)
nb_fl=nb_fln+nb_flx
nm_par=names(param)

for (item in c("nb_fln", "nb_flx", "nb_fl", "nb_ffn", "nb_ffx", "nb_ff")) {
   nb_f[item]=get(item)
}
# translation from n-x to fw-rv
sh_fwrv=substring(nm_fwrv[1:(nb_fwrv/2)], 5)
sh_nx=substring(nm_fallnx, 2)
nb_f$inet2ifwrv=pmatch(paste(".n.", sh_fwrv, sep=""), sh_nx)
nb_f$ixch2ifwrv=pmatch(paste(".x.", sh_fwrv, sep=""), sh_nx)
#nb_f$inet2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.n\\.%s$", substring(f, 5)), nm_fallnx))
#nb_f$ixch2ifwrv=sapply(nm_fwrv[1:(nb_fwrv/2)], function(f) grep(sprintf("^.\\.x\\.%s$", substring(f, 5)), nm_fallnx))

if (TIMEIT) {
   cat("Afl qr(): ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

qrAfl=qr(Afl, LAPACK=T)
d=abs(diag(qrAfl$qr))
qrAfl$rank=sum(d > d[1]*1.e-10)
rank=qrAfl$rank
aful=as.matrix(cBind(Afl, -p2bfl, -c2bfl))
qrow=qr(t(aful))
rankr=qrow$rank
#browser()
# first check the presence of lindep rows
if (nrow(Afl) > rankr) {
   prop=sprintf("Error: Among %d equations (rows), %d are redundant and must be eliminated by hand.\n", nrow(Afl), nrow(Afl)-rankr)
   prop=paste(prop, "Candidate(s) for elimination is (are):\n",
      paste(rownames(Afl)[qrow$pivot[-(1:rankr)]], sep="", collapse="\n"),
               "\n", sep="")
   stop_mes(prop, file=fcerr)
}
if (nrow(Afl) != rank || nrow(Afl) != ncol(Afl)) {
   #write.table(Afl)
   mes=NULL
   if (nrow(Afl) <= rank) {
      mes=paste("Candidate(s) for free or constrained flux(es):\n",
         paste(colnames(Afl)[-qrAfl$pivot[1L:nrow(Afl)]], collapse="\n"),
         "\nFor this choice, condition number of stoechiometric matrix will be ",
         kappa(Afl[,qrAfl$pivot[1L:nrow(Afl)],drop=FALSE]), "\n", sep="")
   } else if (nrow(Afl) > rank) {
      nextra=nrow(Afl)-rank
      comb=combn(c(nm_ffn, colnames(Afl)[-qrAfl$pivot[1L:rank]]), nextra)
      aextra=cBind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl)
      colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl))
      ara=Afl[,qrAfl$pivot[1L:rank],drop=FALSE]
      i=which.min(apply(comb, 2, function(i) kappa(cBind(ara, aextra[,i]))))[1L]
      nm_tmp=comb[,i]
      ka=kappa(cBind(ara, aextra[,nm_tmp]))
      if (ka < 1.e7) {
         prop=paste("Proposal to declare dependent flux(es) is:\n",
            paste(nm_tmp, collapse="\n"), "\n", sep="")
         if (rank < ncol(Afl)) {
            prop=prop%s+%"While the following dependent flux(es) should be declared free or constrained:\n"%s+%join("\n", colnames(Afl)[-qrAfl$pivot[1L:rank]])%s+%"\n"
         }
         prop=paste(prop, "For this choice, condition number of stoechiometric matrix will be ", ka, "\n", sep="")
      } else {
         # add constraint fluxes to candidate list
         if (nb_fcn > 0) {
            aextra=as.matrix(cBind(Afl[,-qrAfl$pivot[1L:rank],drop=FALSE], -p2bfl, -c2bfl))
            colnames(aextra)=c(colnames(Afl)[-qrAfl$pivot[1L:rank]], colnames(p2bfl), colnames(c2bfl))
         }
         aextended=aful
         qae=qr(aextended, LAPACK=T)
         d=abs(diag(qae$qr))
         ranke=sum(d > d[1L]*1.e-10)
         if (ranke == nrow(Afl)) {
            prop=paste("Proposal to declare dependent flux(es) is:\n",
            join("\n", colnames(aextended)[qae$pivot[1L:ranke]]), "\n",
            "while free and constrained fluxes should be:\n",
            join("\n", colnames(aextended)[-qae$pivot[1L:ranke]]), "\n",
            sep="")
            ka=kappa(aextended[,qae$pivot[1L:ranke]])
            prop=paste(prop, "For this choice, condition number of stoechiometric matrix will be ", ka, "\n", sep="")
         } else {
            prop="No proposal for partition dependent/free fluxes could be made.\n"
         }
      }
      mes=paste("There is (are) probably ", nextra,
         " extra free flux(es) among the following:\n",
         paste(nm_ffn, collapse="\n"), "\n",
         prop,
         sep="")
   }
   stop_mes(paste("Flux matrix is not square or is singular: (", nrow(Afl), "eq x ", ncol(Afl), "unk)\n",
      "You have to change your choice of free fluxes in the 'e_coli_i.ftbl' file.\n",
      mes, sep=""), file=fcerr)
}

# make sure that free params choice leads to not singular matrix
if (qrAfl$rank != nb_fl) {
   #write.table(Afl)
   # make a suggestion of new free fluxes
   A=cBind(Afl, -p2bfl, -c2bfl)
   colnames(A)=c(colnames(Afl), nm_ff, nm_fc)
   qa=qr(A, LAPACK=T)
   d=diag(qa$qr)
   qa$rank=sum(abs(d)>=abs(d[1]*1.e-10))
   
   mes=paste("Error: Dependent flux matrix is singular.\n",
      "Change your partition on free/dependent/constrained fluxes in the 'e_coli_i.ftbl' file.\n",
      "Can not resolve dependent fluxe(s):\n",
      paste(colnames(Afl)[-qrAfl$pivot[(1:qrAfl$rank)]], collapse="\n"),
      sep="")
   if (qa$rank==nb_fl) {
      mes=paste(mes,
      "\n\nSuggested dependent fluxes:\n",
      paste(colnames(A)[qa$pivot[(1:qa$rank)]], collapse="\n"),
      "\n\nWhich would give the following free and constrained fluxes:\n",
      paste(colnames(A)[-qa$pivot[(1:qa$rank)]], collapse="\n"), "\n",
      sep="")
   } else {
      mes=paste(mes, "\nNo suggested free fluxes could be found", sep="")
   }
   stop_mes(mes, file=fcerr)
}

# inverse flux matrix
invAfl=solve(qrAfl)

if (fdfit) {
#browser()
   # choose free fluxe values such that they fit starting values from ftbl
   #dep=invAfl%*%(p2bfl%*%ff+bp)
   #ff=ff
   ff=qr.solve(rbind(invAfl%stm%p2bfl, diag(ncol(p2bfl))), c(fl-invAfl%*%bp, param))
}
# intermediate jacobian
if (TIMEIT) {
   cat("dfl_dffg: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

dfl_dffg=invAfl%stm%p2bfl
if (nb_fgr > 0L) {
   dfl_dffg=cBind(dfl_dffg, invAfl%stm%g2bfl)
}
dimnames(dfl_dffg)=list(nm_fl, c(nm_ff, nm_fgr))
dfl_dffg[abs(dfl_dffg) < 1.e-14]=0.
nb_f$dfl_dffg=as.simple_triplet_matrix(dfl_dffg)

# prepare mf, md, mc and mg matrices
# such that mf%*%ff+md%*%fl+mc%*%fc+mg%*%fgr gives fallnx
# here ff free fluxes (param), fl are dependent fluxes, fc are constrained
# fluxes and fgr are variable growth fluxes
mf=matrix(0., nb_fallnx, nb_ff)
dimnames(mf)=list(nm_fallnx, nm_ff)
md=matrix(0., nb_fallnx, nb_fl)
dimnames(md)=list(nm_fallnx, nm_fl)
mc=matrix(0., nb_fallnx, nb_fc)
dimnames(mc)=list(nm_fallnx, nm_fc)
mg=matrix(0., nb_fallnx, nb_fgr)
dimnames(mg)=list(nm_fallnx, nm_fgr)

if (nb_ff > 0) {
   mf[nm_ff, nm_ff]=diag(1., nb_ff)
}
if (nb_fl > 0) {
   md[nm_fl, nm_fl]=diag(1., nb_fl)
}
if (nb_fc > 0) {
   mc[nm_fc, nm_fc]=diag(1., nb_fc)
}
if (nb_fgr > 0) {
   mg[nm_fgr, nm_fgr]=diag(1., nb_fgr)
}

# sparse matrix static parts
# $varname fields:
#  ind_fa - flux index in a_pre$vfwrv[ind_fa]
#  a_pre - sparse matrix whose colsum() gives the a$v vector
#  prodx - dense matrix whose colprod() will give x[ind_x1]*x[ind_x2]*...
#  ind_fb - flux index in b_pre$v=fwrv[ind_fb1]*colprod(prodx)
#  ind_b - dense matrix of indexes for  b_pre$v=f[ind_b[,"indf"]*x[ind_b[,2+1]]*x[ind_b[,2+2]], ...]
#  b_pre - sparse matrix whose colsum gives b@x

#  a - unsigned sparse cumomer A matrix (off-diagonal part)
#  b - unsigned sparse vector of right hand side

if (TIMEIT) {
   cat("spAbr   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

nb_fwrv=172
nb_w=6
spAbr=list()

if (TIMEIT) {
   cat("weight 1: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=1
nb_c=231
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=0 # number of lighter cumomers
maxprod=1
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(78, 0, 0, 90, 0, 0, 78, 0, 40, 90, 0, 54, 80, 1, 1, 153, 1, 1, 131, 1, 1, 80, 1, 52, 153, 1, 13, 131, 1, 101, 86, 2, 2, 152, 2, 2, 156, 2, 2, 86, 2, 19, 152, 2, 50, 156, 2, 45, 165, 3, 3, 172, 3, 3, 2, 3, 3, 1, 3, 3, 165, 3, 36, 172, 3, 18, 79, 4, 4, 85, 4, 4, 83, 4, 4, 164, 4, 4, 79, 4, 33, 85, 4, 65, 83, 4, 54, 164, 4, 6, 65, 5, 5, 157, 5, 5, 65, 5, 61, 157, 5, 70, 78, 6, 6, 90, 6, 6, 78, 6, 4, 90, 6, 54, 65, 7, 7, 157, 7, 7, 65, 7, 64, 157, 7, 45, 70, 8, 8, 171, 8, 8, 170, 8, 8, 170, 8, 8, 147, 8, 8, 70, 8, 41, 171, 8, 52, 170, 8, 52, 170, 8, 102, 147, 8, 103, 70, 9, 9, 171, 9, 9, 170, 9, 9, 170, 9, 9, 147, 9, 9, 70, 9, 31, 171, 9, 27, 170, 9, 56, 170, 9, 49, 147, 9, 104, 65, 10, 10, 157, 10, 10, 65, 10, 62, 157, 10, 71, 3, 11, 11, 154, 11, 11, 155, 11, 11, 3, 11, 70, 154, 11, 105, 155, 11, 106, 3, 12, 12, 154, 12, 12, 155, 12, 12, 3, 12, 73, 154, 12, 107, 155, 12, 108, 67, 13, 13, 167, 13, 13, 118, 13, 13, 168, 13, 13, 67, 13, 1, 167, 13, 66, 118, 13, 58, 168, 13, 55, 67, 14, 14, 167, 14, 14, 118, 14, 14, 168, 14, 14, 67, 14, 17, 167, 14, 64, 118, 14, 109, 168, 14, 50, 78, 15, 15, 90, 15, 15, 78, 15, 36, 90, 15, 51, 165, 16, 16, 172, 16, 16, 2, 16, 16, 1, 16, 16, 165, 16, 40, 172, 16, 37, 80, 17, 17, 153, 17, 17, 131, 17, 17, 80, 17, 54, 153, 17, 14, 131, 17, 110, 86, 18, 18, 152, 18, 18, 156, 18, 18, 86, 18, 3, 152, 18, 51, 156, 18, 30, 165, 19, 19, 172, 19, 19, 2, 19, 19, 1, 19, 19, 165, 19, 27, 172, 19, 2, 79, 20, 20, 85, 20, 20, 83, 20, 20, 164, 20, 20, 79, 20, 35, 85, 20, 28, 83, 20, 53, 164, 20, 44, 3, 21, 21, 154, 21, 21, 155, 21, 21, 3, 21, 69, 154, 21, 106, 155, 21, 105, 65, 22, 22, 157, 22, 22, 65, 22, 46, 157, 22, 73, 79, 23, 23, 85, 23, 23, 83, 23, 23, 164, 23, 23, 79, 23, 38, 85, 23, 60, 83, 23, 52, 164, 23, 32, 65, 24, 24, 157, 24, 24, 65, 24, 66, 157, 24, 72, 80, 25, 25, 153, 25, 25, 131, 25, 25, 80, 25, 51, 153, 25, 42, 131, 25, 111, 65, 26, 26, 157, 26, 26, 65, 26, 47, 157, 26, 69, 79, 27, 27, 85, 27, 27, 83, 27, 27, 164, 27, 27, 79, 27, 19, 85, 27, 9, 83, 27, 56, 164, 27, 29, 70, 28, 28, 171, 28, 28, 170, 28, 28, 170, 28, 28, 147, 28, 28, 70, 28, 37, 171, 28, 20, 170, 28, 53, 170, 28, 112, 147, 28, 113, 78, 29, 29, 90, 29, 29, 78, 29, 27, 90, 29, 52, 70, 30, 30, 171, 30, 30, 170, 30, 30, 170, 30, 30, 147, 30, 30, 70, 30, 18, 171, 30, 51, 170, 30, 51, 170, 30, 114, 147, 30, 115, 86, 31, 31, 152, 31, 31, 156, 31, 31, 86, 31, 35, 152, 31, 48, 156, 31, 9, 78, 32, 32, 90, 32, 32, 78, 32, 23, 90, 32, 52, 165, 33, 33, 172, 33, 33, 2, 33, 33, 1, 33, 33, 165, 33, 4, 172, 33, 34, 86, 34, 34, 152, 34, 34, 156, 34, 34, 86, 34, 33, 152, 34, 54, 156, 34, 39, 165, 35, 35, 172, 35, 35, 2, 35, 35, 1, 35, 35, 165, 35, 20, 172, 35, 31, 79, 36, 36, 85, 36, 36, 83, 36, 36, 164, 36, 36, 79, 36, 3, 85, 36, 59, 83, 36, 51, 164, 36, 15, 86, 37, 37, 152, 37, 37, 156, 37, 37, 86, 37, 16, 152, 37, 55, 156, 37, 28, 165, 38, 38, 172, 38, 38, 2, 38, 38, 1, 38, 38, 165, 38, 23, 172, 38, 41, 70, 39, 39, 171, 39, 39, 170, 39, 39, 170, 39, 39, 147, 39, 39, 70, 39, 34, 171, 39, 54, 170, 39, 54, 170, 39, 116, 147, 39, 117, 79, 40, 40, 85, 40, 40, 83, 40, 40, 164, 40, 40, 79, 40, 16, 85, 40, 63, 83, 40, 49, 164, 40, 0, 86, 41, 41, 152, 41, 41, 156, 41, 41, 86, 41, 38, 152, 41, 52, 156, 41, 8, 67, 42, 42, 167, 42, 42, 118, 42, 42, 168, 42, 42, 67, 42, 25, 167, 42, 61, 118, 42, 88, 168, 42, 48, 3, 43, 43, 154, 43, 43, 155, 43, 43, 3, 43, 72, 154, 43, 108, 155, 43, 107, 78, 44, 44, 90, 44, 44, 78, 44, 20, 90, 44, 51, 37, 45, 45, 39, 45, 45, 36, 45, 45, 40, 45, 45, 23, 45, 45, 56, 45, 45, 20, 45, 45, 3, 45, 45, 24, 45, 45, 77, 45, 45, 57, 45, 45, 70, 45, 45, 44, 45, 45, 72, 45, 45, 71, 45, 45, 167, 45, 45, 98, 45, 45, 37, 45, 118, 39, 45, 118, 36, 45, 118, 40, 45, 118, 23, 45, 87, 56, 45, 87, 20, 45, 87, 3, 45, 71, 24, 45, 119, 77, 45, 50, 57, 45, 120, 70, 45, 2, 44, 45, 68, 72, 45, 107, 71, 45, 7, 167, 45, 62, 98, 45, 121, 77, 46, 46, 92, 46, 46, 151, 46, 46, 77, 46, 48, 92, 46, 122, 151, 46, 22, 77, 47, 47, 92, 47, 47, 151, 47, 47, 77, 47, 55, 92, 47, 123, 151, 47, 26, 72, 48, 48, 44, 48, 48, 66, 48, 48, 82, 48, 48, 139, 48, 48, 163, 48, 48, 72, 48, 105, 44, 48, 124, 66, 48, 31, 82, 48, 42, 139, 48, 75, 163, 48, 46, 84, 49, 49, 169, 49, 49, 84, 49, 9, 169, 49, 40, 72, 50, 50, 44, 50, 50, 66, 50, 50, 82, 50, 50, 139, 50, 50, 163, 50, 50, 72, 50, 108, 44, 50, 125, 66, 50, 2, 82, 50, 14, 139, 50, 87, 163, 50, 45, 4, 51, 51, 4, 51, 51, 66, 51, 51, 85, 51, 51, 84, 51, 51, 169, 51, 51, 166, 51, 51, 4, 51, 44, 4, 51, 15, 66, 51, 18, 85, 51, 30, 84, 51, 30, 169, 51, 36, 166, 51, 25, 4, 52, 52, 4, 52, 52, 66, 52, 52, 85, 52, 52, 84, 52, 52, 169, 52, 52, 166, 52, 52, 4, 52, 29, 4, 52, 32, 66, 52, 41, 85, 52, 8, 84, 52, 8, 169, 52, 23, 166, 52, 1, 84, 53, 53, 169, 53, 53, 84, 53, 28, 169, 53, 20, 4, 54, 54, 4, 54, 54, 66, 54, 54, 85, 54, 54, 84, 54, 54, 169, 54, 54, 166, 54, 54, 4, 54, 0, 4, 54, 6, 66, 54, 34, 85, 54, 39, 84, 54, 39, 169, 54, 4, 166, 54, 17, 72, 55, 55, 44, 55, 55, 66, 55, 55, 82, 55, 55, 139, 55, 55, 163, 55, 55, 72, 55, 106, 44, 55, 126, 66, 55, 37, 82, 55, 13, 139, 55, 74, 163, 55, 47, 84, 56, 56, 169, 56, 56, 84, 56, 9, 169, 56, 27, 17, 57, 57, 109, 57, 57, 110, 57, 57, 112, 57, 57, 116, 57, 57, 114, 57, 57, 104, 57, 57, 17, 57, 62, 109, 57, 82, 110, 57, 82, 112, 57, 127, 116, 57, 128, 114, 57, 129, 104, 57, 130, 32, 58, 58, 119, 58, 58, 120, 58, 58, 32, 58, 13, 119, 58, 131, 120, 58, 132, 83, 59, 59, 171, 59, 59, 100, 59, 59, 83, 59, 114, 171, 59, 36, 100, 59, 100, 83, 60, 60, 171, 60, 60, 100, 60, 60, 83, 60, 102, 171, 60, 23, 100, 60, 89, 81, 61, 61, 73, 61, 61, 151, 61, 61, 103, 61, 61, 81, 61, 42, 73, 61, 105, 151, 61, 5, 103, 61, 133, 81, 62, 62, 73, 62, 62, 151, 62, 62, 103, 62, 62, 81, 62, 45, 73, 62, 107, 151, 62, 10, 103, 62, 57, 83, 63, 63, 171, 63, 63, 100, 63, 63, 83, 63, 112, 171, 63, 40, 100, 63, 98, 81, 64, 64, 73, 64, 64, 151, 64, 64, 103, 64, 64, 81, 64, 14, 73, 64, 108, 151, 64, 7, 103, 64, 119, 83, 65, 65, 171, 65, 65, 100, 65, 65, 83, 65, 116, 171, 65, 4, 100, 65, 99, 81, 66, 66, 73, 66, 66, 151, 66, 66, 103, 66, 66, 81, 66, 13, 73, 66, 106, 151, 66, 24, 103, 66, 134, 50, 67, 67, 148, 67, 67, 114, 67, 67, 50, 67, 135, 148, 67, 136, 114, 67, 137, 42, 68, 68, 130, 68, 68, 42, 68, 118, 130, 68, 45, 71, 69, 69, 89, 69, 69, 94, 69, 69, 71, 69, 26, 89, 69, 21, 94, 69, 138, 71, 70, 70, 89, 70, 70, 94, 70, 70, 71, 70, 5, 89, 70, 11, 94, 70, 139, 71, 71, 71, 89, 71, 71, 94, 71, 71, 71, 71, 10, 89, 71, 45, 94, 71, 140, 71, 72, 72, 89, 72, 72, 94, 72, 72, 71, 72, 24, 89, 72, 43, 94, 72, 141, 71, 73, 73, 89, 73, 73, 94, 73, 73, 71, 73, 22, 89, 73, 12, 94, 73, 142, 53, 74, 74, 109, 74, 74, 110, 74, 74, 142, 74, 74, 142, 74, 74, 106, 74, 74, 140, 74, 74, 53, 74, 55, 109, 74, 76, 110, 74, 143, 142, 74, 144, 142, 74, 77, 106, 74, 78, 140, 74, 145, 53, 75, 75, 109, 75, 75, 110, 75, 75, 142, 75, 75, 142, 75, 75, 106, 75, 75, 140, 75, 75, 53, 75, 48, 109, 75, 79, 110, 75, 146, 142, 75, 147, 142, 75, 80, 106, 75, 81, 140, 75, 148, 23, 76, 76, 24, 76, 76, 23, 76, 74, 24, 76, 134, 56, 77, 77, 143, 77, 77, 145, 77, 77, 56, 77, 74, 143, 77, 149, 145, 77, 150, 20, 78, 78, 20, 78, 74, 23, 79, 79, 24, 79, 79, 23, 79, 75, 24, 79, 133, 56, 80, 80, 143, 80, 80, 145, 80, 80, 56, 80, 75, 143, 80, 151, 145, 80, 152, 20, 81, 81, 20, 81, 75, 23, 82, 82, 24, 82, 82, 23, 82, 57, 24, 82, 57, 57, 83, 83, 57, 83, 144, 57, 84, 84, 57, 84, 147, 50, 85, 85, 50, 85, 153, 50, 86, 86, 50, 86, 154, 53, 87, 87, 109, 87, 87, 142, 87, 87, 106, 87, 87, 110, 87, 87, 142, 87, 87, 140, 87, 87, 53, 87, 50, 109, 87, 45, 142, 87, 45, 106, 87, 45, 110, 87, 155, 142, 87, 120, 140, 87, 156, 32, 88, 88, 119, 88, 88, 120, 88, 88, 32, 88, 42, 119, 88, 157, 120, 88, 158, 14, 89, 89, 119, 89, 89, 14, 89, 60, 119, 89, 159, 37, 90, 90, 36, 90, 90, 37, 90, 160, 36, 90, 160, 40, 91, 91, 39, 91, 91, 40, 91, 160, 39, 91, 160, 42, 92, 92, 42, 92, 160, 37, 93, 93, 36, 93, 93, 37, 93, 161, 36, 93, 162, 40, 94, 94, 39, 94, 94, 40, 94, 161, 39, 94, 162, 42, 95, 95, 42, 95, 161, 37, 96, 96, 36, 96, 96, 37, 96, 162, 36, 96, 161, 40, 97, 97, 39, 97, 97, 40, 97, 162, 39, 97, 161, 14, 98, 98, 119, 98, 98, 14, 98, 63, 119, 98, 163, 14, 99, 99, 119, 99, 99, 14, 99, 65, 119, 99, 164, 14, 100, 100, 119, 100, 100, 14, 100, 59, 119, 100, 165, 45, 101, 101, 132, 101, 101, 45, 101, 1, 132, 101, 135, 84, 102, 102, 169, 102, 102, 84, 102, 8, 169, 102, 60, 61, 103, 103, 148, 103, 103, 128, 103, 103, 61, 103, 8, 148, 103, 166, 128, 103, 167, 61, 104, 104, 148, 104, 104, 128, 104, 104, 61, 104, 9, 148, 104, 168, 128, 104, 169, 69, 105, 105, 68, 105, 105, 158, 105, 105, 159, 105, 105, 69, 105, 21, 68, 105, 11, 158, 105, 48, 159, 105, 61, 69, 106, 106, 68, 106, 106, 158, 106, 106, 159, 106, 106, 69, 106, 11, 68, 106, 21, 158, 106, 55, 159, 106, 66, 69, 107, 107, 68, 107, 107, 158, 107, 107, 159, 107, 107, 69, 107, 43, 68, 107, 12, 158, 107, 45, 159, 107, 62, 69, 108, 108, 68, 108, 108, 158, 108, 108, 159, 108, 108, 69, 108, 12, 68, 108, 43, 158, 108, 50, 159, 108, 64, 32, 109, 109, 119, 109, 109, 120, 109, 109, 32, 109, 14, 119, 109, 170, 120, 109, 171, 45, 110, 110, 132, 110, 110, 45, 110, 17, 132, 110, 153, 45, 111, 111, 132, 111, 111, 45, 111, 25, 132, 111, 154, 84, 112, 112, 169, 112, 112, 84, 112, 28, 169, 112, 63, 61, 113, 113, 148, 113, 113, 128, 113, 113, 61, 113, 28, 148, 113, 172, 128, 113, 173, 84, 114, 114, 169, 114, 114, 84, 114, 30, 169, 114, 59, 61, 115, 115, 148, 115, 115, 128, 115, 115, 61, 115, 30, 148, 115, 174, 128, 115, 175, 84, 116, 116, 169, 116, 116, 84, 116, 39, 169, 116, 65, 61, 117, 117, 148, 117, 117, 128, 117, 117, 61, 117, 39, 148, 117, 176, 128, 117, 177, 34, 118, 118, 123, 118, 118, 126, 118, 118, 122, 118, 118, 125, 118, 118, 128, 118, 118, 34, 118, 170, 123, 118, 45, 126, 118, 45, 122, 118, 45, 125, 118, 45, 128, 118, 68, 17, 119, 119, 109, 119, 119, 112, 119, 119, 116, 119, 119, 110, 119, 119, 114, 119, 119, 104, 119, 119, 17, 119, 64, 109, 119, 155, 112, 119, 178, 116, 119, 179, 110, 119, 45, 114, 119, 180, 104, 119, 181, 56, 120, 120, 143, 120, 120, 145, 120, 120, 56, 120, 87, 143, 120, 45, 145, 120, 182, 12, 121, 121, 12, 121, 45, 6, 122, 122, 143, 122, 122, 6, 122, 46, 143, 122, 183, 6, 123, 123, 143, 123, 123, 6, 123, 47, 143, 123, 184, 42, 124, 124, 130, 124, 124, 42, 124, 158, 130, 124, 48, 42, 125, 125, 130, 125, 125, 42, 125, 171, 130, 125, 50, 42, 126, 126, 130, 126, 126, 42, 126, 132, 130, 126, 55, 26, 127, 127, 106, 127, 127, 26, 127, 57, 106, 127, 185, 30, 128, 128, 30, 128, 57, 28, 129, 129, 28, 129, 57, 18, 130, 130, 18, 130, 57, 33, 131, 131, 120, 131, 131, 33, 131, 58, 120, 131, 161, 34, 132, 132, 123, 132, 132, 122, 132, 132, 126, 132, 132, 125, 132, 132, 128, 132, 132, 34, 132, 58, 123, 132, 186, 122, 132, 186, 126, 132, 187, 125, 132, 187, 128, 132, 126, 17, 133, 133, 109, 133, 133, 112, 133, 133, 116, 133, 133, 110, 133, 133, 114, 133, 133, 104, 133, 133, 17, 133, 61, 109, 133, 146, 112, 133, 188, 116, 133, 189, 110, 133, 79, 114, 133, 190, 104, 133, 191, 17, 134, 134, 109, 134, 134, 112, 134, 134, 116, 134, 134, 110, 134, 134, 114, 134, 134, 104, 134, 134, 17, 134, 66, 109, 134, 143, 112, 134, 192, 116, 134, 193, 110, 134, 76, 114, 134, 194, 104, 134, 195, 46, 135, 135, 136, 135, 135, 134, 135, 135, 46, 135, 101, 136, 135, 67, 134, 135, 196, 62, 136, 136, 62, 136, 67, 28, 137, 137, 28, 137, 67, 8, 138, 138, 95, 138, 138, 8, 138, 69, 95, 138, 197, 8, 139, 139, 95, 139, 139, 8, 139, 70, 95, 139, 198, 8, 140, 140, 95, 140, 140, 8, 140, 71, 95, 140, 199, 8, 141, 141, 95, 141, 141, 8, 141, 72, 95, 141, 200, 8, 142, 142, 95, 142, 142, 8, 142, 73, 95, 142, 201, 23, 143, 143, 24, 143, 143, 23, 143, 134, 24, 143, 74, 56, 144, 144, 143, 144, 144, 145, 144, 144, 56, 144, 74, 143, 144, 83, 145, 144, 202, 54, 145, 145, 54, 145, 74, 23, 146, 146, 24, 146, 146, 23, 146, 133, 24, 146, 75, 56, 147, 147, 143, 147, 147, 145, 147, 147, 56, 147, 75, 143, 147, 84, 145, 147, 203, 54, 148, 148, 54, 148, 75, 57, 149, 149, 57, 149, 77, 59, 150, 150, 59, 150, 77, 57, 151, 151, 57, 151, 80, 59, 152, 152, 59, 152, 80, 46, 153, 153, 136, 153, 153, 134, 153, 153, 46, 153, 110, 136, 153, 85, 134, 153, 204, 46, 154, 154, 136, 154, 154, 134, 154, 154, 46, 154, 111, 136, 154, 86, 134, 154, 205, 23, 155, 155, 24, 155, 155, 23, 155, 119, 24, 155, 87, 54, 156, 156, 54, 156, 87, 33, 157, 157, 120, 157, 157, 33, 157, 88, 120, 157, 160, 34, 158, 158, 123, 158, 158, 122, 158, 158, 126, 158, 158, 125, 158, 158, 128, 158, 158, 34, 158, 88, 123, 158, 206, 122, 158, 206, 126, 158, 207, 125, 158, 207, 128, 158, 124, 33, 159, 159, 120, 159, 159, 33, 159, 89, 120, 159, 162, 34, 160, 160, 123, 160, 160, 122, 160, 160, 126, 160, 160, 125, 160, 160, 128, 160, 160, 34, 160, 157, 123, 160, 90, 122, 160, 90, 126, 160, 91, 125, 160, 91, 128, 160, 92, 34, 161, 161, 123, 161, 161, 126, 161, 161, 128, 161, 161, 122, 161, 161, 125, 161, 161, 34, 161, 131, 123, 161, 93, 126, 161, 94, 128, 161, 95, 122, 161, 96, 125, 161, 97, 34, 162, 162, 123, 162, 162, 126, 162, 162, 128, 162, 162, 122, 162, 162, 125, 162, 162, 34, 162, 159, 123, 162, 96, 126, 162, 97, 128, 162, 208, 122, 162, 93, 125, 162, 94, 33, 163, 163, 120, 163, 163, 33, 163, 98, 120, 163, 209, 33, 164, 164, 120, 164, 164, 33, 164, 99, 120, 164, 210, 33, 165, 165, 120, 165, 165, 33, 165, 100, 120, 165, 211, 62, 166, 166, 62, 166, 103, 42, 167, 167, 42, 167, 103, 62, 168, 168, 62, 168, 104, 42, 169, 169, 42, 169, 104, 33, 170, 170, 120, 170, 170, 33, 170, 109, 120, 170, 118, 34, 171, 171, 123, 171, 171, 122, 171, 171, 126, 171, 171, 125, 171, 171, 128, 171, 171, 34, 171, 109, 123, 171, 212, 122, 171, 212, 126, 171, 213, 125, 171, 213, 128, 171, 125, 62, 172, 172, 62, 172, 113, 42, 173, 173, 42, 173, 113, 62, 174, 174, 62, 174, 115, 42, 175, 175, 42, 175, 115, 62, 176, 176, 62, 176, 117, 42, 177, 177, 42, 177, 117, 26, 178, 178, 106, 178, 178, 26, 178, 119, 106, 178, 214, 30, 179, 179, 30, 179, 119, 28, 180, 180, 28, 180, 119, 18, 181, 181, 18, 181, 119, 59, 182, 182, 59, 182, 120, 57, 183, 183, 57, 183, 122, 57, 184, 184, 57, 184, 123, 20, 185, 185, 20, 185, 127, 37, 186, 186, 36, 186, 186, 37, 186, 132, 36, 186, 132, 40, 187, 187, 39, 187, 187, 40, 187, 132, 39, 187, 132, 26, 188, 188, 106, 188, 188, 26, 188, 133, 106, 188, 215, 30, 189, 189, 30, 189, 133, 28, 190, 190, 28, 190, 133, 18, 191, 191, 18, 191, 133, 26, 192, 192, 106, 192, 192, 26, 192, 134, 106, 192, 216, 30, 193, 193, 30, 193, 134, 28, 194, 194, 28, 194, 134, 18, 195, 195, 18, 195, 134, 48, 196, 196, 48, 196, 135, 9, 197, 197, 98, 197, 197, 9, 197, 138, 98, 197, 217, 9, 198, 198, 98, 198, 198, 9, 198, 139, 98, 198, 218, 9, 199, 199, 98, 199, 199, 9, 199, 140, 98, 199, 219, 9, 200, 200, 98, 200, 200, 9, 200, 141, 98, 200, 220, 9, 201, 201, 98, 201, 201, 9, 201, 142, 98, 201, 221, 59, 202, 202, 59, 202, 144, 59, 203, 203, 59, 203, 147, 48, 204, 204, 48, 204, 153, 48, 205, 205, 48, 205, 154, 37, 206, 206, 36, 206, 206, 37, 206, 158, 36, 206, 158, 40, 207, 207, 39, 207, 207, 40, 207, 158, 39, 207, 158, 42, 208, 208, 42, 208, 162, 34, 209, 209, 123, 209, 209, 126, 209, 209, 128, 209, 209, 122, 209, 209, 125, 209, 209, 34, 209, 163, 123, 209, 222, 126, 209, 223, 128, 209, 224, 122, 209, 225, 125, 209, 226, 34, 210, 210, 123, 210, 210, 122, 210, 210, 126, 210, 210, 125, 210, 210, 128, 210, 210, 34, 210, 164, 123, 210, 227, 122, 210, 227, 126, 210, 228, 125, 210, 228, 128, 210, 229, 34, 211, 211, 123, 211, 211, 126, 211, 211, 128, 211, 211, 122, 211, 211, 125, 211, 211, 34, 211, 165, 123, 211, 225, 126, 211, 226, 128, 211, 230, 122, 211, 222, 125, 211, 223, 37, 212, 212, 36, 212, 212, 37, 212, 171, 36, 212, 171, 40, 213, 213, 39, 213, 213, 40, 213, 171, 39, 213, 171, 20, 214, 214, 20, 214, 178, 20, 215, 215, 20, 215, 188, 20, 216, 216, 20, 216, 192, 12, 217, 217, 12, 217, 197, 12, 218, 218, 12, 218, 198, 12, 219, 219, 12, 219, 199, 12, 220, 220, 12, 220, 200, 12, 221, 221, 12, 221, 201, 37, 222, 222, 36, 222, 222, 37, 222, 209, 36, 222, 211, 40, 223, 223, 39, 223, 223, 40, 223, 209, 39, 223, 211, 42, 224, 224, 42, 224, 209, 37, 225, 225, 36, 225, 225, 37, 225, 211, 36, 225, 209, 40, 226, 226, 39, 226, 226, 40, 226, 211, 39, 226, 209, 37, 227, 227, 36, 227, 227, 37, 227, 210, 36, 227, 210, 40, 228, 228, 39, 228, 228, 40, 228, 210, 39, 228, 210, 42, 229, 229, 42, 229, 210, 42, 230, 230, 42, 230, 211)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(2, 4, 116, 1, 4, 117, 2, 17, 118, 1, 17, 119, 2, 20, 120, 1, 20, 121, 2, 34, 122, 1, 34, 123, 2, 36, 124, 1, 36, 125, 2, 39, 126, 1, 39, 127)), ncol=2+1, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(1), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 2: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=2
nb_c=359
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=231 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(65, 0, 0, 157, 0, 0, 65, 0, 113, 157, 0, 128, 86, 1, 1, 152, 1, 1, 156, 1, 1, 86, 1, 60, 152, 1, 99, 156, 1, 37, 78, 2, 2, 90, 2, 2, 78, 2, 27, 78, 3, 3, 90, 3, 3, 78, 3, 13, 90, 3, 98, 3, 4, 4, 154, 4, 4, 155, 4, 4, 3, 4, 126, 154, 4, 147, 155, 4, 148, 79, 5, 5, 85, 5, 5, 83, 5, 5, 164, 5, 5, 79, 5, 8, 85, 5, 110, 83, 5, 102, 164, 5, 7, 86, 6, 6, 152, 6, 6, 156, 6, 6, 86, 6, 41, 78, 7, 7, 90, 7, 7, 78, 7, 5, 90, 7, 102, 165, 8, 8, 172, 8, 8, 2, 8, 8, 1, 8, 8, 165, 8, 5, 172, 8, 67, 67, 9, 9, 167, 9, 9, 118, 9, 9, 168, 9, 9, 67, 9, 64, 167, 9, 111, 118, 9, 149, 168, 9, 101, 70, 10, 10, 170, 10, 10, 147, 10, 10, 171, 10, 10, 170, 10, 10, 70, 10, 18, 170, 10, 150, 147, 10, 151, 79, 11, 11, 164, 11, 11, 85, 11, 11, 83, 11, 11, 79, 11, 70, 164, 11, 12, 78, 12, 12, 90, 12, 12, 78, 12, 11, 79, 13, 13, 85, 13, 13, 83, 13, 13, 164, 13, 13, 79, 13, 82, 85, 13, 107, 83, 13, 98, 164, 13, 3, 70, 14, 14, 170, 14, 14, 147, 14, 14, 171, 14, 14, 170, 14, 14, 70, 14, 38, 170, 14, 152, 147, 14, 153, 86, 15, 15, 152, 15, 15, 156, 15, 15, 86, 15, 34, 157, 16, 16, 65, 16, 16, 157, 16, 120, 78, 17, 17, 90, 17, 17, 78, 17, 94, 86, 18, 18, 156, 18, 18, 152, 18, 18, 86, 18, 70, 156, 18, 10, 70, 19, 19, 170, 19, 19, 147, 19, 19, 171, 19, 19, 170, 19, 19, 70, 19, 47, 170, 19, 154, 147, 19, 155, 165, 20, 20, 172, 20, 20, 2, 20, 20, 1, 20, 20, 165, 20, 75, 172, 20, 91, 78, 21, 21, 90, 21, 21, 78, 21, 77, 67, 22, 22, 167, 22, 22, 118, 22, 22, 168, 22, 22, 67, 22, 25, 167, 22, 108, 118, 22, 156, 168, 22, 105, 65, 23, 23, 157, 23, 23, 157, 24, 24, 65, 24, 24, 157, 24, 122, 80, 25, 25, 153, 25, 25, 131, 25, 25, 80, 25, 102, 153, 25, 22, 131, 25, 157, 86, 26, 26, 152, 26, 26, 156, 26, 26, 86, 26, 49, 152, 26, 105, 79, 27, 27, 164, 27, 27, 85, 27, 27, 83, 27, 27, 79, 27, 45, 164, 27, 2, 86, 28, 28, 152, 28, 28, 156, 28, 28, 86, 28, 82, 152, 28, 98, 156, 28, 74, 65, 29, 29, 157, 29, 29, 65, 29, 114, 157, 29, 119, 70, 30, 30, 171, 30, 30, 170, 30, 30, 170, 30, 30, 147, 30, 30, 70, 30, 91, 171, 30, 33, 170, 30, 103, 170, 30, 158, 147, 30, 159, 157, 31, 31, 65, 31, 31, 157, 31, 124, 157, 32, 32, 65, 32, 32, 157, 32, 127, 79, 33, 33, 85, 33, 33, 83, 33, 33, 164, 33, 33, 79, 33, 49, 85, 33, 30, 83, 33, 103, 164, 33, 95, 165, 34, 34, 172, 34, 34, 2, 34, 34, 1, 34, 34, 165, 34, 77, 172, 34, 15, 3, 35, 35, 154, 35, 35, 155, 35, 35, 3, 35, 124, 154, 35, 160, 155, 35, 160, 86, 36, 36, 152, 36, 36, 156, 36, 36, 86, 36, 45, 70, 37, 37, 171, 37, 37, 170, 37, 37, 170, 37, 37, 147, 37, 37, 70, 37, 1, 171, 37, 99, 170, 37, 99, 170, 37, 161, 147, 37, 162, 86, 38, 38, 156, 38, 38, 152, 38, 38, 86, 38, 66, 156, 38, 14, 65, 39, 39, 157, 39, 39, 65, 39, 108, 79, 40, 40, 83, 40, 40, 164, 40, 40, 85, 40, 40, 79, 40, 90, 83, 40, 100, 164, 40, 96, 165, 41, 41, 172, 41, 41, 2, 41, 41, 1, 41, 41, 165, 41, 94, 172, 41, 6, 3, 42, 42, 154, 42, 42, 155, 42, 42, 3, 42, 123, 154, 42, 163, 155, 42, 164, 80, 43, 43, 153, 43, 43, 131, 43, 43, 80, 43, 99, 153, 43, 62, 131, 43, 165, 3, 44, 44, 154, 44, 44, 155, 44, 44, 3, 44, 120, 154, 44, 164, 155, 44, 163, 165, 45, 45, 172, 45, 45, 2, 45, 45, 1, 45, 45, 165, 45, 27, 172, 45, 36, 157, 46, 46, 65, 46, 46, 157, 46, 123, 86, 47, 47, 156, 47, 47, 152, 47, 47, 86, 47, 84, 156, 47, 19, 165, 48, 48, 172, 48, 48, 2, 48, 48, 1, 48, 48, 165, 48, 78, 172, 48, 72, 165, 49, 49, 172, 49, 49, 2, 49, 49, 1, 49, 49, 165, 49, 33, 172, 49, 26, 65, 50, 50, 157, 50, 50, 65, 50, 97, 157, 50, 126, 70, 51, 51, 171, 51, 51, 170, 51, 51, 170, 51, 51, 147, 51, 51, 70, 51, 67, 171, 51, 102, 170, 51, 102, 170, 51, 166, 147, 51, 167, 86, 52, 52, 152, 52, 52, 156, 52, 52, 86, 52, 90, 152, 52, 106, 78, 53, 53, 90, 53, 53, 78, 53, 57, 90, 53, 99, 65, 54, 54, 157, 54, 54, 65, 54, 117, 79, 55, 55, 85, 55, 55, 164, 55, 55, 83, 55, 55, 79, 55, 84, 85, 55, 118, 164, 55, 87, 3, 56, 56, 154, 56, 56, 155, 56, 56, 3, 56, 125, 154, 56, 148, 155, 56, 147, 79, 57, 57, 85, 57, 57, 83, 57, 57, 164, 57, 57, 79, 57, 60, 85, 57, 116, 83, 57, 99, 164, 57, 53, 70, 58, 58, 170, 58, 58, 147, 58, 58, 171, 58, 58, 170, 58, 58, 70, 58, 86, 170, 58, 168, 147, 58, 169, 65, 59, 59, 157, 59, 59, 65, 59, 112, 165, 60, 60, 172, 60, 60, 2, 60, 60, 1, 60, 60, 165, 60, 57, 172, 60, 1, 70, 61, 61, 170, 61, 61, 147, 61, 61, 171, 61, 61, 170, 61, 61, 70, 61, 83, 170, 61, 170, 147, 61, 171, 67, 62, 62, 167, 62, 62, 118, 62, 62, 168, 62, 62, 67, 62, 43, 167, 62, 112, 118, 62, 172, 168, 62, 106, 65, 63, 63, 157, 63, 63, 65, 63, 111, 157, 63, 125, 80, 64, 64, 153, 64, 64, 131, 64, 64, 80, 64, 98, 153, 64, 9, 131, 64, 173, 165, 65, 65, 172, 65, 65, 2, 65, 65, 1, 65, 65, 165, 65, 80, 172, 65, 86, 165, 66, 66, 172, 66, 66, 2, 66, 66, 1, 66, 66, 165, 66, 76, 172, 66, 38, 86, 67, 67, 152, 67, 67, 156, 67, 67, 86, 67, 8, 152, 67, 102, 156, 67, 51, 65, 68, 68, 157, 68, 68, 78, 69, 69, 90, 69, 69, 78, 69, 80, 165, 70, 70, 172, 70, 70, 2, 70, 70, 1, 70, 70, 165, 70, 11, 172, 70, 18, 78, 71, 71, 90, 71, 71, 78, 71, 89, 86, 72, 72, 156, 72, 72, 152, 72, 72, 86, 72, 48, 156, 72, 93, 78, 73, 73, 90, 73, 73, 78, 73, 76, 70, 74, 74, 171, 74, 74, 170, 74, 74, 170, 74, 74, 147, 74, 74, 70, 74, 28, 171, 74, 98, 170, 74, 98, 170, 74, 174, 147, 74, 175, 79, 75, 75, 83, 75, 75, 164, 75, 75, 85, 75, 75, 79, 75, 20, 83, 75, 104, 164, 75, 88, 79, 76, 76, 164, 76, 76, 85, 76, 76, 83, 76, 76, 79, 76, 66, 164, 76, 73, 79, 77, 77, 164, 77, 77, 85, 77, 77, 83, 77, 77, 79, 77, 34, 164, 77, 21, 79, 78, 78, 85, 78, 78, 164, 78, 78, 83, 78, 78, 79, 78, 48, 85, 78, 115, 164, 78, 81, 165, 79, 79, 172, 79, 79, 2, 79, 79, 1, 79, 79, 165, 79, 89, 172, 79, 83, 79, 80, 80, 164, 80, 80, 85, 80, 80, 83, 80, 80, 79, 80, 65, 164, 80, 69, 78, 81, 81, 90, 81, 81, 78, 81, 78, 165, 82, 82, 172, 82, 82, 2, 82, 82, 1, 82, 82, 165, 82, 13, 172, 82, 28, 86, 83, 83, 156, 83, 83, 152, 83, 83, 86, 83, 79, 156, 83, 61, 165, 84, 84, 172, 84, 84, 2, 84, 84, 1, 84, 84, 165, 84, 55, 172, 84, 47, 3, 85, 85, 154, 85, 85, 155, 85, 85, 3, 85, 122, 154, 85, 176, 155, 85, 176, 86, 86, 86, 156, 86, 86, 152, 86, 86, 86, 86, 65, 156, 86, 58, 78, 87, 87, 90, 87, 87, 78, 87, 55, 78, 88, 88, 90, 88, 88, 78, 88, 75, 90, 88, 102, 79, 89, 89, 85, 89, 89, 164, 89, 89, 83, 89, 89, 79, 89, 79, 85, 89, 109, 164, 89, 71, 165, 90, 90, 172, 90, 90, 2, 90, 90, 1, 90, 90, 165, 90, 40, 172, 90, 52, 86, 91, 91, 152, 91, 91, 156, 91, 91, 86, 91, 20, 152, 91, 101, 156, 91, 30, 157, 92, 92, 65, 92, 92, 157, 92, 121, 70, 93, 93, 170, 93, 93, 147, 93, 93, 171, 93, 93, 170, 93, 93, 70, 93, 72, 170, 93, 177, 147, 93, 178, 79, 94, 94, 164, 94, 94, 85, 94, 94, 83, 94, 94, 79, 94, 41, 164, 94, 17, 78, 95, 95, 90, 95, 95, 78, 95, 33, 90, 95, 98, 78, 96, 96, 90, 96, 96, 78, 96, 40, 90, 96, 99, 77, 97, 97, 92, 97, 97, 151, 97, 97, 77, 97, 101, 92, 97, 179, 151, 97, 50, 4, 98, 98, 4, 98, 98, 66, 98, 98, 85, 98, 98, 84, 98, 98, 169, 98, 98, 166, 98, 98, 4, 98, 95, 4, 98, 3, 66, 98, 28, 85, 98, 74, 84, 98, 74, 169, 98, 13, 166, 98, 64, 4, 99, 99, 4, 99, 99, 66, 99, 99, 85, 99, 99, 84, 99, 99, 169, 99, 99, 166, 99, 99, 4, 99, 96, 4, 99, 53, 66, 99, 1, 85, 99, 37, 84, 99, 37, 169, 99, 57, 166, 99, 43, 169, 100, 100, 84, 100, 100, 169, 100, 40, 72, 101, 101, 44, 101, 101, 66, 101, 101, 82, 101, 101, 139, 101, 101, 163, 101, 101, 72, 101, 176, 44, 101, 180, 66, 101, 91, 82, 101, 9, 139, 101, 129, 163, 101, 97, 4, 102, 102, 4, 102, 102, 66, 102, 102, 85, 102, 102, 84, 102, 102, 169, 102, 102, 166, 102, 102, 4, 102, 88, 4, 102, 7, 66, 102, 67, 85, 102, 51, 84, 102, 51, 169, 102, 5, 166, 102, 25, 84, 103, 103, 169, 103, 103, 84, 103, 30, 169, 103, 33, 169, 104, 104, 84, 104, 104, 169, 104, 75, 72, 105, 105, 44, 105, 105, 66, 105, 105, 82, 105, 105, 139, 105, 105, 163, 105, 105, 72, 105, 148, 44, 105, 181, 66, 105, 26, 82, 105, 22, 139, 105, 138, 72, 106, 106, 44, 106, 106, 66, 106, 106, 82, 106, 106, 139, 106, 106, 163, 106, 106, 72, 106, 164, 44, 106, 182, 66, 106, 52, 82, 106, 62, 139, 106, 137, 83, 107, 107, 171, 107, 107, 100, 107, 107, 83, 107, 174, 171, 107, 13, 100, 107, 183, 81, 108, 108, 73, 108, 108, 151, 108, 108, 103, 108, 108, 81, 108, 22, 73, 108, 148, 151, 108, 39, 103, 108, 184, 83, 109, 109, 171, 109, 109, 100, 109, 109, 83, 109, 170, 171, 109, 89, 100, 109, 144, 83, 110, 110, 171, 110, 110, 100, 110, 110, 83, 110, 166, 171, 110, 5, 100, 110, 146, 81, 111, 111, 73, 111, 111, 151, 111, 111, 103, 111, 111, 81, 111, 9, 73, 111, 176, 151, 111, 63, 103, 111, 185, 81, 112, 112, 73, 112, 112, 151, 112, 112, 103, 112, 112, 81, 112, 62, 73, 112, 164, 151, 112, 59, 103, 112, 186, 73, 113, 113, 151, 113, 113, 103, 113, 113, 81, 113, 113, 73, 113, 163, 151, 113, 0, 103, 113, 187, 73, 114, 114, 151, 114, 114, 103, 114, 114, 81, 114, 114, 73, 114, 147, 151, 114, 29, 103, 114, 188, 83, 115, 115, 171, 115, 115, 100, 115, 115, 83, 115, 177, 171, 115, 78, 100, 115, 145, 83, 116, 116, 171, 116, 116, 100, 116, 116, 83, 116, 161, 171, 116, 57, 100, 116, 189, 73, 117, 117, 151, 117, 117, 103, 117, 117, 81, 117, 117, 73, 117, 160, 151, 117, 54, 103, 117, 190, 83, 118, 118, 171, 118, 118, 100, 118, 118, 83, 118, 154, 171, 118, 55, 100, 118, 191, 71, 119, 119, 94, 119, 119, 89, 119, 119, 71, 119, 29, 94, 119, 192, 71, 120, 120, 89, 120, 120, 94, 120, 120, 71, 120, 16, 89, 120, 44, 94, 120, 193, 71, 121, 121, 94, 121, 121, 89, 121, 121, 71, 121, 92, 94, 121, 194, 71, 122, 122, 89, 122, 122, 94, 122, 122, 71, 122, 24, 89, 122, 85, 94, 122, 195, 71, 123, 123, 89, 123, 123, 94, 123, 123, 71, 123, 46, 89, 123, 42, 94, 123, 196, 71, 124, 124, 89, 124, 124, 94, 124, 124, 71, 124, 31, 89, 124, 35, 94, 124, 197, 71, 125, 125, 89, 125, 125, 94, 125, 125, 71, 125, 63, 89, 125, 56, 94, 125, 198, 71, 126, 126, 89, 126, 126, 94, 126, 126, 71, 126, 50, 89, 126, 4, 94, 126, 199, 71, 127, 127, 94, 127, 127, 89, 127, 127, 71, 127, 32, 94, 127, 200, 71, 128, 128, 94, 128, 128, 89, 128, 128, 71, 128, 0, 94, 128, 201, 53, 129, 129, 109, 129, 129, 110, 129, 129, 142, 129, 129, 142, 129, 129, 106, 129, 129, 140, 129, 129, 53, 129, 101, 109, 129, 130, 110, 129, 202, 142, 129, 203, 142, 129, 131, 106, 129, 132, 140, 129, 204, 23, 130, 130, 24, 130, 130, 23, 130, 129, 24, 130, 185, 56, 131, 131, 143, 131, 131, 145, 131, 131, 56, 131, 129, 143, 131, 205, 145, 131, 206, 20, 132, 132, 20, 132, 129, 24, 133, 133, 23, 133, 133, 24, 133, 188, 24, 134, 134, 23, 134, 134, 24, 134, 187, 57, 135, 135, 57, 135, 203, 50, 136, 136, 50, 136, 207, 53, 137, 137, 110, 137, 137, 142, 137, 137, 140, 137, 137, 109, 137, 137, 142, 137, 137, 106, 137, 137, 53, 137, 106, 110, 137, 208, 142, 137, 209, 140, 137, 210, 53, 138, 138, 110, 138, 138, 142, 138, 138, 140, 138, 138, 109, 138, 138, 142, 138, 138, 106, 138, 138, 53, 138, 105, 110, 138, 211, 142, 138, 212, 140, 138, 213, 37, 139, 139, 36, 139, 139, 37, 139, 214, 36, 139, 215, 40, 140, 140, 39, 140, 140, 40, 140, 214, 39, 140, 215, 42, 141, 141, 42, 141, 214, 37, 142, 142, 36, 142, 142, 37, 142, 215, 36, 142, 214, 40, 143, 143, 39, 143, 143, 40, 143, 215, 39, 143, 214, 14, 144, 144, 119, 144, 144, 14, 144, 109, 119, 144, 216, 14, 145, 145, 119, 145, 145, 14, 145, 115, 119, 145, 217, 14, 146, 146, 119, 146, 146, 14, 146, 110, 119, 146, 218, 69, 147, 147, 68, 147, 147, 159, 147, 147, 158, 147, 147, 69, 147, 56, 68, 147, 4, 159, 147, 114, 69, 148, 148, 68, 148, 148, 158, 148, 148, 159, 148, 148, 69, 148, 4, 68, 148, 56, 158, 148, 105, 159, 148, 108, 32, 149, 149, 119, 149, 149, 120, 149, 149, 32, 149, 9, 119, 149, 219, 120, 149, 220, 84, 150, 150, 169, 150, 150, 84, 150, 10, 61, 151, 151, 148, 151, 151, 128, 151, 151, 61, 151, 10, 148, 151, 221, 128, 151, 222, 84, 152, 152, 169, 152, 152, 84, 152, 14, 61, 153, 153, 148, 153, 153, 128, 153, 153, 61, 153, 14, 148, 153, 223, 128, 153, 224, 84, 154, 154, 169, 154, 154, 84, 154, 19, 169, 154, 118, 61, 155, 155, 148, 155, 155, 128, 155, 155, 61, 155, 19, 148, 155, 225, 128, 155, 226, 32, 156, 156, 119, 156, 156, 120, 156, 156, 32, 156, 22, 119, 156, 227, 120, 156, 228, 45, 157, 157, 132, 157, 157, 45, 157, 25, 132, 157, 207, 84, 158, 158, 169, 158, 158, 84, 158, 30, 61, 159, 159, 148, 159, 159, 128, 159, 159, 61, 159, 30, 148, 159, 229, 128, 159, 230, 69, 160, 160, 68, 160, 160, 159, 160, 160, 158, 160, 160, 69, 160, 35, 68, 160, 35, 159, 160, 117, 84, 161, 161, 169, 161, 161, 84, 161, 37, 169, 161, 116, 61, 162, 162, 148, 162, 162, 128, 162, 162, 61, 162, 37, 148, 162, 231, 128, 162, 232, 69, 163, 163, 68, 163, 163, 159, 163, 163, 158, 163, 163, 69, 163, 44, 68, 163, 42, 159, 163, 113, 69, 164, 164, 68, 164, 164, 158, 164, 164, 159, 164, 164, 69, 164, 42, 68, 164, 44, 158, 164, 106, 159, 164, 112, 45, 165, 165, 132, 165, 165, 45, 165, 43, 132, 165, 233, 84, 166, 166, 169, 166, 166, 84, 166, 51, 169, 166, 110, 61, 167, 167, 148, 167, 167, 128, 167, 167, 61, 167, 51, 148, 167, 234, 128, 167, 235, 84, 168, 168, 169, 168, 168, 84, 168, 58, 61, 169, 169, 148, 169, 169, 128, 169, 169, 61, 169, 58, 148, 169, 236, 128, 169, 237, 84, 170, 170, 169, 170, 170, 84, 170, 61, 169, 170, 109, 61, 171, 171, 148, 171, 171, 128, 171, 171, 61, 171, 61, 148, 171, 238, 128, 171, 239, 32, 172, 172, 119, 172, 172, 120, 172, 172, 32, 172, 62, 119, 172, 240, 120, 172, 241, 45, 173, 173, 132, 173, 173, 45, 173, 64, 132, 173, 242, 84, 174, 174, 169, 174, 174, 84, 174, 74, 169, 174, 107, 61, 175, 175, 148, 175, 175, 128, 175, 175, 61, 175, 74, 148, 175, 243, 128, 175, 244, 69, 176, 176, 68, 176, 176, 158, 176, 176, 159, 176, 176, 69, 176, 85, 68, 176, 85, 158, 176, 101, 159, 176, 111, 84, 177, 177, 169, 177, 177, 84, 177, 93, 169, 177, 115, 61, 178, 178, 148, 178, 178, 128, 178, 178, 61, 178, 93, 148, 178, 245, 128, 178, 246, 6, 179, 179, 143, 179, 179, 6, 179, 97, 143, 179, 247, 42, 180, 180, 130, 180, 180, 42, 180, 220, 130, 180, 101, 42, 181, 181, 130, 181, 181, 42, 181, 228, 130, 181, 105, 42, 182, 182, 130, 182, 182, 42, 182, 241, 130, 182, 106, 14, 183, 183, 119, 183, 183, 14, 183, 107, 119, 183, 248, 17, 184, 184, 109, 184, 184, 112, 184, 184, 116, 184, 184, 114, 184, 184, 104, 184, 184, 110, 184, 184, 17, 184, 108, 109, 184, 211, 112, 184, 249, 116, 184, 250, 114, 184, 251, 104, 184, 252, 17, 185, 185, 109, 185, 185, 112, 185, 185, 116, 185, 185, 110, 185, 185, 114, 185, 185, 104, 185, 185, 17, 185, 111, 109, 185, 202, 112, 185, 253, 116, 185, 254, 110, 185, 130, 114, 185, 255, 104, 185, 256, 17, 186, 186, 109, 186, 186, 112, 186, 186, 116, 186, 186, 114, 186, 186, 104, 186, 186, 110, 186, 186, 17, 186, 112, 109, 186, 208, 112, 186, 257, 116, 186, 258, 114, 186, 259, 104, 186, 260, 17, 187, 187, 109, 187, 187, 112, 187, 187, 116, 187, 187, 110, 187, 187, 114, 187, 187, 104, 187, 187, 17, 187, 113, 109, 187, 261, 112, 187, 262, 116, 187, 263, 110, 187, 134, 114, 187, 264, 104, 187, 265, 17, 188, 188, 109, 188, 188, 112, 188, 188, 116, 188, 188, 110, 188, 188, 114, 188, 188, 104, 188, 188, 17, 188, 114, 109, 188, 266, 112, 188, 267, 116, 188, 268, 110, 188, 133, 114, 188, 269, 104, 188, 270, 14, 189, 189, 119, 189, 189, 14, 189, 116, 119, 189, 271, 17, 190, 190, 109, 190, 190, 112, 190, 190, 116, 190, 190, 114, 190, 190, 104, 190, 190, 110, 190, 190, 17, 190, 117, 109, 190, 272, 112, 190, 273, 116, 190, 274, 114, 190, 275, 104, 190, 276, 14, 191, 191, 119, 191, 191, 14, 191, 118, 119, 191, 277, 8, 192, 192, 95, 192, 192, 8, 192, 119, 95, 192, 278, 8, 193, 193, 95, 193, 193, 8, 193, 120, 95, 193, 279, 8, 194, 194, 95, 194, 194, 8, 194, 121, 95, 194, 280, 8, 195, 195, 95, 195, 195, 8, 195, 122, 95, 195, 281, 8, 196, 196, 95, 196, 196, 8, 196, 123, 95, 196, 282, 8, 197, 197, 95, 197, 197, 8, 197, 124, 95, 197, 283, 8, 198, 198, 95, 198, 198, 8, 198, 125, 95, 198, 284, 8, 199, 199, 95, 199, 199, 8, 199, 126, 95, 199, 285, 8, 200, 200, 95, 200, 200, 8, 200, 127, 95, 200, 286, 8, 201, 201, 95, 201, 201, 8, 201, 128, 95, 201, 287, 23, 202, 202, 24, 202, 202, 23, 202, 185, 24, 202, 129, 56, 203, 203, 143, 203, 203, 145, 203, 203, 56, 203, 129, 143, 203, 135, 145, 203, 288, 54, 204, 204, 54, 204, 129, 57, 205, 205, 57, 205, 131, 59, 206, 206, 59, 206, 131, 46, 207, 207, 136, 207, 207, 134, 207, 207, 46, 207, 157, 136, 207, 136, 134, 207, 289, 23, 208, 208, 24, 208, 208, 23, 208, 186, 24, 208, 137, 56, 209, 209, 145, 209, 209, 143, 209, 209, 56, 209, 137, 145, 209, 290, 54, 210, 210, 54, 210, 137, 23, 211, 211, 24, 211, 211, 23, 211, 184, 24, 211, 138, 56, 212, 212, 145, 212, 212, 143, 212, 212, 56, 212, 138, 145, 212, 291, 54, 213, 213, 54, 213, 138, 34, 214, 214, 123, 214, 214, 126, 214, 214, 128, 214, 214, 122, 214, 214, 125, 214, 214, 34, 214, 219, 123, 214, 139, 126, 214, 140, 128, 214, 141, 122, 214, 142, 125, 214, 143, 34, 215, 215, 123, 215, 215, 126, 215, 215, 128, 215, 215, 122, 215, 215, 125, 215, 215, 34, 215, 292, 123, 215, 142, 126, 215, 143, 128, 215, 293, 122, 215, 139, 125, 215, 140, 33, 216, 216, 120, 216, 216, 33, 216, 144, 120, 216, 294, 33, 217, 217, 120, 217, 217, 33, 217, 145, 120, 217, 295, 33, 218, 218, 120, 218, 218, 33, 218, 146, 120, 218, 296, 33, 219, 219, 120, 219, 219, 33, 219, 149, 120, 219, 214, 34, 220, 220, 123, 220, 220, 122, 220, 220, 126, 220, 220, 125, 220, 220, 128, 220, 220, 34, 220, 149, 123, 220, 297, 122, 220, 297, 126, 220, 298, 125, 220, 298, 128, 220, 180, 62, 221, 221, 62, 221, 151, 42, 222, 222, 42, 222, 151, 62, 223, 223, 62, 223, 153, 42, 224, 224, 42, 224, 153, 62, 225, 225, 62, 225, 155, 42, 226, 226, 42, 226, 155, 33, 227, 227, 120, 227, 227, 33, 227, 156, 120, 227, 299, 34, 228, 228, 123, 228, 228, 122, 228, 228, 126, 228, 228, 125, 228, 228, 128, 228, 228, 34, 228, 156, 123, 228, 300, 122, 228, 300, 126, 228, 301, 125, 228, 301, 128, 228, 181, 62, 229, 229, 62, 229, 159, 42, 230, 230, 42, 230, 159, 62, 231, 231, 62, 231, 162, 42, 232, 232, 42, 232, 162, 46, 233, 233, 134, 233, 233, 136, 233, 233, 46, 233, 165, 134, 233, 302, 62, 234, 234, 62, 234, 167, 42, 235, 235, 42, 235, 167, 62, 236, 236, 62, 236, 169, 42, 237, 237, 42, 237, 169, 62, 238, 238, 62, 238, 171, 42, 239, 239, 42, 239, 171, 33, 240, 240, 120, 240, 240, 33, 240, 172, 120, 240, 303, 34, 241, 241, 123, 241, 241, 122, 241, 241, 126, 241, 241, 125, 241, 241, 128, 241, 241, 34, 241, 172, 123, 241, 304, 122, 241, 304, 126, 241, 305, 125, 241, 305, 128, 241, 182, 46, 242, 242, 134, 242, 242, 136, 242, 242, 46, 242, 173, 134, 242, 306, 62, 243, 243, 62, 243, 175, 42, 244, 244, 42, 244, 175, 62, 245, 245, 62, 245, 178, 42, 246, 246, 42, 246, 178, 57, 247, 247, 57, 247, 179, 33, 248, 248, 120, 248, 248, 33, 248, 183, 120, 248, 307, 26, 249, 249, 106, 249, 249, 26, 249, 184, 106, 249, 308, 30, 250, 250, 30, 250, 184, 28, 251, 251, 28, 251, 184, 18, 252, 252, 18, 252, 184, 26, 253, 253, 106, 253, 253, 26, 253, 185, 106, 253, 309, 30, 254, 254, 30, 254, 185, 28, 255, 255, 28, 255, 185, 18, 256, 256, 18, 256, 185, 26, 257, 257, 106, 257, 257, 26, 257, 186, 106, 257, 310, 30, 258, 258, 30, 258, 186, 28, 259, 259, 28, 259, 186, 18, 260, 260, 18, 260, 186, 23, 261, 261, 24, 261, 261, 23, 261, 187, 26, 262, 262, 106, 262, 262, 26, 262, 187, 106, 262, 311, 30, 263, 263, 30, 263, 187, 28, 264, 264, 28, 264, 187, 18, 265, 265, 18, 265, 187, 23, 266, 266, 24, 266, 266, 23, 266, 188, 26, 267, 267, 106, 267, 267, 26, 267, 188, 106, 267, 312, 30, 268, 268, 30, 268, 188, 28, 269, 269, 28, 269, 188, 18, 270, 270, 18, 270, 188, 33, 271, 271, 120, 271, 271, 33, 271, 189, 120, 271, 313, 23, 272, 272, 24, 272, 272, 23, 272, 190, 26, 273, 273, 106, 273, 273, 26, 273, 190, 106, 273, 314, 30, 274, 274, 30, 274, 190, 28, 275, 275, 28, 275, 190, 18, 276, 276, 18, 276, 190, 33, 277, 277, 120, 277, 277, 33, 277, 191, 120, 277, 315, 9, 278, 278, 98, 278, 278, 9, 278, 192, 98, 278, 316, 9, 279, 279, 98, 279, 279, 9, 279, 193, 98, 279, 317, 9, 280, 280, 98, 280, 280, 9, 280, 194, 98, 280, 318, 9, 281, 281, 98, 281, 281, 9, 281, 195, 98, 281, 319, 9, 282, 282, 98, 282, 282, 9, 282, 196, 98, 282, 320, 9, 283, 283, 98, 283, 283, 9, 283, 197, 98, 283, 321, 9, 284, 284, 98, 284, 284, 9, 284, 198, 98, 284, 322, 9, 285, 285, 98, 285, 285, 9, 285, 199, 98, 285, 323, 9, 286, 286, 98, 286, 286, 9, 286, 200, 98, 286, 324, 9, 287, 287, 98, 287, 287, 9, 287, 201, 98, 287, 325, 59, 288, 288, 59, 288, 203, 48, 289, 289, 48, 289, 207, 59, 290, 290, 59, 290, 209, 59, 291, 291, 59, 291, 212, 120, 292, 292, 33, 292, 292, 120, 292, 215, 42, 293, 293, 42, 293, 215, 34, 294, 294, 123, 294, 294, 122, 294, 294, 126, 294, 294, 125, 294, 294, 128, 294, 294, 34, 294, 216, 123, 294, 326, 122, 294, 326, 126, 294, 327, 125, 294, 327, 128, 294, 328, 34, 295, 295, 123, 295, 295, 126, 295, 295, 128, 295, 295, 122, 295, 295, 125, 295, 295, 34, 295, 217, 123, 295, 329, 126, 295, 330, 128, 295, 331, 122, 295, 332, 125, 295, 333, 34, 296, 296, 123, 296, 296, 126, 296, 296, 128, 296, 296, 122, 296, 296, 125, 296, 296, 34, 296, 218, 123, 296, 332, 126, 296, 333, 128, 296, 334, 122, 296, 329, 125, 296, 330, 37, 297, 297, 36, 297, 297, 37, 297, 220, 36, 297, 220, 40, 298, 298, 39, 298, 298, 40, 298, 220, 39, 298, 220, 34, 299, 299, 123, 299, 299, 126, 299, 299, 128, 299, 299, 122, 299, 299, 125, 299, 299, 34, 299, 227, 37, 300, 300, 36, 300, 300, 37, 300, 228, 36, 300, 228, 40, 301, 301, 39, 301, 301, 40, 301, 228, 39, 301, 228, 48, 302, 302, 48, 302, 233, 34, 303, 303, 123, 303, 303, 126, 303, 303, 128, 303, 303, 122, 303, 303, 125, 303, 303, 34, 303, 240, 37, 304, 304, 36, 304, 304, 37, 304, 241, 36, 304, 241, 40, 305, 305, 39, 305, 305, 40, 305, 241, 39, 305, 241, 48, 306, 306, 48, 306, 242, 34, 307, 307, 123, 307, 307, 126, 307, 307, 128, 307, 307, 122, 307, 307, 125, 307, 307, 34, 307, 248, 123, 307, 335, 126, 307, 336, 128, 307, 337, 122, 307, 338, 125, 307, 339, 20, 308, 308, 20, 308, 249, 20, 309, 309, 20, 309, 253, 20, 310, 310, 20, 310, 257, 20, 311, 311, 20, 311, 262, 20, 312, 312, 20, 312, 267, 34, 313, 313, 123, 313, 313, 126, 313, 313, 128, 313, 313, 122, 313, 313, 125, 313, 313, 34, 313, 271, 123, 313, 340, 126, 313, 341, 128, 313, 342, 122, 313, 343, 125, 313, 344, 20, 314, 314, 20, 314, 273, 34, 315, 315, 123, 315, 315, 126, 315, 315, 128, 315, 315, 122, 315, 315, 125, 315, 315, 34, 315, 277, 123, 315, 345, 126, 315, 346, 128, 315, 347, 122, 315, 348, 125, 315, 349, 12, 316, 316, 12, 316, 278, 12, 317, 317, 12, 317, 279, 12, 318, 318, 12, 318, 280, 12, 319, 319, 12, 319, 281, 12, 320, 320, 12, 320, 282, 12, 321, 321, 12, 321, 283, 12, 322, 322, 12, 322, 284, 12, 323, 323, 12, 323, 285, 12, 324, 324, 12, 324, 286, 12, 325, 325, 12, 325, 287, 37, 326, 326, 36, 326, 326, 37, 326, 294, 36, 326, 294, 40, 327, 327, 39, 327, 327, 40, 327, 294, 39, 327, 294, 42, 328, 328, 42, 328, 294, 37, 329, 329, 36, 329, 329, 37, 329, 295, 36, 329, 296, 40, 330, 330, 39, 330, 330, 40, 330, 295, 39, 330, 296, 42, 331, 331, 42, 331, 295, 37, 332, 332, 36, 332, 332, 37, 332, 296, 36, 332, 295, 40, 333, 333, 39, 333, 333, 40, 333, 296, 39, 333, 295, 42, 334, 334, 42, 334, 296, 37, 335, 335, 36, 335, 335, 37, 335, 307, 36, 335, 350, 40, 336, 336, 39, 336, 336, 40, 336, 307, 39, 336, 350, 42, 337, 337, 42, 337, 307, 37, 338, 338, 36, 338, 338, 37, 338, 350, 36, 338, 307, 40, 339, 339, 39, 339, 339, 40, 339, 350, 39, 339, 307, 37, 340, 340, 36, 340, 340, 37, 340, 313, 36, 340, 351, 40, 341, 341, 39, 341, 341, 40, 341, 313, 39, 341, 351, 42, 342, 342, 42, 342, 313, 37, 343, 343, 36, 343, 343, 37, 343, 351, 36, 343, 313, 40, 344, 344, 39, 344, 344, 40, 344, 351, 39, 344, 313, 37, 345, 345, 36, 345, 345, 37, 345, 315, 36, 345, 352, 40, 346, 346, 39, 346, 346, 40, 346, 315, 39, 346, 352, 42, 347, 347, 42, 347, 315, 37, 348, 348, 36, 348, 348, 37, 348, 352, 36, 348, 315, 40, 349, 349, 39, 349, 349, 40, 349, 352, 39, 349, 315, 34, 350, 350, 123, 350, 350, 126, 350, 350, 128, 350, 350, 122, 350, 350, 125, 350, 350, 34, 350, 353, 123, 350, 338, 126, 350, 339, 128, 350, 354, 122, 350, 335, 125, 350, 336, 34, 351, 351, 123, 351, 351, 126, 351, 351, 128, 351, 351, 122, 351, 351, 125, 351, 351, 34, 351, 355, 123, 351, 343, 126, 351, 344, 128, 351, 356, 122, 351, 340, 125, 351, 341, 34, 352, 352, 123, 352, 352, 126, 352, 352, 128, 352, 352, 122, 352, 352, 125, 352, 352, 34, 352, 357, 123, 352, 348, 126, 352, 349, 128, 352, 358, 122, 352, 345, 125, 352, 346, 120, 353, 353, 33, 353, 353, 120, 353, 350, 42, 354, 354, 42, 354, 350, 120, 355, 355, 33, 355, 355, 120, 355, 351, 42, 356, 356, 42, 356, 351, 120, 357, 357, 33, 357, 357, 120, 357, 352, 42, 358, 358, 42, 358, 352)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(90, 3, 180, 180, 152, 7, 178, 182, 156, 7, 173, 167, 2, 9, 86, 1, 1, 9, 87, 1, 171, 11, 182, 155, 170, 11, 182, 184, 85, 12, 156, 193, 83, 12, 182, 181, 90, 13, 179, 182, 171, 15, 180, 155, 170, 15, 180, 184, 152, 16, 178, 179, 156, 16, 173, 158, 65, 17, 175, 194, 90, 18, 180, 182, 152, 19, 176, 182, 171, 20, 180, 148, 170, 20, 180, 181, 2, 21, 88, 1, 1, 21, 89, 1, 90, 22, 180, 179, 65, 24, 175, 192, 157, 24, 197, 173, 65, 25, 175, 189, 156, 27, 173, 137, 85, 28, 137, 188, 83, 28, 180, 184, 65, 32, 174, 194, 65, 33, 174, 190, 2, 35, 90, 1, 1, 35, 91, 1, 152, 37, 178, 180, 156, 37, 173, 136, 152, 39, 176, 180, 157, 40, 198, 173, 85, 41, 137, 191, 2, 42, 92, 1, 1, 42, 93, 1, 2, 46, 94, 1, 1, 46, 95, 1, 65, 47, 174, 189, 152, 48, 183, 180, 2, 49, 96, 1, 1, 49, 97, 1, 2, 50, 98, 1, 1, 50, 99, 1, 156, 53, 173, 156, 157, 55, 199, 173, 83, 56, 180, 177, 171, 59, 179, 155, 170, 59, 179, 184, 157, 60, 200, 173, 2, 61, 100, 1, 1, 61, 101, 1, 171, 62, 179, 148, 170, 62, 179, 181, 2, 66, 102, 1, 1, 66, 103, 1, 2, 67, 104, 1, 1, 67, 105, 1, 65, 69, 174, 192, 157, 69, 201, 173, 90, 70, 179, 179, 2, 71, 106, 1, 1, 71, 107, 1, 90, 72, 182, 179, 152, 73, 183, 182, 90, 74, 179, 180, 85, 76, 156, 191, 85, 77, 156, 188, 83, 77, 180, 181, 85, 78, 137, 187, 83, 78, 179, 184, 83, 79, 182, 177, 2, 80, 108, 1, 1, 80, 109, 1, 85, 81, 156, 187, 83, 81, 179, 181, 90, 82, 182, 182, 2, 83, 110, 1, 1, 83, 111, 1, 152, 84, 183, 179, 2, 85, 112, 1, 1, 85, 113, 1, 152, 87, 176, 179, 90, 88, 182, 180, 83, 90, 179, 177, 2, 91, 114, 1, 1, 91, 115, 1, 65, 93, 175, 190, 171, 94, 182, 148, 170, 94, 182, 181, 85, 95, 137, 193, 83, 95, 182, 184, 84, 101, 137, 137, 84, 105, 156, 137, 163, 106, 174, 173, 163, 107, 175, 173, 81, 114, 170, 173, 81, 115, 141, 173, 81, 118, 142, 173, 89, 120, 171, 173, 89, 122, 149, 173, 89, 128, 140, 173, 89, 129, 139, 173, 23, 134, 185, 202, 23, 135, 185, 203, 109, 138, 204, 173, 142, 138, 205, 173, 106, 138, 206, 173, 109, 139, 207, 173, 142, 139, 208, 173, 106, 139, 209, 173, 158, 148, 183, 173, 169, 151, 193, 168, 169, 153, 188, 168, 169, 159, 191, 168, 158, 161, 178, 173, 158, 164, 176, 173, 169, 169, 187, 168, 110, 185, 207, 173, 110, 187, 204, 173, 110, 191, 210, 173, 143, 210, 211, 173, 143, 213, 212, 173, 136, 234, 213, 195, 136, 243, 214, 195, 24, 262, 185, 203, 24, 267, 185, 202, 24, 273, 185, 215, 33, 293, 216, 217, 123, 300, 218, 173, 126, 300, 219, 173, 128, 300, 220, 196, 122, 300, 218, 173, 125, 300, 219, 173, 123, 304, 221, 173, 126, 304, 222, 173, 128, 304, 223, 196, 122, 304, 224, 173, 125, 304, 225, 173, 33, 354, 186, 226, 33, 356, 186, 227, 33, 358, 186, 228)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 3: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=3
nb_c=293
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=590 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(157, 0, 0, 65, 0, 0, 157, 0, 132, 86, 1, 1, 156, 1, 1, 152, 1, 1, 86, 1, 28, 156, 1, 102, 79, 2, 2, 85, 2, 2, 164, 2, 2, 83, 2, 2, 79, 2, 28, 85, 2, 119, 164, 2, 49, 79, 3, 3, 164, 3, 3, 85, 3, 3, 83, 3, 3, 79, 3, 92, 164, 3, 100, 79, 4, 4, 164, 4, 4, 85, 4, 4, 83, 4, 4, 79, 4, 82, 164, 4, 87, 86, 5, 5, 152, 5, 5, 156, 5, 5, 86, 5, 99, 86, 6, 6, 152, 6, 6, 156, 6, 6, 86, 6, 53, 78, 7, 7, 90, 7, 7, 78, 7, 58, 90, 7, 116, 78, 8, 8, 90, 8, 8, 78, 8, 112, 165, 9, 9, 172, 9, 9, 2, 9, 9, 1, 9, 9, 165, 9, 33, 172, 9, 90, 165, 10, 10, 172, 10, 10, 2, 10, 10, 1, 10, 10, 165, 10, 112, 172, 10, 80, 86, 11, 11, 156, 11, 11, 152, 11, 11, 86, 11, 21, 156, 11, 106, 78, 12, 12, 90, 12, 12, 78, 12, 115, 65, 13, 13, 157, 13, 13, 65, 13, 121, 86, 14, 14, 156, 14, 14, 152, 14, 14, 86, 14, 60, 156, 14, 95, 86, 15, 15, 156, 15, 15, 152, 15, 15, 86, 15, 64, 156, 15, 104, 78, 16, 16, 90, 16, 16, 78, 16, 84, 78, 17, 17, 90, 17, 17, 78, 17, 101, 78, 18, 18, 90, 18, 18, 78, 18, 94, 78, 19, 19, 90, 19, 19, 78, 19, 27, 79, 20, 20, 164, 20, 20, 85, 20, 20, 83, 20, 20, 79, 20, 50, 164, 20, 114, 165, 21, 21, 172, 21, 21, 2, 21, 21, 1, 21, 21, 165, 21, 62, 172, 21, 11, 79, 22, 22, 164, 22, 22, 85, 22, 22, 83, 22, 22, 79, 22, 56, 164, 22, 70, 78, 23, 23, 90, 23, 23, 78, 23, 105, 165, 24, 24, 172, 24, 24, 2, 24, 24, 1, 24, 24, 165, 24, 58, 172, 24, 41, 70, 25, 25, 170, 25, 25, 147, 25, 25, 171, 25, 25, 170, 25, 25, 70, 25, 55, 170, 25, 140, 147, 25, 141, 78, 26, 26, 90, 26, 26, 78, 26, 62, 79, 27, 27, 164, 27, 27, 85, 27, 27, 83, 27, 27, 79, 27, 103, 164, 27, 19, 165, 28, 28, 172, 28, 28, 2, 28, 28, 1, 28, 28, 165, 28, 2, 172, 28, 1, 65, 29, 29, 157, 29, 29, 65, 29, 122, 157, 29, 133, 165, 30, 30, 172, 30, 30, 2, 30, 30, 1, 30, 30, 165, 30, 105, 172, 30, 77, 86, 31, 31, 152, 31, 31, 156, 31, 31, 86, 31, 56, 157, 32, 32, 65, 32, 32, 157, 32, 127, 79, 33, 33, 164, 33, 33, 85, 33, 33, 83, 33, 33, 79, 33, 9, 164, 33, 96, 65, 34, 34, 157, 34, 34, 79, 35, 35, 164, 35, 35, 85, 35, 35, 83, 35, 35, 79, 35, 44, 164, 35, 37, 165, 36, 36, 172, 36, 36, 2, 36, 36, 1, 36, 36, 165, 36, 94, 172, 36, 75, 78, 37, 37, 90, 37, 37, 78, 37, 35, 165, 38, 38, 172, 38, 38, 2, 38, 38, 1, 38, 38, 165, 38, 101, 172, 38, 97, 157, 39, 39, 65, 39, 39, 157, 39, 128, 86, 40, 40, 156, 40, 40, 152, 40, 40, 86, 40, 103, 156, 40, 72, 86, 41, 41, 152, 41, 41, 156, 41, 41, 86, 41, 24, 152, 41, 117, 78, 42, 42, 90, 42, 42, 78, 42, 65, 90, 42, 116, 157, 43, 43, 65, 43, 43, 157, 43, 134, 165, 44, 44, 172, 44, 44, 2, 44, 44, 1, 44, 44, 165, 44, 35, 172, 44, 55, 65, 45, 45, 157, 45, 45, 165, 46, 46, 172, 46, 46, 2, 46, 46, 1, 46, 46, 165, 46, 51, 172, 46, 48, 86, 47, 47, 152, 47, 47, 156, 47, 47, 86, 47, 50, 86, 48, 48, 152, 48, 48, 156, 48, 48, 86, 48, 46, 78, 49, 49, 90, 49, 49, 78, 49, 2, 165, 50, 50, 172, 50, 50, 2, 50, 50, 1, 50, 50, 165, 50, 20, 172, 50, 47, 79, 51, 51, 164, 51, 51, 85, 51, 51, 83, 51, 51, 79, 51, 46, 164, 51, 69, 65, 52, 52, 157, 52, 52, 165, 53, 53, 172, 53, 53, 2, 53, 53, 1, 53, 53, 165, 53, 83, 172, 53, 6, 86, 54, 54, 152, 54, 54, 156, 54, 54, 86, 54, 92, 86, 55, 55, 156, 55, 55, 152, 55, 55, 86, 55, 44, 156, 55, 25, 165, 56, 56, 172, 56, 56, 2, 56, 56, 1, 56, 56, 165, 56, 22, 172, 56, 31, 79, 57, 57, 164, 57, 57, 85, 57, 57, 83, 57, 57, 79, 57, 99, 164, 57, 109, 79, 58, 58, 83, 58, 58, 164, 58, 58, 85, 58, 58, 79, 58, 24, 83, 58, 118, 164, 58, 7, 157, 59, 59, 65, 59, 59, 157, 59, 131, 165, 60, 60, 172, 60, 60, 2, 60, 60, 1, 60, 60, 165, 60, 115, 172, 60, 14, 65, 61, 61, 157, 61, 61, 79, 62, 62, 85, 62, 62, 164, 62, 62, 83, 62, 62, 79, 62, 21, 85, 62, 126, 164, 62, 26, 80, 63, 63, 153, 63, 63, 131, 63, 63, 80, 63, 116, 153, 63, 98, 131, 63, 142, 165, 64, 64, 172, 64, 64, 2, 64, 64, 1, 64, 64, 165, 64, 84, 172, 64, 15, 79, 65, 65, 85, 65, 65, 83, 65, 65, 164, 65, 65, 79, 65, 89, 85, 65, 124, 83, 65, 116, 164, 65, 42, 157, 66, 66, 65, 66, 66, 157, 66, 135, 65, 67, 67, 157, 67, 67, 3, 68, 68, 154, 68, 68, 155, 68, 68, 3, 68, 127, 154, 68, 143, 155, 68, 144, 78, 69, 69, 90, 69, 69, 78, 69, 51, 78, 70, 70, 90, 70, 70, 78, 70, 22, 65, 71, 71, 157, 71, 71, 65, 71, 120, 70, 72, 72, 170, 72, 72, 147, 72, 72, 171, 72, 72, 170, 72, 72, 70, 72, 40, 170, 72, 145, 147, 72, 146, 78, 73, 73, 90, 73, 73, 78, 73, 83, 70, 74, 74, 170, 74, 74, 147, 74, 74, 171, 74, 74, 170, 74, 74, 70, 74, 80, 170, 74, 147, 147, 74, 148, 86, 75, 75, 152, 75, 75, 156, 75, 75, 86, 75, 36, 157, 76, 76, 65, 76, 76, 157, 76, 136, 86, 77, 77, 156, 77, 77, 152, 77, 77, 86, 77, 30, 156, 77, 88, 70, 78, 78, 170, 78, 78, 147, 78, 78, 171, 78, 78, 170, 78, 78, 70, 78, 90, 170, 78, 149, 147, 78, 150, 65, 79, 79, 157, 79, 79, 86, 80, 80, 156, 80, 80, 152, 80, 80, 86, 80, 10, 156, 80, 74, 65, 81, 81, 157, 81, 81, 165, 82, 82, 172, 82, 82, 2, 82, 82, 1, 82, 82, 165, 82, 4, 172, 82, 85, 79, 83, 83, 164, 83, 83, 85, 83, 83, 83, 83, 83, 79, 83, 53, 164, 83, 73, 79, 84, 84, 164, 84, 84, 85, 84, 84, 83, 84, 84, 79, 84, 64, 164, 84, 16, 86, 85, 85, 152, 85, 85, 156, 85, 85, 86, 85, 82, 70, 86, 86, 171, 86, 86, 170, 86, 86, 170, 86, 86, 147, 86, 86, 70, 86, 93, 171, 86, 116, 170, 86, 116, 170, 86, 151, 147, 86, 152, 78, 87, 87, 90, 87, 87, 78, 87, 4, 70, 88, 88, 170, 88, 88, 147, 88, 88, 171, 88, 88, 170, 88, 88, 70, 88, 77, 170, 88, 153, 147, 88, 154, 165, 89, 89, 172, 89, 89, 2, 89, 89, 1, 89, 89, 165, 89, 65, 172, 89, 93, 86, 90, 90, 156, 90, 90, 152, 90, 90, 86, 90, 9, 156, 90, 78, 65, 91, 91, 157, 91, 91, 65, 91, 123, 165, 92, 92, 172, 92, 92, 2, 92, 92, 1, 92, 92, 165, 92, 3, 172, 92, 54, 86, 93, 93, 152, 93, 93, 156, 93, 93, 86, 93, 89, 152, 93, 116, 156, 93, 86, 79, 94, 94, 164, 94, 94, 85, 94, 94, 83, 94, 94, 79, 94, 36, 164, 94, 18, 70, 95, 95, 170, 95, 95, 147, 95, 95, 171, 95, 95, 170, 95, 95, 70, 95, 14, 170, 95, 155, 147, 95, 156, 78, 96, 96, 90, 96, 96, 78, 96, 33, 86, 97, 97, 152, 97, 97, 156, 97, 97, 86, 97, 38, 67, 98, 98, 167, 98, 98, 118, 98, 98, 168, 98, 98, 67, 98, 63, 167, 98, 120, 118, 98, 157, 168, 98, 117, 165, 99, 99, 172, 99, 99, 2, 99, 99, 1, 99, 99, 165, 99, 57, 172, 99, 5, 78, 100, 100, 90, 100, 100, 78, 100, 3, 79, 101, 101, 164, 101, 101, 85, 101, 101, 83, 101, 101, 79, 101, 38, 164, 101, 17, 70, 102, 102, 170, 102, 102, 147, 102, 102, 171, 102, 102, 170, 102, 102, 70, 102, 1, 170, 102, 158, 147, 102, 159, 165, 103, 103, 172, 103, 103, 2, 103, 103, 1, 103, 103, 165, 103, 27, 172, 103, 40, 70, 104, 104, 170, 104, 104, 147, 104, 104, 171, 104, 104, 170, 104, 104, 70, 104, 15, 170, 104, 160, 147, 104, 161, 79, 105, 105, 164, 105, 105, 85, 105, 105, 83, 105, 105, 79, 105, 30, 164, 105, 23, 70, 106, 106, 170, 106, 106, 147, 106, 106, 171, 106, 106, 170, 106, 106, 70, 106, 11, 170, 106, 162, 147, 106, 163, 3, 107, 107, 154, 107, 107, 155, 107, 107, 3, 107, 136, 154, 107, 144, 155, 107, 143, 157, 108, 108, 65, 108, 108, 157, 108, 129, 78, 109, 109, 90, 109, 109, 78, 109, 57, 3, 110, 110, 154, 110, 110, 155, 110, 110, 3, 110, 130, 154, 110, 164, 155, 110, 165, 3, 111, 111, 154, 111, 111, 155, 111, 111, 3, 111, 132, 154, 111, 165, 155, 111, 164, 79, 112, 112, 164, 112, 112, 85, 112, 112, 83, 112, 112, 79, 112, 10, 164, 112, 8, 157, 113, 113, 65, 113, 113, 157, 113, 130, 78, 114, 114, 90, 114, 114, 78, 114, 20, 79, 115, 115, 85, 115, 115, 164, 115, 115, 83, 115, 115, 79, 115, 60, 85, 115, 125, 164, 115, 12, 4, 116, 116, 4, 116, 116, 66, 116, 116, 85, 116, 116, 84, 116, 116, 169, 116, 116, 166, 116, 116, 4, 116, 7, 4, 116, 42, 66, 116, 93, 85, 116, 86, 84, 116, 86, 169, 116, 65, 166, 116, 63, 72, 117, 117, 44, 117, 117, 66, 117, 117, 82, 117, 117, 139, 117, 117, 163, 117, 117, 72, 117, 144, 44, 117, 166, 66, 117, 41, 82, 117, 98, 139, 117, 138, 169, 118, 118, 84, 118, 118, 169, 118, 58, 83, 119, 119, 171, 119, 119, 100, 119, 119, 83, 119, 158, 171, 119, 2, 100, 119, 167, 81, 120, 120, 73, 120, 120, 151, 120, 120, 103, 120, 120, 81, 120, 98, 73, 120, 144, 151, 120, 71, 103, 120, 168, 73, 121, 121, 151, 121, 121, 103, 121, 121, 81, 121, 121, 73, 121, 164, 151, 121, 13, 103, 121, 169, 73, 122, 122, 151, 122, 122, 103, 122, 122, 81, 122, 122, 73, 122, 143, 151, 122, 29, 103, 122, 170, 73, 123, 123, 151, 123, 123, 103, 123, 123, 81, 123, 123, 73, 123, 165, 151, 123, 91, 103, 123, 171, 83, 124, 124, 171, 124, 124, 100, 124, 124, 83, 124, 151, 171, 124, 65, 100, 124, 172, 83, 125, 125, 171, 125, 125, 100, 125, 125, 83, 125, 155, 171, 125, 115, 100, 125, 139, 83, 126, 126, 171, 126, 126, 100, 126, 126, 83, 126, 162, 171, 126, 62, 100, 126, 173, 71, 127, 127, 89, 127, 127, 94, 127, 127, 71, 127, 32, 89, 127, 68, 94, 127, 174, 71, 128, 128, 94, 128, 128, 89, 128, 128, 71, 128, 39, 94, 128, 175, 71, 129, 129, 94, 129, 129, 89, 129, 129, 71, 129, 108, 94, 129, 176, 71, 130, 130, 89, 130, 130, 94, 130, 130, 71, 130, 113, 89, 130, 110, 94, 130, 177, 71, 131, 131, 94, 131, 131, 89, 131, 131, 71, 131, 59, 94, 131, 178, 71, 132, 132, 89, 132, 132, 94, 132, 132, 71, 132, 0, 89, 132, 111, 94, 132, 179, 71, 133, 133, 94, 133, 133, 89, 133, 133, 71, 133, 29, 94, 133, 180, 71, 134, 134, 94, 134, 134, 89, 134, 134, 71, 134, 43, 94, 134, 181, 71, 135, 135, 94, 135, 135, 89, 135, 135, 71, 135, 66, 94, 135, 182, 71, 136, 136, 89, 136, 136, 94, 136, 136, 71, 136, 76, 89, 136, 107, 94, 136, 183, 24, 137, 137, 23, 137, 137, 24, 137, 170, 53, 138, 138, 110, 138, 138, 142, 138, 138, 140, 138, 138, 109, 138, 138, 142, 138, 138, 106, 138, 138, 53, 138, 117, 110, 138, 184, 142, 138, 185, 140, 138, 186, 14, 139, 139, 119, 139, 139, 14, 139, 125, 119, 139, 187, 84, 140, 140, 169, 140, 140, 84, 140, 25, 61, 141, 141, 148, 141, 141, 128, 141, 141, 61, 141, 25, 148, 141, 188, 128, 141, 189, 45, 142, 142, 132, 142, 142, 45, 142, 63, 132, 142, 190, 69, 143, 143, 68, 143, 143, 159, 143, 143, 158, 143, 143, 69, 143, 107, 68, 143, 68, 159, 143, 122, 69, 144, 144, 68, 144, 144, 158, 144, 144, 159, 144, 144, 69, 144, 68, 68, 144, 107, 158, 144, 117, 159, 144, 120, 84, 145, 145, 169, 145, 145, 84, 145, 72, 61, 146, 146, 148, 146, 146, 128, 146, 146, 61, 146, 72, 148, 146, 191, 128, 146, 192, 84, 147, 147, 169, 147, 147, 84, 147, 74, 61, 148, 148, 148, 148, 148, 128, 148, 148, 61, 148, 74, 148, 148, 193, 128, 148, 194, 84, 149, 149, 169, 149, 149, 84, 149, 78, 61, 150, 150, 148, 150, 150, 128, 150, 150, 61, 150, 78, 148, 150, 195, 128, 150, 196, 84, 151, 151, 169, 151, 151, 84, 151, 86, 169, 151, 124, 61, 152, 152, 148, 152, 152, 128, 152, 152, 61, 152, 86, 148, 152, 197, 128, 152, 198, 84, 153, 153, 169, 153, 153, 84, 153, 88, 61, 154, 154, 148, 154, 154, 128, 154, 154, 61, 154, 88, 148, 154, 199, 128, 154, 200, 84, 155, 155, 169, 155, 155, 84, 155, 95, 169, 155, 125, 61, 156, 156, 148, 156, 156, 128, 156, 156, 61, 156, 95, 148, 156, 201, 128, 156, 202, 32, 157, 157, 119, 157, 157, 120, 157, 157, 32, 157, 98, 119, 157, 203, 120, 157, 204, 84, 158, 158, 169, 158, 158, 84, 158, 102, 169, 158, 119, 61, 159, 159, 148, 159, 159, 128, 159, 159, 61, 159, 102, 148, 159, 205, 128, 159, 206, 84, 160, 160, 169, 160, 160, 84, 160, 104, 61, 161, 161, 148, 161, 161, 128, 161, 161, 61, 161, 104, 148, 161, 207, 128, 161, 208, 84, 162, 162, 169, 162, 162, 84, 162, 106, 169, 162, 126, 61, 163, 163, 148, 163, 163, 128, 163, 163, 61, 163, 106, 148, 163, 209, 128, 163, 210, 69, 164, 164, 68, 164, 164, 159, 164, 164, 158, 164, 164, 69, 164, 111, 68, 164, 110, 159, 164, 121, 69, 165, 165, 68, 165, 165, 159, 165, 165, 158, 165, 165, 69, 165, 110, 68, 165, 111, 159, 165, 123, 42, 166, 166, 130, 166, 166, 42, 166, 204, 130, 166, 117, 14, 167, 167, 119, 167, 167, 14, 167, 119, 119, 167, 211, 17, 168, 168, 109, 168, 168, 112, 168, 168, 116, 168, 168, 114, 168, 168, 104, 168, 168, 110, 168, 168, 17, 168, 120, 109, 168, 184, 112, 168, 212, 116, 168, 213, 114, 168, 214, 104, 168, 215, 17, 169, 169, 109, 169, 169, 112, 169, 169, 116, 169, 169, 114, 169, 169, 104, 169, 169, 110, 169, 169, 17, 169, 121, 109, 169, 216, 112, 169, 217, 116, 169, 218, 114, 169, 219, 104, 169, 220, 17, 170, 170, 109, 170, 170, 112, 170, 170, 116, 170, 170, 110, 170, 170, 114, 170, 170, 104, 170, 170, 17, 170, 122, 109, 170, 221, 112, 170, 222, 116, 170, 223, 110, 170, 137, 114, 170, 224, 104, 170, 225, 17, 171, 171, 109, 171, 171, 112, 171, 171, 116, 171, 171, 114, 171, 171, 104, 171, 171, 110, 171, 171, 17, 171, 123, 109, 171, 226, 112, 171, 227, 116, 171, 228, 114, 171, 229, 104, 171, 230, 14, 172, 172, 119, 172, 172, 14, 172, 124, 119, 172, 231, 14, 173, 173, 119, 173, 173, 14, 173, 126, 119, 173, 232, 8, 174, 174, 95, 174, 174, 8, 174, 127, 95, 174, 233, 8, 175, 175, 95, 175, 175, 8, 175, 128, 95, 175, 234, 8, 176, 176, 95, 176, 176, 8, 176, 129, 95, 176, 235, 8, 177, 177, 95, 177, 177, 8, 177, 130, 95, 177, 236, 8, 178, 178, 95, 178, 178, 8, 178, 131, 95, 178, 237, 8, 179, 179, 95, 179, 179, 8, 179, 132, 95, 179, 238, 8, 180, 180, 95, 180, 180, 8, 180, 133, 95, 180, 239, 8, 181, 181, 95, 181, 181, 8, 181, 134, 95, 181, 240, 8, 182, 182, 95, 182, 182, 8, 182, 135, 95, 182, 241, 8, 183, 183, 95, 183, 183, 8, 183, 136, 95, 183, 242, 23, 184, 184, 24, 184, 184, 23, 184, 168, 24, 184, 138, 56, 185, 185, 145, 185, 185, 143, 185, 185, 56, 185, 138, 145, 185, 243, 54, 186, 186, 54, 186, 138, 33, 187, 187, 120, 187, 187, 33, 187, 139, 120, 187, 244, 62, 188, 188, 62, 188, 141, 42, 189, 189, 42, 189, 141, 46, 190, 190, 134, 190, 190, 136, 190, 190, 46, 190, 142, 134, 190, 245, 62, 191, 191, 62, 191, 146, 42, 192, 192, 42, 192, 146, 62, 193, 193, 62, 193, 148, 42, 194, 194, 42, 194, 148, 62, 195, 195, 62, 195, 150, 42, 196, 196, 42, 196, 150, 62, 197, 197, 62, 197, 152, 42, 198, 198, 42, 198, 152, 62, 199, 199, 62, 199, 154, 42, 200, 200, 42, 200, 154, 62, 201, 201, 62, 201, 156, 42, 202, 202, 42, 202, 156, 33, 203, 203, 120, 203, 203, 33, 203, 157, 120, 203, 246, 34, 204, 204, 123, 204, 204, 122, 204, 204, 126, 204, 204, 125, 204, 204, 128, 204, 204, 34, 204, 157, 123, 204, 247, 122, 204, 247, 126, 204, 248, 125, 204, 248, 128, 204, 166, 62, 205, 205, 62, 205, 159, 42, 206, 206, 42, 206, 159, 62, 207, 207, 62, 207, 161, 42, 208, 208, 42, 208, 161, 62, 209, 209, 62, 209, 163, 42, 210, 210, 42, 210, 163, 33, 211, 211, 120, 211, 211, 33, 211, 167, 120, 211, 249, 26, 212, 212, 106, 212, 212, 26, 212, 168, 106, 212, 250, 30, 213, 213, 30, 213, 168, 28, 214, 214, 28, 214, 168, 18, 215, 215, 18, 215, 168, 23, 216, 216, 24, 216, 216, 23, 216, 169, 26, 217, 217, 106, 217, 217, 26, 217, 169, 106, 217, 251, 30, 218, 218, 30, 218, 169, 28, 219, 219, 28, 219, 169, 18, 220, 220, 18, 220, 169, 23, 221, 221, 24, 221, 221, 23, 221, 170, 26, 222, 222, 106, 222, 222, 26, 222, 170, 106, 222, 252, 30, 223, 223, 30, 223, 170, 28, 224, 224, 28, 224, 170, 18, 225, 225, 18, 225, 170, 23, 226, 226, 24, 226, 226, 23, 226, 171, 26, 227, 227, 106, 227, 227, 26, 227, 171, 106, 227, 253, 30, 228, 228, 30, 228, 171, 28, 229, 229, 28, 229, 171, 18, 230, 230, 18, 230, 171, 33, 231, 231, 120, 231, 231, 33, 231, 172, 120, 231, 254, 33, 232, 232, 120, 232, 232, 33, 232, 173, 120, 232, 255, 9, 233, 233, 98, 233, 233, 9, 233, 174, 98, 233, 256, 9, 234, 234, 98, 234, 234, 9, 234, 175, 98, 234, 257, 9, 235, 235, 98, 235, 235, 9, 235, 176, 98, 235, 258, 9, 236, 236, 98, 236, 236, 9, 236, 177, 98, 236, 259, 9, 237, 237, 98, 237, 237, 9, 237, 178, 98, 237, 260, 9, 238, 238, 98, 238, 238, 9, 238, 179, 98, 238, 261, 9, 239, 239, 98, 239, 239, 9, 239, 180, 98, 239, 262, 9, 240, 240, 98, 240, 240, 9, 240, 181, 98, 240, 263, 9, 241, 241, 98, 241, 241, 9, 241, 182, 98, 241, 264, 9, 242, 242, 98, 242, 242, 9, 242, 183, 98, 242, 265, 59, 243, 243, 59, 243, 185, 34, 244, 244, 123, 244, 244, 122, 244, 244, 126, 244, 244, 125, 244, 244, 128, 244, 244, 34, 244, 187, 123, 244, 266, 122, 244, 266, 126, 244, 267, 125, 244, 267, 128, 244, 268, 48, 245, 245, 48, 245, 190, 34, 246, 246, 123, 246, 246, 126, 246, 246, 128, 246, 246, 122, 246, 246, 125, 246, 246, 34, 246, 203, 37, 247, 247, 36, 247, 247, 37, 247, 204, 36, 247, 204, 40, 248, 248, 39, 248, 248, 40, 248, 204, 39, 248, 204, 34, 249, 249, 123, 249, 249, 126, 249, 249, 128, 249, 249, 122, 249, 249, 125, 249, 249, 34, 249, 211, 123, 249, 269, 126, 249, 270, 128, 249, 271, 122, 249, 272, 125, 249, 273, 20, 250, 250, 20, 250, 212, 20, 251, 251, 20, 251, 217, 20, 252, 252, 20, 252, 222, 20, 253, 253, 20, 253, 227, 34, 254, 254, 123, 254, 254, 126, 254, 254, 128, 254, 254, 122, 254, 254, 125, 254, 254, 34, 254, 231, 123, 254, 274, 126, 254, 275, 128, 254, 276, 122, 254, 277, 125, 254, 278, 34, 255, 255, 123, 255, 255, 126, 255, 255, 128, 255, 255, 122, 255, 255, 125, 255, 255, 34, 255, 232, 123, 255, 279, 126, 255, 280, 128, 255, 281, 122, 255, 282, 125, 255, 283, 12, 256, 256, 12, 256, 233, 12, 257, 257, 12, 257, 234, 12, 258, 258, 12, 258, 235, 12, 259, 259, 12, 259, 236, 12, 260, 260, 12, 260, 237, 12, 261, 261, 12, 261, 238, 12, 262, 262, 12, 262, 239, 12, 263, 263, 12, 263, 240, 12, 264, 264, 12, 264, 241, 12, 265, 265, 12, 265, 242, 37, 266, 266, 36, 266, 266, 37, 266, 244, 36, 266, 244, 40, 267, 267, 39, 267, 267, 40, 267, 244, 39, 267, 244, 42, 268, 268, 42, 268, 244, 37, 269, 269, 36, 269, 269, 37, 269, 249, 36, 269, 284, 40, 270, 270, 39, 270, 270, 40, 270, 249, 39, 270, 284, 42, 271, 271, 42, 271, 249, 37, 272, 272, 36, 272, 272, 37, 272, 284, 36, 272, 249, 40, 273, 273, 39, 273, 273, 40, 273, 284, 39, 273, 249, 37, 274, 274, 36, 274, 274, 37, 274, 254, 36, 274, 285, 40, 275, 275, 39, 275, 275, 40, 275, 254, 39, 275, 285, 42, 276, 276, 42, 276, 254, 37, 277, 277, 36, 277, 277, 37, 277, 285, 36, 277, 254, 40, 278, 278, 39, 278, 278, 40, 278, 285, 39, 278, 254, 37, 279, 279, 36, 279, 279, 37, 279, 255, 36, 279, 286, 40, 280, 280, 39, 280, 280, 40, 280, 255, 39, 280, 286, 42, 281, 281, 42, 281, 255, 37, 282, 282, 36, 282, 282, 37, 282, 286, 36, 282, 255, 40, 283, 283, 39, 283, 283, 40, 283, 286, 39, 283, 255, 34, 284, 284, 123, 284, 284, 126, 284, 284, 128, 284, 284, 122, 284, 284, 125, 284, 284, 34, 284, 287, 123, 284, 272, 126, 284, 273, 128, 284, 288, 122, 284, 269, 125, 284, 270, 34, 285, 285, 123, 285, 285, 126, 285, 285, 128, 285, 285, 122, 285, 285, 125, 285, 285, 34, 285, 289, 123, 285, 277, 126, 285, 278, 128, 285, 290, 122, 285, 274, 125, 285, 275, 34, 286, 286, 123, 286, 286, 126, 286, 286, 128, 286, 286, 122, 286, 286, 125, 286, 286, 34, 286, 291, 123, 286, 282, 126, 286, 283, 128, 286, 292, 122, 286, 279, 125, 286, 280, 120, 287, 287, 33, 287, 287, 120, 287, 284, 42, 288, 288, 42, 288, 284, 120, 289, 289, 33, 289, 289, 120, 289, 285, 42, 290, 290, 42, 290, 285, 120, 291, 291, 33, 291, 291, 120, 291, 286, 42, 292, 292, 42, 292, 286)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(65, 1, 174, 470, 152, 2, 183, 457, 83, 3, 457, 177, 85, 4, 389, 187, 83, 4, 179, 462, 85, 5, 137, 469, 83, 5, 461, 184, 152, 6, 465, 182, 156, 6, 173, 452, 152, 7, 465, 180, 156, 7, 173, 378, 90, 9, 179, 458, 2, 10, 46, 1, 1, 10, 47, 1, 2, 11, 48, 1, 1, 11, 49, 1, 152, 12, 183, 458, 90, 13, 182, 461, 157, 14, 478, 173, 152, 15, 183, 461, 152, 16, 460, 180, 90, 17, 461, 180, 90, 18, 457, 182, 90, 19, 180, 458, 90, 20, 179, 457, 85, 21, 137, 466, 83, 21, 457, 184, 2, 22, 50, 1, 1, 22, 51, 1, 85, 23, 389, 188, 83, 23, 180, 462, 90, 24, 461, 182, 2, 25, 52, 1, 1, 25, 53, 1, 171, 26, 461, 155, 170, 26, 461, 184, 90, 27, 182, 458, 85, 28, 156, 466, 83, 28, 457, 181, 2, 29, 54, 1, 1, 29, 55, 1, 2, 31, 56, 1, 1, 31, 57, 1, 152, 32, 464, 180, 156, 32, 173, 373, 65, 33, 456, 189, 85, 34, 156, 468, 83, 34, 179, 463, 65, 35, 175, 471, 157, 35, 479, 173, 85, 36, 156, 469, 83, 36, 461, 181, 2, 37, 58, 1, 1, 37, 59, 1, 90, 38, 179, 461, 2, 39, 60, 1, 1, 39, 61, 1, 65, 40, 174, 473, 152, 41, 176, 457, 156, 42, 173, 389, 65, 44, 456, 190, 2, 45, 62, 1, 1, 45, 63, 1, 65, 46, 175, 476, 157, 46, 480, 173, 2, 47, 64, 1, 1, 47, 65, 1, 152, 48, 178, 457, 156, 48, 173, 433, 152, 49, 465, 179, 156, 49, 173, 420, 90, 50, 182, 457, 2, 51, 66, 1, 1, 51, 67, 1, 85, 52, 137, 468, 83, 52, 179, 459, 65, 53, 175, 467, 157, 53, 481, 173, 2, 54, 68, 1, 1, 54, 69, 1, 152, 55, 464, 179, 156, 55, 173, 417, 152, 56, 176, 461, 2, 57, 70, 1, 1, 57, 71, 1, 85, 58, 137, 474, 83, 58, 182, 459, 85, 59, 389, 191, 65, 60, 175, 472, 2, 61, 72, 1, 1, 61, 73, 1, 65, 62, 174, 467, 157, 62, 482, 173, 83, 63, 458, 177, 2, 65, 74, 1, 1, 65, 75, 1, 65, 67, 174, 472, 65, 68, 174, 471, 157, 68, 483, 173, 90, 70, 458, 179, 90, 71, 457, 180, 157, 72, 484, 173, 171, 73, 457, 155, 170, 73, 457, 184, 90, 74, 458, 180, 171, 75, 458, 155, 170, 75, 458, 184, 152, 76, 178, 458, 156, 76, 173, 396, 65, 77, 175, 470, 152, 78, 460, 182, 171, 79, 179, 392, 170, 79, 179, 462, 65, 80, 456, 192, 157, 80, 485, 173, 152, 81, 176, 458, 65, 82, 174, 476, 157, 82, 486, 173, 2, 83, 76, 1, 1, 83, 77, 1, 85, 84, 137, 477, 83, 84, 180, 459, 85, 85, 156, 477, 83, 85, 180, 463, 152, 86, 178, 461, 156, 86, 173, 410, 90, 88, 180, 461, 171, 89, 182, 392, 170, 89, 182, 462, 2, 90, 78, 1, 1, 90, 79, 1, 152, 91, 460, 179, 157, 92, 487, 173, 2, 93, 80, 1, 1, 93, 81, 1, 85, 95, 137, 475, 83, 95, 458, 184, 171, 96, 461, 148, 170, 96, 461, 181, 90, 97, 461, 179, 152, 98, 464, 182, 156, 98, 173, 369, 2, 100, 82, 1, 1, 100, 83, 1, 90, 101, 457, 179, 85, 102, 389, 193, 83, 102, 182, 462, 171, 103, 457, 148, 170, 103, 457, 181, 2, 104, 84, 1, 1, 104, 85, 1, 171, 105, 180, 392, 170, 105, 180, 462, 85, 106, 156, 474, 83, 106, 182, 463, 171, 107, 458, 148, 170, 107, 458, 181, 65, 109, 175, 473, 90, 110, 458, 182, 85, 113, 156, 475, 83, 113, 458, 181, 65, 114, 456, 194, 90, 115, 180, 457, 83, 116, 461, 177, 163, 118, 456, 173, 84, 119, 389, 137, 81, 122, 421, 173, 81, 123, 368, 173, 81, 124, 381, 173, 89, 129, 394, 173, 89, 130, 403, 173, 89, 132, 444, 173, 89, 134, 415, 173, 89, 135, 363, 173, 89, 136, 401, 173, 23, 138, 185, 488, 109, 139, 489, 173, 142, 139, 490, 173, 106, 139, 491, 173, 169, 141, 469, 168, 158, 144, 460, 173, 169, 146, 466, 168, 169, 148, 475, 168, 169, 150, 468, 168, 169, 154, 474, 168, 169, 161, 477, 168, 158, 165, 465, 173, 158, 166, 464, 173, 110, 169, 489, 173, 110, 170, 492, 173, 110, 172, 493, 173, 143, 186, 494, 173, 136, 191, 495, 195, 24, 217, 185, 496, 24, 222, 185, 488, 24, 227, 185, 497, 123, 247, 498, 173, 126, 247, 499, 173, 128, 247, 500, 196, 122, 247, 501, 173, 125, 247, 502, 173, 33, 288, 186, 503, 33, 290, 186, 504, 33, 292, 186, 505)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 4: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=4
nb_c=142
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=883 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(78, 0, 0, 90, 0, 0, 78, 0, 4, 86, 1, 1, 152, 1, 1, 156, 1, 1, 86, 1, 35, 86, 2, 2, 156, 2, 2, 152, 2, 2, 86, 2, 51, 156, 2, 58, 165, 3, 3, 172, 3, 3, 2, 3, 3, 1, 3, 3, 165, 3, 8, 172, 3, 34, 79, 4, 4, 164, 4, 4, 85, 4, 4, 83, 4, 4, 79, 4, 10, 164, 4, 0, 86, 5, 5, 152, 5, 5, 156, 5, 5, 86, 5, 46, 78, 6, 6, 90, 6, 6, 78, 6, 50, 78, 7, 7, 90, 7, 7, 78, 7, 70, 79, 8, 8, 85, 8, 8, 164, 8, 8, 83, 8, 8, 79, 8, 3, 85, 8, 82, 164, 8, 64, 86, 9, 9, 152, 9, 9, 156, 9, 9, 86, 9, 29, 165, 10, 10, 172, 10, 10, 2, 10, 10, 1, 10, 10, 165, 10, 4, 172, 10, 61, 86, 11, 11, 152, 11, 11, 156, 11, 11, 86, 11, 73, 86, 12, 12, 152, 12, 12, 156, 12, 12, 86, 12, 21, 65, 13, 13, 157, 13, 13, 79, 14, 14, 164, 14, 14, 85, 14, 14, 83, 14, 14, 79, 14, 73, 164, 14, 76, 165, 15, 15, 172, 15, 15, 2, 15, 15, 1, 15, 15, 165, 15, 48, 172, 15, 74, 78, 16, 16, 90, 16, 16, 78, 16, 37, 79, 17, 17, 164, 17, 17, 85, 17, 17, 83, 17, 17, 79, 17, 52, 164, 17, 18, 78, 18, 18, 90, 18, 18, 78, 18, 17, 79, 19, 19, 164, 19, 19, 85, 19, 19, 83, 19, 19, 79, 19, 51, 164, 19, 47, 65, 20, 20, 157, 20, 20, 165, 21, 21, 172, 21, 21, 2, 21, 21, 1, 21, 21, 165, 21, 50, 172, 21, 12, 86, 22, 22, 152, 22, 22, 156, 22, 22, 86, 22, 68, 79, 23, 23, 164, 23, 23, 85, 23, 23, 83, 23, 23, 79, 23, 59, 164, 23, 78, 86, 24, 24, 152, 24, 24, 156, 24, 24, 86, 24, 32, 165, 25, 25, 172, 25, 25, 2, 25, 25, 1, 25, 25, 165, 25, 55, 172, 25, 65, 157, 26, 26, 65, 26, 26, 157, 26, 83, 65, 27, 27, 157, 27, 27, 78, 28, 28, 90, 28, 28, 78, 28, 48, 165, 29, 29, 172, 29, 29, 2, 29, 29, 1, 29, 29, 165, 29, 37, 172, 29, 9, 78, 30, 30, 90, 30, 30, 78, 30, 42, 65, 31, 31, 157, 31, 31, 165, 32, 32, 172, 32, 32, 2, 32, 32, 1, 32, 32, 165, 32, 42, 172, 32, 24, 78, 33, 33, 90, 33, 33, 78, 33, 79, 86, 34, 34, 156, 34, 34, 152, 34, 34, 86, 34, 3, 156, 34, 45, 165, 35, 35, 172, 35, 35, 2, 35, 35, 1, 35, 35, 165, 35, 70, 172, 35, 1, 65, 36, 36, 157, 36, 36, 79, 37, 37, 164, 37, 37, 85, 37, 37, 83, 37, 37, 79, 37, 29, 164, 37, 16, 157, 38, 38, 65, 38, 38, 157, 38, 85, 157, 39, 39, 65, 39, 39, 157, 39, 84, 165, 40, 40, 172, 40, 40, 2, 40, 40, 1, 40, 40, 165, 40, 53, 172, 40, 49, 70, 41, 41, 170, 41, 41, 147, 41, 41, 171, 41, 41, 170, 41, 41, 70, 41, 49, 170, 41, 88, 147, 41, 89, 79, 42, 42, 164, 42, 42, 85, 42, 42, 83, 42, 42, 79, 42, 32, 164, 42, 30, 65, 43, 43, 157, 43, 43, 65, 44, 44, 157, 44, 44, 65, 44, 81, 70, 45, 45, 170, 45, 45, 147, 45, 45, 171, 45, 45, 170, 45, 45, 70, 45, 34, 170, 45, 90, 147, 45, 91, 165, 46, 46, 172, 46, 46, 2, 46, 46, 1, 46, 46, 165, 46, 79, 172, 46, 5, 78, 47, 47, 90, 47, 47, 78, 47, 19, 79, 48, 48, 164, 48, 48, 85, 48, 48, 83, 48, 48, 79, 48, 15, 164, 48, 28, 86, 49, 49, 156, 49, 49, 152, 49, 49, 86, 49, 40, 156, 49, 41, 79, 50, 50, 164, 50, 50, 85, 50, 50, 83, 50, 50, 79, 50, 21, 164, 50, 6, 165, 51, 51, 172, 51, 51, 2, 51, 51, 1, 51, 51, 165, 51, 19, 172, 51, 2, 165, 52, 52, 172, 52, 52, 2, 52, 52, 1, 52, 52, 165, 52, 17, 172, 52, 54, 79, 53, 53, 164, 53, 53, 85, 53, 53, 83, 53, 53, 79, 53, 40, 164, 53, 63, 86, 54, 54, 156, 54, 54, 152, 54, 54, 86, 54, 52, 156, 54, 80, 79, 55, 55, 164, 55, 55, 85, 55, 55, 83, 55, 55, 79, 55, 25, 164, 55, 75, 157, 56, 56, 65, 56, 56, 157, 56, 86, 157, 57, 57, 65, 57, 57, 157, 57, 87, 70, 58, 58, 170, 58, 58, 147, 58, 58, 171, 58, 58, 170, 58, 58, 70, 58, 2, 170, 58, 92, 147, 58, 93, 165, 59, 59, 172, 59, 59, 2, 59, 59, 1, 59, 59, 165, 59, 23, 172, 59, 60, 86, 60, 60, 152, 60, 60, 156, 60, 60, 86, 60, 59, 86, 61, 61, 152, 61, 61, 156, 61, 61, 86, 61, 10, 65, 62, 62, 157, 62, 62, 78, 63, 63, 90, 63, 63, 78, 63, 53, 78, 64, 64, 90, 64, 64, 78, 64, 8, 86, 65, 65, 156, 65, 65, 152, 65, 65, 86, 65, 25, 156, 65, 77, 78, 66, 66, 90, 66, 66, 78, 66, 69, 65, 67, 67, 157, 67, 67, 165, 68, 68, 172, 68, 68, 2, 68, 68, 1, 68, 68, 165, 68, 69, 172, 68, 22, 79, 69, 69, 164, 69, 69, 85, 69, 69, 83, 69, 69, 79, 69, 68, 164, 69, 66, 79, 70, 70, 164, 70, 70, 85, 70, 70, 83, 70, 70, 79, 70, 35, 164, 70, 7, 3, 71, 71, 154, 71, 71, 155, 71, 71, 3, 71, 83, 154, 71, 94, 155, 71, 94, 65, 72, 72, 157, 72, 72, 165, 73, 73, 172, 73, 73, 2, 73, 73, 1, 73, 73, 165, 73, 14, 172, 73, 11, 86, 74, 74, 152, 74, 74, 156, 74, 74, 86, 74, 15, 78, 75, 75, 90, 75, 75, 78, 75, 55, 78, 76, 76, 90, 76, 76, 78, 76, 14, 70, 77, 77, 170, 77, 77, 147, 77, 77, 171, 77, 77, 170, 77, 77, 70, 77, 65, 170, 77, 95, 147, 77, 96, 78, 78, 78, 90, 78, 78, 78, 78, 23, 79, 79, 79, 164, 79, 79, 85, 79, 79, 83, 79, 79, 79, 79, 46, 164, 79, 33, 70, 80, 80, 170, 80, 80, 147, 80, 80, 171, 80, 80, 170, 80, 80, 70, 80, 54, 170, 80, 97, 147, 80, 98, 73, 81, 81, 151, 81, 81, 103, 81, 81, 81, 81, 81, 73, 81, 94, 151, 81, 44, 103, 81, 99, 83, 82, 82, 171, 82, 82, 100, 82, 82, 83, 82, 90, 171, 82, 8, 100, 82, 100, 71, 83, 83, 89, 83, 83, 94, 83, 83, 71, 83, 26, 89, 83, 71, 94, 83, 101, 71, 84, 84, 94, 84, 84, 89, 84, 84, 71, 84, 39, 94, 84, 102, 71, 85, 85, 94, 85, 85, 89, 85, 85, 71, 85, 38, 94, 85, 103, 71, 86, 86, 94, 86, 86, 89, 86, 86, 71, 86, 56, 94, 86, 104, 71, 87, 87, 94, 87, 87, 89, 87, 87, 71, 87, 57, 94, 87, 105, 84, 88, 88, 169, 88, 88, 84, 88, 41, 61, 89, 89, 148, 89, 89, 128, 89, 89, 61, 89, 41, 148, 89, 106, 128, 89, 107, 84, 90, 90, 169, 90, 90, 84, 90, 45, 169, 90, 82, 61, 91, 91, 148, 91, 91, 128, 91, 91, 61, 91, 45, 148, 91, 108, 128, 91, 109, 84, 92, 92, 169, 92, 92, 84, 92, 58, 61, 93, 93, 148, 93, 93, 128, 93, 93, 61, 93, 58, 148, 93, 110, 128, 93, 111, 69, 94, 94, 68, 94, 94, 159, 94, 94, 158, 94, 94, 69, 94, 71, 68, 94, 71, 159, 94, 81, 84, 95, 95, 169, 95, 95, 84, 95, 77, 61, 96, 96, 148, 96, 96, 128, 96, 96, 61, 96, 77, 148, 96, 112, 128, 96, 113, 84, 97, 97, 169, 97, 97, 84, 97, 80, 61, 98, 98, 148, 98, 98, 128, 98, 98, 61, 98, 80, 148, 98, 114, 128, 98, 115, 17, 99, 99, 109, 99, 99, 112, 99, 99, 116, 99, 99, 114, 99, 99, 104, 99, 99, 110, 99, 99, 17, 99, 81, 109, 99, 116, 112, 99, 117, 116, 99, 118, 114, 99, 119, 104, 99, 120, 14, 100, 100, 119, 100, 100, 14, 100, 82, 119, 100, 121, 8, 101, 101, 95, 101, 101, 8, 101, 83, 95, 101, 122, 8, 102, 102, 95, 102, 102, 8, 102, 84, 95, 102, 123, 8, 103, 103, 95, 103, 103, 8, 103, 85, 95, 103, 124, 8, 104, 104, 95, 104, 104, 8, 104, 86, 95, 104, 125, 8, 105, 105, 95, 105, 105, 8, 105, 87, 95, 105, 126, 62, 106, 106, 62, 106, 89, 42, 107, 107, 42, 107, 89, 62, 108, 108, 62, 108, 91, 42, 109, 109, 42, 109, 91, 62, 110, 110, 62, 110, 93, 42, 111, 111, 42, 111, 93, 62, 112, 112, 62, 112, 96, 42, 113, 113, 42, 113, 96, 62, 114, 114, 62, 114, 98, 42, 115, 115, 42, 115, 98, 23, 116, 116, 24, 116, 116, 23, 116, 99, 26, 117, 117, 106, 117, 117, 26, 117, 99, 106, 117, 127, 30, 118, 118, 30, 118, 99, 28, 119, 119, 28, 119, 99, 18, 120, 120, 18, 120, 99, 33, 121, 121, 120, 121, 121, 33, 121, 100, 120, 121, 128, 9, 122, 122, 98, 122, 122, 9, 122, 101, 98, 122, 129, 9, 123, 123, 98, 123, 123, 9, 123, 102, 98, 123, 130, 9, 124, 124, 98, 124, 124, 9, 124, 103, 98, 124, 131, 9, 125, 125, 98, 125, 125, 9, 125, 104, 98, 125, 132, 9, 126, 126, 98, 126, 126, 9, 126, 105, 98, 126, 133, 20, 127, 127, 20, 127, 117, 34, 128, 128, 123, 128, 128, 126, 128, 128, 128, 128, 128, 122, 128, 128, 125, 128, 128, 34, 128, 121, 123, 128, 134, 126, 128, 135, 128, 128, 136, 122, 128, 137, 125, 128, 138, 12, 129, 129, 12, 129, 122, 12, 130, 130, 12, 130, 123, 12, 131, 131, 12, 131, 124, 12, 132, 132, 12, 132, 125, 12, 133, 133, 12, 133, 126, 37, 134, 134, 36, 134, 134, 37, 134, 128, 36, 134, 139, 40, 135, 135, 39, 135, 135, 40, 135, 128, 39, 135, 139, 42, 136, 136, 42, 136, 128, 37, 137, 137, 36, 137, 137, 37, 137, 139, 36, 137, 128, 40, 138, 138, 39, 138, 138, 40, 138, 139, 39, 138, 128, 34, 139, 139, 123, 139, 139, 126, 139, 139, 128, 139, 139, 122, 139, 139, 125, 139, 139, 34, 139, 140, 123, 139, 137, 126, 139, 138, 128, 139, 141, 122, 139, 134, 125, 139, 135, 120, 140, 140, 33, 140, 140, 120, 140, 139, 42, 141, 141, 42, 141, 139)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(90, 1, 457, 457, 152, 2, 465, 461, 156, 2, 173, 813, 152, 3, 176, 834, 2, 4, 16, 1, 1, 4, 17, 1, 85, 5, 389, 466, 83, 5, 457, 462, 152, 6, 465, 457, 156, 6, 173, 820, 90, 7, 458, 458, 90, 8, 458, 461, 83, 9, 834, 177, 152, 10, 178, 834, 156, 10, 173, 804, 2, 11, 18, 1, 1, 11, 19, 1, 152, 12, 835, 179, 156, 12, 173, 796, 152, 13, 465, 458, 156, 13, 173, 824, 65, 14, 456, 467, 157, 14, 845, 173, 85, 15, 389, 468, 83, 15, 179, 836, 2, 16, 20, 1, 1, 16, 21, 1, 90, 17, 180, 834, 85, 18, 156, 837, 83, 18, 457, 463, 90, 19, 461, 457, 85, 20, 156, 842, 83, 20, 834, 181, 65, 21, 174, 839, 157, 21, 846, 173, 2, 22, 22, 1, 1, 22, 23, 1, 152, 23, 835, 180, 156, 23, 173, 822, 85, 24, 389, 469, 83, 24, 461, 462, 152, 25, 835, 182, 156, 25, 173, 806, 2, 26, 24, 1, 1, 26, 25, 1, 65, 27, 456, 470, 65, 28, 175, 839, 157, 28, 847, 173, 90, 29, 457, 458, 2, 30, 26, 1, 1, 30, 27, 1, 90, 31, 834, 182, 65, 32, 456, 471, 157, 32, 848, 173, 2, 33, 28, 1, 1, 33, 29, 1, 90, 34, 458, 457, 152, 35, 183, 834, 2, 36, 30, 1, 1, 36, 31, 1, 65, 37, 175, 841, 157, 37, 849, 173, 85, 38, 137, 842, 83, 38, 834, 184, 65, 39, 456, 472, 65, 40, 456, 473, 2, 41, 32, 1, 1, 41, 33, 1, 171, 42, 461, 392, 170, 42, 461, 462, 85, 43, 389, 474, 83, 43, 182, 836, 65, 44, 174, 838, 157, 44, 850, 173, 157, 45, 851, 173, 171, 46, 834, 148, 170, 46, 834, 181, 2, 47, 34, 1, 1, 47, 35, 1, 90, 48, 179, 834, 85, 49, 389, 475, 83, 49, 458, 462, 152, 50, 460, 461, 85, 51, 137, 844, 83, 51, 458, 459, 2, 52, 36, 1, 1, 52, 37, 1, 2, 53, 38, 1, 1, 53, 39, 1, 85, 54, 156, 843, 83, 54, 461, 463, 152, 55, 460, 457, 85, 56, 156, 844, 83, 56, 458, 463, 65, 57, 174, 840, 65, 58, 175, 840, 171, 59, 834, 155, 170, 59, 834, 184, 2, 60, 40, 1, 1, 60, 41, 1, 152, 61, 464, 461, 156, 61, 173, 743, 152, 62, 464, 457, 156, 62, 173, 790, 65, 63, 456, 476, 157, 63, 852, 173, 90, 64, 461, 461, 90, 65, 182, 834, 152, 66, 460, 458, 90, 67, 834, 180, 65, 68, 174, 841, 157, 68, 853, 173, 2, 69, 42, 1, 1, 69, 43, 1, 85, 70, 389, 477, 83, 70, 180, 836, 85, 71, 137, 843, 83, 71, 461, 459, 65, 73, 175, 838, 157, 73, 854, 173, 2, 74, 44, 1, 1, 74, 45, 1, 152, 75, 464, 458, 156, 75, 173, 792, 90, 76, 461, 458, 90, 77, 834, 179, 171, 78, 458, 392, 170, 78, 458, 462, 90, 79, 457, 461, 85, 80, 137, 837, 83, 80, 457, 459, 171, 81, 457, 392, 170, 81, 457, 462, 81, 82, 816, 173, 89, 85, 828, 173, 89, 86, 786, 173, 89, 87, 829, 173, 89, 88, 825, 173, 169, 89, 843, 168, 169, 93, 842, 168, 158, 95, 835, 173, 169, 96, 844, 168, 169, 98, 837, 168, 110, 100, 855, 173, 24, 117, 185, 856, 33, 141, 186, 857)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 5: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=5
nb_c=39
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=1025 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(165, 0, 0, 172, 0, 0, 2, 0, 0, 1, 0, 0, 165, 0, 21, 172, 0, 29, 79, 1, 1, 164, 1, 1, 85, 1, 1, 83, 1, 1, 79, 1, 27, 164, 1, 5, 78, 2, 2, 90, 2, 2, 78, 2, 6, 65, 3, 3, 157, 3, 3, 65, 4, 4, 157, 4, 4, 78, 5, 5, 90, 5, 5, 78, 5, 1, 79, 6, 6, 164, 6, 6, 85, 6, 6, 83, 6, 6, 79, 6, 16, 164, 6, 2, 86, 7, 7, 156, 7, 7, 152, 7, 7, 86, 7, 11, 156, 7, 25, 157, 8, 8, 65, 8, 8, 157, 8, 31, 65, 9, 9, 157, 9, 9, 165, 10, 10, 172, 10, 10, 2, 10, 10, 1, 10, 10, 165, 10, 26, 172, 10, 20, 165, 11, 11, 172, 11, 11, 2, 11, 11, 1, 11, 11, 165, 11, 19, 172, 11, 7, 78, 12, 12, 90, 12, 12, 78, 12, 19, 65, 13, 13, 157, 13, 13, 78, 14, 14, 90, 14, 14, 78, 14, 26, 78, 15, 15, 90, 15, 15, 78, 15, 21, 165, 16, 16, 172, 16, 16, 2, 16, 16, 1, 16, 16, 165, 16, 6, 172, 16, 24, 86, 17, 17, 152, 17, 17, 156, 17, 17, 86, 17, 27, 79, 18, 18, 164, 18, 18, 85, 18, 18, 83, 18, 18, 79, 18, 30, 164, 18, 28, 79, 19, 19, 164, 19, 19, 85, 19, 19, 83, 19, 19, 79, 19, 11, 164, 19, 12, 86, 20, 20, 152, 20, 20, 156, 20, 20, 86, 20, 10, 79, 21, 21, 164, 21, 21, 85, 21, 21, 83, 21, 21, 79, 21, 0, 164, 21, 15, 65, 22, 22, 157, 22, 22, 86, 23, 23, 152, 23, 23, 156, 23, 23, 86, 23, 30, 86, 24, 24, 152, 24, 24, 156, 24, 24, 86, 24, 16, 70, 25, 25, 170, 25, 25, 147, 25, 25, 171, 25, 25, 170, 25, 25, 70, 25, 7, 170, 25, 32, 147, 25, 33, 79, 26, 26, 164, 26, 26, 85, 26, 26, 83, 26, 26, 79, 26, 10, 164, 26, 14, 165, 27, 27, 172, 27, 27, 2, 27, 27, 1, 27, 27, 165, 27, 1, 172, 27, 17, 78, 28, 28, 90, 28, 28, 78, 28, 18, 86, 29, 29, 152, 29, 29, 156, 29, 29, 86, 29, 0, 165, 30, 30, 172, 30, 30, 2, 30, 30, 1, 30, 30, 165, 30, 18, 172, 30, 23, 71, 31, 31, 94, 31, 31, 89, 31, 31, 71, 31, 8, 94, 31, 34, 84, 32, 32, 169, 32, 32, 84, 32, 25, 61, 33, 33, 148, 33, 33, 128, 33, 33, 61, 33, 25, 148, 33, 35, 128, 33, 36, 8, 34, 34, 95, 34, 34, 8, 34, 31, 95, 34, 37, 62, 35, 35, 62, 35, 33, 42, 36, 36, 42, 36, 33, 9, 37, 37, 98, 37, 37, 9, 37, 34, 98, 37, 38, 12, 38, 38, 12, 38, 37)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(2, 1, 4, 1, 1, 1, 5, 1, 85, 2, 389, 837, 83, 2, 457, 836, 90, 3, 458, 834, 65, 4, 456, 838, 157, 4, 1094, 173, 65, 5, 456, 839, 157, 5, 1095, 173, 90, 6, 834, 457, 85, 7, 137, 1093, 83, 7, 834, 459, 152, 8, 460, 834, 65, 9, 456, 840, 65, 10, 456, 841, 157, 10, 1096, 173, 2, 11, 6, 1, 1, 11, 7, 1, 2, 12, 8, 1, 1, 12, 9, 1, 90, 13, 461, 834, 65, 14, 174, 1092, 157, 14, 1097, 173, 90, 15, 834, 458, 90, 16, 834, 461, 2, 17, 10, 1, 1, 17, 11, 1, 152, 18, 835, 457, 156, 18, 173, 1091, 85, 19, 389, 842, 83, 19, 834, 462, 85, 20, 156, 1093, 83, 20, 834, 463, 152, 21, 835, 458, 156, 21, 173, 1088, 85, 22, 389, 843, 83, 22, 461, 836, 65, 23, 175, 1092, 157, 23, 1098, 173, 152, 24, 464, 834, 156, 24, 173, 1069, 152, 25, 465, 834, 156, 25, 173, 1056, 171, 26, 834, 392, 170, 26, 834, 462, 85, 27, 389, 844, 83, 27, 458, 836, 2, 28, 12, 1, 1, 28, 13, 1, 90, 29, 457, 834, 152, 30, 835, 461, 156, 30, 173, 1052, 2, 31, 14, 1, 1, 31, 15, 1, 89, 32, 1082, 173, 169, 33, 1093, 168)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

if (TIMEIT) {
   cat("weight 6: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
w=6
nb_c=5
ba_x=127; # base of cumomer indexes in incu vector
l=new.env()
l$w=w
l$nb_c=nb_c
l$nb_fwrv=nb_fwrv
l$nb_cl=1064 # number of lighter cumomers
maxprod=2
if (nb_c > 0) {
   # matrix a
   ind_a=matrix(as.integer(c(65, 0, 0, 157, 0, 0, 78, 1, 1, 90, 1, 1, 78, 1, 4, 165, 2, 2, 172, 2, 2, 2, 2, 2, 1, 2, 2, 165, 2, 4, 172, 2, 3, 86, 3, 3, 152, 3, 3, 156, 3, 3, 86, 3, 2, 79, 4, 4, 164, 4, 4, 85, 4, 4, 83, 4, 4, 79, 4, 2, 164, 4, 1)), ncol=3, byrow=T)
   colnames(ind_a)=c("indf", "ir0", "ic0")
   l$ind_a=ind_a
   
   # vector b
   ind_b=matrix(as.integer(c(65, 1, 456, 1092, 157, 1, 1184, 173, 90, 2, 834, 834, 2, 3, 2, 1, 1, 3, 3, 1, 152, 4, 835, 834, 156, 4, 173, 1178, 85, 5, 389, 1093, 83, 5, 834, 836)), ncol=2+2, byrow=T)
   colnames(ind_b)=c("indf", "irow", paste("indx", seq_len(2), sep=""))
   l$ind_b=ind_b
   
   # jacobian b_x
   imaxprod=seq_len(maxprod)
   ind_bx=c()
   for (ix in imaxprod) {
      i=ind_b[,2+ix]>ba_x # exclude from differentiation plain input entries
      tmp=ind_b[i,,drop=FALSE]
      ind_bx=rbind(ind_bx, tmp[,c(1,2,ix+2,2+imaxprod[-ix])]) # move diff var to ic1 place
   }
   if (length(ind_bx)) {
      colnames(ind_bx)=c("indf", "irow", "ic1", sprintf("indx%d", seq_len(maxprod-1)))
      ind_bx[,"ic1"]=ind_bx[,"ic1"]-ba_x
   }
   l$ind_bx=ind_bx
}
spAbr[[w]]=l

# weight count
nb_rw=6
# cumomer count by weight
nb_rcumos=c(231, 359, 293, 142, 39, 5)
nbc_cumos=c(0, cumsum(nb_rcumos))
# cumo names
nm_rcumo=c("FruBP:8", "PGA:1", "Gnt6P:32", "Glc6P:2", "Fru6P:4", "ICit:8", "FruBP:4", "ICit:4", "Rib5P:1", "Rib5P:16", "ICit:32", "Suc:4", "Suc:1", "PEP:1", "PEP:4", "FruBP:2", "Glc6P:8", "PGA:4", "Gnt6P:2", "Glc6P:32", "Fru6P:16", "Suc:2", "ICit:1", "Fru6P:1", "ICit:16", "PGA:2", "ICit:2", "Fru6P:32", "Rib5P:8", "FruBP:32", "Rib5P:2", "Gnt6P:16", "FruBP:1", "Glc6P:4", "Gnt6P:4", "Glc6P:16", "Fru6P:2", "Gnt6P:8", "Glc6P:1", "Rib5P:4", "Fru6P:8", "Gnt6P:1", "PEP:2", "Suc:8", "FruBP:16", "CO2:1", "AcCoA:2", "AcCoA:1", "Pyr:2", "Sed7P:16", "Pyr:4", "GA3P:2", "GA3P:1", "Sed7P:32", "GA3P:4", "Pyr:1", "Sed7P:64", "BM_OAA:1", "BM_PEP:1", "Ery4P:2", "Ery4P:1", "OAA:4", "OAA:1", "Ery4P:8", "OAA:8", "Ery4P:4", "OAA:2", "FTHF:1", "PyrCO2:1", "AKG:2", "AKG:4", "AKG:16", "AKG:8", "AKG:1", "BM_Pyr:1", "BM_Pyr:2", "Lys:2", "AKV:2", "Ile:1", "Lys:1", "AKV:4", "Ile:8", "Lys:4", "Leu:1", "Leu:8", "Gly:2", "Gly:1", "BM_Pyr:4", "BM_PEP:2", "BM_Ery4P:1", "Phe:32", "Tyr:32", "Trp:16", "Phe:1", "Tyr:1", "Trp:8", "Phe:16", "Tyr:16", "BM_Ery4P:8", "BM_Ery4P:4", "BM_Ery4P:2", "BM_PGA:1", "Sed7P:1", "BM_Rib5P:1", "BM_Rib5P:16", "Mal:4", "Mal:2", "Mal:1", "Mal:8", "BM_PEP:4", "BM_PGA:4", "BM_PGA:2", "Sed7P:8", "BM_Rib5P:8", "Sed7P:2", "BM_Rib5P:2", "Sed7P:4", "BM_Rib5P:4", "Chor:64", "BM_OAA:8", "AKV:16", "Arg:1", "BM_AcCoA:2", "BM_AcCoA:1", "PyrCO2:4", "PyrCO2:8", "PyrCO2:2", "Thr:1", "Asn:1", "Met:2", "Asp:1", "DAHP:16", "Chor:128", "BM_OAA:4", "BM_OAA:2", "Ser:1", "His:1", "Met:1", "BM_AKG:2", "BM_AKG:4", "BM_AKG:16", "BM_AKG:8", "BM_AKG:1", "Lys:8", "AKV:1", "Ala:1", "Lys:16", "AKV:8", "Ala:2", "Leu:2", "Val:2", "Leu:4", "Val:4", "Ser:4", "Ser:2", "Lys:32", "Ala:4", "DAHP:32", "Chor:256", "DAHP:1", "Chor:32", "Chor:16", "Chor:1", "DAHP:8", "DAHP:4", "DAHP:2", "His:32", "Trp:1024", "His:2", "Trp:64", "DAHP:64", "Chor:512", "His:4", "Trp:128", "His:16", "Trp:512", "His:8", "Trp:256", "Thr:8", "Asn:8", "Met:16", "Asp:8", "Val:16", "Leu:32", "Leu:16", "Ile:2", "Phe:64", "Tyr:64", "Thr:4", "Asn:4", "Met:8", "Asp:4", "Thr:2", "Asn:2", "Met:4", "Asp:2", "Cys:1", "Glu:2", "Glu:4", "Glu:16", "Glu:8", "Glu:1", "Val:1", "Val:8", "Cys:4", "Cys:2", "Phe:128", "Tyr:128", "Trp:32", "Chor:8", "Chor:4", "Chor:2", "Phe:256", "Tyr:256", "Ile:32", "Ile:16", "Ile:4", "Arg:4", "Arg:8", "Arg:32", "Arg:16", "Arg:2", "Phe:2", "Tyr:2", "Trp:4", "Phe:8", "Tyr:8", "Phe:4", "Tyr:4", "Trp:2", "Trp:1", "ICit:40", "Gnt6P:5", "FruBP:33", "FruBP:3", "Suc:3", "Fru6P:6", "Gnt6P:36", "FruBP:6", "Glc6P:6", "PEP:3", "Rib5P:20", "Fru6P:20", "FruBP:20", "Fru6P:3", "Rib5P:17", "Gnt6P:34", "ICit:18", "FruBP:36", "Gnt6P:20", "Rib5P:9", "Glc6P:24", "FruBP:34", "PEP:6", "ICit:6", "ICit:10", "PGA:6", "Gnt6P:48", "Fru6P:33", "Gnt6P:3", "ICit:48", "Rib5P:24", "ICit:17", "ICit:33", "Fru6P:48", "Glc6P:34", "Suc:9", "Gnt6P:33", "Rib5P:5", "Gnt6P:17", "ICit:12", "Fru6P:40", "Glc6P:36", "Suc:5", "PGA:5", "Suc:10", "Glc6P:33", "ICit:9", "Gnt6P:9", "Glc6P:12", "Glc6P:48", "ICit:3", "Rib5P:6", "Gnt6P:40", "FruBP:5", "ICit:36", "Fru6P:9", "Suc:12", "Fru6P:5", "Rib5P:18", "ICit:20", "Glc6P:5", "Rib5P:10", "PEP:5", "ICit:24", "PGA:3", "Glc6P:18", "Glc6P:17", "Gnt6P:6", "ICit:5", "FruBP:18", "Glc6P:20", "FruBP:10", "Gnt6P:12", "FruBP:17", "Rib5P:3", "Fru6P:24", "Fru6P:17", "Fru6P:34", "Fru6P:12", "Glc6P:10", "Fru6P:18", "FruBP:12", "Glc6P:3", "Gnt6P:10", "Glc6P:9", "Suc:6", "Gnt6P:18", "FruBP:9", "FruBP:24", "Fru6P:10", "Glc6P:40", "Gnt6P:24", "ICit:34", "Rib5P:12", "Fru6P:36", "FruBP:48", "FruBP:40", "AcCoA:3", "GA3P:3", "GA3P:5", "Sed7P:80", "Pyr:3", "GA3P:6", "Sed7P:96", "Sed7P:48", "Pyr:6", "Pyr:5", "Ery4P:3", "OAA:12", "Ery4P:10", "Ery4P:6", "OAA:6", "OAA:10", "OAA:5", "OAA:3", "Ery4P:12", "Ery4P:5", "OAA:9", "Ery4P:9", "AKG:24", "AKG:10", "AKG:18", "AKG:6", "AKG:5", "AKG:9", "AKG:12", "AKG:3", "AKG:17", "AKG:20", "BM_Pyr:3", "Lys:3", "AKV:6", "Ile:9", "Lys:6", "Lys:5", "Leu:9", "Gly:3", "BM_Pyr:5", "BM_Pyr:6", "Phe:33", "Tyr:33", "Trp:24", "Phe:48", "Tyr:48", "BM_Ery4P:10", "BM_Ery4P:12", "BM_Ery4P:6", "Mal:3", "Mal:12", "BM_PEP:3", "Sed7P:20", "BM_Rib5P:20", "Sed7P:17", "BM_Rib5P:17", "Sed7P:9", "BM_Rib5P:9", "BM_PEP:6", "BM_PGA:6", "Sed7P:24", "BM_Rib5P:24", "Mal:9", "Sed7P:5", "BM_Rib5P:5", "Mal:5", "Mal:10", "BM_PGA:5", "Sed7P:6", "BM_Rib5P:6", "Sed7P:18", "BM_Rib5P:18", "Sed7P:10", "BM_Rib5P:10", "BM_PEP:5", "BM_PGA:3", "Sed7P:3", "BM_Rib5P:3", "Mal:6", "Sed7P:12", "BM_Rib5P:12", "BM_AcCoA:3", "PyrCO2:6", "PyrCO2:12", "PyrCO2:10", "BM_Ery4P:3", "BM_OAA:12", "BM_OAA:6", "BM_OAA:10", "BM_OAA:5", "BM_OAA:3", "BM_Ery4P:5", "BM_OAA:9", "BM_Ery4P:9", "BM_AKG:24", "BM_AKG:10", "BM_AKG:18", "BM_AKG:6", "BM_AKG:5", "BM_AKG:9", "BM_AKG:12", "BM_AKG:3", "BM_AKG:17", "BM_AKG:20", "Lys:24", "AKV:9", "Ala:3", "Leu:6", "Val:6", "Ser:6", "Lys:40", "AKV:17", "Ala:5", "Lys:48", "AKV:24", "Ala:6", "Chor:48", "Chor:33", "DAHP:10", "DAHP:12", "DAHP:6", "DAHP:48", "Chor:384", "His:10", "Trp:320", "His:34", "Trp:1088", "His:36", "Trp:1152", "DAHP:96", "Chor:768", "His:6", "Trp:192", "His:40", "Trp:1280", "Ser:5", "His:24", "Trp:768", "His:18", "Trp:576", "His:20", "Trp:640", "DAHP:80", "Chor:640", "Ser:3", "His:48", "Trp:1536", "His:12", "Trp:384", "Leu:48", "DAHP:3", "Thr:12", "Asn:12", "Met:24", "Asp:12", "Thr:6", "Asn:6", "Met:12", "Asp:6", "Thr:10", "Asn:10", "Met:20", "Asp:10", "Lys:20", "Thr:5", "Asn:5", "Met:10", "Asp:5", "Lys:12", "Thr:3", "Asn:3", "Met:6", "Asp:3", "DAHP:5", "Lys:36", "Thr:9", "Asn:9", "Met:18", "Asp:9", "DAHP:9", "Glu:24", "Glu:10", "Glu:18", "Glu:6", "Glu:5", "Glu:9", "Glu:12", "Glu:3", "Glu:17", "Glu:20", "Val:9", "Cys:6", "Val:17", "Val:24", "DAHP:33", "Trp:48", "Chor:10", "Chor:12", "Chor:6", "Phe:192", "Tyr:192", "Chor:96", "Phe:384", "Tyr:384", "Cys:5", "Chor:80", "Phe:320", "Tyr:320", "Cys:3", "Chor:3", "Ile:48", "Ile:20", "Ile:36", "Ile:18", "Ile:6", "Chor:5", "Ile:34", "Chor:9", "Arg:48", "Arg:20", "Arg:36", "Arg:12", "Arg:10", "Arg:18", "Arg:24", "Arg:6", "Arg:34", "Arg:40", "Phe:10", "Tyr:10", "Trp:5", "Phe:6", "Tyr:6", "Trp:6", "Phe:12", "Tyr:12", "Trp:3", "Phe:24", "Tyr:24", "Trp:33", "Phe:3", "Tyr:3", "Phe:20", "Tyr:20", "Trp:34", "Phe:5", "Tyr:5", "Phe:18", "Tyr:18", "Trp:36", "Phe:9", "Tyr:9", "Chor:24", "Chor:20", "Chor:18", "DAHP:24", "Trp:12", "DAHP:20", "Trp:10", "DAHP:18", "Trp:9", "ICit:25", "Gnt6P:11", "Fru6P:11", "Fru6P:50", "Fru6P:38", "Gnt6P:44", "Gnt6P:41", "FruBP:56", "FruBP:21", "Glc6P:26", "Glc6P:21", "Gnt6P:13", "FruBP:14", "ICit:52", "Gnt6P:14", "Gnt6P:25", "FruBP:25", "FruBP:52", "FruBP:37", "FruBP:19", "Fru6P:35", "Glc6P:13", "Fru6P:49", "FruBP:28", "Glc6P:56", "Rib5P:22", "FruBP:13", "Fru6P:19", "Glc6P:11", "ICit:56", "Glc6P:28", "Gnt6P:49", "ICit:11", "Fru6P:26", "ICit:22", "Fru6P:22", "Glc6P:37", "FruBP:22", "Glc6P:52", "ICit:49", "Gnt6P:19", "Gnt6P:56", "FruBP:7", "ICit:35", "Glc6P:22", "ICit:38", "Glc6P:42", "Gnt6P:35", "Gnt6P:42", "FruBP:11", "Glc6P:35", "Fru6P:42", "ICit:14", "Glc6P:41", "Gnt6P:50", "Gnt6P:22", "Glc6P:49", "Fru6P:44", "Fru6P:56", "ICit:42", "Glc6P:14", "ICit:13", "Fru6P:13", "PGA:7", "Glc6P:25", "Fru6P:7", "ICit:41", "ICit:21", "Suc:7", "FruBP:42", "FruBP:49", "ICit:28", "Rib5P:19", "FruBP:41", "Rib5P:21", "Gnt6P:37", "ICit:26", "Gnt6P:28", "Rib5P:26", "ICit:7", "Gnt6P:21", "ICit:37", "Glc6P:38", "Fru6P:41", "Fru6P:25", "Gnt6P:38", "Rib5P:7", "FruBP:38", "Rib5P:28", "Glc6P:7", "Gnt6P:26", "ICit:44", "Glc6P:50", "Gnt6P:7", "Fru6P:37", "Rib5P:14", "FruBP:26", "Gnt6P:52", "PEP:7", "Glc6P:44", "FruBP:50", "Fru6P:52", "Rib5P:11", "Glc6P:19", "Rib5P:25", "Fru6P:28", "Rib5P:13", "Suc:14", "ICit:50", "FruBP:44", "Suc:11", "Suc:13", "Fru6P:21", "ICit:19", "FruBP:35", "Fru6P:14", "GA3P:7", "Pyr:7", "Sed7P:112", "Ery4P:11", "OAA:14", "OAA:11", "OAA:7", "OAA:13", "Ery4P:7", "Ery4P:14", "Ery4P:13", "AKG:7", "AKG:25", "AKG:26", "AKG:11", "AKG:22", "AKG:13", "AKG:28", "AKG:19", "AKG:21", "AKG:14", "Lys:7", "BM_Pyr:7", "BM_Ery4P:14", "Sed7P:22", "BM_Rib5P:22", "BM_PGA:7", "Mal:7", "Mal:14", "Sed7P:19", "BM_Rib5P:19", "Sed7P:21", "BM_Rib5P:21", "Sed7P:26", "BM_Rib5P:26", "Sed7P:7", "BM_Rib5P:7", "Sed7P:28", "BM_Rib5P:28", "Sed7P:14", "BM_Rib5P:14", "BM_PEP:7", "Sed7P:11", "BM_Rib5P:11", "Sed7P:25", "BM_Rib5P:25", "Sed7P:13", "BM_Rib5P:13", "Mal:11", "Mal:13", "PyrCO2:14", "BM_Ery4P:11", "BM_OAA:14", "BM_OAA:11", "BM_OAA:7", "BM_OAA:13", "BM_Ery4P:7", "BM_Ery4P:13", "BM_AKG:7", "BM_AKG:25", "BM_AKG:26", "BM_AKG:11", "BM_AKG:22", "BM_AKG:13", "BM_AKG:28", "BM_AKG:19", "BM_AKG:21", "BM_AKG:14", "Lys:56", "AKV:25", "Ala:7", "DAHP:14", "His:26", "Trp:832", "Ser:7", "His:50", "Trp:1600", "His:42", "Trp:1344", "His:22", "Trp:704", "His:56", "Trp:1792", "His:14", "Trp:448", "His:28", "Trp:896", "DAHP:112", "Chor:896", "His:52", "Trp:1664", "His:38", "Trp:1216", "His:44", "Trp:1408", "DAHP:11", "Thr:14", "Asn:14", "Met:28", "Asp:14", "Lys:44", "Thr:11", "Asn:11", "Met:22", "Asp:11", "Lys:28", "Thr:7", "Asn:7", "Met:14", "Asp:7", "Lys:52", "Thr:13", "Asn:13", "Met:26", "Asp:13", "DAHP:7", "DAHP:13", "Glu:7", "Glu:25", "Glu:26", "Glu:11", "Glu:22", "Glu:13", "Glu:28", "Glu:19", "Glu:21", "Glu:14", "Val:25", "Chor:14", "Cys:7", "Chor:112", "Phe:448", "Tyr:448", "Chor:11", "Ile:52", "Ile:38", "Ile:22", "Ile:50", "Chor:7", "Chor:13", "Arg:14", "Arg:50", "Arg:52", "Arg:22", "Arg:44", "Arg:26", "Arg:56", "Arg:38", "Arg:42", "Arg:28", "Phe:14", "Tyr:14", "Trp:7", "Phe:26", "Tyr:26", "Trp:37", "Phe:11", "Tyr:11", "Phe:28", "Tyr:28", "Trp:35", "Phe:7", "Tyr:7", "Phe:22", "Tyr:22", "Trp:38", "Phe:13", "Tyr:13", "Chor:26", "Chor:28", "Chor:22", "DAHP:26", "Trp:13", "DAHP:28", "Trp:14", "DAHP:22", "Trp:11", "FruBP:51", "Gnt6P:46", "Gnt6P:23", "Glc6P:15", "Fru6P:51", "Gnt6P:43", "FruBP:45", "FruBP:46", "Fru6P:15", "Gnt6P:39", "Glc6P:51", "Gnt6P:58", "Gnt6P:45", "ICit:15", "Fru6P:58", "Glc6P:53", "FruBP:39", "Fru6P:27", "FruBP:27", "Fru6P:23", "ICit:53", "Glc6P:45", "Gnt6P:57", "Fru6P:54", "Gnt6P:60", "Glc6P:29", "ICit:27", "ICit:54", "FruBP:53", "Glc6P:39", "FruBP:60", "ICit:23", "Glc6P:60", "FruBP:43", "Gnt6P:15", "Glc6P:46", "ICit:46", "Fru6P:39", "ICit:43", "ICit:51", "Glc6P:30", "Rib5P:30", "Fru6P:60", "ICit:29", "ICit:60", "Rib5P:15", "Glc6P:43", "FruBP:23", "Fru6P:53", "Gnt6P:30", "Fru6P:45", "Glc6P:23", "Glc6P:27", "Fru6P:30", "Gnt6P:27", "Fru6P:29", "ICit:57", "ICit:58", "Rib5P:23", "Glc6P:54", "Gnt6P:54", "Gnt6P:51", "ICit:39", "FruBP:30", "FruBP:15", "Gnt6P:29", "FruBP:57", "ICit:45", "Glc6P:57", "Fru6P:57", "Fru6P:46", "Suc:15", "ICit:30", "Glc6P:58", "Gnt6P:53", "FruBP:29", "FruBP:58", "Rib5P:29", "FruBP:54", "Fru6P:43", "Rib5P:27", "OAA:15", "Ery4P:15", "AKG:15", "AKG:27", "AKG:23", "AKG:29", "AKG:30", "Sed7P:30", "BM_Rib5P:30", "Sed7P:15", "BM_Rib5P:15", "Sed7P:23", "BM_Rib5P:23", "Mal:15", "Sed7P:29", "BM_Rib5P:29", "Sed7P:27", "BM_Rib5P:27", "BM_OAA:15", "BM_Ery4P:15", "BM_AKG:15", "BM_AKG:27", "BM_AKG:23", "BM_AKG:29", "BM_AKG:30", "His:30", "Trp:960", "His:60", "Trp:1920", "His:58", "Trp:1856", "His:46", "Trp:1472", "His:54", "Trp:1728", "Lys:60", "Thr:15", "Asn:15", "Met:30", "Asp:15", "DAHP:15", "Glu:15", "Glu:27", "Glu:23", "Glu:29", "Glu:30", "Ile:54", "Chor:15", "Arg:30", "Arg:54", "Arg:46", "Arg:58", "Arg:60", "Phe:30", "Tyr:30", "Trp:39", "Phe:15", "Tyr:15", "Chor:30", "DAHP:30", "Trp:15", "Glc6P:62", "Fru6P:59", "FruBP:47", "ICit:31", "ICit:55", "FruBP:59", "Fru6P:47", "Gnt6P:31", "ICit:59", "ICit:47", "Glc6P:61", "Glc6P:31", "FruBP:31", "ICit:61", "FruBP:61", "FruBP:62", "Glc6P:47", "Gnt6P:59", "Fru6P:55", "Fru6P:31", "Gnt6P:61", "Fru6P:62", "ICit:62", "Gnt6P:55", "Gnt6P:47", "Rib5P:31", "Fru6P:61", "Glc6P:59", "FruBP:55", "Gnt6P:62", "Glc6P:55", "AKG:31", "Sed7P:31", "BM_Rib5P:31", "BM_AKG:31", "His:62", "Trp:1984", "Glu:31", "Arg:62", "ICit:63", "FruBP:63", "Glc6P:63", "Gnt6P:63", "Fru6P:63")
nm_list$rcumo=nm_rcumo

if (case_i) {
   # check the coherence of metabolites/cumomers
   met_net=unique(matrix(unlist(strsplit(nm_rcumo, ":", fixed=TRUE)), nrow=2)[1,])
   net_pool=sort(setdiff(met_net, names(nm_poolall)))
   if (length(net_pool) > 0) {
      stop_mes("The following metabolites are internal in NETWORK section but not in METABOLITE_POOLS one:\n"%s+%paste(net_pool, collapse="\n"), file=fcerr)
   }
}

nb_exp=1
nm_exp=c("e_coli_i")
nm_list$nm_exp=nm_exp
# input cumomer vectors
xi=c(1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1.0, 1, 0, 1, 0, 1, 0)
if (length(xi)) {
   dim(xi)=c(length(xi)/nb_exp, nb_exp)
} else {
   stop_mes("No reduced label entry is defined (may be because no measurement defined in FTBL). Cannot continue.", file=fcerr)
}
nm_xi=c("Gluc_U:63", "Gluc_1:63", "Gluc_U:62", "Gluc_1:62", "Gluc_U:61", "Gluc_1:61", "Gluc_U:31", "Gluc_1:31", "Gluc_U:47", "Gluc_1:47", "Gluc_U:59", "Gluc_1:59", "Gluc_U:55", "Gluc_1:55", "Gluc_U:15", "Gluc_1:15", "Gluc_U:51", "Gluc_1:51", "Gluc_U:53", "Gluc_1:53", "Gluc_U:45", "Gluc_1:45", "Gluc_U:29", "Gluc_1:29", "Gluc_U:39", "Gluc_1:39", "Gluc_U:60", "Gluc_1:60", "Gluc_U:46", "Gluc_1:46", "Gluc_U:30", "Gluc_1:30", "Gluc_U:43", "Gluc_1:43", "Gluc_U:23", "Gluc_1:23", "Gluc_U:27", "Gluc_1:27", "Gluc_U:54", "Gluc_1:54", "Gluc_U:57", "Gluc_1:57", "Gluc_U:58", "Gluc_1:58", "Gluc_U:26", "Gluc_1:26", "Gluc_U:21", "Gluc_1:21", "Gluc_U:13", "Gluc_1:13", "Gluc_U:56", "Gluc_1:56", "Gluc_U:11", "Gluc_1:11", "Gluc_U:28", "Gluc_1:28", "Gluc_U:37", "Gluc_1:37", "Gluc_U:52", "Gluc_1:52", "Gluc_U:22", "Gluc_1:22", "Gluc_U:42", "Gluc_1:42", "Gluc_U:35", "Gluc_1:35", "Gluc_U:41", "Gluc_1:41", "Gluc_U:49", "Gluc_1:49", "Gluc_U:14", "Gluc_1:14", "Gluc_U:25", "Gluc_1:25", "Gluc_U:38", "Gluc_1:38", "Gluc_U:7", "Gluc_1:7", "Gluc_U:50", "Gluc_1:50", "Gluc_U:44", "Gluc_1:44", "Gluc_U:19", "Gluc_1:19", "Gluc_U:6", "Gluc_1:6", "Gluc_U:24", "Gluc_1:24", "Gluc_U:34", "Gluc_1:34", "Gluc_U:36", "Gluc_1:36", "Gluc_U:33", "Gluc_1:33", "Gluc_U:12", "Gluc_1:12", "Gluc_U:48", "Gluc_1:48", "Gluc_U:5", "Gluc_1:5", "Gluc_U:18", "Gluc_1:18", "Gluc_U:17", "Gluc_1:17", "Gluc_U:20", "Gluc_1:20", "Gluc_U:10", "Gluc_1:10", "Gluc_U:3", "Gluc_1:3", "Gluc_U:9", "Gluc_1:9", "Gluc_U:40", "Gluc_1:40", "Gluc_U:2", "Gluc_1:2", "Gluc_U:8", "Gluc_1:8", "Gluc_U:32", "Gluc_1:32", "Gluc_U:4", "Gluc_1:4", "Gluc_U:16", "Gluc_1:16", "Gluc_U:1", "Gluc_1:1")
dimnames(xi)[[1]]=nm_xi
nm_list$xi=nm_xi
nb_xi=length(nm_xi)
nb_f$xi=nb_xi
nb_cumoi=nb_xi
nm_inp=nm_xi
nm_incu=c("one", nm_xi, nm_rcumo)
nm_inlab=nm_incu
spa=spAbr
nm_x=nm_rcumo
nb_x=nb_rcumos
nb_f$rcumos=nb_rcumos
nb_f$cumoi=nb_cumoi
if (emu) {
   nm_emu=c()
   nb_emus=nb_rcumos*(seq_len(nb_rw)+1)
   nb_f$emus=nb_emus
   nm_list$emu=nm_emu
   nm_x=nm_emu
   nb_x=nb_emus
   xiemu=matrix(c(), ncol=nb_exp)
   nm_xiemu=c()
   nm_list$xiemu=nm_xiemu
   dimnames(xiemu)[[1]]=nm_xiemu
   nb_xiemu=length(nm_xiemu)
   nb_f$xiemu=nb_xiemu
   nb_f$xi=nb_xiemu
   nb_xi=nb_xiemu
   nm_inp=nm_xiemu
   xi=xiemu
   nm_inemu=c("one", nm_xiemu, nm_emu)
   nm_inlab=nm_inemu
   spa=spr2emu(spAbr, nm_incu, nm_inemu, nb_f)
}
# reorder indexes to accelerate sparse matrix construction
spa=sparse2spa(spa)
#browser()
# composite labeling vector incu c(1, xi, xc) names
nm_inlab=c("one", nm_inp, nm_x); # the constant 1 has name "one"
nm_list$x=nm_x
nm_list$inp=nm_inp
nb_f$x=nb_x
nm_cumo=NULL

if (TIMEIT) {
   cat("measure : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
if (!noscale) {
   # make place for scaling factors
   nb_sc=vector("integer", 1)
# experiment: 1

   # mass
   # initial values for scales are set later
   param=c(param,0, 0, 0, 0, 0, 0, 0, 0, 0)
   nm_par=c(nm_par,c("1:mass;Fru6P;111111;689", "1:mass;FruBP;111111;675", "1:mass;Glc6P;111111;682", "1:mass;Gnt6P;111111;702", "1:mass;ICit;111111;660", "1:mass;PEP;111;667", "1:mass;PGA;111;671", "1:mass;Rib5P;11111;696", "1:mass;Suc;1111;651"))
   names(param)=nm_par

   nb_param=length(param)
   nb_sc[1]=nb_param-nb_ff # at this moment it is cumulated sum. diff() is taken later

   # indices mapping from scaling to measure matrix row
   # c(1,par)[ir2isc[[iexp]]] replicates scale parameters
   # for corresponding rows of measure matrix
   ir2isc=vector("list", 1)

   # 1:mass
   ir2isc[[1]]=c(ir2isc[[1]],c(22, 22, 22, 22, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 14, 14, 14, 14, 14, 14, 14, 21, 21, 21, 21, 21, 21, 17, 17, 17, 17, 17, 17, 17))

   # cumulated base for nb_sc
   nb_sc_base=c(0, nb_sc[-nb_exp])
   nb_sc=diff(c(0, nb_sc))
   nb_sc_tot=sum(nb_sc)
   nb_f$nb_sc=nb_sc
   nb_f$nb_sc_tot=nb_sc_tot
   nb_f$nb_sc_base=nb_sc_base
#browser()
} else {
   # no scaling
   ir2isc=list()
   nb_sc=integer(nb_exp)
   nb_sc_tot=0
}
nb_f$nb_sc=nb_sc
nb_f$nb_sc_tot=nb_sc_tot
nm_list$par=nm_par

# make a list of sparse measurement matrices
# measmat*xr+memaone gives a vector of simulated not-yet-pooled and not-yet-scaled measurements
# all but 0. Coefficients of 0-cumomers (by defenition equal to 1)
# are all regrouped in the memaone.
nm_measmat=nm_meas=nb_meas=nb_measmat=measmat=memaone=measvec=measdev=ipooled=vector("list", 1)

nm_measmat[[1]]=c("m:Suc:1,2,3,4:1:651", "m:Suc:1,2,3,4:2:652", "m:Suc:1,2,3,4:3:653", "m:Suc:1,2,3,4:4:654", "m:ICit:1,2,3,4,5,6:0:660", "m:ICit:1,2,3,4,5,6:1:661", "m:ICit:1,2,3,4,5,6:2:662", "m:ICit:1,2,3,4,5,6:3:663", "m:ICit:1,2,3,4,5,6:4:664", "m:ICit:1,2,3,4,5,6:5:665", "m:ICit:1,2,3,4,5,6:6:666", "m:PEP:1,2,3:0:667", "m:PEP:1,2,3:1:668", "m:PEP:1,2,3:2:669", "m:PEP:1,2,3:3:670", "m:PGA:1,2,3:0:671", "m:PGA:1,2,3:1:672", "m:PGA:1,2,3:2:673", "m:PGA:1,2,3:3:674", "m:FruBP:1,2,3,4,5,6:0:675", "m:FruBP:1,2,3,4,5,6:1:676", "m:FruBP:1,2,3,4,5,6:2:677", "m:FruBP:1,2,3,4,5,6:3:678", "m:FruBP:1,2,3,4,5,6:4:679", "m:FruBP:1,2,3,4,5,6:5:680", "m:FruBP:1,2,3,4,5,6:6:681", "m:Glc6P:1,2,3,4,5,6:0:682", "m:Glc6P:1,2,3,4,5,6:1:683", "m:Glc6P:1,2,3,4,5,6:2:684", "m:Glc6P:1,2,3,4,5,6:3:685", "m:Glc6P:1,2,3,4,5,6:4:686", "m:Glc6P:1,2,3,4,5,6:5:687", "m:Glc6P:1,2,3,4,5,6:6:688", "m:Fru6P:1,2,3,4,5,6:0:689", "m:Fru6P:1,2,3,4,5,6:1:690", "m:Fru6P:1,2,3,4,5,6:2:691", "m:Fru6P:1,2,3,4,5,6:3:692", "m:Fru6P:1,2,3,4,5,6:4:693", "m:Fru6P:1,2,3,4,5,6:5:694", "m:Fru6P:1,2,3,4,5,6:6:695", "m:Rib5P:1,2,3,4,5:0:696", "m:Rib5P:1,2,3,4,5:1:697", "m:Rib5P:1,2,3,4,5:2:698", "m:Rib5P:1,2,3,4,5:3:699", "m:Rib5P:1,2,3,4,5:4:700", "m:Rib5P:1,2,3,4,5:5:701", "m:Gnt6P:1,2,3,4,5,6:0:702", "m:Gnt6P:1,2,3,4,5,6:1:703", "m:Gnt6P:1,2,3,4,5,6:2:704", "m:Gnt6P:1,2,3,4,5,6:3:705", "m:Gnt6P:1,2,3,4,5,6:4:706", "m:Gnt6P:1,2,3,4,5,6:5:707", "m:Gnt6P:1,2,3,4,5,6:6:708")
nm_meas[[1]]=c("m:Suc:1,2,3,4:1:651", "m:Suc:1,2,3,4:2:652", "m:Suc:1,2,3,4:3:653", "m:Suc:1,2,3,4:4:654", "m:ICit:1,2,3,4,5,6:0:660", "m:ICit:1,2,3,4,5,6:1:661", "m:ICit:1,2,3,4,5,6:2:662", "m:ICit:1,2,3,4,5,6:3:663", "m:ICit:1,2,3,4,5,6:4:664", "m:ICit:1,2,3,4,5,6:5:665", "m:ICit:1,2,3,4,5,6:6:666", "m:PEP:1,2,3:0:667", "m:PEP:1,2,3:1:668", "m:PEP:1,2,3:2:669", "m:PEP:1,2,3:3:670", "m:PGA:1,2,3:0:671", "m:PGA:1,2,3:1:672", "m:PGA:1,2,3:2:673", "m:PGA:1,2,3:3:674", "m:FruBP:1,2,3,4,5,6:0:675", "m:FruBP:1,2,3,4,5,6:1:676", "m:FruBP:1,2,3,4,5,6:2:677", "m:FruBP:1,2,3,4,5,6:3:678", "m:FruBP:1,2,3,4,5,6:4:679", "m:FruBP:1,2,3,4,5,6:5:680", "m:FruBP:1,2,3,4,5,6:6:681", "m:Glc6P:1,2,3,4,5,6:0:682", "m:Glc6P:1,2,3,4,5,6:1:683", "m:Glc6P:1,2,3,4,5,6:2:684", "m:Glc6P:1,2,3,4,5,6:3:685", "m:Glc6P:1,2,3,4,5,6:4:686", "m:Glc6P:1,2,3,4,5,6:5:687", "m:Glc6P:1,2,3,4,5,6:6:688", "m:Fru6P:1,2,3,4,5,6:0:689", "m:Fru6P:1,2,3,4,5,6:1:690", "m:Fru6P:1,2,3,4,5,6:2:691", "m:Fru6P:1,2,3,4,5,6:3:692", "m:Fru6P:1,2,3,4,5,6:4:693", "m:Fru6P:1,2,3,4,5,6:5:694", "m:Fru6P:1,2,3,4,5,6:6:695", "m:Rib5P:1,2,3,4,5:0:696", "m:Rib5P:1,2,3,4,5:1:697", "m:Rib5P:1,2,3,4,5:2:698", "m:Rib5P:1,2,3,4,5:3:699", "m:Rib5P:1,2,3,4,5:4:700", "m:Rib5P:1,2,3,4,5:5:701", "m:Gnt6P:1,2,3,4,5,6:0:702", "m:Gnt6P:1,2,3,4,5,6:1:703", "m:Gnt6P:1,2,3,4,5,6:2:704", "m:Gnt6P:1,2,3,4,5,6:3:705", "m:Gnt6P:1,2,3,4,5,6:4:706", "m:Gnt6P:1,2,3,4,5,6:5:707", "m:Gnt6P:1,2,3,4,5,6:6:708")
nb_meas[[1]]=length(nm_meas[[1]])
nb_measmat[[1]]=length(nm_measmat[[1]])
measmat[[1]]=simple_triplet_zero_matrix(nrow=nb_measmat[[1]], ncol=1069)
dimnames(measmat[[1]])=list(nm_measmat[[1]], nm_x)
memaone[[1]]=numeric(nb_measmat[[1]])
measvec[[1]]=c(0.371605319, 0.360829749, 0.208425325, 0.059139607, 0.131864539419667, 0.225857638569, 0.256421170949333, 0.209230210478667, 0.116863585449667, 0.0457727744643333, 0.0139900806697867, 0.421359839367667, 0.358998301162333, 0.0348521859365667, 0.184789673534, 0.434335785072667, 0.352829683224667, 0.0323479804176, 0.180486551285333, 0.0738121029259333, 0.454450017158667, 0.160823529969333, 0.0944468077710667, 0.105281338489667, 0.0155016033633, 0.0956846003217333, 0.0160587173349, 0.673510772480667, 0.0930110047641, 0.0280359937297, 0.0397315614067667, 0.0145524520950667, 0.135099498189, 0.0235029951295, 0.624253565357667, 0.113068441282333, 0.0456605631765, 0.0516089447155667, 0.0185881765378333, 0.123317313800333, 0.341615670498667, 0.25454117519, 0.159027180368333, 0.113789577528667, 0.0615266612553333, 0.0694997351590667, 0.0249552273874, 0.672556163913, 0.0866890773125333, 0.0313987199704333, 0.0314691889898667, 0.0138168327362333, 0.139114789690333)
measdev[[1]]=c(0.01, 0.01, 0.01, 0.01, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.02, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
names(measvec[[1]])=nm_meas[[1]]
names(measdev[[1]])=nm_meas[[1]]
ipooled[[1]]=list(ishort=pmatch(nm_meas[[1]], nm_measmat[[1]]))

nm_meas_tot=unlist(nm_meas)
nb_meas=unlist(nb_meas)
nb_meas_cumo=c(0., cumsum(nb_meas[-nb_exp]))
iexp_meas=lapply(seq_len(nb_exp), function(iexp) seq_len(nb_meas[iexp])+nb_meas_cumo[iexp])
nm_list$meas=nm_meas
nm_list$measmat=nm_measmat
nm_list$meas_tot=nm_meas_tot
nb_f$nb_meas=nb_meas

names(measvec)=names(measdev)=nm_exp

if (!noscale) {
   for (iexp in seq_len(nb_exp))
      ir2isc[[iexp]]=ir2isc[[iexp]][ipooled[[iexp]]$ishort]

   # prepare indexes of dispatching scale params in jacobian
   if (nb_sc_tot > 0) {
      nb_f$is2m=vector("list", nb_exp)
      for (iexp in seq_len(nb_exp)) {
         ipaire=matrix(0, nrow=0, ncol=2)
         tmp=lapply(seq_len(nb_sc[[iexp]]), function(isc) {
            i=which(ir2isc[[iexp]]==isc+nb_sc_base[iexp]+1+nb_ff)
            ipaire <<- rbind(ipaire, cbind(i, isc+nb_sc_base[iexp]))
            return(NULL)
         })
         nb_f$is2m[[iexp]]=ipaire
         # place holder for scale part of jacobian
         jx_f$dr_dsc[[iexp]]=simple_triplet_zero_matrix(nrow=length(ir2isc[[iexp]]), ncol=nb_sc_tot)
      }
   }
}
# prepare measmat indexes and values : ir, ic, val

ind_mema=matrix(c(
1, 13, 1, 1, 659, 3, 1, 701, 3, 1, 702, 3, 1, 236, -2, 1, 274, -2, 1, 267, -2, 1, 955, -4, 1, 22, 1, 1, 698, 3, 1, 317, -2, 1, 276, -2, 1, 12, 1, 1, 288, -2, 1, 44, 1,
2, 236, 1, 2, 955, 6, 2, 659, -3, 2, 701, -3, 2, 274, 1, 2, 702, -3, 2, 317, 1, 2, 698, -3, 2, 267, 1, 2, 276, 1, 2, 288, 1,
3, 659, 1, 3, 955, -4, 3, 701, 1, 3, 702, 1, 3, 698, 1,
4, 955, 1,
5, 282, 1, 5, 300, 1, 5, 255, 1, 5, 278, 1, 5, 256, 1, 5, 271, 1, 5, 897, 1, 5, 263, 1, 5, 248, 1, 5, 291, 1, 5, 915, 1, 5, 295, 1, 5, 910, 1, 5, 927, 1, 5, 956, 1, 5, 264, 1, 5, 324, 1, 5, 286, 1, 5, 946, 1, 5, 232, 1, 5, 922, 1, 5, 951, 1, 5, 920, 1, 5, 261, 1, 5, 923, 1, 5, 904, 1, 5, 911, 1, 5, 940, 1, 5, 941, 1, 5, 928, 1, 5, 1065, 1, 5, 23, -1, 5, 27, -1, 5, 8, -1, 5, 670, -1, 5, 6, -1, 5, 623, -1, 5, 652, -1, 5, 643, -1, 5, 25, -1, 5, 704, -1, 5, 658, -1, 5, 625, -1, 5, 591, -1, 5, 667, -1, 5, 662, -1, 5, 1029, -1, 5, 11, -1, 5, 634, -1, 5, 672, -1, 5, 636, -1, 5, 657, -1, 5, 650, -1, 5, 682, -1, 5, 1035, -1, 5, 630, -1, 5, 699, -1, 5, 604, -1, 5, 1030, -1, 5, 620, -1, 5, 1034, -1, 5, 1039, -1, 5, 1048, -1,
6, 23, 1, 6, 670, 3, 6, 623, 3, 6, 652, 3, 6, 704, 3, 6, 658, 3, 6, 591, 3, 6, 1029, 5, 6, 634, 3, 6, 672, 3, 6, 657, 3, 6, 1035, 5, 6, 630, 3, 6, 1030, 5, 6, 1034, 5, 6, 1039, 5, 6, 282, -2, 6, 300, -2, 6, 278, -2, 6, 897, -4, 6, 263, -2, 6, 915, -4, 6, 910, -4, 6, 927, -4, 6, 264, -2, 6, 946, -4, 6, 922, -4, 6, 951, -4, 6, 923, -4, 6, 904, -4, 6, 940, -4, 6, 1065, -6, 6, 27, 1, 6, 643, 3, 6, 625, 3, 6, 667, 3, 6, 636, 3, 6, 650, 3, 6, 699, 3, 6, 1048, 5, 6, 255, -2, 6, 256, -2, 6, 248, -2, 6, 956, -4, 6, 324, -2, 6, 920, -4, 6, 911, -4, 6, 941, -4, 6, 8, 1, 6, 662, 3, 6, 682, 3, 6, 604, 3, 6, 271, -2, 6, 291, -2, 6, 286, -2, 6, 928, -4, 6, 6, 1, 6, 620, 3, 6, 295, -2, 6, 232, -2, 6, 25, 1, 6, 261, -2, 6, 11, 1,
7, 282, 1, 7, 897, 6, 7, 915, 6, 7, 910, 6, 7, 946, 6, 7, 922, 6, 7, 923, 6, 7, 1065, 15, 7, 670, -3, 7, 623, -3, 7, 704, -3, 7, 1029, -10, 7, 634, -3, 7, 1035, -10, 7, 1030, -10, 7, 1034, -10, 7, 300, 1, 7, 927, 6, 7, 951, 6, 7, 904, 6, 7, 652, -3, 7, 658, -3, 7, 672, -3, 7, 1039, -10, 7, 255, 1, 7, 956, 6, 7, 920, 6, 7, 911, 6, 7, 643, -3, 7, 625, -3, 7, 636, -3, 7, 1048, -10, 7, 278, 1, 7, 940, 6, 7, 591, -3, 7, 657, -3, 7, 256, 1, 7, 941, 6, 7, 667, -3, 7, 650, -3, 7, 271, 1, 7, 928, 6, 7, 662, -3, 7, 682, -3, 7, 263, 1, 7, 630, -3, 7, 248, 1, 7, 699, -3, 7, 291, 1, 7, 604, -3, 7, 295, 1, 7, 620, -3, 7, 264, 1, 7, 324, 1, 7, 286, 1, 7, 232, 1, 7, 261, 1,
8, 670, 1, 8, 1029, 10, 8, 1035, 10, 8, 1030, 10, 8, 897, -4, 8, 915, -4, 8, 946, -4, 8, 1065, -20, 8, 623, 1, 8, 1034, 10, 8, 910, -4, 8, 922, -4, 8, 652, 1, 8, 1039, 10, 8, 927, -4, 8, 951, -4, 8, 643, 1, 8, 1048, 10, 8, 956, -4, 8, 920, -4, 8, 704, 1, 8, 923, -4, 8, 658, 1, 8, 904, -4, 8, 625, 1, 8, 911, -4, 8, 591, 1, 8, 940, -4, 8, 667, 1, 8, 941, -4, 8, 662, 1, 8, 928, -4, 8, 634, 1, 8, 672, 1, 8, 636, 1, 8, 657, 1, 8, 650, 1, 8, 682, 1, 8, 630, 1, 8, 699, 1, 8, 604, 1, 8, 620, 1,
9, 897, 1, 9, 1065, 15, 9, 1029, -5, 9, 1035, -5, 9, 915, 1, 9, 1030, -5, 9, 910, 1, 9, 1034, -5, 9, 927, 1, 9, 1039, -5, 9, 956, 1, 9, 1048, -5, 9, 946, 1, 9, 922, 1, 9, 951, 1, 9, 920, 1, 9, 923, 1, 9, 904, 1, 9, 911, 1, 9, 940, 1, 9, 941, 1, 9, 928, 1,
10, 1029, 1, 10, 1065, -6, 10, 1035, 1, 10, 1030, 1, 10, 1034, 1, 10, 1039, 1, 10, 1048, 1,
11, 1065, 1,
12, 241, 1, 12, 294, 1, 12, 254, 1, 12, 14, -1, 12, 43, -1, 12, 15, -1, 12, 689, -1,
13, 14, 1, 13, 689, 3, 13, 241, -2, 13, 294, -2, 13, 43, 1, 13, 254, -2, 13, 15, 1,
14, 241, 1, 14, 689, -3, 14, 294, 1, 14, 254, 1,
15, 689, 1,
16, 296, 1, 16, 275, 1, 16, 257, 1, 16, 2, -1, 16, 26, -1, 16, 18, -1, 16, 654, -1,
17, 2, 1, 17, 654, 3, 17, 296, -2, 17, 275, -2, 17, 26, 1, 17, 257, -2, 17, 18, 1,
18, 296, 1, 18, 654, -3, 18, 275, 1, 18, 257, 1,
19, 654, 1,
20, 235, 1, 20, 285, 1, 20, 239, 1, 20, 319, 1, 20, 303, 1, 20, 313, 1, 20, 948, 1, 20, 305, 1, 20, 301, 1, 20, 244, 1, 20, 931, 1, 20, 320, 1, 20, 902, 1, 20, 959, 1, 20, 947, 1, 20, 234, 1, 20, 253, 1, 20, 249, 1, 20, 900, 1, 20, 328, 1, 20, 917, 1, 20, 890, 1, 20, 891, 1, 20, 327, 1, 20, 884, 1, 20, 912, 1, 20, 962, 1, 20, 950, 1, 20, 960, 1, 20, 914, 1, 20, 1066, 1, 20, 33, -1, 20, 16, -1, 20, 7, -1, 20, 633, -1, 20, 1, -1, 20, 640, -1, 20, 617, -1, 20, 603, -1, 20, 45, -1, 20, 610, -1, 20, 599, -1, 20, 628, -1, 20, 607, -1, 20, 687, -1, 20, 614, -1, 20, 1038, -1, 20, 30, -1, 20, 705, -1, 20, 609, -1, 20, 678, -1, 20, 664, -1, 20, 660, -1, 20, 700, -1, 20, 1028, -1, 20, 661, -1, 20, 691, -1, 20, 608, -1, 20, 1054, -1, 20, 598, -1, 20, 1031, -1, 20, 1040, -1, 20, 1041, -1,
21, 33, 1, 21, 633, 3, 21, 640, 3, 21, 617, 3, 21, 610, 3, 21, 599, 3, 21, 607, 3, 21, 1038, 5, 21, 705, 3, 21, 609, 3, 21, 664, 3, 21, 1028, 5, 21, 661, 3, 21, 1054, 5, 21, 1031, 5, 21, 1040, 5, 21, 235, -2, 21, 285, -2, 21, 319, -2, 21, 948, -4, 21, 305, -2, 21, 931, -4, 21, 902, -4, 21, 959, -4, 21, 234, -2, 21, 900, -4, 21, 917, -4, 21, 890, -4, 21, 884, -4, 21, 912, -4, 21, 950, -4, 21, 1066, -6, 21, 16, 1, 21, 603, 3, 21, 628, 3, 21, 687, 3, 21, 678, 3, 21, 660, 3, 21, 691, 3, 21, 1041, 5, 21, 239, -2, 21, 303, -2, 21, 301, -2, 21, 947, -4, 21, 253, -2, 21, 891, -4, 21, 962, -4, 21, 960, -4, 21, 7, 1, 21, 614, 3, 21, 700, 3, 21, 608, 3, 21, 313, -2, 21, 244, -2, 21, 249, -2, 21, 914, -4, 21, 1, 1, 21, 598, 3, 21, 320, -2, 21, 328, -2, 21, 45, 1, 21, 327, -2, 21, 30, 1,
22, 235, 1, 22, 948, 6, 22, 931, 6, 22, 902, 6, 22, 900, 6, 22, 917, 6, 22, 884, 6, 22, 1066, 15, 22, 633, -3, 22, 640, -3, 22, 610, -3, 22, 1038, -10, 22, 705, -3, 22, 1028, -10, 22, 1054, -10, 22, 1031, -10, 22, 285, 1, 22, 959, 6, 22, 890, 6, 22, 912, 6, 22, 617, -3, 22, 599, -3, 22, 609, -3, 22, 1040, -10, 22, 239, 1, 22, 947, 6, 22, 891, 6, 22, 962, 6, 22, 603, -3, 22, 628, -3, 22, 678, -3, 22, 1041, -10, 22, 319, 1, 22, 950, 6, 22, 607, -3, 22, 664, -3, 22, 303, 1, 22, 960, 6, 22, 687, -3, 22, 660, -3, 22, 313, 1, 22, 914, 6, 22, 614, -3, 22, 700, -3, 22, 305, 1, 22, 661, -3, 22, 301, 1, 22, 691, -3, 22, 244, 1, 22, 608, -3, 22, 320, 1, 22, 598, -3, 22, 234, 1, 22, 253, 1, 22, 249, 1, 22, 328, 1, 22, 327, 1,
23, 633, 1, 23, 1038, 10, 23, 1028, 10, 23, 1054, 10, 23, 948, -4, 23, 931, -4, 23, 900, -4, 23, 1066, -20, 23, 640, 1, 23, 1031, 10, 23, 902, -4, 23, 917, -4, 23, 617, 1, 23, 1040, 10, 23, 959, -4, 23, 890, -4, 23, 603, 1, 23, 1041, 10, 23, 947, -4, 23, 891, -4, 23, 610, 1, 23, 884, -4, 23, 599, 1, 23, 912, -4, 23, 628, 1, 23, 962, -4, 23, 607, 1, 23, 950, -4, 23, 687, 1, 23, 960, -4, 23, 614, 1, 23, 914, -4, 23, 705, 1, 23, 609, 1, 23, 678, 1, 23, 664, 1, 23, 660, 1, 23, 700, 1, 23, 661, 1, 23, 691, 1, 23, 608, 1, 23, 598, 1,
24, 948, 1, 24, 1066, 15, 24, 1038, -5, 24, 1028, -5, 24, 931, 1, 24, 1054, -5, 24, 902, 1, 24, 1031, -5, 24, 959, 1, 24, 1040, -5, 24, 947, 1, 24, 1041, -5, 24, 900, 1, 24, 917, 1, 24, 890, 1, 24, 891, 1, 24, 884, 1, 24, 912, 1, 24, 962, 1, 24, 950, 1, 24, 960, 1, 24, 914, 1,
25, 1038, 1, 25, 1066, -6, 25, 1028, 1, 25, 1054, 1, 25, 1031, 1, 25, 1040, 1, 25, 1041, 1,
26, 1066, 1,
27, 314, 1, 27, 292, 1, 27, 240, 1, 27, 316, 1, 27, 311, 1, 27, 280, 1, 27, 887, 1, 27, 298, 1, 27, 297, 1, 27, 302, 1, 27, 935, 1, 27, 252, 1, 27, 936, 1, 27, 909, 1, 27, 924, 1, 27, 277, 1, 27, 266, 1, 27, 273, 1, 27, 913, 1, 27, 322, 1, 27, 930, 1, 27, 905, 1, 27, 919, 1, 27, 281, 1, 27, 894, 1, 27, 899, 1, 27, 943, 1, 27, 952, 1, 27, 957, 1, 27, 916, 1, 27, 1067, 1, 27, 39, -1, 27, 4, -1, 27, 34, -1, 27, 680, -1, 27, 17, -1, 27, 619, -1, 27, 612, -1, 27, 651, -1, 27, 36, -1, 27, 694, -1, 27, 601, -1, 27, 635, -1, 27, 655, -1, 27, 600, -1, 27, 621, -1, 27, 1037, -1, 27, 20, -1, 27, 641, -1, 27, 627, -1, 27, 673, -1, 27, 644, -1, 27, 637, -1, 27, 690, -1, 27, 1042, -1, 27, 647, -1, 27, 683, -1, 27, 629, -1, 27, 1056, -1, 27, 615, -1, 27, 1053, -1, 27, 1036, -1, 27, 1026, -1,
28, 39, 1, 28, 680, 3, 28, 619, 3, 28, 612, 3, 28, 694, 3, 28, 601, 3, 28, 655, 3, 28, 1037, 5, 28, 641, 3, 28, 627, 3, 28, 644, 3, 28, 1042, 5, 28, 647, 3, 28, 1056, 5, 28, 1053, 5, 28, 1036, 5, 28, 314, -2, 28, 292, -2, 28, 316, -2, 28, 887, -4, 28, 298, -2, 28, 935, -4, 28, 936, -4, 28, 909, -4, 28, 277, -2, 28, 913, -4, 28, 930, -4, 28, 905, -4, 28, 894, -4, 28, 899, -4, 28, 952, -4, 28, 1067, -6, 28, 4, 1, 28, 651, 3, 28, 635, 3, 28, 600, 3, 28, 673, 3, 28, 637, 3, 28, 683, 3, 28, 1026, 5, 28, 240, -2, 28, 311, -2, 28, 297, -2, 28, 924, -4, 28, 266, -2, 28, 919, -4, 28, 943, -4, 28, 957, -4, 28, 34, 1, 28, 621, 3, 28, 690, 3, 28, 629, 3, 28, 280, -2, 28, 302, -2, 28, 273, -2, 28, 916, -4, 28, 17, 1, 28, 615, 3, 28, 252, -2, 28, 322, -2, 28, 36, 1, 28, 281, -2, 28, 20, 1,
29, 314, 1, 29, 887, 6, 29, 935, 6, 29, 936, 6, 29, 913, 6, 29, 930, 6, 29, 894, 6, 29, 1067, 15, 29, 680, -3, 29, 619, -3, 29, 694, -3, 29, 1037, -10, 29, 641, -3, 29, 1042, -10, 29, 1056, -10, 29, 1053, -10, 29, 292, 1, 29, 909, 6, 29, 905, 6, 29, 899, 6, 29, 612, -3, 29, 601, -3, 29, 627, -3, 29, 1036, -10, 29, 240, 1, 29, 924, 6, 29, 919, 6, 29, 943, 6, 29, 651, -3, 29, 635, -3, 29, 673, -3, 29, 1026, -10, 29, 316, 1, 29, 952, 6, 29, 655, -3, 29, 644, -3, 29, 311, 1, 29, 957, 6, 29, 600, -3, 29, 637, -3, 29, 280, 1, 29, 916, 6, 29, 621, -3, 29, 690, -3, 29, 298, 1, 29, 647, -3, 29, 297, 1, 29, 683, -3, 29, 302, 1, 29, 629, -3, 29, 252, 1, 29, 615, -3, 29, 277, 1, 29, 266, 1, 29, 273, 1, 29, 322, 1, 29, 281, 1,
30, 680, 1, 30, 1037, 10, 30, 1042, 10, 30, 1056, 10, 30, 887, -4, 30, 935, -4, 30, 913, -4, 30, 1067, -20, 30, 619, 1, 30, 1053, 10, 30, 936, -4, 30, 930, -4, 30, 612, 1, 30, 1036, 10, 30, 909, -4, 30, 905, -4, 30, 651, 1, 30, 1026, 10, 30, 924, -4, 30, 919, -4, 30, 694, 1, 30, 894, -4, 30, 601, 1, 30, 899, -4, 30, 635, 1, 30, 943, -4, 30, 655, 1, 30, 952, -4, 30, 600, 1, 30, 957, -4, 30, 621, 1, 30, 916, -4, 30, 641, 1, 30, 627, 1, 30, 673, 1, 30, 644, 1, 30, 637, 1, 30, 690, 1, 30, 647, 1, 30, 683, 1, 30, 629, 1, 30, 615, 1,
31, 887, 1, 31, 1067, 15, 31, 1037, -5, 31, 1042, -5, 31, 935, 1, 31, 1056, -5, 31, 936, 1, 31, 1053, -5, 31, 909, 1, 31, 1036, -5, 31, 924, 1, 31, 1026, -5, 31, 913, 1, 31, 930, 1, 31, 905, 1, 31, 919, 1, 31, 894, 1, 31, 899, 1, 31, 943, 1, 31, 952, 1, 31, 957, 1, 31, 916, 1,
32, 1037, 1, 32, 1067, -6, 32, 1042, 1, 32, 1056, 1, 32, 1053, 1, 32, 1036, 1, 32, 1026, 1,
33, 1067, 1,
34, 245, 1, 34, 289, 1, 34, 237, 1, 34, 287, 1, 34, 321, 1, 34, 310, 1, 34, 892, 1, 34, 308, 1, 34, 312, 1, 34, 243, 1, 34, 903, 1, 34, 307, 1, 34, 901, 1, 34, 939, 1, 34, 937, 1, 34, 259, 1, 34, 309, 1, 34, 326, 1, 34, 921, 1, 34, 272, 1, 34, 963, 1, 34, 934, 1, 34, 954, 1, 34, 265, 1, 34, 888, 1, 34, 932, 1, 34, 907, 1, 34, 953, 1, 34, 898, 1, 34, 926, 1, 34, 1069, 1, 34, 24, -1, 34, 37, -1, 34, 5, -1, 34, 656, -1, 34, 41, -1, 34, 593, -1, 34, 653, -1, 34, 706, -1, 34, 21, -1, 34, 618, -1, 34, 703, -1, 34, 626, -1, 34, 675, -1, 34, 624, -1, 34, 696, -1, 34, 1045, -1, 34, 28, -1, 34, 611, -1, 34, 685, -1, 34, 595, -1, 34, 674, -1, 34, 642, -1, 34, 648, -1, 34, 1032, -1, 34, 613, -1, 34, 594, -1, 34, 692, -1, 34, 1044, -1, 34, 649, -1, 34, 1027, -1, 34, 1052, -1, 34, 1047, -1,
35, 24, 1, 35, 656, 3, 35, 593, 3, 35, 653, 3, 35, 618, 3, 35, 703, 3, 35, 675, 3, 35, 1045, 5, 35, 611, 3, 35, 685, 3, 35, 674, 3, 35, 1032, 5, 35, 613, 3, 35, 1044, 5, 35, 1027, 5, 35, 1052, 5, 35, 245, -2, 35, 289, -2, 35, 287, -2, 35, 892, -4, 35, 308, -2, 35, 903, -4, 35, 901, -4, 35, 939, -4, 35, 259, -2, 35, 921, -4, 35, 963, -4, 35, 934, -4, 35, 888, -4, 35, 932, -4, 35, 953, -4, 35, 1069, -6, 35, 37, 1, 35, 706, 3, 35, 626, 3, 35, 624, 3, 35, 595, 3, 35, 642, 3, 35, 594, 3, 35, 1047, 5, 35, 237, -2, 35, 321, -2, 35, 312, -2, 35, 937, -4, 35, 309, -2, 35, 954, -4, 35, 907, -4, 35, 898, -4, 35, 5, 1, 35, 696, 3, 35, 648, 3, 35, 692, 3, 35, 310, -2, 35, 243, -2, 35, 326, -2, 35, 926, -4, 35, 41, 1, 35, 649, 3, 35, 307, -2, 35, 272, -2, 35, 21, 1, 35, 265, -2, 35, 28, 1,
36, 245, 1, 36, 892, 6, 36, 903, 6, 36, 901, 6, 36, 921, 6, 36, 963, 6, 36, 888, 6, 36, 1069, 15, 36, 656, -3, 36, 593, -3, 36, 618, -3, 36, 1045, -10, 36, 611, -3, 36, 1032, -10, 36, 1044, -10, 36, 1027, -10, 36, 289, 1, 36, 939, 6, 36, 934, 6, 36, 932, 6, 36, 653, -3, 36, 703, -3, 36, 685, -3, 36, 1052, -10, 36, 237, 1, 36, 937, 6, 36, 954, 6, 36, 907, 6, 36, 706, -3, 36, 626, -3, 36, 595, -3, 36, 1047, -10, 36, 287, 1, 36, 953, 6, 36, 675, -3, 36, 674, -3, 36, 321, 1, 36, 898, 6, 36, 624, -3, 36, 642, -3, 36, 310, 1, 36, 926, 6, 36, 696, -3, 36, 648, -3, 36, 308, 1, 36, 613, -3, 36, 312, 1, 36, 594, -3, 36, 243, 1, 36, 692, -3, 36, 307, 1, 36, 649, -3, 36, 259, 1, 36, 309, 1, 36, 326, 1, 36, 272, 1, 36, 265, 1,
37, 656, 1, 37, 1045, 10, 37, 1032, 10, 37, 1044, 10, 37, 892, -4, 37, 903, -4, 37, 921, -4, 37, 1069, -20, 37, 593, 1, 37, 1027, 10, 37, 901, -4, 37, 963, -4, 37, 653, 1, 37, 1052, 10, 37, 939, -4, 37, 934, -4, 37, 706, 1, 37, 1047, 10, 37, 937, -4, 37, 954, -4, 37, 618, 1, 37, 888, -4, 37, 703, 1, 37, 932, -4, 37, 626, 1, 37, 907, -4, 37, 675, 1, 37, 953, -4, 37, 624, 1, 37, 898, -4, 37, 696, 1, 37, 926, -4, 37, 611, 1, 37, 685, 1, 37, 595, 1, 37, 674, 1, 37, 642, 1, 37, 648, 1, 37, 613, 1, 37, 594, 1, 37, 692, 1, 37, 649, 1,
38, 892, 1, 38, 1069, 15, 38, 1045, -5, 38, 1032, -5, 38, 903, 1, 38, 1044, -5, 38, 901, 1, 38, 1027, -5, 38, 939, 1, 38, 1052, -5, 38, 937, 1, 38, 1047, -5, 38, 921, 1, 38, 963, 1, 38, 934, 1, 38, 954, 1, 38, 888, 1, 38, 932, 1, 38, 907, 1, 38, 953, 1, 38, 898, 1, 38, 926, 1,
39, 1045, 1, 39, 1069, -6, 39, 1032, 1, 39, 1044, 1, 39, 1027, 1, 39, 1052, 1, 39, 1047, 1,
40, 1069, 1,
41, 306, 1, 41, 269, 1, 41, 283, 1, 41, 251, 1, 41, 293, 1, 41, 325, 1, 41, 929, 1, 41, 246, 1, 41, 290, 1, 41, 242, 1, 41, 942, 1, 41, 262, 1, 41, 964, 1, 41, 961, 1, 41, 925, 1, 41, 9, -1, 41, 31, -1, 41, 40, -1, 41, 677, -1, 41, 29, -1, 41, 693, -1, 41, 697, -1, 41, 686, -1, 41, 10, -1, 41, 663, -1, 41, 665, -1, 41, 616, -1, 41, 695, -1, 41, 669, -1, 41, 679, -1, 41, 1051, -1,
42, 9, 1, 42, 677, 3, 42, 693, 3, 42, 697, 3, 42, 663, 3, 42, 665, 3, 42, 695, 3, 42, 1051, 5, 42, 306, -2, 42, 269, -2, 42, 251, -2, 42, 929, -4, 42, 246, -2, 42, 942, -4, 42, 964, -4, 42, 961, -4, 42, 31, 1, 42, 686, 3, 42, 616, 3, 42, 669, 3, 42, 283, -2, 42, 293, -2, 42, 290, -2, 42, 925, -4, 42, 40, 1, 42, 679, 3, 42, 325, -2, 42, 242, -2, 42, 29, 1, 42, 262, -2, 42, 10, 1,
43, 306, 1, 43, 929, 6, 43, 942, 6, 43, 964, 6, 43, 677, -3, 43, 693, -3, 43, 663, -3, 43, 1051, -10, 43, 269, 1, 43, 961, 6, 43, 697, -3, 43, 665, -3, 43, 283, 1, 43, 925, 6, 43, 686, -3, 43, 616, -3, 43, 251, 1, 43, 695, -3, 43, 293, 1, 43, 669, -3, 43, 325, 1, 43, 679, -3, 43, 246, 1, 43, 290, 1, 43, 242, 1, 43, 262, 1,
44, 677, 1, 44, 1051, 10, 44, 929, -4, 44, 942, -4, 44, 693, 1, 44, 964, -4, 44, 697, 1, 44, 961, -4, 44, 686, 1, 44, 925, -4, 44, 663, 1, 44, 665, 1, 44, 616, 1, 44, 695, 1, 44, 669, 1, 44, 679, 1,
45, 929, 1, 45, 1051, -5, 45, 942, 1, 45, 964, 1, 45, 961, 1, 45, 925, 1,
46, 1051, 1,
47, 260, 1, 47, 233, 1, 47, 299, 1, 47, 279, 1, 47, 315, 1, 47, 304, 1, 47, 918, 1, 47, 270, 1, 47, 318, 1, 47, 250, 1, 47, 886, 1, 47, 323, 1, 47, 938, 1, 47, 949, 1, 47, 933, 1, 47, 268, 1, 47, 247, 1, 47, 238, 1, 47, 893, 1, 47, 284, 1, 47, 889, 1, 47, 896, 1, 47, 885, 1, 47, 258, 1, 47, 945, 1, 47, 958, 1, 47, 944, 1, 47, 906, 1, 47, 895, 1, 47, 908, 1, 47, 1068, 1, 47, 42, -1, 47, 19, -1, 47, 35, -1, 47, 684, -1, 47, 38, -1, 47, 592, -1, 47, 602, -1, 47, 605, -1, 47, 32, -1, 47, 631, -1, 47, 671, -1, 47, 646, -1, 47, 606, -1, 47, 681, -1, 47, 668, -1, 47, 1033, -1, 47, 3, -1, 47, 638, -1, 47, 666, -1, 47, 676, -1, 47, 597, -1, 47, 639, -1, 47, 596, -1, 47, 1050, -1, 47, 622, -1, 47, 645, -1, 47, 688, -1, 47, 1049, -1, 47, 632, -1, 47, 1043, -1, 47, 1046, -1, 47, 1055, -1,
48, 42, 1, 48, 684, 3, 48, 592, 3, 48, 602, 3, 48, 631, 3, 48, 671, 3, 48, 606, 3, 48, 1033, 5, 48, 638, 3, 48, 666, 3, 48, 597, 3, 48, 1050, 5, 48, 622, 3, 48, 1049, 5, 48, 1043, 5, 48, 1046, 5, 48, 260, -2, 48, 233, -2, 48, 279, -2, 48, 918, -4, 48, 270, -2, 48, 886, -4, 48, 938, -4, 48, 949, -4, 48, 268, -2, 48, 893, -4, 48, 889, -4, 48, 896, -4, 48, 945, -4, 48, 958, -4, 48, 906, -4, 48, 1068, -6, 48, 19, 1, 48, 605, 3, 48, 646, 3, 48, 681, 3, 48, 676, 3, 48, 639, 3, 48, 645, 3, 48, 1055, 5, 48, 299, -2, 48, 315, -2, 48, 318, -2, 48, 933, -4, 48, 247, -2, 48, 885, -4, 48, 944, -4, 48, 895, -4, 48, 35, 1, 48, 668, 3, 48, 596, 3, 48, 688, 3, 48, 304, -2, 48, 250, -2, 48, 238, -2, 48, 908, -4, 48, 38, 1, 48, 632, 3, 48, 323, -2, 48, 284, -2, 48, 32, 1, 48, 258, -2, 48, 3, 1,
49, 260, 1, 49, 918, 6, 49, 886, 6, 49, 938, 6, 49, 893, 6, 49, 889, 6, 49, 945, 6, 49, 1068, 15, 49, 684, -3, 49, 592, -3, 49, 631, -3, 49, 1033, -10, 49, 638, -3, 49, 1050, -10, 49, 1049, -10, 49, 1043, -10, 49, 233, 1, 49, 949, 6, 49, 896, 6, 49, 958, 6, 49, 602, -3, 49, 671, -3, 49, 666, -3, 49, 1046, -10, 49, 299, 1, 49, 933, 6, 49, 885, 6, 49, 944, 6, 49, 605, -3, 49, 646, -3, 49, 676, -3, 49, 1055, -10, 49, 279, 1, 49, 906, 6, 49, 606, -3, 49, 597, -3, 49, 315, 1, 49, 895, 6, 49, 681, -3, 49, 639, -3, 49, 304, 1, 49, 908, 6, 49, 668, -3, 49, 596, -3, 49, 270, 1, 49, 622, -3, 49, 318, 1, 49, 645, -3, 49, 250, 1, 49, 688, -3, 49, 323, 1, 49, 632, -3, 49, 268, 1, 49, 247, 1, 49, 238, 1, 49, 284, 1, 49, 258, 1,
50, 684, 1, 50, 1033, 10, 50, 1050, 10, 50, 1049, 10, 50, 918, -4, 50, 886, -4, 50, 893, -4, 50, 1068, -20, 50, 592, 1, 50, 1043, 10, 50, 938, -4, 50, 889, -4, 50, 602, 1, 50, 1046, 10, 50, 949, -4, 50, 896, -4, 50, 605, 1, 50, 1055, 10, 50, 933, -4, 50, 885, -4, 50, 631, 1, 50, 945, -4, 50, 671, 1, 50, 958, -4, 50, 646, 1, 50, 944, -4, 50, 606, 1, 50, 906, -4, 50, 681, 1, 50, 895, -4, 50, 668, 1, 50, 908, -4, 50, 638, 1, 50, 666, 1, 50, 676, 1, 50, 597, 1, 50, 639, 1, 50, 596, 1, 50, 622, 1, 50, 645, 1, 50, 688, 1, 50, 632, 1,
51, 918, 1, 51, 1068, 15, 51, 1033, -5, 51, 1050, -5, 51, 886, 1, 51, 1049, -5, 51, 938, 1, 51, 1043, -5, 51, 949, 1, 51, 1046, -5, 51, 933, 1, 51, 1055, -5, 51, 893, 1, 51, 889, 1, 51, 896, 1, 51, 885, 1, 51, 945, 1, 51, 958, 1, 51, 944, 1, 51, 906, 1, 51, 895, 1, 51, 908, 1,
52, 1033, 1, 52, 1068, -6, 52, 1050, 1, 52, 1049, 1, 52, 1043, 1, 52, 1046, 1, 52, 1055, 1,
53, 1068, 1,

NULL), ncol=3, byrow=T); # close ind_mema creation
measmat[[1]][ind_mema[,1:2,drop=FALSE]]=ind_mema[,3]
memaone[[1]]=c(0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

pwe=ipwe=ip2ipwe=pool_factor=ijpwef=dp_ones=meas2sum=dpw_dpf=ipf_in_ppw=vector("list", nb_exp)
mets_in_res=vector("list", nb_exp)
for (iexp in seq_len(nb_exp)) {
   names(memaone[[iexp]])=nm_measmat[[iexp]]

   # prepare weights of label data for pooled metabs
   # prepare ipwe and ip2ipwe such that pwe[ipwe]=pool[ip2ipwe]
   # gives a good base for weight sum and normalization
   pwe[[iexp]]=double(nb_measmat[[iexp]])+1.
   mets_in_res[[iexp]]=sapply(nm_measmat[[iexp]], function(m) strsplit(m, ":")[[1L]][2L])
   for (po in names(ipooled[[iexp]])) {
      if (po == "ishort") next
      nm_sum=strsplit(po, ":")[[1L]][2L]
      mets=strsplit(nm_sum, "\\+")[[1L]]
      irpo=ipooled[[iexp]][[po]]
      ipwe[[iexp]]=c(ipwe[[iexp]], irpo) # where weighting is
      i=pmatch(mets, names(nm_poolf))
      if (any(!is.na(i))) {
         for (ir in i) {
            if (is.na(ir)) next
            ijpwef[[iexp]]=rbind(ijpwef[[iexp]], cbind(irpo, ir)) # where free pools matter
         }
      }
      ip2ipwe[[iexp]]=c(ip2ipwe[[iexp]], pmatch(mets, names(nm_poolall)))
      mets_in_res[[iexp]][irpo]=mets
   }
   # order ijpwef for sparse matrix ordering
   if (!is.null(ijpwef[[iexp]])) {
      o=order(ijpwef[[iexp]][,2L], ijpwef[[iexp]][,1L])
      ijpwef[[iexp]]=ijpwef[[iexp]][o,,drop=FALSE]
   }
   pool_factor[[iexp]]=as.factor(nm_measmat[[iexp]])
   # free pool in principal pool weight
   ipf_in_ppw[[iexp]]=apply(outer(mets_in_res[[iexp]], names(nm_poolf), "=="), 1, function(v) if(length(w <-which(v))) w else NA)
   ipf_in_ppw[[iexp]][is.na(ipf_in_ppw[[iexp]])]=0L
   dp_ones[[iexp]]=matrix(0., nb_measmat[[iexp]], nb_poolf)
   dp_ones[[iexp]][cbind(ipwe[[iexp]], ipf_in_ppw[[iexp]][ipwe[[iexp]]])]=1.
   
   # matrix for summing weighted measurements
   meas2sum[[iexp]]=simple_triplet_zero_matrix(length(ipooled[[iexp]]$ishort), nb_measmat[[iexp]])
   meas2sum[[iexp]][cbind(pmatch(nm_measmat[[iexp]], nm_measmat[[iexp]][ipooled[[iexp]]$ishort], dup=T),       seq_len(nb_measmat[[iexp]]))]=1.
   dimnames(meas2sum[[iexp]])=list(nm_meas[[iexp]], nm_measmat[[iexp]])
   
   # dpw_dpf - matrix for derivation of pool weights by free pools
   if (nb_poolf > 0L && length(ijpwef[[iexp]]) > 0) {
      # indeed, we'll have to do weight derivation by free pools
      dpw_dpf[[iexp]]=simple_triplet_zero_matrix(nb_measmat[[iexp]], nb_poolf)
      dpw_dpf[[iexp]][ijpwef[[iexp]]]=1.
   }
}


# prepare flux measurements
nm_fmn=nm_net[c("out_Ac")]
nm_list$fmn=nm_fmn
nb_fmn=length(nm_fmn)
nb_f$nb_fmn=nb_fmn

# measured values
fmn=c(0.213)

# SD for flux measurements
fmndev=c(0.0001)
if (nb_fmn)
   names(fmndev)=names(fmn)=nm_fmn

# indices for measured fluxes
# fallnx[ifmn]=>fmn, here fallnx is complete net|xch flux vector
# combining unknown (dependent), free, constrainded and groth fluxes
ifmn=match(nm_fmn, nm_fallnx)

if (TIMEIT) {
   cat("ineq    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
# prepare mi matrix and li vector
# such that mi*fallnx>=li corresponds
# to the inequalities given in ftbl file
nb_ineq=6
mi=matrix(0., nrow=nb_ineq, ncol=nb_fallnx)
li=numeric(nb_ineq)
nm_i=c(c("n:1<=pyk", "n:0.0001<=edd", "n:0.0001<=gnd", "n:0.0001<=zwf", "n:0.0001<=ppc", "n:0.0001<=mae"), c())
dimnames(mi)=list(nm_i, nm_fallnx)
mi[1, nm_net[c("pyk")]]=c(1.0)
li[1]=1
mi[2, nm_net[c("edd")]]=c(1.0)
li[2]=0.0001
mi[3, nm_net[c("gnd")]]=c(1.0)
li[3]=0.0001
mi[4, nm_net[c("zwf")]]=c(1.0)
li[4]=0.0001
mi[5, nm_net[c("ppc")]]=c(1.0)
li[5]=0.0001
mi[6, nm_net[c("mae")]]=c(1.0)
li[6]=0.0001

# add standard limits on [df].xch [0;cupx]
nb_tmp=nrow(mi)
nb_fx=nb_flx+nb_ffx
if (nb_fx) {
   mi=rbind(mi, matrix(0, nrow=2*nb_fx, ncol=nb_fallnx))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, ">=0", sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, ">=0", sep=""))
   if (nb_flx)
      nm_i=c(nm_i, paste(nm_flx, "<=", cupx, sep=""))
   if (nb_ffx)
      nm_i=c(nm_i, paste(nm_ffx, "<=", cupx, sep=""))
   li=c(li, rep(0, nb_fx), rep(-cupx, nb_fx))
   mi[nb_tmp+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(1., nb_fx)
   mi[nb_tmp+nb_fx+(1:nb_fx),c(nm_flx, nm_ffx)]=diag(-1., nb_fx)
}

nm_inout=grep("^[^c]\\.", nm_net[c("bs_fru6P", "out_Ac", "bs_oaa2_aux", "bs_oaa5_aux", "bs_pga3_aux", "bs_oaa3_aux", "bs_akg2", "bs_glc6P", "bs_oaa6_aux", "out_FTHF", "bs_pyr3_aux", "bs_pyr4_aux", "bs_oaa4", "bs_accoa_aux", "bs_pep6_aux", "bs_pep5", "bs_akg3", "Glucupt_1", "bs_rib5p2", "bs_pga_aux", "bs_oaa7_aux", "bs_oaa1_aux", "bs_pep4_aux", "bs_pyr1_aux", "bs_DHAP", "out_co2", "bs_pga1_aux", "bs_akg4_aux", "bs_pep3_aux", "Glucupt_U", "bs_pga2_aux", "bs_rib5p1_aux")], v=T) # strip out constrained fluxes
nb_inout=length(nm_inout)
if (nb_inout > 0) {
   # add cinout low limits on inout net fluxes
   nb_tmp=nrow(mi)
   # explicit inequalities take precedence over generic ones
   # so eliminate inout fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_inout, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_inout[-i]
   } else {
      nm_tmp=nm_inout
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste("inout ", nm_tmp, ">=", cinout, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(cinout, len_tmp))
   }
}
if (clownr!=0.) {
   # add low limits on net >= clownr for not reversible reactions
   nb_tmp=nrow(mi)
   nm_tmp=nm_net[c("bs_oaa", "bs_oaa7", "bs_fru6P", "mae", "bs_pga1", "out_Ac", "bs_oaa6", "bs_pga2", "bs_pep3a", "bs_pyr", "bs_akg4", "bs_oaa2_aux", "bs_pep", "bs_akg1", "bs_oaa5", "citsynth", "bs_oaa5_aux", "bs_pga3_aux", "bs_pyr4", "bs_oaa3_aux", "edd", "bs_akg2", "gnd", "bs_pep7", "bs_glc6P", "bs_oaa6_aux", "out_FTHF", "bs_oaa1", "bs_pyr3_aux", "bs_pyr4_aux", "bs_e4p", "bs_accoa_aux", "bs_oaa4", "bs_pep6_aux", "bs_pep5", "bs_pep1", "Glucupt_1", "bs_akg3", "bs_accoa", "pfk", "bs_rib5p2", "bs_pep2", "bs_oaa7_aux", "bs_oaa2", "bs_pga_aux", "zwf", "bs_pyr1", "bs_oaa1_aux", "bs_akg", "bs_pep4a", "bs_pep4_aux", "bs_pep3b", "bs_pep4b", "bs_pyr1_aux", "bs_pep6", "bs_oaa3a", "bs_pyr3", "bs_DHAP", "bs_oaa3b", "bs_pyr2", "akgdh", "out_co2", "bs_akg4_aux", "bs_pga1_aux", "bs_rib5p1", "bs_pep3_aux", "bs_pga2_aux", "Glucupt_U", "idh", "bs_rib5p", "bs_pga", "bs_rib5p1_aux")]
   # explicit inequalities take precedence over generic ones
   # so eliminate notrev fluxes which are already in inequalities
   nm_itmp=paste("n:.+<=", substring(nm_tmp, 5), sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   # search for inout too
   nm_itmp=paste("inout ", nm_tmp, ">=", sep="")
   i=sapply(1:length(nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i, fix=T)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }

   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste(nm_tmp, ">=", clownr, sep=""))
      mi[nb_tmp+(1:len_tmp), nm_tmp]=diag(1., len_tmp)
      li=c(li, rep(clownr, len_tmp))
   }
}
nb_fn=nb_fln+nb_ffn
if (cupn != 0 && nb_fn > 0) {
   # add upper limits on [df].net <= cupn for net fluxes
   # explicit inequalities take precedence over generic ones
   # so eliminate net fluxes which are already in inequalities
   nm_tmp=c(nm_ffn, nm_fln) # all not fixed net fluxes
   nm_itmp=paste("n:.+>=", substring(nm_tmp, 5), sep="")
   i=sapply(seq(along=nm_itmp), function(k) {
      j=grep(nm_itmp[k], nm_i)
      #cat(nm_itmp[k], "->", nm_i[j], "\n", file=fclog)
      if (length(j)==0) {
         return(0)
      } else {
         return(k)
      }
   })
   i=i[i!=0]
   if (length(i) > 0) {
      nm_tmp=nm_tmp[-i]
   }
   len_tmp=length(nm_tmp)
   if (len_tmp > 0) {
      nb_tmp=nrow(mi)
      mi=rbind(mi, matrix(0, nrow=len_tmp, ncol=nb_fallnx))
      nm_i=c(nm_i, paste(nm_tmp, "<=", cupn, sep=""))
      li=c(li, rep(-cupn, len_tmp))
      mi[nb_tmp+(1:len_tmp),nm_tmp]=diag(-1., len_tmp)
   }
}

nb_ineq=NROW(li);

dimnames(mi)=list(nm_i, nm_fallnx)
names(li)=nm_i
# prepare ui matrix and ci vector for optimisation
# ui%*%param-ci>=0
# it is composed of explicite inequalities from ftbl
# and permanent inequalities 0<=xch<=0.999 and scale>=0

# constraints such that ui%*%param-ci>=0
# first flux part
ui=mi%*%(md%*%invAfl%stm%p2bfl+mf)
mic=(md%*%invAfl%*%(c2bfl%stm%fc+cnst2bfl) + mc%*%fc)
ci=as.numeric(li-mi%*%mic)

# finaly, metab part
uip=matrix(0., 0, ncol=nb_poolf)
colnames(uip)=nm_poolf
cip=c()
# ind: irow, metab, coef, rhs, name
uip_ind=c(

)
if (length(uip_ind) > 0) {
   uip_ind=matrix(uip_ind, byrow=T, ncol=5L)
} else {
   uip_ind=matrix(0, 0L, 5L)
}
colnames(uip_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(uip_ind) > 0) {
   # rhs are summed up for the same irow by aggregate()
   irow=as.integer(uip_ind[,"irow"])
   cip=aggregate(as.double(uip_ind[,"rhs"]), by=list(irow), sum)[,"x"]
   for (i in seq_len(nrow(uip_ind))) {
      row=uip_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      uip[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(uip) > 0) {
      rownames(uip)=paste("m:", uip_ind[pmatch(seq_len(nrow(uip)), irow),"name"], sep="")
   }
}
names(cip)=rownames(uip)

#browser() # before null inequality removing
# remove all zero rows in ui (constrained fluxes with fixed values)
# find zero indexes
#print(dim(ui))
if (ncol(ui)) {
   zi=apply(ui,1,function(v){return(max(abs(v))<=1.e-14)})
} else {
   # remove all flux inequalities as there is no free fluxe
   zi=rep(TRUE, nrow(ui))
}

if (!all(ci[zi]<=1.e-10)) {
   cat("The following constant inequalities are not satisfied:\n", file=fcerr)
   cat(nm_i[zi][ci[zi]>1.e-10], sep="\n", file=fcerr)
   cat("They are simply ignored.\n", file=fcerr)
   #stop_mes("", file=fcerr)
}
ui=ui[!zi,,drop=FALSE]
ci=ci[!zi]
nm_i=nm_i[!zi]

# complete ui by zero columns corresponding to scale params
if (nb_sc_tot) {
   ui=cBind(as.matrix(ui), matrix(0., NROW(ui), nb_sc_tot))
   # complete ui by scales >=0
   ui=rBind(ui, cBind(matrix(0, nb_sc_tot, nb_ff), diag(1, nb_sc_tot)))
   ci=c(ci,rep(0., nb_sc_tot))
   nm_i=c(nm_i, paste(nm_par[nb_ff+seq_len(nb_sc_tot)], ">=0", sep=""))
   rownames(ui)=nm_i
   names(ci)=nm_i
}

# remove redundant inequalities
#browser()
nb_i=nrow(ui)
ired=c()
if (nb_i > 1L) {
   for (i in 1L:(nb_i-1L)) {
      nmref=nm_i[i]
      for (j in setdiff((i+1L):nb_i, ired)) {
         if (all(ui[j,]==ui[i,]) && ci[i]==ci[j]) {
            # redundancy
            cat("inequality '", nm_i[j], "' redundant with '", nmref, "' is removed.
", sep="", file=fclog)
            ired=c(ired, j)
         }
      }
   }
}
if (!is.null(ired)) {
   # remove all ired inequalities
   ui=ui[-ired,,drop=FALSE]
   ci=ci[-ired]
   nm_i=nm_i[-ired]
}

# metabolite equalities
ep=matrix(0., 0, ncol=nb_poolf)
cp=c()
colnames(ep)=nm_poolf
# ind: irow, metab, coef, rhs, name
ep_ind=c(

)
if (length(ep_ind) > 0) {
   ep_ind=matrix(ep_ind, byrow=T, ncol=5L)
} else {
   ep_ind=matrix(0, 0L, 5L)
}
colnames(ep_ind)=c("irow", "metab", "coef", "rhs", "name")


if (nrow(ep_ind) > 0) {
   # rhs are summed up for the same irow by aggregate
   irow=as.integer(ep_ind[,"irow"])
   cp=aggregate(as.double(ep_ind[,"rhs"]), by=list(irow))[,"x"]
   for (i in seq_len(nrow(ep_ind))) {
      row=ep_ind[i,]
      if (nchar(row["metab"])==0) {
         next
      }
      ep[irow[i], nm_poolf[row["metab"]]]=as.double(row["coef"])
   }
   if (nrow(ep) > 0) {
      rownames(ep)=paste("m:", ep_ind[pmatch(seq_len(nrow(ep)), irow),"name"], sep="")
   }
}
ep=as.matrix(ep)
names(cp)=rownames(ep)

nb_sys=list(
   reactions=list(
      reversible=14,
      non_reversible=72
   ),
   fluxes=list(
      free=12,
      dependent=55,
      constrained=105
   ),
   metabolites=list(
      input=2,
      output=30,
      intra=49
   ),
   measurements=list(
      flux=1,
      mass=53,
      peak=0,
      label=0,
      metab=6
   ),
   equations=list(
      equalities=6,
      inequalities=6
   ),
   label_variables=list(
      full=c(0,0,0,0,0,0,0,0,0,0,0),
      reduced_cumomers=c(231,359,293,142,39,5)
   ),
   parallel_experiments=1
)
if (sum(nb_sys$label_variables$full)==0) {
   nb_sys$label_variables$full=NULL
}
if (emu) {
   x=nb_sys$label_variables$reduced_cumomers
   nb_sys$label_variables$reduced_cumomers=NULL
   nb_sys$label_variables$emu=paste(x, "*", seq_len(length(x)), "=", x*seq_len(length(x)))
}

#browser()

# extend param vector by free pools
if (nb_poolf > 0) {
   param=c(param, poolf)
   nm_par=c(nm_par, nm_poolf)
   nb_param=length(param)
}
nm_list$par=nm_par

#browser()
if (nb_poolf > 0) {
   # extend inequalities ui, ci by uip, cip
   nb_row=nrow(ui)
   nb_col=ncol(ui)
   ui=cbind(ui, matrix (0., nrow=nb_row, ncol=nb_poolf)) # add 0-columns
   ui=rbind(ui, cbind(matrix(0., nrow(uip), ncol=nb_col), uip))
   ci=c(ci, cip)
   
   # extend inequalities ui, ci by cupp>= poolf >= clowp
   # but exclude metabolites that are individually set in the uip (FTBL)
   met_low=met_up=c()
   if (nrow(uip) > 0) {
      # number of non zero entries per row in uip
      i_nz=rowSums(abs(uip) != 0.)
      # number of positive coeffs for alone metabs (i.e. low limit is set)
      i_pos=colSums(uip[i_nz > 0,,drop=FALSE] > 0)
      met_low=nm_poolf[i_pos > 0]
      # number of negative coeffs for alone metabs (i.e. upper limit is set)
      i_neg=colSums(uip[i_nz > 0,,drop=FALSE] < 0)
      met_up=nm_poolf[i_neg > 0]
   }

   # add low limit
   nb_add=nb_poolf-length(met_low)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_low]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(1., nb_add)
      rownames(ui_add)=paste(nm_add, ">=", clowp, sep="")
      if (nrow(ui)) {
         ui=rbind(ui, ui_add)
      } else {
         ui=ui_add
      }
      ci=c(ci, rep(clowp, nb_add))
   }

   # add upper limit
   nb_add=nb_poolf-length(met_up)
   if (nb_add > 0) {
      nm_add=nm_poolf[!nm_poolf %in% met_up]
      ui_add=matrix(0., nrow=nb_add, ncol=ncol(ui))
      ui_add[,nb_col+pmatch(nm_add, nm_poolf)]=diag(-1., nb_add)
      rownames(ui_add)=paste(nm_add, "<=", cupp, sep="")
      ui=rbind(ui, ui_add)
      ci=c(ci, rep(-cupp, nb_add))
   }

   nm_i=names(ci)=rownames(ui)
   colnames(ui)=nm_par
}
# extend the matrix of metabolite equalities
ep=cbind(matrix(0., nrow(ep), nb_param-nb_poolf), ep)
colnames(ep)=nm_par

# prepare metabolite pools measurements
nb_poolm=6
nb_f$nb_poolm=nb_poolm
nm_poolm=c("pm:Fru6P", "pm:GA3P", "pm:FruBP", "pm:PEP", "pm:Rib5P", "pm:Sed7P")
nm_list$poolm=nm_poolm

# measured values
vecpoolm=c(0.4263681348074568, 0.469998855791378, 1.860001398406723, 0.1099999780931608, 0.01933825682263468, 0.05727159999541005)
names(vecpoolm)=nm_poolm

# inverse of variance for pool measurements
poolmdev=c(0.01, 0.01, 0.01, 0.01, 0.01, 0.01)
names(poolmdev)=nm_poolm

# simulated metabolite measurements are calculated as
# measmatpool*poolall=>poolm
measmatpool=matrix(0., nrow=nb_poolm, ncol=length(poolall))
dimnames(measmatpool)=list(nm_poolm, nm_poolall)
i=matrix(1+c(0, 2, 1, 4, 2, 3, 3, 8, 4, 11, 5, 12), ncol=2, byrow=T)
measmatpool[i]=1.


## variables for isotopomer kinetics
tstart=0.
tmax=c(Inf)
dt=c(1)

# read measvecti from file(s) specified in ftbl(s)
flabcin=c("e_coli_msen.txt")
measvecti=ti=tifull=tifull2=vector("list", nb_exp)
nb_ti=nb_tifu=nb_tifu2=integer(nb_exp)
nsubdiv_dt=pmax(1L, as.integer(c(4)))
nb_f$ipf2ircumo=nb_f$ipf2ircumo2=list()
nminvm=nm_poolall[matrix(unlist(strsplit(nm_rcumo, ":")), ncol=2, byrow=T)[,1L]]
for (iexp in seq_len(nb_exp)) {
   if (tmax[iexp] < 0) {
      stop_mes(sprintf("The parameter tmax must not be negative (tmax=%g in '%s.ftbl')", tmax[iexp], nm_exp[iexp]), fcerr)
   }
   if (dt[iexp] <= 0) {
      stop_mes(sprintf("The parameter dt must be positive (dt=%g in '%s.ftbl')", dt[iexp], nm_exp[iexp]), fcerr)
   }
   if (nchar(flabcin[iexp])) {
      if (substr(flabcin[iexp], 1, 1) == "/")
         flabcin[iexp]=file.path(flabcin[iexp])
      else
         flabcin[iexp]=file.path(dirw, flabcin[iexp])
      measvecti[[iexp]]=as.matrix(read.table(flabcin[iexp], header=T, row.names=1, sep="	", check=F, comment="#"))
      nm_row=rownames(measvecti[[iexp]])
      # put in the same row order as simulated measurements
      # check if nm_meas are all in rownames
      if (all(nm_meas %in% nm_row)) {
         measvecti[[iexp]]=measvecti[[iexp]][nm_meas,,drop=FALSE]
      } else {
         # try to strip row number from measure id
         nm_strip=sapply(strsplit(nm_meas[[iexp]], ":"), function(v) {
            paste(v[-length(v)], sep="", collapse=":")
         })
         im=pmatch(nm_strip, nm_row)
         ina=is.na(im)
         if (any(ina)) {
            mes=paste("Cannot match the following measurement(s) in the file '", flabcin[iexp], "':\n", paste(nm_meas[[iexp]][ina], sep="", collapse="\n"), "\n", sep="", collapse="")
            stop_mes(mes, file=fcerr)
         }
         measvecti[[iexp]]=measvecti[[iexp]][im,,drop=FALSE]
         #stopifnot(all(!is.na(measvecti)))
         stopifnot(typeof(measvecti[[iexp]])=="double" || all(is.na(measvecti[[iexp]])))
      }
      ti[[iexp]]=as.double(colnames(measvecti[[iexp]]))
      if (any(is.na(ti[[iexp]]))) {
         mes=sprintf("All time moments (in column names) could not be converted to real numbers in the file '%s'\nConverted times:\n%s", flabcin[[iexp]], join("\n", ti[[iexp]]))
         stop_mes(mes, file=fcerr)
      }
      if (length(ti[[iexp]]) < 1L) {
         mes=sprintf("No column found in the file '%s'", flabcin[[iexp]])
         stop_mes(mes, file=fcerr)
      }
      if (!all(diff(ti[[iexp]]) > 0.)) {
         mes=sprintf("Time moments (in column names) are not monotonously increasing in the file '%s'", flabcin[[iexp]])
         stop_mes(mes, file=fcerr)
      }
      if (ti[[iexp]][1L] <= 0.) {
         mes=sprintf("The first time moment cannot be negative or 0 in the file '%s'", flabcin[[iexp]])
         stop_mes(mes, file=fcerr)
      }
      if (ti[[iexp]][1L] != 0.) {
         ti[[iexp]]=c(tstart, ti[[iexp]])
      }
      i=which(ti[[iexp]]<=tmax[[iexp]])
      ti[[iexp]]=ti[[iexp]][i]
      if (tmax[[iexp]] == Inf) {
         tmax[[iexp]]=max(ti[[iexp]])
      }
      measvecti[[iexp]]=measvecti[[iexp]][,i[-1]-1,drop=FALSE]
   } else {
      if (tmax[[iexp]] == Inf) {
         stop_mes(sprintf("Maximal value for time is Inf (probably 'tmax' field is not set in OPTIONS section: '%s.ftbl')", nm_exp[[iexp]]), file=fcerr)
      }
      ti[[iexp]]=seq(tstart, tmax[[iexp]], by=dt[iexp])
      if (optimize) {
         cat(sprintf("Warning: a fitting is requested but no file with label data is provided by 'file_labcin' option in '%s.ftbl' file.
   The fitting is ignored as if '--noopt' option were asked.\n", nm_exp[[iexp]]), file=fcerr)
         optimize=F
      }
   }
   nb_ti[iexp]=length(ti[[iexp]])
   if (nb_ti[iexp] < 2L) {
      mes=sprintf("After filtering by tmax, only %d time moments are kept for experiment '%s'. It is not sufficient.", nb_ti[iexp], nm_exp[iexp])
      stop_mes(mes, file=fcerr)
   }
   
   # divide the first time interval by n1 geometric intervals
   tifull[[iexp]]=ti[[iexp]]
   
   # divide each time interval by nsubdiv_dt
   dt=diff(tifull[[iexp]])
   dt=rep(dt/nsubdiv_dt[iexp], each=nsubdiv_dt[iexp])
   tifull[[iexp]]=c(tifull[[iexp]][1L], cumsum(dt))
   nb_tifu[iexp]=length(tifull[[iexp]])
   
   tifull2[[iexp]]=c(tifull[[iexp]][1L], tifull[[iexp]][1L]+cumsum(rep(diff(tifull[[iexp]])/2., each=2L)))
   nb_tifu2[iexp]=length(tifull2[[iexp]])
   
   if (length(ijpwef[[iexp]])) {
      # vector index for many time points
      ijpwef[[iexp]]=cbind(ijpwef[[iexp]][,1L], rep(seq_len(nb_ti[[iexp]]-1L), each=nrow(ijpwef[[iexp]])), ijpwef[[iexp]][,2L])
      dp_ones[[iexp]]=matrix(aperm(array(dp_ones[[iexp]], c(dim(dp_ones[[iexp]]), nb_ti[[iexp]]-1L)), c(1L, 3L, 2L)), ncol=nb_poolf)
   }


   # prepare mapping of metab pools on cumomers
   nb_f$ipf2ircumo[[iexp]]=nb_f$ipf2ircumo2[[iexp]]=list()
   for (iw in seq_len(nb_w)) {
      ix=seq_len(nb_rcumos[iw])
      ipf2ircumo=ipf2ircumo2=match(nminvm[nbc_cumos[iw]+ix], nm_poolf, nomatch=0L)
      dims=c(1L, nb_rcumos[iw], ifelse(emu, iw, 1L), nb_tifu[iexp]-1L)
      dims2=c(1L, nb_rcumos[iw], ifelse(emu, iw, 1L), nb_tifu2[iexp]-1L)
      i=as.matrix(ipf2ircumo)
      i2=as.matrix(ipf2ircumo2)
      for (id in 2L:length(dims)) {
         cstr=sprintf("cbind(%srep(seq_len(dims[id]), each=prod(dims[seq_len(id-1L)])))", paste("i[, ", seq_len(id-1L), "], ", sep="", collapse=""))
         i=eval(parse(text=cstr))
      }
      for (id in 2L:length(dims2)) {
         cstr=sprintf("cbind(%srep(seq_len(dims2[id]), each=prod(dims2[seq_len(id-1L)])))", paste("i2[, ", seq_len(id-1L), "], ", sep="", collapse=""))
         i2=eval(parse(text=cstr))
      }
      colnames(i)=c("ipoolf", "ic", "iw", "iti")
      colnames(i2)=c("ipoolf", "ic", "iw", "iti")
      i=i[i[,1L]!=0L,,drop=FALSE]
      i2=i2[i2[,1L]!=0L,,drop=FALSE]
      # put the poolf column last
      nb_f$ipf2ircumo[[iexp]][[iw]]=i[, c("ic", "iw", "ipoolf", "iti"), drop=FALSE]
      nb_f$ipf2ircumo2[[iexp]][[iw]]=i2[, c("ic", "iw", "ipoolf", "iti"), drop=FALSE]
   }
}
nb_f$ip2ircumo=match(nminvm, nm_poolall)
nb_f$tifu=nb_tifu
nb_f$tifu2=nb_tifu2

# label state at t=0 (by default=0 but later it should be able to be specified by user)
x0=NULL
nb_f$ti=nb_ti

# gather all measurement information
measurements=list(
   vec=list(labeled=measvec, flux=fmn, pool=vecpoolm, kin=if (case_i) measvecti else NULL),
   dev=list(labeled=measdev, flux=fmndev, pool=poolmdev, kin=if (case_i) rep(measdev, nb_ti-1) else NULL),
   mat=list(labeled=measmat, flux=ifmn, pool=measmatpool),
   one=list(labeled=memaone)
)
nm_resid=c(if (case_i) unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, outer(nm_meas[[iexp]], ti[[iexp]][-1L], paste, sep=", t="), sep=":"))) else unlist(lapply(seq_len(nb_exp), function(iexp) paste(iexp, nm_meas[[iexp]], sep=":"))), nm_fmn, nm_poolm)
nm_list$resid=nm_resid

if (TIMEIT) {
   cat("preopt  : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
#browser()
names(param)=nm_par
# prepare series of starting points
if (nchar(fseries) > 0) {
   pstart=as.matrix(read.table(fseries, header=T, row.n=1, sep="\t"))
   # skip parameters (rows) who's name is not in nm_par
   i=rownames(pstart) %in% nm_par
   if (!any(i)) {
      stop_mes("Option --fseries is used but no free parameter with known name is found.\n")
   }
   pstart=pstart[i,,drop=FALSE]
   cat("Using starting values form '", fseries, "' for the following free parameters:\n", paste(rownames(pstart), collapse="\n"), "\n", sep="", file=fclog)
   nseries=ncol(pstart)
   if (initrand) {
      # fill the rest of rows with random values
      i=nm_par %in% rownames(pstart)
      n=sum(!i)
      pstart=rbind(pstart, matrix(runif(n*nseries), n, nseries))
      rownames(pstart)=c(rownames(pstart)[seq_len(nb_param-n)], nm_par[!i])
   }
   if (nchar(iseries) > 0) {
      iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
      iseries=iseries[iseries<=nseries]
      # subsample
      pstart=pstart[,iseries, drop=FALSE]
      nseries=ncol(pstart)
   } else {
      iseries=seq_len(nseries)
   }
} else if (nchar(iseries) > 0) {
   # first construct pstart then if needed fill it with random values
   # and only then subsample
   iseries=unique(as.integer(eval(parse(t="c("%s+%iseries%s+%")"))))
   nseries=max(iseries)
   pstart=matrix(rep(param, nseries), nrow=nb_param, ncol=nseries)
   dimnames(pstart)=list(nm_par, paste("V", seq_len(nseries), sep=""))
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
   # subsample
   pstart=pstart[,iseries, drop=FALSE]
   nseries=ncol(pstart)
} else {
   iseries=1L
   pstart=as.matrix(param)
   nseries=1L
   if (initrand) {
      # fill pstart with random values
      pstart[]=runif(length(pstart))
   }
}
nm_pseries=rownames(pstart)

if (is.null(nseries) || nseries==0) {
   stop_mes(sprintf("No starting values in the series file '%s' or --iseries is empty.", fseries),  file=fcerr)
}

pres=matrix(NA, nb_param, nseries)
rownames(pres)=nm_par
colnames(pres)=colnames(pstart)
costres=rep.int(NA, nseries)

# prepare flux index conversion
ifwrv=1:nb_fwrv
names(ifwrv)=nm_fwrv
ifl_in_fw=if (nb_fln) ifwrv[paste("fwd", substring(c(nm_fln, nm_flx), 4), sep="")] else integer(0)
iff_in_fw=if (nb_ff > 0) ifwrv[paste("fwd", substring(c(nm_ffn, nm_ffx), 4), sep="")] else integer(0)
ifg_in_fw=if (nb_fgr > 0) ifwrv[paste("fwd", substring(nm_fgr, 4), sep="")] else integer(0)

# index couples for jacobian df_dfl, df_dffd
cfw_fl=crv_fl=cbind(ifl_in_fw, seq_len(nb_fl))
cfw_ff=crv_ff=cbind(iff_in_fw, seq_len(nb_ff))
cfw_fg=crv_fg=cbind(ifg_in_fw, nb_ff+seq_len(nb_fgr))
crv_fl[,1L]=(nb_fwrv/2)+crv_fl[,1L]
crv_ff[,1L]=(nb_fwrv/2)+crv_ff[,1L]
crv_fg[,1L]=(nb_fwrv/2)+crv_fg[,1L]

# store it in nb_f
nb_f=append(nb_f, list(cfw_fl=cfw_fl, crv_fl=crv_fl, cfw_ff=cfw_ff,
   crv_ff=crv_ff, cfw_fg=cfw_fg, crv_fg=crv_fg))
nb_f=as.environment(nb_f)

nbc_x=c(0, cumsum(nb_x))
nb_f$nbc_x=nbc_x

# fixed part of jacobian (unreduced by SD)
# measured fluxes
dufm_dp=cbind(dufm_dff(nb_f, nm_list), matrix(0, nrow=nb_fmn, ncol=nb_sc_tot+nb_poolf))
dimnames(dufm_dp)=list(nm_fmn, nm_par)

# measured pools
dupm_dp=matrix(0., nb_poolm, nb_ff+nb_sc_tot)
if (nb_poolf > 0L) {
   dupm_dp=cbind(dupm_dp, measurements$mat$pool[,nm_list$poolf, drop=FALSE])
}
dimnames(dupm_dp)=list(rownames(measurements$mat$pool), nm_par)

#browser()
# prepare argument list for passing to label simulating functions
nm_labargs=c("jx_f", "nb_f", "nm_list", "nb_x", "invAfl", "p2bfl", "g2bfl", "bp", "fc", "xi", "spa", "emu", "pool", "measurements", "ipooled", "ir2isc",  "nb_w", "nbc_x", "measmat", "memaone", "dufm_dp", "dupm_dp", "pwe", "ipwe", "ip2ipwe", "pool_factor", "ijpwef", "ipf_in_ppw", "meas2sum", "dp_ones", "clen", "dirr", "dirw", "baseshort", "case_i", "nb_exp", "noscale", "dpw_dpf")
nm_labargs=c(nm_labargs, "ti", "tifull", "tifull2", "x0", "time_order")

if (TIMEIT) {
   cat("labargs : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}
labargs=new.env()
tmp=lapply(nm_labargs, function(nm) assign(nm, get(nm), labargs))
#for (nm in nm_labargs) {
#   labargs[[nm]]=get(nm)
#}
labargs[["nm"]]=labargs[["nm_list"]]

# prepare labargs2 if time_order includes 2
if (case_i && (time_order == "2" || time_order == "1,2")) {
   labargs2=as.environment(as.list(labargs))
   labargs2$nb_f=as.environment(as.list(labargs$nb_f))
   labargs2$tifull=tifull2
   labargs2$jx_f=new.env()
   labargs2$nb_f$ipf2ircumo=nb_f$ipf2ircumo2
   labargs2$nb_f$tifu=nb_f$tifu2
   labargs[["labargs2"]]=labargs2
}

# formated output in kvh file
fkvh_saved=file.path(dirw, sprintf("%s_res.kvh", baseshort))

control_ftbl=list(errx=0.001, maxit=50, btmaxit=16, btstart=1, btfrac=0.5, adaptbt=1, monotone=1)

retcode=numeric(nseries)
cl_type="PSOCK"
cl=NULL
if ((case_i && (time_order %in% c("1,2", "2"))) || sensitive == "mc") {
   if (np > 1L) {
      # prepare cluster
      nodes=if (sensitive == "mc") np else 2

      # prepare cluster
      cl=makeCluster(nodes, cl_type) #, outfile="cl.log")
#cat("make cluster=")
#print(cl[[1]])
      labargs[["cl"]]=cl
      nodes=length(cl)
      if (TIMEIT) {
         cat("cl expor: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterExport(cl, c("lsi_fun", "df_dffp", "lab_sim", "is.diff", "lab_resid", "ui", "ci", "ep", "cp", "control_ftbl", "method", "sln", "labargs", "dirr", "emu", "%stm%", "case_i", "time_order"))
      if (TIMEIT) {
         cat("cl sourc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      clusterEvalQ(cl, {
         #idth=myinfo$id
         suppressPackageStartupMessages(library(nnls))
         suppressPackageStartupMessages(library(slam)) # for quick sparse matrices
         suppressPackageStartupMessages(library(Rcpp))
         suppressPackageStartupMessages(library(RcppArmadillo))
         suppressPackageStartupMessages(library(rmumps))
         suppressPackageStartupMessages(library(arrApply)) # for fast apply() on arrays
         suppressPackageStartupMessages(library(multbxxc))
         compiler::enableJIT(0)
         source(file.path(dirr, "tools_ssg.R"))
         source(file.path(dirr, "nlsic.R"))
         source(file.path(dirr, "opt_cumo_tools.R"))
         source(file.path(dirr, "opt_icumo_tools.R"))
         #loadcmp(file.path(dirr, "tools_ssg.Rc"))
         #loadcmp(file.path(dirr, "nlsic.Rc"))
         #loadcmp(file.path(dirr, "opt_cumo_tools.Rc"))
         #loadcmp(file.path(dirr, "opt_icumo_tools.Rc"))
         labargs$spa=sparse2spa(labargs$spa)
         if (case_i && (time_order == "2" || time_order == "1,2")) {
            labargs$labargs2$spa=labargs$spa
         }
#cat("evalQ idth=", idth, "\n")
#print(labargs)
#print(labargs$labargs2)
#print(labargs$spa)
#print(labargs$labargs2$spa)
         NULL
      })
      clusterSetRNGStream(cl)
      # set worker id
      idw=parLapply(cl, seq_along(cl), function(i) assign("idw", i, envir=.GlobalEnv))
   } else {
      labargs$cl=NULL
   }
}
for (irun in seq_len(nseries)) {
   if (TIMEIT) {
      cat(sprintf("run %4d: %s cpu=%g\n", irun, format(Sys.time()), proc.time()[1], "\n", sep=""), file=fclog)
   }
   param[nm_pseries]=pstart[nm_pseries, irun]
#browser()
   # prepare kvh file name
   if (nseries > 1) {
      runsuf="." %s+% colnames(pstart)[irun]
   } else {
      runsuf=""
   }
   if (length(nseries) > 0) {
      cat("Starting point", runsuf, "\n", sep="", file=fclog)
   }
   fkvh=file(substring(fkvh_saved, 1, nchar(fkvh_saved)-4) %s+% runsuf %s+% ".kvh", "w");

   # remove zc inequalities from previous runs
   izc=grep("^zc ", nm_i)
   if (length(izc)) {
      ui=ui[-izc,,drop=FALSE]
      ci=ci[-izc]
      nm_i=rownames(ui)
   }
   # check if initial approximation is feasible
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   if (any(ineq <= -1.e-10)) {
      cat("The following ", sum(ineq<= -1.e-10), " ineqalities are not respected at starting point", runsuf, ":\n", sep="", file=fclog)
      i=ineq[ineq<= -1.e-10]
      cat(paste(names(i), i, sep="\t", collapse="\n"), "\n", sep="", file=fclog)
      # put them inside
      capture.output(pinside <- put_inside(param, ui, ci), file=fclog)
      if (any(is.na(pinside))) {
         if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
            # fatal error occured
            cat("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n",
               file=fcerr, sep="")
            close(fkvh)
            retcode[irun]=attr(pinside, "err")
            next;
         }
      } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0) {
         # non fatal problem
         cat(paste("put_inside: ", attr(pinside, "mes"), collapse=""), "\n", file=fcerr)
      }
      param[]=pinside
   }

   # prepare zero crossing strategy
   # inequalities to keep sens of net flux on first call to opt_wrapper()
   # if active they are removed on the second call to opt_wrapper()
   # and finaly all zc constraints are relaxed on the last call to opt_wrapper()
   fallnx=param2fl(param, labargs)$fallnx
   mi_zc=NULL
   li_zc=NULL
   if (zerocross && length(grep("^[df]\\.n\\.", nm_fallnx))>0) {
      if (TIMEIT) {
         cat("zc ineq : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
#browser()
      # prepare fluxes that are already in inequalities in alone mode
      ige=names(which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==1) & li>=0))
      ige=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ige, v=T)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ige, v=T)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ige, v=T))
      ))]
      ile=which(apply(mi, 1L, function(v) diff(range(v))==1 && sum(v)==-1)&li>=0)
      ile=nm_dfn[unique(c(
         sub("^n:.+<=(.+)$", "\\1", grep("^n:.+<=.+$", ile, v=T)),
         sub("^[df]\\.n\\.(.+)>=.+$", "\\1", grep("^[df]\\.n\\..+>=.+$", ile, v=T)),
         sub("^inout [df]\\.n\\.(.+)>=.+$", "\\1", grep("^inout [df]\\.n\\..+>=.+$", ile, v=T))
      ))]
      # add lower limits on [df].net >= zc for positive net fluxes
      # and upper limits on [df].net <= -zc for negative net fluxes
      nm_izc=c()
      ipos=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]>=0.)), ige)
      ineg=setdiff(names(which(fallnx[grep("^[df]\\.n\\.", nm_fallnx)]<0.)), ile)
      mi_zc=matrix(0, nrow=length(ipos)+length(ineg), ncol=nb_fallnx)
      colnames(mi_zc)=nm_fallnx
      if (length(ipos)) {
         nm_izc=c(nm_izc, paste("zc ", ipos, ">=", zc, sep=""))
         mi_zc[(1:length(ipos)),ipos]=diag(1., length(ipos))
      }
      if (length(ineg)) {
         nm_izc=c(nm_izc, paste("zc ", ineg, "<=", -zc, sep=""))
         mi_zc[length(ipos)+(1:length(ineg)),ineg]=diag(-1., length(ineg))
      }
      rownames(mi_zc)=nm_izc
      li_zc=rep(zc, length(nm_izc)) # that's ok for both pos and neg constraints
      ui_zc=cbind(mi_zc%*%(md%*%invAfl%stm%p2bfl+mf),
         matrix(0., nrow=nrow(mi_zc), ncol=nb_sc_tot))
      if (nb_fgr > 0) {
         ui_zc=cbind(ui_zc, mi_zc%*%((md%*%invAfl%stm%g2bfl)+mg*nb_f$mu))
      } else if (nb_poolf > 0) {
         ui_zc=cbind(ui_zc, matrix(0., nrow=nrow(mi_zc), ncol=nb_poolf))
      }
      ci_zc=li_zc-mi_zc%*%mic
      # remove constant inequalities
      if (ncol(ui_zc)) {
         zi=apply(ui_zc,1,function(v){return(max(abs(v))<=1.e-14)})
      } else {
         # remove all flux inequalities as there is no free params
         zi=rep(TRUE, nrow(ui_zc))
      }

      inotsat=ci_zc[zi]>1.e-10
      if (any(inotsat)) {
         cat("Warning: The following constant zc inequalities are not satisfied:\n", file=fcerr)
         cat(nm_izc[zi][inotsat], sep="\n", file=fcerr)
      }
      ui_zc=ui_zc[!zi,,drop=FALSE]
      ci_zc=ci_zc[!zi]
      nm_izc=nm_izc[!zi]
      mi_zc=mi_zc[!zi,,drop=FALSE]

      # remove redundant/contradictory inequalities
      nb_zc=nrow(ui_zc)
      nb_i=nrow(ui)
      ired=c()
      tui=t(ui)
      uzcd=sapply(seq_len(nb_zc), function(i) apply(abs(tui-ui_zc[i,]), 2L, max))
      uzcs=sapply(seq_len(nb_zc), function(i) apply(abs(tui+ui_zc[i,]), 2L, max))
      czcd=abs(outer(abs(ci), abs(ci_zc), "-"))
      ired=which(apply((uzcd < 1.e-10 | uzcs < 1.e-10) & czcd <= 1.e-2, 2, any))
      
      if (length(ired) > 0L) {
         # remove all ired inequalities
         cat("The following ", length(ired), " zerocross inequalities are redundant and are removed:\n", paste(nm_izc[ired], collapse="\n"), "\n", sep="", file=fclog)
         ui_zc=ui_zc[-ired,,drop=FALSE]
         ci_zc=ci_zc[-ired]
         nm_izc=nm_izc[-ired]
         mi_zc=mi_zc[-ired,,drop=FALSE]
      }
      if (nrow(ui_zc)) {
         # add zc inequalities
         ui=rbind(ui, ui_zc)
         ci=c(ci, ci_zc)
         nm_i=c(nm_i, nm_izc)
      }
      rm(ui_zc, ci_zc, uzcd, uzcs, czcd)
   }
   rres=NULL

   # see if there are any active inequalities at starting point
   ineq=as.numeric(ui%*%param-ci)
   names(ineq)=rownames(ui)
   if (any(abs(ineq)<=1.e-10)) {
      cat("The following ", sum(abs(ineq)<=1.e-10), " ineqalitie(s) are active at starting point", runsuf, ":\n",
         paste(names(ineq[abs(ineq)<=1.e-10]), collapse="\n"), "\n", sep="", file=fclog)
   }

   if (TIMEIT) {
      cat("kvh init: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }

   cat("influx\n", file=fkvh)
   cat("\tversion\t", vernum, "\n", file=fkvh, sep="")
   cat("\tlabeling\t", if (case_i) "instationary" else "stationary", "\n", file=fkvh, sep="")
   # save options of command line
   cat("\truntime options\n", file=fkvh)
   cat("\t\tnoscale=TRUE
		clowp=1e-09
		zc=0.0
		time_order='2'
		TIMEIT=TRUE\n", file=fkvh)
   
   obj2kvh(R.Version(), "R.Version", fkvh, indent=1)
   cat("\tR command line\n", file=fkvh)
   obj2kvh(opts, "opts", fkvh, indent=2)
   cat("\t\texecution date	", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fkvh)

   # resume system sizes
   obj2kvh(nb_sys, "system sizes", fkvh)

   # save initial param
   cat("starting point\n", file=fkvh)
   names(param)=nm_par
   obj2kvh(param, "starting free parameters", fkvh, indent=1)
#browser()
   if (!length(rres)) {
      capture.output(rres <- lab_resid(param, cjac=FALSE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
      if (sum(is.infinite(rres$res))) {
         cat("Infinite values appeared in residual vector (at starting point)", file=fcerr)
         retcode[irun]=1
         close(fkvh)
         next
      }
   }
   rcost=if (length(rres$res) && !all(ina <- is.na(rres$res))) sum(crossprod(rres$res[!ina])) else NA
   obj2kvh(rcost, "starting cost value", fkvh, indent=1)

   obj2kvh(Afl, "flux system (Afl)", fkvh, indent=1)
   fg=numeric(nb_f$nb_fgr)
   names(fg)=nm_list$fgr
   if (nb_f$nb_fgr > 0) {
      fg[paste("g.n.", substring(nm_list$poolf, 4), "_gr", sep="")]=nb_f$mu*param[nm_list$poolf]
   }
   btmp=as.numeric(p2bfl%stm%param[seq_len(nb_f$nb_ff)]+bp+g2bfl%stm%fg)
   names(btmp)=dimnames(Afl)[[1]]
   obj2kvh(btmp, "flux system (bfl)", fkvh, indent=1)

   #cat("mass vector:\n", file=fclog)
   #print_mass(x)

   names(param)=nm_par

#browser()
   if (optimize && nb_ff+nb_poolf > 0L) {
      if (!(least_norm || sln || method!="nlsic")) {
         # check if at starting position all fluxes can be resolved
         if (TIMEIT) {
            cat("check ja: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         rres=lab_resid(param, cjac=TRUE, labargs)
         if (sum(is.infinite(rres$res))) {
            cat("Infinite values appeared in residual vector (at identifiability check)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         if (sum(is.infinite(rres$jacobian))) {
            cat("Infinite values appeared in Jacobian (at identifiability check)", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         qrj=qr(jx_f$dr_dff, LAPACK=T)
         d=diag(qrj$qr)
         qrj$rank=sum(abs(d)>abs(d[1])*1.e-10)
         if (is.na(qrj$rank)) {
            cat("Rank of starting jacobian could not be estimated.", file=fcerr)
            retcode[irun]=1
            close(fkvh)
            next
         }
         if (qrj$rank) {
            nm_uns=nm_ff[qrj$pivot[-(1:qrj$rank)]]
         } else {
            nm_uns=nm_ff
         }
         if (qrj$rank < nb_ff) {
            # Too bad. The jacobian of free fluxes is not of full rank.
            dimnames(jx_f$dr_dff)[[2]]=c(nm_ffn, nm_ffx)
            fname="dbg_dr_dff_singular" %s+% runsuf %s+% ".csv"
            cat(sprintf("Provided measurements (labeling and fluxes) are not sufficient to resolve all free fluxes.\nUnsolvable fluxes may be:\n%s\nJacobian dr_dff is written in the result kvh file.\n",
               paste(nm_uns, sep=", ", collapse=", ")),
               file=fcerr)
            obj2kvh(jx_f$dr_dff, "Jacobian dr_dff", fkvh, indent=0)
            close(fkvh)
            retcode[irun]=1
            next
         }
      }
      if (TIMEIT) {
         cat("optim   : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      # pass control to the chosen optimization method
      if (time_order=="1,2")
         labargs$time_order="1" # start with order 1, later continue with 2
      capture.output(res <- opt_wrapper(param, measurements, jx_f, labargs), file=fclog)
      if ((!is.null(res$err) && res$err) || is.null(res$par)) {
         cat("first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fcerr)
         res$par=rep(NA, length(param))
         res$cost=NA
      } else if (!is.null(res$mes) && nchar(res$mes)) {
         cat("first optimization pass", runsuf, ": ", res$mes, "\n", sep="", file=fcerr)
      }
      if (any(is.na(res$par))) {
         res$retres$jx_f=NULL # to avoid writing of huge data
         obj2kvh(res, "failed first pass optimization process information", fkvh)
         cat("Optimization failed", runsuf, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=max(res$err, 1)
         next
      }
      param=res$par
#browser()
      if (zerocross && !is.null(mi_zc)) {
         if (TIMEIT) {
            cat("secondzc: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         # inverse active "zc" inequalities
         nm_inv=names(which((ui%*%res$par-ci)[,1]<=1.e-10))
         i=grep("^zc ", nm_inv, v=T)
         if (length(i) > 0) {
            i=str2ind(i, nm_i)
            cat("The following inequalities are active after first pass
of zero crossing strategy and will be inverted", runsuf, ":\n", paste(nm_i[i], collapse="\n"), "\n", sep="", file=fclog)
            ipos=grep(">=", nm_i[i], v=T)
            ineg=grep("<=", nm_i[i], v=T)
            ui[i,]=-ui[i,,drop=FALSE]
            if (length(ipos)) {
               ipzc=str2ind(ipos, nm_izc)
               ipos=str2ind(ipos, nm_i)
               ci[ipos]=as.numeric(zc+mi_zc[ipzc,,drop=FALSE]%*%mic)
               nm_i[ipos]=sub(">=", "<=-", nm_i[ipos])
            }
            if (length(ineg)) {
               inzc=str2ind(ineg, nm_izc)
               ineg=str2ind(ineg, nm_i)
               ci[ineg]=as.numeric(zc+mi_zc[inzc,,drop=FALSE]%*%mic)
               nm_i[ineg]=sub("<=-", ">=", nm_i[ineg])
            }
            rownames(ui)=nm_i
            names(ci)=nm_i
            # enforce new inequalities
            reopt=TRUE
            capture.output(pinside <- put_inside(res$par, ui, ci), file=fclog)
            if (any(is.na(pinside))) {
               if (!is.null(attr(pinside, "err")) && attr(pinside, "err")!=0) {
                  # fatal error occured, don't reoptimize
                  cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
                  reopt=FALSE
               }
            } else if (!is.null(attr(pinside, "err")) && attr(pinside, "err")==0){
               # non fatal problem
               cat(paste("put_inside", runsuf, ": ", attr(pinside, "mes"), "\n", collapse=""), file=fcerr)
            }
            # reoptimize
            if (reopt) {
               cat("Second zero crossing pass", runsuf, "\n", sep="", file=fclog)
               capture.output(reso <- opt_wrapper(pinside, measurements, new.env(), labargs), file=fclog)
               if (reso$err || is.null(reso$par)) {
                  cat("second zero crossing pass: ", reso$mes, "\n", sep="", file=fcerr)
               } else if (!is.null(reso$mes) && nchar(reso$mes)) {
                  cat("second zero crossing pass", runsuf, ": ", reso$mes, "\n", sep="", file=fcerr)
               }
               if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                  param=reso$par
                  res=reso
                  jx_f=labargs$jx_f
               }
               if (any(is.na(reso$par))) {
                  reso$retres$jx_f=NULL # to avoid writing of huge data
                  obj2kvh(reso, "failed second pass optimization process information", fkvh)
                  cat("Second zero crossing pass failed. Keep free parameters from previous pass", runsuf, "\n", file=fcerr, sep="")
               }
            }
            # last pass, free all zc constraints
            i=grep("^zc ", nm_i)
            if (length(i) > 0) {
               if (TIMEIT) {
                  cat("last zc : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
               }
               ui=ui[-i,,drop=FALSE]
               ci=ci[-i]
               nm_i=nm_i[-i]
               cat("Last zero crossing pass (free of zc constraints)", runsuf, "\n", sep="", file=fclog)
               capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
               if (reso$err || is.null(reso$par) || (!is.null(res$mes) && nchar(res$mes))) {
                  cat("last zero crossing (free of zc)", runsuf, ": ", reso$mes, "\n", sep="", file=fcerr)
               }
               if(!reso$err && !is.null(reso$par) && !any(is.na(reso$par))) {
                  param=reso$par
                  res=reso
                  jx_f=labargs$jx_f
               }
               if (any(is.na(res$par))) {
                  res$retres$jx_f=NULL # to avoid writing of huge data
                  obj2kvh(res, "failed last pass optimization process information", fkvh)
                  cat("Last zero crossing pass failed. Keep free parameters from previous passes", runsuf, "\n", file=fcerr, sep="")
               }
            }
         } else {
            cat("After the first optimization, no zero crossing inequality was activated. So no reoptimization", runsuf, "\n", sep="", file=fclog)
         }
      } # end if zero crossing
      param=res$par
      names(param)=nm_par
      if (excl_outliers != F) {
         # detect outliers
         if (TIMEIT) {
            cat("outliers: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         iva=!is.na(res$res)
         zpval=rz.pval.bi(res$res)
         iout=which(zpval <= excl_outliers & iva)
         #cat("iout=", iout, "\n", file=fclog)
         if (length(iout)) {
            measurements$outlier=iout
            outtab=cbind(residual=res$res[iout], `p-value`=zpval[iout])
            row.names(outtab)=nm_resid[iout]
            cat("Excluded outliers at p-value ", excl_outliers, ":\n", sep="", file=fclog)
            write.table(outtab, file=fclog, append=TRUE, quote=FALSE, sep="\t", col.names=FALSE)
            
            capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
            if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
               cat("wo outliers: ", reso$mes, "\n", sep="", file=fcerr)
            }
            if (any(is.na(reso$par))) {
               cat("Optimization with outliers excluded has failed, run= ", runsuf, "\n", file=fcerr, sep="")
               # continue without outlier exclusion
               measurements$outlier=NULL
            } else {
               res=reso
               param=reso$par
               names(param)=nm_par
               jx_f=labargs$jx_f
               labargs$measurements=measurements # store outliers
               obj2kvh(outtab, "excluded outliers", fkvh)
            }
         } else {
            cat("Outlier exclusion at p-value "%s+%excl_outliers%s+%" has been requested but no outlier was detected at this level.", "\n", sep="", file=fcerr)
         }
      }
      if (case_i && time_order=="1,2") {
         if (TIMEIT) {
            cat("order 2 : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
         }
         labargs$time_order="2" # continue with the 2-nd order
         capture.output(reso <- opt_wrapper(param, measurements, new.env(), labargs), file=fclog)
         if (reso$err || is.null(reso$par) || (!is.null(reso$mes) && nchar(reso$mes))) {
            cat("order2: ", reso$mes, "\n", sep="", file=fcerr)
         }
         if (any(is.na(reso$par))) {
            cat("Optimization time_order 2 (in '1,2' suite) has failed, run=", runsuf, "\n", file=fcerr, sep="")
         } else {
            res=reso
            param=reso$par
            names(param)=nm_par
            jx_f=labargs$jx_f
         }
      }
#browser()
      optinfo=list(
         "fitted parameters"=param,
         "last increment before backtracking"=res$lastp,
         "last increment after backtracking"=res$laststep,
         "iteration number"=res$it,
         "convergence history"=res$hist,
         "exit message"=res$mes
      )
      obj2kvh(optinfo, "optimization process information", fkvh)
      rres=res$retres
   } else {
      rres=lab_resid(param, TRUE, labargs)
   }
   if (TIMEIT) {
      cat("postopt : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # active constraints
   ine=as.numeric(abs(ui%*%param-ci))<1.e-10
   if (any(ine)) {
      obj2kvh(nm_i[ine], "active inequality constraints", fkvh)
   }
   poolall[nm_poolf]=param[nm_poolf]

#browser()
   if (is.null(jx_f$jacobian)) {
      # final jacobian calculation
      capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
   }
   rcost=cumo_cost(param, labargs, rres)
   pres[,irun]=param
   costres[irun]=rcost
   obj2kvh(rcost, "final cost", fkvh)
#browser()
   # get z p-values on residual vector
   zpval=rz.pval.bi(rres$res)
   resid=list()
   if (sum(nb_meas)) {
      resid[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) if (is.matrix(jx_f$reslab[[iexp]])) jx_f$reslab[[iexp]] else cbind(residual=jx_f$reslab[[iexp]], `p-value`=zpval[seq_along(jx_f$reslab[[iexp]])]))
      names(resid[["labeled data"]])=nm_exp
   
      if (case_i) {
         resid[["labeled data p-value"]]=vector("list", nb_exp)
         names(resid[["labeled data p-value"]])=nm_exp
         for (iexp in seq_len(nb_exp)) {
            mtmp=zpval[seq_along(jx_f$reslab[[iexp]])]
            dim(mtmp)=dim(jx_f$reslab[[iexp]])
            dimnames(mtmp)=dimnames(jx_f$reslab[[iexp]])
            resid[["labeled data p-value"]][[iexp]]=mtmp
            rm(mtmp)
         }
      }
   }
   nb_reslab_tot=sum(sapply(jx_f$reslab, length))
   if (length(jx_f$resflu))
      resid[["measured fluxes"]]=cbind(residual=jx_f$resflu, `p-value`=zpval[nb_reslab_tot+seq_along(jx_f$resflu)])
   if (length(jx_f$respool))
      resid[["measured pools"]]=cbind(residual=if (is.matrix(jx_f$respool)) jx_f$respool[,1] else jx_f$respool, `p-value`=zpval[nb_reslab_tot+length(jx_f$resflu)+seq_along(jx_f$respool)])
   obj2kvh(resid, "(simulated-measured)/sd_exp", fkvh)
   rm(resid, zpval)

   # simulated measurements -> kvh
   simul=list()
#browser()
   if (case_i) {
      if (sum(nb_meas)) {
         if (addnoise) {
            simul[["labeled data"]]=lapply(seq_len(nb_exp), function(iexp) jx_f$usm[[iexp]]+rnorm(length(jx_f$usm[[iexp]]))*measurements$dev$labeled[[iexp]])
            names(simul[["labeled data"]])=nm_exp
         } else {
            simul[["labeled data"]]=jx_f$usm
         }
      }
   } else {
      if (sum(nb_meas)) {
         if (addnoise) {
            simlab=lapply(seq_len(nb_exp), function(iexp) jx_f$simlab[[iexp]]+rnorm(length(jx_f$simlab[[iexp]]))*measurements$dev$labeled[[iexp]])
            names(simlab)=nm_exp
         } else {
            simlab=jx_f$simlab
         }
         if (nb_sc_tot > 0) {
            simul[["labeled data (unscaled)"]]=jx_f$usimlab
            simul[["labeled data (scaled)"]]=simlab
         } else {
            simul[["labeled data"]]=simlab
         }
      }
   }
   if (nb_fmn) {
      if (addnoise)
         simul[["measured fluxes"]]=jx_f$simfmn+rnorm(length(jx_f$simfm))*measurements$dev$flux
      else
         simul[["measured fluxes"]]=jx_f$simfmn
   }
   if (nb_poolm) {
      if (addnoise)
         simul[["measured pools"]]=jx_f$simpool+rnorm(length(jx_f$simpool))*measurements$dev$pool
      else
         simul[["measured pools"]]=jx_f$simpool
   }
   obj2kvh(simul, "simulated measurements", fkvh)
   
   # SD -> kvh
   # get index of non null components
   iget=sapply(names(measurements$dev), function(nm) !is.null(measurements$dev[[nm]]) & nm %in% c("labeled", "flux", "pool"))
   obj2kvh(measurements$dev[iget], "measurement SD", fkvh)

   # gradient -> kvh
   if (length(jx_f$res) && !all(ina <- is.na(jx_f$res))) {
      if (any(ina)) {
         gr=2*as.numeric(crossprod(jx_f$res[!ina], jx_f$jacobian[!ina,,drop=FALSE]))
      } else {
         gr=2*as.numeric(crossprod(jx_f$res, jx_f$jacobian))
      }
      names(gr)=nm_par
      obj2kvh(gr, "gradient vector", fkvh)
   }
   colnames(jx_f$udr_dp)=nm_par
   obj2kvh(jx_f$udr_dp, "jacobian dr_dp (without 1/sd_exp)", fkvh)
   # generalized inverse of non reduced jacobian
   svj=svd(jx_f$udr_dp)
   invj=svj$v%*%(t(svj$u)/svj$d)
   dimnames(invj)=rev(dimnames(jx_f$udr_dp))
   obj2kvh(invj, "generalized inverse of jacobian dr_dp (without 1/sd_exp)", fkvh)

   labargs$getx=TRUE
   labargs$labargs2getx=TRUE
   if (fullsys) {
      nm_flist=nm_list
      nm_flist$rcumo=nm_cumo
      nm_flist$rcumo_in_cumo=match(nm_rcumo, nm_cumo)
      nb_f$cumos=nb_cumos
      nm_xi_f=c()
      xi_f=matrix(c(), ncol=nb_exp)
      dimnames(xi_f)[[1]]=nm_xi_f
      nm_flist$xi=nm_xi_f
      labargs$emu=F
      v=lab_sim(param, cjac=FALSE, labargs)
      labargs$emu=emu
      x=if (case_i) v$xf else v$x
   } else {
      v=lab_sim(param, cjac=FALSE, labargs)
      x=if (case_i) v$xf else v$x
   }

   # write some info in result kvh
   mid=cumo2mass(x)
   if (case_i) {
      mid=lapply(mid, function(m) m[sort(rownames(m)),,drop=FALSE])
   } else if (length(mid)) {
      mid=mid[sort(rownames(mid)),,drop=FALSE]
   }
   obj2kvh(mid, "MID vector", fkvh)
   
   # constrained fluxes to kvh
   obj2kvh(fallnx[nm_fc], "constrained net-xch01 fluxes", fkvh)

   fwrv=v$lf$fwrv
   fallnx=v$lf$fallnx
   flnx=v$lf$flnx
   fgr=fallnx[nm_fgr]

   # keep last jx_f in jx_f_last
#browser()
   while (sensitive=="mc") {
      if (TIMEIT) {
         cat("monte-ca: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
      }
      if (set_seed) {
         set.seed(seed)
      }
      # reference simulation corresponding to the final param
      refsim=new.env()
      for (nm_it in c("simlab", "simfmn", "simpool", "usm")) {
         assign(nm_it, jx_f[[nm_it]], envir=refsim)
      }
      # Monte-Carlo simulation in parallel way (if asked and possible)
      if (np > 1L) {
         spli=splitIndices(nmc, nodes);
         clusterExport(cl, c("param", "refsim", "runsuf", "spli"))
         #clusterEvalQ(cl, labargs$spa[[1]]$a <- NULL) # to rebuild sparse matrices on cores ## now, they are build once, at the cluster init
         cl_res=clusterEvalQ(cl, {mc_iter=TRUE; labargs$getx=FALSE; mc_res=lapply(spli[[idw]], mc_sim); rm(mc_iter); mc_res})
         mc_res=vector(nmc, mode="list")
         for (i in seq(nodes))
            mc_res[spli[[i]]]=cl_res[[i]]
         #mc_res=parLapplyLB(cl, seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      } else {
         mc_res=lapply(seq_len(nmc), function(imc) cl_worker(funth=mc_sim, argth=list(imc)))
      }
      free_mc=sapply(mc_res, function(l) {if (class(l)=="character" || is.null(l) || is.na(l$cost) || l$err) { ret=rep(NA, nb_param+3) } else { ret=c(l$cost, l$it, l$normp, l$par) }; ret })
      if (length(free_mc)==0) {
         cat("Parallel exectution of Monte-Carlo simulations has failed.", "\n", sep="", file=fcerr)
         free_mc=matrix(NA, nb_param+2, 0)
      }
      cost_mc=free_mc[1,]
      nmc_real=nmc-sum(is.na(free_mc[4,]))
      cat("monte-carlo\n", file=fkvh)
      indent=1
      obj2kvh(cl_type, "cluster type", fkvh, indent)
      obj2kvh(avaco, "detected cores", fkvh, indent)
      avaco=max(1, avaco, na.rm=T)
      obj2kvh(min(avaco, np, na.rm=T), "used cores", fkvh, indent)
      cat("\tfitting samples\n", file=fkvh)
      indent=2
      obj2kvh(nmc, "requested number", fkvh, indent)
      obj2kvh(nmc_real, "calculated number", fkvh, indent)
      obj2kvh(nmc-nmc_real, "failed to calculate", fkvh, indent)
      # convergence section in kvh
      indent=1
      mout=rbind(round(free_mc[1:2,,drop=FALSE], 2),
         format(free_mc[3,,drop=FALSE], di=2, sci=T))
      dimnames(mout)=list(c("cost", "it.numb", "normp"), seq_len(ncol(free_mc)))
      obj2kvh(mout, "convergence per sample", fkvh, indent)
      # remove failed m-c iterations
      free_mc=free_mc[-(1:3),,drop=FALSE]
      ifa=which(is.na(free_mc[1,]))
      if (length(ifa)) {
         if (ncol(free_mc) > length(ifa)) {
            cat("Some Monte-Carlo iterations failed.", "\n", sep="", file=fcerr)
         }
         free_mc=free_mc[,-ifa,drop=FALSE]
         cost_mc=cost_mc[-ifa]
      }
      if (nmc_real <= 1) {
         cat("No sufficient Monter-Carlo samples were successfully calculated to do any statistics.", "\n", sep="", file=fcerr)
         retcode[irun]=1
         break
      }
#browser()
      rownames(free_mc)=nm_par
      
      # cost section in kvh
      cat("\tcost\n", file=fkvh)
      indent=2
      obj2kvh(mean(cost_mc), "mean", fkvh, indent)
      obj2kvh(median(cost_mc), "median", fkvh, indent)
      obj2kvh(sd(cost_mc), "sd", fkvh, indent)
      obj2kvh(sd(cost_mc)*100/mean(cost_mc), "rsd (%)", fkvh, indent)
      obj2kvh(quantile(cost_mc, c(0.025, 0.95, 0.975)), "ci", fkvh, indent)
      
      # free parameters section in kvh
      cat("\tStatistics\n", file=fkvh)
      mout=c()
      indent=2
      # param stats
      # mean
      parmean=apply(free_mc, 1, mean)
      # median
      parmed=apply(free_mc, 1, median)
#browser()
      # covariance matrix
      covmc=cov(t(free_mc))
      obj2kvh(covmc, "covariance", fkvh, indent)
      # sd
      sdmc=sqrt(diag(covmc))
      # confidence intervals
      ci_mc=t(apply(free_mc, 1, quantile, probs=c(0.025, 0.975)))
      ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
      colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI length")
      mout=cbind(mout, mean=parmean, median=parmed, sd=sdmc,
         "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
      obj2kvh(mout, "free parameters", fkvh, indent)

      # net-xch01 stats
      fallnx_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fallnx)
      fallnx=param2fl(param, labargs)$fallnx
      if (length(fallnx_mc)) {
         dimnames(fallnx_mc)[[1]]=nm_fallnx
         # form a matrix output
         fallout=matrix(0, nrow=nrow(fallnx_mc), ncol=0)
         # mean
#browser()
         parmean=apply(fallnx_mc, 1, mean)
         # median
         parmed=apply(fallnx_mc, 1, median)
         # covariance matrix
         covmc=cov(t(fallnx_mc))
         dimnames(covmc)=list(nm_fallnx, nm_fallnx)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(fallnx_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         ci_mc=cbind(ci_mc, ci_mc[,3]*100/abs(parmean))
         colnames(ci_mc)=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
         fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(fallnx), ci_mc)
         o=order(nm_fallnx)
         obj2kvh(fallout[o,,drop=FALSE], "all net-xch01 fluxes", fkvh, indent)
         obj2kvh(covmc[o,o], "covariance of all net-xch01 fluxes", fkvh, indent)

         # fwd-rev stats
         fwrv_mc=apply(free_mc, 2, function(p)param2fl(p, labargs)$fwrv)
         dimnames(fwrv_mc)[[1]]=nm_fwrv
         fallout=matrix(0, nrow=nrow(fwrv_mc), ncol=0)
         # mean
         parmean=apply(fwrv_mc, 1, mean)
         # median
         parmed=apply(fwrv_mc, 1, median)
         # covariance matrix
         covmc=cov(t(fwrv_mc))
         dimnames(covmc)=list(nm_fwrv, nm_fwrv)
         # sd
         sdmc=sqrt(diag(covmc))
         # confidence intervals
         ci_mc=t(apply(fwrv_mc, 1, quantile, probs=c(0.025, 0.975)))
         ci_mc=cbind(ci_mc, t(diff(t(ci_mc))))
         ci_mc=cbind(ci_mc, ci_mc[,3]*100/abs(fwrv))
         dimnames(ci_mc)[[2]]=c("CI 2.5%", "CI 97.5%", "CI 95% length", "relative CI (%)")
         fallout=cbind(fallout, mean=parmean, median=parmed, sd=sdmc,
            "rsd (%)"=sdmc*100/abs(parmean), ci_mc)
         o=order(nm_fwrv)
         obj2kvh(fallout[o,,drop=FALSE], "forward-reverse fluxes", fkvh, indent)
         obj2kvh(covmc[o,o], "covariance of forward-reverse fluxes", fkvh, indent)
      }
      break
   }
#browser()
   if (length(sensitive) && nchar(sensitive) && sensitive != "mc") {
      cat(paste("Unknown sensitivity '", sensitive, "' method chosen.", sep=""), "\n", sep="", file=fcerr)
      retcode[irun]=1
   }

   if (TIMEIT) {
      cat("linstats: ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
   }
   # Linear method based on jacobian x_f
   # reset fluxes and jacobians according to param
   if (is.null(jx_f$jacobian)) {
      capture.output(rres <- lab_resid(param, cjac=TRUE, labargs), file=fclog)
      if (!is.null(rres$err) && rres$err) {
         cat("lab_resid", runsuf, ": ", rres$mes, "\n", file=fcerr, sep="")
         close(fkvh)
         retcode[irun]=rres$err
         next
      }
   } # else use the last calculated jacobian

   # covariance matrix of free fluxes
   svj=svd(jx_f$jacobian)
   if (svj$d[1] == 0.) {
      i=rep(TRUE, length(svj$d))
   } else {
      i=svj$d/svj$d[1]<1.e-10
      if (all(!i) && svj$d[1]<1.e-10) {
         # we could not find very small d, take just the last
         i[length(i)]=TRUE
      }
   }
   ibad=apply(svj$v[, i, drop=FALSE], 2, which.contrib)
   ibad=unique(unlist(ibad))
   if (length(ibad) > 0) {
      cat(paste(if (nchar(runsuf)) runsuf%s+%": " else "", "Inverse of covariance matrix is numerically singular.\nStatistically undefined parameter(s) seems to be:\n",
         paste(sort(nm_par[ibad]), collapse="\n"), "\nFor more complete list, see sd columns in '/linear stats'\nin the result file.", sep=""), "\n", sep="", file=fcerr)
   }
   # "square root" of covariance matrix (to preserve numerical positive definitness)
   rtcov=(svj$u)%*%(t(svj$v)/svj$d)
   # standart deviations of free fluxes
   cat("linear stats\n", file=fkvh)

   # sd free+dependent+growth net-xch01 fluxes
   nm_flfd=c(nm_ff, nm_fgr, nm_fl)
   if (nb_ff > 0 || nb_fgr > 0) {
      i=1:nb_param
      i=c(head(i, nb_ff), tail(i, nb_fgr))
      covfl=crossprod(rtcov[, i, drop=FALSE]%mmt%(rbind(diag(nb_ff+nb_fgr), dfl_dffg)%mrv%c(rep.int(1., nb_ff), fgr)))
      dimnames(covfl)=list(nm_flfd, nm_flfd)
      sdfl=sqrt(diag(covfl))
   } else {
      sdfl=rep(0., nb_fl)
      covfl=matrix(0., nb_fl, nb_fl)
   }
   fl=c(head(param, nb_ff), fgr, flnx)
   stats_nx=cbind("value"=fl, "sd"=sdfl, "rsd"=sdfl/abs(fl))
   rownames(stats_nx)=nm_flfd
   o=order(nm_flfd)
   obj2kvh(stats_nx[o,,drop=FALSE], "net-xch01 fluxes (sorted by name)", fkvh, indent=1)
   obj2kvh(covfl[o, o], "covariance net-xch01 fluxes", fkvh, indent=1)

   # sd of all fwd-rev
   if (nb_ff > 0 || nb_fgr > 0) {
      i=1:nb_param
      i=c(head(i, nb_ff), tail(i, nb_fgr))
      covf=crossprod(tcrossprod_simple_triplet_matrix(rtcov[,i, drop=FALSE], jx_f$df_dffp%mrv%c(rep.int(1., nb_ff), head(poolall[nm_poolf], nb_fgr))))
      dimnames(covf)=list(nm_fwrv, nm_fwrv)
      sdf=sqrt(diag(covf))
   } else {
      sdf=rep(0., length(fwrv))
   }
   mtmp=cbind(fwrv, sdf, sdf/abs(fwrv))
   dimnames(mtmp)[[2]]=c("value", "sd", "rsd")
   o=order(nm_fwrv)
   obj2kvh(mtmp[o,], "fwd-rev fluxes (sorted by name)", fkvh, indent=1)
   if (nb_ff > 0 || nb_fgr > 0) {
      obj2kvh(covf, "covariance fwd-rev fluxes", fkvh, indent=1)
   }
   # pool -> kvh
   sdpf=poolall
   sdpf[]=0.

   if (nb_poolf > 0) {
      # covariance matrix of free pools
      # "square root" of covariance matrix (to preserve numerical positive definitness)
      poolall[nm_poolf]=param[nm_poolf]
      # cov poolf
      covpf=crossprod(rtcov[,nb_ff+nb_sc_tot+seq_len(nb_poolf), drop=FALSE])
      dimnames(covpf)=list(nm_poolf, nm_poolf)
      sdpf[nm_poolf]=sqrt(diag(covpf))
   }
   if (length(poolall) > 0) {
      mtmp=cbind("value"=poolall, "sd"=sdpf, "rsd"=sdpf/poolall)
      rownames(mtmp)=nm_poolall
      o=order(nm_poolall)
      obj2kvh(mtmp[o,,drop=FALSE], "metabolite pools (sorted by name)", fkvh, indent=1)
      if (nb_poolf > 0) {
         o=order(nm_poolf)
         obj2kvh(covpf[o, o], "covariance free pools", fkvh, indent=1)
      }
   }

   # khi2 test for goodness of fit
   # goodness of fit (khi2 test)
   if (length(jx_f$res)) {
      nvres=sum(!is.na(jx_f$res))
      if (nvres >= nb_param) {
         khi2test=list("khi2 value"=rcost, "data points"=nvres,
            "fitted parameters"=nb_param, "degrees of freedom"=nvres-nb_param)
         khi2test$`khi2 reduced value`=khi2test$`khi2 value`/khi2test$`degrees of freedom`
         khi2test$`p-value, i.e. P(X^2<=value)`=pchisq(khi2test$`khi2 value`, df=khi2test$`degrees of freedom`)
         khi2test$conclusion=if (khi2test$`p-value, i.e. P(X^2<=value)` > 0.95) "At level of 95% confidence, the model does not fit the data good enough with respect to the provided measurement SD" else "At level of 95% confidence, the model fits the data good enough with respect to the provided measurement SD"
         obj2kvh(khi2test, "goodness of fit (khi2 test)", fkvh, indent=1)
      } else {
         cat(sprintf("khi2: Measurement number %d is lower than parameter number %d. Khi2 test cannot be done.\n", nvres, nb_param), sep="", file=fcerr)
      }
   }
   if (prof) {
      Rprof(NULL)
   }
   close(fkvh)
   # write edge.netflux property
   fedge=file(file.path(dirw, sprintf("edge.netflux.%s%s.attrs", baseshort,  runsuf)), "w")
   cat("netflux (class=Double)\n", sep="", file=fedge)
   nm_edge=names(edge2fl)
   cat(paste(nm_edge, fallnx[edge2fl], sep=" = "), sep="\n" , file=fedge)
   close(fedge)

   # write edge.xchflux property
   fedge=file(file.path(dirw, sprintf("edge.xchflux.%s%s.attrs", baseshort,  runsuf)), "w")
   flxch=paste(".x", substring(edge2fl, 4), sep="")
   ifl=charmatch(flxch, substring(names(fallnx), 2))
   cat("xchflux (class=Double)\n", sep="", file=fedge)
   cat(paste(nm_edge, fallnx[ifl], sep=" = "), sep="\n" , file=fedge)
   close(fedge)

   # write node.log2pool property
   if (length(poolall)> 0) {
      fnode=file(file.path(dirw, sprintf("edge.xchflux.%s%s.attrs", baseshort,  runsuf)), "w")
      cat("log2pool (class=Double)\n", sep="", file=fnode)
      nm_node=substring(names(poolall), 4)
      cat(paste(nm_node, log2(poolall), sep=" = "), sep="\n" , file=fnode)
      close(fnode)
   }
}
if (!is.null(cl)) {
   stopCluster(cl)
   labargs$cl=cl=NULL
}

pres=rbind(cost=costres, pres)
fco=file(file.path(dirw, sprintf("%s.pres.csv", baseshort)), open="w")
cat("row_col	", file=fco)
write.table(file=fco, pres, row.n=T, quot=F, sep="\t")
close(fco)
if (TIMEIT) {
   cat("rend    : ", format(Sys.time()), " cpu=", proc.time()[1], "\n", sep="", file=fclog)
}

# source files from FTBL/posttreat_R
postlist=strsplit("save_all.R; plot_imass.R", " *; *")[[1]]
for (post in postlist) {
   fpostR=file.path(dirw, post)
   if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
      source(fpostR)
   } else {
      # not found in 'dirw', try 'dirr'
      fpostR=file.path(dirr, post)
      if (file.exists(fpostR) && !isTRUE(file.info(fpostR)$isdir)) {
         source(fpostR)
      } else {
         cat(sprintf("Posttreatment R file '%s' does not exist in ftbl directory neither in influx_si one. Ignored.\n", post), file=fcerr)
      }
   }
}
xgc=gc(verbose=FALSE) # to avoid the message "Error in (function (x)  : tentative d'appliquer un objet qui n'est pas une fonction"
close(fclog)
close(fcerr)
retcode=max(retcode)
if (format(parent.frame()) == format(.GlobalEnv)) {
   q("no", status=retcode)
}
