"""Constants for the Multilevel Sensor CC."""

# ----------------------------------------------------------------------------------- #
# **BEGINNING OF AUTOGENERATED CONTENT** (TO ADD ADDITIONAL MANUAL CONTENT, LOOK FOR  #
# THE "END OF AUTOGENERATED CONTENT" COMMENT BLOCK AND ADD YOUR CODE BELOW IT)        #
# ----------------------------------------------------------------------------------- #

from __future__ import annotations

from enum import IntEnum

CC_SPECIFIC_SCALE = "scale"
CC_SPECIFIC_SENSOR_TYPE = "sensorType"

ACCELERATION_X_AXIS_PROPERTY = "Acceleration X-axis"
ACCELERATION_Y_AXIS_PROPERTY = "Acceleration Y-axis"
ACCELERATION_Z_AXIS_PROPERTY = "Acceleration Z-axis"
AIR_FLOW_PROPERTY = "Air flow"
AIR_TEMPERATURE_PROPERTY = "Air temperature"
AMMONIA_PROPERTY = "Ammonia"
ANGLE_POSITION_PROPERTY = "Angle position"
APPLIED_FORCE_ON_THE_SENSOR_PROPERTY = "Applied force on the sensor"
ATMOSPHERIC_PRESSURE_PROPERTY = "Atmospheric pressure"
BAROMETRIC_PRESSURE_PROPERTY = "Barometric pressure"
BASIS_METABOLIC_RATE_PROPERTY = "Basis metabolic rate (BMR)"
BLOOD_PRESSURE_PROPERTY = "Blood pressure"
BODY_MASS_INDEX_PROPERTY = "Body Mass Index (BMI)"
BOILER_WATER_TEMPERATURE_PROPERTY = "Boiler water temperature"
BONE_MASS_PROPERTY = "Bone mass"
CARBON_DIOXIDE_LEVEL_PROPERTY = "Carbon dioxide (CO₂) level"
CARBON_MONOXIDE_LEVEL_PROPERTY = "Carbon monoxide (CO) level"
CONDENSER_COIL_TEMPERATURE_PROPERTY = "Condenser Coil temperature"
CURRENT_PROPERTY = "Current"
DEFROST_TEMPERATURE_PROPERTY = "Defrost temperature"
DEW_POINT_PROPERTY = "Dew point"
DIRECTION_PROPERTY = "Direction"
DISCHARGE_LINE_TEMPERATURE_PROPERTY = "Discharge Line temperature"
DISCHARGE_PRESSURE_PROPERTY = "Discharge Pressure"
DISTANCE_PROPERTY = "Distance"
DOMESTIC_HOT_WATER_TEMPERATURE_PROPERTY = "Domestic Hot Water (DHW) temperature"
ELECTRICAL_CONDUCTIVITY_PROPERTY = "Electrical conductivity"
ELECTRICAL_RESISTIVITY_PROPERTY = "Electrical resistivity"
EVAPORATOR_COIL_TEMPERATURE_PROPERTY = "Evaporator Coil temperature"
EXHAUST_TEMPERATURE_PROPERTY = "Exhaust temperature"
FAT_MASS_PROPERTY = "Fat mass"
FORMALDEHYDE_LEVEL_PROPERTY = "Formaldehyde (CH₂O) level"
FREQUENCY_PROPERTY = "Frequency"
GENERAL_PURPOSE_PROPERTY = "General purpose"
HEART_RATE_PROPERTY = "Heart rate"
HEART_RATE_LF_HF_RATIO_PROPERTY = "Heart Rate LF/HF ratio"
HUMIDITY_PROPERTY = "Humidity"
ILLUMINANCE_PROPERTY = "Illuminance"
LEAD_PROPERTY = "Lead"
LIQUID_LINE_TEMPERATURE_PROPERTY = "Liquid Line temperature"
LOUDNESS_PROPERTY = "Loudness"
METHANE_DENSITY_PROPERTY = "Methane (CH₄) density"
MOISTURE_PROPERTY = "Moisture"
MOTION_DIRECTION_PROPERTY = "Motion Direction"
MUSCLE_MASS_PROPERTY = "Muscle mass"
NITROGEN_DIOXIDE_PROPERTY = "Nitrogen dioxide"
OUTSIDE_TEMPERATURE_PROPERTY = "Outside temperature"
OZONE_PROPERTY = "Ozone"
PARTICULATE_MATTER_1_PROPERTY = "Particulate Matter 1"
PARTICULATE_MATTER_10_PROPERTY = "Particulate Matter 10"
PARTICULATE_MATTER_2_5_PROPERTY = "Particulate Matter 2.5"
PERSON_COUNTER_ENTERING_PROPERTY = "Person counter (entering)"
PERSON_COUNTER_EXITING_PROPERTY = "Person counter (exiting)"
POWER_PROPERTY = "Power"
RADON_CONCENTRATION_PROPERTY = "Radon concentration"
RAIN_RATE_PROPERTY = "Rain rate"
RELATIVE_MODULATION_LEVEL_PROPERTY = "Relative Modulation level"
RESPIRATORY_RATE_PROPERTY = "Respiratory rate"
RETURN_AIR_TEMPERATURE_PROPERTY = "Return Air temperature"
RF_SIGNAL_STRENGTH_PROPERTY = "RF signal strength"
ROTATION_PROPERTY = "Rotation"
SEISMIC_INTENSITY_PROPERTY = "Seismic Intensity"
SEISMIC_MAGNITUDE_PROPERTY = "Seismic magnitude"
SMOKE_DENSITY_PROPERTY = "Smoke density"
SOIL_HUMIDITY_PROPERTY = "Soil humidity"
SOIL_REACTIVITY_PROPERTY = "Soil reactivity"
SOIL_SALINITY_PROPERTY = "Soil salinity"
SOIL_TEMPERATURE_PROPERTY = "Soil temperature"
SOLAR_RADIATION_PROPERTY = "Solar radiation"
SUCTION_PRESSURE_PROPERTY = "Suction Pressure"
SULFUR_DIOXIDE_PROPERTY = "Sulfur dioxide"
SUPPLY_AIR_TEMPERATURE_PROPERTY = "Supply Air temperature"
TANK_CAPACITY_PROPERTY = "Tank capacity"
TARGET_TEMPERATURE_PROPERTY = "Target temperature"
TIDE_LEVEL_PROPERTY = "Tide level"
TIME_PROPERTY = "Time"
TOTAL_BODY_WATER_PROPERTY = "Total body water (TBW)"
ULTRAVIOLET_PROPERTY = "Ultraviolet"
VELOCITY_PROPERTY = "Velocity"
VOLATILE_ORGANIC_COMPOUND_LEVEL_PROPERTY = "Volatile Organic Compound level"
VOLTAGE_PROPERTY = "Voltage"
WATER_ACIDITY_PROPERTY = "Water acidity"
WATER_CHLORINE_LEVEL_PROPERTY = "Water Chlorine level"
WATER_FLOW_PROPERTY = "Water flow"
WATER_OXIDATION_REDUCTION_POTENTIAL_PROPERTY = "Water Oxidation reduction potential"
WATER_PRESSURE_PROPERTY = "Water pressure"
WATER_TEMPERATURE_PROPERTY = "Water temperature"
WEIGHT_PROPERTY = "Weight"


class MultilevelSensorType(IntEnum):
    """Enum for known multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    ACCELERATION_X_AXIS = 52
    ACCELERATION_Y_AXIS = 53
    ACCELERATION_Z_AXIS = 54
    AIR_FLOW = 18
    AIR_TEMPERATURE = 1
    AMMONIA = 84
    ANGLE_POSITION = 21
    APPLIED_FORCE_ON_THE_SENSOR = 71
    ATMOSPHERIC_PRESSURE = 8
    BAROMETRIC_PRESSURE = 9
    BASIS_METABOLIC_RATE = 50
    BLOOD_PRESSURE = 45
    BODY_MASS_INDEX = 51
    BOILER_WATER_TEMPERATURE = 62
    BONE_MASS = 48
    CARBON_DIOXIDE_LEVEL = 17
    CARBON_MONOXIDE_LEVEL = 40
    CONDENSER_COIL_TEMPERATURE = 74
    CURRENT = 16
    DEFROST_TEMPERATURE = 80
    DEW_POINT = 11
    DIRECTION = 7
    DISCHARGE_LINE_TEMPERATURE = 77
    DISCHARGE_PRESSURE = 79
    DISTANCE = 20
    DOMESTIC_HOT_WATER_TEMPERATURE = 63
    ELECTRICAL_CONDUCTIVITY = 29
    ELECTRICAL_RESISTIVITY = 28
    EVAPORATOR_COIL_TEMPERATURE = 75
    EXHAUST_TEMPERATURE = 65
    FAT_MASS = 47
    FORMALDEHYDE_LEVEL = 36
    FREQUENCY = 32
    GENERAL_PURPOSE = 2
    HEART_RATE = 44
    HEART_RATE_LF_HF_RATIO = 69
    HUMIDITY = 5
    ILLUMINANCE = 3
    LEAD = 85
    LIQUID_LINE_TEMPERATURE = 76
    LOUDNESS = 30
    METHANE_DENSITY = 38
    MOISTURE = 31
    MOTION_DIRECTION = 70
    MUSCLE_MASS = 46
    NITROGEN_DIOXIDE = 83
    OUTSIDE_TEMPERATURE = 64
    OZONE = 81
    PARTICULATE_MATTER_1 = 86
    PARTICULATE_MATTER_10 = 59
    PARTICULATE_MATTER_2_5 = 35
    PERSON_COUNTER_ENTERING = 87
    PERSON_COUNTER_EXITING = 88
    POWER = 4
    RADON_CONCENTRATION = 37
    RAIN_RATE = 12
    RELATIVE_MODULATION_LEVEL = 61
    RESPIRATORY_RATE = 60
    RETURN_AIR_TEMPERATURE = 72
    RF_SIGNAL_STRENGTH = 58
    ROTATION = 22
    SEISMIC_INTENSITY = 25
    SEISMIC_MAGNITUDE = 26
    SMOKE_DENSITY = 55
    SOIL_HUMIDITY = 41
    SOIL_REACTIVITY = 42
    SOIL_SALINITY = 43
    SOIL_TEMPERATURE = 24
    SOLAR_RADIATION = 10
    SUCTION_PRESSURE = 78
    SULFUR_DIOXIDE = 82
    SUPPLY_AIR_TEMPERATURE = 73
    TANK_CAPACITY = 19
    TARGET_TEMPERATURE = 34
    TIDE_LEVEL = 13
    TIME = 33
    TOTAL_BODY_WATER = 49
    ULTRAVIOLET = 27
    VELOCITY = 6
    VOLATILE_ORGANIC_COMPOUND_LEVEL = 39
    VOLTAGE = 15
    WATER_ACIDITY = 67
    WATER_CHLORINE_LEVEL = 66
    WATER_FLOW = 56
    WATER_OXIDATION_REDUCTION_POTENTIAL = 68
    WATER_PRESSURE = 57
    WATER_TEMPERATURE = 23
    WEIGHT = 14


class MultilevelSensorScaleType(IntEnum):
    """Common base class for multilevel sensor scale enums."""


class AirFlowScale(MultilevelSensorScaleType):
    """Enum for known scales for AIR_FLOW multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    CUBIC_FEET_PER_MINUTE = 1
    CUBIC_METER_PER_HOUR = 0


class AnglePositionScale(MultilevelSensorScaleType):
    """Enum for known scales for ANGLE_POSITION multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    DEGREES_RELATIVE_TO_NORTH_POLE_OF_STANDING_EYE_VIEW = 1
    DEGREES_RELATIVE_TO_SOUTH_POLE_OF_STANDING_EYE_VIEW = 2
    PERCENTAGE_VALUE = 0


class AppliedForceOnTheSensorScale(MultilevelSensorScaleType):
    """Enum for known scales for APPLIED_FORCE_ON_THE_SENSOR multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    NEWTON = 0


class AccelerationScale(MultilevelSensorScaleType):
    """Enum for known scales for Acceleration multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    METER_PER_SQUARE_SECOND = 0


class AcidityScale(MultilevelSensorScaleType):
    """Enum for known scales for Acidity multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    ACIDITY = 0


class AirPressureScale(MultilevelSensorScaleType):
    """Enum for known scales for Air Pressure multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    INCHES_OF_MERCURY = 1
    KILOPASCAL = 0


class BasisMetabolicRateScale(MultilevelSensorScaleType):
    """Enum for known scales for BASIS_METABOLIC_RATE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    JOULE = 0


class BloodPressureScale(MultilevelSensorScaleType):
    """Enum for known scales for BLOOD_PRESSURE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    DIASTOLIC = 1
    SYSTOLIC = 0


class BodyMassIndexScale(MultilevelSensorScaleType):
    """Enum for known scales for BODY_MASS_INDEX multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    BODY_MASS_INDEX = 0


class CarbonDioxideLevelScale(MultilevelSensorScaleType):
    """Enum for known scales for CARBON_DIOXIDE_LEVEL multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    PARTS_MILLION = 0


class CarbonMonoxideLevelScale(MultilevelSensorScaleType):
    """Enum for known scales for CARBON_MONOXIDE_LEVEL multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MOLE_PER_CUBIC_METER = 0
    PARTS_MILLION = 1


class CurrentScale(MultilevelSensorScaleType):
    """Enum for known scales for CURRENT multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    AMPERE = 0
    MILLIAMPERE = 1


class DistanceScale(MultilevelSensorScaleType):
    """Enum for known scales for DISTANCE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    CENTIMETER = 1
    FEET = 2
    METER = 0


class DensityScale(MultilevelSensorScaleType):
    """Enum for known scales for Density multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    DENSITY = 0


class DirectionScale(MultilevelSensorScaleType):
    """Enum for known scales for Direction multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    DEGREES = 0


class ElectricalConductivityScale(MultilevelSensorScaleType):
    """Enum for known scales for ELECTRICAL_CONDUCTIVITY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    SIEMENS_PER_METER = 0


class ElectricalResistivityScale(MultilevelSensorScaleType):
    """Enum for known scales for ELECTRICAL_RESISTIVITY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    OHM_METER = 0


class FormaldehydeLevelScale(MultilevelSensorScaleType):
    """Enum for known scales for FORMALDEHYDE_LEVEL multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MOLE_PER_CUBIC_METER = 0


class FrequencyScale(MultilevelSensorScaleType):
    """Enum for known scales for FREQUENCY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    HERTZ = 0
    KILOHERTZ = 1


class GeneralPurposeScale(MultilevelSensorScaleType):
    """Enum for known scales for GENERAL_PURPOSE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    DIMENSIONLESS_VALUE = 1
    PERCENTAGE_VALUE = 0


class HeartRateScale(MultilevelSensorScaleType):
    """Enum for known scales for HEART_RATE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    BEATS_PER_MINUTE = 0


class HumidityScale(MultilevelSensorScaleType):
    """Enum for known scales for Humidity multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    ABSOLUTE_HUMIDITY = 1
    PERCENTAGE_VALUE = 0


class IlluminanceScale(MultilevelSensorScaleType):
    """Enum for known scales for ILLUMINANCE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    LUX = 1
    PERCENTAGE_VALUE = 0


class LoudnessScale(MultilevelSensorScaleType):
    """Enum for known scales for LOUDNESS multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    A_WEIGHTED_DECIBELS = 1
    DECIBEL = 0


class MethaneDensityScale(MultilevelSensorScaleType):
    """Enum for known scales for METHANE_DENSITY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MOLE_PER_CUBIC_METER = 0


class MoistureScale(MultilevelSensorScaleType):
    """Enum for known scales for MOISTURE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    IMPEDANCE = 2
    PERCENTAGE_VALUE = 0
    VOLUME_WATER_CONTENT = 1
    WATER_ACTIVITY = 3


class MassScale(MultilevelSensorScaleType):
    """Enum for known scales for Mass multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    KILOGRAM = 0


class ParticulateMatter10Scale(MultilevelSensorScaleType):
    """Enum for known scales for PARTICULATE_MATTER_10 multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MICROGRAM_PER_CUBIC_METER = 1
    MOLE_PER_CUBIC_METER = 0


class ParticulateMatter25Scale(MultilevelSensorScaleType):
    """Enum for known scales for PARTICULATE_MATTER_2_5 multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MICROGRAM_PER_CUBIC_METER = 1
    MOLE_PER_CUBIC_METER = 0


class PowerScale(MultilevelSensorScaleType):
    """Enum for known scales for POWER multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    BTU_H = 1
    WATT = 0


class PercentageScale(MultilevelSensorScaleType):
    """Enum for known scales for Percentage multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    PERCENTAGE_VALUE = 0


class PressureScale(MultilevelSensorScaleType):
    """Enum for known scales for Pressure multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    KILOPASCAL = 0
    POUND_PER_SQUARE_INCH = 1


class RadonConcentrationScale(MultilevelSensorScaleType):
    """Enum for known scales for RADON_CONCENTRATION multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    BECQUEREL_PER_CUBIC_METER = 0
    PICOCURIES_PER_LITER = 1


class RainRateScale(MultilevelSensorScaleType):
    """Enum for known scales for RAIN_RATE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    INCHES_PER_HOUR = 1
    MILLIMETER_HOUR = 0


class RespiratoryRateScale(MultilevelSensorScaleType):
    """Enum for known scales for RESPIRATORY_RATE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    BREATHS_PER_MINUTE = 0


class RfSignalStrengthScale(MultilevelSensorScaleType):
    """Enum for known scales for RF_SIGNAL_STRENGTH multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    POWER_LEVEL = 1
    RSSI = 0


class RotationScale(MultilevelSensorScaleType):
    """Enum for known scales for ROTATION multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    HERTZ = 1
    REVOLUTIONS_PER_MINUTE = 0


class SeismicIntensityScale(MultilevelSensorScaleType):
    """Enum for known scales for SEISMIC_INTENSITY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    EUROPEAN_MACROSEISMIC = 1
    LIEDU = 2
    MERCALLI = 0
    SHINDO = 3


class SeismicMagnitudeScale(MultilevelSensorScaleType):
    """Enum for known scales for SEISMIC_MAGNITUDE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    BODY_WAVE = 3
    LOCAL = 0
    MOMENT = 1
    SURFACE_WAVE = 2


class SoilSalinityScale(MultilevelSensorScaleType):
    """Enum for known scales for SOIL_SALINITY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MOLE_PER_CUBIC_METER = 0


class SolarRadiationScale(MultilevelSensorScaleType):
    """Enum for known scales for SOLAR_RADIATION multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    WATT_PER_SQUARE_METER = 0


class TankCapacityScale(MultilevelSensorScaleType):
    """Enum for known scales for TANK_CAPACITY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    CUBIC_METER = 1
    GALLONS = 2
    LITER = 0


class TideLevelScale(MultilevelSensorScaleType):
    """Enum for known scales for TIDE_LEVEL multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    FEET = 1
    METER = 0


class TimeScale(MultilevelSensorScaleType):
    """Enum for known scales for TIME multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    SECOND = 0


class TemperatureScale(MultilevelSensorScaleType):
    """Enum for known scales for Temperature multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    CELSIUS = 0
    FAHRENHEIT = 1


class UltravioletScale(MultilevelSensorScaleType):
    """Enum for known scales for ULTRAVIOLET multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    UV_INDEX = 0


class UnitlessScale(MultilevelSensorScaleType):
    """Enum for known scales for Unitless multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    UNITLESS = 0


class VelocityScale(MultilevelSensorScaleType):
    """Enum for known scales for VELOCITY multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MPH = 1
    M_S = 0


class VolatileOrganicCompoundLevelScale(MultilevelSensorScaleType):
    """Enum for known scales for VOLATILE_ORGANIC_COMPOUND_LEVEL multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MOLE_PER_CUBIC_METER = 0
    PARTS_MILLION = 1


class VoltageScale(MultilevelSensorScaleType):
    """Enum for known scales for VOLTAGE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MILLIVOLT = 1
    VOLT = 0


class WaterChlorineLevelScale(MultilevelSensorScaleType):
    """Enum for known scales for WATER_CHLORINE_LEVEL multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MILLIGRAM_PER_LITER = 0


class WaterFlowScale(MultilevelSensorScaleType):
    """Enum for known scales for WATER_FLOW multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    LITER_PER_HOUR = 0


class WaterOxidationReductionPotentialScale(MultilevelSensorScaleType):
    """Enum for known scales for WATER_OXIDATION_REDUCTION_POTENTIAL multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    MILLIVOLT = 0


class WaterPressureScale(MultilevelSensorScaleType):
    """Enum for known scales for WATER_PRESSURE multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    KILOPASCAL = 0


class WeightScale(MultilevelSensorScaleType):
    """Enum for known scales for WEIGHT multilevel sensor types."""

    # https://github.com/zwave-js/node-zwave-js/blob/master/packages/config/config/sensorTypes.json
    KILOGRAM = 0
    POUNDS = 1


MULTILEVEL_SENSOR_TYPE_TO_SCALE_MAP: dict[
    MultilevelSensorType, type[MultilevelSensorScaleType]
] = {
    MultilevelSensorType.ACCELERATION_X_AXIS: AccelerationScale,
    MultilevelSensorType.ACCELERATION_Y_AXIS: AccelerationScale,
    MultilevelSensorType.ACCELERATION_Z_AXIS: AccelerationScale,
    MultilevelSensorType.AIR_FLOW: AirFlowScale,
    MultilevelSensorType.AIR_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.AMMONIA: DensityScale,
    MultilevelSensorType.ANGLE_POSITION: AnglePositionScale,
    MultilevelSensorType.APPLIED_FORCE_ON_THE_SENSOR: AppliedForceOnTheSensorScale,
    MultilevelSensorType.ATMOSPHERIC_PRESSURE: AirPressureScale,
    MultilevelSensorType.BAROMETRIC_PRESSURE: AirPressureScale,
    MultilevelSensorType.BASIS_METABOLIC_RATE: BasisMetabolicRateScale,
    MultilevelSensorType.BLOOD_PRESSURE: BloodPressureScale,
    MultilevelSensorType.BODY_MASS_INDEX: BodyMassIndexScale,
    MultilevelSensorType.BOILER_WATER_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.BONE_MASS: MassScale,
    MultilevelSensorType.CARBON_DIOXIDE_LEVEL: CarbonDioxideLevelScale,
    MultilevelSensorType.CARBON_MONOXIDE_LEVEL: CarbonMonoxideLevelScale,
    MultilevelSensorType.CONDENSER_COIL_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.CURRENT: CurrentScale,
    MultilevelSensorType.DEFROST_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.DEW_POINT: TemperatureScale,
    MultilevelSensorType.DIRECTION: DirectionScale,
    MultilevelSensorType.DISCHARGE_LINE_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.DISCHARGE_PRESSURE: PressureScale,
    MultilevelSensorType.DISTANCE: DistanceScale,
    MultilevelSensorType.DOMESTIC_HOT_WATER_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.ELECTRICAL_CONDUCTIVITY: ElectricalConductivityScale,
    MultilevelSensorType.ELECTRICAL_RESISTIVITY: ElectricalResistivityScale,
    MultilevelSensorType.EVAPORATOR_COIL_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.EXHAUST_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.FAT_MASS: MassScale,
    MultilevelSensorType.FORMALDEHYDE_LEVEL: FormaldehydeLevelScale,
    MultilevelSensorType.FREQUENCY: FrequencyScale,
    MultilevelSensorType.GENERAL_PURPOSE: GeneralPurposeScale,
    MultilevelSensorType.HEART_RATE: HeartRateScale,
    MultilevelSensorType.HEART_RATE_LF_HF_RATIO: UnitlessScale,
    MultilevelSensorType.HUMIDITY: HumidityScale,
    MultilevelSensorType.ILLUMINANCE: IlluminanceScale,
    MultilevelSensorType.LEAD: DensityScale,
    MultilevelSensorType.LIQUID_LINE_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.LOUDNESS: LoudnessScale,
    MultilevelSensorType.METHANE_DENSITY: MethaneDensityScale,
    MultilevelSensorType.MOISTURE: MoistureScale,
    MultilevelSensorType.MOTION_DIRECTION: DirectionScale,
    MultilevelSensorType.MUSCLE_MASS: MassScale,
    MultilevelSensorType.NITROGEN_DIOXIDE: DensityScale,
    MultilevelSensorType.OUTSIDE_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.OZONE: DensityScale,
    MultilevelSensorType.PARTICULATE_MATTER_1: DensityScale,
    MultilevelSensorType.PARTICULATE_MATTER_10: ParticulateMatter10Scale,
    MultilevelSensorType.PARTICULATE_MATTER_2_5: ParticulateMatter25Scale,
    MultilevelSensorType.PERSON_COUNTER_ENTERING: UnitlessScale,
    MultilevelSensorType.PERSON_COUNTER_EXITING: UnitlessScale,
    MultilevelSensorType.POWER: PowerScale,
    MultilevelSensorType.RADON_CONCENTRATION: RadonConcentrationScale,
    MultilevelSensorType.RAIN_RATE: RainRateScale,
    MultilevelSensorType.RELATIVE_MODULATION_LEVEL: PercentageScale,
    MultilevelSensorType.RESPIRATORY_RATE: RespiratoryRateScale,
    MultilevelSensorType.RETURN_AIR_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.RF_SIGNAL_STRENGTH: RfSignalStrengthScale,
    MultilevelSensorType.ROTATION: RotationScale,
    MultilevelSensorType.SEISMIC_INTENSITY: SeismicIntensityScale,
    MultilevelSensorType.SEISMIC_MAGNITUDE: SeismicMagnitudeScale,
    MultilevelSensorType.SMOKE_DENSITY: PercentageScale,
    MultilevelSensorType.SOIL_HUMIDITY: PercentageScale,
    MultilevelSensorType.SOIL_REACTIVITY: AcidityScale,
    MultilevelSensorType.SOIL_SALINITY: SoilSalinityScale,
    MultilevelSensorType.SOIL_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.SOLAR_RADIATION: SolarRadiationScale,
    MultilevelSensorType.SUCTION_PRESSURE: PressureScale,
    MultilevelSensorType.SULFUR_DIOXIDE: DensityScale,
    MultilevelSensorType.SUPPLY_AIR_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.TANK_CAPACITY: TankCapacityScale,
    MultilevelSensorType.TARGET_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.TIDE_LEVEL: TideLevelScale,
    MultilevelSensorType.TIME: TimeScale,
    MultilevelSensorType.TOTAL_BODY_WATER: MassScale,
    MultilevelSensorType.ULTRAVIOLET: UltravioletScale,
    MultilevelSensorType.VELOCITY: VelocityScale,
    MultilevelSensorType.VOLATILE_ORGANIC_COMPOUND_LEVEL: VolatileOrganicCompoundLevelScale,
    MultilevelSensorType.VOLTAGE: VoltageScale,
    MultilevelSensorType.WATER_ACIDITY: AcidityScale,
    MultilevelSensorType.WATER_CHLORINE_LEVEL: WaterChlorineLevelScale,
    MultilevelSensorType.WATER_FLOW: WaterFlowScale,
    MultilevelSensorType.WATER_OXIDATION_REDUCTION_POTENTIAL: WaterOxidationReductionPotentialScale,
    MultilevelSensorType.WATER_PRESSURE: WaterPressureScale,
    MultilevelSensorType.WATER_TEMPERATURE: TemperatureScale,
    MultilevelSensorType.WEIGHT: WeightScale,
}

UNIT_ABSOLUTE_HUMIDITY: list[MultilevelSensorScaleType] = [
    HumidityScale.ABSOLUTE_HUMIDITY
]
UNIT_ACIDITY: list[MultilevelSensorScaleType] = [AcidityScale.ACIDITY]
UNIT_AMPERE: list[MultilevelSensorScaleType] = [CurrentScale.AMPERE]
UNIT_A_WEIGHTED_DECIBELS: list[MultilevelSensorScaleType] = [
    LoudnessScale.A_WEIGHTED_DECIBELS
]
UNIT_BEATS_PER_MINUTE: list[MultilevelSensorScaleType] = [
    HeartRateScale.BEATS_PER_MINUTE
]
UNIT_BECQUEREL_PER_CUBIC_METER: list[MultilevelSensorScaleType] = [
    RadonConcentrationScale.BECQUEREL_PER_CUBIC_METER
]
UNIT_BODY_MASS_INDEX: list[MultilevelSensorScaleType] = [
    BodyMassIndexScale.BODY_MASS_INDEX
]
UNIT_BODY_WAVE: list[MultilevelSensorScaleType] = [SeismicMagnitudeScale.BODY_WAVE]
UNIT_BREATHS_PER_MINUTE: list[MultilevelSensorScaleType] = [
    RespiratoryRateScale.BREATHS_PER_MINUTE
]
UNIT_BTU_H: list[MultilevelSensorScaleType] = [PowerScale.BTU_H]
UNIT_CELSIUS: list[MultilevelSensorScaleType] = [TemperatureScale.CELSIUS]
UNIT_CENTIMETER: list[MultilevelSensorScaleType] = [DistanceScale.CENTIMETER]
UNIT_CUBIC_FEET_PER_MINUTE: list[MultilevelSensorScaleType] = [
    AirFlowScale.CUBIC_FEET_PER_MINUTE
]
UNIT_CUBIC_METER: list[MultilevelSensorScaleType] = [TankCapacityScale.CUBIC_METER]
UNIT_CUBIC_METER_PER_HOUR: list[MultilevelSensorScaleType] = [
    AirFlowScale.CUBIC_METER_PER_HOUR
]
UNIT_DECIBEL: list[MultilevelSensorScaleType] = [LoudnessScale.DECIBEL]
UNIT_DEGREES: list[MultilevelSensorScaleType] = [DirectionScale.DEGREES]
UNIT_DEGREES_RELATIVE_TO_NORTH_POLE_OF_STANDING_EYE_VIEW: list[
    MultilevelSensorScaleType
] = [AnglePositionScale.DEGREES_RELATIVE_TO_NORTH_POLE_OF_STANDING_EYE_VIEW]
UNIT_DEGREES_RELATIVE_TO_SOUTH_POLE_OF_STANDING_EYE_VIEW: list[
    MultilevelSensorScaleType
] = [AnglePositionScale.DEGREES_RELATIVE_TO_SOUTH_POLE_OF_STANDING_EYE_VIEW]
UNIT_DENSITY: list[MultilevelSensorScaleType] = [DensityScale.DENSITY]
UNIT_DIASTOLIC: list[MultilevelSensorScaleType] = [BloodPressureScale.DIASTOLIC]
UNIT_DIMENSIONLESS_VALUE: list[MultilevelSensorScaleType] = [
    GeneralPurposeScale.DIMENSIONLESS_VALUE
]
UNIT_EUROPEAN_MACROSEISMIC: list[MultilevelSensorScaleType] = [
    SeismicIntensityScale.EUROPEAN_MACROSEISMIC
]
UNIT_FAHRENHEIT: list[MultilevelSensorScaleType] = [TemperatureScale.FAHRENHEIT]
UNIT_FEET: list[MultilevelSensorScaleType] = [DistanceScale.FEET, TideLevelScale.FEET]
UNIT_GALLONS: list[MultilevelSensorScaleType] = [TankCapacityScale.GALLONS]
UNIT_HERTZ: list[MultilevelSensorScaleType] = [
    FrequencyScale.HERTZ,
    RotationScale.HERTZ,
]
UNIT_IMPEDANCE: list[MultilevelSensorScaleType] = [MoistureScale.IMPEDANCE]
UNIT_INCHES_OF_MERCURY: list[MultilevelSensorScaleType] = [
    AirPressureScale.INCHES_OF_MERCURY
]
UNIT_INCHES_PER_HOUR: list[MultilevelSensorScaleType] = [RainRateScale.INCHES_PER_HOUR]
UNIT_JOULE: list[MultilevelSensorScaleType] = [BasisMetabolicRateScale.JOULE]
UNIT_KILOGRAM: list[MultilevelSensorScaleType] = [
    MassScale.KILOGRAM,
    WeightScale.KILOGRAM,
]
UNIT_KILOHERTZ: list[MultilevelSensorScaleType] = [FrequencyScale.KILOHERTZ]
UNIT_KILOPASCAL: list[MultilevelSensorScaleType] = [
    AirPressureScale.KILOPASCAL,
    PressureScale.KILOPASCAL,
    WaterPressureScale.KILOPASCAL,
]
UNIT_LIEDU: list[MultilevelSensorScaleType] = [SeismicIntensityScale.LIEDU]
UNIT_LITER: list[MultilevelSensorScaleType] = [TankCapacityScale.LITER]
UNIT_LITER_PER_HOUR: list[MultilevelSensorScaleType] = [WaterFlowScale.LITER_PER_HOUR]
UNIT_LOCAL: list[MultilevelSensorScaleType] = [SeismicMagnitudeScale.LOCAL]
UNIT_LUX: list[MultilevelSensorScaleType] = [IlluminanceScale.LUX]
UNIT_MERCALLI: list[MultilevelSensorScaleType] = [SeismicIntensityScale.MERCALLI]
UNIT_METER: list[MultilevelSensorScaleType] = [
    DistanceScale.METER,
    TideLevelScale.METER,
]
UNIT_METER_PER_SQUARE_SECOND: list[MultilevelSensorScaleType] = [
    AccelerationScale.METER_PER_SQUARE_SECOND
]
UNIT_MICROGRAM_PER_CUBIC_METER: list[MultilevelSensorScaleType] = [
    ParticulateMatter10Scale.MICROGRAM_PER_CUBIC_METER,
    ParticulateMatter25Scale.MICROGRAM_PER_CUBIC_METER,
]
UNIT_MILLIAMPERE: list[MultilevelSensorScaleType] = [CurrentScale.MILLIAMPERE]
UNIT_MILLIGRAM_PER_LITER: list[MultilevelSensorScaleType] = [
    WaterChlorineLevelScale.MILLIGRAM_PER_LITER
]
UNIT_MILLIMETER_HOUR: list[MultilevelSensorScaleType] = [RainRateScale.MILLIMETER_HOUR]
UNIT_MILLIVOLT: list[MultilevelSensorScaleType] = [
    VoltageScale.MILLIVOLT,
    WaterOxidationReductionPotentialScale.MILLIVOLT,
]
UNIT_MOLE_PER_CUBIC_METER: list[MultilevelSensorScaleType] = [
    CarbonMonoxideLevelScale.MOLE_PER_CUBIC_METER,
    FormaldehydeLevelScale.MOLE_PER_CUBIC_METER,
    MethaneDensityScale.MOLE_PER_CUBIC_METER,
    ParticulateMatter10Scale.MOLE_PER_CUBIC_METER,
    ParticulateMatter25Scale.MOLE_PER_CUBIC_METER,
    SoilSalinityScale.MOLE_PER_CUBIC_METER,
    VolatileOrganicCompoundLevelScale.MOLE_PER_CUBIC_METER,
]
UNIT_MOMENT: list[MultilevelSensorScaleType] = [SeismicMagnitudeScale.MOMENT]
UNIT_MPH: list[MultilevelSensorScaleType] = [VelocityScale.MPH]
UNIT_M_S: list[MultilevelSensorScaleType] = [VelocityScale.M_S]
UNIT_NEWTON: list[MultilevelSensorScaleType] = [AppliedForceOnTheSensorScale.NEWTON]
UNIT_OHM_METER: list[MultilevelSensorScaleType] = [ElectricalResistivityScale.OHM_METER]
UNIT_PARTS_MILLION: list[MultilevelSensorScaleType] = [
    CarbonDioxideLevelScale.PARTS_MILLION,
    CarbonMonoxideLevelScale.PARTS_MILLION,
    VolatileOrganicCompoundLevelScale.PARTS_MILLION,
]
UNIT_PERCENTAGE_VALUE: list[MultilevelSensorScaleType] = [
    AnglePositionScale.PERCENTAGE_VALUE,
    GeneralPurposeScale.PERCENTAGE_VALUE,
    HumidityScale.PERCENTAGE_VALUE,
    IlluminanceScale.PERCENTAGE_VALUE,
    MoistureScale.PERCENTAGE_VALUE,
    PercentageScale.PERCENTAGE_VALUE,
]
UNIT_PICOCURIES_PER_LITER: list[MultilevelSensorScaleType] = [
    RadonConcentrationScale.PICOCURIES_PER_LITER
]
UNIT_POUNDS: list[MultilevelSensorScaleType] = [WeightScale.POUNDS]
UNIT_POUND_PER_SQUARE_INCH: list[MultilevelSensorScaleType] = [
    PressureScale.POUND_PER_SQUARE_INCH
]
UNIT_POWER_LEVEL: list[MultilevelSensorScaleType] = [RfSignalStrengthScale.POWER_LEVEL]
UNIT_REVOLUTIONS_PER_MINUTE: list[MultilevelSensorScaleType] = [
    RotationScale.REVOLUTIONS_PER_MINUTE
]
UNIT_RSSI: list[MultilevelSensorScaleType] = [RfSignalStrengthScale.RSSI]
UNIT_SECOND: list[MultilevelSensorScaleType] = [TimeScale.SECOND]
UNIT_SHINDO: list[MultilevelSensorScaleType] = [SeismicIntensityScale.SHINDO]
UNIT_SIEMENS_PER_METER: list[MultilevelSensorScaleType] = [
    ElectricalConductivityScale.SIEMENS_PER_METER
]
UNIT_SURFACE_WAVE: list[MultilevelSensorScaleType] = [
    SeismicMagnitudeScale.SURFACE_WAVE
]
UNIT_SYSTOLIC: list[MultilevelSensorScaleType] = [BloodPressureScale.SYSTOLIC]
UNIT_UNITLESS: list[MultilevelSensorScaleType] = [UnitlessScale.UNITLESS]
UNIT_UV_INDEX: list[MultilevelSensorScaleType] = [UltravioletScale.UV_INDEX]
UNIT_VOLT: list[MultilevelSensorScaleType] = [VoltageScale.VOLT]
UNIT_VOLUME_WATER_CONTENT: list[MultilevelSensorScaleType] = [
    MoistureScale.VOLUME_WATER_CONTENT
]
UNIT_WATER_ACTIVITY: list[MultilevelSensorScaleType] = [MoistureScale.WATER_ACTIVITY]
UNIT_WATT: list[MultilevelSensorScaleType] = [PowerScale.WATT]
UNIT_WATT_PER_SQUARE_METER: list[MultilevelSensorScaleType] = [
    SolarRadiationScale.WATT_PER_SQUARE_METER
]

# ----------------------------------------------------------------------------------- #
# **END OF AUTOGENERATED CONTENT** (DO NOT EDIT/REMOVE THIS COMMENT BLOCK AND DO NOT  #
# EDIT ANYTHING ABOVE IT. IF A NEW IMPORT IS NEEDED, ADD IT TO THE IMPORTS IN THE     #
# CORRESPONDING GENERATION SCRIPT THEN RE-RUN THE SCRIPT. LINES WRITTEN BELOW THIS    #
# BLOCK WILL BE PRESERVED AS LONG AS THIS BLOCK REMAINS)                              #
# ----------------------------------------------------------------------------------- #

CO_SENSORS = [MultilevelSensorType.CARBON_MONOXIDE_LEVEL]
CO2_SENSORS = [MultilevelSensorType.CARBON_DIOXIDE_LEVEL]
CURRENT_SENSORS = [MultilevelSensorType.CURRENT]
ENERGY_MEASUREMENT_SENSORS = [MultilevelSensorType.BASIS_METABOLIC_RATE]
HUMIDITY_SENSORS = [MultilevelSensorType.HUMIDITY]
ILLUMINANCE_SENSORS = [MultilevelSensorType.ILLUMINANCE]
POWER_SENSORS = [MultilevelSensorType.POWER]
PRESSURE_SENSORS = [
    MultilevelSensorType.BLOOD_PRESSURE,
    MultilevelSensorType.WATER_PRESSURE,
    MultilevelSensorType.SUCTION_PRESSURE,
    MultilevelSensorType.DISCHARGE_PRESSURE,
    MultilevelSensorType.BAROMETRIC_PRESSURE,
    MultilevelSensorType.ATMOSPHERIC_PRESSURE,
]
SIGNAL_STRENGTH_SENSORS = [MultilevelSensorType.RF_SIGNAL_STRENGTH]
TEMPERATURE_SENSORS = [
    MultilevelSensorType.AIR_TEMPERATURE,
    MultilevelSensorType.DEW_POINT,
    MultilevelSensorType.WATER_TEMPERATURE,
    MultilevelSensorType.SOIL_TEMPERATURE,
    MultilevelSensorType.TARGET_TEMPERATURE,
    MultilevelSensorType.BOILER_WATER_TEMPERATURE,
    MultilevelSensorType.DOMESTIC_HOT_WATER_TEMPERATURE,
    MultilevelSensorType.OUTSIDE_TEMPERATURE,
    MultilevelSensorType.EXHAUST_TEMPERATURE,
    MultilevelSensorType.RETURN_AIR_TEMPERATURE,
    MultilevelSensorType.SUPPLY_AIR_TEMPERATURE,
    MultilevelSensorType.CONDENSER_COIL_TEMPERATURE,
    MultilevelSensorType.EVAPORATOR_COIL_TEMPERATURE,
    MultilevelSensorType.LIQUID_LINE_TEMPERATURE,
    MultilevelSensorType.DISCHARGE_LINE_TEMPERATURE,
    MultilevelSensorType.DEFROST_TEMPERATURE,
]
VOLTAGE_SENSORS = [
    MultilevelSensorType.VOLTAGE,
    MultilevelSensorType.WATER_OXIDATION_REDUCTION_POTENTIAL,
]
