import unittest
from domestic_violence_classifier import DomesticViolenceClassifier
 
class TestClassifier(unittest.TestCase):
        
    def test_sum(self):
        classifier = DomesticViolenceClassifier()
        test_sentences_positive = ["na mujer de 39 años murió en las últimas horas en un hospital de Santa Fe luego de agonizar desde el 11 de marzo, cuando su hijo la roció con nafta y la prendió fuego, en la localidad de Bella Italia, lindante con Rafaela, informaron hoy fuentes policiales. Los voceros identificaron a la víctima como Romina Esther Leiva (39), en tanto el acusado del ataque es su hijo Miguel Ángel Beresvilj (25), quien está detenido a la espera del juicio. Leiva murió mientras era asistida en la sala de terapia intensiva del hospital José María Cullen de la capital santafesina, luego de sufrir graves quemaduras en el 80 por ciento de su cuerpo que le afectaron el rostro, tórax, brazos y la pierna izquierda. La mujer resultó quemada en el marco de un violento episodio en su casa, situada en calle Córdoba al 100, de Bella Italia, localidad ubicada unos 95 kilómetros al oeste de la ciudad de Santa Fe. Luego del ataque, Beresvilj escapó en su motocicleta y horas después fue atrapado por la policía en la localidad de Frontera, en el límite con la provincia de Córdoba. En el domicilio donde ocurrió la agresión la Policía de Investigaciones secuestró dos bidones de cinco litros con restos de nafta. La versión del muchacho ante la Justicia es que su intención era quemar el automóvil de la pareja de su madre, con quien mantenía una mala relación, y que su madre se interpuso y resultó quemada por accidente. La fiscal de la Unidad de Violencia de Género, Familiar y Sexual del Ministerio Público de la Acusación (MPA), Ángela Capitanio, imputó a Beresvilj por el delito de ?homicidio agravado por el vínculo y por mediar violencia de género, en grado de tentativa, aunque ahora cambiará de figura penal ante la muerte de la mujer. El acusado se encuentra detenido con prisión preventiva sin plazos por orden del juez Osvaldo Carlos. Voceros judiciales indicaron que en la audiencia donde se fijó la prisión preventiva, el acusado dijo que jamás tuvo la intención de lastimar a su madre y que solo quería arruinarle el auto a (Roberto) Mansilla, el esposo de Leiva. Romina Leiva tenía, además de Beresvilj, cuatro hijos, dos mellizos de 13 años y otros dos de 9, producto de una relación anterior.",
        "Irene Montero ya se ha reincorporado a las reuniones del Consejo de Ministros pero ha dado plantón al Congreso. El pleno de la Cámara Baja tenía previsto debatir este miércoles la convalidación del decreto-ley que estableció medidas urgentes en materia de violencia de género pero la ministra de Igualdad, que promovió la iniciativa, ha forzado su retirada del orden del día.La Junta de Portavoces del Congreso ha acordado en su reunión de la tarde del martes sacar del orden del día el debate sobre el decreto–ley 12/2020 de medidas urgentes en materia de protección y asistencia a las víctimas de violencia de género. Montero, que ha estado 42 días en su chalé de Galapagar tras dar positivo en el test del coronavirus (aunque aseguró encontrarse muy bien en cuanto a los síntomas), ha pedido posponer su asistencia al Parlamento, por lo que el decreto-ley sigue pendiente de convalidación.La norma viene aplicándose desde el 1 de abril sin que las fuerzas políticas hayan podido discutir su contenido. El Congreso había previsto inicialmente el debate para su validación el día 9, pero la baja de la titular de Igualdad motivó su aplazamiento. Ahora, ya superado el coronavirus, tendrá que volver a postergarse aunque ya había sido incluido en el orden de la sesión.",
        "La policía local se personó en el domicilio en la Madrila Alta de Cáceres, el pasado lunes, 20 de abril por la noche, alertada por la llamada de una vecina que aseguraba escuchar una fuerte discusión “con insultos, voces y golpes”Una vez en el rellano, los agentes fueron testigos de un fuerte alboroto e intentaron acceder a la vivienda sin éxito al tiempo que escuchaban una voz masculina que decía no abras la puerta.Finalmente solicitaron la asistencia de Bomberos y Policía Nacional y accedieron a la vivienda por el balcón. Según Jesús Sellers, oficial de la policía local, una vez en la vivienda, llegaron hasta una habitación en la que se encontraron con una pareja. Allí pudieron comprobar que “la mujer presentaba lesiones visibles en la cara, golpes en el costado, moratones y se encontraba desorientada completamente.La víctima fue trasladada al Hospital Universitario y el presunto agresor fue detenido y trasladado a la Comisaría de la Policía Nacional",
        "Guterres ha asumido que los confinamientos y las cuarentas son esenciales en una emergencia como la del Covid-19, pero al mismo tiempo también ha advertido de que, para muchas mujeres y niñas, el principal riesgo reside precisamente en el lugar donde deberían estar más seguras: en sus propios hogares. Ya antes de la pandemia, la ONU estimaba que una tercera parte de las mujeres de todo el mundo experimentaban a lo largo de su vida algún tipo de violencia. La restricción de movimientos, sumada a las presiones económicas y sociales derivadas del coronavirus, amenazan con empeorar este tipo de balances, tanto en países desarrollados como en los más pobres. En Líbano y Malasia, las llamadas a los teléfonos de ayuda se han duplicado desde el inicio de la pandemia, mientras que en China se han triplicado. En Australia, los motores de búsqueda en Internet experimentaron el mayor volumen de consultas de ayuda por violencia doméstica de los últimos cinco años, según Naciones Unidas. Guterres ha alertado de que el personal sanitario y policial está desbordado y algunos centros para víctimas de la violencia de género están cerrados, mientras que otros están llenos. Por este motivo, ha apelado a la colaboración de todos para prevenir la violencia, tanto en zonas de guerra como en los hogares de las personas, mientras se combate al coronavirus. La ONU propone medidas Guterres ha llamado a aumentar la inversión, por ejemplo mediante servicios de ayuda a distancia, y a establecer sistemas de alerta en farmacias y tiendas de alimentación, dos de los comercios que pueden seguir abiertos en la mayoría de los países pese a las medidas de confinamiento, favoreciendo que las mujeres den la voz de alarma sin que se percaten sus maltratadores. Además, ha pedido que los centros de acogida sean considerados servicios esenciales y que se garantice el correcto funcionamiento de los sistemas judiciales, para que sigan procesando a los abusadores. También ha llamado a evitar que los presos condenados por violencia contra la mujer sean liberados.",
        "Los hechos ocurrieron minutos antes de las 13:00 horas de este domingo. A esa hora una compañera de piso de los implicados que había presenciado la agresión, telefoneó a la guardia urbana para alertar de la misma. Una patrulla acudió al lugar indicado y se entrevistó tanto con la denunciante como con el supuesto agresor y su víctima. Tras escuchar sus declaraciones y comprobar que la mujer presentaba varias marcas de lesiones, los agentes detuvieron al hombre, según ha informado la Policía Local. En Santurtzi, un hombre de 37 años ha sido detenido este lunes acusado de agredir a su expareja en un domicilio de esta localidad vizcaína, donde ambos conviven temporalmente durante el confinamiento por el COVID-19 para compartir el cuidado de sus hijos, según ha informado el Departamento vasco de Seguridad. Sobre las 03:00 horas de este lunes, la Ertzaintza ha recibido la llamada de una menor de edad que alertaba de que su padrastro había golpeado a su madre en una vivienda del barrio de Mamariga. Varios recursos policiales se han trasladado al lugar y han contactado con la víctima. La mujer, que se encontraba en un estado de gran nerviosismo, ha denunciado a los agentes que su expareja, con la que convive estos días de confinamiento para compartir el cuidado de sus hijos, le había tirado del pelo y agarrado del cuello. Según ha relatado la víctima, la agresión se había producido tras una discusión por el alto volumen de la televisión y la conversación a gritos que su expareja mantenía por teléfono. La mujer ha podido refugiarse en la habitación de sus hijos y uno de ellos ha realizado la llamada de socorro. Los ertzainas han procedido a la identificación y posterior arresto del presunto agresor acusado de un delito de violencia de género. Una vez trasladado a dependencias policiales, ha quedado en libertad con la obligación de comparecer ante la autoridad judicial en las próximas horas."]
        
        test_sentences_negative = ["IMPORTANTE: El restaurante cierra los días de partido o eventos.  El confort y la elegancia son uno de los dúos más apreciados por los sibaritas de todo el mundo. Pero Chamartín ha sabido convertirlo en un muy distinguido trío, puesto que suma la gastronomía asiática a esta lujosa ecuación.  Y es que Zen Market es mucho más que un restaurante, puesto que su calidad raya la perfección. No es casualidad que Ignacio García de Vinuesa y su equipo de profesionales le hayan dado forma a este rincón que también es deportista: se encuentra en una zona exclusiva del estadio Santiago Bernabéu.  Si pensabas que habías probado un pato lacado auténtico, desde eltenedor.es te pedimos que reserves una mesa y disfrutes de un auténtico pato lacado en caviar o quizás un bogavante salteado con sal y pimienta Sechuan. Si ya los probaste, reserva en cualquier caso y para cualquier ocasión. Zen Market es toda una experiencia. ¡No te lo puedes perder!",
        "España ha amanecido este martes con una buena noticia: La Organización Mundial de la Salud (OMS) ha comentado que nuestro país puede estar llegando al pico de incidencia de casos del nuevo coronavirus Covid-19. Sin embargo, no ha sido la única. Entre las tinieblas y la incertidumbre que ha pintado el Covid-19 esta primavera de 2020, cada jornada se conocen informaciones que animan a mantener la esperanza. Un paciente de coronavirus Un paciente de coronavirus 1. El Hospital Gregorio Marañón da el alta de la UCI a su paciente más joven, de 20 años. El Hospital Gregorio Marañón ha dado el alta de la UCI a su paciente de coronavirus más joven, un chico de 20 años que ha pasado a la planta de hospitalización, donde continuará con su recuperación del Covid-19. Según informaron fuentes del centro hospitalario, el Gregorio Marañón ha dado hoy más de 80 altas a pacientes que ya han regresado a su domicilio. El hospital madrileño es uno de los cinco españoles que participan en un ensayo clínico con «sarilumab» para pacientes hospitalizados con Covid-19 en estado grave o crítico con enfermos europeos. El Hospital Vall d'Hebron de Barcelona ha sido el primer centro activado en España y el Gregorio Marañón de Madrid el que ha incluido los primeros pacientes. También participan el Hospital La Paz y el Ramón y Cajal, ambos de Madrid y el Clinic de Barcelona. 2. El emotivo gesto de dos agentes de la Policía Nacional con una anciana por su cumpleaño. La crisis del coronavirus ha desatado un gran estado de alarma y nerviosismo entre la población. En estos tiempos difíciles, la solidaridad se abre paso y sale a la luz el lado más humano de la sociedad. Una muestra de ello es el emotivo gesto que se vivió la semana pasada en un municipio de Aragón. Un equipo de la Policía Nacional estaba realizando una patrulla peatonal por el centro de Jaca (Huesca), y Toñi, una anciana de un edificio cercano, al verlos, salió a aplaudirles. No fue la única. Varios vecinos, que también se asomaron a sus balcones, comentaron a los agentes que aquel día era el cumpleaños de la mujer. Decididos a hacer de aquella una jornada especial para ella, los dos miembros del cuerpo se acercaron a la comisaría para hacerse con una caja de dulces y regresaron al barrio de Toñi. Una vez allí, y sin pensárselo dos veces, Manuel Aldaz, jefe de la Policía Nacional en Jaca, se encaramó a su coche y entregó el presente a la anciana. Amancio Ortega ha hecho grandes esfuerzos para lugar contra el coronavirus Amancio Ortega ha hecho grandes esfuerzos para lugar contra el coronavirus 3. La Fundación Amancio Ortega compra material contra la pandemia de coronavirus por 63 millones de euros. Según ha informado la entidad a través de un comunicado, «las gestiones de compra continúan en marcha con el objetivo de seguir incrementando el volumen de material adquirido». Entre este material destaca, principalmente, la adquisición de 1.450 respiradores para las unidades de cuidados intensivos, tres millones de mascarillas filtrantes para el uso de personal sanitario, un millón de kits de detección del virus y otros equipamientos para centros sanitarios, como 450 camas hospitalarias.",
        "Recuerdo que antes decía, que en mí vivían sentimientos de agonía y tristeza, sentimientos que revivían con cada recuerdo que tenía, mi mente, un lugar abrumado, confundido, desolado y que pensaba que en ningún otro momento eso cambiaría, estaba tan lastimado no sólo por las personas, sino por la vida en general… De un momento a otro llega una pequeña casualidad, aquella que le daría un rumbo diferente a mi vida, que haría despertar aquel yo que se había ocultado por mucho tiempo, aquellos sentimientos que habían desaparecido, aquella pequeña casualidad, cobró mucha importancia, ya no sólo era una casualidad, era la razón de que yo no brincara al fondo de ese hoyo el cual me atraía cada vez más para hundirme dentro de el, era por quién en las mañanas ya no pensaba que todo era repetitivo, sino que todas las mañanas eran días nuevos, para poder vivir, poder disfrutar y sobre todo poder amar",
        "Agricultores afectados por el incendio de junio en la Ribera d'Ebre, Garrigues y Segrià consideran insuficiente el plan de choque anunciado este jueves por la 'consellera' de Agricultura, Teresa Jordà, que propuso ayudas directas por la limpieza de los bosques quemados y créditos blandos por los propietarios de fincas afectadas por el fuego, que arrasó más de 5.000 hectáreas. El presidente de Asaja y portavoz de agricultores afectados por el incendio de Ribera de Ebro, Pere Roqué, dice que los campesinos están desilusionados con la propuesta puesto que necesitan una primera ayuda directa para las explotaciones antes de plantearse un crédito blando. También Unió de Pagesos se ha sumado a la protesta y añaden que las ayudas no tienen en cuenta la pérdida de rentas que supondrán a medio plazo para los afectados, algunos de los cuales se plantean poder continuar con la actividad agrícola o ganadera. Los agricultores anuncian una nueva manifestación por domingo a las 18h en Flix y reclaman una reunión urgente con Jordà la semana que viene. Lamentan que se los emplace en septiembre y le recuerdan que los campesinos afectados no se van de vacaciones. La 'consellera' de Agricultura, Teresa Jordà, anunció una ayuda directa para limpiar los bosques de la madera quemada este agosto y una línea de créditos de 5 millones de euros, cuyos intereses irán a cargo del departamento. También anunció una inversión de 3,5 millones de euros para extender el riego de apoyo a toda la zona afectada por el incendio. Sobre las ayudas a fondo perdido, Jordà se emplazó a seguir hablando en septiembre, dependiendo también de los próximos presupuestos, a pesar de que se comprometió a estudiar caso por caso todas las demandas y necesidades. Los agricultores y ganaderos afectados por el incendio de la Ribera d'Ebre no  tienen bastante y reclaman ayudas directas para recuperar sus explotaciones. La medida del crédito puede ser interesante, siempre y cuando primero haya una ayuda directa para salir adelante, para aquellas explotaciones que los hagan falta más dinero además de la ayuda directa, explica Roqué."
        ]
        for text in test_sentences_positive:
            print(text)
            sentiment_result = classifier.domestic_violence_subject_probability(text)
            print(sentiment_result)
            print("--------")
            self.assertGreater(sentiment_result, 0.5, "Result should be possitive")
        
        for text in test_sentences_negative:
            print(text)
            sentiment_result = classifier.domestic_violence_subject_probability(text)
            print(sentiment_result)
            print("--------")
            self.assertLess(sentiment_result, 0.5, "Result should be negative")



if __name__ == '__main__':
    unittest.main()