"""added goal properties

Revision ID: 5018059c5c8f
Revises: 16b4a243d41d
Create Date: 2015-09-23 11:56:01.897992

"""

# revision identifiers, used by Alembic.
revision = '5018059c5c8f'
down_revision = '16b4a243d41d'
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('goalproperties',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('is_variable', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('goals_goalproperties',
    sa.Column('goal_id', sa.Integer(), nullable=False),
    sa.Column('property_id', sa.Integer(), nullable=False),
    sa.Column('value', sa.String(length=255), nullable=True),
    sa.Column('value_translation_id', sa.Integer(), nullable=True),
    sa.Column('from_level', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['goal_id'], ['goals.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['property_id'], ['goalproperties.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['value_translation_id'], ['translationvariables.id'], ondelete='RESTRICT'),
    sa.PrimaryKeyConstraint('goal_id', 'property_id', 'from_level')
    )
    op.add_column(u'goals', sa.Column('name', sa.String(length=255), nullable=False, server_default=""))
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_column(u'goals', 'name')
    op.drop_table('goals_goalproperties')
    op.drop_table('goalproperties')
    ### end Alembic commands ###
