use std::{cmp::Ordering, fmt::Display};

use allocative::Allocative;
use serde::{Deserialize, Serialize};

#[derive(Copy, Clone, Serialize, Deserialize, PartialEq, Eq, Hash, Debug, Default, Allocative)]
pub struct EdgeId(pub usize);

impl PartialOrd for EdgeId {
    fn partial_cmp(&self, other: &Self) -> Option<Ordering> {
        Some(self.0.cmp(&other.0))
    }
}

impl Ord for EdgeId {
    fn cmp(&self, other: &Self) -> Ordering {
        self.0.cmp(&other.0)
    }
}

impl Display for EdgeId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "{}", self.0)
    }
}

impl EdgeId {
    pub fn as_usize(&self) -> usize {
        self.0
    }
}
