"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SNSSlackMessageLambdaSubscription = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_resource_naming_1 = require("@gammarers/aws-resource-naming");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const logs = require("aws-cdk-lib/aws-logs");
const sns = require("aws-cdk-lib/aws-sns");
const constructs_1 = require("constructs");
const send_slack_message_function_1 = require("./funcs/send-slack-message-function");
class SNSSlackMessageLambdaSubscription extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // 👇 Get account & region
        const account = aws_cdk_lib_1.Stack.of(scope).account;
        const region = aws_cdk_lib_1.Stack.of(scope).region;
        // 👇 Create random 8 length string
        const random = aws_resource_naming_1.ResourceNaming.createRandomString(`${aws_cdk_lib_1.Names.uniqueId(scope)}.${aws_cdk_lib_1.Names.uniqueId(this)}`);
        const autoNaming = {
            functionName: `send-slack-message-${random}-func`,
            functionRoleName: `send-slack-message-lambda-func-exec-${random}-role`,
        };
        const names = aws_resource_naming_1.ResourceNaming.naming(autoNaming, props.resourceNamingOption);
        // Lambda function
        const sendMessageFunction = new send_slack_message_function_1.SendSlackMessageFunction(this, 'SendSlackMessageFunction', {
            functionName: names.functionName,
            description: 'Send Slack message function',
            architecture: lambda.Architecture.ARM_64,
            role: new iam.Role(this, 'LambdaExecutionRole', {
                roleName: names.functionRoleName,
                description: '',
                assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
                managedPolicies: [
                    iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
                ],
                inlinePolicies: {
                    'get-secret-policy': new iam.PolicyDocument({
                        statements: [
                            new iam.PolicyStatement({
                                effect: iam.Effect.ALLOW,
                                actions: [
                                    'secretsmanager:GetSecretValue',
                                ],
                                resources: [
                                    `arn:aws:secretsmanager:${region}:${account}:secret:${props.slackWebhookSecretName}*`,
                                ],
                            }),
                        ],
                    }),
                },
            }),
            timeout: aws_cdk_lib_1.Duration.seconds(10),
            paramsAndSecrets: lambda.ParamsAndSecretsLayerVersion.fromVersion(lambda.ParamsAndSecretsVersions.V1_0_103, {
                cacheSize: 500,
                logLevel: lambda.ParamsAndSecretsLogLevel.INFO,
            }),
            environment: {
                SLACK_WEBOOK_SECRET_NAME: props.slackWebhookSecretName,
            },
            logFormat: lambda.LogFormat.JSON,
            systemLogLevel: lambda.SystemLogLevel.INFO,
            applicationLogLevel: lambda.ApplicationLogLevel.INFO,
            logGroup: new logs.LogGroup(this, 'SendSlackMessageFunctionLogGroup', {
                logGroupName: names.functionName ? `/aws/lambda/${names.functionName}` : undefined,
                retention: logs.RetentionDays.THREE_MONTHS,
                removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN_ON_UPDATE_OR_DELETE,
            }),
        });
        sendMessageFunction.addPermission('InvokeFunctionFromSNS', {
            principal: new iam.ServicePrincipal('sns.amazonaws.com'),
            action: 'lambda:InvokeFunction',
            sourceArn: props.topic.topicArn,
        });
        new sns.Subscription(this, 'LambdaSubscription', {
            topic: props.topic,
            protocol: sns.SubscriptionProtocol.LAMBDA,
            endpoint: sendMessageFunction.functionArn,
        });
    }
}
exports.SNSSlackMessageLambdaSubscription = SNSSlackMessageLambdaSubscription;
_a = JSII_RTTI_SYMBOL_1;
SNSSlackMessageLambdaSubscription[_a] = { fqn: "@gammarers/aws-sns-slack-message-lambda-subscription.SNSSlackMessageLambdaSubscription", version: "1.0.13" };
//# sourceMappingURL=data:application/json;base64,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