"""
Copyright (c) 2010-present by Jaxl Innovations Private Limited.

All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, is strictly prohibited.
"""

from typing import Any, Dict, List, Type, TypeVar, Union, cast

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="CallTtsRequestRequest")


@attr.s(auto_attribs=True)
class CallTtsRequestRequest:
    """
    Attributes:
        prompts (List[str]):
        mark (Union[Unset, None, str]):  Default: 'outgoing-ivr'.
    """

    prompts: List[str]
    mark: Union[Unset, None, str] = "outgoing-ivr"
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        prompts = self.prompts

        mark = self.mark

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "prompts": prompts,
            }
        )
        if mark is not UNSET:
            field_dict["mark"] = mark

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        prompts = cast(List[str], d.pop("prompts"))

        mark = d.pop("mark", UNSET)

        call_tts_request_request = cls(
            prompts=prompts,
            mark=mark,
        )

        call_tts_request_request.additional_properties = d
        return call_tts_request_request

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
