from typing import Any, ClassVar

from typing import overload
import Boost.Python

class AngleAxis(Boost.Python.instance):
    angle: Any
    axis: Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def fromRotationMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def inverse(cls, classEigen) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrix(cls, classEigen) -> Any: ...
    @classmethod
    def toRotationMatrix(cls, classEigen) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class ComputationInfo(Boost.Python.enum):
    InvalidInput: ClassVar[ComputationInfo] = ...
    NoConvergence: ClassVar[ComputationInfo] = ...
    NumericalIssue: ClassVar[ComputationInfo] = ...
    Success: ClassVar[ComputationInfo] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class DecompositionOptions(Boost.Python.enum):
    ABx_lx: ClassVar[DecompositionOptions] = ...
    Ax_lBx: ClassVar[DecompositionOptions] = ...
    BAx_lx: ClassVar[DecompositionOptions] = ...
    ComputeEigenvectors: ClassVar[DecompositionOptions] = ...
    ComputeFullU: ClassVar[DecompositionOptions] = ...
    ComputeFullV: ClassVar[DecompositionOptions] = ...
    ComputeThinU: ClassVar[DecompositionOptions] = ...
    ComputeThinV: ClassVar[DecompositionOptions] = ...
    EigenvaluesOnly: ClassVar[DecompositionOptions] = ...
    names: ClassVar[dict] = ...
    values: ClassVar[dict] = ...
    __slots__: ClassVar[tuple] = ...

class EigenSolver(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def compute(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def eigenvalues(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def eigenvectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def getMaxIterations(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def info(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def pseudoEigenvalueMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def pseudoEigenvectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setMaxIterations(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class Exception(Boost.Python.instance):
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @property
    def message(self) -> Any: ...

class LDLT(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def adjoint(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def compute(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def info(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isNegative(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isPositive(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrixL(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrixLDLT(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrixU(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def rankUpdate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def rcond(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def reconstructedMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setZero(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def solve(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def transpositionsP(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def vectorD(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class LLT(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def adjoint(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def compute(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def info(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrixL(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrixLLT(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrixU(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def rankUpdate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def rcond(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def reconstructedMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def solve(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class MINRES(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def analyzePattern(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def cols(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def compute(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def error(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def factorize(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def info(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def iterations(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def maxIterations(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def preconditioner(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def rows(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setMaxIterations(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setTolerance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def solve(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def solveWithGuess(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolerance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class Quaternion(Boost.Python.instance):
    w: Any
    x: Any
    y: Any
    z: Any
    @overload
    @classmethod
    def __init__(cls, classboost, classEigen) -> Any: ...
    @overload
    @classmethod
    def __init__(cls, classboost) -> Any: ...
    def FromTwoVectors(self, *args, **kwargs) -> Any: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    @classmethod
    def _transformVector(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def angularDistance(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def assign(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def coeffs(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def conjugate(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def dot(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def inverse(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def isApprox(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def matrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def norm(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def normalize(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def normalized(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setFromTwoVectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def setIdentity(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def slerp(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def squaredNorm(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def toRotationMatrix(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def vec(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __abs__(cls) -> Any: ...
    @classmethod
    def __eq__(cls, other) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __imul__(cls, other) -> Any: ...
    @classmethod
    def __len__(cls) -> Any: ...
    @classmethod
    def __mul__(cls, other) -> Any: ...
    @classmethod
    def __ne__(cls, other) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> Any: ...

class SelfAdjointEigenSolver(Boost.Python.instance):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def compute(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def computeDirect(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def eigenvalues(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def eigenvectors(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def info(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def operatorInverseSqrt(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def operatorSqrt(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

class StdVec_MatrixXd(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def reserve(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> Any: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls, classboost) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> Any: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_MatrixXi(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def reserve(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> Any: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls, classboost) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> Any: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_VectorXd(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def reserve(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> Any: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls, classboost) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> Any: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class StdVec_VectorXi(Boost.Python.instance):
    __getstate_manages_dict__: ClassVar[bool] = ...
    __instance_size__: ClassVar[int] = ...
    __safe_for_unpickling__: ClassVar[bool] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def append(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def copy(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def extend(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def reserve(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def tolist(cls, *args, **kwargs) -> Any: ...
    @classmethod
    def __contains__(cls, other) -> Any: ...
    @classmethod
    def __delitem__(cls, other) -> Any: ...
    @classmethod
    def __getinitargs__(cls) -> Any: ...
    @classmethod
    def __getitem__(cls, index) -> Any: ...
    @classmethod
    def __getstate__(cls, classboost) -> Any: ...
    @classmethod
    def __iter__(cls) -> Any: ...
    @classmethod
    def __len__(cls) -> Any: ...
    @classmethod
    def __reduce__(cls) -> Any: ...
    @classmethod
    def __setitem__(cls, index, object) -> Any: ...
    @classmethod
    def __setstate__(cls, state) -> Any: ...

class solvers(Boost.Python.instance):
    class ComputationInfo(Boost.Python.enum):
        InvalidInput: ClassVar[ComputationInfo] = ...
        NoConvergence: ClassVar[ComputationInfo] = ...
        NumericalIssue: ClassVar[ComputationInfo] = ...
        Success: ClassVar[ComputationInfo] = ...
        names: ClassVar[dict] = ...
        values: ClassVar[dict] = ...
        __slots__: ClassVar[tuple] = ...

    class ConjugateGradient(Boost.Python.instance):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @classmethod
        def analyzePattern(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def compute(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def error(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def factorize(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def info(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def iterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def maxIterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def preconditioner(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def setMaxIterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def setTolerance(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def solve(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def solveWithGuess(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def tolerance(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def __reduce__(cls) -> Any: ...

    class DiagonalPreconditioner(Boost.Python.instance):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @classmethod
        def __reduce__(cls) -> Any: ...

    class IdentityConjugateGradient(Boost.Python.instance):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @classmethod
        def analyzePattern(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def compute(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def error(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def factorize(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def info(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def iterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def maxIterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def preconditioner(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def setMaxIterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def setTolerance(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def solve(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def solveWithGuess(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def tolerance(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def __reduce__(cls) -> Any: ...

    class IdentityPreconditioner(Boost.Python.instance):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @classmethod
        def compute(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def factorize(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def info(cls, classEigen) -> Any: ...
        @classmethod
        def solve(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def __reduce__(cls) -> Any: ...

    class LeastSquareDiagonalPreconditioner(Boost.Python.instance):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @classmethod
        def compute(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def factorize(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def info(cls, classEigen) -> Any: ...
        @classmethod
        def solve(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def __reduce__(cls) -> Any: ...

    class LeastSquaresConjugateGradient(Boost.Python.instance):
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        @classmethod
        def analyzePattern(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def compute(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def error(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def factorize(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def info(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def iterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def maxIterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def preconditioner(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def setMaxIterations(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def setTolerance(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def solve(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def solveWithGuess(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def tolerance(cls, *args, **kwargs) -> Any: ...
        @classmethod
        def __reduce__(cls) -> Any: ...
    __instance_size__: ClassVar[int] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def __reduce__(cls) -> Any: ...

def SimdInstructionSetsInUse() -> Any: ...
def checkVersionAtLeast(*args, **kwargs) -> Any: ...
def fromEulerAngles(*args, **kwargs) -> Any: ...
def getNumpyType() -> Any: ...
def is_approx(*args, **kwargs) -> Any: ...
def seed(unsignedint) -> Any: ...
def setNumpyType(classboost) -> Any: ...
@overload
def sharedMemory(bool) -> Any: ...
@overload
def sharedMemory() -> Any: ...
def switchToNumpyArray() -> Any: ...
def switchToNumpyMatrix() -> Any: ...
def toEulerAngles(*args, **kwargs) -> Any: ...
