#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Fri Aug 20 12:48:41 2021 by generateDS.py version 2.39.6.
# Python 3.8.6 (v3.8.6:db455296be, Sep 23 2020, 13:31:39)  [Clang 6.0 (clang-600.0.57)]
#
# Command line options:
#   ('--no-namespace-defs', '')
#   ('-o', './ics_courier_lib/services.py')
#
# Command line arguments:
#   ./schemas/services.xsd
#
# Command line:
#   /Users/danielkobina/Workspace/project/purplship-carriers/.venv/purplship-carriers/bin/generateDS --no-namespace-defs -o "./ics_courier_lib/services.py" ./schemas/services.xsd
#
# Current working directory (os.getcwd()):
#   ics_courier
#

import sys
try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_ :
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ModulenotfoundExp_ :
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_ :

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_ :
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:
        class GeneratedsSuperSuper(object):
            pass
    
    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer values')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return_value = '%s' % input_data
            if '.' in return_value:
                return_value = return_value.rstrip('0')
                if return_value.endswith('.'):
                    return_value = return_value.rstrip('.')
            return return_value
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return ' '.join([self.gds_format_decimal(item) for item in input_data])
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%s' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == 'xml':
            namespace = 'http://www.w3.org/XML/1998/namespace'
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class ValidateUser(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Account=None, PWD=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Account = Account
        self.Account_nsprefix_ = None
        self.PWD = PWD
        self.PWD_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValidateUser)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValidateUser.subclass:
            return ValidateUser.subclass(*args_, **kwargs_)
        else:
            return ValidateUser(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Account(self):
        return self.Account
    def set_Account(self, Account):
        self.Account = Account
    def get_PWD(self):
        return self.PWD
    def set_PWD(self, PWD):
        self.PWD = PWD
    def _hasContent(self):
        if (
            self.Account is not None or
            self.PWD is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateUser', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ValidateUser')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ValidateUser':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ValidateUser')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ValidateUser', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ValidateUser'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateUser', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Account is not None:
            namespaceprefix_ = self.Account_nsprefix_ + ':' if (UseCapturedNS_ and self.Account_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccount>%s</%sAccount>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Account), input_name='Account')), namespaceprefix_ , eol_))
        if self.PWD is not None:
            namespaceprefix_ = self.PWD_nsprefix_ + ':' if (UseCapturedNS_ and self.PWD_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPWD>%s</%sPWD>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PWD), input_name='PWD')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Account':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Account')
            value_ = self.gds_validate_string(value_, node, 'Account')
            self.Account = value_
            self.Account_nsprefix_ = child_.prefix
        elif nodeName_ == 'PWD':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PWD')
            value_ = self.gds_validate_string(value_, node, 'PWD')
            self.PWD = value_
            self.PWD_nsprefix_ = child_.prefix
# end class ValidateUser


class ValidateUserResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ValidateUserResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ValidateUserResult = ValidateUserResult
        self.ValidateUserResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValidateUserResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValidateUserResponse.subclass:
            return ValidateUserResponse.subclass(*args_, **kwargs_)
        else:
            return ValidateUserResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ValidateUserResult(self):
        return self.ValidateUserResult
    def set_ValidateUserResult(self, ValidateUserResult):
        self.ValidateUserResult = ValidateUserResult
    def _hasContent(self):
        if (
            self.ValidateUserResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateUserResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ValidateUserResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ValidateUserResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ValidateUserResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ValidateUserResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ValidateUserResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateUserResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ValidateUserResult is not None:
            namespaceprefix_ = self.ValidateUserResult_nsprefix_ + ':' if (UseCapturedNS_ and self.ValidateUserResult_nsprefix_) else ''
            self.ValidateUserResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ValidateUserResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ValidateUserResult':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ValidateUserResult = obj_
            obj_.original_tagname_ = 'ValidateUserResult'
# end class ValidateUserResponse


class ErrorClass(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, _ErrCode=None, _ErrDescription=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self._ErrCode = _ErrCode
        self._ErrCode_nsprefix_ = None
        self._ErrDescription = _ErrDescription
        self._ErrDescription_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ErrorClass)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ErrorClass.subclass:
            return ErrorClass.subclass(*args_, **kwargs_)
        else:
            return ErrorClass(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get__ErrCode(self):
        return self._ErrCode
    def set__ErrCode(self, _ErrCode):
        self._ErrCode = _ErrCode
    def get__ErrDescription(self):
        return self._ErrDescription
    def set__ErrDescription(self, _ErrDescription):
        self._ErrDescription = _ErrDescription
    def _hasContent(self):
        if (
            self._ErrCode is not None or
            self._ErrDescription is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ErrorClass', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ErrorClass')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ErrorClass':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ErrorClass')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ErrorClass', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ErrorClass'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ErrorClass', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self._ErrCode is not None:
            namespaceprefix_ = self._ErrCode_nsprefix_ + ':' if (UseCapturedNS_ and self._ErrCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s_ErrCode>%s</%s_ErrCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self._ErrCode), input_name='_ErrCode')), namespaceprefix_ , eol_))
        if self._ErrDescription is not None:
            namespaceprefix_ = self._ErrDescription_nsprefix_ + ':' if (UseCapturedNS_ and self._ErrDescription_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%s_ErrDescription>%s</%s_ErrDescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self._ErrDescription), input_name='_ErrDescription')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == '_ErrCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, '_ErrCode')
            value_ = self.gds_validate_string(value_, node, '_ErrCode')
            self._ErrCode = value_
            self._ErrCode_nsprefix_ = child_.prefix
        elif nodeName_ == '_ErrDescription':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, '_ErrDescription')
            value_ = self.gds_validate_string(value_, node, '_ErrDescription')
            self._ErrDescription = value_
            self._ErrDescription_nsprefix_ = child_.prefix
# end class ErrorClass


class ValidateShipToInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ShipToAddress=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ShipToAddress = ShipToAddress
        self.ShipToAddress_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValidateShipToInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValidateShipToInfo.subclass:
            return ValidateShipToInfo.subclass(*args_, **kwargs_)
        else:
            return ValidateShipToInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ShipToAddress(self):
        return self.ShipToAddress
    def set_ShipToAddress(self, ShipToAddress):
        self.ShipToAddress = ShipToAddress
    def _hasContent(self):
        if (
            self.ShipToAddress is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateShipToInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ValidateShipToInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ValidateShipToInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ValidateShipToInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ValidateShipToInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ValidateShipToInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateShipToInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ShipToAddress is not None:
            namespaceprefix_ = self.ShipToAddress_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipToAddress_nsprefix_) else ''
            self.ShipToAddress.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ShipToAddress', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ShipToAddress':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ShipToAddress = obj_
            obj_.original_tagname_ = 'ShipToAddress'
# end class ValidateShipToInfo


class AddressInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ID=None, Name=None, Address1=None, Address2=None, City=None, Province=None, Postcode=None, Contact=None, Phone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ID = ID
        self.ID_nsprefix_ = None
        self.Name = Name
        self.Name_nsprefix_ = None
        self.Address1 = Address1
        self.Address1_nsprefix_ = None
        self.Address2 = Address2
        self.Address2_nsprefix_ = None
        self.City = City
        self.City_nsprefix_ = None
        self.Province = Province
        self.Province_nsprefix_ = None
        self.Postcode = Postcode
        self.Postcode_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Phone = Phone
        self.Phone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, AddressInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if AddressInfo.subclass:
            return AddressInfo.subclass(*args_, **kwargs_)
        else:
            return AddressInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ID(self):
        return self.ID
    def set_ID(self, ID):
        self.ID = ID
    def get_Name(self):
        return self.Name
    def set_Name(self, Name):
        self.Name = Name
    def get_Address1(self):
        return self.Address1
    def set_Address1(self, Address1):
        self.Address1 = Address1
    def get_Address2(self):
        return self.Address2
    def set_Address2(self, Address2):
        self.Address2 = Address2
    def get_City(self):
        return self.City
    def set_City(self, City):
        self.City = City
    def get_Province(self):
        return self.Province
    def set_Province(self, Province):
        self.Province = Province
    def get_Postcode(self):
        return self.Postcode
    def set_Postcode(self, Postcode):
        self.Postcode = Postcode
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Phone(self):
        return self.Phone
    def set_Phone(self, Phone):
        self.Phone = Phone
    def _hasContent(self):
        if (
            self.ID is not None or
            self.Name is not None or
            self.Address1 is not None or
            self.Address2 is not None or
            self.City is not None or
            self.Province is not None or
            self.Postcode is not None or
            self.Contact is not None or
            self.Phone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AddressInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('AddressInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'AddressInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='AddressInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='AddressInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='AddressInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='AddressInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ID is not None:
            namespaceprefix_ = self.ID_nsprefix_ + ':' if (UseCapturedNS_ and self.ID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sID>%s</%sID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ID), input_name='ID')), namespaceprefix_ , eol_))
        if self.Name is not None:
            namespaceprefix_ = self.Name_nsprefix_ + ':' if (UseCapturedNS_ and self.Name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sName>%s</%sName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Name), input_name='Name')), namespaceprefix_ , eol_))
        if self.Address1 is not None:
            namespaceprefix_ = self.Address1_nsprefix_ + ':' if (UseCapturedNS_ and self.Address1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddress1>%s</%sAddress1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Address1), input_name='Address1')), namespaceprefix_ , eol_))
        if self.Address2 is not None:
            namespaceprefix_ = self.Address2_nsprefix_ + ':' if (UseCapturedNS_ and self.Address2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddress2>%s</%sAddress2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Address2), input_name='Address2')), namespaceprefix_ , eol_))
        if self.City is not None:
            namespaceprefix_ = self.City_nsprefix_ + ':' if (UseCapturedNS_ and self.City_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCity>%s</%sCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.City), input_name='City')), namespaceprefix_ , eol_))
        if self.Province is not None:
            namespaceprefix_ = self.Province_nsprefix_ + ':' if (UseCapturedNS_ and self.Province_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProvince>%s</%sProvince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Province), input_name='Province')), namespaceprefix_ , eol_))
        if self.Postcode is not None:
            namespaceprefix_ = self.Postcode_nsprefix_ + ':' if (UseCapturedNS_ and self.Postcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPostcode>%s</%sPostcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Postcode), input_name='Postcode')), namespaceprefix_ , eol_))
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContact>%s</%sContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Contact), input_name='Contact')), namespaceprefix_ , eol_))
        if self.Phone is not None:
            namespaceprefix_ = self.Phone_nsprefix_ + ':' if (UseCapturedNS_ and self.Phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhone>%s</%sPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Phone), input_name='Phone')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ID')
            value_ = self.gds_validate_string(value_, node, 'ID')
            self.ID = value_
            self.ID_nsprefix_ = child_.prefix
        elif nodeName_ == 'Name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Name')
            value_ = self.gds_validate_string(value_, node, 'Name')
            self.Name = value_
            self.Name_nsprefix_ = child_.prefix
        elif nodeName_ == 'Address1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Address1')
            value_ = self.gds_validate_string(value_, node, 'Address1')
            self.Address1 = value_
            self.Address1_nsprefix_ = child_.prefix
        elif nodeName_ == 'Address2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Address2')
            value_ = self.gds_validate_string(value_, node, 'Address2')
            self.Address2 = value_
            self.Address2_nsprefix_ = child_.prefix
        elif nodeName_ == 'City':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'City')
            value_ = self.gds_validate_string(value_, node, 'City')
            self.City = value_
            self.City_nsprefix_ = child_.prefix
        elif nodeName_ == 'Province':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Province')
            value_ = self.gds_validate_string(value_, node, 'Province')
            self.Province = value_
            self.Province_nsprefix_ = child_.prefix
        elif nodeName_ == 'Postcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Postcode')
            value_ = self.gds_validate_string(value_, node, 'Postcode')
            self.Postcode = value_
            self.Postcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'Contact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Contact')
            value_ = self.gds_validate_string(value_, node, 'Contact')
            self.Contact = value_
            self.Contact_nsprefix_ = child_.prefix
        elif nodeName_ == 'Phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Phone')
            value_ = self.gds_validate_string(value_, node, 'Phone')
            self.Phone = value_
            self.Phone_nsprefix_ = child_.prefix
# end class AddressInfo


class ValidateShipToInfoResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ValidateShipToInfoResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ValidateShipToInfoResult = ValidateShipToInfoResult
        self.ValidateShipToInfoResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ValidateShipToInfoResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ValidateShipToInfoResponse.subclass:
            return ValidateShipToInfoResponse.subclass(*args_, **kwargs_)
        else:
            return ValidateShipToInfoResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ValidateShipToInfoResult(self):
        return self.ValidateShipToInfoResult
    def set_ValidateShipToInfoResult(self, ValidateShipToInfoResult):
        self.ValidateShipToInfoResult = ValidateShipToInfoResult
    def _hasContent(self):
        if (
            self.ValidateShipToInfoResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateShipToInfoResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ValidateShipToInfoResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ValidateShipToInfoResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ValidateShipToInfoResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ValidateShipToInfoResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ValidateShipToInfoResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ValidateShipToInfoResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ValidateShipToInfoResult is not None:
            namespaceprefix_ = self.ValidateShipToInfoResult_nsprefix_ + ':' if (UseCapturedNS_ and self.ValidateShipToInfoResult_nsprefix_) else ''
            self.ValidateShipToInfoResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ValidateShipToInfoResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ValidateShipToInfoResult':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ValidateShipToInfoResult = obj_
            obj_.original_tagname_ = 'ValidateShipToInfoResult'
# end class ValidateShipToInfoResponse


class CreateShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, ConsigneeInfo=None, PackageInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.ConsigneeInfo = ConsigneeInfo
        self.ConsigneeInfo_nsprefix_ = "tns"
        self.PackageInfo = PackageInfo
        self.PackageInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipment.subclass:
            return CreateShipment.subclass(*args_, **kwargs_)
        else:
            return CreateShipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_ConsigneeInfo(self):
        return self.ConsigneeInfo
    def set_ConsigneeInfo(self, ConsigneeInfo):
        self.ConsigneeInfo = ConsigneeInfo
    def get_PackageInfo(self):
        return self.PackageInfo
    def set_PackageInfo(self, PackageInfo):
        self.PackageInfo = PackageInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.ConsigneeInfo is not None or
            self.PackageInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateShipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateShipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateShipment')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateShipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateShipment'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.ConsigneeInfo is not None:
            namespaceprefix_ = self.ConsigneeInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeInfo_nsprefix_) else ''
            self.ConsigneeInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ConsigneeInfo', pretty_print=pretty_print)
        if self.PackageInfo is not None:
            namespaceprefix_ = self.PackageInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageInfo_nsprefix_) else ''
            self.PackageInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'ConsigneeInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConsigneeInfo = obj_
            obj_.original_tagname_ = 'ConsigneeInfo'
        elif nodeName_ == 'PackageInfo':
            obj_ = PackageInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageInfo = obj_
            obj_.original_tagname_ = 'PackageInfo'
# end class CreateShipment


class Authenticate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AccountID=None, Password=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AccountID = AccountID
        self.AccountID_nsprefix_ = None
        self.Password = Password
        self.Password_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Authenticate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Authenticate.subclass:
            return Authenticate.subclass(*args_, **kwargs_)
        else:
            return Authenticate(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AccountID(self):
        return self.AccountID
    def set_AccountID(self, AccountID):
        self.AccountID = AccountID
    def get_Password(self):
        return self.Password
    def set_Password(self, Password):
        self.Password = Password
    def _hasContent(self):
        if (
            self.AccountID is not None or
            self.Password is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Authenticate', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('Authenticate')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'Authenticate':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='Authenticate')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='Authenticate', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='Authenticate'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='Authenticate', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AccountID is not None:
            namespaceprefix_ = self.AccountID_nsprefix_ + ':' if (UseCapturedNS_ and self.AccountID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccountID>%s</%sAccountID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AccountID), input_name='AccountID')), namespaceprefix_ , eol_))
        if self.Password is not None:
            namespaceprefix_ = self.Password_nsprefix_ + ':' if (UseCapturedNS_ and self.Password_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPassword>%s</%sPassword>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Password), input_name='Password')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AccountID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AccountID')
            value_ = self.gds_validate_string(value_, node, 'AccountID')
            self.AccountID = value_
            self.AccountID_nsprefix_ = child_.prefix
        elif nodeName_ == 'Password':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Password')
            value_ = self.gds_validate_string(value_, node, 'Password')
            self.Password = value_
            self.Password_nsprefix_ = child_.prefix
# end class Authenticate


class PackageInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Product=None, Pieces=None, Contact=None, Phone=None, CostCenter=None, Refereces=None, NotificationEmail=None, SpecialInstruction=None, NoSignatureRequired=None, ShipDate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = "tns"
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Phone = Phone
        self.Phone_nsprefix_ = None
        self.CostCenter = CostCenter
        self.CostCenter_nsprefix_ = None
        self.Refereces = Refereces
        self.Refereces_nsprefix_ = "tns"
        self.NotificationEmail = NotificationEmail
        self.NotificationEmail_nsprefix_ = None
        self.SpecialInstruction = SpecialInstruction
        self.SpecialInstruction_nsprefix_ = None
        self.NoSignatureRequired = NoSignatureRequired
        self.NoSignatureRequired_nsprefix_ = None
        self.ShipDate = ShipDate
        self.ShipDate_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PackageInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PackageInfo.subclass:
            return PackageInfo.subclass(*args_, **kwargs_)
        else:
            return PackageInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Phone(self):
        return self.Phone
    def set_Phone(self, Phone):
        self.Phone = Phone
    def get_CostCenter(self):
        return self.CostCenter
    def set_CostCenter(self, CostCenter):
        self.CostCenter = CostCenter
    def get_Refereces(self):
        return self.Refereces
    def set_Refereces(self, Refereces):
        self.Refereces = Refereces
    def get_NotificationEmail(self):
        return self.NotificationEmail
    def set_NotificationEmail(self, NotificationEmail):
        self.NotificationEmail = NotificationEmail
    def get_SpecialInstruction(self):
        return self.SpecialInstruction
    def set_SpecialInstruction(self, SpecialInstruction):
        self.SpecialInstruction = SpecialInstruction
    def get_NoSignatureRequired(self):
        return self.NoSignatureRequired
    def set_NoSignatureRequired(self, NoSignatureRequired):
        self.NoSignatureRequired = NoSignatureRequired
    def get_ShipDate(self):
        return self.ShipDate
    def set_ShipDate(self, ShipDate):
        self.ShipDate = ShipDate
    def _hasContent(self):
        if (
            self.Product is not None or
            self.Pieces is not None or
            self.Contact is not None or
            self.Phone is not None or
            self.CostCenter is not None or
            self.Refereces is not None or
            self.NotificationEmail is not None or
            self.SpecialInstruction is not None or
            self.NoSignatureRequired is not None or
            self.ShipDate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackageInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PackageInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PackageInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PackageInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PackageInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PackageInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackageInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            self.Pieces.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pieces', pretty_print=pretty_print)
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContact>%s</%sContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Contact), input_name='Contact')), namespaceprefix_ , eol_))
        if self.Phone is not None:
            namespaceprefix_ = self.Phone_nsprefix_ + ':' if (UseCapturedNS_ and self.Phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhone>%s</%sPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Phone), input_name='Phone')), namespaceprefix_ , eol_))
        if self.CostCenter is not None:
            namespaceprefix_ = self.CostCenter_nsprefix_ + ':' if (UseCapturedNS_ and self.CostCenter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCostCenter>%s</%sCostCenter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CostCenter), input_name='CostCenter')), namespaceprefix_ , eol_))
        if self.Refereces is not None:
            namespaceprefix_ = self.Refereces_nsprefix_ + ':' if (UseCapturedNS_ and self.Refereces_nsprefix_) else ''
            self.Refereces.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Refereces', pretty_print=pretty_print)
        if self.NotificationEmail is not None:
            namespaceprefix_ = self.NotificationEmail_nsprefix_ + ':' if (UseCapturedNS_ and self.NotificationEmail_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNotificationEmail>%s</%sNotificationEmail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.NotificationEmail), input_name='NotificationEmail')), namespaceprefix_ , eol_))
        if self.SpecialInstruction is not None:
            namespaceprefix_ = self.SpecialInstruction_nsprefix_ + ':' if (UseCapturedNS_ and self.SpecialInstruction_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSpecialInstruction>%s</%sSpecialInstruction>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SpecialInstruction), input_name='SpecialInstruction')), namespaceprefix_ , eol_))
        if self.NoSignatureRequired is not None:
            namespaceprefix_ = self.NoSignatureRequired_nsprefix_ + ':' if (UseCapturedNS_ and self.NoSignatureRequired_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNoSignatureRequired>%s</%sNoSignatureRequired>%s' % (namespaceprefix_ , self.gds_format_boolean(self.NoSignatureRequired, input_name='NoSignatureRequired'), namespaceprefix_ , eol_))
        if self.ShipDate is not None:
            namespaceprefix_ = self.ShipDate_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipDate>%s</%sShipDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipDate), input_name='ShipDate')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces':
            obj_ = ArrayOfPieceInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Pieces = obj_
            obj_.original_tagname_ = 'Pieces'
        elif nodeName_ == 'Contact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Contact')
            value_ = self.gds_validate_string(value_, node, 'Contact')
            self.Contact = value_
            self.Contact_nsprefix_ = child_.prefix
        elif nodeName_ == 'Phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Phone')
            value_ = self.gds_validate_string(value_, node, 'Phone')
            self.Phone = value_
            self.Phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'CostCenter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CostCenter')
            value_ = self.gds_validate_string(value_, node, 'CostCenter')
            self.CostCenter = value_
            self.CostCenter_nsprefix_ = child_.prefix
        elif nodeName_ == 'Refereces':
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Refereces = obj_
            obj_.original_tagname_ = 'Refereces'
        elif nodeName_ == 'NotificationEmail':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'NotificationEmail')
            value_ = self.gds_validate_string(value_, node, 'NotificationEmail')
            self.NotificationEmail = value_
            self.NotificationEmail_nsprefix_ = child_.prefix
        elif nodeName_ == 'SpecialInstruction':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SpecialInstruction')
            value_ = self.gds_validate_string(value_, node, 'SpecialInstruction')
            self.SpecialInstruction = value_
            self.SpecialInstruction_nsprefix_ = child_.prefix
        elif nodeName_ == 'NoSignatureRequired':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'NoSignatureRequired')
            ival_ = self.gds_validate_boolean(ival_, node, 'NoSignatureRequired')
            self.NoSignatureRequired = ival_
            self.NoSignatureRequired_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipDate')
            value_ = self.gds_validate_string(value_, node, 'ShipDate')
            self.ShipDate = value_
            self.ShipDate_nsprefix_ = child_.prefix
# end class PackageInfo


class ArrayOfPieceInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PieceInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if PieceInfo is None:
            self.PieceInfo = []
        else:
            self.PieceInfo = PieceInfo
        self.PieceInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfPieceInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfPieceInfo.subclass:
            return ArrayOfPieceInfo.subclass(*args_, **kwargs_)
        else:
            return ArrayOfPieceInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PieceInfo(self):
        return self.PieceInfo
    def set_PieceInfo(self, PieceInfo):
        self.PieceInfo = PieceInfo
    def add_PieceInfo(self, value):
        self.PieceInfo.append(value)
    def insert_PieceInfo_at(self, index, value):
        self.PieceInfo.insert(index, value)
    def replace_PieceInfo_at(self, index, value):
        self.PieceInfo[index] = value
    def _hasContent(self):
        if (
            self.PieceInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfPieceInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfPieceInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfPieceInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfPieceInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfPieceInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfPieceInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfPieceInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for PieceInfo_ in self.PieceInfo:
            namespaceprefix_ = self.PieceInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PieceInfo_nsprefix_) else ''
            PieceInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PieceInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PieceInfo':
            obj_ = PieceInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PieceInfo.append(obj_)
            obj_.original_tagname_ = 'PieceInfo'
# end class ArrayOfPieceInfo


class PieceInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Weight=None, WeightUnit=None, Length=None, Width=None, Height=None, DeclaredValue=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Weight = Weight
        self.Weight_nsprefix_ = None
        self.WeightUnit = WeightUnit
        self.WeightUnit_nsprefix_ = None
        self.Length = Length
        self.Length_nsprefix_ = None
        self.Width = Width
        self.Width_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.DeclaredValue_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PieceInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PieceInfo.subclass:
            return PieceInfo.subclass(*args_, **kwargs_)
        else:
            return PieceInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_WeightUnit(self):
        return self.WeightUnit
    def set_WeightUnit(self, WeightUnit):
        self.WeightUnit = WeightUnit
    def get_Length(self):
        return self.Length
    def set_Length(self, Length):
        self.Length = Length
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def _hasContent(self):
        if (
            self.Weight is not None or
            self.WeightUnit is not None or
            self.Length is not None or
            self.Width is not None or
            self.Height is not None or
            self.DeclaredValue is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PieceInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PieceInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PieceInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PieceInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PieceInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PieceInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_double(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.WeightUnit is not None:
            namespaceprefix_ = self.WeightUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.WeightUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeightUnit>%s</%sWeightUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.WeightUnit), input_name='WeightUnit')), namespaceprefix_ , eol_))
        if self.Length is not None:
            namespaceprefix_ = self.Length_nsprefix_ + ':' if (UseCapturedNS_ and self.Length_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLength>%s</%sLength>%s' % (namespaceprefix_ , self.gds_format_double(self.Length, input_name='Length'), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_format_double(self.Width, input_name='Width'), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_format_double(self.Height, input_name='Height'), namespaceprefix_ , eol_))
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_format_double(self.DeclaredValue, input_name='DeclaredValue'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Weight')
            fval_ = self.gds_validate_double(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'WeightUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'WeightUnit')
            value_ = self.gds_validate_string(value_, node, 'WeightUnit')
            self.WeightUnit = value_
            self.WeightUnit_nsprefix_ = child_.prefix
        elif nodeName_ == 'Length' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Length')
            fval_ = self.gds_validate_double(fval_, node, 'Length')
            self.Length = fval_
            self.Length_nsprefix_ = child_.prefix
        elif nodeName_ == 'Width' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Width')
            fval_ = self.gds_validate_double(fval_, node, 'Width')
            self.Width = fval_
            self.Width_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Height')
            fval_ = self.gds_validate_double(fval_, node, 'Height')
            self.Height = fval_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'DeclaredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'DeclaredValue')
            fval_ = self.gds_validate_double(fval_, node, 'DeclaredValue')
            self.DeclaredValue = fval_
            self.DeclaredValue_nsprefix_ = child_.prefix
# end class PieceInfo


class ArrayOfString(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, string=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if string is None:
            self.string = []
        else:
            self.string = string
        self.string_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfString)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfString.subclass:
            return ArrayOfString.subclass(*args_, **kwargs_)
        else:
            return ArrayOfString(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_string(self):
        return self.string
    def set_string(self, string):
        self.string = string
    def add_string(self, value):
        self.string.append(value)
    def insert_string_at(self, index, value):
        self.string.insert(index, value)
    def replace_string_at(self, index, value):
        self.string[index] = value
    def _hasContent(self):
        if (
            self.string
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfString', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfString')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfString':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfString')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfString', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfString'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfString', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for string_ in self.string:
            namespaceprefix_ = self.string_nsprefix_ + ':' if (UseCapturedNS_ and self.string_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstring>%s</%sstring>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(string_), input_name='string')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'string':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'string')
            value_ = self.gds_validate_string(value_, node, 'string')
            self.string.append(value_)
            self.string_nsprefix_ = child_.prefix
# end class ArrayOfString


class CreateShipmentResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CreateShipmentResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CreateShipmentResult = CreateShipmentResult
        self.CreateShipmentResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipmentResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipmentResponse.subclass:
            return CreateShipmentResponse.subclass(*args_, **kwargs_)
        else:
            return CreateShipmentResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CreateShipmentResult(self):
        return self.CreateShipmentResult
    def set_CreateShipmentResult(self, CreateShipmentResult):
        self.CreateShipmentResult = CreateShipmentResult
    def _hasContent(self):
        if (
            self.CreateShipmentResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateShipmentResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateShipmentResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateShipmentResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateShipmentResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateShipmentResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CreateShipmentResult is not None:
            namespaceprefix_ = self.CreateShipmentResult_nsprefix_ + ':' if (UseCapturedNS_ and self.CreateShipmentResult_nsprefix_) else ''
            self.CreateShipmentResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CreateShipmentResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CreateShipmentResult':
            obj_ = ResponseCreateShipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CreateShipmentResult = obj_
            obj_.original_tagname_ = 'CreateShipmentResult'
# end class CreateShipmentResponse


class ResponseCreateShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, ManifestNumber=None, PackageIDAndLink=None, PackageID=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.ManifestNumber = ManifestNumber
        self.ManifestNumber_nsprefix_ = None
        self.PackageIDAndLink = PackageIDAndLink
        self.PackageIDAndLink_nsprefix_ = None
        self.PackageID = PackageID
        self.PackageID_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseCreateShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseCreateShipment.subclass:
            return ResponseCreateShipment.subclass(*args_, **kwargs_)
        else:
            return ResponseCreateShipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_ManifestNumber(self):
        return self.ManifestNumber
    def set_ManifestNumber(self, ManifestNumber):
        self.ManifestNumber = ManifestNumber
    def get_PackageIDAndLink(self):
        return self.PackageIDAndLink
    def set_PackageIDAndLink(self, PackageIDAndLink):
        self.PackageIDAndLink = PackageIDAndLink
    def get_PackageID(self):
        return self.PackageID
    def set_PackageID(self, PackageID):
        self.PackageID = PackageID
    def _hasContent(self):
        if (
            self.Err is not None or
            self.ManifestNumber is not None or
            self.PackageIDAndLink is not None or
            self.PackageID is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCreateShipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseCreateShipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseCreateShipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseCreateShipment')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseCreateShipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseCreateShipment'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCreateShipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.ManifestNumber is not None:
            namespaceprefix_ = self.ManifestNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestNumber>%s</%sManifestNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestNumber), input_name='ManifestNumber')), namespaceprefix_ , eol_))
        if self.PackageIDAndLink is not None:
            namespaceprefix_ = self.PackageIDAndLink_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageIDAndLink_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageIDAndLink>%s</%sPackageIDAndLink>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageIDAndLink), input_name='PackageIDAndLink')), namespaceprefix_ , eol_))
        if self.PackageID is not None:
            namespaceprefix_ = self.PackageID_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageID_nsprefix_) else ''
            self.PackageID.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageID', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'ManifestNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestNumber')
            value_ = self.gds_validate_string(value_, node, 'ManifestNumber')
            self.ManifestNumber = value_
            self.ManifestNumber_nsprefix_ = child_.prefix
        elif nodeName_ == 'PackageIDAndLink':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageIDAndLink')
            value_ = self.gds_validate_string(value_, node, 'PackageIDAndLink')
            self.PackageIDAndLink = value_
            self.PackageIDAndLink_nsprefix_ = child_.prefix
        elif nodeName_ == 'PackageID':
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageID = obj_
            obj_.original_tagname_ = 'PackageID'
# end class ResponseCreateShipment


class CreateShipmentWithLabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, ConsigneeInfo=None, PackageInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.ConsigneeInfo = ConsigneeInfo
        self.ConsigneeInfo_nsprefix_ = "tns"
        self.PackageInfo = PackageInfo
        self.PackageInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipmentWithLabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipmentWithLabelInfo.subclass:
            return CreateShipmentWithLabelInfo.subclass(*args_, **kwargs_)
        else:
            return CreateShipmentWithLabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_ConsigneeInfo(self):
        return self.ConsigneeInfo
    def set_ConsigneeInfo(self, ConsigneeInfo):
        self.ConsigneeInfo = ConsigneeInfo
    def get_PackageInfo(self):
        return self.PackageInfo
    def set_PackageInfo(self, PackageInfo):
        self.PackageInfo = PackageInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.ConsigneeInfo is not None or
            self.PackageInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithLabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateShipmentWithLabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateShipmentWithLabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateShipmentWithLabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateShipmentWithLabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateShipmentWithLabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithLabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.ConsigneeInfo is not None:
            namespaceprefix_ = self.ConsigneeInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeInfo_nsprefix_) else ''
            self.ConsigneeInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ConsigneeInfo', pretty_print=pretty_print)
        if self.PackageInfo is not None:
            namespaceprefix_ = self.PackageInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageInfo_nsprefix_) else ''
            self.PackageInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'ConsigneeInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConsigneeInfo = obj_
            obj_.original_tagname_ = 'ConsigneeInfo'
        elif nodeName_ == 'PackageInfo':
            obj_ = PackageInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageInfo = obj_
            obj_.original_tagname_ = 'PackageInfo'
# end class CreateShipmentWithLabelInfo


class CreateShipmentWithLabelInfoResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CreateShipmentWithLabelInfoResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CreateShipmentWithLabelInfoResult = CreateShipmentWithLabelInfoResult
        self.CreateShipmentWithLabelInfoResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipmentWithLabelInfoResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipmentWithLabelInfoResponse.subclass:
            return CreateShipmentWithLabelInfoResponse.subclass(*args_, **kwargs_)
        else:
            return CreateShipmentWithLabelInfoResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CreateShipmentWithLabelInfoResult(self):
        return self.CreateShipmentWithLabelInfoResult
    def set_CreateShipmentWithLabelInfoResult(self, CreateShipmentWithLabelInfoResult):
        self.CreateShipmentWithLabelInfoResult = CreateShipmentWithLabelInfoResult
    def _hasContent(self):
        if (
            self.CreateShipmentWithLabelInfoResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithLabelInfoResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateShipmentWithLabelInfoResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateShipmentWithLabelInfoResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateShipmentWithLabelInfoResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateShipmentWithLabelInfoResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateShipmentWithLabelInfoResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithLabelInfoResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CreateShipmentWithLabelInfoResult is not None:
            namespaceprefix_ = self.CreateShipmentWithLabelInfoResult_nsprefix_ + ':' if (UseCapturedNS_ and self.CreateShipmentWithLabelInfoResult_nsprefix_) else ''
            self.CreateShipmentWithLabelInfoResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CreateShipmentWithLabelInfoResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CreateShipmentWithLabelInfoResult':
            obj_ = ResponseLabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CreateShipmentWithLabelInfoResult = obj_
            obj_.original_tagname_ = 'CreateShipmentWithLabelInfoResult'
# end class CreateShipmentWithLabelInfoResponse


class ResponseLabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, ManifestNumber=None, LabelInfo=None, PackageIDAndLink=None, BaseCharges=None, InsuranceCharges=None, SurCharges=None, FuelCharges=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.ManifestNumber = ManifestNumber
        self.ManifestNumber_nsprefix_ = None
        self.LabelInfo = LabelInfo
        self.LabelInfo_nsprefix_ = "tns"
        self.PackageIDAndLink = PackageIDAndLink
        self.PackageIDAndLink_nsprefix_ = None
        self.BaseCharges = BaseCharges
        self.BaseCharges_nsprefix_ = None
        self.InsuranceCharges = InsuranceCharges
        self.InsuranceCharges_nsprefix_ = None
        self.SurCharges = SurCharges
        self.SurCharges_nsprefix_ = "tns"
        self.FuelCharges = FuelCharges
        self.FuelCharges_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseLabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseLabelInfo.subclass:
            return ResponseLabelInfo.subclass(*args_, **kwargs_)
        else:
            return ResponseLabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_ManifestNumber(self):
        return self.ManifestNumber
    def set_ManifestNumber(self, ManifestNumber):
        self.ManifestNumber = ManifestNumber
    def get_LabelInfo(self):
        return self.LabelInfo
    def set_LabelInfo(self, LabelInfo):
        self.LabelInfo = LabelInfo
    def get_PackageIDAndLink(self):
        return self.PackageIDAndLink
    def set_PackageIDAndLink(self, PackageIDAndLink):
        self.PackageIDAndLink = PackageIDAndLink
    def get_BaseCharges(self):
        return self.BaseCharges
    def set_BaseCharges(self, BaseCharges):
        self.BaseCharges = BaseCharges
    def get_InsuranceCharges(self):
        return self.InsuranceCharges
    def set_InsuranceCharges(self, InsuranceCharges):
        self.InsuranceCharges = InsuranceCharges
    def get_SurCharges(self):
        return self.SurCharges
    def set_SurCharges(self, SurCharges):
        self.SurCharges = SurCharges
    def get_FuelCharges(self):
        return self.FuelCharges
    def set_FuelCharges(self, FuelCharges):
        self.FuelCharges = FuelCharges
    def _hasContent(self):
        if (
            self.Err is not None or
            self.ManifestNumber is not None or
            self.LabelInfo is not None or
            self.PackageIDAndLink is not None or
            self.BaseCharges is not None or
            self.InsuranceCharges is not None or
            self.SurCharges is not None or
            self.FuelCharges is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseLabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseLabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseLabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseLabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseLabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseLabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseLabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.ManifestNumber is not None:
            namespaceprefix_ = self.ManifestNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestNumber>%s</%sManifestNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestNumber), input_name='ManifestNumber')), namespaceprefix_ , eol_))
        if self.LabelInfo is not None:
            namespaceprefix_ = self.LabelInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.LabelInfo_nsprefix_) else ''
            self.LabelInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LabelInfo', pretty_print=pretty_print)
        if self.PackageIDAndLink is not None:
            namespaceprefix_ = self.PackageIDAndLink_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageIDAndLink_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageIDAndLink>%s</%sPackageIDAndLink>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageIDAndLink), input_name='PackageIDAndLink')), namespaceprefix_ , eol_))
        if self.BaseCharges is not None:
            namespaceprefix_ = self.BaseCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.BaseCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBaseCharges>%s</%sBaseCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.BaseCharges, input_name='BaseCharges'), namespaceprefix_ , eol_))
        if self.InsuranceCharges is not None:
            namespaceprefix_ = self.InsuranceCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuranceCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuranceCharges>%s</%sInsuranceCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.InsuranceCharges, input_name='InsuranceCharges'), namespaceprefix_ , eol_))
        if self.SurCharges is not None:
            namespaceprefix_ = self.SurCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.SurCharges_nsprefix_) else ''
            self.SurCharges.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SurCharges', pretty_print=pretty_print)
        if self.FuelCharges is not None:
            namespaceprefix_ = self.FuelCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.FuelCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFuelCharges>%s</%sFuelCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.FuelCharges, input_name='FuelCharges'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'ManifestNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestNumber')
            value_ = self.gds_validate_string(value_, node, 'ManifestNumber')
            self.ManifestNumber = value_
            self.ManifestNumber_nsprefix_ = child_.prefix
        elif nodeName_ == 'LabelInfo':
            obj_ = ArrayOfLabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LabelInfo = obj_
            obj_.original_tagname_ = 'LabelInfo'
        elif nodeName_ == 'PackageIDAndLink':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageIDAndLink')
            value_ = self.gds_validate_string(value_, node, 'PackageIDAndLink')
            self.PackageIDAndLink = value_
            self.PackageIDAndLink_nsprefix_ = child_.prefix
        elif nodeName_ == 'BaseCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'BaseCharges')
            fval_ = self.gds_validate_double(fval_, node, 'BaseCharges')
            self.BaseCharges = fval_
            self.BaseCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'InsuranceCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'InsuranceCharges')
            fval_ = self.gds_validate_double(fval_, node, 'InsuranceCharges')
            self.InsuranceCharges = fval_
            self.InsuranceCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'SurCharges':
            obj_ = ArrayOfSurCharge.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SurCharges = obj_
            obj_.original_tagname_ = 'SurCharges'
        elif nodeName_ == 'FuelCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'FuelCharges')
            fval_ = self.gds_validate_double(fval_, node, 'FuelCharges')
            self.FuelCharges = fval_
            self.FuelCharges_nsprefix_ = child_.prefix
# end class ResponseLabelInfo


class ArrayOfLabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, LabelInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if LabelInfo is None:
            self.LabelInfo = []
        else:
            self.LabelInfo = LabelInfo
        self.LabelInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfLabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfLabelInfo.subclass:
            return ArrayOfLabelInfo.subclass(*args_, **kwargs_)
        else:
            return ArrayOfLabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_LabelInfo(self):
        return self.LabelInfo
    def set_LabelInfo(self, LabelInfo):
        self.LabelInfo = LabelInfo
    def add_LabelInfo(self, value):
        self.LabelInfo.append(value)
    def insert_LabelInfo_at(self, index, value):
        self.LabelInfo.insert(index, value)
    def replace_LabelInfo_at(self, index, value):
        self.LabelInfo[index] = value
    def _hasContent(self):
        if (
            self.LabelInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfLabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfLabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfLabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfLabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfLabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfLabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfLabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for LabelInfo_ in self.LabelInfo:
            namespaceprefix_ = self.LabelInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.LabelInfo_nsprefix_) else ''
            LabelInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='LabelInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'LabelInfo':
            obj_ = LabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.LabelInfo.append(obj_)
            obj_.original_tagname_ = 'LabelInfo'
# end class ArrayOfLabelInfo


class LabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AirportCode=None, AirportPhone=None, TapConsignee=None, FromInfo=None, ToInfo=None, ToPostcode=None, RouteBranch=None, DriverNotes=None, Weight=None, Insurance=None, ProcessDate=None, Product=None, PIn=None, Pieces=None, Reference=None, Route=None, Branch=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AirportCode = AirportCode
        self.AirportCode_nsprefix_ = None
        self.AirportPhone = AirportPhone
        self.AirportPhone_nsprefix_ = None
        self.TapConsignee = TapConsignee
        self.TapConsignee_nsprefix_ = None
        self.FromInfo = FromInfo
        self.FromInfo_nsprefix_ = None
        self.ToInfo = ToInfo
        self.ToInfo_nsprefix_ = None
        self.ToPostcode = ToPostcode
        self.ToPostcode_nsprefix_ = None
        self.RouteBranch = RouteBranch
        self.RouteBranch_nsprefix_ = None
        self.DriverNotes = DriverNotes
        self.DriverNotes_nsprefix_ = None
        self.Weight = Weight
        self.Weight_nsprefix_ = None
        self.Insurance = Insurance
        self.Insurance_nsprefix_ = None
        self.ProcessDate = ProcessDate
        self.ProcessDate_nsprefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.PIn = PIn
        self.PIn_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.Reference = Reference
        self.Reference_nsprefix_ = None
        self.Route = Route
        self.Route_nsprefix_ = None
        self.Branch = Branch
        self.Branch_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, LabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LabelInfo.subclass:
            return LabelInfo.subclass(*args_, **kwargs_)
        else:
            return LabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AirportCode(self):
        return self.AirportCode
    def set_AirportCode(self, AirportCode):
        self.AirportCode = AirportCode
    def get_AirportPhone(self):
        return self.AirportPhone
    def set_AirportPhone(self, AirportPhone):
        self.AirportPhone = AirportPhone
    def get_TapConsignee(self):
        return self.TapConsignee
    def set_TapConsignee(self, TapConsignee):
        self.TapConsignee = TapConsignee
    def get_FromInfo(self):
        return self.FromInfo
    def set_FromInfo(self, FromInfo):
        self.FromInfo = FromInfo
    def get_ToInfo(self):
        return self.ToInfo
    def set_ToInfo(self, ToInfo):
        self.ToInfo = ToInfo
    def get_ToPostcode(self):
        return self.ToPostcode
    def set_ToPostcode(self, ToPostcode):
        self.ToPostcode = ToPostcode
    def get_RouteBranch(self):
        return self.RouteBranch
    def set_RouteBranch(self, RouteBranch):
        self.RouteBranch = RouteBranch
    def get_DriverNotes(self):
        return self.DriverNotes
    def set_DriverNotes(self, DriverNotes):
        self.DriverNotes = DriverNotes
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_Insurance(self):
        return self.Insurance
    def set_Insurance(self, Insurance):
        self.Insurance = Insurance
    def get_ProcessDate(self):
        return self.ProcessDate
    def set_ProcessDate(self, ProcessDate):
        self.ProcessDate = ProcessDate
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_PIn(self):
        return self.PIn
    def set_PIn(self, PIn):
        self.PIn = PIn
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_Reference(self):
        return self.Reference
    def set_Reference(self, Reference):
        self.Reference = Reference
    def get_Route(self):
        return self.Route
    def set_Route(self, Route):
        self.Route = Route
    def get_Branch(self):
        return self.Branch
    def set_Branch(self, Branch):
        self.Branch = Branch
    def _hasContent(self):
        if (
            self.AirportCode is not None or
            self.AirportPhone is not None or
            self.TapConsignee is not None or
            self.FromInfo is not None or
            self.ToInfo is not None or
            self.ToPostcode is not None or
            self.RouteBranch is not None or
            self.DriverNotes is not None or
            self.Weight is not None or
            self.Insurance is not None or
            self.ProcessDate is not None or
            self.Product is not None or
            self.PIn is not None or
            self.Pieces is not None or
            self.Reference is not None or
            self.Route is not None or
            self.Branch is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('LabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'LabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='LabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='LabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='LabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='LabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AirportCode is not None:
            namespaceprefix_ = self.AirportCode_nsprefix_ + ':' if (UseCapturedNS_ and self.AirportCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAirportCode>%s</%sAirportCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AirportCode), input_name='AirportCode')), namespaceprefix_ , eol_))
        if self.AirportPhone is not None:
            namespaceprefix_ = self.AirportPhone_nsprefix_ + ':' if (UseCapturedNS_ and self.AirportPhone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAirportPhone>%s</%sAirportPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AirportPhone), input_name='AirportPhone')), namespaceprefix_ , eol_))
        if self.TapConsignee is not None:
            namespaceprefix_ = self.TapConsignee_nsprefix_ + ':' if (UseCapturedNS_ and self.TapConsignee_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTapConsignee>%s</%sTapConsignee>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TapConsignee), input_name='TapConsignee')), namespaceprefix_ , eol_))
        if self.FromInfo is not None:
            namespaceprefix_ = self.FromInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.FromInfo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromInfo>%s</%sFromInfo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromInfo), input_name='FromInfo')), namespaceprefix_ , eol_))
        if self.ToInfo is not None:
            namespaceprefix_ = self.ToInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ToInfo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sToInfo>%s</%sToInfo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ToInfo), input_name='ToInfo')), namespaceprefix_ , eol_))
        if self.ToPostcode is not None:
            namespaceprefix_ = self.ToPostcode_nsprefix_ + ':' if (UseCapturedNS_ and self.ToPostcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sToPostcode>%s</%sToPostcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ToPostcode), input_name='ToPostcode')), namespaceprefix_ , eol_))
        if self.RouteBranch is not None:
            namespaceprefix_ = self.RouteBranch_nsprefix_ + ':' if (UseCapturedNS_ and self.RouteBranch_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRouteBranch>%s</%sRouteBranch>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.RouteBranch), input_name='RouteBranch')), namespaceprefix_ , eol_))
        if self.DriverNotes is not None:
            namespaceprefix_ = self.DriverNotes_nsprefix_ + ':' if (UseCapturedNS_ and self.DriverNotes_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDriverNotes>%s</%sDriverNotes>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DriverNotes), input_name='DriverNotes')), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Weight), input_name='Weight')), namespaceprefix_ , eol_))
        if self.Insurance is not None:
            namespaceprefix_ = self.Insurance_nsprefix_ + ':' if (UseCapturedNS_ and self.Insurance_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsurance>%s</%sInsurance>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Insurance), input_name='Insurance')), namespaceprefix_ , eol_))
        if self.ProcessDate is not None:
            namespaceprefix_ = self.ProcessDate_nsprefix_ + ':' if (UseCapturedNS_ and self.ProcessDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProcessDate>%s</%sProcessDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ProcessDate), input_name='ProcessDate')), namespaceprefix_ , eol_))
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.PIn is not None:
            namespaceprefix_ = self.PIn_nsprefix_ + ':' if (UseCapturedNS_ and self.PIn_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPIn>%s</%sPIn>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PIn), input_name='PIn')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieces>%s</%sPieces>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Pieces), input_name='Pieces')), namespaceprefix_ , eol_))
        if self.Reference is not None:
            namespaceprefix_ = self.Reference_nsprefix_ + ':' if (UseCapturedNS_ and self.Reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference>%s</%sReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Reference), input_name='Reference')), namespaceprefix_ , eol_))
        if self.Route is not None:
            namespaceprefix_ = self.Route_nsprefix_ + ':' if (UseCapturedNS_ and self.Route_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRoute>%s</%sRoute>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Route), input_name='Route')), namespaceprefix_ , eol_))
        if self.Branch is not None:
            namespaceprefix_ = self.Branch_nsprefix_ + ':' if (UseCapturedNS_ and self.Branch_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBranch>%s</%sBranch>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Branch), input_name='Branch')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AirportCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AirportCode')
            value_ = self.gds_validate_string(value_, node, 'AirportCode')
            self.AirportCode = value_
            self.AirportCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'AirportPhone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AirportPhone')
            value_ = self.gds_validate_string(value_, node, 'AirportPhone')
            self.AirportPhone = value_
            self.AirportPhone_nsprefix_ = child_.prefix
        elif nodeName_ == 'TapConsignee':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TapConsignee')
            value_ = self.gds_validate_string(value_, node, 'TapConsignee')
            self.TapConsignee = value_
            self.TapConsignee_nsprefix_ = child_.prefix
        elif nodeName_ == 'FromInfo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromInfo')
            value_ = self.gds_validate_string(value_, node, 'FromInfo')
            self.FromInfo = value_
            self.FromInfo_nsprefix_ = child_.prefix
        elif nodeName_ == 'ToInfo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ToInfo')
            value_ = self.gds_validate_string(value_, node, 'ToInfo')
            self.ToInfo = value_
            self.ToInfo_nsprefix_ = child_.prefix
        elif nodeName_ == 'ToPostcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ToPostcode')
            value_ = self.gds_validate_string(value_, node, 'ToPostcode')
            self.ToPostcode = value_
            self.ToPostcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'RouteBranch':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'RouteBranch')
            value_ = self.gds_validate_string(value_, node, 'RouteBranch')
            self.RouteBranch = value_
            self.RouteBranch_nsprefix_ = child_.prefix
        elif nodeName_ == 'DriverNotes':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DriverNotes')
            value_ = self.gds_validate_string(value_, node, 'DriverNotes')
            self.DriverNotes = value_
            self.DriverNotes_nsprefix_ = child_.prefix
        elif nodeName_ == 'Weight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Weight')
            value_ = self.gds_validate_string(value_, node, 'Weight')
            self.Weight = value_
            self.Weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'Insurance':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Insurance')
            value_ = self.gds_validate_string(value_, node, 'Insurance')
            self.Insurance = value_
            self.Insurance_nsprefix_ = child_.prefix
        elif nodeName_ == 'ProcessDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ProcessDate')
            value_ = self.gds_validate_string(value_, node, 'ProcessDate')
            self.ProcessDate = value_
            self.ProcessDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'PIn':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PIn')
            value_ = self.gds_validate_string(value_, node, 'PIn')
            self.PIn = value_
            self.PIn_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Pieces')
            value_ = self.gds_validate_string(value_, node, 'Pieces')
            self.Pieces = value_
            self.Pieces_nsprefix_ = child_.prefix
        elif nodeName_ == 'Reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Reference')
            value_ = self.gds_validate_string(value_, node, 'Reference')
            self.Reference = value_
            self.Reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'Route':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Route')
            value_ = self.gds_validate_string(value_, node, 'Route')
            self.Route = value_
            self.Route_nsprefix_ = child_.prefix
        elif nodeName_ == 'Branch':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Branch')
            value_ = self.gds_validate_string(value_, node, 'Branch')
            self.Branch = value_
            self.Branch_nsprefix_ = child_.prefix
# end class LabelInfo


class ArrayOfSurCharge(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, SurCharge=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if SurCharge is None:
            self.SurCharge = []
        else:
            self.SurCharge = SurCharge
        self.SurCharge_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfSurCharge)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfSurCharge.subclass:
            return ArrayOfSurCharge.subclass(*args_, **kwargs_)
        else:
            return ArrayOfSurCharge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_SurCharge(self):
        return self.SurCharge
    def set_SurCharge(self, SurCharge):
        self.SurCharge = SurCharge
    def add_SurCharge(self, value):
        self.SurCharge.append(value)
    def insert_SurCharge_at(self, index, value):
        self.SurCharge.insert(index, value)
    def replace_SurCharge_at(self, index, value):
        self.SurCharge[index] = value
    def _hasContent(self):
        if (
            self.SurCharge
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfSurCharge', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfSurCharge')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfSurCharge':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfSurCharge')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfSurCharge', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfSurCharge'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfSurCharge', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for SurCharge_ in self.SurCharge:
            namespaceprefix_ = self.SurCharge_nsprefix_ + ':' if (UseCapturedNS_ and self.SurCharge_nsprefix_) else ''
            SurCharge_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SurCharge', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SurCharge':
            obj_ = SurCharge.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SurCharge.append(obj_)
            obj_.original_tagname_ = 'SurCharge'
# end class ArrayOfSurCharge


class SurCharge(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, SurChargeName=None, SurChargeAmount=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.SurChargeName = SurChargeName
        self.SurChargeName_nsprefix_ = None
        self.SurChargeAmount = SurChargeAmount
        self.SurChargeAmount_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SurCharge)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SurCharge.subclass:
            return SurCharge.subclass(*args_, **kwargs_)
        else:
            return SurCharge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_SurChargeName(self):
        return self.SurChargeName
    def set_SurChargeName(self, SurChargeName):
        self.SurChargeName = SurChargeName
    def get_SurChargeAmount(self):
        return self.SurChargeAmount
    def set_SurChargeAmount(self, SurChargeAmount):
        self.SurChargeAmount = SurChargeAmount
    def _hasContent(self):
        if (
            self.SurChargeName is not None or
            self.SurChargeAmount is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SurCharge', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('SurCharge')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'SurCharge':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='SurCharge')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='SurCharge', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='SurCharge'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='SurCharge', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.SurChargeName is not None:
            namespaceprefix_ = self.SurChargeName_nsprefix_ + ':' if (UseCapturedNS_ and self.SurChargeName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSurChargeName>%s</%sSurChargeName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SurChargeName), input_name='SurChargeName')), namespaceprefix_ , eol_))
        if self.SurChargeAmount is not None:
            namespaceprefix_ = self.SurChargeAmount_nsprefix_ + ':' if (UseCapturedNS_ and self.SurChargeAmount_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSurChargeAmount>%s</%sSurChargeAmount>%s' % (namespaceprefix_ , self.gds_format_double(self.SurChargeAmount, input_name='SurChargeAmount'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'SurChargeName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SurChargeName')
            value_ = self.gds_validate_string(value_, node, 'SurChargeName')
            self.SurChargeName = value_
            self.SurChargeName_nsprefix_ = child_.prefix
        elif nodeName_ == 'SurChargeAmount' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'SurChargeAmount')
            fval_ = self.gds_validate_double(fval_, node, 'SurChargeAmount')
            self.SurChargeAmount = fval_
            self.SurChargeAmount_nsprefix_ = child_.prefix
# end class SurCharge


class CreateShipmentWithShipperDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, ConsigneeInfo=None, PackageInfo=None, ShipperInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.ConsigneeInfo = ConsigneeInfo
        self.ConsigneeInfo_nsprefix_ = "tns"
        self.PackageInfo = PackageInfo
        self.PackageInfo_nsprefix_ = "tns"
        self.ShipperInfo = ShipperInfo
        self.ShipperInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipmentWithShipperDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipmentWithShipperDetail.subclass:
            return CreateShipmentWithShipperDetail.subclass(*args_, **kwargs_)
        else:
            return CreateShipmentWithShipperDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_ConsigneeInfo(self):
        return self.ConsigneeInfo
    def set_ConsigneeInfo(self, ConsigneeInfo):
        self.ConsigneeInfo = ConsigneeInfo
    def get_PackageInfo(self):
        return self.PackageInfo
    def set_PackageInfo(self, PackageInfo):
        self.PackageInfo = PackageInfo
    def get_ShipperInfo(self):
        return self.ShipperInfo
    def set_ShipperInfo(self, ShipperInfo):
        self.ShipperInfo = ShipperInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.ConsigneeInfo is not None or
            self.PackageInfo is not None or
            self.ShipperInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithShipperDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateShipmentWithShipperDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateShipmentWithShipperDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateShipmentWithShipperDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateShipmentWithShipperDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateShipmentWithShipperDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithShipperDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.ConsigneeInfo is not None:
            namespaceprefix_ = self.ConsigneeInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeInfo_nsprefix_) else ''
            self.ConsigneeInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ConsigneeInfo', pretty_print=pretty_print)
        if self.PackageInfo is not None:
            namespaceprefix_ = self.PackageInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageInfo_nsprefix_) else ''
            self.PackageInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageInfo', pretty_print=pretty_print)
        if self.ShipperInfo is not None:
            namespaceprefix_ = self.ShipperInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperInfo_nsprefix_) else ''
            self.ShipperInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ShipperInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'ConsigneeInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConsigneeInfo = obj_
            obj_.original_tagname_ = 'ConsigneeInfo'
        elif nodeName_ == 'PackageInfo':
            obj_ = PackageInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageInfo = obj_
            obj_.original_tagname_ = 'PackageInfo'
        elif nodeName_ == 'ShipperInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ShipperInfo = obj_
            obj_.original_tagname_ = 'ShipperInfo'
# end class CreateShipmentWithShipperDetail


class CreateShipmentWithShipperDetailResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CreateShipmentWithShipperDetailResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CreateShipmentWithShipperDetailResult = CreateShipmentWithShipperDetailResult
        self.CreateShipmentWithShipperDetailResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateShipmentWithShipperDetailResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateShipmentWithShipperDetailResponse.subclass:
            return CreateShipmentWithShipperDetailResponse.subclass(*args_, **kwargs_)
        else:
            return CreateShipmentWithShipperDetailResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CreateShipmentWithShipperDetailResult(self):
        return self.CreateShipmentWithShipperDetailResult
    def set_CreateShipmentWithShipperDetailResult(self, CreateShipmentWithShipperDetailResult):
        self.CreateShipmentWithShipperDetailResult = CreateShipmentWithShipperDetailResult
    def _hasContent(self):
        if (
            self.CreateShipmentWithShipperDetailResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithShipperDetailResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateShipmentWithShipperDetailResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateShipmentWithShipperDetailResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateShipmentWithShipperDetailResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateShipmentWithShipperDetailResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateShipmentWithShipperDetailResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateShipmentWithShipperDetailResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CreateShipmentWithShipperDetailResult is not None:
            namespaceprefix_ = self.CreateShipmentWithShipperDetailResult_nsprefix_ + ':' if (UseCapturedNS_ and self.CreateShipmentWithShipperDetailResult_nsprefix_) else ''
            self.CreateShipmentWithShipperDetailResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CreateShipmentWithShipperDetailResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CreateShipmentWithShipperDetailResult':
            obj_ = ResponseLabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CreateShipmentWithShipperDetailResult = obj_
            obj_.original_tagname_ = 'CreateShipmentWithShipperDetailResult'
# end class CreateShipmentWithShipperDetailResponse


class GetCloseManifestPDF(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, ManifestNumber=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.ManifestNumber = ManifestNumber
        self.ManifestNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetCloseManifestPDF)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetCloseManifestPDF.subclass:
            return GetCloseManifestPDF.subclass(*args_, **kwargs_)
        else:
            return GetCloseManifestPDF(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_ManifestNumber(self):
        return self.ManifestNumber
    def set_ManifestNumber(self, ManifestNumber):
        self.ManifestNumber = ManifestNumber
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.ManifestNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCloseManifestPDF', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetCloseManifestPDF')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetCloseManifestPDF':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetCloseManifestPDF')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetCloseManifestPDF', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetCloseManifestPDF'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCloseManifestPDF', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.ManifestNumber is not None:
            namespaceprefix_ = self.ManifestNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestNumber>%s</%sManifestNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestNumber), input_name='ManifestNumber')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'ManifestNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestNumber')
            value_ = self.gds_validate_string(value_, node, 'ManifestNumber')
            self.ManifestNumber = value_
            self.ManifestNumber_nsprefix_ = child_.prefix
# end class GetCloseManifestPDF


class GetCloseManifestPDFResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, GetCloseManifestPDFResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.GetCloseManifestPDFResult = GetCloseManifestPDFResult
        self.GetCloseManifestPDFResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetCloseManifestPDFResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetCloseManifestPDFResponse.subclass:
            return GetCloseManifestPDFResponse.subclass(*args_, **kwargs_)
        else:
            return GetCloseManifestPDFResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_GetCloseManifestPDFResult(self):
        return self.GetCloseManifestPDFResult
    def set_GetCloseManifestPDFResult(self, GetCloseManifestPDFResult):
        self.GetCloseManifestPDFResult = GetCloseManifestPDFResult
    def _hasContent(self):
        if (
            self.GetCloseManifestPDFResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCloseManifestPDFResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetCloseManifestPDFResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetCloseManifestPDFResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetCloseManifestPDFResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetCloseManifestPDFResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetCloseManifestPDFResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetCloseManifestPDFResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GetCloseManifestPDFResult is not None:
            namespaceprefix_ = self.GetCloseManifestPDFResult_nsprefix_ + ':' if (UseCapturedNS_ and self.GetCloseManifestPDFResult_nsprefix_) else ''
            self.GetCloseManifestPDFResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GetCloseManifestPDFResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'GetCloseManifestPDFResult':
            obj_ = ResponseCloseManifestPDF.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GetCloseManifestPDFResult = obj_
            obj_.original_tagname_ = 'GetCloseManifestPDFResult'
# end class GetCloseManifestPDFResponse


class ResponseCloseManifestPDF(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, err=None, ManifestLink=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.err = err
        self.err_nsprefix_ = "tns"
        self.ManifestLink = ManifestLink
        self.ManifestLink_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseCloseManifestPDF)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseCloseManifestPDF.subclass:
            return ResponseCloseManifestPDF.subclass(*args_, **kwargs_)
        else:
            return ResponseCloseManifestPDF(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_err(self):
        return self.err
    def set_err(self, err):
        self.err = err
    def get_ManifestLink(self):
        return self.ManifestLink
    def set_ManifestLink(self, ManifestLink):
        self.ManifestLink = ManifestLink
    def _hasContent(self):
        if (
            self.err is not None or
            self.ManifestLink is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCloseManifestPDF', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseCloseManifestPDF')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseCloseManifestPDF':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseCloseManifestPDF')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseCloseManifestPDF', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseCloseManifestPDF'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCloseManifestPDF', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.err is not None:
            namespaceprefix_ = self.err_nsprefix_ + ':' if (UseCapturedNS_ and self.err_nsprefix_) else ''
            self.err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='err', pretty_print=pretty_print)
        if self.ManifestLink is not None:
            namespaceprefix_ = self.ManifestLink_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestLink_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestLink>%s</%sManifestLink>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestLink), input_name='ManifestLink')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.err = obj_
            obj_.original_tagname_ = 'err'
        elif nodeName_ == 'ManifestLink':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestLink')
            value_ = self.gds_validate_string(value_, node, 'ManifestLink')
            self.ManifestLink = value_
            self.ManifestLink_nsprefix_ = child_.prefix
# end class ResponseCloseManifestPDF


class GetEstimatedCharges(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, PkgInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.PkgInfo = PkgInfo
        self.PkgInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetEstimatedCharges)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetEstimatedCharges.subclass:
            return GetEstimatedCharges.subclass(*args_, **kwargs_)
        else:
            return GetEstimatedCharges(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_PkgInfo(self):
        return self.PkgInfo
    def set_PkgInfo(self, PkgInfo):
        self.PkgInfo = PkgInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.PkgInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetEstimatedCharges', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetEstimatedCharges')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetEstimatedCharges':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetEstimatedCharges')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetEstimatedCharges', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetEstimatedCharges'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetEstimatedCharges', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.PkgInfo is not None:
            namespaceprefix_ = self.PkgInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PkgInfo_nsprefix_) else ''
            self.PkgInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PkgInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'PkgInfo':
            obj_ = PackgeInfoToGetCharges.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PkgInfo = obj_
            obj_.original_tagname_ = 'PkgInfo'
# end class GetEstimatedCharges


class PackgeInfoToGetCharges(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Product=None, Pieces=None, FromPost=None, ToPost=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = "tns"
        self.FromPost = FromPost
        self.FromPost_nsprefix_ = None
        self.ToPost = ToPost
        self.ToPost_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PackgeInfoToGetCharges)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PackgeInfoToGetCharges.subclass:
            return PackgeInfoToGetCharges.subclass(*args_, **kwargs_)
        else:
            return PackgeInfoToGetCharges(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_FromPost(self):
        return self.FromPost
    def set_FromPost(self, FromPost):
        self.FromPost = FromPost
    def get_ToPost(self):
        return self.ToPost
    def set_ToPost(self, ToPost):
        self.ToPost = ToPost
    def _hasContent(self):
        if (
            self.Product is not None or
            self.Pieces is not None or
            self.FromPost is not None or
            self.ToPost is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackgeInfoToGetCharges', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PackgeInfoToGetCharges')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PackgeInfoToGetCharges':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PackgeInfoToGetCharges')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PackgeInfoToGetCharges', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PackgeInfoToGetCharges'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackgeInfoToGetCharges', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            self.Pieces.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Pieces', pretty_print=pretty_print)
        if self.FromPost is not None:
            namespaceprefix_ = self.FromPost_nsprefix_ + ':' if (UseCapturedNS_ and self.FromPost_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromPost>%s</%sFromPost>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromPost), input_name='FromPost')), namespaceprefix_ , eol_))
        if self.ToPost is not None:
            namespaceprefix_ = self.ToPost_nsprefix_ + ':' if (UseCapturedNS_ and self.ToPost_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sToPost>%s</%sToPost>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ToPost), input_name='ToPost')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces':
            obj_ = ArrayOfPieceInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Pieces = obj_
            obj_.original_tagname_ = 'Pieces'
        elif nodeName_ == 'FromPost':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromPost')
            value_ = self.gds_validate_string(value_, node, 'FromPost')
            self.FromPost = value_
            self.FromPost_nsprefix_ = child_.prefix
        elif nodeName_ == 'ToPost':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ToPost')
            value_ = self.gds_validate_string(value_, node, 'ToPost')
            self.ToPost = value_
            self.ToPost_nsprefix_ = child_.prefix
# end class PackgeInfoToGetCharges


class GetEstimatedChargesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, GetEstimatedChargesResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.GetEstimatedChargesResult = GetEstimatedChargesResult
        self.GetEstimatedChargesResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetEstimatedChargesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetEstimatedChargesResponse.subclass:
            return GetEstimatedChargesResponse.subclass(*args_, **kwargs_)
        else:
            return GetEstimatedChargesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_GetEstimatedChargesResult(self):
        return self.GetEstimatedChargesResult
    def set_GetEstimatedChargesResult(self, GetEstimatedChargesResult):
        self.GetEstimatedChargesResult = GetEstimatedChargesResult
    def _hasContent(self):
        if (
            self.GetEstimatedChargesResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetEstimatedChargesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetEstimatedChargesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetEstimatedChargesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetEstimatedChargesResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetEstimatedChargesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetEstimatedChargesResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetEstimatedChargesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GetEstimatedChargesResult is not None:
            namespaceprefix_ = self.GetEstimatedChargesResult_nsprefix_ + ':' if (UseCapturedNS_ and self.GetEstimatedChargesResult_nsprefix_) else ''
            self.GetEstimatedChargesResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GetEstimatedChargesResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'GetEstimatedChargesResult':
            obj_ = ResponseGetCharges.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GetEstimatedChargesResult = obj_
            obj_.original_tagname_ = 'GetEstimatedChargesResult'
# end class GetEstimatedChargesResponse


class ResponseGetCharges(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, BaseCharges=None, InsuranceCharges=None, SurCharges=None, FuelCharges=None, Zone=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.BaseCharges = BaseCharges
        self.BaseCharges_nsprefix_ = None
        self.InsuranceCharges = InsuranceCharges
        self.InsuranceCharges_nsprefix_ = None
        self.SurCharges = SurCharges
        self.SurCharges_nsprefix_ = "tns"
        self.FuelCharges = FuelCharges
        self.FuelCharges_nsprefix_ = None
        self.Zone = Zone
        self.Zone_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseGetCharges)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseGetCharges.subclass:
            return ResponseGetCharges.subclass(*args_, **kwargs_)
        else:
            return ResponseGetCharges(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_BaseCharges(self):
        return self.BaseCharges
    def set_BaseCharges(self, BaseCharges):
        self.BaseCharges = BaseCharges
    def get_InsuranceCharges(self):
        return self.InsuranceCharges
    def set_InsuranceCharges(self, InsuranceCharges):
        self.InsuranceCharges = InsuranceCharges
    def get_SurCharges(self):
        return self.SurCharges
    def set_SurCharges(self, SurCharges):
        self.SurCharges = SurCharges
    def get_FuelCharges(self):
        return self.FuelCharges
    def set_FuelCharges(self, FuelCharges):
        self.FuelCharges = FuelCharges
    def get_Zone(self):
        return self.Zone
    def set_Zone(self, Zone):
        self.Zone = Zone
    def _hasContent(self):
        if (
            self.Err is not None or
            self.BaseCharges is not None or
            self.InsuranceCharges is not None or
            self.SurCharges is not None or
            self.FuelCharges is not None or
            self.Zone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseGetCharges', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseGetCharges')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseGetCharges':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseGetCharges')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseGetCharges', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseGetCharges'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseGetCharges', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.BaseCharges is not None:
            namespaceprefix_ = self.BaseCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.BaseCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBaseCharges>%s</%sBaseCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.BaseCharges, input_name='BaseCharges'), namespaceprefix_ , eol_))
        if self.InsuranceCharges is not None:
            namespaceprefix_ = self.InsuranceCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuranceCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuranceCharges>%s</%sInsuranceCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.InsuranceCharges, input_name='InsuranceCharges'), namespaceprefix_ , eol_))
        if self.SurCharges is not None:
            namespaceprefix_ = self.SurCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.SurCharges_nsprefix_) else ''
            self.SurCharges.export(outfile, level, namespaceprefix_, namespacedef_='', name_='SurCharges', pretty_print=pretty_print)
        if self.FuelCharges is not None:
            namespaceprefix_ = self.FuelCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.FuelCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFuelCharges>%s</%sFuelCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.FuelCharges, input_name='FuelCharges'), namespaceprefix_ , eol_))
        if self.Zone is not None:
            namespaceprefix_ = self.Zone_nsprefix_ + ':' if (UseCapturedNS_ and self.Zone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sZone>%s</%sZone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Zone), input_name='Zone')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'BaseCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'BaseCharges')
            fval_ = self.gds_validate_double(fval_, node, 'BaseCharges')
            self.BaseCharges = fval_
            self.BaseCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'InsuranceCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'InsuranceCharges')
            fval_ = self.gds_validate_double(fval_, node, 'InsuranceCharges')
            self.InsuranceCharges = fval_
            self.InsuranceCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'SurCharges':
            obj_ = ArrayOfSurCharge.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.SurCharges = obj_
            obj_.original_tagname_ = 'SurCharges'
        elif nodeName_ == 'FuelCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'FuelCharges')
            fval_ = self.gds_validate_double(fval_, node, 'FuelCharges')
            self.FuelCharges = fval_
            self.FuelCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'Zone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Zone')
            value_ = self.gds_validate_string(value_, node, 'Zone')
            self.Zone = value_
            self.Zone_nsprefix_ = child_.prefix
# end class ResponseGetCharges


class VoidPackages(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, Packages=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.Packages = Packages
        self.Packages_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoidPackages)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoidPackages.subclass:
            return VoidPackages.subclass(*args_, **kwargs_)
        else:
            return VoidPackages(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_Packages(self):
        return self.Packages
    def set_Packages(self, Packages):
        self.Packages = Packages
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.Packages is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPackages', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VoidPackages')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VoidPackages':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VoidPackages')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VoidPackages', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VoidPackages'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPackages', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.Packages is not None:
            namespaceprefix_ = self.Packages_nsprefix_ + ':' if (UseCapturedNS_ and self.Packages_nsprefix_) else ''
            self.Packages.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Packages', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'Packages':
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Packages = obj_
            obj_.original_tagname_ = 'Packages'
# end class VoidPackages


class VoidPackagesResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, VoidPackagesResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.VoidPackagesResult = VoidPackagesResult
        self.VoidPackagesResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoidPackagesResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoidPackagesResponse.subclass:
            return VoidPackagesResponse.subclass(*args_, **kwargs_)
        else:
            return VoidPackagesResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_VoidPackagesResult(self):
        return self.VoidPackagesResult
    def set_VoidPackagesResult(self, VoidPackagesResult):
        self.VoidPackagesResult = VoidPackagesResult
    def _hasContent(self):
        if (
            self.VoidPackagesResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPackagesResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('VoidPackagesResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'VoidPackagesResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='VoidPackagesResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='VoidPackagesResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='VoidPackagesResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='VoidPackagesResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.VoidPackagesResult is not None:
            namespaceprefix_ = self.VoidPackagesResult_nsprefix_ + ':' if (UseCapturedNS_ and self.VoidPackagesResult_nsprefix_) else ''
            self.VoidPackagesResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='VoidPackagesResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'VoidPackagesResult':
            obj_ = ResponseVoidPackage.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.VoidPackagesResult = obj_
            obj_.original_tagname_ = 'VoidPackagesResult'
# end class VoidPackagesResponse


class ResponseVoidPackage(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, err=None, PackageVoidStatus=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.err = err
        self.err_nsprefix_ = "tns"
        self.PackageVoidStatus = PackageVoidStatus
        self.PackageVoidStatus_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseVoidPackage)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseVoidPackage.subclass:
            return ResponseVoidPackage.subclass(*args_, **kwargs_)
        else:
            return ResponseVoidPackage(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_err(self):
        return self.err
    def set_err(self, err):
        self.err = err
    def get_PackageVoidStatus(self):
        return self.PackageVoidStatus
    def set_PackageVoidStatus(self, PackageVoidStatus):
        self.PackageVoidStatus = PackageVoidStatus
    def _hasContent(self):
        if (
            self.err is not None or
            self.PackageVoidStatus is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseVoidPackage', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseVoidPackage')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseVoidPackage':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseVoidPackage')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseVoidPackage', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseVoidPackage'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseVoidPackage', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.err is not None:
            namespaceprefix_ = self.err_nsprefix_ + ':' if (UseCapturedNS_ and self.err_nsprefix_) else ''
            self.err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='err', pretty_print=pretty_print)
        if self.PackageVoidStatus is not None:
            namespaceprefix_ = self.PackageVoidStatus_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageVoidStatus_nsprefix_) else ''
            self.PackageVoidStatus.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageVoidStatus', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.err = obj_
            obj_.original_tagname_ = 'err'
        elif nodeName_ == 'PackageVoidStatus':
            obj_ = ArrayOfPackageVoidStatus.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageVoidStatus = obj_
            obj_.original_tagname_ = 'PackageVoidStatus'
# end class ResponseVoidPackage


class ArrayOfPackageVoidStatus(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PackageVoidStatus=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if PackageVoidStatus is None:
            self.PackageVoidStatus = []
        else:
            self.PackageVoidStatus = PackageVoidStatus
        self.PackageVoidStatus_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfPackageVoidStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfPackageVoidStatus.subclass:
            return ArrayOfPackageVoidStatus.subclass(*args_, **kwargs_)
        else:
            return ArrayOfPackageVoidStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PackageVoidStatus(self):
        return self.PackageVoidStatus
    def set_PackageVoidStatus(self, PackageVoidStatus):
        self.PackageVoidStatus = PackageVoidStatus
    def add_PackageVoidStatus(self, value):
        self.PackageVoidStatus.append(value)
    def insert_PackageVoidStatus_at(self, index, value):
        self.PackageVoidStatus.insert(index, value)
    def replace_PackageVoidStatus_at(self, index, value):
        self.PackageVoidStatus[index] = value
    def _hasContent(self):
        if (
            self.PackageVoidStatus
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfPackageVoidStatus', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfPackageVoidStatus')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfPackageVoidStatus':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfPackageVoidStatus')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfPackageVoidStatus', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfPackageVoidStatus'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfPackageVoidStatus', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for PackageVoidStatus_ in self.PackageVoidStatus:
            namespaceprefix_ = self.PackageVoidStatus_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageVoidStatus_nsprefix_) else ''
            PackageVoidStatus_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageVoidStatus', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PackageVoidStatus':
            obj_ = PackageVoidStatus.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageVoidStatus.append(obj_)
            obj_.original_tagname_ = 'PackageVoidStatus'
# end class ArrayOfPackageVoidStatus


class PackageVoidStatus(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, HeaderPin=None, VoidStatus=None, Err=None, Packages=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.HeaderPin = HeaderPin
        self.HeaderPin_nsprefix_ = None
        self.VoidStatus = VoidStatus
        self.VoidStatus_nsprefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.Packages = Packages
        self.Packages_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PackageVoidStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PackageVoidStatus.subclass:
            return PackageVoidStatus.subclass(*args_, **kwargs_)
        else:
            return PackageVoidStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_HeaderPin(self):
        return self.HeaderPin
    def set_HeaderPin(self, HeaderPin):
        self.HeaderPin = HeaderPin
    def get_VoidStatus(self):
        return self.VoidStatus
    def set_VoidStatus(self, VoidStatus):
        self.VoidStatus = VoidStatus
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_Packages(self):
        return self.Packages
    def set_Packages(self, Packages):
        self.Packages = Packages
    def _hasContent(self):
        if (
            self.HeaderPin is not None or
            self.VoidStatus is not None or
            self.Err is not None or
            self.Packages is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackageVoidStatus', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PackageVoidStatus')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PackageVoidStatus':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PackageVoidStatus')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PackageVoidStatus', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PackageVoidStatus'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackageVoidStatus', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.HeaderPin is not None:
            namespaceprefix_ = self.HeaderPin_nsprefix_ + ':' if (UseCapturedNS_ and self.HeaderPin_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeaderPin>%s</%sHeaderPin>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.HeaderPin), input_name='HeaderPin')), namespaceprefix_ , eol_))
        if self.VoidStatus is not None:
            namespaceprefix_ = self.VoidStatus_nsprefix_ + ':' if (UseCapturedNS_ and self.VoidStatus_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVoidStatus>%s</%sVoidStatus>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.VoidStatus), input_name='VoidStatus')), namespaceprefix_ , eol_))
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.Packages is not None:
            namespaceprefix_ = self.Packages_nsprefix_ + ':' if (UseCapturedNS_ and self.Packages_nsprefix_) else ''
            self.Packages.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Packages', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'HeaderPin':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'HeaderPin')
            value_ = self.gds_validate_string(value_, node, 'HeaderPin')
            self.HeaderPin = value_
            self.HeaderPin_nsprefix_ = child_.prefix
        elif nodeName_ == 'VoidStatus':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'VoidStatus')
            value_ = self.gds_validate_string(value_, node, 'VoidStatus')
            self.VoidStatus = value_
            self.VoidStatus_nsprefix_ = child_.prefix
        elif nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'Packages':
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Packages = obj_
            obj_.original_tagname_ = 'Packages'
# end class PackageVoidStatus


class IsProductAvailable(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, product=None, FromPostCode=None, ToPostCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.product = product
        self.product_nsprefix_ = None
        self.FromPostCode = FromPostCode
        self.FromPostCode_nsprefix_ = None
        self.ToPostCode = ToPostCode
        self.ToPostCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IsProductAvailable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IsProductAvailable.subclass:
            return IsProductAvailable.subclass(*args_, **kwargs_)
        else:
            return IsProductAvailable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_product(self):
        return self.product
    def set_product(self, product):
        self.product = product
    def get_FromPostCode(self):
        return self.FromPostCode
    def set_FromPostCode(self, FromPostCode):
        self.FromPostCode = FromPostCode
    def get_ToPostCode(self):
        return self.ToPostCode
    def set_ToPostCode(self, ToPostCode):
        self.ToPostCode = ToPostCode
    def _hasContent(self):
        if (
            self.product is not None or
            self.FromPostCode is not None or
            self.ToPostCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsProductAvailable', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IsProductAvailable')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IsProductAvailable':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IsProductAvailable')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IsProductAvailable', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IsProductAvailable'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsProductAvailable', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.product is not None:
            namespaceprefix_ = self.product_nsprefix_ + ':' if (UseCapturedNS_ and self.product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sproduct>%s</%sproduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.product), input_name='product')), namespaceprefix_ , eol_))
        if self.FromPostCode is not None:
            namespaceprefix_ = self.FromPostCode_nsprefix_ + ':' if (UseCapturedNS_ and self.FromPostCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromPostCode>%s</%sFromPostCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromPostCode), input_name='FromPostCode')), namespaceprefix_ , eol_))
        if self.ToPostCode is not None:
            namespaceprefix_ = self.ToPostCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ToPostCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sToPostCode>%s</%sToPostCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ToPostCode), input_name='ToPostCode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'product')
            value_ = self.gds_validate_string(value_, node, 'product')
            self.product = value_
            self.product_nsprefix_ = child_.prefix
        elif nodeName_ == 'FromPostCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromPostCode')
            value_ = self.gds_validate_string(value_, node, 'FromPostCode')
            self.FromPostCode = value_
            self.FromPostCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'ToPostCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ToPostCode')
            value_ = self.gds_validate_string(value_, node, 'ToPostCode')
            self.ToPostCode = value_
            self.ToPostCode_nsprefix_ = child_.prefix
# end class IsProductAvailable


class IsProductAvailableResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, IsProductAvailableResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.IsProductAvailableResult = IsProductAvailableResult
        self.IsProductAvailableResult_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IsProductAvailableResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IsProductAvailableResponse.subclass:
            return IsProductAvailableResponse.subclass(*args_, **kwargs_)
        else:
            return IsProductAvailableResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_IsProductAvailableResult(self):
        return self.IsProductAvailableResult
    def set_IsProductAvailableResult(self, IsProductAvailableResult):
        self.IsProductAvailableResult = IsProductAvailableResult
    def _hasContent(self):
        if (
            self.IsProductAvailableResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsProductAvailableResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IsProductAvailableResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IsProductAvailableResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IsProductAvailableResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IsProductAvailableResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IsProductAvailableResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsProductAvailableResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsProductAvailableResult is not None:
            namespaceprefix_ = self.IsProductAvailableResult_nsprefix_ + ':' if (UseCapturedNS_ and self.IsProductAvailableResult_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsProductAvailableResult>%s</%sIsProductAvailableResult>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IsProductAvailableResult), input_name='IsProductAvailableResult')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'IsProductAvailableResult':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IsProductAvailableResult')
            value_ = self.gds_validate_string(value_, node, 'IsProductAvailableResult')
            self.IsProductAvailableResult = value_
            self.IsProductAvailableResult_nsprefix_ = child_.prefix
# end class IsProductAvailableResponse


class IsPostcodeinIcsAOS(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, PostCode=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.PostCode = PostCode
        self.PostCode_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IsPostcodeinIcsAOS)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IsPostcodeinIcsAOS.subclass:
            return IsPostcodeinIcsAOS.subclass(*args_, **kwargs_)
        else:
            return IsPostcodeinIcsAOS(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_PostCode(self):
        return self.PostCode
    def set_PostCode(self, PostCode):
        self.PostCode = PostCode
    def _hasContent(self):
        if (
            self.PostCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsPostcodeinIcsAOS', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IsPostcodeinIcsAOS')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IsPostcodeinIcsAOS':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IsPostcodeinIcsAOS')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IsPostcodeinIcsAOS', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IsPostcodeinIcsAOS'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsPostcodeinIcsAOS', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.PostCode is not None:
            namespaceprefix_ = self.PostCode_nsprefix_ + ':' if (UseCapturedNS_ and self.PostCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPostCode>%s</%sPostCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PostCode), input_name='PostCode')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'PostCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PostCode')
            value_ = self.gds_validate_string(value_, node, 'PostCode')
            self.PostCode = value_
            self.PostCode_nsprefix_ = child_.prefix
# end class IsPostcodeinIcsAOS


class IsPostcodeinIcsAOSResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, IsPostcodeinIcsAOSResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.IsPostcodeinIcsAOSResult = IsPostcodeinIcsAOSResult
        self.IsPostcodeinIcsAOSResult_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IsPostcodeinIcsAOSResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IsPostcodeinIcsAOSResponse.subclass:
            return IsPostcodeinIcsAOSResponse.subclass(*args_, **kwargs_)
        else:
            return IsPostcodeinIcsAOSResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_IsPostcodeinIcsAOSResult(self):
        return self.IsPostcodeinIcsAOSResult
    def set_IsPostcodeinIcsAOSResult(self, IsPostcodeinIcsAOSResult):
        self.IsPostcodeinIcsAOSResult = IsPostcodeinIcsAOSResult
    def _hasContent(self):
        if (
            self.IsPostcodeinIcsAOSResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsPostcodeinIcsAOSResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('IsPostcodeinIcsAOSResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'IsPostcodeinIcsAOSResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='IsPostcodeinIcsAOSResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='IsPostcodeinIcsAOSResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='IsPostcodeinIcsAOSResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='IsPostcodeinIcsAOSResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.IsPostcodeinIcsAOSResult is not None:
            namespaceprefix_ = self.IsPostcodeinIcsAOSResult_nsprefix_ + ':' if (UseCapturedNS_ and self.IsPostcodeinIcsAOSResult_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sIsPostcodeinIcsAOSResult>%s</%sIsPostcodeinIcsAOSResult>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.IsPostcodeinIcsAOSResult), input_name='IsPostcodeinIcsAOSResult')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'IsPostcodeinIcsAOSResult':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'IsPostcodeinIcsAOSResult')
            value_ = self.gds_validate_string(value_, node, 'IsPostcodeinIcsAOSResult')
            self.IsPostcodeinIcsAOSResult = value_
            self.IsPostcodeinIcsAOSResult_nsprefix_ = child_.prefix
# end class IsPostcodeinIcsAOSResponse


class GetOpenManifest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetOpenManifest)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetOpenManifest.subclass:
            return GetOpenManifest.subclass(*args_, **kwargs_)
        else:
            return GetOpenManifest(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifest', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetOpenManifest')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetOpenManifest':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetOpenManifest')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetOpenManifest', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetOpenManifest'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifest', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
# end class GetOpenManifest


class GetOpenManifestResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, GetOpenManifestResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.GetOpenManifestResult = GetOpenManifestResult
        self.GetOpenManifestResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetOpenManifestResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetOpenManifestResponse.subclass:
            return GetOpenManifestResponse.subclass(*args_, **kwargs_)
        else:
            return GetOpenManifestResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_GetOpenManifestResult(self):
        return self.GetOpenManifestResult
    def set_GetOpenManifestResult(self, GetOpenManifestResult):
        self.GetOpenManifestResult = GetOpenManifestResult
    def _hasContent(self):
        if (
            self.GetOpenManifestResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifestResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetOpenManifestResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetOpenManifestResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetOpenManifestResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetOpenManifestResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetOpenManifestResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifestResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GetOpenManifestResult is not None:
            namespaceprefix_ = self.GetOpenManifestResult_nsprefix_ + ':' if (UseCapturedNS_ and self.GetOpenManifestResult_nsprefix_) else ''
            self.GetOpenManifestResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GetOpenManifestResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'GetOpenManifestResult':
            obj_ = ResponseOpenManifest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GetOpenManifestResult = obj_
            obj_.original_tagname_ = 'GetOpenManifestResult'
# end class GetOpenManifestResponse


class ResponseOpenManifest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, err=None, OpenManifestInformation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.err = err
        self.err_nsprefix_ = "tns"
        self.OpenManifestInformation = OpenManifestInformation
        self.OpenManifestInformation_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseOpenManifest)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseOpenManifest.subclass:
            return ResponseOpenManifest.subclass(*args_, **kwargs_)
        else:
            return ResponseOpenManifest(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_err(self):
        return self.err
    def set_err(self, err):
        self.err = err
    def get_OpenManifestInformation(self):
        return self.OpenManifestInformation
    def set_OpenManifestInformation(self, OpenManifestInformation):
        self.OpenManifestInformation = OpenManifestInformation
    def _hasContent(self):
        if (
            self.err is not None or
            self.OpenManifestInformation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseOpenManifest', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseOpenManifest')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseOpenManifest':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseOpenManifest')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseOpenManifest', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseOpenManifest'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseOpenManifest', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.err is not None:
            namespaceprefix_ = self.err_nsprefix_ + ':' if (UseCapturedNS_ and self.err_nsprefix_) else ''
            self.err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='err', pretty_print=pretty_print)
        if self.OpenManifestInformation is not None:
            namespaceprefix_ = self.OpenManifestInformation_nsprefix_ + ':' if (UseCapturedNS_ and self.OpenManifestInformation_nsprefix_) else ''
            self.OpenManifestInformation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OpenManifestInformation', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.err = obj_
            obj_.original_tagname_ = 'err'
        elif nodeName_ == 'OpenManifestInformation':
            obj_ = ArrayOfOpenManifestInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OpenManifestInformation = obj_
            obj_.original_tagname_ = 'OpenManifestInformation'
# end class ResponseOpenManifest


class ArrayOfOpenManifestInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, OpenManifestInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if OpenManifestInfo is None:
            self.OpenManifestInfo = []
        else:
            self.OpenManifestInfo = OpenManifestInfo
        self.OpenManifestInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfOpenManifestInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfOpenManifestInfo.subclass:
            return ArrayOfOpenManifestInfo.subclass(*args_, **kwargs_)
        else:
            return ArrayOfOpenManifestInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_OpenManifestInfo(self):
        return self.OpenManifestInfo
    def set_OpenManifestInfo(self, OpenManifestInfo):
        self.OpenManifestInfo = OpenManifestInfo
    def add_OpenManifestInfo(self, value):
        self.OpenManifestInfo.append(value)
    def insert_OpenManifestInfo_at(self, index, value):
        self.OpenManifestInfo.insert(index, value)
    def replace_OpenManifestInfo_at(self, index, value):
        self.OpenManifestInfo[index] = value
    def _hasContent(self):
        if (
            self.OpenManifestInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfOpenManifestInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfOpenManifestInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfOpenManifestInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfOpenManifestInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfOpenManifestInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfOpenManifestInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfOpenManifestInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for OpenManifestInfo_ in self.OpenManifestInfo:
            namespaceprefix_ = self.OpenManifestInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.OpenManifestInfo_nsprefix_) else ''
            OpenManifestInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OpenManifestInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OpenManifestInfo':
            obj_ = OpenManifestInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OpenManifestInfo.append(obj_)
            obj_.original_tagname_ = 'OpenManifestInfo'
# end class ArrayOfOpenManifestInfo


class OpenManifestInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Void=None, AccountNo=None, ID=None, Company=None, Address1=None, Address2=None, City=None, Province=None, PostCode=None, Manifest=None, PIN=None, Reference=None, LabelCreatedDate=None, ActualWeight=None, CubeWeight=None, Product=None, CostCenter=None, User=None, ICS_BranchDestn=None, Pieces=None, SurCharges=None, InsuranceCharges=None, BaseCharges=None, DeclaredValue=None, Height=None, Length=None, Width=None, FromPost=None, Contact=None, Phone=None, comments=None, email=None, NSR=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Void = Void
        self.Void_nsprefix_ = None
        self.AccountNo = AccountNo
        self.AccountNo_nsprefix_ = None
        self.ID = ID
        self.ID_nsprefix_ = None
        self.Company = Company
        self.Company_nsprefix_ = None
        self.Address1 = Address1
        self.Address1_nsprefix_ = None
        self.Address2 = Address2
        self.Address2_nsprefix_ = None
        self.City = City
        self.City_nsprefix_ = None
        self.Province = Province
        self.Province_nsprefix_ = None
        self.PostCode = PostCode
        self.PostCode_nsprefix_ = None
        self.Manifest = Manifest
        self.Manifest_nsprefix_ = None
        self.PIN = PIN
        self.PIN_nsprefix_ = None
        self.Reference = Reference
        self.Reference_nsprefix_ = None
        if isinstance(LabelCreatedDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(LabelCreatedDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = LabelCreatedDate
        self.LabelCreatedDate = initvalue_
        self.LabelCreatedDate_nsprefix_ = None
        self.ActualWeight = ActualWeight
        self.ActualWeight_nsprefix_ = None
        self.CubeWeight = CubeWeight
        self.CubeWeight_nsprefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.CostCenter = CostCenter
        self.CostCenter_nsprefix_ = None
        self.User = User
        self.User_nsprefix_ = None
        self.ICS_BranchDestn = ICS_BranchDestn
        self.ICS_BranchDestn_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.SurCharges = SurCharges
        self.SurCharges_nsprefix_ = None
        self.InsuranceCharges = InsuranceCharges
        self.InsuranceCharges_nsprefix_ = None
        self.BaseCharges = BaseCharges
        self.BaseCharges_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.DeclaredValue_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.Length = Length
        self.Length_nsprefix_ = None
        self.Width = Width
        self.Width_nsprefix_ = None
        self.FromPost = FromPost
        self.FromPost_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Phone = Phone
        self.Phone_nsprefix_ = None
        self.comments = comments
        self.comments_nsprefix_ = None
        self.email = email
        self.email_nsprefix_ = None
        self.NSR = NSR
        self.NSR_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OpenManifestInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OpenManifestInfo.subclass:
            return OpenManifestInfo.subclass(*args_, **kwargs_)
        else:
            return OpenManifestInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Void(self):
        return self.Void
    def set_Void(self, Void):
        self.Void = Void
    def get_AccountNo(self):
        return self.AccountNo
    def set_AccountNo(self, AccountNo):
        self.AccountNo = AccountNo
    def get_ID(self):
        return self.ID
    def set_ID(self, ID):
        self.ID = ID
    def get_Company(self):
        return self.Company
    def set_Company(self, Company):
        self.Company = Company
    def get_Address1(self):
        return self.Address1
    def set_Address1(self, Address1):
        self.Address1 = Address1
    def get_Address2(self):
        return self.Address2
    def set_Address2(self, Address2):
        self.Address2 = Address2
    def get_City(self):
        return self.City
    def set_City(self, City):
        self.City = City
    def get_Province(self):
        return self.Province
    def set_Province(self, Province):
        self.Province = Province
    def get_PostCode(self):
        return self.PostCode
    def set_PostCode(self, PostCode):
        self.PostCode = PostCode
    def get_Manifest(self):
        return self.Manifest
    def set_Manifest(self, Manifest):
        self.Manifest = Manifest
    def get_PIN(self):
        return self.PIN
    def set_PIN(self, PIN):
        self.PIN = PIN
    def get_Reference(self):
        return self.Reference
    def set_Reference(self, Reference):
        self.Reference = Reference
    def get_LabelCreatedDate(self):
        return self.LabelCreatedDate
    def set_LabelCreatedDate(self, LabelCreatedDate):
        self.LabelCreatedDate = LabelCreatedDate
    def get_ActualWeight(self):
        return self.ActualWeight
    def set_ActualWeight(self, ActualWeight):
        self.ActualWeight = ActualWeight
    def get_CubeWeight(self):
        return self.CubeWeight
    def set_CubeWeight(self, CubeWeight):
        self.CubeWeight = CubeWeight
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_CostCenter(self):
        return self.CostCenter
    def set_CostCenter(self, CostCenter):
        self.CostCenter = CostCenter
    def get_User(self):
        return self.User
    def set_User(self, User):
        self.User = User
    def get_ICS_BranchDestn(self):
        return self.ICS_BranchDestn
    def set_ICS_BranchDestn(self, ICS_BranchDestn):
        self.ICS_BranchDestn = ICS_BranchDestn
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_SurCharges(self):
        return self.SurCharges
    def set_SurCharges(self, SurCharges):
        self.SurCharges = SurCharges
    def get_InsuranceCharges(self):
        return self.InsuranceCharges
    def set_InsuranceCharges(self, InsuranceCharges):
        self.InsuranceCharges = InsuranceCharges
    def get_BaseCharges(self):
        return self.BaseCharges
    def set_BaseCharges(self, BaseCharges):
        self.BaseCharges = BaseCharges
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_Length(self):
        return self.Length
    def set_Length(self, Length):
        self.Length = Length
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_FromPost(self):
        return self.FromPost
    def set_FromPost(self, FromPost):
        self.FromPost = FromPost
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Phone(self):
        return self.Phone
    def set_Phone(self, Phone):
        self.Phone = Phone
    def get_comments(self):
        return self.comments
    def set_comments(self, comments):
        self.comments = comments
    def get_email(self):
        return self.email
    def set_email(self, email):
        self.email = email
    def get_NSR(self):
        return self.NSR
    def set_NSR(self, NSR):
        self.NSR = NSR
    def _hasContent(self):
        if (
            self.Void is not None or
            self.AccountNo is not None or
            self.ID is not None or
            self.Company is not None or
            self.Address1 is not None or
            self.Address2 is not None or
            self.City is not None or
            self.Province is not None or
            self.PostCode is not None or
            self.Manifest is not None or
            self.PIN is not None or
            self.Reference is not None or
            self.LabelCreatedDate is not None or
            self.ActualWeight is not None or
            self.CubeWeight is not None or
            self.Product is not None or
            self.CostCenter is not None or
            self.User is not None or
            self.ICS_BranchDestn is not None or
            self.Pieces is not None or
            self.SurCharges is not None or
            self.InsuranceCharges is not None or
            self.BaseCharges is not None or
            self.DeclaredValue is not None or
            self.Height is not None or
            self.Length is not None or
            self.Width is not None or
            self.FromPost is not None or
            self.Contact is not None or
            self.Phone is not None or
            self.comments is not None or
            self.email is not None or
            self.NSR is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OpenManifestInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OpenManifestInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OpenManifestInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OpenManifestInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OpenManifestInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OpenManifestInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OpenManifestInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Void is not None:
            namespaceprefix_ = self.Void_nsprefix_ + ':' if (UseCapturedNS_ and self.Void_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVoid>%s</%sVoid>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Void), input_name='Void')), namespaceprefix_ , eol_))
        if self.AccountNo is not None:
            namespaceprefix_ = self.AccountNo_nsprefix_ + ':' if (UseCapturedNS_ and self.AccountNo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccountNo>%s</%sAccountNo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AccountNo), input_name='AccountNo')), namespaceprefix_ , eol_))
        if self.ID is not None:
            namespaceprefix_ = self.ID_nsprefix_ + ':' if (UseCapturedNS_ and self.ID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sID>%s</%sID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ID), input_name='ID')), namespaceprefix_ , eol_))
        if self.Company is not None:
            namespaceprefix_ = self.Company_nsprefix_ + ':' if (UseCapturedNS_ and self.Company_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCompany>%s</%sCompany>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Company), input_name='Company')), namespaceprefix_ , eol_))
        if self.Address1 is not None:
            namespaceprefix_ = self.Address1_nsprefix_ + ':' if (UseCapturedNS_ and self.Address1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddress1>%s</%sAddress1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Address1), input_name='Address1')), namespaceprefix_ , eol_))
        if self.Address2 is not None:
            namespaceprefix_ = self.Address2_nsprefix_ + ':' if (UseCapturedNS_ and self.Address2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAddress2>%s</%sAddress2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Address2), input_name='Address2')), namespaceprefix_ , eol_))
        if self.City is not None:
            namespaceprefix_ = self.City_nsprefix_ + ':' if (UseCapturedNS_ and self.City_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCity>%s</%sCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.City), input_name='City')), namespaceprefix_ , eol_))
        if self.Province is not None:
            namespaceprefix_ = self.Province_nsprefix_ + ':' if (UseCapturedNS_ and self.Province_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProvince>%s</%sProvince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Province), input_name='Province')), namespaceprefix_ , eol_))
        if self.PostCode is not None:
            namespaceprefix_ = self.PostCode_nsprefix_ + ':' if (UseCapturedNS_ and self.PostCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPostCode>%s</%sPostCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PostCode), input_name='PostCode')), namespaceprefix_ , eol_))
        if self.Manifest is not None:
            namespaceprefix_ = self.Manifest_nsprefix_ + ':' if (UseCapturedNS_ and self.Manifest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifest>%s</%sManifest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Manifest), input_name='Manifest')), namespaceprefix_ , eol_))
        if self.PIN is not None:
            namespaceprefix_ = self.PIN_nsprefix_ + ':' if (UseCapturedNS_ and self.PIN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPIN>%s</%sPIN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PIN), input_name='PIN')), namespaceprefix_ , eol_))
        if self.Reference is not None:
            namespaceprefix_ = self.Reference_nsprefix_ + ':' if (UseCapturedNS_ and self.Reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference>%s</%sReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Reference), input_name='Reference')), namespaceprefix_ , eol_))
        if self.LabelCreatedDate is not None:
            namespaceprefix_ = self.LabelCreatedDate_nsprefix_ + ':' if (UseCapturedNS_ and self.LabelCreatedDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLabelCreatedDate>%s</%sLabelCreatedDate>%s' % (namespaceprefix_ , self.gds_format_datetime(self.LabelCreatedDate, input_name='LabelCreatedDate'), namespaceprefix_ , eol_))
        if self.ActualWeight is not None:
            namespaceprefix_ = self.ActualWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.ActualWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sActualWeight>%s</%sActualWeight>%s' % (namespaceprefix_ , self.gds_format_double(self.ActualWeight, input_name='ActualWeight'), namespaceprefix_ , eol_))
        if self.CubeWeight is not None:
            namespaceprefix_ = self.CubeWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.CubeWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCubeWeight>%s</%sCubeWeight>%s' % (namespaceprefix_ , self.gds_format_double(self.CubeWeight, input_name='CubeWeight'), namespaceprefix_ , eol_))
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.CostCenter is not None:
            namespaceprefix_ = self.CostCenter_nsprefix_ + ':' if (UseCapturedNS_ and self.CostCenter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCostCenter>%s</%sCostCenter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CostCenter), input_name='CostCenter')), namespaceprefix_ , eol_))
        if self.User is not None:
            namespaceprefix_ = self.User_nsprefix_ + ':' if (UseCapturedNS_ and self.User_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUser>%s</%sUser>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.User), input_name='User')), namespaceprefix_ , eol_))
        if self.ICS_BranchDestn is not None:
            namespaceprefix_ = self.ICS_BranchDestn_nsprefix_ + ':' if (UseCapturedNS_ and self.ICS_BranchDestn_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sICS_BranchDestn>%s</%sICS_BranchDestn>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ICS_BranchDestn), input_name='ICS_BranchDestn')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieces>%s</%sPieces>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Pieces), input_name='Pieces')), namespaceprefix_ , eol_))
        if self.SurCharges is not None:
            namespaceprefix_ = self.SurCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.SurCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSurCharges>%s</%sSurCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.SurCharges, input_name='SurCharges'), namespaceprefix_ , eol_))
        if self.InsuranceCharges is not None:
            namespaceprefix_ = self.InsuranceCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuranceCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuranceCharges>%s</%sInsuranceCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.InsuranceCharges, input_name='InsuranceCharges'), namespaceprefix_ , eol_))
        if self.BaseCharges is not None:
            namespaceprefix_ = self.BaseCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.BaseCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBaseCharges>%s</%sBaseCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.BaseCharges, input_name='BaseCharges'), namespaceprefix_ , eol_))
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_format_double(self.DeclaredValue, input_name='DeclaredValue'), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_format_double(self.Height, input_name='Height'), namespaceprefix_ , eol_))
        if self.Length is not None:
            namespaceprefix_ = self.Length_nsprefix_ + ':' if (UseCapturedNS_ and self.Length_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLength>%s</%sLength>%s' % (namespaceprefix_ , self.gds_format_double(self.Length, input_name='Length'), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_format_double(self.Width, input_name='Width'), namespaceprefix_ , eol_))
        if self.FromPost is not None:
            namespaceprefix_ = self.FromPost_nsprefix_ + ':' if (UseCapturedNS_ and self.FromPost_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromPost>%s</%sFromPost>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromPost), input_name='FromPost')), namespaceprefix_ , eol_))
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContact>%s</%sContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Contact), input_name='Contact')), namespaceprefix_ , eol_))
        if self.Phone is not None:
            namespaceprefix_ = self.Phone_nsprefix_ + ':' if (UseCapturedNS_ and self.Phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhone>%s</%sPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Phone), input_name='Phone')), namespaceprefix_ , eol_))
        if self.comments is not None:
            namespaceprefix_ = self.comments_nsprefix_ + ':' if (UseCapturedNS_ and self.comments_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomments>%s</%scomments>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.comments), input_name='comments')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
        if self.NSR is not None:
            namespaceprefix_ = self.NSR_nsprefix_ + ':' if (UseCapturedNS_ and self.NSR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNSR>%s</%sNSR>%s' % (namespaceprefix_ , self.gds_format_integer(self.NSR, input_name='NSR'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Void':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Void')
            value_ = self.gds_validate_string(value_, node, 'Void')
            self.Void = value_
            self.Void_nsprefix_ = child_.prefix
        elif nodeName_ == 'AccountNo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AccountNo')
            value_ = self.gds_validate_string(value_, node, 'AccountNo')
            self.AccountNo = value_
            self.AccountNo_nsprefix_ = child_.prefix
        elif nodeName_ == 'ID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ID')
            value_ = self.gds_validate_string(value_, node, 'ID')
            self.ID = value_
            self.ID_nsprefix_ = child_.prefix
        elif nodeName_ == 'Company':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Company')
            value_ = self.gds_validate_string(value_, node, 'Company')
            self.Company = value_
            self.Company_nsprefix_ = child_.prefix
        elif nodeName_ == 'Address1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Address1')
            value_ = self.gds_validate_string(value_, node, 'Address1')
            self.Address1 = value_
            self.Address1_nsprefix_ = child_.prefix
        elif nodeName_ == 'Address2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Address2')
            value_ = self.gds_validate_string(value_, node, 'Address2')
            self.Address2 = value_
            self.Address2_nsprefix_ = child_.prefix
        elif nodeName_ == 'City':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'City')
            value_ = self.gds_validate_string(value_, node, 'City')
            self.City = value_
            self.City_nsprefix_ = child_.prefix
        elif nodeName_ == 'Province':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Province')
            value_ = self.gds_validate_string(value_, node, 'Province')
            self.Province = value_
            self.Province_nsprefix_ = child_.prefix
        elif nodeName_ == 'PostCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PostCode')
            value_ = self.gds_validate_string(value_, node, 'PostCode')
            self.PostCode = value_
            self.PostCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'Manifest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Manifest')
            value_ = self.gds_validate_string(value_, node, 'Manifest')
            self.Manifest = value_
            self.Manifest_nsprefix_ = child_.prefix
        elif nodeName_ == 'PIN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PIN')
            value_ = self.gds_validate_string(value_, node, 'PIN')
            self.PIN = value_
            self.PIN_nsprefix_ = child_.prefix
        elif nodeName_ == 'Reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Reference')
            value_ = self.gds_validate_string(value_, node, 'Reference')
            self.Reference = value_
            self.Reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'LabelCreatedDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.LabelCreatedDate = dval_
            self.LabelCreatedDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'ActualWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'ActualWeight')
            fval_ = self.gds_validate_double(fval_, node, 'ActualWeight')
            self.ActualWeight = fval_
            self.ActualWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'CubeWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'CubeWeight')
            fval_ = self.gds_validate_double(fval_, node, 'CubeWeight')
            self.CubeWeight = fval_
            self.CubeWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'CostCenter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CostCenter')
            value_ = self.gds_validate_string(value_, node, 'CostCenter')
            self.CostCenter = value_
            self.CostCenter_nsprefix_ = child_.prefix
        elif nodeName_ == 'User':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'User')
            value_ = self.gds_validate_string(value_, node, 'User')
            self.User = value_
            self.User_nsprefix_ = child_.prefix
        elif nodeName_ == 'ICS_BranchDestn':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ICS_BranchDestn')
            value_ = self.gds_validate_string(value_, node, 'ICS_BranchDestn')
            self.ICS_BranchDestn = value_
            self.ICS_BranchDestn_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Pieces')
            value_ = self.gds_validate_string(value_, node, 'Pieces')
            self.Pieces = value_
            self.Pieces_nsprefix_ = child_.prefix
        elif nodeName_ == 'SurCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'SurCharges')
            fval_ = self.gds_validate_double(fval_, node, 'SurCharges')
            self.SurCharges = fval_
            self.SurCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'InsuranceCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'InsuranceCharges')
            fval_ = self.gds_validate_double(fval_, node, 'InsuranceCharges')
            self.InsuranceCharges = fval_
            self.InsuranceCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'BaseCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'BaseCharges')
            fval_ = self.gds_validate_double(fval_, node, 'BaseCharges')
            self.BaseCharges = fval_
            self.BaseCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'DeclaredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'DeclaredValue')
            fval_ = self.gds_validate_double(fval_, node, 'DeclaredValue')
            self.DeclaredValue = fval_
            self.DeclaredValue_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Height')
            fval_ = self.gds_validate_double(fval_, node, 'Height')
            self.Height = fval_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'Length' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Length')
            fval_ = self.gds_validate_double(fval_, node, 'Length')
            self.Length = fval_
            self.Length_nsprefix_ = child_.prefix
        elif nodeName_ == 'Width' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Width')
            fval_ = self.gds_validate_double(fval_, node, 'Width')
            self.Width = fval_
            self.Width_nsprefix_ = child_.prefix
        elif nodeName_ == 'FromPost':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromPost')
            value_ = self.gds_validate_string(value_, node, 'FromPost')
            self.FromPost = value_
            self.FromPost_nsprefix_ = child_.prefix
        elif nodeName_ == 'Contact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Contact')
            value_ = self.gds_validate_string(value_, node, 'Contact')
            self.Contact = value_
            self.Contact_nsprefix_ = child_.prefix
        elif nodeName_ == 'Phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Phone')
            value_ = self.gds_validate_string(value_, node, 'Phone')
            self.Phone = value_
            self.Phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'comments':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'comments')
            value_ = self.gds_validate_string(value_, node, 'comments')
            self.comments = value_
            self.comments_nsprefix_ = child_.prefix
        elif nodeName_ == 'email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
        elif nodeName_ == 'NSR' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'NSR')
            ival_ = self.gds_validate_integer(ival_, node, 'NSR')
            self.NSR = ival_
            self.NSR_nsprefix_ = child_.prefix
# end class OpenManifestInfo


class GetOpenManifestWithShipperDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetOpenManifestWithShipperDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetOpenManifestWithShipperDetail.subclass:
            return GetOpenManifestWithShipperDetail.subclass(*args_, **kwargs_)
        else:
            return GetOpenManifestWithShipperDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifestWithShipperDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetOpenManifestWithShipperDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetOpenManifestWithShipperDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetOpenManifestWithShipperDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetOpenManifestWithShipperDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetOpenManifestWithShipperDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifestWithShipperDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
# end class GetOpenManifestWithShipperDetail


class GetOpenManifestWithShipperDetailResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, GetOpenManifestWithShipperDetailResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.GetOpenManifestWithShipperDetailResult = GetOpenManifestWithShipperDetailResult
        self.GetOpenManifestWithShipperDetailResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetOpenManifestWithShipperDetailResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetOpenManifestWithShipperDetailResponse.subclass:
            return GetOpenManifestWithShipperDetailResponse.subclass(*args_, **kwargs_)
        else:
            return GetOpenManifestWithShipperDetailResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_GetOpenManifestWithShipperDetailResult(self):
        return self.GetOpenManifestWithShipperDetailResult
    def set_GetOpenManifestWithShipperDetailResult(self, GetOpenManifestWithShipperDetailResult):
        self.GetOpenManifestWithShipperDetailResult = GetOpenManifestWithShipperDetailResult
    def _hasContent(self):
        if (
            self.GetOpenManifestWithShipperDetailResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifestWithShipperDetailResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetOpenManifestWithShipperDetailResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetOpenManifestWithShipperDetailResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetOpenManifestWithShipperDetailResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetOpenManifestWithShipperDetailResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetOpenManifestWithShipperDetailResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetOpenManifestWithShipperDetailResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GetOpenManifestWithShipperDetailResult is not None:
            namespaceprefix_ = self.GetOpenManifestWithShipperDetailResult_nsprefix_ + ':' if (UseCapturedNS_ and self.GetOpenManifestWithShipperDetailResult_nsprefix_) else ''
            self.GetOpenManifestWithShipperDetailResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GetOpenManifestWithShipperDetailResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'GetOpenManifestWithShipperDetailResult':
            obj_ = ResponseOpenManifestWithShipperInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GetOpenManifestWithShipperDetailResult = obj_
            obj_.original_tagname_ = 'GetOpenManifestWithShipperDetailResult'
# end class GetOpenManifestWithShipperDetailResponse


class ResponseOpenManifestWithShipperInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, err=None, OpenManifestWithshipperInformation=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.err = err
        self.err_nsprefix_ = "tns"
        self.OpenManifestWithshipperInformation = OpenManifestWithshipperInformation
        self.OpenManifestWithshipperInformation_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseOpenManifestWithShipperInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseOpenManifestWithShipperInfo.subclass:
            return ResponseOpenManifestWithShipperInfo.subclass(*args_, **kwargs_)
        else:
            return ResponseOpenManifestWithShipperInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_err(self):
        return self.err
    def set_err(self, err):
        self.err = err
    def get_OpenManifestWithshipperInformation(self):
        return self.OpenManifestWithshipperInformation
    def set_OpenManifestWithshipperInformation(self, OpenManifestWithshipperInformation):
        self.OpenManifestWithshipperInformation = OpenManifestWithshipperInformation
    def _hasContent(self):
        if (
            self.err is not None or
            self.OpenManifestWithshipperInformation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseOpenManifestWithShipperInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseOpenManifestWithShipperInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseOpenManifestWithShipperInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseOpenManifestWithShipperInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseOpenManifestWithShipperInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseOpenManifestWithShipperInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseOpenManifestWithShipperInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.err is not None:
            namespaceprefix_ = self.err_nsprefix_ + ':' if (UseCapturedNS_ and self.err_nsprefix_) else ''
            self.err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='err', pretty_print=pretty_print)
        if self.OpenManifestWithshipperInformation is not None:
            namespaceprefix_ = self.OpenManifestWithshipperInformation_nsprefix_ + ':' if (UseCapturedNS_ and self.OpenManifestWithshipperInformation_nsprefix_) else ''
            self.OpenManifestWithshipperInformation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OpenManifestWithshipperInformation', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.err = obj_
            obj_.original_tagname_ = 'err'
        elif nodeName_ == 'OpenManifestWithshipperInformation':
            obj_ = ArrayOfOpenManifestWithShipperInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OpenManifestWithshipperInformation = obj_
            obj_.original_tagname_ = 'OpenManifestWithshipperInformation'
# end class ResponseOpenManifestWithShipperInfo


class ArrayOfOpenManifestWithShipperInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, OpenManifestWithShipperInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if OpenManifestWithShipperInfo is None:
            self.OpenManifestWithShipperInfo = []
        else:
            self.OpenManifestWithShipperInfo = OpenManifestWithShipperInfo
        self.OpenManifestWithShipperInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfOpenManifestWithShipperInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfOpenManifestWithShipperInfo.subclass:
            return ArrayOfOpenManifestWithShipperInfo.subclass(*args_, **kwargs_)
        else:
            return ArrayOfOpenManifestWithShipperInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_OpenManifestWithShipperInfo(self):
        return self.OpenManifestWithShipperInfo
    def set_OpenManifestWithShipperInfo(self, OpenManifestWithShipperInfo):
        self.OpenManifestWithShipperInfo = OpenManifestWithShipperInfo
    def add_OpenManifestWithShipperInfo(self, value):
        self.OpenManifestWithShipperInfo.append(value)
    def insert_OpenManifestWithShipperInfo_at(self, index, value):
        self.OpenManifestWithShipperInfo.insert(index, value)
    def replace_OpenManifestWithShipperInfo_at(self, index, value):
        self.OpenManifestWithShipperInfo[index] = value
    def _hasContent(self):
        if (
            self.OpenManifestWithShipperInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfOpenManifestWithShipperInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfOpenManifestWithShipperInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfOpenManifestWithShipperInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfOpenManifestWithShipperInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfOpenManifestWithShipperInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfOpenManifestWithShipperInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfOpenManifestWithShipperInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for OpenManifestWithShipperInfo_ in self.OpenManifestWithShipperInfo:
            namespaceprefix_ = self.OpenManifestWithShipperInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.OpenManifestWithShipperInfo_nsprefix_) else ''
            OpenManifestWithShipperInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='OpenManifestWithShipperInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'OpenManifestWithShipperInfo':
            obj_ = OpenManifestWithShipperInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.OpenManifestWithShipperInfo.append(obj_)
            obj_.original_tagname_ = 'OpenManifestWithShipperInfo'
# end class ArrayOfOpenManifestWithShipperInfo


class OpenManifestWithShipperInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Void=None, AccountNo=None, ShipperCompany=None, ShipperAddress1=None, ShipperAddress2=None, ShipperCity=None, ShipperProvince=None, ShipperPostCode=None, ShipperContact=None, ShipperPhone=None, ConsigneeID=None, ConsigneeCompany=None, ConsigneeAddress1=None, ConsigneeAddress2=None, ConsigneeCity=None, ConsigneeProvince=None, ConsigneePostCode=None, Manifest=None, PIN=None, Reference=None, LabelCreatedDate=None, ActualWeight=None, CubeWeight=None, Product=None, CostCenter=None, User=None, ICS_BranchDestn=None, Pieces=None, SurCharges=None, InsuranceCharges=None, BaseCharges=None, DeclaredValue=None, Height=None, Length=None, Width=None, Contact=None, Phone=None, comments=None, email=None, NSR=None, HeaderPin=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Void = Void
        self.Void_nsprefix_ = None
        self.AccountNo = AccountNo
        self.AccountNo_nsprefix_ = None
        self.ShipperCompany = ShipperCompany
        self.ShipperCompany_nsprefix_ = None
        self.ShipperAddress1 = ShipperAddress1
        self.ShipperAddress1_nsprefix_ = None
        self.ShipperAddress2 = ShipperAddress2
        self.ShipperAddress2_nsprefix_ = None
        self.ShipperCity = ShipperCity
        self.ShipperCity_nsprefix_ = None
        self.ShipperProvince = ShipperProvince
        self.ShipperProvince_nsprefix_ = None
        self.ShipperPostCode = ShipperPostCode
        self.ShipperPostCode_nsprefix_ = None
        self.ShipperContact = ShipperContact
        self.ShipperContact_nsprefix_ = None
        self.ShipperPhone = ShipperPhone
        self.ShipperPhone_nsprefix_ = None
        self.ConsigneeID = ConsigneeID
        self.ConsigneeID_nsprefix_ = None
        self.ConsigneeCompany = ConsigneeCompany
        self.ConsigneeCompany_nsprefix_ = None
        self.ConsigneeAddress1 = ConsigneeAddress1
        self.ConsigneeAddress1_nsprefix_ = None
        self.ConsigneeAddress2 = ConsigneeAddress2
        self.ConsigneeAddress2_nsprefix_ = None
        self.ConsigneeCity = ConsigneeCity
        self.ConsigneeCity_nsprefix_ = None
        self.ConsigneeProvince = ConsigneeProvince
        self.ConsigneeProvince_nsprefix_ = None
        self.ConsigneePostCode = ConsigneePostCode
        self.ConsigneePostCode_nsprefix_ = None
        self.Manifest = Manifest
        self.Manifest_nsprefix_ = None
        self.PIN = PIN
        self.PIN_nsprefix_ = None
        self.Reference = Reference
        self.Reference_nsprefix_ = None
        if isinstance(LabelCreatedDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(LabelCreatedDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = LabelCreatedDate
        self.LabelCreatedDate = initvalue_
        self.LabelCreatedDate_nsprefix_ = None
        self.ActualWeight = ActualWeight
        self.ActualWeight_nsprefix_ = None
        self.CubeWeight = CubeWeight
        self.CubeWeight_nsprefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.CostCenter = CostCenter
        self.CostCenter_nsprefix_ = None
        self.User = User
        self.User_nsprefix_ = None
        self.ICS_BranchDestn = ICS_BranchDestn
        self.ICS_BranchDestn_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.SurCharges = SurCharges
        self.SurCharges_nsprefix_ = None
        self.InsuranceCharges = InsuranceCharges
        self.InsuranceCharges_nsprefix_ = None
        self.BaseCharges = BaseCharges
        self.BaseCharges_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.DeclaredValue_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.Length = Length
        self.Length_nsprefix_ = None
        self.Width = Width
        self.Width_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Phone = Phone
        self.Phone_nsprefix_ = None
        self.comments = comments
        self.comments_nsprefix_ = None
        self.email = email
        self.email_nsprefix_ = None
        self.NSR = NSR
        self.NSR_nsprefix_ = None
        self.HeaderPin = HeaderPin
        self.HeaderPin_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, OpenManifestWithShipperInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if OpenManifestWithShipperInfo.subclass:
            return OpenManifestWithShipperInfo.subclass(*args_, **kwargs_)
        else:
            return OpenManifestWithShipperInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Void(self):
        return self.Void
    def set_Void(self, Void):
        self.Void = Void
    def get_AccountNo(self):
        return self.AccountNo
    def set_AccountNo(self, AccountNo):
        self.AccountNo = AccountNo
    def get_ShipperCompany(self):
        return self.ShipperCompany
    def set_ShipperCompany(self, ShipperCompany):
        self.ShipperCompany = ShipperCompany
    def get_ShipperAddress1(self):
        return self.ShipperAddress1
    def set_ShipperAddress1(self, ShipperAddress1):
        self.ShipperAddress1 = ShipperAddress1
    def get_ShipperAddress2(self):
        return self.ShipperAddress2
    def set_ShipperAddress2(self, ShipperAddress2):
        self.ShipperAddress2 = ShipperAddress2
    def get_ShipperCity(self):
        return self.ShipperCity
    def set_ShipperCity(self, ShipperCity):
        self.ShipperCity = ShipperCity
    def get_ShipperProvince(self):
        return self.ShipperProvince
    def set_ShipperProvince(self, ShipperProvince):
        self.ShipperProvince = ShipperProvince
    def get_ShipperPostCode(self):
        return self.ShipperPostCode
    def set_ShipperPostCode(self, ShipperPostCode):
        self.ShipperPostCode = ShipperPostCode
    def get_ShipperContact(self):
        return self.ShipperContact
    def set_ShipperContact(self, ShipperContact):
        self.ShipperContact = ShipperContact
    def get_ShipperPhone(self):
        return self.ShipperPhone
    def set_ShipperPhone(self, ShipperPhone):
        self.ShipperPhone = ShipperPhone
    def get_ConsigneeID(self):
        return self.ConsigneeID
    def set_ConsigneeID(self, ConsigneeID):
        self.ConsigneeID = ConsigneeID
    def get_ConsigneeCompany(self):
        return self.ConsigneeCompany
    def set_ConsigneeCompany(self, ConsigneeCompany):
        self.ConsigneeCompany = ConsigneeCompany
    def get_ConsigneeAddress1(self):
        return self.ConsigneeAddress1
    def set_ConsigneeAddress1(self, ConsigneeAddress1):
        self.ConsigneeAddress1 = ConsigneeAddress1
    def get_ConsigneeAddress2(self):
        return self.ConsigneeAddress2
    def set_ConsigneeAddress2(self, ConsigneeAddress2):
        self.ConsigneeAddress2 = ConsigneeAddress2
    def get_ConsigneeCity(self):
        return self.ConsigneeCity
    def set_ConsigneeCity(self, ConsigneeCity):
        self.ConsigneeCity = ConsigneeCity
    def get_ConsigneeProvince(self):
        return self.ConsigneeProvince
    def set_ConsigneeProvince(self, ConsigneeProvince):
        self.ConsigneeProvince = ConsigneeProvince
    def get_ConsigneePostCode(self):
        return self.ConsigneePostCode
    def set_ConsigneePostCode(self, ConsigneePostCode):
        self.ConsigneePostCode = ConsigneePostCode
    def get_Manifest(self):
        return self.Manifest
    def set_Manifest(self, Manifest):
        self.Manifest = Manifest
    def get_PIN(self):
        return self.PIN
    def set_PIN(self, PIN):
        self.PIN = PIN
    def get_Reference(self):
        return self.Reference
    def set_Reference(self, Reference):
        self.Reference = Reference
    def get_LabelCreatedDate(self):
        return self.LabelCreatedDate
    def set_LabelCreatedDate(self, LabelCreatedDate):
        self.LabelCreatedDate = LabelCreatedDate
    def get_ActualWeight(self):
        return self.ActualWeight
    def set_ActualWeight(self, ActualWeight):
        self.ActualWeight = ActualWeight
    def get_CubeWeight(self):
        return self.CubeWeight
    def set_CubeWeight(self, CubeWeight):
        self.CubeWeight = CubeWeight
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_CostCenter(self):
        return self.CostCenter
    def set_CostCenter(self, CostCenter):
        self.CostCenter = CostCenter
    def get_User(self):
        return self.User
    def set_User(self, User):
        self.User = User
    def get_ICS_BranchDestn(self):
        return self.ICS_BranchDestn
    def set_ICS_BranchDestn(self, ICS_BranchDestn):
        self.ICS_BranchDestn = ICS_BranchDestn
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_SurCharges(self):
        return self.SurCharges
    def set_SurCharges(self, SurCharges):
        self.SurCharges = SurCharges
    def get_InsuranceCharges(self):
        return self.InsuranceCharges
    def set_InsuranceCharges(self, InsuranceCharges):
        self.InsuranceCharges = InsuranceCharges
    def get_BaseCharges(self):
        return self.BaseCharges
    def set_BaseCharges(self, BaseCharges):
        self.BaseCharges = BaseCharges
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_Length(self):
        return self.Length
    def set_Length(self, Length):
        self.Length = Length
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Phone(self):
        return self.Phone
    def set_Phone(self, Phone):
        self.Phone = Phone
    def get_comments(self):
        return self.comments
    def set_comments(self, comments):
        self.comments = comments
    def get_email(self):
        return self.email
    def set_email(self, email):
        self.email = email
    def get_NSR(self):
        return self.NSR
    def set_NSR(self, NSR):
        self.NSR = NSR
    def get_HeaderPin(self):
        return self.HeaderPin
    def set_HeaderPin(self, HeaderPin):
        self.HeaderPin = HeaderPin
    def _hasContent(self):
        if (
            self.Void is not None or
            self.AccountNo is not None or
            self.ShipperCompany is not None or
            self.ShipperAddress1 is not None or
            self.ShipperAddress2 is not None or
            self.ShipperCity is not None or
            self.ShipperProvince is not None or
            self.ShipperPostCode is not None or
            self.ShipperContact is not None or
            self.ShipperPhone is not None or
            self.ConsigneeID is not None or
            self.ConsigneeCompany is not None or
            self.ConsigneeAddress1 is not None or
            self.ConsigneeAddress2 is not None or
            self.ConsigneeCity is not None or
            self.ConsigneeProvince is not None or
            self.ConsigneePostCode is not None or
            self.Manifest is not None or
            self.PIN is not None or
            self.Reference is not None or
            self.LabelCreatedDate is not None or
            self.ActualWeight is not None or
            self.CubeWeight is not None or
            self.Product is not None or
            self.CostCenter is not None or
            self.User is not None or
            self.ICS_BranchDestn is not None or
            self.Pieces is not None or
            self.SurCharges is not None or
            self.InsuranceCharges is not None or
            self.BaseCharges is not None or
            self.DeclaredValue is not None or
            self.Height is not None or
            self.Length is not None or
            self.Width is not None or
            self.Contact is not None or
            self.Phone is not None or
            self.comments is not None or
            self.email is not None or
            self.NSR is not None or
            self.HeaderPin is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OpenManifestWithShipperInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('OpenManifestWithShipperInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'OpenManifestWithShipperInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='OpenManifestWithShipperInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='OpenManifestWithShipperInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='OpenManifestWithShipperInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='OpenManifestWithShipperInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Void is not None:
            namespaceprefix_ = self.Void_nsprefix_ + ':' if (UseCapturedNS_ and self.Void_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sVoid>%s</%sVoid>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Void), input_name='Void')), namespaceprefix_ , eol_))
        if self.AccountNo is not None:
            namespaceprefix_ = self.AccountNo_nsprefix_ + ':' if (UseCapturedNS_ and self.AccountNo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccountNo>%s</%sAccountNo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AccountNo), input_name='AccountNo')), namespaceprefix_ , eol_))
        if self.ShipperCompany is not None:
            namespaceprefix_ = self.ShipperCompany_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperCompany_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperCompany>%s</%sShipperCompany>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperCompany), input_name='ShipperCompany')), namespaceprefix_ , eol_))
        if self.ShipperAddress1 is not None:
            namespaceprefix_ = self.ShipperAddress1_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperAddress1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperAddress1>%s</%sShipperAddress1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperAddress1), input_name='ShipperAddress1')), namespaceprefix_ , eol_))
        if self.ShipperAddress2 is not None:
            namespaceprefix_ = self.ShipperAddress2_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperAddress2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperAddress2>%s</%sShipperAddress2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperAddress2), input_name='ShipperAddress2')), namespaceprefix_ , eol_))
        if self.ShipperCity is not None:
            namespaceprefix_ = self.ShipperCity_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperCity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperCity>%s</%sShipperCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperCity), input_name='ShipperCity')), namespaceprefix_ , eol_))
        if self.ShipperProvince is not None:
            namespaceprefix_ = self.ShipperProvince_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperProvince_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperProvince>%s</%sShipperProvince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperProvince), input_name='ShipperProvince')), namespaceprefix_ , eol_))
        if self.ShipperPostCode is not None:
            namespaceprefix_ = self.ShipperPostCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperPostCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperPostCode>%s</%sShipperPostCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperPostCode), input_name='ShipperPostCode')), namespaceprefix_ , eol_))
        if self.ShipperContact is not None:
            namespaceprefix_ = self.ShipperContact_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperContact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperContact>%s</%sShipperContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperContact), input_name='ShipperContact')), namespaceprefix_ , eol_))
        if self.ShipperPhone is not None:
            namespaceprefix_ = self.ShipperPhone_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperPhone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperPhone>%s</%sShipperPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperPhone), input_name='ShipperPhone')), namespaceprefix_ , eol_))
        if self.ConsigneeID is not None:
            namespaceprefix_ = self.ConsigneeID_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeID>%s</%sConsigneeID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeID), input_name='ConsigneeID')), namespaceprefix_ , eol_))
        if self.ConsigneeCompany is not None:
            namespaceprefix_ = self.ConsigneeCompany_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeCompany_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeCompany>%s</%sConsigneeCompany>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeCompany), input_name='ConsigneeCompany')), namespaceprefix_ , eol_))
        if self.ConsigneeAddress1 is not None:
            namespaceprefix_ = self.ConsigneeAddress1_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeAddress1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeAddress1>%s</%sConsigneeAddress1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeAddress1), input_name='ConsigneeAddress1')), namespaceprefix_ , eol_))
        if self.ConsigneeAddress2 is not None:
            namespaceprefix_ = self.ConsigneeAddress2_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeAddress2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeAddress2>%s</%sConsigneeAddress2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeAddress2), input_name='ConsigneeAddress2')), namespaceprefix_ , eol_))
        if self.ConsigneeCity is not None:
            namespaceprefix_ = self.ConsigneeCity_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeCity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeCity>%s</%sConsigneeCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeCity), input_name='ConsigneeCity')), namespaceprefix_ , eol_))
        if self.ConsigneeProvince is not None:
            namespaceprefix_ = self.ConsigneeProvince_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeProvince_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeProvince>%s</%sConsigneeProvince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeProvince), input_name='ConsigneeProvince')), namespaceprefix_ , eol_))
        if self.ConsigneePostCode is not None:
            namespaceprefix_ = self.ConsigneePostCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneePostCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneePostCode>%s</%sConsigneePostCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneePostCode), input_name='ConsigneePostCode')), namespaceprefix_ , eol_))
        if self.Manifest is not None:
            namespaceprefix_ = self.Manifest_nsprefix_ + ':' if (UseCapturedNS_ and self.Manifest_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifest>%s</%sManifest>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Manifest), input_name='Manifest')), namespaceprefix_ , eol_))
        if self.PIN is not None:
            namespaceprefix_ = self.PIN_nsprefix_ + ':' if (UseCapturedNS_ and self.PIN_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPIN>%s</%sPIN>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PIN), input_name='PIN')), namespaceprefix_ , eol_))
        if self.Reference is not None:
            namespaceprefix_ = self.Reference_nsprefix_ + ':' if (UseCapturedNS_ and self.Reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference>%s</%sReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Reference), input_name='Reference')), namespaceprefix_ , eol_))
        if self.LabelCreatedDate is not None:
            namespaceprefix_ = self.LabelCreatedDate_nsprefix_ + ':' if (UseCapturedNS_ and self.LabelCreatedDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLabelCreatedDate>%s</%sLabelCreatedDate>%s' % (namespaceprefix_ , self.gds_format_datetime(self.LabelCreatedDate, input_name='LabelCreatedDate'), namespaceprefix_ , eol_))
        if self.ActualWeight is not None:
            namespaceprefix_ = self.ActualWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.ActualWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sActualWeight>%s</%sActualWeight>%s' % (namespaceprefix_ , self.gds_format_double(self.ActualWeight, input_name='ActualWeight'), namespaceprefix_ , eol_))
        if self.CubeWeight is not None:
            namespaceprefix_ = self.CubeWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.CubeWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCubeWeight>%s</%sCubeWeight>%s' % (namespaceprefix_ , self.gds_format_double(self.CubeWeight, input_name='CubeWeight'), namespaceprefix_ , eol_))
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.CostCenter is not None:
            namespaceprefix_ = self.CostCenter_nsprefix_ + ':' if (UseCapturedNS_ and self.CostCenter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCostCenter>%s</%sCostCenter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CostCenter), input_name='CostCenter')), namespaceprefix_ , eol_))
        if self.User is not None:
            namespaceprefix_ = self.User_nsprefix_ + ':' if (UseCapturedNS_ and self.User_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUser>%s</%sUser>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.User), input_name='User')), namespaceprefix_ , eol_))
        if self.ICS_BranchDestn is not None:
            namespaceprefix_ = self.ICS_BranchDestn_nsprefix_ + ':' if (UseCapturedNS_ and self.ICS_BranchDestn_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sICS_BranchDestn>%s</%sICS_BranchDestn>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ICS_BranchDestn), input_name='ICS_BranchDestn')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieces>%s</%sPieces>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Pieces), input_name='Pieces')), namespaceprefix_ , eol_))
        if self.SurCharges is not None:
            namespaceprefix_ = self.SurCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.SurCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSurCharges>%s</%sSurCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.SurCharges, input_name='SurCharges'), namespaceprefix_ , eol_))
        if self.InsuranceCharges is not None:
            namespaceprefix_ = self.InsuranceCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuranceCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuranceCharges>%s</%sInsuranceCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.InsuranceCharges, input_name='InsuranceCharges'), namespaceprefix_ , eol_))
        if self.BaseCharges is not None:
            namespaceprefix_ = self.BaseCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.BaseCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBaseCharges>%s</%sBaseCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.BaseCharges, input_name='BaseCharges'), namespaceprefix_ , eol_))
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_format_double(self.DeclaredValue, input_name='DeclaredValue'), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_format_double(self.Height, input_name='Height'), namespaceprefix_ , eol_))
        if self.Length is not None:
            namespaceprefix_ = self.Length_nsprefix_ + ':' if (UseCapturedNS_ and self.Length_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLength>%s</%sLength>%s' % (namespaceprefix_ , self.gds_format_double(self.Length, input_name='Length'), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_format_double(self.Width, input_name='Width'), namespaceprefix_ , eol_))
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContact>%s</%sContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Contact), input_name='Contact')), namespaceprefix_ , eol_))
        if self.Phone is not None:
            namespaceprefix_ = self.Phone_nsprefix_ + ':' if (UseCapturedNS_ and self.Phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhone>%s</%sPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Phone), input_name='Phone')), namespaceprefix_ , eol_))
        if self.comments is not None:
            namespaceprefix_ = self.comments_nsprefix_ + ':' if (UseCapturedNS_ and self.comments_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scomments>%s</%scomments>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.comments), input_name='comments')), namespaceprefix_ , eol_))
        if self.email is not None:
            namespaceprefix_ = self.email_nsprefix_ + ':' if (UseCapturedNS_ and self.email_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.email), input_name='email')), namespaceprefix_ , eol_))
        if self.NSR is not None:
            namespaceprefix_ = self.NSR_nsprefix_ + ':' if (UseCapturedNS_ and self.NSR_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sNSR>%s</%sNSR>%s' % (namespaceprefix_ , self.gds_format_integer(self.NSR, input_name='NSR'), namespaceprefix_ , eol_))
        if self.HeaderPin is not None:
            namespaceprefix_ = self.HeaderPin_nsprefix_ + ':' if (UseCapturedNS_ and self.HeaderPin_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeaderPin>%s</%sHeaderPin>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.HeaderPin), input_name='HeaderPin')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Void':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Void')
            value_ = self.gds_validate_string(value_, node, 'Void')
            self.Void = value_
            self.Void_nsprefix_ = child_.prefix
        elif nodeName_ == 'AccountNo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AccountNo')
            value_ = self.gds_validate_string(value_, node, 'AccountNo')
            self.AccountNo = value_
            self.AccountNo_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperCompany':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperCompany')
            value_ = self.gds_validate_string(value_, node, 'ShipperCompany')
            self.ShipperCompany = value_
            self.ShipperCompany_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperAddress1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperAddress1')
            value_ = self.gds_validate_string(value_, node, 'ShipperAddress1')
            self.ShipperAddress1 = value_
            self.ShipperAddress1_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperAddress2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperAddress2')
            value_ = self.gds_validate_string(value_, node, 'ShipperAddress2')
            self.ShipperAddress2 = value_
            self.ShipperAddress2_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperCity':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperCity')
            value_ = self.gds_validate_string(value_, node, 'ShipperCity')
            self.ShipperCity = value_
            self.ShipperCity_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperProvince':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperProvince')
            value_ = self.gds_validate_string(value_, node, 'ShipperProvince')
            self.ShipperProvince = value_
            self.ShipperProvince_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperPostCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperPostCode')
            value_ = self.gds_validate_string(value_, node, 'ShipperPostCode')
            self.ShipperPostCode = value_
            self.ShipperPostCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperContact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperContact')
            value_ = self.gds_validate_string(value_, node, 'ShipperContact')
            self.ShipperContact = value_
            self.ShipperContact_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperPhone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperPhone')
            value_ = self.gds_validate_string(value_, node, 'ShipperPhone')
            self.ShipperPhone = value_
            self.ShipperPhone_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeID')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeID')
            self.ConsigneeID = value_
            self.ConsigneeID_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeCompany':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeCompany')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeCompany')
            self.ConsigneeCompany = value_
            self.ConsigneeCompany_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeAddress1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeAddress1')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeAddress1')
            self.ConsigneeAddress1 = value_
            self.ConsigneeAddress1_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeAddress2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeAddress2')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeAddress2')
            self.ConsigneeAddress2 = value_
            self.ConsigneeAddress2_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeCity':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeCity')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeCity')
            self.ConsigneeCity = value_
            self.ConsigneeCity_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeProvince':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeProvince')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeProvince')
            self.ConsigneeProvince = value_
            self.ConsigneeProvince_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneePostCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneePostCode')
            value_ = self.gds_validate_string(value_, node, 'ConsigneePostCode')
            self.ConsigneePostCode = value_
            self.ConsigneePostCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'Manifest':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Manifest')
            value_ = self.gds_validate_string(value_, node, 'Manifest')
            self.Manifest = value_
            self.Manifest_nsprefix_ = child_.prefix
        elif nodeName_ == 'PIN':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PIN')
            value_ = self.gds_validate_string(value_, node, 'PIN')
            self.PIN = value_
            self.PIN_nsprefix_ = child_.prefix
        elif nodeName_ == 'Reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Reference')
            value_ = self.gds_validate_string(value_, node, 'Reference')
            self.Reference = value_
            self.Reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'LabelCreatedDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.LabelCreatedDate = dval_
            self.LabelCreatedDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'ActualWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'ActualWeight')
            fval_ = self.gds_validate_double(fval_, node, 'ActualWeight')
            self.ActualWeight = fval_
            self.ActualWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'CubeWeight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'CubeWeight')
            fval_ = self.gds_validate_double(fval_, node, 'CubeWeight')
            self.CubeWeight = fval_
            self.CubeWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'CostCenter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CostCenter')
            value_ = self.gds_validate_string(value_, node, 'CostCenter')
            self.CostCenter = value_
            self.CostCenter_nsprefix_ = child_.prefix
        elif nodeName_ == 'User':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'User')
            value_ = self.gds_validate_string(value_, node, 'User')
            self.User = value_
            self.User_nsprefix_ = child_.prefix
        elif nodeName_ == 'ICS_BranchDestn':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ICS_BranchDestn')
            value_ = self.gds_validate_string(value_, node, 'ICS_BranchDestn')
            self.ICS_BranchDestn = value_
            self.ICS_BranchDestn_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Pieces')
            value_ = self.gds_validate_string(value_, node, 'Pieces')
            self.Pieces = value_
            self.Pieces_nsprefix_ = child_.prefix
        elif nodeName_ == 'SurCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'SurCharges')
            fval_ = self.gds_validate_double(fval_, node, 'SurCharges')
            self.SurCharges = fval_
            self.SurCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'InsuranceCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'InsuranceCharges')
            fval_ = self.gds_validate_double(fval_, node, 'InsuranceCharges')
            self.InsuranceCharges = fval_
            self.InsuranceCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'BaseCharges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'BaseCharges')
            fval_ = self.gds_validate_double(fval_, node, 'BaseCharges')
            self.BaseCharges = fval_
            self.BaseCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'DeclaredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'DeclaredValue')
            fval_ = self.gds_validate_double(fval_, node, 'DeclaredValue')
            self.DeclaredValue = fval_
            self.DeclaredValue_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Height')
            fval_ = self.gds_validate_double(fval_, node, 'Height')
            self.Height = fval_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'Length' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Length')
            fval_ = self.gds_validate_double(fval_, node, 'Length')
            self.Length = fval_
            self.Length_nsprefix_ = child_.prefix
        elif nodeName_ == 'Width' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Width')
            fval_ = self.gds_validate_double(fval_, node, 'Width')
            self.Width = fval_
            self.Width_nsprefix_ = child_.prefix
        elif nodeName_ == 'Contact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Contact')
            value_ = self.gds_validate_string(value_, node, 'Contact')
            self.Contact = value_
            self.Contact_nsprefix_ = child_.prefix
        elif nodeName_ == 'Phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Phone')
            value_ = self.gds_validate_string(value_, node, 'Phone')
            self.Phone = value_
            self.Phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'comments':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'comments')
            value_ = self.gds_validate_string(value_, node, 'comments')
            self.comments = value_
            self.comments_nsprefix_ = child_.prefix
        elif nodeName_ == 'email':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'email')
            value_ = self.gds_validate_string(value_, node, 'email')
            self.email = value_
            self.email_nsprefix_ = child_.prefix
        elif nodeName_ == 'NSR' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'NSR')
            ival_ = self.gds_validate_integer(ival_, node, 'NSR')
            self.NSR = ival_
            self.NSR_nsprefix_ = child_.prefix
        elif nodeName_ == 'HeaderPin':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'HeaderPin')
            value_ = self.gds_validate_string(value_, node, 'HeaderPin')
            self.HeaderPin = value_
            self.HeaderPin_nsprefix_ = child_.prefix
# end class OpenManifestWithShipperInfo


class TracePackge(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TrackNums=None, DetailInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TrackNums = TrackNums
        self.TrackNums_nsprefix_ = "tns"
        self.DetailInfo = DetailInfo
        self.DetailInfo_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TracePackge)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TracePackge.subclass:
            return TracePackge.subclass(*args_, **kwargs_)
        else:
            return TracePackge(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TrackNums(self):
        return self.TrackNums
    def set_TrackNums(self, TrackNums):
        self.TrackNums = TrackNums
    def get_DetailInfo(self):
        return self.DetailInfo
    def set_DetailInfo(self, DetailInfo):
        self.DetailInfo = DetailInfo
    def _hasContent(self):
        if (
            self.TrackNums is not None or
            self.DetailInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackge', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TracePackge')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TracePackge':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TracePackge')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TracePackge', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TracePackge'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackge', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TrackNums is not None:
            namespaceprefix_ = self.TrackNums_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackNums_nsprefix_) else ''
            self.TrackNums.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TrackNums', pretty_print=pretty_print)
        if self.DetailInfo is not None:
            namespaceprefix_ = self.DetailInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.DetailInfo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDetailInfo>%s</%sDetailInfo>%s' % (namespaceprefix_ , self.gds_format_boolean(self.DetailInfo, input_name='DetailInfo'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TrackNums':
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TrackNums = obj_
            obj_.original_tagname_ = 'TrackNums'
        elif nodeName_ == 'DetailInfo':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'DetailInfo')
            ival_ = self.gds_validate_boolean(ival_, node, 'DetailInfo')
            self.DetailInfo = ival_
            self.DetailInfo_nsprefix_ = child_.prefix
# end class TracePackge


class TracePackgeResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TracePackgeResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TracePackgeResult = TracePackgeResult
        self.TracePackgeResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TracePackgeResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TracePackgeResponse.subclass:
            return TracePackgeResponse.subclass(*args_, **kwargs_)
        else:
            return TracePackgeResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TracePackgeResult(self):
        return self.TracePackgeResult
    def set_TracePackgeResult(self, TracePackgeResult):
        self.TracePackgeResult = TracePackgeResult
    def _hasContent(self):
        if (
            self.TracePackgeResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackgeResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TracePackgeResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TracePackgeResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TracePackgeResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TracePackgeResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TracePackgeResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackgeResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TracePackgeResult is not None:
            namespaceprefix_ = self.TracePackgeResult_nsprefix_ + ':' if (UseCapturedNS_ and self.TracePackgeResult_nsprefix_) else ''
            self.TracePackgeResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TracePackgeResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TracePackgeResult':
            obj_ = ResponseTrackingInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TracePackgeResult = obj_
            obj_.original_tagname_ = 'TracePackgeResult'
# end class TracePackgeResponse


class ResponseTrackingInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, TrackingInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.TrackingInfo = TrackingInfo
        self.TrackingInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseTrackingInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseTrackingInfo.subclass:
            return ResponseTrackingInfo.subclass(*args_, **kwargs_)
        else:
            return ResponseTrackingInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_TrackingInfo(self):
        return self.TrackingInfo
    def set_TrackingInfo(self, TrackingInfo):
        self.TrackingInfo = TrackingInfo
    def _hasContent(self):
        if (
            self.Err is not None or
            self.TrackingInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseTrackingInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseTrackingInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseTrackingInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseTrackingInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseTrackingInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseTrackingInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseTrackingInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.TrackingInfo is not None:
            namespaceprefix_ = self.TrackingInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackingInfo_nsprefix_) else ''
            self.TrackingInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TrackingInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'TrackingInfo':
            obj_ = ArrayOfTrackingInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TrackingInfo = obj_
            obj_.original_tagname_ = 'TrackingInfo'
# end class ResponseTrackingInfo


class ArrayOfTrackingInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TrackingInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if TrackingInfo is None:
            self.TrackingInfo = []
        else:
            self.TrackingInfo = TrackingInfo
        self.TrackingInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfTrackingInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfTrackingInfo.subclass:
            return ArrayOfTrackingInfo.subclass(*args_, **kwargs_)
        else:
            return ArrayOfTrackingInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TrackingInfo(self):
        return self.TrackingInfo
    def set_TrackingInfo(self, TrackingInfo):
        self.TrackingInfo = TrackingInfo
    def add_TrackingInfo(self, value):
        self.TrackingInfo.append(value)
    def insert_TrackingInfo_at(self, index, value):
        self.TrackingInfo.insert(index, value)
    def replace_TrackingInfo_at(self, index, value):
        self.TrackingInfo[index] = value
    def _hasContent(self):
        if (
            self.TrackingInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfTrackingInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfTrackingInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfTrackingInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfTrackingInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfTrackingInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfTrackingInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfTrackingInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for TrackingInfo_ in self.TrackingInfo:
            namespaceprefix_ = self.TrackingInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackingInfo_nsprefix_) else ''
            TrackingInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TrackingInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TrackingInfo':
            obj_ = TrackingInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TrackingInfo.append(obj_)
            obj_.original_tagname_ = 'TrackingInfo'
# end class ArrayOfTrackingInfo


class TrackingInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TrackingNum=None, StatusDate=None, Status=None, Signby=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TrackingNum = TrackingNum
        self.TrackingNum_nsprefix_ = None
        if isinstance(StatusDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(StatusDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = StatusDate
        self.StatusDate = initvalue_
        self.StatusDate_nsprefix_ = None
        self.Status = Status
        self.Status_nsprefix_ = None
        self.Signby = Signby
        self.Signby_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingInfo.subclass:
            return TrackingInfo.subclass(*args_, **kwargs_)
        else:
            return TrackingInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TrackingNum(self):
        return self.TrackingNum
    def set_TrackingNum(self, TrackingNum):
        self.TrackingNum = TrackingNum
    def get_StatusDate(self):
        return self.StatusDate
    def set_StatusDate(self, StatusDate):
        self.StatusDate = StatusDate
    def get_Status(self):
        return self.Status
    def set_Status(self, Status):
        self.Status = Status
    def get_Signby(self):
        return self.Signby
    def set_Signby(self, Signby):
        self.Signby = Signby
    def _hasContent(self):
        if (
            self.TrackingNum is not None or
            self.StatusDate is not None or
            self.Status is not None or
            self.Signby is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TrackingNum is not None:
            namespaceprefix_ = self.TrackingNum_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackingNum_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTrackingNum>%s</%sTrackingNum>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TrackingNum), input_name='TrackingNum')), namespaceprefix_ , eol_))
        if self.StatusDate is not None:
            namespaceprefix_ = self.StatusDate_nsprefix_ + ':' if (UseCapturedNS_ and self.StatusDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStatusDate>%s</%sStatusDate>%s' % (namespaceprefix_ , self.gds_format_datetime(self.StatusDate, input_name='StatusDate'), namespaceprefix_ , eol_))
        if self.Status is not None:
            namespaceprefix_ = self.Status_nsprefix_ + ':' if (UseCapturedNS_ and self.Status_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStatus>%s</%sStatus>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Status), input_name='Status')), namespaceprefix_ , eol_))
        if self.Signby is not None:
            namespaceprefix_ = self.Signby_nsprefix_ + ':' if (UseCapturedNS_ and self.Signby_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSignby>%s</%sSignby>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Signby), input_name='Signby')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TrackingNum':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TrackingNum')
            value_ = self.gds_validate_string(value_, node, 'TrackingNum')
            self.TrackingNum = value_
            self.TrackingNum_nsprefix_ = child_.prefix
        elif nodeName_ == 'StatusDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.StatusDate = dval_
            self.StatusDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'Status':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Status')
            value_ = self.gds_validate_string(value_, node, 'Status')
            self.Status = value_
            self.Status_nsprefix_ = child_.prefix
        elif nodeName_ == 'Signby':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Signby')
            value_ = self.gds_validate_string(value_, node, 'Signby')
            self.Signby = value_
            self.Signby_nsprefix_ = child_.prefix
# end class TrackingInfo


class TracePackgeWithEnFRStatus(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TrackNums=None, DetailInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TrackNums = TrackNums
        self.TrackNums_nsprefix_ = "tns"
        self.DetailInfo = DetailInfo
        self.DetailInfo_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TracePackgeWithEnFRStatus)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TracePackgeWithEnFRStatus.subclass:
            return TracePackgeWithEnFRStatus.subclass(*args_, **kwargs_)
        else:
            return TracePackgeWithEnFRStatus(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TrackNums(self):
        return self.TrackNums
    def set_TrackNums(self, TrackNums):
        self.TrackNums = TrackNums
    def get_DetailInfo(self):
        return self.DetailInfo
    def set_DetailInfo(self, DetailInfo):
        self.DetailInfo = DetailInfo
    def _hasContent(self):
        if (
            self.TrackNums is not None or
            self.DetailInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackgeWithEnFRStatus', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TracePackgeWithEnFRStatus')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TracePackgeWithEnFRStatus':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TracePackgeWithEnFRStatus')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TracePackgeWithEnFRStatus', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TracePackgeWithEnFRStatus'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackgeWithEnFRStatus', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TrackNums is not None:
            namespaceprefix_ = self.TrackNums_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackNums_nsprefix_) else ''
            self.TrackNums.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TrackNums', pretty_print=pretty_print)
        if self.DetailInfo is not None:
            namespaceprefix_ = self.DetailInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.DetailInfo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDetailInfo>%s</%sDetailInfo>%s' % (namespaceprefix_ , self.gds_format_boolean(self.DetailInfo, input_name='DetailInfo'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TrackNums':
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TrackNums = obj_
            obj_.original_tagname_ = 'TrackNums'
        elif nodeName_ == 'DetailInfo':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'DetailInfo')
            ival_ = self.gds_validate_boolean(ival_, node, 'DetailInfo')
            self.DetailInfo = ival_
            self.DetailInfo_nsprefix_ = child_.prefix
# end class TracePackgeWithEnFRStatus


class TracePackgeWithEnFRStatusResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TracePackgeWithEnFRStatusResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TracePackgeWithEnFRStatusResult = TracePackgeWithEnFRStatusResult
        self.TracePackgeWithEnFRStatusResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TracePackgeWithEnFRStatusResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TracePackgeWithEnFRStatusResponse.subclass:
            return TracePackgeWithEnFRStatusResponse.subclass(*args_, **kwargs_)
        else:
            return TracePackgeWithEnFRStatusResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TracePackgeWithEnFRStatusResult(self):
        return self.TracePackgeWithEnFRStatusResult
    def set_TracePackgeWithEnFRStatusResult(self, TracePackgeWithEnFRStatusResult):
        self.TracePackgeWithEnFRStatusResult = TracePackgeWithEnFRStatusResult
    def _hasContent(self):
        if (
            self.TracePackgeWithEnFRStatusResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackgeWithEnFRStatusResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TracePackgeWithEnFRStatusResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TracePackgeWithEnFRStatusResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TracePackgeWithEnFRStatusResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TracePackgeWithEnFRStatusResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TracePackgeWithEnFRStatusResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TracePackgeWithEnFRStatusResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TracePackgeWithEnFRStatusResult is not None:
            namespaceprefix_ = self.TracePackgeWithEnFRStatusResult_nsprefix_ + ':' if (UseCapturedNS_ and self.TracePackgeWithEnFRStatusResult_nsprefix_) else ''
            self.TracePackgeWithEnFRStatusResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TracePackgeWithEnFRStatusResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TracePackgeWithEnFRStatusResult':
            obj_ = ResponseTrackingInfoWithFrench.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TracePackgeWithEnFRStatusResult = obj_
            obj_.original_tagname_ = 'TracePackgeWithEnFRStatusResult'
# end class TracePackgeWithEnFRStatusResponse


class ResponseTrackingInfoWithFrench(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, TrackingInfoWithFrench=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.TrackingInfoWithFrench = TrackingInfoWithFrench
        self.TrackingInfoWithFrench_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseTrackingInfoWithFrench)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseTrackingInfoWithFrench.subclass:
            return ResponseTrackingInfoWithFrench.subclass(*args_, **kwargs_)
        else:
            return ResponseTrackingInfoWithFrench(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_TrackingInfoWithFrench(self):
        return self.TrackingInfoWithFrench
    def set_TrackingInfoWithFrench(self, TrackingInfoWithFrench):
        self.TrackingInfoWithFrench = TrackingInfoWithFrench
    def _hasContent(self):
        if (
            self.Err is not None or
            self.TrackingInfoWithFrench is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseTrackingInfoWithFrench', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseTrackingInfoWithFrench')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseTrackingInfoWithFrench':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseTrackingInfoWithFrench')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseTrackingInfoWithFrench', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseTrackingInfoWithFrench'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseTrackingInfoWithFrench', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.TrackingInfoWithFrench is not None:
            namespaceprefix_ = self.TrackingInfoWithFrench_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackingInfoWithFrench_nsprefix_) else ''
            self.TrackingInfoWithFrench.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TrackingInfoWithFrench', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'TrackingInfoWithFrench':
            obj_ = ArrayOfTrackingInfoWithFrench.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TrackingInfoWithFrench = obj_
            obj_.original_tagname_ = 'TrackingInfoWithFrench'
# end class ResponseTrackingInfoWithFrench


class ArrayOfTrackingInfoWithFrench(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TrackingInfoWithFrench=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if TrackingInfoWithFrench is None:
            self.TrackingInfoWithFrench = []
        else:
            self.TrackingInfoWithFrench = TrackingInfoWithFrench
        self.TrackingInfoWithFrench_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfTrackingInfoWithFrench)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfTrackingInfoWithFrench.subclass:
            return ArrayOfTrackingInfoWithFrench.subclass(*args_, **kwargs_)
        else:
            return ArrayOfTrackingInfoWithFrench(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TrackingInfoWithFrench(self):
        return self.TrackingInfoWithFrench
    def set_TrackingInfoWithFrench(self, TrackingInfoWithFrench):
        self.TrackingInfoWithFrench = TrackingInfoWithFrench
    def add_TrackingInfoWithFrench(self, value):
        self.TrackingInfoWithFrench.append(value)
    def insert_TrackingInfoWithFrench_at(self, index, value):
        self.TrackingInfoWithFrench.insert(index, value)
    def replace_TrackingInfoWithFrench_at(self, index, value):
        self.TrackingInfoWithFrench[index] = value
    def _hasContent(self):
        if (
            self.TrackingInfoWithFrench
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfTrackingInfoWithFrench', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfTrackingInfoWithFrench')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfTrackingInfoWithFrench':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfTrackingInfoWithFrench')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfTrackingInfoWithFrench', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfTrackingInfoWithFrench'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfTrackingInfoWithFrench', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for TrackingInfoWithFrench_ in self.TrackingInfoWithFrench:
            namespaceprefix_ = self.TrackingInfoWithFrench_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackingInfoWithFrench_nsprefix_) else ''
            TrackingInfoWithFrench_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='TrackingInfoWithFrench', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TrackingInfoWithFrench':
            obj_ = TrackingInfoWithFrench.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TrackingInfoWithFrench.append(obj_)
            obj_.original_tagname_ = 'TrackingInfoWithFrench'
# end class ArrayOfTrackingInfoWithFrench


class TrackingInfoWithFrench(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, TrackingNum=None, StatusDate=None, Status=None, Signby=None, StatusFrench=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.TrackingNum = TrackingNum
        self.TrackingNum_nsprefix_ = None
        if isinstance(StatusDate, BaseStrType_):
            initvalue_ = datetime_.datetime.strptime(StatusDate, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = StatusDate
        self.StatusDate = initvalue_
        self.StatusDate_nsprefix_ = None
        self.Status = Status
        self.Status_nsprefix_ = None
        self.Signby = Signby
        self.Signby_nsprefix_ = None
        self.StatusFrench = StatusFrench
        self.StatusFrench_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TrackingInfoWithFrench)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TrackingInfoWithFrench.subclass:
            return TrackingInfoWithFrench.subclass(*args_, **kwargs_)
        else:
            return TrackingInfoWithFrench(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_TrackingNum(self):
        return self.TrackingNum
    def set_TrackingNum(self, TrackingNum):
        self.TrackingNum = TrackingNum
    def get_StatusDate(self):
        return self.StatusDate
    def set_StatusDate(self, StatusDate):
        self.StatusDate = StatusDate
    def get_Status(self):
        return self.Status
    def set_Status(self, Status):
        self.Status = Status
    def get_Signby(self):
        return self.Signby
    def set_Signby(self, Signby):
        self.Signby = Signby
    def get_StatusFrench(self):
        return self.StatusFrench
    def set_StatusFrench(self, StatusFrench):
        self.StatusFrench = StatusFrench
    def _hasContent(self):
        if (
            self.TrackingNum is not None or
            self.StatusDate is not None or
            self.Status is not None or
            self.Signby is not None or
            self.StatusFrench is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingInfoWithFrench', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('TrackingInfoWithFrench')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'TrackingInfoWithFrench':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='TrackingInfoWithFrench')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='TrackingInfoWithFrench', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='TrackingInfoWithFrench'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='TrackingInfoWithFrench', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.TrackingNum is not None:
            namespaceprefix_ = self.TrackingNum_nsprefix_ + ':' if (UseCapturedNS_ and self.TrackingNum_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTrackingNum>%s</%sTrackingNum>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TrackingNum), input_name='TrackingNum')), namespaceprefix_ , eol_))
        if self.StatusDate is not None:
            namespaceprefix_ = self.StatusDate_nsprefix_ + ':' if (UseCapturedNS_ and self.StatusDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStatusDate>%s</%sStatusDate>%s' % (namespaceprefix_ , self.gds_format_datetime(self.StatusDate, input_name='StatusDate'), namespaceprefix_ , eol_))
        if self.Status is not None:
            namespaceprefix_ = self.Status_nsprefix_ + ':' if (UseCapturedNS_ and self.Status_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStatus>%s</%sStatus>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Status), input_name='Status')), namespaceprefix_ , eol_))
        if self.Signby is not None:
            namespaceprefix_ = self.Signby_nsprefix_ + ':' if (UseCapturedNS_ and self.Signby_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSignby>%s</%sSignby>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Signby), input_name='Signby')), namespaceprefix_ , eol_))
        if self.StatusFrench is not None:
            namespaceprefix_ = self.StatusFrench_nsprefix_ + ':' if (UseCapturedNS_ and self.StatusFrench_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sStatusFrench>%s</%sStatusFrench>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.StatusFrench), input_name='StatusFrench')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'TrackingNum':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TrackingNum')
            value_ = self.gds_validate_string(value_, node, 'TrackingNum')
            self.TrackingNum = value_
            self.TrackingNum_nsprefix_ = child_.prefix
        elif nodeName_ == 'StatusDate':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.StatusDate = dval_
            self.StatusDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'Status':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Status')
            value_ = self.gds_validate_string(value_, node, 'Status')
            self.Status = value_
            self.Status_nsprefix_ = child_.prefix
        elif nodeName_ == 'Signby':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Signby')
            value_ = self.gds_validate_string(value_, node, 'Signby')
            self.Signby = value_
            self.Signby_nsprefix_ = child_.prefix
        elif nodeName_ == 'StatusFrench':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'StatusFrench')
            value_ = self.gds_validate_string(value_, node, 'StatusFrench')
            self.StatusFrench = value_
            self.StatusFrench_nsprefix_ = child_.prefix
# end class TrackingInfoWithFrench


class GetTransitDays(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, FromPostalCode=None, ToPostalCode=None, Product=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.FromPostalCode = FromPostalCode
        self.FromPostalCode_nsprefix_ = None
        self.ToPostalCode = ToPostalCode
        self.ToPostalCode_nsprefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetTransitDays)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetTransitDays.subclass:
            return GetTransitDays.subclass(*args_, **kwargs_)
        else:
            return GetTransitDays(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_FromPostalCode(self):
        return self.FromPostalCode
    def set_FromPostalCode(self, FromPostalCode):
        self.FromPostalCode = FromPostalCode
    def get_ToPostalCode(self):
        return self.ToPostalCode
    def set_ToPostalCode(self, ToPostalCode):
        self.ToPostalCode = ToPostalCode
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def _hasContent(self):
        if (
            self.FromPostalCode is not None or
            self.ToPostalCode is not None or
            self.Product is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetTransitDays', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetTransitDays')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetTransitDays':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetTransitDays')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetTransitDays', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetTransitDays'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetTransitDays', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.FromPostalCode is not None:
            namespaceprefix_ = self.FromPostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.FromPostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromPostalCode>%s</%sFromPostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromPostalCode), input_name='FromPostalCode')), namespaceprefix_ , eol_))
        if self.ToPostalCode is not None:
            namespaceprefix_ = self.ToPostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ToPostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sToPostalCode>%s</%sToPostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ToPostalCode), input_name='ToPostalCode')), namespaceprefix_ , eol_))
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'FromPostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromPostalCode')
            value_ = self.gds_validate_string(value_, node, 'FromPostalCode')
            self.FromPostalCode = value_
            self.FromPostalCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'ToPostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ToPostalCode')
            value_ = self.gds_validate_string(value_, node, 'ToPostalCode')
            self.ToPostalCode = value_
            self.ToPostalCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
# end class GetTransitDays


class GetTransitDaysResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, GetTransitDaysResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.GetTransitDaysResult = GetTransitDaysResult
        self.GetTransitDaysResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetTransitDaysResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetTransitDaysResponse.subclass:
            return GetTransitDaysResponse.subclass(*args_, **kwargs_)
        else:
            return GetTransitDaysResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_GetTransitDaysResult(self):
        return self.GetTransitDaysResult
    def set_GetTransitDaysResult(self, GetTransitDaysResult):
        self.GetTransitDaysResult = GetTransitDaysResult
    def _hasContent(self):
        if (
            self.GetTransitDaysResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetTransitDaysResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetTransitDaysResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetTransitDaysResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetTransitDaysResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetTransitDaysResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetTransitDaysResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetTransitDaysResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GetTransitDaysResult is not None:
            namespaceprefix_ = self.GetTransitDaysResult_nsprefix_ + ':' if (UseCapturedNS_ and self.GetTransitDaysResult_nsprefix_) else ''
            self.GetTransitDaysResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GetTransitDaysResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'GetTransitDaysResult':
            obj_ = ResponseTransitDays.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GetTransitDaysResult = obj_
            obj_.original_tagname_ = 'GetTransitDaysResult'
# end class GetTransitDaysResponse


class ResponseTransitDays(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, TransitDays=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.TransitDays = TransitDays
        self.TransitDays_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseTransitDays)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseTransitDays.subclass:
            return ResponseTransitDays.subclass(*args_, **kwargs_)
        else:
            return ResponseTransitDays(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_TransitDays(self):
        return self.TransitDays
    def set_TransitDays(self, TransitDays):
        self.TransitDays = TransitDays
    def _hasContent(self):
        if (
            self.Err is not None or
            self.TransitDays is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseTransitDays', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseTransitDays')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseTransitDays':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseTransitDays')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseTransitDays', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseTransitDays'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseTransitDays', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.TransitDays is not None:
            namespaceprefix_ = self.TransitDays_nsprefix_ + ':' if (UseCapturedNS_ and self.TransitDays_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTransitDays>%s</%sTransitDays>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.TransitDays), input_name='TransitDays')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'TransitDays':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'TransitDays')
            value_ = self.gds_validate_string(value_, node, 'TransitDays')
            self.TransitDays = value_
            self.TransitDays_nsprefix_ = child_.prefix
# end class ResponseTransitDays


class UploadManifestTextFile(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, f=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.f = f
        self.f_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UploadManifestTextFile)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UploadManifestTextFile.subclass:
            return UploadManifestTextFile.subclass(*args_, **kwargs_)
        else:
            return UploadManifestTextFile(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_f(self):
        return self.f
    def set_f(self, f):
        self.f = f
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.f is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='UploadManifestTextFile', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UploadManifestTextFile')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'UploadManifestTextFile':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UploadManifestTextFile')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='UploadManifestTextFile', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='UploadManifestTextFile'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='UploadManifestTextFile', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.f is not None:
            namespaceprefix_ = self.f_nsprefix_ + ':' if (UseCapturedNS_ and self.f_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sf>%s</%sf>%s' % (namespaceprefix_ , self.gds_format_base64(self.f, input_name='f'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'f':
            sval_ = child_.text
            if sval_ is not None:
                try:
                    bval_ = base64.b64decode(sval_)
                except (TypeError, ValueError) as exp:
                    raise_parse_error(child_, 'requires base64 encoded string: %s' % exp)
                bval_ = self.gds_validate_base64(bval_, node, 'f')
            else:
                bval_ = None
            self.f = bval_
            self.f_nsprefix_ = child_.prefix
# end class UploadManifestTextFile


class UploadManifestTextFileResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, UploadManifestTextFileResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.UploadManifestTextFileResult = UploadManifestTextFileResult
        self.UploadManifestTextFileResult_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UploadManifestTextFileResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UploadManifestTextFileResponse.subclass:
            return UploadManifestTextFileResponse.subclass(*args_, **kwargs_)
        else:
            return UploadManifestTextFileResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_UploadManifestTextFileResult(self):
        return self.UploadManifestTextFileResult
    def set_UploadManifestTextFileResult(self, UploadManifestTextFileResult):
        self.UploadManifestTextFileResult = UploadManifestTextFileResult
    def _hasContent(self):
        if (
            self.UploadManifestTextFileResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='UploadManifestTextFileResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('UploadManifestTextFileResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'UploadManifestTextFileResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='UploadManifestTextFileResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='UploadManifestTextFileResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='UploadManifestTextFileResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='UploadManifestTextFileResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.UploadManifestTextFileResult is not None:
            namespaceprefix_ = self.UploadManifestTextFileResult_nsprefix_ + ':' if (UseCapturedNS_ and self.UploadManifestTextFileResult_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sUploadManifestTextFileResult>%s</%sUploadManifestTextFileResult>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.UploadManifestTextFileResult), input_name='UploadManifestTextFileResult')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'UploadManifestTextFileResult':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'UploadManifestTextFileResult')
            value_ = self.gds_validate_string(value_, node, 'UploadManifestTextFileResult')
            self.UploadManifestTextFileResult = value_
            self.UploadManifestTextFileResult_nsprefix_ = child_.prefix
# end class UploadManifestTextFileResponse


class CreateReturnLabels(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, FromInfo=None, PackageInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.FromInfo = FromInfo
        self.FromInfo_nsprefix_ = "tns"
        self.PackageInfo = PackageInfo
        self.PackageInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnLabels)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnLabels.subclass:
            return CreateReturnLabels.subclass(*args_, **kwargs_)
        else:
            return CreateReturnLabels(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_FromInfo(self):
        return self.FromInfo
    def set_FromInfo(self, FromInfo):
        self.FromInfo = FromInfo
    def get_PackageInfo(self):
        return self.PackageInfo
    def set_PackageInfo(self, PackageInfo):
        self.PackageInfo = PackageInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.FromInfo is not None or
            self.PackageInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnLabels', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateReturnLabels')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateReturnLabels':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateReturnLabels')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateReturnLabels', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateReturnLabels'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnLabels', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.FromInfo is not None:
            namespaceprefix_ = self.FromInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.FromInfo_nsprefix_) else ''
            self.FromInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FromInfo', pretty_print=pretty_print)
        if self.PackageInfo is not None:
            namespaceprefix_ = self.PackageInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageInfo_nsprefix_) else ''
            self.PackageInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'FromInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FromInfo = obj_
            obj_.original_tagname_ = 'FromInfo'
        elif nodeName_ == 'PackageInfo':
            obj_ = PackageInfoReturn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageInfo = obj_
            obj_.original_tagname_ = 'PackageInfo'
# end class CreateReturnLabels


class PackageInfoReturn(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Product=None, TotalPieces=None, Weight=None, DeclaredValue=None, CostCenter=None, Referece=None, length=None, width=None, Height=None, WeightUnit=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.TotalPieces = TotalPieces
        self.TotalPieces_nsprefix_ = None
        self.Weight = Weight
        self.Weight_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.DeclaredValue_nsprefix_ = None
        self.CostCenter = CostCenter
        self.CostCenter_nsprefix_ = None
        self.Referece = Referece
        self.Referece_nsprefix_ = None
        self.length = length
        self.length_nsprefix_ = None
        self.width = width
        self.width_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.WeightUnit = WeightUnit
        self.WeightUnit_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PackageInfoReturn)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PackageInfoReturn.subclass:
            return PackageInfoReturn.subclass(*args_, **kwargs_)
        else:
            return PackageInfoReturn(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_TotalPieces(self):
        return self.TotalPieces
    def set_TotalPieces(self, TotalPieces):
        self.TotalPieces = TotalPieces
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_CostCenter(self):
        return self.CostCenter
    def set_CostCenter(self, CostCenter):
        self.CostCenter = CostCenter
    def get_Referece(self):
        return self.Referece
    def set_Referece(self, Referece):
        self.Referece = Referece
    def get_length(self):
        return self.length
    def set_length(self, length):
        self.length = length
    def get_width(self):
        return self.width
    def set_width(self, width):
        self.width = width
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_WeightUnit(self):
        return self.WeightUnit
    def set_WeightUnit(self, WeightUnit):
        self.WeightUnit = WeightUnit
    def _hasContent(self):
        if (
            self.Product is not None or
            self.TotalPieces is not None or
            self.Weight is not None or
            self.DeclaredValue is not None or
            self.CostCenter is not None or
            self.Referece is not None or
            self.length is not None or
            self.width is not None or
            self.Height is not None or
            self.WeightUnit is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackageInfoReturn', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PackageInfoReturn')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PackageInfoReturn':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PackageInfoReturn')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PackageInfoReturn', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PackageInfoReturn'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PackageInfoReturn', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.TotalPieces is not None:
            namespaceprefix_ = self.TotalPieces_nsprefix_ + ':' if (UseCapturedNS_ and self.TotalPieces_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTotalPieces>%s</%sTotalPieces>%s' % (namespaceprefix_ , self.gds_format_integer(self.TotalPieces, input_name='TotalPieces'), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_double(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_format_double(self.DeclaredValue, input_name='DeclaredValue'), namespaceprefix_ , eol_))
        if self.CostCenter is not None:
            namespaceprefix_ = self.CostCenter_nsprefix_ + ':' if (UseCapturedNS_ and self.CostCenter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCostCenter>%s</%sCostCenter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CostCenter), input_name='CostCenter')), namespaceprefix_ , eol_))
        if self.Referece is not None:
            namespaceprefix_ = self.Referece_nsprefix_ + ':' if (UseCapturedNS_ and self.Referece_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReferece>%s</%sReferece>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Referece), input_name='Referece')), namespaceprefix_ , eol_))
        if self.length is not None:
            namespaceprefix_ = self.length_nsprefix_ + ':' if (UseCapturedNS_ and self.length_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slength>%s</%slength>%s' % (namespaceprefix_ , self.gds_format_double(self.length, input_name='length'), namespaceprefix_ , eol_))
        if self.width is not None:
            namespaceprefix_ = self.width_nsprefix_ + ':' if (UseCapturedNS_ and self.width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swidth>%s</%swidth>%s' % (namespaceprefix_ , self.gds_format_double(self.width, input_name='width'), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_format_double(self.Height, input_name='Height'), namespaceprefix_ , eol_))
        if self.WeightUnit is not None:
            namespaceprefix_ = self.WeightUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.WeightUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeightUnit>%s</%sWeightUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.WeightUnit), input_name='WeightUnit')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'TotalPieces' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'TotalPieces')
            ival_ = self.gds_validate_integer(ival_, node, 'TotalPieces')
            self.TotalPieces = ival_
            self.TotalPieces_nsprefix_ = child_.prefix
        elif nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Weight')
            fval_ = self.gds_validate_double(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'DeclaredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'DeclaredValue')
            fval_ = self.gds_validate_double(fval_, node, 'DeclaredValue')
            self.DeclaredValue = fval_
            self.DeclaredValue_nsprefix_ = child_.prefix
        elif nodeName_ == 'CostCenter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CostCenter')
            value_ = self.gds_validate_string(value_, node, 'CostCenter')
            self.CostCenter = value_
            self.CostCenter_nsprefix_ = child_.prefix
        elif nodeName_ == 'Referece':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Referece')
            value_ = self.gds_validate_string(value_, node, 'Referece')
            self.Referece = value_
            self.Referece_nsprefix_ = child_.prefix
        elif nodeName_ == 'length' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'length')
            fval_ = self.gds_validate_double(fval_, node, 'length')
            self.length = fval_
            self.length_nsprefix_ = child_.prefix
        elif nodeName_ == 'width' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'width')
            fval_ = self.gds_validate_double(fval_, node, 'width')
            self.width = fval_
            self.width_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Height')
            fval_ = self.gds_validate_double(fval_, node, 'Height')
            self.Height = fval_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'WeightUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'WeightUnit')
            value_ = self.gds_validate_string(value_, node, 'WeightUnit')
            self.WeightUnit = value_
            self.WeightUnit_nsprefix_ = child_.prefix
# end class PackageInfoReturn


class CreateReturnLabelsResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CreateReturnLabelsResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CreateReturnLabelsResult = CreateReturnLabelsResult
        self.CreateReturnLabelsResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnLabelsResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnLabelsResponse.subclass:
            return CreateReturnLabelsResponse.subclass(*args_, **kwargs_)
        else:
            return CreateReturnLabelsResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CreateReturnLabelsResult(self):
        return self.CreateReturnLabelsResult
    def set_CreateReturnLabelsResult(self, CreateReturnLabelsResult):
        self.CreateReturnLabelsResult = CreateReturnLabelsResult
    def _hasContent(self):
        if (
            self.CreateReturnLabelsResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnLabelsResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateReturnLabelsResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateReturnLabelsResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateReturnLabelsResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateReturnLabelsResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateReturnLabelsResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnLabelsResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CreateReturnLabelsResult is not None:
            namespaceprefix_ = self.CreateReturnLabelsResult_nsprefix_ + ':' if (UseCapturedNS_ and self.CreateReturnLabelsResult_nsprefix_) else ''
            self.CreateReturnLabelsResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CreateReturnLabelsResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CreateReturnLabelsResult':
            obj_ = ResponseCreateReturnShipment.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CreateReturnLabelsResult = obj_
            obj_.original_tagname_ = 'CreateReturnLabelsResult'
# end class CreateReturnLabelsResponse


class ResponseCreateReturnShipment(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, PackageIDAndLink=None, PackageID=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.PackageIDAndLink = PackageIDAndLink
        self.PackageIDAndLink_nsprefix_ = None
        self.PackageID = PackageID
        self.PackageID_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseCreateReturnShipment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseCreateReturnShipment.subclass:
            return ResponseCreateReturnShipment.subclass(*args_, **kwargs_)
        else:
            return ResponseCreateReturnShipment(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_PackageIDAndLink(self):
        return self.PackageIDAndLink
    def set_PackageIDAndLink(self, PackageIDAndLink):
        self.PackageIDAndLink = PackageIDAndLink
    def get_PackageID(self):
        return self.PackageID
    def set_PackageID(self, PackageID):
        self.PackageID = PackageID
    def _hasContent(self):
        if (
            self.Err is not None or
            self.PackageIDAndLink is not None or
            self.PackageID is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCreateReturnShipment', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseCreateReturnShipment')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseCreateReturnShipment':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseCreateReturnShipment')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseCreateReturnShipment', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseCreateReturnShipment'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCreateReturnShipment', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.PackageIDAndLink is not None:
            namespaceprefix_ = self.PackageIDAndLink_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageIDAndLink_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageIDAndLink>%s</%sPackageIDAndLink>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageIDAndLink), input_name='PackageIDAndLink')), namespaceprefix_ , eol_))
        if self.PackageID is not None:
            namespaceprefix_ = self.PackageID_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageID_nsprefix_) else ''
            self.PackageID.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageID', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'PackageIDAndLink':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageIDAndLink')
            value_ = self.gds_validate_string(value_, node, 'PackageIDAndLink')
            self.PackageIDAndLink = value_
            self.PackageIDAndLink_nsprefix_ = child_.prefix
        elif nodeName_ == 'PackageID':
            obj_ = ArrayOfString.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageID = obj_
            obj_.original_tagname_ = 'PackageID'
# end class ResponseCreateReturnShipment


class CreatePickupRequest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, FromInfo=None, ToInfo=None, PickupPkgInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.FromInfo = FromInfo
        self.FromInfo_nsprefix_ = "tns"
        self.ToInfo = ToInfo
        self.ToInfo_nsprefix_ = "tns"
        self.PickupPkgInfo = PickupPkgInfo
        self.PickupPkgInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreatePickupRequest)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreatePickupRequest.subclass:
            return CreatePickupRequest.subclass(*args_, **kwargs_)
        else:
            return CreatePickupRequest(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_FromInfo(self):
        return self.FromInfo
    def set_FromInfo(self, FromInfo):
        self.FromInfo = FromInfo
    def get_ToInfo(self):
        return self.ToInfo
    def set_ToInfo(self, ToInfo):
        self.ToInfo = ToInfo
    def get_PickupPkgInfo(self):
        return self.PickupPkgInfo
    def set_PickupPkgInfo(self, PickupPkgInfo):
        self.PickupPkgInfo = PickupPkgInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.FromInfo is not None or
            self.ToInfo is not None or
            self.PickupPkgInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreatePickupRequest', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreatePickupRequest')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreatePickupRequest':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreatePickupRequest')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreatePickupRequest', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreatePickupRequest'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreatePickupRequest', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.FromInfo is not None:
            namespaceprefix_ = self.FromInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.FromInfo_nsprefix_) else ''
            self.FromInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FromInfo', pretty_print=pretty_print)
        if self.ToInfo is not None:
            namespaceprefix_ = self.ToInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ToInfo_nsprefix_) else ''
            self.ToInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ToInfo', pretty_print=pretty_print)
        if self.PickupPkgInfo is not None:
            namespaceprefix_ = self.PickupPkgInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PickupPkgInfo_nsprefix_) else ''
            self.PickupPkgInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PickupPkgInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'FromInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FromInfo = obj_
            obj_.original_tagname_ = 'FromInfo'
        elif nodeName_ == 'ToInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ToInfo = obj_
            obj_.original_tagname_ = 'ToInfo'
        elif nodeName_ == 'PickupPkgInfo':
            obj_ = PickupRequestPackageInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PickupPkgInfo = obj_
            obj_.original_tagname_ = 'PickupPkgInfo'
# end class CreatePickupRequest


class PickupRequestPackageInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ShipperContact=None, ReceiverContact=None, SpecialInstruction=None, PickupDate=None, CostCenter=None, Refereces=None, Pieces=None, Weight=None, WeightUnit=None, DeclaredValue=None, PrintLabel=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.ShipperContact = ShipperContact
        self.ShipperContact_nsprefix_ = None
        self.ReceiverContact = ReceiverContact
        self.ReceiverContact_nsprefix_ = None
        self.SpecialInstruction = SpecialInstruction
        self.SpecialInstruction_nsprefix_ = None
        self.PickupDate = PickupDate
        self.PickupDate_nsprefix_ = None
        self.CostCenter = CostCenter
        self.CostCenter_nsprefix_ = None
        self.Refereces = Refereces
        self.Refereces_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.Weight = Weight
        self.Weight_nsprefix_ = None
        self.WeightUnit = WeightUnit
        self.WeightUnit_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.DeclaredValue_nsprefix_ = None
        self.PrintLabel = PrintLabel
        self.PrintLabel_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PickupRequestPackageInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PickupRequestPackageInfo.subclass:
            return PickupRequestPackageInfo.subclass(*args_, **kwargs_)
        else:
            return PickupRequestPackageInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ShipperContact(self):
        return self.ShipperContact
    def set_ShipperContact(self, ShipperContact):
        self.ShipperContact = ShipperContact
    def get_ReceiverContact(self):
        return self.ReceiverContact
    def set_ReceiverContact(self, ReceiverContact):
        self.ReceiverContact = ReceiverContact
    def get_SpecialInstruction(self):
        return self.SpecialInstruction
    def set_SpecialInstruction(self, SpecialInstruction):
        self.SpecialInstruction = SpecialInstruction
    def get_PickupDate(self):
        return self.PickupDate
    def set_PickupDate(self, PickupDate):
        self.PickupDate = PickupDate
    def get_CostCenter(self):
        return self.CostCenter
    def set_CostCenter(self, CostCenter):
        self.CostCenter = CostCenter
    def get_Refereces(self):
        return self.Refereces
    def set_Refereces(self, Refereces):
        self.Refereces = Refereces
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_WeightUnit(self):
        return self.WeightUnit
    def set_WeightUnit(self, WeightUnit):
        self.WeightUnit = WeightUnit
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_PrintLabel(self):
        return self.PrintLabel
    def set_PrintLabel(self, PrintLabel):
        self.PrintLabel = PrintLabel
    def _hasContent(self):
        if (
            self.ShipperContact is not None or
            self.ReceiverContact is not None or
            self.SpecialInstruction is not None or
            self.PickupDate is not None or
            self.CostCenter is not None or
            self.Refereces is not None or
            self.Pieces is not None or
            self.Weight is not None or
            self.WeightUnit is not None or
            self.DeclaredValue is not None or
            self.PrintLabel is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PickupRequestPackageInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('PickupRequestPackageInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'PickupRequestPackageInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='PickupRequestPackageInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='PickupRequestPackageInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='PickupRequestPackageInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='PickupRequestPackageInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.ShipperContact is not None:
            namespaceprefix_ = self.ShipperContact_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperContact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperContact>%s</%sShipperContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperContact), input_name='ShipperContact')), namespaceprefix_ , eol_))
        if self.ReceiverContact is not None:
            namespaceprefix_ = self.ReceiverContact_nsprefix_ + ':' if (UseCapturedNS_ and self.ReceiverContact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReceiverContact>%s</%sReceiverContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ReceiverContact), input_name='ReceiverContact')), namespaceprefix_ , eol_))
        if self.SpecialInstruction is not None:
            namespaceprefix_ = self.SpecialInstruction_nsprefix_ + ':' if (UseCapturedNS_ and self.SpecialInstruction_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSpecialInstruction>%s</%sSpecialInstruction>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.SpecialInstruction), input_name='SpecialInstruction')), namespaceprefix_ , eol_))
        if self.PickupDate is not None:
            namespaceprefix_ = self.PickupDate_nsprefix_ + ':' if (UseCapturedNS_ and self.PickupDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPickupDate>%s</%sPickupDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PickupDate), input_name='PickupDate')), namespaceprefix_ , eol_))
        if self.CostCenter is not None:
            namespaceprefix_ = self.CostCenter_nsprefix_ + ':' if (UseCapturedNS_ and self.CostCenter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCostCenter>%s</%sCostCenter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CostCenter), input_name='CostCenter')), namespaceprefix_ , eol_))
        if self.Refereces is not None:
            namespaceprefix_ = self.Refereces_nsprefix_ + ':' if (UseCapturedNS_ and self.Refereces_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sRefereces>%s</%sRefereces>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Refereces), input_name='Refereces')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieces>%s</%sPieces>%s' % (namespaceprefix_ , self.gds_format_integer(self.Pieces, input_name='Pieces'), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_format_double(self.Weight, input_name='Weight'), namespaceprefix_ , eol_))
        if self.WeightUnit is not None:
            namespaceprefix_ = self.WeightUnit_nsprefix_ + ':' if (UseCapturedNS_ and self.WeightUnit_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeightUnit>%s</%sWeightUnit>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.WeightUnit), input_name='WeightUnit')), namespaceprefix_ , eol_))
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_format_double(self.DeclaredValue, input_name='DeclaredValue'), namespaceprefix_ , eol_))
        if self.PrintLabel is not None:
            namespaceprefix_ = self.PrintLabel_nsprefix_ + ':' if (UseCapturedNS_ and self.PrintLabel_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPrintLabel>%s</%sPrintLabel>%s' % (namespaceprefix_ , self.gds_format_boolean(self.PrintLabel, input_name='PrintLabel'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ShipperContact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperContact')
            value_ = self.gds_validate_string(value_, node, 'ShipperContact')
            self.ShipperContact = value_
            self.ShipperContact_nsprefix_ = child_.prefix
        elif nodeName_ == 'ReceiverContact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ReceiverContact')
            value_ = self.gds_validate_string(value_, node, 'ReceiverContact')
            self.ReceiverContact = value_
            self.ReceiverContact_nsprefix_ = child_.prefix
        elif nodeName_ == 'SpecialInstruction':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'SpecialInstruction')
            value_ = self.gds_validate_string(value_, node, 'SpecialInstruction')
            self.SpecialInstruction = value_
            self.SpecialInstruction_nsprefix_ = child_.prefix
        elif nodeName_ == 'PickupDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PickupDate')
            value_ = self.gds_validate_string(value_, node, 'PickupDate')
            self.PickupDate = value_
            self.PickupDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'CostCenter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CostCenter')
            value_ = self.gds_validate_string(value_, node, 'CostCenter')
            self.CostCenter = value_
            self.CostCenter_nsprefix_ = child_.prefix
        elif nodeName_ == 'Refereces':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Refereces')
            value_ = self.gds_validate_string(value_, node, 'Refereces')
            self.Refereces = value_
            self.Refereces_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'Pieces')
            ival_ = self.gds_validate_integer(ival_, node, 'Pieces')
            self.Pieces = ival_
            self.Pieces_nsprefix_ = child_.prefix
        elif nodeName_ == 'Weight' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Weight')
            fval_ = self.gds_validate_double(fval_, node, 'Weight')
            self.Weight = fval_
            self.Weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'WeightUnit':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'WeightUnit')
            value_ = self.gds_validate_string(value_, node, 'WeightUnit')
            self.WeightUnit = value_
            self.WeightUnit_nsprefix_ = child_.prefix
        elif nodeName_ == 'DeclaredValue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'DeclaredValue')
            fval_ = self.gds_validate_double(fval_, node, 'DeclaredValue')
            self.DeclaredValue = fval_
            self.DeclaredValue_nsprefix_ = child_.prefix
        elif nodeName_ == 'PrintLabel':
            sval_ = child_.text
            ival_ = self.gds_parse_boolean(sval_, node, 'PrintLabel')
            ival_ = self.gds_validate_boolean(ival_, node, 'PrintLabel')
            self.PrintLabel = ival_
            self.PrintLabel_nsprefix_ = child_.prefix
# end class PickupRequestPackageInfo


class CreatePickupRequestResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CreatePickupRequestResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CreatePickupRequestResult = CreatePickupRequestResult
        self.CreatePickupRequestResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreatePickupRequestResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreatePickupRequestResponse.subclass:
            return CreatePickupRequestResponse.subclass(*args_, **kwargs_)
        else:
            return CreatePickupRequestResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CreatePickupRequestResult(self):
        return self.CreatePickupRequestResult
    def set_CreatePickupRequestResult(self, CreatePickupRequestResult):
        self.CreatePickupRequestResult = CreatePickupRequestResult
    def _hasContent(self):
        if (
            self.CreatePickupRequestResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreatePickupRequestResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreatePickupRequestResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreatePickupRequestResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreatePickupRequestResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreatePickupRequestResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreatePickupRequestResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreatePickupRequestResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CreatePickupRequestResult is not None:
            namespaceprefix_ = self.CreatePickupRequestResult_nsprefix_ + ':' if (UseCapturedNS_ and self.CreatePickupRequestResult_nsprefix_) else ''
            self.CreatePickupRequestResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CreatePickupRequestResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CreatePickupRequestResult':
            obj_ = ResponsePickUpRequest.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CreatePickupRequestResult = obj_
            obj_.original_tagname_ = 'CreatePickupRequestResult'
# end class CreatePickupRequestResponse


class ResponsePickUpRequest(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, PickupNumber=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.PickupNumber = PickupNumber
        self.PickupNumber_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponsePickUpRequest)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponsePickUpRequest.subclass:
            return ResponsePickUpRequest.subclass(*args_, **kwargs_)
        else:
            return ResponsePickUpRequest(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_PickupNumber(self):
        return self.PickupNumber
    def set_PickupNumber(self, PickupNumber):
        self.PickupNumber = PickupNumber
    def _hasContent(self):
        if (
            self.Err is not None or
            self.PickupNumber is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponsePickUpRequest', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponsePickUpRequest')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponsePickUpRequest':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponsePickUpRequest')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponsePickUpRequest', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponsePickUpRequest'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponsePickUpRequest', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.PickupNumber is not None:
            namespaceprefix_ = self.PickupNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.PickupNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPickupNumber>%s</%sPickupNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PickupNumber), input_name='PickupNumber')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'PickupNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PickupNumber')
            value_ = self.gds_validate_string(value_, node, 'PickupNumber')
            self.PickupNumber = value_
            self.PickupNumber_nsprefix_ = child_.prefix
# end class ResponsePickUpRequest


class CreateReturnShipmentWithLabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, FromInfo=None, PackageInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.FromInfo = FromInfo
        self.FromInfo_nsprefix_ = "tns"
        self.PackageInfo = PackageInfo
        self.PackageInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnShipmentWithLabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnShipmentWithLabelInfo.subclass:
            return CreateReturnShipmentWithLabelInfo.subclass(*args_, **kwargs_)
        else:
            return CreateReturnShipmentWithLabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_FromInfo(self):
        return self.FromInfo
    def set_FromInfo(self, FromInfo):
        self.FromInfo = FromInfo
    def get_PackageInfo(self):
        return self.PackageInfo
    def set_PackageInfo(self, PackageInfo):
        self.PackageInfo = PackageInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.FromInfo is not None or
            self.PackageInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithLabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateReturnShipmentWithLabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateReturnShipmentWithLabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateReturnShipmentWithLabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateReturnShipmentWithLabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateReturnShipmentWithLabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithLabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.FromInfo is not None:
            namespaceprefix_ = self.FromInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.FromInfo_nsprefix_) else ''
            self.FromInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FromInfo', pretty_print=pretty_print)
        if self.PackageInfo is not None:
            namespaceprefix_ = self.PackageInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageInfo_nsprefix_) else ''
            self.PackageInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'FromInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FromInfo = obj_
            obj_.original_tagname_ = 'FromInfo'
        elif nodeName_ == 'PackageInfo':
            obj_ = PackageInfoReturn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageInfo = obj_
            obj_.original_tagname_ = 'PackageInfo'
# end class CreateReturnShipmentWithLabelInfo


class CreateReturnShipmentWithLabelInfoResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CreateReturnShipmentWithLabelInfoResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CreateReturnShipmentWithLabelInfoResult = CreateReturnShipmentWithLabelInfoResult
        self.CreateReturnShipmentWithLabelInfoResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnShipmentWithLabelInfoResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnShipmentWithLabelInfoResponse.subclass:
            return CreateReturnShipmentWithLabelInfoResponse.subclass(*args_, **kwargs_)
        else:
            return CreateReturnShipmentWithLabelInfoResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CreateReturnShipmentWithLabelInfoResult(self):
        return self.CreateReturnShipmentWithLabelInfoResult
    def set_CreateReturnShipmentWithLabelInfoResult(self, CreateReturnShipmentWithLabelInfoResult):
        self.CreateReturnShipmentWithLabelInfoResult = CreateReturnShipmentWithLabelInfoResult
    def _hasContent(self):
        if (
            self.CreateReturnShipmentWithLabelInfoResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithLabelInfoResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateReturnShipmentWithLabelInfoResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateReturnShipmentWithLabelInfoResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateReturnShipmentWithLabelInfoResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateReturnShipmentWithLabelInfoResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateReturnShipmentWithLabelInfoResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithLabelInfoResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CreateReturnShipmentWithLabelInfoResult is not None:
            namespaceprefix_ = self.CreateReturnShipmentWithLabelInfoResult_nsprefix_ + ':' if (UseCapturedNS_ and self.CreateReturnShipmentWithLabelInfoResult_nsprefix_) else ''
            self.CreateReturnShipmentWithLabelInfoResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CreateReturnShipmentWithLabelInfoResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CreateReturnShipmentWithLabelInfoResult':
            obj_ = ResponseReturnLabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CreateReturnShipmentWithLabelInfoResult = obj_
            obj_.original_tagname_ = 'CreateReturnShipmentWithLabelInfoResult'
# end class CreateReturnShipmentWithLabelInfoResponse


class ResponseReturnLabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Err=None, ReturnLabelInfo=None, PackageIDAndLink=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Err = Err
        self.Err_nsprefix_ = "tns"
        self.ReturnLabelInfo = ReturnLabelInfo
        self.ReturnLabelInfo_nsprefix_ = "tns"
        self.PackageIDAndLink = PackageIDAndLink
        self.PackageIDAndLink_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseReturnLabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseReturnLabelInfo.subclass:
            return ResponseReturnLabelInfo.subclass(*args_, **kwargs_)
        else:
            return ResponseReturnLabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Err(self):
        return self.Err
    def set_Err(self, Err):
        self.Err = Err
    def get_ReturnLabelInfo(self):
        return self.ReturnLabelInfo
    def set_ReturnLabelInfo(self, ReturnLabelInfo):
        self.ReturnLabelInfo = ReturnLabelInfo
    def get_PackageIDAndLink(self):
        return self.PackageIDAndLink
    def set_PackageIDAndLink(self, PackageIDAndLink):
        self.PackageIDAndLink = PackageIDAndLink
    def _hasContent(self):
        if (
            self.Err is not None or
            self.ReturnLabelInfo is not None or
            self.PackageIDAndLink is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseReturnLabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseReturnLabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseReturnLabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseReturnLabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseReturnLabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseReturnLabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseReturnLabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Err is not None:
            namespaceprefix_ = self.Err_nsprefix_ + ':' if (UseCapturedNS_ and self.Err_nsprefix_) else ''
            self.Err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='Err', pretty_print=pretty_print)
        if self.ReturnLabelInfo is not None:
            namespaceprefix_ = self.ReturnLabelInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ReturnLabelInfo_nsprefix_) else ''
            self.ReturnLabelInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ReturnLabelInfo', pretty_print=pretty_print)
        if self.PackageIDAndLink is not None:
            namespaceprefix_ = self.PackageIDAndLink_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageIDAndLink_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageIDAndLink>%s</%sPackageIDAndLink>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageIDAndLink), input_name='PackageIDAndLink')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Err = obj_
            obj_.original_tagname_ = 'Err'
        elif nodeName_ == 'ReturnLabelInfo':
            obj_ = ArrayOfReturnLabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ReturnLabelInfo = obj_
            obj_.original_tagname_ = 'ReturnLabelInfo'
        elif nodeName_ == 'PackageIDAndLink':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageIDAndLink')
            value_ = self.gds_validate_string(value_, node, 'PackageIDAndLink')
            self.PackageIDAndLink = value_
            self.PackageIDAndLink_nsprefix_ = child_.prefix
# end class ResponseReturnLabelInfo


class ArrayOfReturnLabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ReturnLabelInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ReturnLabelInfo is None:
            self.ReturnLabelInfo = []
        else:
            self.ReturnLabelInfo = ReturnLabelInfo
        self.ReturnLabelInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfReturnLabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfReturnLabelInfo.subclass:
            return ArrayOfReturnLabelInfo.subclass(*args_, **kwargs_)
        else:
            return ArrayOfReturnLabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ReturnLabelInfo(self):
        return self.ReturnLabelInfo
    def set_ReturnLabelInfo(self, ReturnLabelInfo):
        self.ReturnLabelInfo = ReturnLabelInfo
    def add_ReturnLabelInfo(self, value):
        self.ReturnLabelInfo.append(value)
    def insert_ReturnLabelInfo_at(self, index, value):
        self.ReturnLabelInfo.insert(index, value)
    def replace_ReturnLabelInfo_at(self, index, value):
        self.ReturnLabelInfo[index] = value
    def _hasContent(self):
        if (
            self.ReturnLabelInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfReturnLabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfReturnLabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfReturnLabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfReturnLabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfReturnLabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfReturnLabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfReturnLabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ReturnLabelInfo_ in self.ReturnLabelInfo:
            namespaceprefix_ = self.ReturnLabelInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ReturnLabelInfo_nsprefix_) else ''
            ReturnLabelInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ReturnLabelInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ReturnLabelInfo':
            obj_ = ReturnLabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ReturnLabelInfo.append(obj_)
            obj_.original_tagname_ = 'ReturnLabelInfo'
# end class ArrayOfReturnLabelInfo


class ReturnLabelInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AirportCode=None, AirportPhone=None, FromInfo=None, ToInfo=None, ToPostcode=None, Weight=None, Product=None, PIn=None, Pieces=None, Reference=None, Branch=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AirportCode = AirportCode
        self.AirportCode_nsprefix_ = None
        self.AirportPhone = AirportPhone
        self.AirportPhone_nsprefix_ = None
        self.FromInfo = FromInfo
        self.FromInfo_nsprefix_ = None
        self.ToInfo = ToInfo
        self.ToInfo_nsprefix_ = None
        self.ToPostcode = ToPostcode
        self.ToPostcode_nsprefix_ = None
        self.Weight = Weight
        self.Weight_nsprefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.PIn = PIn
        self.PIn_nsprefix_ = None
        self.Pieces = Pieces
        self.Pieces_nsprefix_ = None
        self.Reference = Reference
        self.Reference_nsprefix_ = None
        self.Branch = Branch
        self.Branch_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ReturnLabelInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReturnLabelInfo.subclass:
            return ReturnLabelInfo.subclass(*args_, **kwargs_)
        else:
            return ReturnLabelInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AirportCode(self):
        return self.AirportCode
    def set_AirportCode(self, AirportCode):
        self.AirportCode = AirportCode
    def get_AirportPhone(self):
        return self.AirportPhone
    def set_AirportPhone(self, AirportPhone):
        self.AirportPhone = AirportPhone
    def get_FromInfo(self):
        return self.FromInfo
    def set_FromInfo(self, FromInfo):
        self.FromInfo = FromInfo
    def get_ToInfo(self):
        return self.ToInfo
    def set_ToInfo(self, ToInfo):
        self.ToInfo = ToInfo
    def get_ToPostcode(self):
        return self.ToPostcode
    def set_ToPostcode(self, ToPostcode):
        self.ToPostcode = ToPostcode
    def get_Weight(self):
        return self.Weight
    def set_Weight(self, Weight):
        self.Weight = Weight
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_PIn(self):
        return self.PIn
    def set_PIn(self, PIn):
        self.PIn = PIn
    def get_Pieces(self):
        return self.Pieces
    def set_Pieces(self, Pieces):
        self.Pieces = Pieces
    def get_Reference(self):
        return self.Reference
    def set_Reference(self, Reference):
        self.Reference = Reference
    def get_Branch(self):
        return self.Branch
    def set_Branch(self, Branch):
        self.Branch = Branch
    def _hasContent(self):
        if (
            self.AirportCode is not None or
            self.AirportPhone is not None or
            self.FromInfo is not None or
            self.ToInfo is not None or
            self.ToPostcode is not None or
            self.Weight is not None or
            self.Product is not None or
            self.PIn is not None or
            self.Pieces is not None or
            self.Reference is not None or
            self.Branch is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ReturnLabelInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ReturnLabelInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ReturnLabelInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ReturnLabelInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ReturnLabelInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ReturnLabelInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ReturnLabelInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AirportCode is not None:
            namespaceprefix_ = self.AirportCode_nsprefix_ + ':' if (UseCapturedNS_ and self.AirportCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAirportCode>%s</%sAirportCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AirportCode), input_name='AirportCode')), namespaceprefix_ , eol_))
        if self.AirportPhone is not None:
            namespaceprefix_ = self.AirportPhone_nsprefix_ + ':' if (UseCapturedNS_ and self.AirportPhone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAirportPhone>%s</%sAirportPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.AirportPhone), input_name='AirportPhone')), namespaceprefix_ , eol_))
        if self.FromInfo is not None:
            namespaceprefix_ = self.FromInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.FromInfo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromInfo>%s</%sFromInfo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromInfo), input_name='FromInfo')), namespaceprefix_ , eol_))
        if self.ToInfo is not None:
            namespaceprefix_ = self.ToInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ToInfo_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sToInfo>%s</%sToInfo>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ToInfo), input_name='ToInfo')), namespaceprefix_ , eol_))
        if self.ToPostcode is not None:
            namespaceprefix_ = self.ToPostcode_nsprefix_ + ':' if (UseCapturedNS_ and self.ToPostcode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sToPostcode>%s</%sToPostcode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ToPostcode), input_name='ToPostcode')), namespaceprefix_ , eol_))
        if self.Weight is not None:
            namespaceprefix_ = self.Weight_nsprefix_ + ':' if (UseCapturedNS_ and self.Weight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWeight>%s</%sWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Weight), input_name='Weight')), namespaceprefix_ , eol_))
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.PIn is not None:
            namespaceprefix_ = self.PIn_nsprefix_ + ':' if (UseCapturedNS_ and self.PIn_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPIn>%s</%sPIn>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PIn), input_name='PIn')), namespaceprefix_ , eol_))
        if self.Pieces is not None:
            namespaceprefix_ = self.Pieces_nsprefix_ + ':' if (UseCapturedNS_ and self.Pieces_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPieces>%s</%sPieces>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Pieces), input_name='Pieces')), namespaceprefix_ , eol_))
        if self.Reference is not None:
            namespaceprefix_ = self.Reference_nsprefix_ + ':' if (UseCapturedNS_ and self.Reference_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReference>%s</%sReference>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Reference), input_name='Reference')), namespaceprefix_ , eol_))
        if self.Branch is not None:
            namespaceprefix_ = self.Branch_nsprefix_ + ':' if (UseCapturedNS_ and self.Branch_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBranch>%s</%sBranch>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Branch), input_name='Branch')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AirportCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AirportCode')
            value_ = self.gds_validate_string(value_, node, 'AirportCode')
            self.AirportCode = value_
            self.AirportCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'AirportPhone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'AirportPhone')
            value_ = self.gds_validate_string(value_, node, 'AirportPhone')
            self.AirportPhone = value_
            self.AirportPhone_nsprefix_ = child_.prefix
        elif nodeName_ == 'FromInfo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromInfo')
            value_ = self.gds_validate_string(value_, node, 'FromInfo')
            self.FromInfo = value_
            self.FromInfo_nsprefix_ = child_.prefix
        elif nodeName_ == 'ToInfo':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ToInfo')
            value_ = self.gds_validate_string(value_, node, 'ToInfo')
            self.ToInfo = value_
            self.ToInfo_nsprefix_ = child_.prefix
        elif nodeName_ == 'ToPostcode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ToPostcode')
            value_ = self.gds_validate_string(value_, node, 'ToPostcode')
            self.ToPostcode = value_
            self.ToPostcode_nsprefix_ = child_.prefix
        elif nodeName_ == 'Weight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Weight')
            value_ = self.gds_validate_string(value_, node, 'Weight')
            self.Weight = value_
            self.Weight_nsprefix_ = child_.prefix
        elif nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'PIn':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PIn')
            value_ = self.gds_validate_string(value_, node, 'PIn')
            self.PIn = value_
            self.PIn_nsprefix_ = child_.prefix
        elif nodeName_ == 'Pieces':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Pieces')
            value_ = self.gds_validate_string(value_, node, 'Pieces')
            self.Pieces = value_
            self.Pieces_nsprefix_ = child_.prefix
        elif nodeName_ == 'Reference':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Reference')
            value_ = self.gds_validate_string(value_, node, 'Reference')
            self.Reference = value_
            self.Reference_nsprefix_ = child_.prefix
        elif nodeName_ == 'Branch':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Branch')
            value_ = self.gds_validate_string(value_, node, 'Branch')
            self.Branch = value_
            self.Branch_nsprefix_ = child_.prefix
# end class ReturnLabelInfo


class CreateReturnShipmentWithConsigneeDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, FromInfo=None, PackageInfo=None, ConsigneeInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.FromInfo = FromInfo
        self.FromInfo_nsprefix_ = "tns"
        self.PackageInfo = PackageInfo
        self.PackageInfo_nsprefix_ = "tns"
        self.ConsigneeInfo = ConsigneeInfo
        self.ConsigneeInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnShipmentWithConsigneeDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnShipmentWithConsigneeDetail.subclass:
            return CreateReturnShipmentWithConsigneeDetail.subclass(*args_, **kwargs_)
        else:
            return CreateReturnShipmentWithConsigneeDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_FromInfo(self):
        return self.FromInfo
    def set_FromInfo(self, FromInfo):
        self.FromInfo = FromInfo
    def get_PackageInfo(self):
        return self.PackageInfo
    def set_PackageInfo(self, PackageInfo):
        self.PackageInfo = PackageInfo
    def get_ConsigneeInfo(self):
        return self.ConsigneeInfo
    def set_ConsigneeInfo(self, ConsigneeInfo):
        self.ConsigneeInfo = ConsigneeInfo
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.FromInfo is not None or
            self.PackageInfo is not None or
            self.ConsigneeInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithConsigneeDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateReturnShipmentWithConsigneeDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateReturnShipmentWithConsigneeDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateReturnShipmentWithConsigneeDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateReturnShipmentWithConsigneeDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateReturnShipmentWithConsigneeDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithConsigneeDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.FromInfo is not None:
            namespaceprefix_ = self.FromInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.FromInfo_nsprefix_) else ''
            self.FromInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='FromInfo', pretty_print=pretty_print)
        if self.PackageInfo is not None:
            namespaceprefix_ = self.PackageInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageInfo_nsprefix_) else ''
            self.PackageInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='PackageInfo', pretty_print=pretty_print)
        if self.ConsigneeInfo is not None:
            namespaceprefix_ = self.ConsigneeInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeInfo_nsprefix_) else ''
            self.ConsigneeInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ConsigneeInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'FromInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.FromInfo = obj_
            obj_.original_tagname_ = 'FromInfo'
        elif nodeName_ == 'PackageInfo':
            obj_ = PackageInfoReturn.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.PackageInfo = obj_
            obj_.original_tagname_ = 'PackageInfo'
        elif nodeName_ == 'ConsigneeInfo':
            obj_ = AddressInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConsigneeInfo = obj_
            obj_.original_tagname_ = 'ConsigneeInfo'
# end class CreateReturnShipmentWithConsigneeDetail


class CreateReturnShipmentWithConsigneeDetailResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CreateReturnShipmentWithConsigneeDetailResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.CreateReturnShipmentWithConsigneeDetailResult = CreateReturnShipmentWithConsigneeDetailResult
        self.CreateReturnShipmentWithConsigneeDetailResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CreateReturnShipmentWithConsigneeDetailResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CreateReturnShipmentWithConsigneeDetailResponse.subclass:
            return CreateReturnShipmentWithConsigneeDetailResponse.subclass(*args_, **kwargs_)
        else:
            return CreateReturnShipmentWithConsigneeDetailResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CreateReturnShipmentWithConsigneeDetailResult(self):
        return self.CreateReturnShipmentWithConsigneeDetailResult
    def set_CreateReturnShipmentWithConsigneeDetailResult(self, CreateReturnShipmentWithConsigneeDetailResult):
        self.CreateReturnShipmentWithConsigneeDetailResult = CreateReturnShipmentWithConsigneeDetailResult
    def _hasContent(self):
        if (
            self.CreateReturnShipmentWithConsigneeDetailResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithConsigneeDetailResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CreateReturnShipmentWithConsigneeDetailResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CreateReturnShipmentWithConsigneeDetailResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CreateReturnShipmentWithConsigneeDetailResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CreateReturnShipmentWithConsigneeDetailResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CreateReturnShipmentWithConsigneeDetailResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CreateReturnShipmentWithConsigneeDetailResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.CreateReturnShipmentWithConsigneeDetailResult is not None:
            namespaceprefix_ = self.CreateReturnShipmentWithConsigneeDetailResult_nsprefix_ + ':' if (UseCapturedNS_ and self.CreateReturnShipmentWithConsigneeDetailResult_nsprefix_) else ''
            self.CreateReturnShipmentWithConsigneeDetailResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CreateReturnShipmentWithConsigneeDetailResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CreateReturnShipmentWithConsigneeDetailResult':
            obj_ = ResponseReturnLabelInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CreateReturnShipmentWithConsigneeDetailResult = obj_
            obj_.original_tagname_ = 'CreateReturnShipmentWithConsigneeDetailResult'
# end class CreateReturnShipmentWithConsigneeDetailResponse


class GetClosedManifestsDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, FromDate=None, Todate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.FromDate = FromDate
        self.FromDate_nsprefix_ = None
        self.Todate = Todate
        self.Todate_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetClosedManifestsDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetClosedManifestsDetail.subclass:
            return GetClosedManifestsDetail.subclass(*args_, **kwargs_)
        else:
            return GetClosedManifestsDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_FromDate(self):
        return self.FromDate
    def set_FromDate(self, FromDate):
        self.FromDate = FromDate
    def get_Todate(self):
        return self.Todate
    def set_Todate(self, Todate):
        self.Todate = Todate
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.FromDate is not None or
            self.Todate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetClosedManifestsDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetClosedManifestsDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetClosedManifestsDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetClosedManifestsDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetClosedManifestsDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.FromDate is not None:
            namespaceprefix_ = self.FromDate_nsprefix_ + ':' if (UseCapturedNS_ and self.FromDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromDate>%s</%sFromDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromDate), input_name='FromDate')), namespaceprefix_ , eol_))
        if self.Todate is not None:
            namespaceprefix_ = self.Todate_nsprefix_ + ':' if (UseCapturedNS_ and self.Todate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTodate>%s</%sTodate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Todate), input_name='Todate')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'FromDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromDate')
            value_ = self.gds_validate_string(value_, node, 'FromDate')
            self.FromDate = value_
            self.FromDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'Todate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Todate')
            value_ = self.gds_validate_string(value_, node, 'Todate')
            self.Todate = value_
            self.Todate_nsprefix_ = child_.prefix
# end class GetClosedManifestsDetail


class GetClosedManifestsDetailResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, GetClosedManifestsDetailResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.GetClosedManifestsDetailResult = GetClosedManifestsDetailResult
        self.GetClosedManifestsDetailResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetClosedManifestsDetailResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetClosedManifestsDetailResponse.subclass:
            return GetClosedManifestsDetailResponse.subclass(*args_, **kwargs_)
        else:
            return GetClosedManifestsDetailResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_GetClosedManifestsDetailResult(self):
        return self.GetClosedManifestsDetailResult
    def set_GetClosedManifestsDetailResult(self, GetClosedManifestsDetailResult):
        self.GetClosedManifestsDetailResult = GetClosedManifestsDetailResult
    def _hasContent(self):
        if (
            self.GetClosedManifestsDetailResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetailResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetClosedManifestsDetailResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetClosedManifestsDetailResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetClosedManifestsDetailResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetClosedManifestsDetailResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetClosedManifestsDetailResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetailResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GetClosedManifestsDetailResult is not None:
            namespaceprefix_ = self.GetClosedManifestsDetailResult_nsprefix_ + ':' if (UseCapturedNS_ and self.GetClosedManifestsDetailResult_nsprefix_) else ''
            self.GetClosedManifestsDetailResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GetClosedManifestsDetailResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'GetClosedManifestsDetailResult':
            obj_ = ResponseCloseManifestDetail.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GetClosedManifestsDetailResult = obj_
            obj_.original_tagname_ = 'GetClosedManifestsDetailResult'
# end class GetClosedManifestsDetailResponse


class ResponseCloseManifestDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, err=None, CloseManifestDetailInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.err = err
        self.err_nsprefix_ = "tns"
        self.CloseManifestDetailInfo = CloseManifestDetailInfo
        self.CloseManifestDetailInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseCloseManifestDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseCloseManifestDetail.subclass:
            return ResponseCloseManifestDetail.subclass(*args_, **kwargs_)
        else:
            return ResponseCloseManifestDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_err(self):
        return self.err
    def set_err(self, err):
        self.err = err
    def get_CloseManifestDetailInfo(self):
        return self.CloseManifestDetailInfo
    def set_CloseManifestDetailInfo(self, CloseManifestDetailInfo):
        self.CloseManifestDetailInfo = CloseManifestDetailInfo
    def _hasContent(self):
        if (
            self.err is not None or
            self.CloseManifestDetailInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCloseManifestDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseCloseManifestDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseCloseManifestDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseCloseManifestDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseCloseManifestDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseCloseManifestDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCloseManifestDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.err is not None:
            namespaceprefix_ = self.err_nsprefix_ + ':' if (UseCapturedNS_ and self.err_nsprefix_) else ''
            self.err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='err', pretty_print=pretty_print)
        if self.CloseManifestDetailInfo is not None:
            namespaceprefix_ = self.CloseManifestDetailInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.CloseManifestDetailInfo_nsprefix_) else ''
            self.CloseManifestDetailInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CloseManifestDetailInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.err = obj_
            obj_.original_tagname_ = 'err'
        elif nodeName_ == 'CloseManifestDetailInfo':
            obj_ = ArrayOfCloseManifestDetail.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CloseManifestDetailInfo = obj_
            obj_.original_tagname_ = 'CloseManifestDetailInfo'
# end class ResponseCloseManifestDetail


class ArrayOfCloseManifestDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CloseManifestDetail=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CloseManifestDetail is None:
            self.CloseManifestDetail = []
        else:
            self.CloseManifestDetail = CloseManifestDetail
        self.CloseManifestDetail_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfCloseManifestDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfCloseManifestDetail.subclass:
            return ArrayOfCloseManifestDetail.subclass(*args_, **kwargs_)
        else:
            return ArrayOfCloseManifestDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CloseManifestDetail(self):
        return self.CloseManifestDetail
    def set_CloseManifestDetail(self, CloseManifestDetail):
        self.CloseManifestDetail = CloseManifestDetail
    def add_CloseManifestDetail(self, value):
        self.CloseManifestDetail.append(value)
    def insert_CloseManifestDetail_at(self, index, value):
        self.CloseManifestDetail.insert(index, value)
    def replace_CloseManifestDetail_at(self, index, value):
        self.CloseManifestDetail[index] = value
    def _hasContent(self):
        if (
            self.CloseManifestDetail
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfCloseManifestDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfCloseManifestDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfCloseManifestDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfCloseManifestDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfCloseManifestDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfCloseManifestDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfCloseManifestDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CloseManifestDetail_ in self.CloseManifestDetail:
            namespaceprefix_ = self.CloseManifestDetail_nsprefix_ + ':' if (UseCapturedNS_ and self.CloseManifestDetail_nsprefix_) else ''
            CloseManifestDetail_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CloseManifestDetail', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CloseManifestDetail':
            obj_ = CloseManifestDetail.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CloseManifestDetail.append(obj_)
            obj_.original_tagname_ = 'CloseManifestDetail'
# end class ArrayOfCloseManifestDetail


class CloseManifestDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Account=None, ManifestNumber=None, ConsigneeID=None, ConsigneeName=None, ConsigneeAddress1=None, ConsigneeAddress2=None, ConsigneeCity=None, ConsigneeProvince=None, ConsigneePostalCode=None, Contact=None, Phone=None, CostCenter=None, PackageID=None, References=None, ActualWeight=None, DimensionWeight=None, BilledWeight=None, Product=None, DeclaredValue=None, InsuranceCost=None, Length=None, Width=None, Height=None, Charges=None, Surcharges=None, ConsolidationCharges=None, ManifestCloseDate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Account = Account
        self.Account_nsprefix_ = None
        self.ManifestNumber = ManifestNumber
        self.ManifestNumber_nsprefix_ = None
        self.ConsigneeID = ConsigneeID
        self.ConsigneeID_nsprefix_ = None
        self.ConsigneeName = ConsigneeName
        self.ConsigneeName_nsprefix_ = None
        self.ConsigneeAddress1 = ConsigneeAddress1
        self.ConsigneeAddress1_nsprefix_ = None
        self.ConsigneeAddress2 = ConsigneeAddress2
        self.ConsigneeAddress2_nsprefix_ = None
        self.ConsigneeCity = ConsigneeCity
        self.ConsigneeCity_nsprefix_ = None
        self.ConsigneeProvince = ConsigneeProvince
        self.ConsigneeProvince_nsprefix_ = None
        self.ConsigneePostalCode = ConsigneePostalCode
        self.ConsigneePostalCode_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Phone = Phone
        self.Phone_nsprefix_ = None
        self.CostCenter = CostCenter
        self.CostCenter_nsprefix_ = None
        self.PackageID = PackageID
        self.PackageID_nsprefix_ = None
        self.References = References
        self.References_nsprefix_ = None
        self.ActualWeight = ActualWeight
        self.ActualWeight_nsprefix_ = None
        self.DimensionWeight = DimensionWeight
        self.DimensionWeight_nsprefix_ = None
        self.BilledWeight = BilledWeight
        self.BilledWeight_nsprefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.DeclaredValue_nsprefix_ = None
        self.InsuranceCost = InsuranceCost
        self.InsuranceCost_nsprefix_ = None
        self.Length = Length
        self.Length_nsprefix_ = None
        self.Width = Width
        self.Width_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.Charges = Charges
        self.Charges_nsprefix_ = None
        self.Surcharges = Surcharges
        self.Surcharges_nsprefix_ = None
        self.ConsolidationCharges = ConsolidationCharges
        self.ConsolidationCharges_nsprefix_ = None
        self.ManifestCloseDate = ManifestCloseDate
        self.ManifestCloseDate_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CloseManifestDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CloseManifestDetail.subclass:
            return CloseManifestDetail.subclass(*args_, **kwargs_)
        else:
            return CloseManifestDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Account(self):
        return self.Account
    def set_Account(self, Account):
        self.Account = Account
    def get_ManifestNumber(self):
        return self.ManifestNumber
    def set_ManifestNumber(self, ManifestNumber):
        self.ManifestNumber = ManifestNumber
    def get_ConsigneeID(self):
        return self.ConsigneeID
    def set_ConsigneeID(self, ConsigneeID):
        self.ConsigneeID = ConsigneeID
    def get_ConsigneeName(self):
        return self.ConsigneeName
    def set_ConsigneeName(self, ConsigneeName):
        self.ConsigneeName = ConsigneeName
    def get_ConsigneeAddress1(self):
        return self.ConsigneeAddress1
    def set_ConsigneeAddress1(self, ConsigneeAddress1):
        self.ConsigneeAddress1 = ConsigneeAddress1
    def get_ConsigneeAddress2(self):
        return self.ConsigneeAddress2
    def set_ConsigneeAddress2(self, ConsigneeAddress2):
        self.ConsigneeAddress2 = ConsigneeAddress2
    def get_ConsigneeCity(self):
        return self.ConsigneeCity
    def set_ConsigneeCity(self, ConsigneeCity):
        self.ConsigneeCity = ConsigneeCity
    def get_ConsigneeProvince(self):
        return self.ConsigneeProvince
    def set_ConsigneeProvince(self, ConsigneeProvince):
        self.ConsigneeProvince = ConsigneeProvince
    def get_ConsigneePostalCode(self):
        return self.ConsigneePostalCode
    def set_ConsigneePostalCode(self, ConsigneePostalCode):
        self.ConsigneePostalCode = ConsigneePostalCode
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Phone(self):
        return self.Phone
    def set_Phone(self, Phone):
        self.Phone = Phone
    def get_CostCenter(self):
        return self.CostCenter
    def set_CostCenter(self, CostCenter):
        self.CostCenter = CostCenter
    def get_PackageID(self):
        return self.PackageID
    def set_PackageID(self, PackageID):
        self.PackageID = PackageID
    def get_References(self):
        return self.References
    def set_References(self, References):
        self.References = References
    def get_ActualWeight(self):
        return self.ActualWeight
    def set_ActualWeight(self, ActualWeight):
        self.ActualWeight = ActualWeight
    def get_DimensionWeight(self):
        return self.DimensionWeight
    def set_DimensionWeight(self, DimensionWeight):
        self.DimensionWeight = DimensionWeight
    def get_BilledWeight(self):
        return self.BilledWeight
    def set_BilledWeight(self, BilledWeight):
        self.BilledWeight = BilledWeight
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_InsuranceCost(self):
        return self.InsuranceCost
    def set_InsuranceCost(self, InsuranceCost):
        self.InsuranceCost = InsuranceCost
    def get_Length(self):
        return self.Length
    def set_Length(self, Length):
        self.Length = Length
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_Charges(self):
        return self.Charges
    def set_Charges(self, Charges):
        self.Charges = Charges
    def get_Surcharges(self):
        return self.Surcharges
    def set_Surcharges(self, Surcharges):
        self.Surcharges = Surcharges
    def get_ConsolidationCharges(self):
        return self.ConsolidationCharges
    def set_ConsolidationCharges(self, ConsolidationCharges):
        self.ConsolidationCharges = ConsolidationCharges
    def get_ManifestCloseDate(self):
        return self.ManifestCloseDate
    def set_ManifestCloseDate(self, ManifestCloseDate):
        self.ManifestCloseDate = ManifestCloseDate
    def _hasContent(self):
        if (
            self.Account is not None or
            self.ManifestNumber is not None or
            self.ConsigneeID is not None or
            self.ConsigneeName is not None or
            self.ConsigneeAddress1 is not None or
            self.ConsigneeAddress2 is not None or
            self.ConsigneeCity is not None or
            self.ConsigneeProvince is not None or
            self.ConsigneePostalCode is not None or
            self.Contact is not None or
            self.Phone is not None or
            self.CostCenter is not None or
            self.PackageID is not None or
            self.References is not None or
            self.ActualWeight is not None or
            self.DimensionWeight is not None or
            self.BilledWeight is not None or
            self.Product is not None or
            self.DeclaredValue is not None or
            self.InsuranceCost is not None or
            self.Length is not None or
            self.Width is not None or
            self.Height is not None or
            self.Charges is not None or
            self.Surcharges is not None or
            self.ConsolidationCharges is not None or
            self.ManifestCloseDate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CloseManifestDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CloseManifestDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CloseManifestDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CloseManifestDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CloseManifestDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CloseManifestDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CloseManifestDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Account is not None:
            namespaceprefix_ = self.Account_nsprefix_ + ':' if (UseCapturedNS_ and self.Account_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccount>%s</%sAccount>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Account), input_name='Account')), namespaceprefix_ , eol_))
        if self.ManifestNumber is not None:
            namespaceprefix_ = self.ManifestNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestNumber>%s</%sManifestNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestNumber), input_name='ManifestNumber')), namespaceprefix_ , eol_))
        if self.ConsigneeID is not None:
            namespaceprefix_ = self.ConsigneeID_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeID>%s</%sConsigneeID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeID), input_name='ConsigneeID')), namespaceprefix_ , eol_))
        if self.ConsigneeName is not None:
            namespaceprefix_ = self.ConsigneeName_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeName>%s</%sConsigneeName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeName), input_name='ConsigneeName')), namespaceprefix_ , eol_))
        if self.ConsigneeAddress1 is not None:
            namespaceprefix_ = self.ConsigneeAddress1_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeAddress1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeAddress1>%s</%sConsigneeAddress1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeAddress1), input_name='ConsigneeAddress1')), namespaceprefix_ , eol_))
        if self.ConsigneeAddress2 is not None:
            namespaceprefix_ = self.ConsigneeAddress2_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeAddress2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeAddress2>%s</%sConsigneeAddress2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeAddress2), input_name='ConsigneeAddress2')), namespaceprefix_ , eol_))
        if self.ConsigneeCity is not None:
            namespaceprefix_ = self.ConsigneeCity_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeCity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeCity>%s</%sConsigneeCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeCity), input_name='ConsigneeCity')), namespaceprefix_ , eol_))
        if self.ConsigneeProvince is not None:
            namespaceprefix_ = self.ConsigneeProvince_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeProvince_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeProvince>%s</%sConsigneeProvince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeProvince), input_name='ConsigneeProvince')), namespaceprefix_ , eol_))
        if self.ConsigneePostalCode is not None:
            namespaceprefix_ = self.ConsigneePostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneePostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneePostalCode>%s</%sConsigneePostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneePostalCode), input_name='ConsigneePostalCode')), namespaceprefix_ , eol_))
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContact>%s</%sContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Contact), input_name='Contact')), namespaceprefix_ , eol_))
        if self.Phone is not None:
            namespaceprefix_ = self.Phone_nsprefix_ + ':' if (UseCapturedNS_ and self.Phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhone>%s</%sPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Phone), input_name='Phone')), namespaceprefix_ , eol_))
        if self.CostCenter is not None:
            namespaceprefix_ = self.CostCenter_nsprefix_ + ':' if (UseCapturedNS_ and self.CostCenter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCostCenter>%s</%sCostCenter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CostCenter), input_name='CostCenter')), namespaceprefix_ , eol_))
        if self.PackageID is not None:
            namespaceprefix_ = self.PackageID_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageID>%s</%sPackageID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageID), input_name='PackageID')), namespaceprefix_ , eol_))
        if self.References is not None:
            namespaceprefix_ = self.References_nsprefix_ + ':' if (UseCapturedNS_ and self.References_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReferences>%s</%sReferences>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.References), input_name='References')), namespaceprefix_ , eol_))
        if self.ActualWeight is not None:
            namespaceprefix_ = self.ActualWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.ActualWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sActualWeight>%s</%sActualWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ActualWeight), input_name='ActualWeight')), namespaceprefix_ , eol_))
        if self.DimensionWeight is not None:
            namespaceprefix_ = self.DimensionWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.DimensionWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDimensionWeight>%s</%sDimensionWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DimensionWeight), input_name='DimensionWeight')), namespaceprefix_ , eol_))
        if self.BilledWeight is not None:
            namespaceprefix_ = self.BilledWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.BilledWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBilledWeight>%s</%sBilledWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BilledWeight), input_name='BilledWeight')), namespaceprefix_ , eol_))
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DeclaredValue), input_name='DeclaredValue')), namespaceprefix_ , eol_))
        if self.InsuranceCost is not None:
            namespaceprefix_ = self.InsuranceCost_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuranceCost_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuranceCost>%s</%sInsuranceCost>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InsuranceCost), input_name='InsuranceCost')), namespaceprefix_ , eol_))
        if self.Length is not None:
            namespaceprefix_ = self.Length_nsprefix_ + ':' if (UseCapturedNS_ and self.Length_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLength>%s</%sLength>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Length), input_name='Length')), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Width), input_name='Width')), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Height), input_name='Height')), namespaceprefix_ , eol_))
        if self.Charges is not None:
            namespaceprefix_ = self.Charges_nsprefix_ + ':' if (UseCapturedNS_ and self.Charges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCharges>%s</%sCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.Charges, input_name='Charges'), namespaceprefix_ , eol_))
        if self.Surcharges is not None:
            namespaceprefix_ = self.Surcharges_nsprefix_ + ':' if (UseCapturedNS_ and self.Surcharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSurcharges>%s</%sSurcharges>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Surcharges), input_name='Surcharges')), namespaceprefix_ , eol_))
        if self.ConsolidationCharges is not None:
            namespaceprefix_ = self.ConsolidationCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsolidationCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsolidationCharges>%s</%sConsolidationCharges>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsolidationCharges), input_name='ConsolidationCharges')), namespaceprefix_ , eol_))
        if self.ManifestCloseDate is not None:
            namespaceprefix_ = self.ManifestCloseDate_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestCloseDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestCloseDate>%s</%sManifestCloseDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestCloseDate), input_name='ManifestCloseDate')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Account':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Account')
            value_ = self.gds_validate_string(value_, node, 'Account')
            self.Account = value_
            self.Account_nsprefix_ = child_.prefix
        elif nodeName_ == 'ManifestNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestNumber')
            value_ = self.gds_validate_string(value_, node, 'ManifestNumber')
            self.ManifestNumber = value_
            self.ManifestNumber_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeID')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeID')
            self.ConsigneeID = value_
            self.ConsigneeID_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeName')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeName')
            self.ConsigneeName = value_
            self.ConsigneeName_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeAddress1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeAddress1')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeAddress1')
            self.ConsigneeAddress1 = value_
            self.ConsigneeAddress1_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeAddress2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeAddress2')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeAddress2')
            self.ConsigneeAddress2 = value_
            self.ConsigneeAddress2_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeCity':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeCity')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeCity')
            self.ConsigneeCity = value_
            self.ConsigneeCity_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeProvince':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeProvince')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeProvince')
            self.ConsigneeProvince = value_
            self.ConsigneeProvince_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneePostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneePostalCode')
            value_ = self.gds_validate_string(value_, node, 'ConsigneePostalCode')
            self.ConsigneePostalCode = value_
            self.ConsigneePostalCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'Contact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Contact')
            value_ = self.gds_validate_string(value_, node, 'Contact')
            self.Contact = value_
            self.Contact_nsprefix_ = child_.prefix
        elif nodeName_ == 'Phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Phone')
            value_ = self.gds_validate_string(value_, node, 'Phone')
            self.Phone = value_
            self.Phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'CostCenter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CostCenter')
            value_ = self.gds_validate_string(value_, node, 'CostCenter')
            self.CostCenter = value_
            self.CostCenter_nsprefix_ = child_.prefix
        elif nodeName_ == 'PackageID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageID')
            value_ = self.gds_validate_string(value_, node, 'PackageID')
            self.PackageID = value_
            self.PackageID_nsprefix_ = child_.prefix
        elif nodeName_ == 'References':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'References')
            value_ = self.gds_validate_string(value_, node, 'References')
            self.References = value_
            self.References_nsprefix_ = child_.prefix
        elif nodeName_ == 'ActualWeight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ActualWeight')
            value_ = self.gds_validate_string(value_, node, 'ActualWeight')
            self.ActualWeight = value_
            self.ActualWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'DimensionWeight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DimensionWeight')
            value_ = self.gds_validate_string(value_, node, 'DimensionWeight')
            self.DimensionWeight = value_
            self.DimensionWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'BilledWeight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'BilledWeight')
            value_ = self.gds_validate_string(value_, node, 'BilledWeight')
            self.BilledWeight = value_
            self.BilledWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'DeclaredValue':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DeclaredValue')
            value_ = self.gds_validate_string(value_, node, 'DeclaredValue')
            self.DeclaredValue = value_
            self.DeclaredValue_nsprefix_ = child_.prefix
        elif nodeName_ == 'InsuranceCost':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InsuranceCost')
            value_ = self.gds_validate_string(value_, node, 'InsuranceCost')
            self.InsuranceCost = value_
            self.InsuranceCost_nsprefix_ = child_.prefix
        elif nodeName_ == 'Length':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Length')
            value_ = self.gds_validate_string(value_, node, 'Length')
            self.Length = value_
            self.Length_nsprefix_ = child_.prefix
        elif nodeName_ == 'Width':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Width')
            value_ = self.gds_validate_string(value_, node, 'Width')
            self.Width = value_
            self.Width_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Height')
            value_ = self.gds_validate_string(value_, node, 'Height')
            self.Height = value_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'Charges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Charges')
            fval_ = self.gds_validate_double(fval_, node, 'Charges')
            self.Charges = fval_
            self.Charges_nsprefix_ = child_.prefix
        elif nodeName_ == 'Surcharges':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Surcharges')
            value_ = self.gds_validate_string(value_, node, 'Surcharges')
            self.Surcharges = value_
            self.Surcharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsolidationCharges':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsolidationCharges')
            value_ = self.gds_validate_string(value_, node, 'ConsolidationCharges')
            self.ConsolidationCharges = value_
            self.ConsolidationCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'ManifestCloseDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestCloseDate')
            value_ = self.gds_validate_string(value_, node, 'ManifestCloseDate')
            self.ManifestCloseDate = value_
            self.ManifestCloseDate_nsprefix_ = child_.prefix
# end class CloseManifestDetail


class GetClosedManifestsDetailWithShipperDetail(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, AuthenicateAccount=None, FromDate=None, Todate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.AuthenicateAccount = AuthenicateAccount
        self.AuthenicateAccount_nsprefix_ = "tns"
        self.FromDate = FromDate
        self.FromDate_nsprefix_ = None
        self.Todate = Todate
        self.Todate_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetClosedManifestsDetailWithShipperDetail)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetClosedManifestsDetailWithShipperDetail.subclass:
            return GetClosedManifestsDetailWithShipperDetail.subclass(*args_, **kwargs_)
        else:
            return GetClosedManifestsDetailWithShipperDetail(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_AuthenicateAccount(self):
        return self.AuthenicateAccount
    def set_AuthenicateAccount(self, AuthenicateAccount):
        self.AuthenicateAccount = AuthenicateAccount
    def get_FromDate(self):
        return self.FromDate
    def set_FromDate(self, FromDate):
        self.FromDate = FromDate
    def get_Todate(self):
        return self.Todate
    def set_Todate(self, Todate):
        self.Todate = Todate
    def _hasContent(self):
        if (
            self.AuthenicateAccount is not None or
            self.FromDate is not None or
            self.Todate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetailWithShipperDetail', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetClosedManifestsDetailWithShipperDetail')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetClosedManifestsDetailWithShipperDetail':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetClosedManifestsDetailWithShipperDetail')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetClosedManifestsDetailWithShipperDetail', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetClosedManifestsDetailWithShipperDetail'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetailWithShipperDetail', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.AuthenicateAccount is not None:
            namespaceprefix_ = self.AuthenicateAccount_nsprefix_ + ':' if (UseCapturedNS_ and self.AuthenicateAccount_nsprefix_) else ''
            self.AuthenicateAccount.export(outfile, level, namespaceprefix_, namespacedef_='', name_='AuthenicateAccount', pretty_print=pretty_print)
        if self.FromDate is not None:
            namespaceprefix_ = self.FromDate_nsprefix_ + ':' if (UseCapturedNS_ and self.FromDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sFromDate>%s</%sFromDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.FromDate), input_name='FromDate')), namespaceprefix_ , eol_))
        if self.Todate is not None:
            namespaceprefix_ = self.Todate_nsprefix_ + ':' if (UseCapturedNS_ and self.Todate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sTodate>%s</%sTodate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Todate), input_name='Todate')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'AuthenicateAccount':
            obj_ = Authenticate.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.AuthenicateAccount = obj_
            obj_.original_tagname_ = 'AuthenicateAccount'
        elif nodeName_ == 'FromDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'FromDate')
            value_ = self.gds_validate_string(value_, node, 'FromDate')
            self.FromDate = value_
            self.FromDate_nsprefix_ = child_.prefix
        elif nodeName_ == 'Todate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Todate')
            value_ = self.gds_validate_string(value_, node, 'Todate')
            self.Todate = value_
            self.Todate_nsprefix_ = child_.prefix
# end class GetClosedManifestsDetailWithShipperDetail


class GetClosedManifestsDetailWithShipperDetailResponse(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, GetClosedManifestsDetailWithShipperDetailResult=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.GetClosedManifestsDetailWithShipperDetailResult = GetClosedManifestsDetailWithShipperDetailResult
        self.GetClosedManifestsDetailWithShipperDetailResult_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, GetClosedManifestsDetailWithShipperDetailResponse)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GetClosedManifestsDetailWithShipperDetailResponse.subclass:
            return GetClosedManifestsDetailWithShipperDetailResponse.subclass(*args_, **kwargs_)
        else:
            return GetClosedManifestsDetailWithShipperDetailResponse(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_GetClosedManifestsDetailWithShipperDetailResult(self):
        return self.GetClosedManifestsDetailWithShipperDetailResult
    def set_GetClosedManifestsDetailWithShipperDetailResult(self, GetClosedManifestsDetailWithShipperDetailResult):
        self.GetClosedManifestsDetailWithShipperDetailResult = GetClosedManifestsDetailWithShipperDetailResult
    def _hasContent(self):
        if (
            self.GetClosedManifestsDetailWithShipperDetailResult is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetailWithShipperDetailResponse', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('GetClosedManifestsDetailWithShipperDetailResponse')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'GetClosedManifestsDetailWithShipperDetailResponse':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='GetClosedManifestsDetailWithShipperDetailResponse')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='GetClosedManifestsDetailWithShipperDetailResponse', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='GetClosedManifestsDetailWithShipperDetailResponse'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='GetClosedManifestsDetailWithShipperDetailResponse', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.GetClosedManifestsDetailWithShipperDetailResult is not None:
            namespaceprefix_ = self.GetClosedManifestsDetailWithShipperDetailResult_nsprefix_ + ':' if (UseCapturedNS_ and self.GetClosedManifestsDetailWithShipperDetailResult_nsprefix_) else ''
            self.GetClosedManifestsDetailWithShipperDetailResult.export(outfile, level, namespaceprefix_, namespacedef_='', name_='GetClosedManifestsDetailWithShipperDetailResult', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'GetClosedManifestsDetailWithShipperDetailResult':
            obj_ = ResponseCloseManifestDetailWithShipperInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.GetClosedManifestsDetailWithShipperDetailResult = obj_
            obj_.original_tagname_ = 'GetClosedManifestsDetailWithShipperDetailResult'
# end class GetClosedManifestsDetailWithShipperDetailResponse


class ResponseCloseManifestDetailWithShipperInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, err=None, CloseManifestDetailWithShipperInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.err = err
        self.err_nsprefix_ = "tns"
        self.CloseManifestDetailWithShipperInfo = CloseManifestDetailWithShipperInfo
        self.CloseManifestDetailWithShipperInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ResponseCloseManifestDetailWithShipperInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ResponseCloseManifestDetailWithShipperInfo.subclass:
            return ResponseCloseManifestDetailWithShipperInfo.subclass(*args_, **kwargs_)
        else:
            return ResponseCloseManifestDetailWithShipperInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_err(self):
        return self.err
    def set_err(self, err):
        self.err = err
    def get_CloseManifestDetailWithShipperInfo(self):
        return self.CloseManifestDetailWithShipperInfo
    def set_CloseManifestDetailWithShipperInfo(self, CloseManifestDetailWithShipperInfo):
        self.CloseManifestDetailWithShipperInfo = CloseManifestDetailWithShipperInfo
    def _hasContent(self):
        if (
            self.err is not None or
            self.CloseManifestDetailWithShipperInfo is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCloseManifestDetailWithShipperInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ResponseCloseManifestDetailWithShipperInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ResponseCloseManifestDetailWithShipperInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ResponseCloseManifestDetailWithShipperInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ResponseCloseManifestDetailWithShipperInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ResponseCloseManifestDetailWithShipperInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ResponseCloseManifestDetailWithShipperInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.err is not None:
            namespaceprefix_ = self.err_nsprefix_ + ':' if (UseCapturedNS_ and self.err_nsprefix_) else ''
            self.err.export(outfile, level, namespaceprefix_, namespacedef_='', name_='err', pretty_print=pretty_print)
        if self.CloseManifestDetailWithShipperInfo is not None:
            namespaceprefix_ = self.CloseManifestDetailWithShipperInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.CloseManifestDetailWithShipperInfo_nsprefix_) else ''
            self.CloseManifestDetailWithShipperInfo.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CloseManifestDetailWithShipperInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'err':
            obj_ = ErrorClass.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.err = obj_
            obj_.original_tagname_ = 'err'
        elif nodeName_ == 'CloseManifestDetailWithShipperInfo':
            obj_ = ArrayOfCloseManifestDetailWithShipperInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CloseManifestDetailWithShipperInfo = obj_
            obj_.original_tagname_ = 'CloseManifestDetailWithShipperInfo'
# end class ResponseCloseManifestDetailWithShipperInfo


class ArrayOfCloseManifestDetailWithShipperInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, CloseManifestDetailWithShipperInfo=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if CloseManifestDetailWithShipperInfo is None:
            self.CloseManifestDetailWithShipperInfo = []
        else:
            self.CloseManifestDetailWithShipperInfo = CloseManifestDetailWithShipperInfo
        self.CloseManifestDetailWithShipperInfo_nsprefix_ = "tns"
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ArrayOfCloseManifestDetailWithShipperInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ArrayOfCloseManifestDetailWithShipperInfo.subclass:
            return ArrayOfCloseManifestDetailWithShipperInfo.subclass(*args_, **kwargs_)
        else:
            return ArrayOfCloseManifestDetailWithShipperInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_CloseManifestDetailWithShipperInfo(self):
        return self.CloseManifestDetailWithShipperInfo
    def set_CloseManifestDetailWithShipperInfo(self, CloseManifestDetailWithShipperInfo):
        self.CloseManifestDetailWithShipperInfo = CloseManifestDetailWithShipperInfo
    def add_CloseManifestDetailWithShipperInfo(self, value):
        self.CloseManifestDetailWithShipperInfo.append(value)
    def insert_CloseManifestDetailWithShipperInfo_at(self, index, value):
        self.CloseManifestDetailWithShipperInfo.insert(index, value)
    def replace_CloseManifestDetailWithShipperInfo_at(self, index, value):
        self.CloseManifestDetailWithShipperInfo[index] = value
    def _hasContent(self):
        if (
            self.CloseManifestDetailWithShipperInfo
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfCloseManifestDetailWithShipperInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ArrayOfCloseManifestDetailWithShipperInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'ArrayOfCloseManifestDetailWithShipperInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ArrayOfCloseManifestDetailWithShipperInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ArrayOfCloseManifestDetailWithShipperInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ArrayOfCloseManifestDetailWithShipperInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ArrayOfCloseManifestDetailWithShipperInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for CloseManifestDetailWithShipperInfo_ in self.CloseManifestDetailWithShipperInfo:
            namespaceprefix_ = self.CloseManifestDetailWithShipperInfo_nsprefix_ + ':' if (UseCapturedNS_ and self.CloseManifestDetailWithShipperInfo_nsprefix_) else ''
            CloseManifestDetailWithShipperInfo_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='CloseManifestDetailWithShipperInfo', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'CloseManifestDetailWithShipperInfo':
            obj_ = CloseManifestDetailWithShipperInfo.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.CloseManifestDetailWithShipperInfo.append(obj_)
            obj_.original_tagname_ = 'CloseManifestDetailWithShipperInfo'
# end class ArrayOfCloseManifestDetailWithShipperInfo


class CloseManifestDetailWithShipperInfo(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, Account=None, ManifestNumber=None, ShipperName=None, ShipperAddress1=None, ShipperAddress2=None, ShipperCity=None, ShipperProvince=None, ShipperPostalCode=None, ShipperContact=None, ShipperPhone=None, ConsigneeID=None, ConsigneeName=None, ConsigneeAddress1=None, ConsigneeAddress2=None, ConsigneeCity=None, ConsigneeProvince=None, ConsigneePostalCode=None, Contact=None, Phone=None, CostCenter=None, PackageID=None, References=None, ActualWeight=None, DimensionWeight=None, BilledWeight=None, Product=None, DeclaredValue=None, InsuranceCost=None, Length=None, Width=None, Height=None, Charges=None, Surcharges=None, ConsolidationCharges=None, ManifestCloseDate=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.Account = Account
        self.Account_nsprefix_ = None
        self.ManifestNumber = ManifestNumber
        self.ManifestNumber_nsprefix_ = None
        self.ShipperName = ShipperName
        self.ShipperName_nsprefix_ = None
        self.ShipperAddress1 = ShipperAddress1
        self.ShipperAddress1_nsprefix_ = None
        self.ShipperAddress2 = ShipperAddress2
        self.ShipperAddress2_nsprefix_ = None
        self.ShipperCity = ShipperCity
        self.ShipperCity_nsprefix_ = None
        self.ShipperProvince = ShipperProvince
        self.ShipperProvince_nsprefix_ = None
        self.ShipperPostalCode = ShipperPostalCode
        self.ShipperPostalCode_nsprefix_ = None
        self.ShipperContact = ShipperContact
        self.ShipperContact_nsprefix_ = None
        self.ShipperPhone = ShipperPhone
        self.ShipperPhone_nsprefix_ = None
        self.ConsigneeID = ConsigneeID
        self.ConsigneeID_nsprefix_ = None
        self.ConsigneeName = ConsigneeName
        self.ConsigneeName_nsprefix_ = None
        self.ConsigneeAddress1 = ConsigneeAddress1
        self.ConsigneeAddress1_nsprefix_ = None
        self.ConsigneeAddress2 = ConsigneeAddress2
        self.ConsigneeAddress2_nsprefix_ = None
        self.ConsigneeCity = ConsigneeCity
        self.ConsigneeCity_nsprefix_ = None
        self.ConsigneeProvince = ConsigneeProvince
        self.ConsigneeProvince_nsprefix_ = None
        self.ConsigneePostalCode = ConsigneePostalCode
        self.ConsigneePostalCode_nsprefix_ = None
        self.Contact = Contact
        self.Contact_nsprefix_ = None
        self.Phone = Phone
        self.Phone_nsprefix_ = None
        self.CostCenter = CostCenter
        self.CostCenter_nsprefix_ = None
        self.PackageID = PackageID
        self.PackageID_nsprefix_ = None
        self.References = References
        self.References_nsprefix_ = None
        self.ActualWeight = ActualWeight
        self.ActualWeight_nsprefix_ = None
        self.DimensionWeight = DimensionWeight
        self.DimensionWeight_nsprefix_ = None
        self.BilledWeight = BilledWeight
        self.BilledWeight_nsprefix_ = None
        self.Product = Product
        self.Product_nsprefix_ = None
        self.DeclaredValue = DeclaredValue
        self.DeclaredValue_nsprefix_ = None
        self.InsuranceCost = InsuranceCost
        self.InsuranceCost_nsprefix_ = None
        self.Length = Length
        self.Length_nsprefix_ = None
        self.Width = Width
        self.Width_nsprefix_ = None
        self.Height = Height
        self.Height_nsprefix_ = None
        self.Charges = Charges
        self.Charges_nsprefix_ = None
        self.Surcharges = Surcharges
        self.Surcharges_nsprefix_ = None
        self.ConsolidationCharges = ConsolidationCharges
        self.ConsolidationCharges_nsprefix_ = None
        self.ManifestCloseDate = ManifestCloseDate
        self.ManifestCloseDate_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, CloseManifestDetailWithShipperInfo)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CloseManifestDetailWithShipperInfo.subclass:
            return CloseManifestDetailWithShipperInfo.subclass(*args_, **kwargs_)
        else:
            return CloseManifestDetailWithShipperInfo(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_Account(self):
        return self.Account
    def set_Account(self, Account):
        self.Account = Account
    def get_ManifestNumber(self):
        return self.ManifestNumber
    def set_ManifestNumber(self, ManifestNumber):
        self.ManifestNumber = ManifestNumber
    def get_ShipperName(self):
        return self.ShipperName
    def set_ShipperName(self, ShipperName):
        self.ShipperName = ShipperName
    def get_ShipperAddress1(self):
        return self.ShipperAddress1
    def set_ShipperAddress1(self, ShipperAddress1):
        self.ShipperAddress1 = ShipperAddress1
    def get_ShipperAddress2(self):
        return self.ShipperAddress2
    def set_ShipperAddress2(self, ShipperAddress2):
        self.ShipperAddress2 = ShipperAddress2
    def get_ShipperCity(self):
        return self.ShipperCity
    def set_ShipperCity(self, ShipperCity):
        self.ShipperCity = ShipperCity
    def get_ShipperProvince(self):
        return self.ShipperProvince
    def set_ShipperProvince(self, ShipperProvince):
        self.ShipperProvince = ShipperProvince
    def get_ShipperPostalCode(self):
        return self.ShipperPostalCode
    def set_ShipperPostalCode(self, ShipperPostalCode):
        self.ShipperPostalCode = ShipperPostalCode
    def get_ShipperContact(self):
        return self.ShipperContact
    def set_ShipperContact(self, ShipperContact):
        self.ShipperContact = ShipperContact
    def get_ShipperPhone(self):
        return self.ShipperPhone
    def set_ShipperPhone(self, ShipperPhone):
        self.ShipperPhone = ShipperPhone
    def get_ConsigneeID(self):
        return self.ConsigneeID
    def set_ConsigneeID(self, ConsigneeID):
        self.ConsigneeID = ConsigneeID
    def get_ConsigneeName(self):
        return self.ConsigneeName
    def set_ConsigneeName(self, ConsigneeName):
        self.ConsigneeName = ConsigneeName
    def get_ConsigneeAddress1(self):
        return self.ConsigneeAddress1
    def set_ConsigneeAddress1(self, ConsigneeAddress1):
        self.ConsigneeAddress1 = ConsigneeAddress1
    def get_ConsigneeAddress2(self):
        return self.ConsigneeAddress2
    def set_ConsigneeAddress2(self, ConsigneeAddress2):
        self.ConsigneeAddress2 = ConsigneeAddress2
    def get_ConsigneeCity(self):
        return self.ConsigneeCity
    def set_ConsigneeCity(self, ConsigneeCity):
        self.ConsigneeCity = ConsigneeCity
    def get_ConsigneeProvince(self):
        return self.ConsigneeProvince
    def set_ConsigneeProvince(self, ConsigneeProvince):
        self.ConsigneeProvince = ConsigneeProvince
    def get_ConsigneePostalCode(self):
        return self.ConsigneePostalCode
    def set_ConsigneePostalCode(self, ConsigneePostalCode):
        self.ConsigneePostalCode = ConsigneePostalCode
    def get_Contact(self):
        return self.Contact
    def set_Contact(self, Contact):
        self.Contact = Contact
    def get_Phone(self):
        return self.Phone
    def set_Phone(self, Phone):
        self.Phone = Phone
    def get_CostCenter(self):
        return self.CostCenter
    def set_CostCenter(self, CostCenter):
        self.CostCenter = CostCenter
    def get_PackageID(self):
        return self.PackageID
    def set_PackageID(self, PackageID):
        self.PackageID = PackageID
    def get_References(self):
        return self.References
    def set_References(self, References):
        self.References = References
    def get_ActualWeight(self):
        return self.ActualWeight
    def set_ActualWeight(self, ActualWeight):
        self.ActualWeight = ActualWeight
    def get_DimensionWeight(self):
        return self.DimensionWeight
    def set_DimensionWeight(self, DimensionWeight):
        self.DimensionWeight = DimensionWeight
    def get_BilledWeight(self):
        return self.BilledWeight
    def set_BilledWeight(self, BilledWeight):
        self.BilledWeight = BilledWeight
    def get_Product(self):
        return self.Product
    def set_Product(self, Product):
        self.Product = Product
    def get_DeclaredValue(self):
        return self.DeclaredValue
    def set_DeclaredValue(self, DeclaredValue):
        self.DeclaredValue = DeclaredValue
    def get_InsuranceCost(self):
        return self.InsuranceCost
    def set_InsuranceCost(self, InsuranceCost):
        self.InsuranceCost = InsuranceCost
    def get_Length(self):
        return self.Length
    def set_Length(self, Length):
        self.Length = Length
    def get_Width(self):
        return self.Width
    def set_Width(self, Width):
        self.Width = Width
    def get_Height(self):
        return self.Height
    def set_Height(self, Height):
        self.Height = Height
    def get_Charges(self):
        return self.Charges
    def set_Charges(self, Charges):
        self.Charges = Charges
    def get_Surcharges(self):
        return self.Surcharges
    def set_Surcharges(self, Surcharges):
        self.Surcharges = Surcharges
    def get_ConsolidationCharges(self):
        return self.ConsolidationCharges
    def set_ConsolidationCharges(self, ConsolidationCharges):
        self.ConsolidationCharges = ConsolidationCharges
    def get_ManifestCloseDate(self):
        return self.ManifestCloseDate
    def set_ManifestCloseDate(self, ManifestCloseDate):
        self.ManifestCloseDate = ManifestCloseDate
    def _hasContent(self):
        if (
            self.Account is not None or
            self.ManifestNumber is not None or
            self.ShipperName is not None or
            self.ShipperAddress1 is not None or
            self.ShipperAddress2 is not None or
            self.ShipperCity is not None or
            self.ShipperProvince is not None or
            self.ShipperPostalCode is not None or
            self.ShipperContact is not None or
            self.ShipperPhone is not None or
            self.ConsigneeID is not None or
            self.ConsigneeName is not None or
            self.ConsigneeAddress1 is not None or
            self.ConsigneeAddress2 is not None or
            self.ConsigneeCity is not None or
            self.ConsigneeProvince is not None or
            self.ConsigneePostalCode is not None or
            self.Contact is not None or
            self.Phone is not None or
            self.CostCenter is not None or
            self.PackageID is not None or
            self.References is not None or
            self.ActualWeight is not None or
            self.DimensionWeight is not None or
            self.BilledWeight is not None or
            self.Product is not None or
            self.DeclaredValue is not None or
            self.InsuranceCost is not None or
            self.Length is not None or
            self.Width is not None or
            self.Height is not None or
            self.Charges is not None or
            self.Surcharges is not None or
            self.ConsolidationCharges is not None or
            self.ManifestCloseDate is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CloseManifestDetailWithShipperInfo', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('CloseManifestDetailWithShipperInfo')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None and name_ == 'CloseManifestDetailWithShipperInfo':
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self._exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='CloseManifestDetailWithShipperInfo')
        if self._hasContent():
            outfile.write('>%s' % (eol_, ))
            self._exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='CloseManifestDetailWithShipperInfo', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def _exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='CloseManifestDetailWithShipperInfo'):
        pass
    def _exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='CloseManifestDetailWithShipperInfo', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.Account is not None:
            namespaceprefix_ = self.Account_nsprefix_ + ':' if (UseCapturedNS_ and self.Account_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sAccount>%s</%sAccount>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Account), input_name='Account')), namespaceprefix_ , eol_))
        if self.ManifestNumber is not None:
            namespaceprefix_ = self.ManifestNumber_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestNumber_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestNumber>%s</%sManifestNumber>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestNumber), input_name='ManifestNumber')), namespaceprefix_ , eol_))
        if self.ShipperName is not None:
            namespaceprefix_ = self.ShipperName_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperName>%s</%sShipperName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperName), input_name='ShipperName')), namespaceprefix_ , eol_))
        if self.ShipperAddress1 is not None:
            namespaceprefix_ = self.ShipperAddress1_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperAddress1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperAddress1>%s</%sShipperAddress1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperAddress1), input_name='ShipperAddress1')), namespaceprefix_ , eol_))
        if self.ShipperAddress2 is not None:
            namespaceprefix_ = self.ShipperAddress2_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperAddress2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperAddress2>%s</%sShipperAddress2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperAddress2), input_name='ShipperAddress2')), namespaceprefix_ , eol_))
        if self.ShipperCity is not None:
            namespaceprefix_ = self.ShipperCity_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperCity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperCity>%s</%sShipperCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperCity), input_name='ShipperCity')), namespaceprefix_ , eol_))
        if self.ShipperProvince is not None:
            namespaceprefix_ = self.ShipperProvince_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperProvince_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperProvince>%s</%sShipperProvince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperProvince), input_name='ShipperProvince')), namespaceprefix_ , eol_))
        if self.ShipperPostalCode is not None:
            namespaceprefix_ = self.ShipperPostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperPostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperPostalCode>%s</%sShipperPostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperPostalCode), input_name='ShipperPostalCode')), namespaceprefix_ , eol_))
        if self.ShipperContact is not None:
            namespaceprefix_ = self.ShipperContact_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperContact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperContact>%s</%sShipperContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperContact), input_name='ShipperContact')), namespaceprefix_ , eol_))
        if self.ShipperPhone is not None:
            namespaceprefix_ = self.ShipperPhone_nsprefix_ + ':' if (UseCapturedNS_ and self.ShipperPhone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sShipperPhone>%s</%sShipperPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ShipperPhone), input_name='ShipperPhone')), namespaceprefix_ , eol_))
        if self.ConsigneeID is not None:
            namespaceprefix_ = self.ConsigneeID_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeID>%s</%sConsigneeID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeID), input_name='ConsigneeID')), namespaceprefix_ , eol_))
        if self.ConsigneeName is not None:
            namespaceprefix_ = self.ConsigneeName_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeName_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeName>%s</%sConsigneeName>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeName), input_name='ConsigneeName')), namespaceprefix_ , eol_))
        if self.ConsigneeAddress1 is not None:
            namespaceprefix_ = self.ConsigneeAddress1_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeAddress1_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeAddress1>%s</%sConsigneeAddress1>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeAddress1), input_name='ConsigneeAddress1')), namespaceprefix_ , eol_))
        if self.ConsigneeAddress2 is not None:
            namespaceprefix_ = self.ConsigneeAddress2_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeAddress2_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeAddress2>%s</%sConsigneeAddress2>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeAddress2), input_name='ConsigneeAddress2')), namespaceprefix_ , eol_))
        if self.ConsigneeCity is not None:
            namespaceprefix_ = self.ConsigneeCity_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeCity_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeCity>%s</%sConsigneeCity>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeCity), input_name='ConsigneeCity')), namespaceprefix_ , eol_))
        if self.ConsigneeProvince is not None:
            namespaceprefix_ = self.ConsigneeProvince_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneeProvince_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneeProvince>%s</%sConsigneeProvince>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneeProvince), input_name='ConsigneeProvince')), namespaceprefix_ , eol_))
        if self.ConsigneePostalCode is not None:
            namespaceprefix_ = self.ConsigneePostalCode_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsigneePostalCode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsigneePostalCode>%s</%sConsigneePostalCode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsigneePostalCode), input_name='ConsigneePostalCode')), namespaceprefix_ , eol_))
        if self.Contact is not None:
            namespaceprefix_ = self.Contact_nsprefix_ + ':' if (UseCapturedNS_ and self.Contact_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sContact>%s</%sContact>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Contact), input_name='Contact')), namespaceprefix_ , eol_))
        if self.Phone is not None:
            namespaceprefix_ = self.Phone_nsprefix_ + ':' if (UseCapturedNS_ and self.Phone_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPhone>%s</%sPhone>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Phone), input_name='Phone')), namespaceprefix_ , eol_))
        if self.CostCenter is not None:
            namespaceprefix_ = self.CostCenter_nsprefix_ + ':' if (UseCapturedNS_ and self.CostCenter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCostCenter>%s</%sCostCenter>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.CostCenter), input_name='CostCenter')), namespaceprefix_ , eol_))
        if self.PackageID is not None:
            namespaceprefix_ = self.PackageID_nsprefix_ + ':' if (UseCapturedNS_ and self.PackageID_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sPackageID>%s</%sPackageID>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.PackageID), input_name='PackageID')), namespaceprefix_ , eol_))
        if self.References is not None:
            namespaceprefix_ = self.References_nsprefix_ + ':' if (UseCapturedNS_ and self.References_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sReferences>%s</%sReferences>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.References), input_name='References')), namespaceprefix_ , eol_))
        if self.ActualWeight is not None:
            namespaceprefix_ = self.ActualWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.ActualWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sActualWeight>%s</%sActualWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ActualWeight), input_name='ActualWeight')), namespaceprefix_ , eol_))
        if self.DimensionWeight is not None:
            namespaceprefix_ = self.DimensionWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.DimensionWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDimensionWeight>%s</%sDimensionWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DimensionWeight), input_name='DimensionWeight')), namespaceprefix_ , eol_))
        if self.BilledWeight is not None:
            namespaceprefix_ = self.BilledWeight_nsprefix_ + ':' if (UseCapturedNS_ and self.BilledWeight_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sBilledWeight>%s</%sBilledWeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.BilledWeight), input_name='BilledWeight')), namespaceprefix_ , eol_))
        if self.Product is not None:
            namespaceprefix_ = self.Product_nsprefix_ + ':' if (UseCapturedNS_ and self.Product_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sProduct>%s</%sProduct>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Product), input_name='Product')), namespaceprefix_ , eol_))
        if self.DeclaredValue is not None:
            namespaceprefix_ = self.DeclaredValue_nsprefix_ + ':' if (UseCapturedNS_ and self.DeclaredValue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sDeclaredValue>%s</%sDeclaredValue>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.DeclaredValue), input_name='DeclaredValue')), namespaceprefix_ , eol_))
        if self.InsuranceCost is not None:
            namespaceprefix_ = self.InsuranceCost_nsprefix_ + ':' if (UseCapturedNS_ and self.InsuranceCost_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sInsuranceCost>%s</%sInsuranceCost>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.InsuranceCost), input_name='InsuranceCost')), namespaceprefix_ , eol_))
        if self.Length is not None:
            namespaceprefix_ = self.Length_nsprefix_ + ':' if (UseCapturedNS_ and self.Length_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sLength>%s</%sLength>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Length), input_name='Length')), namespaceprefix_ , eol_))
        if self.Width is not None:
            namespaceprefix_ = self.Width_nsprefix_ + ':' if (UseCapturedNS_ and self.Width_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sWidth>%s</%sWidth>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Width), input_name='Width')), namespaceprefix_ , eol_))
        if self.Height is not None:
            namespaceprefix_ = self.Height_nsprefix_ + ':' if (UseCapturedNS_ and self.Height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sHeight>%s</%sHeight>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Height), input_name='Height')), namespaceprefix_ , eol_))
        if self.Charges is not None:
            namespaceprefix_ = self.Charges_nsprefix_ + ':' if (UseCapturedNS_ and self.Charges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sCharges>%s</%sCharges>%s' % (namespaceprefix_ , self.gds_format_double(self.Charges, input_name='Charges'), namespaceprefix_ , eol_))
        if self.Surcharges is not None:
            namespaceprefix_ = self.Surcharges_nsprefix_ + ':' if (UseCapturedNS_ and self.Surcharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sSurcharges>%s</%sSurcharges>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.Surcharges), input_name='Surcharges')), namespaceprefix_ , eol_))
        if self.ConsolidationCharges is not None:
            namespaceprefix_ = self.ConsolidationCharges_nsprefix_ + ':' if (UseCapturedNS_ and self.ConsolidationCharges_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sConsolidationCharges>%s</%sConsolidationCharges>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ConsolidationCharges), input_name='ConsolidationCharges')), namespaceprefix_ , eol_))
        if self.ManifestCloseDate is not None:
            namespaceprefix_ = self.ManifestCloseDate_nsprefix_ + ':' if (UseCapturedNS_ and self.ManifestCloseDate_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sManifestCloseDate>%s</%sManifestCloseDate>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.ManifestCloseDate), input_name='ManifestCloseDate')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def _buildAttributes(self, node, attrs, already_processed):
        pass
    def _buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'Account':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Account')
            value_ = self.gds_validate_string(value_, node, 'Account')
            self.Account = value_
            self.Account_nsprefix_ = child_.prefix
        elif nodeName_ == 'ManifestNumber':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestNumber')
            value_ = self.gds_validate_string(value_, node, 'ManifestNumber')
            self.ManifestNumber = value_
            self.ManifestNumber_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperName')
            value_ = self.gds_validate_string(value_, node, 'ShipperName')
            self.ShipperName = value_
            self.ShipperName_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperAddress1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperAddress1')
            value_ = self.gds_validate_string(value_, node, 'ShipperAddress1')
            self.ShipperAddress1 = value_
            self.ShipperAddress1_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperAddress2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperAddress2')
            value_ = self.gds_validate_string(value_, node, 'ShipperAddress2')
            self.ShipperAddress2 = value_
            self.ShipperAddress2_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperCity':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperCity')
            value_ = self.gds_validate_string(value_, node, 'ShipperCity')
            self.ShipperCity = value_
            self.ShipperCity_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperProvince':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperProvince')
            value_ = self.gds_validate_string(value_, node, 'ShipperProvince')
            self.ShipperProvince = value_
            self.ShipperProvince_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperPostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperPostalCode')
            value_ = self.gds_validate_string(value_, node, 'ShipperPostalCode')
            self.ShipperPostalCode = value_
            self.ShipperPostalCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperContact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperContact')
            value_ = self.gds_validate_string(value_, node, 'ShipperContact')
            self.ShipperContact = value_
            self.ShipperContact_nsprefix_ = child_.prefix
        elif nodeName_ == 'ShipperPhone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ShipperPhone')
            value_ = self.gds_validate_string(value_, node, 'ShipperPhone')
            self.ShipperPhone = value_
            self.ShipperPhone_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeID')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeID')
            self.ConsigneeID = value_
            self.ConsigneeID_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeName':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeName')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeName')
            self.ConsigneeName = value_
            self.ConsigneeName_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeAddress1':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeAddress1')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeAddress1')
            self.ConsigneeAddress1 = value_
            self.ConsigneeAddress1_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeAddress2':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeAddress2')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeAddress2')
            self.ConsigneeAddress2 = value_
            self.ConsigneeAddress2_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeCity':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeCity')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeCity')
            self.ConsigneeCity = value_
            self.ConsigneeCity_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneeProvince':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneeProvince')
            value_ = self.gds_validate_string(value_, node, 'ConsigneeProvince')
            self.ConsigneeProvince = value_
            self.ConsigneeProvince_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsigneePostalCode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsigneePostalCode')
            value_ = self.gds_validate_string(value_, node, 'ConsigneePostalCode')
            self.ConsigneePostalCode = value_
            self.ConsigneePostalCode_nsprefix_ = child_.prefix
        elif nodeName_ == 'Contact':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Contact')
            value_ = self.gds_validate_string(value_, node, 'Contact')
            self.Contact = value_
            self.Contact_nsprefix_ = child_.prefix
        elif nodeName_ == 'Phone':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Phone')
            value_ = self.gds_validate_string(value_, node, 'Phone')
            self.Phone = value_
            self.Phone_nsprefix_ = child_.prefix
        elif nodeName_ == 'CostCenter':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'CostCenter')
            value_ = self.gds_validate_string(value_, node, 'CostCenter')
            self.CostCenter = value_
            self.CostCenter_nsprefix_ = child_.prefix
        elif nodeName_ == 'PackageID':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'PackageID')
            value_ = self.gds_validate_string(value_, node, 'PackageID')
            self.PackageID = value_
            self.PackageID_nsprefix_ = child_.prefix
        elif nodeName_ == 'References':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'References')
            value_ = self.gds_validate_string(value_, node, 'References')
            self.References = value_
            self.References_nsprefix_ = child_.prefix
        elif nodeName_ == 'ActualWeight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ActualWeight')
            value_ = self.gds_validate_string(value_, node, 'ActualWeight')
            self.ActualWeight = value_
            self.ActualWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'DimensionWeight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DimensionWeight')
            value_ = self.gds_validate_string(value_, node, 'DimensionWeight')
            self.DimensionWeight = value_
            self.DimensionWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'BilledWeight':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'BilledWeight')
            value_ = self.gds_validate_string(value_, node, 'BilledWeight')
            self.BilledWeight = value_
            self.BilledWeight_nsprefix_ = child_.prefix
        elif nodeName_ == 'Product':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Product')
            value_ = self.gds_validate_string(value_, node, 'Product')
            self.Product = value_
            self.Product_nsprefix_ = child_.prefix
        elif nodeName_ == 'DeclaredValue':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'DeclaredValue')
            value_ = self.gds_validate_string(value_, node, 'DeclaredValue')
            self.DeclaredValue = value_
            self.DeclaredValue_nsprefix_ = child_.prefix
        elif nodeName_ == 'InsuranceCost':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'InsuranceCost')
            value_ = self.gds_validate_string(value_, node, 'InsuranceCost')
            self.InsuranceCost = value_
            self.InsuranceCost_nsprefix_ = child_.prefix
        elif nodeName_ == 'Length':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Length')
            value_ = self.gds_validate_string(value_, node, 'Length')
            self.Length = value_
            self.Length_nsprefix_ = child_.prefix
        elif nodeName_ == 'Width':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Width')
            value_ = self.gds_validate_string(value_, node, 'Width')
            self.Width = value_
            self.Width_nsprefix_ = child_.prefix
        elif nodeName_ == 'Height':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Height')
            value_ = self.gds_validate_string(value_, node, 'Height')
            self.Height = value_
            self.Height_nsprefix_ = child_.prefix
        elif nodeName_ == 'Charges' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_double(sval_, node, 'Charges')
            fval_ = self.gds_validate_double(fval_, node, 'Charges')
            self.Charges = fval_
            self.Charges_nsprefix_ = child_.prefix
        elif nodeName_ == 'Surcharges':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'Surcharges')
            value_ = self.gds_validate_string(value_, node, 'Surcharges')
            self.Surcharges = value_
            self.Surcharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'ConsolidationCharges':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ConsolidationCharges')
            value_ = self.gds_validate_string(value_, node, 'ConsolidationCharges')
            self.ConsolidationCharges = value_
            self.ConsolidationCharges_nsprefix_ = child_.prefix
        elif nodeName_ == 'ManifestCloseDate':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'ManifestCloseDate')
            value_ = self.gds_validate_string(value_, node, 'ManifestCloseDate')
            self.ManifestCloseDate = value_
            self.ManifestCloseDate_nsprefix_ = child_.prefix
# end class CloseManifestDetailWithShipperInfo


GDSClassesMapping = {
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def get_required_ns_prefix_defs(rootNode):
    '''Get all name space prefix definitions required in this XML doc.
    Return a dictionary of definitions and a char string of definitions.
    '''
    nsmap = {
        prefix: uri
        for node in rootNode.iter()
        for (prefix, uri) in node.nsmap.items()
        if prefix is not None
    }
    namespacedefs = ' '.join([
        'xmlns:{}="{}"'.format(prefix, uri)
        for prefix, uri in nsmap.items()
    ])
    return nsmap, namespacedefs


def parse(inFileName, silence=False, print_warnings=True):
    global CapturedNsmap_
    gds_collector = GdsCollector_()
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'ValidateUser'
        rootClass = ValidateUser
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    CapturedNsmap_, namespacedefs = get_required_ns_prefix_defs(rootNode)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_=namespacedefs,
            pretty_print=True)
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseEtree(inFileName, silence=False, print_warnings=True,
               mapping=None, reverse_mapping=None, nsmap=None):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'ValidateUser'
        rootClass = ValidateUser
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    if mapping is None:
        mapping = {}
    if reverse_mapping is None:
        reverse_mapping = {}
    rootElement = rootObj.to_etree(
        None, name_=rootTag, mapping_=mapping,
        reverse_mapping_=reverse_mapping, nsmap_=nsmap)
    reverse_node_mapping = rootObj.gds_reverse_node_mapping(mapping)
    # Enable Python to collect the space used by the DOM.
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(str(content))
        sys.stdout.write('\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj, rootElement, mapping, reverse_node_mapping


def parseString(inString, silence=False, print_warnings=True):
    '''Parse a string, create the object tree, and export it.

    Arguments:
    - inString -- A string.  This XML fragment should not start
      with an XML declaration containing an encoding.
    - silence -- A boolean.  If False, export the object.
    Returns -- The root object in the tree.
    '''
    parser = None
    rootNode= parsexmlstring_(inString, parser)
    gds_collector = GdsCollector_()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'ValidateUser'
        rootClass = ValidateUser
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    if not SaveElementTreeNode:
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='xmlns:tns="http://www.icscourier.ca/"')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseLiteral(inFileName, silence=False, print_warnings=True):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'ValidateUser'
        rootClass = ValidateUser
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('#from services import *\n\n')
        sys.stdout.write('import services as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

RenameMappings_ = {
}

#
# Mapping of namespaces to types defined in them
# and the file in which each is defined.
# simpleTypes are marked "ST" and complexTypes "CT".
NamespaceToDefMappings_ = {'http://www.icscourier.ca/': [('ErrorClass', './schemas/services.xsd', 'CT'),
                               ('AddressInfo', './schemas/services.xsd', 'CT'),
                               ('Authenticate', './schemas/services.xsd', 'CT'),
                               ('PackageInfo', './schemas/services.xsd', 'CT'),
                               ('ArrayOfPieceInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('PieceInfo', './schemas/services.xsd', 'CT'),
                               ('ArrayOfString',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseCreateShipment',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseLabelInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfLabelInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('LabelInfo', './schemas/services.xsd', 'CT'),
                               ('ArrayOfSurCharge',
                                './schemas/services.xsd',
                                'CT'),
                               ('SurCharge', './schemas/services.xsd', 'CT'),
                               ('ResponseCloseManifestPDF',
                                './schemas/services.xsd',
                                'CT'),
                               ('PackgeInfoToGetCharges',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseGetCharges',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseVoidPackage',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfPackageVoidStatus',
                                './schemas/services.xsd',
                                'CT'),
                               ('PackageVoidStatus',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseOpenManifest',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfOpenManifestInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('OpenManifestInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseOpenManifestWithShipperInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfOpenManifestWithShipperInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('OpenManifestWithShipperInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseTrackingInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfTrackingInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('TrackingInfo', './schemas/services.xsd', 'CT'),
                               ('ResponseTrackingInfoWithFrench',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfTrackingInfoWithFrench',
                                './schemas/services.xsd',
                                'CT'),
                               ('TrackingInfoWithFrench',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseTransitDays',
                                './schemas/services.xsd',
                                'CT'),
                               ('PackageInfoReturn',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseCreateReturnShipment',
                                './schemas/services.xsd',
                                'CT'),
                               ('PickupRequestPackageInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponsePickUpRequest',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseReturnLabelInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfReturnLabelInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ReturnLabelInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseCloseManifestDetail',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfCloseManifestDetail',
                                './schemas/services.xsd',
                                'CT'),
                               ('CloseManifestDetail',
                                './schemas/services.xsd',
                                'CT'),
                               ('ResponseCloseManifestDetailWithShipperInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('ArrayOfCloseManifestDetailWithShipperInfo',
                                './schemas/services.xsd',
                                'CT'),
                               ('CloseManifestDetailWithShipperInfo',
                                './schemas/services.xsd',
                                'CT')]}

__all__ = [
    "AddressInfo",
    "ArrayOfCloseManifestDetail",
    "ArrayOfCloseManifestDetailWithShipperInfo",
    "ArrayOfLabelInfo",
    "ArrayOfOpenManifestInfo",
    "ArrayOfOpenManifestWithShipperInfo",
    "ArrayOfPackageVoidStatus",
    "ArrayOfPieceInfo",
    "ArrayOfReturnLabelInfo",
    "ArrayOfString",
    "ArrayOfSurCharge",
    "ArrayOfTrackingInfo",
    "ArrayOfTrackingInfoWithFrench",
    "Authenticate",
    "CloseManifestDetail",
    "CloseManifestDetailWithShipperInfo",
    "CreatePickupRequest",
    "CreatePickupRequestResponse",
    "CreateReturnLabels",
    "CreateReturnLabelsResponse",
    "CreateReturnShipmentWithConsigneeDetail",
    "CreateReturnShipmentWithConsigneeDetailResponse",
    "CreateReturnShipmentWithLabelInfo",
    "CreateReturnShipmentWithLabelInfoResponse",
    "CreateShipment",
    "CreateShipmentResponse",
    "CreateShipmentWithLabelInfo",
    "CreateShipmentWithLabelInfoResponse",
    "CreateShipmentWithShipperDetail",
    "CreateShipmentWithShipperDetailResponse",
    "ErrorClass",
    "GetCloseManifestPDF",
    "GetCloseManifestPDFResponse",
    "GetClosedManifestsDetail",
    "GetClosedManifestsDetailResponse",
    "GetClosedManifestsDetailWithShipperDetail",
    "GetClosedManifestsDetailWithShipperDetailResponse",
    "GetEstimatedCharges",
    "GetEstimatedChargesResponse",
    "GetOpenManifest",
    "GetOpenManifestResponse",
    "GetOpenManifestWithShipperDetail",
    "GetOpenManifestWithShipperDetailResponse",
    "GetTransitDays",
    "GetTransitDaysResponse",
    "IsPostcodeinIcsAOS",
    "IsPostcodeinIcsAOSResponse",
    "IsProductAvailable",
    "IsProductAvailableResponse",
    "LabelInfo",
    "OpenManifestInfo",
    "OpenManifestWithShipperInfo",
    "PackageInfo",
    "PackageInfoReturn",
    "PackageVoidStatus",
    "PackgeInfoToGetCharges",
    "PickupRequestPackageInfo",
    "PieceInfo",
    "ResponseCloseManifestDetail",
    "ResponseCloseManifestDetailWithShipperInfo",
    "ResponseCloseManifestPDF",
    "ResponseCreateReturnShipment",
    "ResponseCreateShipment",
    "ResponseGetCharges",
    "ResponseLabelInfo",
    "ResponseOpenManifest",
    "ResponseOpenManifestWithShipperInfo",
    "ResponsePickUpRequest",
    "ResponseReturnLabelInfo",
    "ResponseTrackingInfo",
    "ResponseTrackingInfoWithFrench",
    "ResponseTransitDays",
    "ResponseVoidPackage",
    "ReturnLabelInfo",
    "SurCharge",
    "TracePackge",
    "TracePackgeResponse",
    "TracePackgeWithEnFRStatus",
    "TracePackgeWithEnFRStatusResponse",
    "TrackingInfo",
    "TrackingInfoWithFrench",
    "UploadManifestTextFile",
    "UploadManifestTextFileResponse",
    "ValidateShipToInfo",
    "ValidateShipToInfoResponse",
    "ValidateUser",
    "ValidateUserResponse",
    "VoidPackages",
    "VoidPackagesResponse"
]
