"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import collections.abc
import grpc
import grpc.aio
import typing
import vdp.pipeline.v1beta.common_pb2
import vdp.pipeline.v1beta.component_definition_pb2
import vdp.pipeline.v1beta.pipeline_pb2
import vdp.pipeline.v1beta.secret_pb2

_T = typing.TypeVar('_T')

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta):
    ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore
    ...

class PipelinePublicServiceStub:
    """VDP

    PipelinePublicService exposes the public VDP endpoints that allow clients to
    manage pipelines.
    """

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Liveness: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.LivenessRequest,
        vdp.pipeline.v1beta.pipeline_pb2.LivenessResponse,
    ]
    """Check if the pipeline server is alive

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
    """
    Readiness: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ReadinessRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ReadinessResponse,
    ]
    """Check if the pipeline server is ready

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
    """
    GetHubStats: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetHubStatsRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse,
    ]
    """Get hub status

    Return the stats of the hub
    """
    ListPipelines: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListPipelinesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse,
    ]
    """List accessible pipelines

    Returns a paginated list of pipelines that are visible to the requester.
    """
    LookUpPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.LookUpPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse,
    ]
    """Get a pipeline by UID

    Returns the details of a pipeline by a permalink defined by the resource
    UID.
    """
    CreateUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse,
    ]
    """Create a new user pipeline

    Creates a new pipeline under the parenthood of a user. Users can only
    create a pipeline as the parent of that resource (i.e. the authenticated
    user must match the `parent` path parameter).
    """
    ListUserPipelines: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelinesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse,
    ]
    """List user pipelines

    Returns a paginated list of pipelines that belong to the specified user.
    The parent user may be different from the authenticated user, in which
    case the results will contain the pipelines that are visible to the
    latter.
    """
    GetUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse,
    ]
    """Get a pipeline owned by a user

    Returns the details of a user-owned pipeline by its resource name, which is defined
    by the parent user and the ID of the pipeline.
    """
    UpdateUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse,
    ]
    """Update a pipeline owned by a user

    Udpates a pipeline, accessing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to modify it.

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse,
    ]
    """Delete a pipeline owned by a user

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to delete it.
    """
    ValidateUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by a user

    Validates a pipeline by its resource name, which is defined by the parent
    user and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its components.
    """
    RenameUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse,
    ]
    """Rename a pipeline owned by a user

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent user and ID of the pipeline (e.g.
    `users/luigi/pipelines/pizza-recipe-generator`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    CloneUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineResponse,
    ]
    """Clone a pipeline owned by a user

    Clones a pipeline owned by a user. The new pipeline may have a different
    parent, and this can be either a user or an organization.
    """
    CloneUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineReleaseResponse,
    ]
    """Clone a pipeline release owned by a user

    Clones a pipeline release owned by a user. The new pipeline may have a different
    parent, and this can be either a user or an organization.
    """
    TriggerUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user

    Triggers the execution of a pipeline synchronously, i.e., the result is
    sent back to the user right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    TriggerUserPipelineWithStream: grpc.UnaryStreamMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse,
    ]
    """Trigger a pipeline owned by a user and stream back the response

    Triggers the execution of a pipeline asynchronously and streams back the response.
    This method is intended for real-time inference when low latency is of concern
    and the response needs to be processed incrementally.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.
    """
    TriggerAsyncUserPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    CreateUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by a user

    Commits the version of a pipeline, identified by its resource name, which
    is formed by the parent user and ID of the pipeline.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    ListUserPipelineReleases: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by a user

    Lists the commited versions of a pipeline, identified by its resource
    name, which is formed by the parent user and ID of the pipeline.
    """
    GetUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by a user

    Gets the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent user and ID.
    """
    UpdateUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by a user

    Updates the details of a pipeline release, where the pipeline is
    identified by its resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    DeleteUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by a user

    Deletes a pipeline release, where the pipeline is identified by its
    resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RestoreUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by a user to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RenameUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by a user

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent user and ID. Since this is an
    output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed
    by the pipeline name and the ID of the release (e.g.
    `users/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    TriggerUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    TriggerAsyncUserPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    CreateOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse,
    ]
    """Create a new organization pipeline

    Creates a new pipeline under the parenthood of an organization.
    """
    ListOrganizationPipelines: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse,
    ]
    """List organization pipelines

    Returns a paginated list of pipelines that belong to the specified
    organization.
    """
    GetOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse,
    ]
    """Get a pipeline owned by an organization

    Returns the details of an organization-owned pipeline by its resource name,
    which is defined by the parent organization and the ID of the pipeline.
    """
    UpdateOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse,
    ]
    """Update a pipeline owned by an organization

    Udpates a pipeline, accessing it by its resource name, which is defined by

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse,
    ]
    """Delete a pipeline owned by an organization

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent organization and the ID of the pipeline.
    """
    ValidateOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by an organization

    Validates a pipeline by its resource name, which is defined by the parent
    organization and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its
    components.
    """
    RenameOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse,
    ]
    """Rename a pipeline owned by an organization

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent organization and ID of the pipeline (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator`).
    """
    CloneOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineResponse,
    ]
    """Clone a pipeline owned by an organization

    Clones a pipeline owned by an organization. The new pipeline may have a
    different parent, and this can be either a user or an organization.
    """
    CloneOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineReleaseResponse,
    ]
    """Clone a pipeline release owned by an organization

    Clones a pipeline release owned by an organization. The new pipeline may
    have a different parent, and this can be either a user or an organization.
    """
    TriggerOrganizationPipelineStream: grpc.UnaryStreamMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    TriggerOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    TriggerAsyncOrganizationPipeline: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    CreateOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by an organization

    Commits the version of a pipeline, identified by its resource name, which is
    formed by the parent organization and ID of the pipeline.
    """
    ListOrganizationPipelineReleases: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by an organization

    Lists the commited versions of a pipeline, identified by its resource name,
    which is formed by the parent organization and ID of the pipeline.
    """
    GetOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by an organization

    Gets the details of a pipeline release, where the pipeline is identified by
    its resource name, formed by its parent organization and ID.
    """
    UpdateOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by an organization

    Updates the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent organization and ID.
    """
    DeleteOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by an organization

    Deletes a pipeline release, where the pipeline is identified by its resource
    name, formed by its parent organization and ID.
    """
    RestoreOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by an organization to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    RenameOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by an organization

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent organization and ID. Since this is
    an output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed by
    the pipeline name and the ID of the release (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).
    """
    TriggerOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    TriggerAsyncOrganizationPipelineRelease: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    GetOperation: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetOperationRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetOperationResponse,
    ]
    """Get the details of a long-running operation

    This method allows requesters to request the status and outcome of
    long-running operations such as asynchronous pipeline triggers.
    """
    ListConnectorDefinitions: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.ListConnectorDefinitionsRequest,
        vdp.pipeline.v1beta.component_definition_pb2.ListConnectorDefinitionsResponse,
    ]
    """List connector definitions

    Returns a paginated list of connector definitions.
    """
    GetConnectorDefinition: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.GetConnectorDefinitionRequest,
        vdp.pipeline.v1beta.component_definition_pb2.GetConnectorDefinitionResponse,
    ]
    """Get connector definition

    Returns the details of a connector definition.
    """
    ListOperatorDefinitions: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.ListOperatorDefinitionsRequest,
        vdp.pipeline.v1beta.component_definition_pb2.ListOperatorDefinitionsResponse,
    ]
    """List operator definitions

    Returns a paginated list of operator definitions.
    """
    ListComponentDefinitions: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsRequest,
        vdp.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse,
    ]
    """List component definitions

    Returns a paginated list of component definitions, regardless their type.
    This offers a single source of truth, with pagination and filter
    capabilities, for the components that might be used in a VDP pipeline.
    """
    GetOperatorDefinition: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.GetOperatorDefinitionRequest,
        vdp.pipeline.v1beta.component_definition_pb2.GetOperatorDefinitionResponse,
    ]
    """Get operator definition

    Returns the details of an operator definition.
    """
    CheckName: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.common_pb2.CheckNameRequest,
        vdp.pipeline.v1beta.common_pb2.CheckNameResponse,
    ]
    """Check the availibity of a resource name

    Check whether a resource name is already in use. Currently this endpoint
    only supports pipeline and connector resource names.
    """
    CreateUserSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.CreateUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.CreateUserSecretResponse,
    ]
    """Create a new user secret

    Creates a new secret under the parenthood of an user.
    """
    ListUserSecrets: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.ListUserSecretsRequest,
        vdp.pipeline.v1beta.secret_pb2.ListUserSecretsResponse,
    ]
    """List user secrets

    Returns a paginated list of secrets that belong to the specified
    user.
    """
    GetUserSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.GetUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.GetUserSecretResponse,
    ]
    """Get a secret owned by an user

    Returns the details of an user-owned secret by its resource name,
    which is defined by the parent user and the ID of the secret.
    """
    UpdateUserSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.UpdateUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse,
    ]
    """Update a secret owned by an user

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteUserSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.DeleteUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse,
    ]
    """Delete a secret owned by an user

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent user and the ID of the secret.
    """
    CreateOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.CreateOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse,
    ]
    """Create a new organization secret

    Creates a new secret under the parenthood of an organization.
    """
    ListOrganizationSecrets: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.ListOrganizationSecretsRequest,
        vdp.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse,
    ]
    """List organization secrets

    Returns a paginated list of secrets that belong to the specified
    organization.
    """
    GetOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.GetOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse,
    ]
    """Get a secret owned by an organization

    Returns the details of an organization-owned secret by its resource name,
    which is defined by the parent organization and the ID of the secret.
    """
    UpdateOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse,
    ]
    """Update a secret owned by an organization

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationSecret: grpc.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse,
    ]
    """Delete a secret owned by an organization

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent organization and the ID of the secret.
    """

class PipelinePublicServiceAsyncStub:
    """VDP

    PipelinePublicService exposes the public VDP endpoints that allow clients to
    manage pipelines.
    """

    Liveness: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.LivenessRequest,
        vdp.pipeline.v1beta.pipeline_pb2.LivenessResponse,
    ]
    """Check if the pipeline server is alive

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
    """
    Readiness: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ReadinessRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ReadinessResponse,
    ]
    """Check if the pipeline server is ready

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
    """
    GetHubStats: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetHubStatsRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse,
    ]
    """Get hub status

    Return the stats of the hub
    """
    ListPipelines: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListPipelinesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse,
    ]
    """List accessible pipelines

    Returns a paginated list of pipelines that are visible to the requester.
    """
    LookUpPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.LookUpPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse,
    ]
    """Get a pipeline by UID

    Returns the details of a pipeline by a permalink defined by the resource
    UID.
    """
    CreateUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse,
    ]
    """Create a new user pipeline

    Creates a new pipeline under the parenthood of a user. Users can only
    create a pipeline as the parent of that resource (i.e. the authenticated
    user must match the `parent` path parameter).
    """
    ListUserPipelines: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelinesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse,
    ]
    """List user pipelines

    Returns a paginated list of pipelines that belong to the specified user.
    The parent user may be different from the authenticated user, in which
    case the results will contain the pipelines that are visible to the
    latter.
    """
    GetUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse,
    ]
    """Get a pipeline owned by a user

    Returns the details of a user-owned pipeline by its resource name, which is defined
    by the parent user and the ID of the pipeline.
    """
    UpdateUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse,
    ]
    """Update a pipeline owned by a user

    Udpates a pipeline, accessing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to modify it.

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse,
    ]
    """Delete a pipeline owned by a user

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent user and the ID of the pipeline. The authenticated user must be
    the parent of the pipeline in order to delete it.
    """
    ValidateUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by a user

    Validates a pipeline by its resource name, which is defined by the parent
    user and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its components.
    """
    RenameUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse,
    ]
    """Rename a pipeline owned by a user

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent user and ID of the pipeline (e.g.
    `users/luigi/pipelines/pizza-recipe-generator`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    CloneUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineResponse,
    ]
    """Clone a pipeline owned by a user

    Clones a pipeline owned by a user. The new pipeline may have a different
    parent, and this can be either a user or an organization.
    """
    CloneUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineReleaseResponse,
    ]
    """Clone a pipeline release owned by a user

    Clones a pipeline release owned by a user. The new pipeline may have a different
    parent, and this can be either a user or an organization.
    """
    TriggerUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user

    Triggers the execution of a pipeline synchronously, i.e., the result is
    sent back to the user right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    TriggerUserPipelineWithStream: grpc.aio.UnaryStreamMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse,
    ]
    """Trigger a pipeline owned by a user and stream back the response

    Triggers the execution of a pipeline asynchronously and streams back the response.
    This method is intended for real-time inference when low latency is of concern
    and the response needs to be processed incrementally.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.
    """
    TriggerAsyncUserPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse,
    ]
    """Trigger a pipeline owned by a user asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent user
    and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    CreateUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by a user

    Commits the version of a pipeline, identified by its resource name, which
    is formed by the parent user and ID of the pipeline.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    ListUserPipelineReleases: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by a user

    Lists the commited versions of a pipeline, identified by its resource
    name, which is formed by the parent user and ID of the pipeline.
    """
    GetUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by a user

    Gets the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent user and ID.
    """
    UpdateUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by a user

    Updates the details of a pipeline release, where the pipeline is
    identified by its resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    DeleteUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by a user

    Deletes a pipeline release, where the pipeline is identified by its
    resource name, formed by its parent user and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RestoreUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by a user to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    RenameUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by a user

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent user and ID. Since this is an
    output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed
    by the pipeline name and the ID of the release (e.g.
    `users/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).

    The authenticated user must be the parent of the pipeline in order to
    perform this action.
    """
    TriggerUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    TriggerAsyncUserPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by a user asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent user
    and ID.
    """
    CreateOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse,
    ]
    """Create a new organization pipeline

    Creates a new pipeline under the parenthood of an organization.
    """
    ListOrganizationPipelines: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse,
    ]
    """List organization pipelines

    Returns a paginated list of pipelines that belong to the specified
    organization.
    """
    GetOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse,
    ]
    """Get a pipeline owned by an organization

    Returns the details of an organization-owned pipeline by its resource name,
    which is defined by the parent organization and the ID of the pipeline.
    """
    UpdateOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse,
    ]
    """Update a pipeline owned by an organization

    Udpates a pipeline, accessing it by its resource name, which is defined by

    In REST requests, only the supplied pipeline fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse,
    ]
    """Delete a pipeline owned by an organization

    Deletes a pipeline, accesing it by its resource name, which is defined by
    the parent organization and the ID of the pipeline.
    """
    ValidateOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse,
    ]
    """Validate a pipeline a pipeline owned by an organization

    Validates a pipeline by its resource name, which is defined by the parent
    organization and the ID of the pipeline.

    Validation checks the recipe of the pipeline and the status of its
    components.
    """
    RenameOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse,
    ]
    """Rename a pipeline owned by an organization

    Updates the ID of a pipeline. Since this is an output-only field, a custom
    method is required to modify it.

    The pipeline name will be updated accordingly, as it is  composed by the
    parent organization and ID of the pipeline (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator`).
    """
    CloneOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineResponse,
    ]
    """Clone a pipeline owned by an organization

    Clones a pipeline owned by an organization. The new pipeline may have a
    different parent, and this can be either a user or an organization.
    """
    CloneOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineReleaseResponse,
    ]
    """Clone a pipeline release owned by an organization

    Clones a pipeline release owned by an organization. The new pipeline may
    have a different parent, and this can be either a user or an organization.
    """
    TriggerOrganizationPipelineStream: grpc.aio.UnaryStreamMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    TriggerOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization

    Triggers the execution of a pipeline synchronously, i.e., the result is sent
    back to the organization right after the data is processed. This method is
    intended for real-time inference when low latency is of concern.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    TriggerAsyncOrganizationPipeline: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse,
    ]
    """Trigger a pipeline owned by an organization asynchronously

    Triggers the execution of a pipeline asynchronously, i.e., the result
    contains the necessary information to access the result and status of the
    operation. This method is intended for cases that require long-running
    workloads.

    The pipeline is identified by its resource name, formed by the parent
    organization and ID of the pipeline.

    For more information, see [Trigger
    Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
    """
    CreateOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse,
    ]
    """Release a version of a pipeline owned by an organization

    Commits the version of a pipeline, identified by its resource name, which is
    formed by the parent organization and ID of the pipeline.
    """
    ListOrganizationPipelineReleases: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesRequest,
        vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse,
    ]
    """List the releases in a pipeline owned by an organization

    Lists the commited versions of a pipeline, identified by its resource name,
    which is formed by the parent organization and ID of the pipeline.
    """
    GetOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse,
    ]
    """Get a release in a pipeline owned by an organization

    Gets the details of a pipeline release, where the pipeline is identified by
    its resource name, formed by its parent organization and ID.
    """
    UpdateOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse,
    ]
    """Update a release in a pipeline owned by an organization

    Updates the details of a pipeline release, where the pipeline is identified
    by its resource name, formed by its parent organization and ID.
    """
    DeleteOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse,
    ]
    """Delete a release in a pipeline owned by an organization

    Deletes a pipeline release, where the pipeline is identified by its resource
    name, formed by its parent organization and ID.
    """
    RestoreOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse,
    ]
    """Set the version of a pipeline owned by an organization to a pinned release

    Sets the pipeline configuration to a pinned version defined by a release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    RenameOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse,
    ]
    """Rename a release in a pipeline owned by an organization

    Updates the ID of a pipeline release, where the pipeline is identified by
    its resource name, formed by the parent organization and ID. Since this is
    an output-only field, a custom method is required to modify it.

    The pipeline release name will be updated accordingly, as it is  composed by
    the pipeline name and the ID of the release (e.g.
    `organizations/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).
    """
    TriggerOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization

    Triggers the synchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    TriggerAsyncOrganizationPipelineRelease: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseRequest,
        vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse,
    ]
    """Trigger a version of a pipeline owned by an organization asynchronously

    Triggers the asynchronous execution of of a pipeline. While the trigger
    endpoint (where the release version isn't specified) triggers the pipeline
    at its latest release, this method allows the client to specified any
    committed release.

    The pipeline is identified by its resource name, formed by its parent
    organization and ID.
    """
    GetOperation: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.pipeline_pb2.GetOperationRequest,
        vdp.pipeline.v1beta.pipeline_pb2.GetOperationResponse,
    ]
    """Get the details of a long-running operation

    This method allows requesters to request the status and outcome of
    long-running operations such as asynchronous pipeline triggers.
    """
    ListConnectorDefinitions: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.ListConnectorDefinitionsRequest,
        vdp.pipeline.v1beta.component_definition_pb2.ListConnectorDefinitionsResponse,
    ]
    """List connector definitions

    Returns a paginated list of connector definitions.
    """
    GetConnectorDefinition: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.GetConnectorDefinitionRequest,
        vdp.pipeline.v1beta.component_definition_pb2.GetConnectorDefinitionResponse,
    ]
    """Get connector definition

    Returns the details of a connector definition.
    """
    ListOperatorDefinitions: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.ListOperatorDefinitionsRequest,
        vdp.pipeline.v1beta.component_definition_pb2.ListOperatorDefinitionsResponse,
    ]
    """List operator definitions

    Returns a paginated list of operator definitions.
    """
    ListComponentDefinitions: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsRequest,
        vdp.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse,
    ]
    """List component definitions

    Returns a paginated list of component definitions, regardless their type.
    This offers a single source of truth, with pagination and filter
    capabilities, for the components that might be used in a VDP pipeline.
    """
    GetOperatorDefinition: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.component_definition_pb2.GetOperatorDefinitionRequest,
        vdp.pipeline.v1beta.component_definition_pb2.GetOperatorDefinitionResponse,
    ]
    """Get operator definition

    Returns the details of an operator definition.
    """
    CheckName: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.common_pb2.CheckNameRequest,
        vdp.pipeline.v1beta.common_pb2.CheckNameResponse,
    ]
    """Check the availibity of a resource name

    Check whether a resource name is already in use. Currently this endpoint
    only supports pipeline and connector resource names.
    """
    CreateUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.CreateUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.CreateUserSecretResponse,
    ]
    """Create a new user secret

    Creates a new secret under the parenthood of an user.
    """
    ListUserSecrets: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.ListUserSecretsRequest,
        vdp.pipeline.v1beta.secret_pb2.ListUserSecretsResponse,
    ]
    """List user secrets

    Returns a paginated list of secrets that belong to the specified
    user.
    """
    GetUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.GetUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.GetUserSecretResponse,
    ]
    """Get a secret owned by an user

    Returns the details of an user-owned secret by its resource name,
    which is defined by the parent user and the ID of the secret.
    """
    UpdateUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.UpdateUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse,
    ]
    """Update a secret owned by an user

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteUserSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.DeleteUserSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse,
    ]
    """Delete a secret owned by an user

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent user and the ID of the secret.
    """
    CreateOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.CreateOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse,
    ]
    """Create a new organization secret

    Creates a new secret under the parenthood of an organization.
    """
    ListOrganizationSecrets: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.ListOrganizationSecretsRequest,
        vdp.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse,
    ]
    """List organization secrets

    Returns a paginated list of secrets that belong to the specified
    organization.
    """
    GetOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.GetOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse,
    ]
    """Get a secret owned by an organization

    Returns the details of an organization-owned secret by its resource name,
    which is defined by the parent organization and the ID of the secret.
    """
    UpdateOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse,
    ]
    """Update a secret owned by an organization

    Udpates a secret, accessing it by its resource name, which is defined by

    In REST requests, only the supplied secret fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationSecret: grpc.aio.UnaryUnaryMultiCallable[
        vdp.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretRequest,
        vdp.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse,
    ]
    """Delete a secret owned by an organization

    Deletes a secret, accesing it by its resource name, which is defined by
    the parent organization and the ID of the secret.
    """

class PipelinePublicServiceServicer(metaclass=abc.ABCMeta):
    """VDP

    PipelinePublicService exposes the public VDP endpoints that allow clients to
    manage pipelines.
    """

    @abc.abstractmethod
    def Liveness(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.LivenessRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.LivenessResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.LivenessResponse]]:
        """Check if the pipeline server is alive

        See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
        """
    @abc.abstractmethod
    def Readiness(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ReadinessRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ReadinessResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ReadinessResponse]]:
        """Check if the pipeline server is ready

        See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
        """
    @abc.abstractmethod
    def GetHubStats(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.GetHubStatsRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.GetHubStatsResponse]]:
        """Get hub status

        Return the stats of the hub
        """
    @abc.abstractmethod
    def ListPipelines(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ListPipelinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ListPipelinesResponse]]:
        """List accessible pipelines

        Returns a paginated list of pipelines that are visible to the requester.
        """
    @abc.abstractmethod
    def LookUpPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.LookUpPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.LookUpPipelineResponse]]:
        """Get a pipeline by UID

        Returns the details of a pipeline by a permalink defined by the resource
        UID.
        """
    @abc.abstractmethod
    def CreateUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineResponse]]:
        """Create a new user pipeline

        Creates a new pipeline under the parenthood of a user. Users can only
        create a pipeline as the parent of that resource (i.e. the authenticated
        user must match the `parent` path parameter).
        """
    @abc.abstractmethod
    def ListUserPipelines(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelinesResponse]]:
        """List user pipelines

        Returns a paginated list of pipelines that belong to the specified user.
        The parent user may be different from the authenticated user, in which
        case the results will contain the pipelines that are visible to the
        latter.
        """
    @abc.abstractmethod
    def GetUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineResponse]]:
        """Get a pipeline owned by a user

        Returns the details of a user-owned pipeline by its resource name, which is defined
        by the parent user and the ID of the pipeline.
        """
    @abc.abstractmethod
    def UpdateUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineResponse]]:
        """Update a pipeline owned by a user

        Udpates a pipeline, accessing it by its resource name, which is defined by
        the parent user and the ID of the pipeline. The authenticated user must be
        the parent of the pipeline in order to modify it.

        In REST requests, only the supplied pipeline fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineResponse]]:
        """Delete a pipeline owned by a user

        Deletes a pipeline, accesing it by its resource name, which is defined by
        the parent user and the ID of the pipeline. The authenticated user must be
        the parent of the pipeline in order to delete it.
        """
    @abc.abstractmethod
    def ValidateUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ValidateUserPipelineResponse]]:
        """Validate a pipeline a pipeline owned by a user

        Validates a pipeline by its resource name, which is defined by the parent
        user and the ID of the pipeline.

        Validation checks the recipe of the pipeline and the status of its components.
        """
    @abc.abstractmethod
    def RenameUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineResponse]]:
        """Rename a pipeline owned by a user

        Updates the ID of a pipeline. Since this is an output-only field, a custom
        method is required to modify it.

        The pipeline name will be updated accordingly, as it is  composed by the
        parent user and ID of the pipeline (e.g.
        `users/luigi/pipelines/pizza-recipe-generator`).

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def CloneUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineResponse]]:
        """Clone a pipeline owned by a user

        Clones a pipeline owned by a user. The new pipeline may have a different
        parent, and this can be either a user or an organization.
        """
    @abc.abstractmethod
    def CloneUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CloneUserPipelineReleaseResponse]]:
        """Clone a pipeline release owned by a user

        Clones a pipeline release owned by a user. The new pipeline may have a different
        parent, and this can be either a user or an organization.
        """
    @abc.abstractmethod
    def TriggerUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineResponse]]:
        """Trigger a pipeline owned by a user

        Triggers the execution of a pipeline synchronously, i.e., the result is
        sent back to the user right after the data is processed. This method is
        intended for real-time inference when low latency is of concern.

        The pipeline is identified by its resource name, formed by the parent user
        and ID of the pipeline.

        For more information, see [Trigger
        Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
        """
    @abc.abstractmethod
    def TriggerUserPipelineWithStream(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse], collections.abc.AsyncIterator[vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineWithStreamResponse]]:
        """Trigger a pipeline owned by a user and stream back the response

        Triggers the execution of a pipeline asynchronously and streams back the response.
        This method is intended for real-time inference when low latency is of concern
        and the response needs to be processed incrementally.

        The pipeline is identified by its resource name, formed by the parent user
        and ID of the pipeline.
        """
    @abc.abstractmethod
    def TriggerAsyncUserPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineResponse]]:
        """Trigger a pipeline owned by a user asynchronously

        Triggers the execution of a pipeline asynchronously, i.e., the result
        contains the necessary information to access the result and status of the
        operation. This method is intended for cases that require long-running
        workloads.

        The pipeline is identified by its resource name, formed by the parent user
        and ID of the pipeline.

        For more information, see [Trigger
        Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
        """
    @abc.abstractmethod
    def CreateUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CreateUserPipelineReleaseResponse]]:
        """Release a version of a pipeline owned by a user

        Commits the version of a pipeline, identified by its resource name, which
        is formed by the parent user and ID of the pipeline.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def ListUserPipelineReleases(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ListUserPipelineReleasesResponse]]:
        """List the releases in a pipeline owned by a user

        Lists the commited versions of a pipeline, identified by its resource
        name, which is formed by the parent user and ID of the pipeline.
        """
    @abc.abstractmethod
    def GetUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.GetUserPipelineReleaseResponse]]:
        """Get a release in a pipeline owned by a user

        Gets the details of a pipeline release, where the pipeline is identified
        by its resource name, formed by its parent user and ID.
        """
    @abc.abstractmethod
    def UpdateUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.UpdateUserPipelineReleaseResponse]]:
        """Update a release in a pipeline owned by a user

        Updates the details of a pipeline release, where the pipeline is
        identified by its resource name, formed by its parent user and ID.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def DeleteUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.DeleteUserPipelineReleaseResponse]]:
        """Delete a release in a pipeline owned by a user

        Deletes a pipeline release, where the pipeline is identified by its
        resource name, formed by its parent user and ID.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def RestoreUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.RestoreUserPipelineReleaseResponse]]:
        """Set the version of a pipeline owned by a user to a pinned release

        Sets the pipeline configuration to a pinned version defined by a release.

        The pipeline is identified by its resource name, formed by its parent user
        and ID.

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def RenameUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.RenameUserPipelineReleaseResponse]]:
        """Rename a release in a pipeline owned by a user

        Updates the ID of a pipeline release, where the pipeline is identified by
        its resource name, formed by the parent user and ID. Since this is an
        output-only field, a custom method is required to modify it.

        The pipeline release name will be updated accordingly, as it is  composed
        by the pipeline name and the ID of the release (e.g.
        `users/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).

        The authenticated user must be the parent of the pipeline in order to
        perform this action.
        """
    @abc.abstractmethod
    def TriggerUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerUserPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by a user

        Triggers the synchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent user
        and ID.
        """
    @abc.abstractmethod
    def TriggerAsyncUserPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncUserPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by a user asynchronously

        Triggers the asynchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent user
        and ID.
        """
    @abc.abstractmethod
    def CreateOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineResponse]]:
        """Create a new organization pipeline

        Creates a new pipeline under the parenthood of an organization.
        """
    @abc.abstractmethod
    def ListOrganizationPipelines(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelinesResponse]]:
        """List organization pipelines

        Returns a paginated list of pipelines that belong to the specified
        organization.
        """
    @abc.abstractmethod
    def GetOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineResponse]]:
        """Get a pipeline owned by an organization

        Returns the details of an organization-owned pipeline by its resource name,
        which is defined by the parent organization and the ID of the pipeline.
        """
    @abc.abstractmethod
    def UpdateOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineResponse]]:
        """Update a pipeline owned by an organization

        Udpates a pipeline, accessing it by its resource name, which is defined by

        In REST requests, only the supplied pipeline fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineResponse]]:
        """Delete a pipeline owned by an organization

        Deletes a pipeline, accesing it by its resource name, which is defined by
        the parent organization and the ID of the pipeline.
        """
    @abc.abstractmethod
    def ValidateOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ValidateOrganizationPipelineResponse]]:
        """Validate a pipeline a pipeline owned by an organization

        Validates a pipeline by its resource name, which is defined by the parent
        organization and the ID of the pipeline.

        Validation checks the recipe of the pipeline and the status of its
        components.
        """
    @abc.abstractmethod
    def RenameOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineResponse]]:
        """Rename a pipeline owned by an organization

        Updates the ID of a pipeline. Since this is an output-only field, a custom
        method is required to modify it.

        The pipeline name will be updated accordingly, as it is  composed by the
        parent organization and ID of the pipeline (e.g.
        `organizations/luigi/pipelines/pizza-recipe-generator`).
        """
    @abc.abstractmethod
    def CloneOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineResponse]]:
        """Clone a pipeline owned by an organization

        Clones a pipeline owned by an organization. The new pipeline may have a
        different parent, and this can be either a user or an organization.
        """
    @abc.abstractmethod
    def CloneOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CloneOrganizationPipelineReleaseResponse]]:
        """Clone a pipeline release owned by an organization

        Clones a pipeline release owned by an organization. The new pipeline may
        have a different parent, and this can be either a user or an organization.
        """
    @abc.abstractmethod
    def TriggerOrganizationPipelineStream(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse], collections.abc.AsyncIterator[vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineStreamResponse]]:
        """Trigger a pipeline owned by an organization

        Triggers the execution of a pipeline synchronously, i.e., the result is sent
        back to the organization right after the data is processed. This method is
        intended for real-time inference when low latency is of concern.

        The pipeline is identified by its resource name, formed by the parent
        organization and ID of the pipeline.

        For more information, see [Trigger
        Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
        """
    @abc.abstractmethod
    def TriggerOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineResponse]]:
        """Trigger a pipeline owned by an organization

        Triggers the execution of a pipeline synchronously, i.e., the result is sent
        back to the organization right after the data is processed. This method is
        intended for real-time inference when low latency is of concern.

        The pipeline is identified by its resource name, formed by the parent
        organization and ID of the pipeline.

        For more information, see [Trigger
        Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
        """
    @abc.abstractmethod
    def TriggerAsyncOrganizationPipeline(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineResponse]]:
        """Trigger a pipeline owned by an organization asynchronously

        Triggers the execution of a pipeline asynchronously, i.e., the result
        contains the necessary information to access the result and status of the
        operation. This method is intended for cases that require long-running
        workloads.

        The pipeline is identified by its resource name, formed by the parent
        organization and ID of the pipeline.

        For more information, see [Trigger
        Pipeline](https://www.instill.tech/docs/latest/core/concepts/pipeline#trigger-pipeline).
        """
    @abc.abstractmethod
    def CreateOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.CreateOrganizationPipelineReleaseResponse]]:
        """Release a version of a pipeline owned by an organization

        Commits the version of a pipeline, identified by its resource name, which is
        formed by the parent organization and ID of the pipeline.
        """
    @abc.abstractmethod
    def ListOrganizationPipelineReleases(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.ListOrganizationPipelineReleasesResponse]]:
        """List the releases in a pipeline owned by an organization

        Lists the commited versions of a pipeline, identified by its resource name,
        which is formed by the parent organization and ID of the pipeline.
        """
    @abc.abstractmethod
    def GetOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.GetOrganizationPipelineReleaseResponse]]:
        """Get a release in a pipeline owned by an organization

        Gets the details of a pipeline release, where the pipeline is identified by
        its resource name, formed by its parent organization and ID.
        """
    @abc.abstractmethod
    def UpdateOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.UpdateOrganizationPipelineReleaseResponse]]:
        """Update a release in a pipeline owned by an organization

        Updates the details of a pipeline release, where the pipeline is identified
        by its resource name, formed by its parent organization and ID.
        """
    @abc.abstractmethod
    def DeleteOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.DeleteOrganizationPipelineReleaseResponse]]:
        """Delete a release in a pipeline owned by an organization

        Deletes a pipeline release, where the pipeline is identified by its resource
        name, formed by its parent organization and ID.
        """
    @abc.abstractmethod
    def RestoreOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.RestoreOrganizationPipelineReleaseResponse]]:
        """Set the version of a pipeline owned by an organization to a pinned release

        Sets the pipeline configuration to a pinned version defined by a release.

        The pipeline is identified by its resource name, formed by its parent
        organization and ID.
        """
    @abc.abstractmethod
    def RenameOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.RenameOrganizationPipelineReleaseResponse]]:
        """Rename a release in a pipeline owned by an organization

        Updates the ID of a pipeline release, where the pipeline is identified by
        its resource name, formed by the parent organization and ID. Since this is
        an output-only field, a custom method is required to modify it.

        The pipeline release name will be updated accordingly, as it is  composed by
        the pipeline name and the ID of the release (e.g.
        `organizations/luigi/pipelines/pizza-recipe-generator/releases/v0.2.1`).
        """
    @abc.abstractmethod
    def TriggerOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerOrganizationPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by an organization

        Triggers the synchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent
        organization and ID.
        """
    @abc.abstractmethod
    def TriggerAsyncOrganizationPipelineRelease(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.TriggerAsyncOrganizationPipelineReleaseResponse]]:
        """Trigger a version of a pipeline owned by an organization asynchronously

        Triggers the asynchronous execution of of a pipeline. While the trigger
        endpoint (where the release version isn't specified) triggers the pipeline
        at its latest release, this method allows the client to specified any
        committed release.

        The pipeline is identified by its resource name, formed by its parent
        organization and ID.
        """
    @abc.abstractmethod
    def GetOperation(
        self,
        request: vdp.pipeline.v1beta.pipeline_pb2.GetOperationRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.pipeline_pb2.GetOperationResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.pipeline_pb2.GetOperationResponse]]:
        """Get the details of a long-running operation

        This method allows requesters to request the status and outcome of
        long-running operations such as asynchronous pipeline triggers.
        """
    @abc.abstractmethod
    def ListConnectorDefinitions(
        self,
        request: vdp.pipeline.v1beta.component_definition_pb2.ListConnectorDefinitionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.component_definition_pb2.ListConnectorDefinitionsResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.component_definition_pb2.ListConnectorDefinitionsResponse]]:
        """List connector definitions

        Returns a paginated list of connector definitions.
        """
    @abc.abstractmethod
    def GetConnectorDefinition(
        self,
        request: vdp.pipeline.v1beta.component_definition_pb2.GetConnectorDefinitionRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.component_definition_pb2.GetConnectorDefinitionResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.component_definition_pb2.GetConnectorDefinitionResponse]]:
        """Get connector definition

        Returns the details of a connector definition.
        """
    @abc.abstractmethod
    def ListOperatorDefinitions(
        self,
        request: vdp.pipeline.v1beta.component_definition_pb2.ListOperatorDefinitionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.component_definition_pb2.ListOperatorDefinitionsResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.component_definition_pb2.ListOperatorDefinitionsResponse]]:
        """List operator definitions

        Returns a paginated list of operator definitions.
        """
    @abc.abstractmethod
    def ListComponentDefinitions(
        self,
        request: vdp.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.component_definition_pb2.ListComponentDefinitionsResponse]]:
        """List component definitions

        Returns a paginated list of component definitions, regardless their type.
        This offers a single source of truth, with pagination and filter
        capabilities, for the components that might be used in a VDP pipeline.
        """
    @abc.abstractmethod
    def GetOperatorDefinition(
        self,
        request: vdp.pipeline.v1beta.component_definition_pb2.GetOperatorDefinitionRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.component_definition_pb2.GetOperatorDefinitionResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.component_definition_pb2.GetOperatorDefinitionResponse]]:
        """Get operator definition

        Returns the details of an operator definition.
        """
    @abc.abstractmethod
    def CheckName(
        self,
        request: vdp.pipeline.v1beta.common_pb2.CheckNameRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.common_pb2.CheckNameResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.common_pb2.CheckNameResponse]]:
        """Check the availibity of a resource name

        Check whether a resource name is already in use. Currently this endpoint
        only supports pipeline and connector resource names.
        """
    @abc.abstractmethod
    def CreateUserSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.CreateUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.CreateUserSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.CreateUserSecretResponse]]:
        """Create a new user secret

        Creates a new secret under the parenthood of an user.
        """
    @abc.abstractmethod
    def ListUserSecrets(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.ListUserSecretsRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.ListUserSecretsResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.ListUserSecretsResponse]]:
        """List user secrets

        Returns a paginated list of secrets that belong to the specified
        user.
        """
    @abc.abstractmethod
    def GetUserSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.GetUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.GetUserSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.GetUserSecretResponse]]:
        """Get a secret owned by an user

        Returns the details of an user-owned secret by its resource name,
        which is defined by the parent user and the ID of the secret.
        """
    @abc.abstractmethod
    def UpdateUserSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.UpdateUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.UpdateUserSecretResponse]]:
        """Update a secret owned by an user

        Udpates a secret, accessing it by its resource name, which is defined by

        In REST requests, only the supplied secret fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteUserSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.DeleteUserSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.DeleteUserSecretResponse]]:
        """Delete a secret owned by an user

        Deletes a secret, accesing it by its resource name, which is defined by
        the parent user and the ID of the secret.
        """
    @abc.abstractmethod
    def CreateOrganizationSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.CreateOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.CreateOrganizationSecretResponse]]:
        """Create a new organization secret

        Creates a new secret under the parenthood of an organization.
        """
    @abc.abstractmethod
    def ListOrganizationSecrets(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.ListOrganizationSecretsRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.ListOrganizationSecretsResponse]]:
        """List organization secrets

        Returns a paginated list of secrets that belong to the specified
        organization.
        """
    @abc.abstractmethod
    def GetOrganizationSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.GetOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.GetOrganizationSecretResponse]]:
        """Get a secret owned by an organization

        Returns the details of an organization-owned secret by its resource name,
        which is defined by the parent organization and the ID of the secret.
        """
    @abc.abstractmethod
    def UpdateOrganizationSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.UpdateOrganizationSecretResponse]]:
        """Update a secret owned by an organization

        Udpates a secret, accessing it by its resource name, which is defined by

        In REST requests, only the supplied secret fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteOrganizationSecret(
        self,
        request: vdp.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretRequest,
        context: _ServicerContext,
    ) -> typing.Union[vdp.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse, collections.abc.Awaitable[vdp.pipeline.v1beta.secret_pb2.DeleteOrganizationSecretResponse]]:
        """Delete a secret owned by an organization

        Deletes a secret, accesing it by its resource name, which is defined by
        the parent organization and the ID of the secret.
        """

def add_PipelinePublicServiceServicer_to_server(servicer: PipelinePublicServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
