# generated by datamodel-codegen:
#   filename:  openapi.yml
#   timestamp: 2024-09-25T17:15:02+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Field, RootModel, constr


class City(RootModel[str]):
    root: str = Field(..., description="Angabe des Ortes der Marktlokationsadresse", examples=["Berlin"])


class Company(RootModel[str]):
    root: str = Field(..., description="Angabe des Firmennamen", examples=["BDEW & Co. KG"])


class CountryCode(RootModel[constr(pattern=r"[A-Z]{2}")]):
    root: constr(pattern=r"[A-Z]{2}") = Field(
        ..., description="Angabe des Ländercodes nach ISO-3166-1 Alpha-2", examples=["DE"]
    )


class CustomerNumber(RootModel[str]):
    root: str = Field(
        ...,
        description="Zur Angabe der Kundennummer des Kunden beim bisherigen Lieferanten (LFA)",
        examples=["V567345345"],
    )


class CreationDateTime(
    RootModel[
        constr(
            pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\d(\.[\d]{1,4})?Z"
        )
    ]
):
    root: constr(
        pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\d(\.[\d]{1,4})?Z"
    ) = Field(..., description="Zeitpunkt an dem der Aufruf erstellt wurde", examples=["2023-08-01T12:30:00.1704Z"])


class DistrictName(RootModel[str]):
    root: str = Field(..., description="Angabe des Gemarkungsnamens (des Flurstücks) der Marktlokationsadresse")


class East(RootModel[str]):
    root: str = Field(
        ...,
        description="Angabe des UTM Ostwert nach WGS84. Umgerechneter Wert muss Min/Max für Länge/Breite entsprechen",
    )


class Easting(RootModel[str]):
    root: str = Field(
        ..., description="Gauß-Krüger Rechtswert. Umgerechneter Wert muss Min/Max für Länge/Breite entsprechen."
    )


class EnergyDirection(Enum):
    consumption = "consumption"
    production = "production"


class ExecutionTimeFrom(
    RootModel[
        constr(
            pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\dZ"
        )
    ]
):
    root: constr(
        pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\dZ"
    ) = Field(
        ...,
        description="Beginnzeitpunkt, Zeitpunkt zu dem die zugeordneten Marktpartner oder Lokationen zugeordnet werden. Dieser Zeitpunkt muss ein Tagesbeginn 00:00 Uhr gesetzlicher deutscher Zeit sein.",
        examples=["2023-08-01T22:00:00Z"],
    )


class ExecutionTimeUntil(
    RootModel[
        constr(
            pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\dZ"
        )
    ]
):
    root: constr(
        pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\dZ"
    ) = Field(
        ...,
        description="Endezeitpunkt, Zeitpunkt bis zu dem die zugeordneten Marktpartner oder Lokationen zugeordnet werden. Dieser Zeitpunkt muss ein Tagesbeginn 00:00 Uhr gesetzlicher deutscher Zeit sein.",
        examples=["2023-08-01T22:00:00Z"],
    )


class Reason(RootModel[str]):
    root: str = Field(
        ...,
        description="Angabe der weiteren Erläuterung zum in responseCode genannten Antwortgrundes sofern dies gemäß dem in decisionTree genannten Entscheidungsbaums zulässig ist.",
        examples=["Ich bin ein Freitext."],
    )


class Firstnames(RootModel[str]):
    root: str = Field(..., description="Angabe des Vornamen des Kunden", examples=["Michael"])


class HouseNumber(RootModel[int]):
    root: int = Field(..., description="Angabe der Hausnummer der Marktlokationsadresse", examples=[32])


class HouseNumberAddition(RootModel[str]):
    root: str = Field(..., description="Angabe der Hausnummernergänzung der Marktlokationsadresse", examples=["F"])


class IdentificationDateTime(
    RootModel[
        constr(
            pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\dZ"
        )
    ]
):
    root: constr(
        pattern=r"20(\d{2}(\-(0[13578]|1[02])\-(0[1-9]|[12]\d|3[01])|\-02\-(0[1-9]|1\d|2[0-8])|\-(0[469]|11)\-(0[1-9]|[12]\d|30))|([02468][048]|[13579][26])\-02\-(29))T([01]\d|2[0-3]):[0-5]\d:[0-5]\dZ"
    ) = Field(
        ...,
        description="Zeitpunkt zu dem die Identifikation stattfinden soll. Dieser Zeitpunkt muss ein Tagesbeginn 00:00 Uhr gesetzlicher deutscher Zeit sein.",
        examples=["2023-08-02T22:00:00Z"],
    )


class InitialTransactionId(RootModel[str]):
    root: str = Field(
        ...,
        description="Zur Angabe des Idempodenzschlüssel im Falle eines Retry.",
        examples=["f81d4fae-7dec-11d0-a765-00a0c91e6bf6"],
    )


class LotNumber(RootModel[str]):
    root: str = Field(..., description="Angabe der Flurnummer (des Flurstücks) der Marktlokationsadresse")


class Latitude(RootModel[str]):
    root: str = Field(..., description="Angabe der Breite (Breitengrad) nach WGS84. 46 <= X <= 59. °N")


class Longitude(RootModel[str]):
    root: str = Field(..., description="Angabe der Länge (Längengrad) nach WGS84. 4 <= X <= 18. °O")


class MaloId(RootModel[constr(pattern=r"\d{11}")]):
    root: constr(pattern=r"\d{11}") = Field(
        ..., description="Identifiziert die Marktlokation mittels einer eindeutigen ID", examples=["57685676748"]
    )


class MarketLocationDateTime(BaseModel):
    maloId: MaloId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class MarketLocationDateTimes(RootModel[List[MarketLocationDateTime]]):
    root: List[MarketLocationDateTime]


class MarketLocationProperty(Enum):
    customerFacility = "customerFacility"
    nonActive = "nonActive"
    standard = "standard"


class MarketPartnerId(RootModel[int]):
    root: int = Field(..., description="Identifiziert den Marktpartner (Marktpartner-ID)", examples=[9900987654321])


class MeasurementTechnologyClassification(Enum):
    intelligentMeasuringSystem = "intelligentMeasuringSystem"
    conventionalMeasuringSystem = "conventionalMeasuringSystem"
    noMeasurement = "noMeasurement"


class MeloId(RootModel[constr(pattern=r"DE\d{11}[A-Z,\d]{20}")]):
    root: constr(pattern=r"DE\d{11}[A-Z,\d]{20}") = Field(
        ...,
        description="Identifiziert die Messlokation mittels einer eindeutigen ID",
        examples=["DE00014545768S0000000000000003054"],
    )


class MeloIds(RootModel[List[MeloId]]):
    root: List[MeloId]


class MeterLocationMeasuringPointOperator(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class MeterNumber(RootModel[str]):
    root: str = Field(
        ..., description="Identifiziert das Gerät der Messlokation mittels Gerätenummer", examples=["1SM-8465929523"]
    )


class MeterNumbers(RootModel[List[MeterNumber]]):
    root: List[MeterNumber]


class NeloId(RootModel[constr(pattern=r"E[A-Z\d]{9}\d")]):
    root: constr(pattern=r"E[A-Z\d]{9}\d") = Field(
        ..., description="Identifiziert die Netzlokation mittels einer eindeutigen ID", examples=["E1234848431"]
    )


class NetworkLocationMeasuringPointOperator(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class North(RootModel[str]):
    root: str = Field(
        ...,
        description="Angabe des UTM Nordwert nach WGS84. Umgerechneter Wert muss Min/Max für Länge/Breite entsprechen",
    )


class Northing(RootModel[str]):
    root: str = Field(
        ..., description="Gauß-Krüger Hochwert. Umgerechneter Wert muss Min/Max für Länge/Breite entsprechen."
    )


class OptionalChangeForecastBasis(Enum):
    possible = "possible"
    notPossible = "notPossible"


class Percent(RootModel[float]):
    root: float = Field(
        ..., description="Prozentualer Wert, wenn proportion mit percent vorhanden ist.", examples=["75.912"]
    )


class SubLotNumber(RootModel[str]):
    root: str = Field(..., description="Angabe der Flurstücksnummer (des Flurstücks) der Marktlokationsadresse")


class Proportion(Enum):
    bilateralAgreement = "bilateralAgreement"
    percent = "percent"


class ResponseCode(RootModel[constr(pattern=r"A[A-Z\d]{2}")]):
    root: constr(pattern=r"A[A-Z\d]{2}") = Field(
        ..., description="Angabe des Antwortgrundes des in decisionTree genannten Entscheidungsbaums.", examples=["A10"]
    )


class ReferenceId(RootModel[str]):
    root: str = Field(
        ...,
        description="Externe Vorgangsreferenz zur eindeutigen Identifikation des ursprünglichen Vorgangs",
        examples=["f81d4fae-7dec-11d0-a765-00a0c91e6bf6"],
    )


class SrId(RootModel[constr(pattern=r"C[A-Z\d]{9}\d")]):
    root: constr(pattern=r"C[A-Z\d]{9}\d") = Field(
        ..., description="Identifiziert die Steuerbare Ressource mittels einer eindeutigen ID", examples=["C1234848431"]
    )


class SrMarketPartner(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class DecisionTree(RootModel[constr(pattern=r"E_\d{4}")]):
    root: constr(pattern=r"E_\d{4}") = Field(
        ...,
        description='Angabe des Entscheidungsbaums aus dem edi@energy Dokument "Entscheidungsbaum-Diagramme und Codelisten für die Antwortnachrichten" als Grundlage für den negativen Antwortgrund',
        examples=["E_0594"],
    )


class Street(RootModel[str]):
    root: str = Field(..., description="Angabe der Straße der Marktlokationsadresse", examples=["Reinhardtstraße"])


class Surnames(RootModel[str]):
    root: str = Field(..., description="Angabe des Namen des Kunden", examples=["Becker"])


class Title(RootModel[str]):
    root: str = Field(..., description="Angabe des Titels der natürlichen Person", examples=["Prof.Dr."])


class TranchenId(RootModel[constr(pattern=r"\d{11}")]):
    root: constr(pattern=r"\d{11}") = Field(
        ..., description="Identifiziert die Tranche mittels einer eindeutigen ID", examples=["57685676742"]
    )


class TranchenIds(RootModel[List[TranchenId]]):
    root: List[TranchenId]


class TrancheSupplier(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class TransactionId(RootModel[str]):
    root: str = Field(
        ...,
        description="Externe Transaktionsnummer zur eindeutigen Identifikation des Vorgangs des sendenden Marktpartners",
        examples=["f81d4fae-7dec-11d0-a765-00a0c91e6bf6"],
    )


class TrId(RootModel[constr(pattern=r"D[A-Z\d]{9}\d")]):
    root: constr(pattern=r"D[A-Z\d]{9}\d") = Field(
        ..., description="Identifiziert die Technische Ressource mittels einer eindeutigen ID", examples=["D1234848431"]
    )


class ZipCode(RootModel[str]):
    root: str = Field(..., description="Angabe der Postleitzahl der Marktlokationsadresse", examples=[12117])


class Zone(Enum):
    UTMZone31 = "UTMZone31"
    UTMZone32 = "UTMZone32"
    UTMZone33 = "UTMZone33"


class IdentificationParameterIdentificationParameterId(BaseModel):
    maloId: Optional[MaloId] = None
    tranchenIds: Optional[TranchenIds] = None
    meloIds: Optional[MeloIds] = None
    meterNumbers: Optional[MeterNumbers] = None
    customerNumber: Optional[CustomerNumber] = None


class Address(BaseModel):
    countryCode: Optional[CountryCode] = None
    zipCode: Optional[ZipCode] = None
    city: Optional[City] = None
    street: Optional[Street] = None
    houseNumber: Optional[HouseNumber] = None
    houseNumberAddition: Optional[HouseNumberAddition] = None


class DataControllableResourceMeasuringPointOperators(RootModel[List[SrMarketPartner]]):
    root: List[SrMarketPartner]


class DataMeterLocationMeasuringPointOperators(RootModel[List[MeterLocationMeasuringPointOperator]]):
    root: List[MeterLocationMeasuringPointOperator]


class DataNetworkLocationMeasuringPointOperators(RootModel[List[NetworkLocationMeasuringPointOperator]]):
    root: List[NetworkLocationMeasuringPointOperator]


class DataTechnicalResource(BaseModel):
    trId: TrId


class DataTechnicalResources(RootModel[List[DataTechnicalResource]]):
    root: List[DataTechnicalResource]


class DataTrancheSuppliers(RootModel[List[TrancheSupplier]]):
    root: List[TrancheSupplier]


class GeographicCoordinates(BaseModel):
    latitude: Optional[Latitude] = None
    longitude: Optional[Longitude] = None
    east: Optional[East] = None
    north: Optional[North] = None
    zone: Optional[Zone] = None
    northing: Optional[Northing] = None
    easting: Optional[Easting] = None


class LandParcel(BaseModel):
    districtName: DistrictName
    lotNumber: LotNumber
    subLotNumber: SubLotNumber


class LandParcels(RootModel[List[LandParcel]]):
    root: List[LandParcel]


class MarketLocationMeasuringPointOperator(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class MarketLocationNetworkOperator(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class MarketLocationProperties(BaseModel):
    marketLocationProperty: MarketLocationProperty
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class MarketLocationSupplier(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class MarketLocationTransmissionSystemOperator(BaseModel):
    marketPartnerId: MarketPartnerId
    executionTimeFrom: ExecutionTimeFrom
    executionTimeUntil: Optional[ExecutionTimeUntil] = None


class Name(BaseModel):
    surnames: Optional[Surnames] = None
    firstnames: Optional[Firstnames] = None
    title: Optional[Title] = None
    company: Optional[Company] = None


class ResultNegative(BaseModel):
    decisionTree: DecisionTree
    responseCode: ResponseCode
    reason: Optional[Reason] = None
    networkOperator: Optional[MarketPartnerId] = None


class IdentificationParameterIdentificationParameterAddress(BaseModel):
    name: Optional[Name] = None
    address: Optional[Address] = None
    landParcels: Optional[LandParcels] = None
    geographicCoordinates: Optional[GeographicCoordinates] = None


class DataControllableResource(BaseModel):
    srId: SrId
    dataControllableResourceMeasuringPointOperators: Optional[DataControllableResourceMeasuringPointOperators] = None


class DataControllableResources(RootModel[List[DataControllableResource]]):
    root: List[DataControllableResource]


class DataMarketLocationMeasuringPointOperators(RootModel[List[MarketLocationMeasuringPointOperator]]):
    root: List[MarketLocationMeasuringPointOperator]


class DataMarketLocationProperties(RootModel[List[MarketLocationProperties]]):
    root: List[MarketLocationProperties]


class DataMarketLocationNetworkOperators(RootModel[List[MarketLocationNetworkOperator]]):
    root: List[MarketLocationNetworkOperator]


class DataMarketLocationSuppliers(RootModel[List[MarketLocationSupplier]]):
    root: List[MarketLocationSupplier]


class DataMarketLocationTransmissionSystemOperators(RootModel[List[MarketLocationTransmissionSystemOperator]]):
    root: List[MarketLocationTransmissionSystemOperator]


class DataMeterLocation(BaseModel):
    meloId: MeloId
    meterNumber: MeterNumber
    dataMeterLocationMeasuringPointOperators: DataMeterLocationMeasuringPointOperators


class DataMeterLocations(RootModel[List[DataMeterLocation]]):
    root: List[DataMeterLocation]


class DataNetworkLocation(BaseModel):
    neloId: NeloId
    dataNetworkLocationMeasuringPointOperators: DataNetworkLocationMeasuringPointOperators


class DataNetworkLocations(RootModel[List[DataNetworkLocation]]):
    root: List[DataNetworkLocation]


class DataTranche(BaseModel):
    tranchenId: TranchenId
    proportion: Proportion
    percent: Optional[Percent] = None
    dataTrancheSuppliers: DataTrancheSuppliers


class DataTranches(RootModel[List[DataTranche]]):
    root: List[DataTranche]


class IdentificationParameter(BaseModel):
    identificationDateTime: IdentificationDateTime
    energyDirection: EnergyDirection
    identificationParameterId: Optional[IdentificationParameterIdentificationParameterId] = None
    identificationParameterAddress: Optional[IdentificationParameterIdentificationParameterAddress] = None


class DataMarketLocation(BaseModel):
    maloId: MaloId
    energyDirection: EnergyDirection
    measurementTechnologyClassification: MeasurementTechnologyClassification
    optionalChangeForecastBasis: OptionalChangeForecastBasis
    dataMarketLocationProperties: DataMarketLocationProperties
    dataMarketLocationNetworkOperators: DataMarketLocationNetworkOperators
    dataMarketLocationMeasuringPointOperators: Optional[DataMarketLocationMeasuringPointOperators] = None
    dataMarketLocationTransmissionSystemOperators: DataMarketLocationTransmissionSystemOperators
    dataMarketLocationSuppliers: Optional[DataMarketLocationSuppliers] = None
    dataMarketLocationName: Optional[Name] = None
    dataMarketLocationAddress: Optional[Address] = None
    dataMarketLocationLandParcels: Optional[LandParcels] = None
    dataMarketLocationGeographicCoordinates: Optional[GeographicCoordinates] = None


class ResultPositive(BaseModel):
    dataMarketLocation: DataMarketLocation
    dataTranches: Optional[DataTranches] = None
    dataMeterLocations: Optional[DataMeterLocations] = None
    dataTechnicalResources: Optional[DataTechnicalResources] = None
    dataControllableResources: Optional[DataControllableResources] = None
    dataNetworkLocations: Optional[DataNetworkLocations] = None
