from typing import Any, Dict, Optional, Type
from abc import ABCMeta
from surfgram.types import TypesFactory


class RevenueWithdrawalStateSucceededMeta(ABCMeta):
    """Metaclass for RevenueWithdrawalStateSucceeded classes."""

    def __new__(cls, name: str, bases: tuple, attrs: Dict[str, Any]):
        new_class = super().__new__(cls, name, bases, attrs)
        if bases and new_class.__is_active__:
            RevenueWithdrawalStateSucceededsFactory.register_revenue_withdrawal_state_succeeded(
                new_class
            )
        return new_class


class RevenueWithdrawalStateSucceededsFactory(TypesFactory):
    """Factory for creating RevenueWithdrawalStateSucceeded instances."""

    REVENUEWITHDRAWALSTATESUCCEEDEDS_REGISTRY: Dict[str, Type] = {}
    __fallback_handler__: Optional[Type] = None
    __type_name__ = "revenue_withdrawal_state_succeeded"

    @classmethod
    def register_revenue_withdrawal_state_succeeded(
        cls, revenue_withdrawal_state_succeeded_cls: Type
    ) -> None:
        """Register a new revenue_withdrawal_state_succeeded handler."""
        instance = revenue_withdrawal_state_succeeded_cls()
        names = instance.__names__

        # Check if should be registered as fallback handler
        if not names or None in names or "" in names:
            cls.__fallback_handler__ = revenue_withdrawal_state_succeeded_cls
        else:
            for name in names:
                if name:  # Skip empty/None names
                    cls.REVENUEWITHDRAWALSTATESUCCEEDEDS_REGISTRY[name] = (
                        revenue_withdrawal_state_succeeded_cls
                    )

    @classmethod
    async def create(cls, update: Any) -> Optional[Any]:
        """Create handler instance from update."""
        obj = update.revenue_withdrawal_state_succeeded
        trigger_value = obj.type

        # Try to get specific handler first
        handler_cls = cls.REVENUEWITHDRAWALSTATESUCCEEDEDS_REGISTRY.get(trigger_value)

        # If no specific handler found, use fallback if available
        if handler_cls is None and cls.__fallback_handler__:
            handler_cls = cls.__fallback_handler__

        return handler_cls() if handler_cls else None
