"""
Module containing a class for getting the BNGL NET file for a given PySB model.

Serves as a wrapper around :py:func:`pysb.bng.generate_network`, which
generates the BNGL for the model and then invokes BNG to generate the NET file.

For information on how to use the model exporters, see the documentation
for :py:mod:`pysb.export`.
"""

from pysb.bng import generate_network
from pysb.export import Exporter

class BngNetExporter(Exporter):
    """A class for generating the BNG NET file for a given PySB model.

    Inherits from :py:class:`pysb.export.Export`, which implements
    basic functionality for all exporters.
    """
    def export(self):
        """Generate the BNGL NET file for the PySB model associated with
        the exporter. A wrapper around :py:func:`pysb.bng.generate_network`.

        Returns
        -------
        string
            The NET file output for the model, generated by BNG.
        """
        net_str = ''
        if self.docstring:
            net_str += '# ' + self.docstring.replace('\n', '\n# ') + '\n'
        net_str += generate_network(self.model, append_stdout=True)
        return net_str

