<%doc>
</%doc>

<%def name="get_type(col)">
    <%
    col_type = getattr(c.table.c, col).type
    if col_type:
        type = 'test'
    %>
</%def>

<%def name="show_field(col)">
    <%
    from sqlalchemy import types
    if c.id is not None:
        value = getattr(c.entry, col)
    else:
        value = ''
    tbl_col = getattr(c.table.c, col)
    %>
    % if len(tbl_col.foreign_keys) > 0:
        ${self.show_field_select(col)}
    % elif isinstance(tbl_col.type, types.Boolean):
        <input type="checkbox"
            %if tbl_col.default.arg:
                checked="checked"
            %endif
            name="${col}" />
    % elif isinstance(tbl_col.type, (types.Text, types.UnicodeText)):
        <textarea name="${col}" cols="32" rows="6">${value}</textarea>
    % elif isinstance(tbl_col.type, types.Date):
        <input name="${col}" value="${value}" /><small>(YYYY-MM-DD)</small>
    % elif isinstance(tbl_col.type, types.DateTime):
        <input name="${col}" value="${value}" /><small>(YYYY-MM-DD HH:MM)</small>
    % elif isinstance(tbl_col.type, types.Time):
        <input name="${col}" value="${value}" /><small>(HH:MM)</small>
    % else:
        <input name="${col}" value="${value}" />
    % endif
</%def>

<%def name="show_field_select(col)">
    <%
    v_id = getattr(c.entry, col)
    p_table = c.parent[col]['table']
    p_column = c.parent[col]['column']
    p_entries = c.db_sess.query(p_table).select()
    %>
    <select name="${col}">
    %if getattr(c.table.c, col).nullable:
        <option value=""></option>
    %endif
    %for entry in p_entries:
        %if entry.id == v_id:
            <option value="${entry.id}" selected="selected">
                ${getattr(entry, p_column)}
            </option>
        %else:
            <option value="${entry.id}">
                ${getattr(entry, p_column)}
            </option>
        %endif
    %endfor
    </select>
</%def>


<div class="child-entry">
% for col in c.columns:
    % if col != 'id':
    <dt>${col}</dt>
    <dd>
    <%
        input = self.show_field(col)
        type = getattr(c.table.c, col).type
    %>
    ${input}
    </dd>
    % endif
% endfor
<span class="child-remove-link">
${h.link_to_remote("remove",
        dict(update=c.child+'-'+c.cnt, url=h.url_for(action='rem_child'))
    )}
</span>
</div>

