/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class TeraDriver
implements Driver {
    protected static Log log = new Log("TeraDriver/" + (class$com$teradata$jdbc$TeraDriver == null ? (class$com$teradata$jdbc$TeraDriver = TeraDriver.class$("com.teradata.jdbc.TeraDriver")) : class$com$teradata$jdbc$TeraDriver).getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    static /* synthetic */ Class class$com$teradata$jdbc$TeraDriver;

    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string3 = null;
        String string4 = null;
        String string5 = "";
        String string6 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string7 = string.substring(string6.length());
        int n = string7.indexOf("/");
        if (n >= 0) {
            string2 = string7.substring(0, n);
            string5 = string7.substring(n + 1);
        } else {
            string2 = string7.trim();
            string5 = "";
        }
        if (string2.startsWith("[") && string2.endsWith("]")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (properties.containsKey("user")) {
            string3 = properties.getProperty("user");
        } else if (properties.containsKey("username")) {
            string3 = properties.getProperty("username");
        }
        if (properties.containsKey("password")) {
            string4 = properties.getProperty("password");
        }
        URLParameters uRLParameters = new URLParameters(string5);
        if (string3 == null) {
            string3 = uRLParameters.getUser();
        }
        if (string4 == null) {
            string4 = uRLParameters.getPassword();
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string2, string3, string4, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)((Object)connection);
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    public int getMajorVersion() {
        return 16;
    }

    public int getMinorVersion() {
        return 20;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)((Object)clob);
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)((Object)blob);
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        Object object;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)((Object)currentThreadIO.getConnection())).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (object = (TDResultSet)((Object)resultSetArray[i])) == null || ((TDResultSet)object).isClosed()) continue;
            long l = ((TDResultSet)object).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)object).getRequestNumber() + " stmtnum=" + ((TDResultSet)object).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)object).getStatementNumber(), ((TDResultSet)object).getRequestNumber(), l));
            ((TDResultSet)object).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        object = (TDStatement)((Object)tDSession.createStatement());
        StatementController statementController = new StatementController((TDStatement)object, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
    }
}

