/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.raw;

import com.teradata.jdbc.jdbc.raw.RawPreparedStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public abstract class RawResultSetMetaData {
    private RawPreparedStatement pstmt = null;
    private int numberOfColumns = 1;
    public static final String COLUMN_NAME = "RawMessage";

    public RawResultSetMetaData(RawPreparedStatement rawPreparedStatement) throws SQLException {
        this.pstmt = rawPreparedStatement;
    }

    protected void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > this.numberOfColumns) {
            throw ErrorFactory.makeDriverJDBCException("TJ599", n);
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "";
    }

    public String getColumnClassName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "[B";
    }

    public int getColumnCount() throws SQLException {
        this.pstmt.abortIfClosed();
        return this.numberOfColumns;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return this.pstmt.con.getMaxMessageSize(false, true);
    }

    public String getColumnLabel(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return COLUMN_NAME;
    }

    public String getColumnName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return COLUMN_NAME;
    }

    public int getColumnType(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return -3;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "VARBYTE";
    }

    public int getPrecision(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    public int getScale(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    public String getSchemaName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "";
    }

    public String getTableName(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return "";
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return 0;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    public boolean isSigned(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        this.pstmt.abortIfClosed();
        this.abortIfIndexNotValid(n);
        return false;
    }
}

