/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.ColumnSchema;
import com.datapps.linkoopdb.jdbc.LdbSqlNameManager;
import com.datapps.linkoopdb.jdbc.lib.HashMappedList;
import com.datapps.linkoopdb.jdbc.types.TableType;
import com.datapps.linkoopdb.jdbc.types.Type;

public class PipelineType
extends TableType {
    public static final HashMappedList PIPELINE_COLUMNS = new HashMappedList();
    public static final Type[] PIPELINE_COL_TYPES = new Type[]{Type.SQL_VARCHAR_DEFAULT, Type.SQL_VARCHAR_DEFAULT, Type.SQL_VARCHAR_DEFAULT};
    private String algorithm;

    public PipelineType() {
        this("unknown");
    }

    public PipelineType(String algorithm) {
        super(117, PIPELINE_COLUMNS, PIPELINE_COL_TYPES);
        this.algorithm = algorithm;
    }

    @Override
    public String getDefinition() {
        return "PIPELINE(" + this.algorithm + ")";
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        return otherType.typeCode == 117 && this.algorithm.equalsIgnoreCase(((PipelineType)otherType).algorithm) || otherType.typeCode == 0;
    }

    static {
        PIPELINE_COLUMNS.add("NAME", new ColumnSchema(LdbSqlNameManager.newSystemObjectName("NAME", 9), Type.SQL_VARCHAR_DEFAULT));
        PIPELINE_COLUMNS.add("VALUE", new ColumnSchema(LdbSqlNameManager.newSystemObjectName("VALUE", 9), Type.SQL_VARCHAR_DEFAULT));
        PIPELINE_COLUMNS.add("DOC", new ColumnSchema(LdbSqlNameManager.newSystemObjectName("DOC", 9), Type.SQL_VARCHAR_DEFAULT));
    }
}

