/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class CodeSwitcher {
    private static final String ls = System.getProperty("line.separator", "\n");
    private static final int MAX_LINELENGTH = 82;
    private Vector vList = new Vector();
    private Vector vSwitchOn = new Vector();
    private Vector vSwitchOff = new Vector();
    private Vector vSwitches = new Vector();

    CodeSwitcher() {
    }

    public static void main(String[] a) {
        CodeSwitcher s = new CodeSwitcher();
        if (a.length == 0) {
            CodeSwitcher.showUsage();
            return;
        }
        File listFile = null;
        File baseDir = null;
        for (int i = 0; i < a.length; ++i) {
            String p = a[i];
            if (p.startsWith("+")) {
                s.vSwitchOn.addElement(p.substring(1));
                continue;
            }
            if (p.startsWith("--basedir=")) {
                baseDir = new File(p.substring("--basedir=".length()));
                continue;
            }
            if (p.startsWith("--pathlist=")) {
                listFile = new File(p.substring("--pathlist=".length()));
                continue;
            }
            if (p.startsWith("-")) {
                s.vSwitchOff.addElement(p.substring(1));
                continue;
            }
            s.addDir(p);
        }
        if (baseDir != null) {
            if (listFile == null) {
                System.err.println("--basedir= setting ignored, since only used for list files");
            } else if (!baseDir.isDirectory()) {
                System.err.println("Skipping listfile since basedir '" + baseDir.getAbsolutePath() + "' is not a directory");
                listFile = null;
            }
        }
        if (listFile != null) {
            try {
                String st;
                BufferedReader br = new BufferedReader(new FileReader(listFile));
                while ((st = br.readLine()) != null) {
                    File f;
                    int hashIndex = st.indexOf(35);
                    String p = (hashIndex > -1 ? st.substring(0, hashIndex) : st).trim();
                    if (p.length() < 1) continue;
                    File file = f = baseDir == null ? new File(p) : new File(baseDir, p);
                    if (f.isFile()) {
                        s.addDir(f);
                        continue;
                    }
                    System.err.println("Skipping non-file '" + p.trim() + "'");
                }
            }
            catch (Exception e) {
                System.err.println("Failed to read pathlist file '" + listFile.getAbsolutePath() + "'");
            }
        }
        if (s.size() < 1) {
            CodeSwitcher.printError("No path specified, or no specified paths qualify");
            CodeSwitcher.showUsage();
        }
        s.process();
        if (s.vSwitchOff.size() == 0 && s.vSwitchOn.size() == 0) {
            s.printSwitches();
        }
    }

    static void showUsage() {
        System.out.print("Usage: java CodeSwitcher paths|{--pathlist=listfile} [{+|-}label...] [+][-]\nIf no labels are specified then all used\nlabels in the source code are shown.\nUse +MODE to switch on the things labeld MODE\nUse -MODE to switch off the things labeld MODE\nPath: Any number of path or files may be\nspecified. Use . for the current directory\n(including sub-directories).\nExample: java CodeSwitcher +JAVA2 .\nThis example switches on code labeled JAVA2\nin all *.java files in the current directory\nand all subdirectories.\n");
    }

    static Vector getFileLines(File f) throws IOException {
        String line;
        LineNumberReader read = new LineNumberReader(new FileReader(f));
        Vector<String> v = new Vector<String>();
        while ((line = read.readLine()) != null) {
            v.addElement(line);
        }
        read.close();
        return v;
    }

    static void writeFileLines(Vector v, File f) throws IOException {
        FileWriter write = new FileWriter(f);
        for (int i = 0; i < v.size(); ++i) {
            write.write((String)v.elementAt(i));
            write.write(ls);
        }
        write.flush();
        write.close();
    }

    static void printError(String error) {
        System.out.println("");
        System.out.println("ERROR: " + error);
    }

    public int size() {
        return this.vList == null ? 0 : this.vList.size();
    }

    void process() {
        int len = this.vList.size();
        for (int i = 0; i < len; ++i) {
            System.out.print(".");
            String file = (String)this.vList.elementAt(i);
            if (this.processFile(file)) continue;
            System.out.println("in file " + file + " !");
        }
        System.out.println("");
    }

    void printSwitches() {
        System.out.println("Used labels:");
        for (int i = 0; i < this.vSwitches.size(); ++i) {
            System.out.println((String)this.vSwitches.elementAt(i));
        }
    }

    void addDir(String path) {
        this.addDir(new File(path));
    }

    void addDir(File f) {
        if (f.isFile() && f.getName().endsWith(".java")) {
            this.vList.addElement(f.getPath());
        } else if (f.isDirectory()) {
            File[] list = f.listFiles();
            for (int i = 0; i < list.length; ++i) {
                this.addDir(list[i]);
            }
        }
    }

    boolean processFile(String name) {
        File f = new File(name);
        File fnew = new File(name + ".new");
        int state = 0;
        boolean switchoff = false;
        boolean working = false;
        try {
            String line;
            int i;
            Vector v = CodeSwitcher.getFileLines(f);
            Vector v1 = new Vector(v.size());
            for (i = 0; i < v.size(); ++i) {
                v1.addElement(v.elementAt(i));
            }
            for (i = 0; i < v.size() && (line = (String)v.elementAt(i)) != null; ++i) {
                String s;
                if (working && (line.equals("/*") || line.equals("*/"))) {
                    v.removeElementAt(i--);
                    continue;
                }
                if (!line.startsWith("//#")) continue;
                if (line.startsWith("//#ifdef ")) {
                    if (state != 0) {
                        CodeSwitcher.printError("'#ifdef' not allowed inside '#ifdef'");
                        return false;
                    }
                    state = 1;
                    s = line.substring(9);
                    if (this.vSwitchOn.indexOf(s) != -1) {
                        working = true;
                        switchoff = false;
                    } else if (this.vSwitchOff.indexOf(s) != -1) {
                        working = true;
                        v.insertElementAt("/*", ++i);
                        switchoff = true;
                    }
                    if (this.vSwitches.indexOf(s) != -1) continue;
                    this.vSwitches.addElement(s);
                    continue;
                }
                if (line.startsWith("//#ifndef ")) {
                    if (state != 0) {
                        CodeSwitcher.printError("'#ifndef' not allowed inside '#ifdef'");
                        return false;
                    }
                    state = 1;
                    s = line.substring(10);
                    if (this.vSwitchOff.indexOf(s) != -1) {
                        working = true;
                        switchoff = false;
                    } else if (this.vSwitchOn.indexOf(s) != -1) {
                        working = true;
                        v.insertElementAt("/*", ++i);
                        switchoff = true;
                    }
                    if (this.vSwitches.indexOf(s) != -1) continue;
                    this.vSwitches.addElement(s);
                    continue;
                }
                if (line.startsWith("//#else")) {
                    if (state != 1) {
                        CodeSwitcher.printError("'#else' without '#ifdef'");
                        return false;
                    }
                    state = 2;
                    if (!working) continue;
                    if (switchoff) {
                        if (v.elementAt(i - 1).equals("")) {
                            v.insertElementAt("*/", i - 1);
                            ++i;
                        } else {
                            v.insertElementAt("*/", i++);
                        }
                        switchoff = false;
                        continue;
                    }
                    v.insertElementAt("/*", ++i);
                    switchoff = true;
                    continue;
                }
                if (!line.startsWith("//#endif")) continue;
                if (state == 0) {
                    CodeSwitcher.printError("'#endif' without '#ifdef'");
                    return false;
                }
                state = 0;
                if (working && switchoff) {
                    if (v.elementAt(i - 1).equals("")) {
                        v.insertElementAt("*/", i - 1);
                        ++i;
                    } else {
                        v.insertElementAt("*/", i++);
                    }
                }
                working = false;
            }
            if (state != 0) {
                CodeSwitcher.printError("'#endif' missing");
                return false;
            }
            boolean filechanged = false;
            for (int i2 = 0; i2 < v.size(); ++i2) {
                if (v1.elementAt(i2).equals(v.elementAt(i2))) continue;
                filechanged = true;
                break;
            }
            if (!filechanged) {
                return true;
            }
            CodeSwitcher.writeFileLines(v, fnew);
            File fbak = new File(name + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
            return true;
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.toString());
            return false;
        }
    }
}

