# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApiDeploymentSpecificationResult',
    'AwaitableGetApiDeploymentSpecificationResult',
    'get_api_deployment_specification',
    'get_api_deployment_specification_output',
]

@pulumi.output_type
class GetApiDeploymentSpecificationResult:
    """
    A collection of values returned by getApiDeploymentSpecification.
    """
    def __init__(__self__, api_id=None, id=None, logging_policies=None, request_policies=None, routes=None):
        if api_id and not isinstance(api_id, str):
            raise TypeError("Expected argument 'api_id' to be a str")
        pulumi.set(__self__, "api_id", api_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if logging_policies and not isinstance(logging_policies, list):
            raise TypeError("Expected argument 'logging_policies' to be a list")
        pulumi.set(__self__, "logging_policies", logging_policies)
        if request_policies and not isinstance(request_policies, list):
            raise TypeError("Expected argument 'request_policies' to be a list")
        pulumi.set(__self__, "request_policies", request_policies)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)

    @property
    @pulumi.getter(name="apiId")
    def api_id(self) -> str:
        return pulumi.get(self, "api_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loggingPolicies")
    def logging_policies(self) -> Sequence['outputs.GetApiDeploymentSpecificationLoggingPolicyResult']:
        """
        Policies controlling the pushing of logs to Oracle Cloud Infrastructure Public Logging.
        """
        return pulumi.get(self, "logging_policies")

    @property
    @pulumi.getter(name="requestPolicies")
    def request_policies(self) -> Sequence['outputs.GetApiDeploymentSpecificationRequestPolicyResult']:
        """
        Behavior applied to any requests received by the API on this route.
        """
        return pulumi.get(self, "request_policies")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetApiDeploymentSpecificationRouteResult']:
        """
        A list of routes that this API exposes.
        """
        return pulumi.get(self, "routes")


class AwaitableGetApiDeploymentSpecificationResult(GetApiDeploymentSpecificationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApiDeploymentSpecificationResult(
            api_id=self.api_id,
            id=self.id,
            logging_policies=self.logging_policies,
            request_policies=self.request_policies,
            routes=self.routes)


def get_api_deployment_specification(api_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApiDeploymentSpecificationResult:
    """
    This data source provides details about a specific Api Deployment Specification resource in Oracle Cloud Infrastructure API Gateway service.

    Gets an API Deployment specification by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_deployment_specification = oci.ApiGateway.get_api_deployment_specification(api_id=test_api["id"])
    ```


    :param str api_id: The ocid of the API.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApiGateway/getApiDeploymentSpecification:getApiDeploymentSpecification', __args__, opts=opts, typ=GetApiDeploymentSpecificationResult).value

    return AwaitableGetApiDeploymentSpecificationResult(
        api_id=pulumi.get(__ret__, 'api_id'),
        id=pulumi.get(__ret__, 'id'),
        logging_policies=pulumi.get(__ret__, 'logging_policies'),
        request_policies=pulumi.get(__ret__, 'request_policies'),
        routes=pulumi.get(__ret__, 'routes'))
def get_api_deployment_specification_output(api_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApiDeploymentSpecificationResult]:
    """
    This data source provides details about a specific Api Deployment Specification resource in Oracle Cloud Infrastructure API Gateway service.

    Gets an API Deployment specification by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_api_deployment_specification = oci.ApiGateway.get_api_deployment_specification(api_id=test_api["id"])
    ```


    :param str api_id: The ocid of the API.
    """
    __args__ = dict()
    __args__['apiId'] = api_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ApiGateway/getApiDeploymentSpecification:getApiDeploymentSpecification', __args__, opts=opts, typ=GetApiDeploymentSpecificationResult)
    return __ret__.apply(lambda __response__: GetApiDeploymentSpecificationResult(
        api_id=pulumi.get(__response__, 'api_id'),
        id=pulumi.get(__response__, 'id'),
        logging_policies=pulumi.get(__response__, 'logging_policies'),
        request_policies=pulumi.get(__response__, 'request_policies'),
        routes=pulumi.get(__response__, 'routes')))
