# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetContainerSignaturesResult',
    'AwaitableGetContainerSignaturesResult',
    'get_container_signatures',
    'get_container_signatures_output',
]

@pulumi.output_type
class GetContainerSignaturesResult:
    """
    A collection of values returned by getContainerSignatures.
    """
    def __init__(__self__, compartment_id=None, compartment_id_in_subtree=None, container_image_signature_collections=None, display_name=None, filters=None, id=None, image_digest=None, image_id=None, kms_key_id=None, kms_key_version_id=None, repository_id=None, repository_name=None, signing_algorithm=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if container_image_signature_collections and not isinstance(container_image_signature_collections, list):
            raise TypeError("Expected argument 'container_image_signature_collections' to be a list")
        pulumi.set(__self__, "container_image_signature_collections", container_image_signature_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_digest and not isinstance(image_digest, str):
            raise TypeError("Expected argument 'image_digest' to be a str")
        pulumi.set(__self__, "image_digest", image_digest)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id and not isinstance(kms_key_version_id, str):
            raise TypeError("Expected argument 'kms_key_version_id' to be a str")
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if repository_name and not isinstance(repository_name, str):
            raise TypeError("Expected argument 'repository_name' to be a str")
        pulumi.set(__self__, "repository_name", repository_name)
        if signing_algorithm and not isinstance(signing_algorithm, str):
            raise TypeError("Expected argument 'signing_algorithm' to be a str")
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the container repository exists.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="containerImageSignatureCollections")
    def container_image_signature_collections(self) -> Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionResult']:
        """
        The list of container_image_signature_collection.
        """
        return pulumi.get(self, "container_image_signature_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The last 10 characters of the kmsKeyId, the last 10 characters of the kmsKeyVersionId, the signingAlgorithm, and the last 10 characters of the signatureId.  Example: `wrmz22sixa::qdwyc2ptun::SHA_256_RSA_PKCS_PSS::2vwmobasva`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetContainerSignaturesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> Optional[str]:
        return pulumi.get(self, "image_digest")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image.  Example: `ocid1.containerimage.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyId used to sign the container image.  Example: `ocid1.key.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[str]:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> Optional[str]:
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[str]:
        """
        The algorithm to be used for signing. These are the only supported signing algorithms for container images.
        """
        return pulumi.get(self, "signing_algorithm")


class AwaitableGetContainerSignaturesResult(GetContainerSignaturesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerSignaturesResult(
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            container_image_signature_collections=self.container_image_signature_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            image_digest=self.image_digest,
            image_id=self.image_id,
            kms_key_id=self.kms_key_id,
            kms_key_version_id=self.kms_key_version_id,
            repository_id=self.repository_id,
            repository_name=self.repository_name,
            signing_algorithm=self.signing_algorithm)


def get_container_signatures(compartment_id: Optional[str] = None,
                             compartment_id_in_subtree: Optional[bool] = None,
                             display_name: Optional[str] = None,
                             filters: Optional[Sequence[Union['GetContainerSignaturesFilterArgs', 'GetContainerSignaturesFilterArgsDict']]] = None,
                             image_digest: Optional[str] = None,
                             image_id: Optional[str] = None,
                             kms_key_id: Optional[str] = None,
                             kms_key_version_id: Optional[str] = None,
                             repository_id: Optional[str] = None,
                             repository_name: Optional[str] = None,
                             signing_algorithm: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerSignaturesResult:
    """
    This data source provides the list of Container Image Signatures in Oracle Cloud Infrastructure Artifacts service.

    List container image signatures in an image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_image_signatures = oci.Artifacts.get_container_signatures(compartment_id=compartment_id,
        compartment_id_in_subtree=container_image_signature_compartment_id_in_subtree,
        display_name=container_image_signature_display_name,
        image_digest=container_image_signature_image_digest,
        image_id=test_image["id"],
        kms_key_id=test_key["id"],
        kms_key_version_id=test_key_version["id"],
        repository_id=test_repository["id"],
        repository_name=test_repository["name"],
        signing_algorithm=container_image_signature_signing_algorithm)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are inspected depending on the the setting of `accessLevel`. Default is false. Can only be set to true when calling the API on the tenancy (root compartment).
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str image_digest: The digest of the container image.  Example: `sha256:e7d38b3517548a1c71e41bffe9c8ae6d6d29546ce46bf62159837aad072c90aa`
    :param str image_id: A filter to return a container image summary only for the specified container image OCID.
    :param str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
    :param str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
    :param str repository_id: A filter to return container images only for the specified container repository OCID.
    :param str repository_name: A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
    :param str signing_algorithm: The algorithm to be used for signing. These are the only supported signing algorithms for container images.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['imageDigest'] = image_digest
    __args__['imageId'] = image_id
    __args__['kmsKeyId'] = kms_key_id
    __args__['kmsKeyVersionId'] = kms_key_version_id
    __args__['repositoryId'] = repository_id
    __args__['repositoryName'] = repository_name
    __args__['signingAlgorithm'] = signing_algorithm
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Artifacts/getContainerSignatures:getContainerSignatures', __args__, opts=opts, typ=GetContainerSignaturesResult).value

    return AwaitableGetContainerSignaturesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        container_image_signature_collections=pulumi.get(__ret__, 'container_image_signature_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        image_digest=pulumi.get(__ret__, 'image_digest'),
        image_id=pulumi.get(__ret__, 'image_id'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        kms_key_version_id=pulumi.get(__ret__, 'kms_key_version_id'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        repository_name=pulumi.get(__ret__, 'repository_name'),
        signing_algorithm=pulumi.get(__ret__, 'signing_algorithm'))
def get_container_signatures_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                    compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetContainerSignaturesFilterArgs', 'GetContainerSignaturesFilterArgsDict']]]]] = None,
                                    image_digest: Optional[pulumi.Input[Optional[str]]] = None,
                                    image_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    kms_key_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    kms_key_version_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    repository_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    repository_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    signing_algorithm: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerSignaturesResult]:
    """
    This data source provides the list of Container Image Signatures in Oracle Cloud Infrastructure Artifacts service.

    List container image signatures in an image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_container_image_signatures = oci.Artifacts.get_container_signatures(compartment_id=compartment_id,
        compartment_id_in_subtree=container_image_signature_compartment_id_in_subtree,
        display_name=container_image_signature_display_name,
        image_digest=container_image_signature_image_digest,
        image_id=test_image["id"],
        kms_key_id=test_key["id"],
        kms_key_version_id=test_key_version["id"],
        repository_id=test_repository["id"],
        repository_name=test_repository["name"],
        signing_algorithm=container_image_signature_signing_algorithm)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param bool compartment_id_in_subtree: When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are inspected depending on the the setting of `accessLevel`. Default is false. Can only be set to true when calling the API on the tenancy (root compartment).
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str image_digest: The digest of the container image.  Example: `sha256:e7d38b3517548a1c71e41bffe9c8ae6d6d29546ce46bf62159837aad072c90aa`
    :param str image_id: A filter to return a container image summary only for the specified container image OCID.
    :param str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
    :param str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
    :param str repository_id: A filter to return container images only for the specified container repository OCID.
    :param str repository_name: A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
    :param str signing_algorithm: The algorithm to be used for signing. These are the only supported signing algorithms for container images.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['imageDigest'] = image_digest
    __args__['imageId'] = image_id
    __args__['kmsKeyId'] = kms_key_id
    __args__['kmsKeyVersionId'] = kms_key_version_id
    __args__['repositoryId'] = repository_id
    __args__['repositoryName'] = repository_name
    __args__['signingAlgorithm'] = signing_algorithm
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Artifacts/getContainerSignatures:getContainerSignatures', __args__, opts=opts, typ=GetContainerSignaturesResult)
    return __ret__.apply(lambda __response__: GetContainerSignaturesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        container_image_signature_collections=pulumi.get(__response__, 'container_image_signature_collections'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        image_digest=pulumi.get(__response__, 'image_digest'),
        image_id=pulumi.get(__response__, 'image_id'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        kms_key_version_id=pulumi.get(__response__, 'kms_key_version_id'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        repository_name=pulumi.get(__response__, 'repository_name'),
        signing_algorithm=pulumi.get(__response__, 'signing_algorithm')))
