# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBdsInstanceMetastoreConfigResult',
    'AwaitableGetBdsInstanceMetastoreConfigResult',
    'get_bds_instance_metastore_config',
    'get_bds_instance_metastore_config_output',
]

@pulumi.output_type
class GetBdsInstanceMetastoreConfigResult:
    """
    A collection of values returned by getBdsInstanceMetastoreConfig.
    """
    def __init__(__self__, activate_trigger=None, bds_api_key_id=None, bds_api_key_passphrase=None, bds_instance_id=None, cluster_admin_password=None, display_name=None, id=None, metastore_config_id=None, metastore_id=None, metastore_type=None, state=None, time_created=None, time_updated=None):
        if activate_trigger and not isinstance(activate_trigger, int):
            raise TypeError("Expected argument 'activate_trigger' to be a int")
        pulumi.set(__self__, "activate_trigger", activate_trigger)
        if bds_api_key_id and not isinstance(bds_api_key_id, str):
            raise TypeError("Expected argument 'bds_api_key_id' to be a str")
        pulumi.set(__self__, "bds_api_key_id", bds_api_key_id)
        if bds_api_key_passphrase and not isinstance(bds_api_key_passphrase, str):
            raise TypeError("Expected argument 'bds_api_key_passphrase' to be a str")
        pulumi.set(__self__, "bds_api_key_passphrase", bds_api_key_passphrase)
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if cluster_admin_password and not isinstance(cluster_admin_password, str):
            raise TypeError("Expected argument 'cluster_admin_password' to be a str")
        pulumi.set(__self__, "cluster_admin_password", cluster_admin_password)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metastore_config_id and not isinstance(metastore_config_id, str):
            raise TypeError("Expected argument 'metastore_config_id' to be a str")
        pulumi.set(__self__, "metastore_config_id", metastore_config_id)
        if metastore_id and not isinstance(metastore_id, str):
            raise TypeError("Expected argument 'metastore_id' to be a str")
        pulumi.set(__self__, "metastore_id", metastore_id)
        if metastore_type and not isinstance(metastore_type, str):
            raise TypeError("Expected argument 'metastore_type' to be a str")
        pulumi.set(__self__, "metastore_type", metastore_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="activateTrigger")
    def activate_trigger(self) -> int:
        return pulumi.get(self, "activate_trigger")

    @property
    @pulumi.getter(name="bdsApiKeyId")
    def bds_api_key_id(self) -> str:
        """
        The ID of BDS API Key used for metastore configuration. Set only if metastore's type is EXTERNAL.
        """
        return pulumi.get(self, "bds_api_key_id")

    @property
    @pulumi.getter(name="bdsApiKeyPassphrase")
    def bds_api_key_passphrase(self) -> str:
        return pulumi.get(self, "bds_api_key_passphrase")

    @property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> str:
        return pulumi.get(self, "bds_instance_id")

    @property
    @pulumi.getter(name="clusterAdminPassword")
    def cluster_admin_password(self) -> str:
        return pulumi.get(self, "cluster_admin_password")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of metastore configuration
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the metastore configuration
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metastoreConfigId")
    def metastore_config_id(self) -> str:
        return pulumi.get(self, "metastore_config_id")

    @property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> str:
        """
        The OCID of the Data Catalog metastore. Set only if metastore's type is EXTERNAL.
        """
        return pulumi.get(self, "metastore_id")

    @property
    @pulumi.getter(name="metastoreType")
    def metastore_type(self) -> str:
        """
        The type of the metastore in the metastore configuration.
        """
        return pulumi.get(self, "metastore_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        the lifecycle state of the metastore configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time when the configuration was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when the configuration was updated, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetBdsInstanceMetastoreConfigResult(GetBdsInstanceMetastoreConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceMetastoreConfigResult(
            activate_trigger=self.activate_trigger,
            bds_api_key_id=self.bds_api_key_id,
            bds_api_key_passphrase=self.bds_api_key_passphrase,
            bds_instance_id=self.bds_instance_id,
            cluster_admin_password=self.cluster_admin_password,
            display_name=self.display_name,
            id=self.id,
            metastore_config_id=self.metastore_config_id,
            metastore_id=self.metastore_id,
            metastore_type=self.metastore_type,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_bds_instance_metastore_config(bds_instance_id: Optional[str] = None,
                                      metastore_config_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceMetastoreConfigResult:
    """
    This data source provides details about a specific Bds Instance Metastore Config resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns the BDS Metastore configuration information for the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_metastore_config = oci.BigDataService.get_bds_instance_metastore_config(bds_instance_id=test_bds_instance["id"],
        metastore_config_id=test_config["id"])
    ```


    :param str bds_instance_id: The OCID of the cluster.
    :param str metastore_config_id: The metastore configuration ID
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['metastoreConfigId'] = metastore_config_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceMetastoreConfig:getBdsInstanceMetastoreConfig', __args__, opts=opts, typ=GetBdsInstanceMetastoreConfigResult).value

    return AwaitableGetBdsInstanceMetastoreConfigResult(
        activate_trigger=pulumi.get(__ret__, 'activate_trigger'),
        bds_api_key_id=pulumi.get(__ret__, 'bds_api_key_id'),
        bds_api_key_passphrase=pulumi.get(__ret__, 'bds_api_key_passphrase'),
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__ret__, 'cluster_admin_password'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        metastore_config_id=pulumi.get(__ret__, 'metastore_config_id'),
        metastore_id=pulumi.get(__ret__, 'metastore_id'),
        metastore_type=pulumi.get(__ret__, 'metastore_type'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_bds_instance_metastore_config_output(bds_instance_id: Optional[pulumi.Input[str]] = None,
                                             metastore_config_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceMetastoreConfigResult]:
    """
    This data source provides details about a specific Bds Instance Metastore Config resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns the BDS Metastore configuration information for the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_metastore_config = oci.BigDataService.get_bds_instance_metastore_config(bds_instance_id=test_bds_instance["id"],
        metastore_config_id=test_config["id"])
    ```


    :param str bds_instance_id: The OCID of the cluster.
    :param str metastore_config_id: The metastore configuration ID
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['metastoreConfigId'] = metastore_config_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceMetastoreConfig:getBdsInstanceMetastoreConfig', __args__, opts=opts, typ=GetBdsInstanceMetastoreConfigResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceMetastoreConfigResult(
        activate_trigger=pulumi.get(__response__, 'activate_trigger'),
        bds_api_key_id=pulumi.get(__response__, 'bds_api_key_id'),
        bds_api_key_passphrase=pulumi.get(__response__, 'bds_api_key_passphrase'),
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        cluster_admin_password=pulumi.get(__response__, 'cluster_admin_password'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        metastore_config_id=pulumi.get(__response__, 'metastore_config_id'),
        metastore_id=pulumi.get(__response__, 'metastore_id'),
        metastore_type=pulumi.get(__response__, 'metastore_type'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
