# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetClusterOptionResult',
    'AwaitableGetClusterOptionResult',
    'get_cluster_option',
    'get_cluster_option_output',
]

@pulumi.output_type
class GetClusterOptionResult:
    """
    A collection of values returned by getClusterOption.
    """
    def __init__(__self__, cluster_option_id=None, cluster_pod_network_options=None, compartment_id=None, id=None, kubernetes_versions=None):
        if cluster_option_id and not isinstance(cluster_option_id, str):
            raise TypeError("Expected argument 'cluster_option_id' to be a str")
        pulumi.set(__self__, "cluster_option_id", cluster_option_id)
        if cluster_pod_network_options and not isinstance(cluster_pod_network_options, list):
            raise TypeError("Expected argument 'cluster_pod_network_options' to be a list")
        pulumi.set(__self__, "cluster_pod_network_options", cluster_pod_network_options)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kubernetes_versions and not isinstance(kubernetes_versions, list):
            raise TypeError("Expected argument 'kubernetes_versions' to be a list")
        pulumi.set(__self__, "kubernetes_versions", kubernetes_versions)

    @property
    @pulumi.getter(name="clusterOptionId")
    def cluster_option_id(self) -> str:
        return pulumi.get(self, "cluster_option_id")

    @property
    @pulumi.getter(name="clusterPodNetworkOptions")
    def cluster_pod_network_options(self) -> Sequence['outputs.GetClusterOptionClusterPodNetworkOptionResult']:
        """
        Available CNIs and network options for existing and new node pools of the cluster
        """
        return pulumi.get(self, "cluster_pod_network_options")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersions")
    def kubernetes_versions(self) -> Sequence[str]:
        """
        Available Kubernetes versions.
        """
        return pulumi.get(self, "kubernetes_versions")


class AwaitableGetClusterOptionResult(GetClusterOptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClusterOptionResult(
            cluster_option_id=self.cluster_option_id,
            cluster_pod_network_options=self.cluster_pod_network_options,
            compartment_id=self.compartment_id,
            id=self.id,
            kubernetes_versions=self.kubernetes_versions)


def get_cluster_option(cluster_option_id: Optional[str] = None,
                       compartment_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClusterOptionResult:
    """
    This data source provides details about a specific Cluster Option resource in Oracle Cloud Infrastructure Container Engine service.

    Get options available for clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_option = oci.ContainerEngine.get_cluster_option(cluster_option_id=test_cluster_option_oci_containerengine_cluster_option["id"],
        compartment_id=compartment_id)
    ```


    :param str cluster_option_id: The id of the option set to retrieve. Use "all" get all options, or use a cluster ID to get options specific to the provided cluster.
    :param str compartment_id: The OCID of the compartment.
    """
    __args__ = dict()
    __args__['clusterOptionId'] = cluster_option_id
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ContainerEngine/getClusterOption:getClusterOption', __args__, opts=opts, typ=GetClusterOptionResult).value

    return AwaitableGetClusterOptionResult(
        cluster_option_id=pulumi.get(__ret__, 'cluster_option_id'),
        cluster_pod_network_options=pulumi.get(__ret__, 'cluster_pod_network_options'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        kubernetes_versions=pulumi.get(__ret__, 'kubernetes_versions'))
def get_cluster_option_output(cluster_option_id: Optional[pulumi.Input[str]] = None,
                              compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetClusterOptionResult]:
    """
    This data source provides details about a specific Cluster Option resource in Oracle Cloud Infrastructure Container Engine service.

    Get options available for clusters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cluster_option = oci.ContainerEngine.get_cluster_option(cluster_option_id=test_cluster_option_oci_containerengine_cluster_option["id"],
        compartment_id=compartment_id)
    ```


    :param str cluster_option_id: The id of the option set to retrieve. Use "all" get all options, or use a cluster ID to get options specific to the provided cluster.
    :param str compartment_id: The OCID of the compartment.
    """
    __args__ = dict()
    __args__['clusterOptionId'] = cluster_option_id
    __args__['compartmentId'] = compartment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ContainerEngine/getClusterOption:getClusterOption', __args__, opts=opts, typ=GetClusterOptionResult)
    return __ret__.apply(lambda __response__: GetClusterOptionResult(
        cluster_option_id=pulumi.get(__response__, 'cluster_option_id'),
        cluster_pod_network_options=pulumi.get(__response__, 'cluster_pod_network_options'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        id=pulumi.get(__response__, 'id'),
        kubernetes_versions=pulumi.get(__response__, 'kubernetes_versions')))
