# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTunnelSecurityAssociationsResult',
    'AwaitableGetTunnelSecurityAssociationsResult',
    'get_tunnel_security_associations',
    'get_tunnel_security_associations_output',
]

@pulumi.output_type
class GetTunnelSecurityAssociationsResult:
    """
    A collection of values returned by getTunnelSecurityAssociations.
    """
    def __init__(__self__, filters=None, id=None, ipsec_id=None, tunnel_id=None, tunnel_security_associations=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipsec_id and not isinstance(ipsec_id, str):
            raise TypeError("Expected argument 'ipsec_id' to be a str")
        pulumi.set(__self__, "ipsec_id", ipsec_id)
        if tunnel_id and not isinstance(tunnel_id, str):
            raise TypeError("Expected argument 'tunnel_id' to be a str")
        pulumi.set(__self__, "tunnel_id", tunnel_id)
        if tunnel_security_associations and not isinstance(tunnel_security_associations, list):
            raise TypeError("Expected argument 'tunnel_security_associations' to be a list")
        pulumi.set(__self__, "tunnel_security_associations", tunnel_security_associations)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTunnelSecurityAssociationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> str:
        return pulumi.get(self, "ipsec_id")

    @property
    @pulumi.getter(name="tunnelId")
    def tunnel_id(self) -> str:
        return pulumi.get(self, "tunnel_id")

    @property
    @pulumi.getter(name="tunnelSecurityAssociations")
    def tunnel_security_associations(self) -> Sequence['outputs.GetTunnelSecurityAssociationsTunnelSecurityAssociationResult']:
        """
        The list of tunnel_security_associations.
        """
        return pulumi.get(self, "tunnel_security_associations")


class AwaitableGetTunnelSecurityAssociationsResult(GetTunnelSecurityAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTunnelSecurityAssociationsResult(
            filters=self.filters,
            id=self.id,
            ipsec_id=self.ipsec_id,
            tunnel_id=self.tunnel_id,
            tunnel_security_associations=self.tunnel_security_associations)


def get_tunnel_security_associations(filters: Optional[Sequence[Union['GetTunnelSecurityAssociationsFilterArgs', 'GetTunnelSecurityAssociationsFilterArgsDict']]] = None,
                                     ipsec_id: Optional[str] = None,
                                     tunnel_id: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTunnelSecurityAssociationsResult:
    """
    This data source provides the list of Tunnel Security Associations in Oracle Cloud Infrastructure Core service.

    Lists the tunnel security associations information for the specified IPSec tunnel ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tunnel_security_associations = oci.Core.get_tunnel_security_associations(ipsec_id=test_ipsec["id"],
        tunnel_id=test_tunnel["id"])
    ```


    :param str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    :param str tunnel_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tunnel.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipsecId'] = ipsec_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getTunnelSecurityAssociations:getTunnelSecurityAssociations', __args__, opts=opts, typ=GetTunnelSecurityAssociationsResult).value

    return AwaitableGetTunnelSecurityAssociationsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipsec_id=pulumi.get(__ret__, 'ipsec_id'),
        tunnel_id=pulumi.get(__ret__, 'tunnel_id'),
        tunnel_security_associations=pulumi.get(__ret__, 'tunnel_security_associations'))
def get_tunnel_security_associations_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTunnelSecurityAssociationsFilterArgs', 'GetTunnelSecurityAssociationsFilterArgsDict']]]]] = None,
                                            ipsec_id: Optional[pulumi.Input[str]] = None,
                                            tunnel_id: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTunnelSecurityAssociationsResult]:
    """
    This data source provides the list of Tunnel Security Associations in Oracle Cloud Infrastructure Core service.

    Lists the tunnel security associations information for the specified IPSec tunnel ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_tunnel_security_associations = oci.Core.get_tunnel_security_associations(ipsec_id=test_ipsec["id"],
        tunnel_id=test_tunnel["id"])
    ```


    :param str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    :param str tunnel_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tunnel.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipsecId'] = ipsec_id
    __args__['tunnelId'] = tunnel_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getTunnelSecurityAssociations:getTunnelSecurityAssociations', __args__, opts=opts, typ=GetTunnelSecurityAssociationsResult)
    return __ret__.apply(lambda __response__: GetTunnelSecurityAssociationsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        ipsec_id=pulumi.get(__response__, 'ipsec_id'),
        tunnel_id=pulumi.get(__response__, 'tunnel_id'),
        tunnel_security_associations=pulumi.get(__response__, 'tunnel_security_associations')))
