# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExadataInfrastructureStorageArgs', 'ExadataInfrastructureStorage']

@pulumi.input_type
class ExadataInfrastructureStorageArgs:
    def __init__(__self__, *,
                 admin_network_cidr: pulumi.Input[str],
                 cloud_control_plane_server1: pulumi.Input[str],
                 cloud_control_plane_server2: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 dns_servers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 gateway: pulumi.Input[str],
                 infini_band_network_cidr: pulumi.Input[str],
                 netmask: pulumi.Input[str],
                 ntp_servers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 shape: pulumi.Input[str],
                 time_zone: pulumi.Input[str],
                 activation_file: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureStorageContactArgs']]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['ExadataInfrastructureStorageMaintenanceWindowArgs']] = None,
                 storage_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ExadataInfrastructureStorage resource.
        """
        pulumi.set(__self__, "admin_network_cidr", admin_network_cidr)
        pulumi.set(__self__, "cloud_control_plane_server1", cloud_control_plane_server1)
        pulumi.set(__self__, "cloud_control_plane_server2", cloud_control_plane_server2)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "gateway", gateway)
        pulumi.set(__self__, "infini_band_network_cidr", infini_band_network_cidr)
        pulumi.set(__self__, "netmask", netmask)
        pulumi.set(__self__, "ntp_servers", ntp_servers)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "time_zone", time_zone)
        if activation_file is not None:
            pulumi.set(__self__, "activation_file", activation_file)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if corporate_proxy is not None:
            pulumi.set(__self__, "corporate_proxy", corporate_proxy)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> pulumi.Input[str]:
        return pulumi.get(self, "admin_network_cidr")

    @admin_network_cidr.setter
    def admin_network_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_network_cidr", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cloud_control_plane_server1")

    @cloud_control_plane_server1.setter
    def cloud_control_plane_server1(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_control_plane_server1", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cloud_control_plane_server2")

    @cloud_control_plane_server2.setter
    def cloud_control_plane_server2(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_control_plane_server2", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Input[str]:
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: pulumi.Input[str]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> pulumi.Input[str]:
        return pulumi.get(self, "infini_band_network_cidr")

    @infini_band_network_cidr.setter
    def infini_band_network_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "infini_band_network_cidr", value)

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Input[str]:
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: pulumi.Input[str]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        return pulumi.get(self, "ntp_servers")

    @ntp_servers.setter
    def ntp_servers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ntp_servers", value)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[str]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "activation_file")

    @activation_file.setter
    def activation_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_file", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureStorageContactArgs']]]]:
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureStorageContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "corporate_proxy")

    @corporate_proxy.setter
    def corporate_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corporate_proxy", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ExadataInfrastructureStorageMaintenanceWindowArgs']]:
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ExadataInfrastructureStorageMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)


@pulumi.input_type
class _ExadataInfrastructureStorageState:
    def __init__(__self__, *,
                 activated_storage_count: Optional[pulumi.Input[int]] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 additional_storage_count: Optional[pulumi.Input[int]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureStorageContactArgs']]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 cpus_enabled: Optional[pulumi.Input[int]] = None,
                 csi_number: Optional[pulumi.Input[str]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_slo_status: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input['ExadataInfrastructureStorageMaintenanceWindowArgs']] = None,
                 max_cpu_count: Optional[pulumi.Input[int]] = None,
                 max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
                 max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
                 max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExadataInfrastructureStorage resources.
        """
        if activated_storage_count is not None:
            pulumi.set(__self__, "activated_storage_count", activated_storage_count)
        if activation_file is not None:
            pulumi.set(__self__, "activation_file", activation_file)
        if additional_storage_count is not None:
            pulumi.set(__self__, "additional_storage_count", additional_storage_count)
        if admin_network_cidr is not None:
            pulumi.set(__self__, "admin_network_cidr", admin_network_cidr)
        if cloud_control_plane_server1 is not None:
            pulumi.set(__self__, "cloud_control_plane_server1", cloud_control_plane_server1)
        if cloud_control_plane_server2 is not None:
            pulumi.set(__self__, "cloud_control_plane_server2", cloud_control_plane_server2)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_count is not None:
            pulumi.set(__self__, "compute_count", compute_count)
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if corporate_proxy is not None:
            pulumi.set(__self__, "corporate_proxy", corporate_proxy)
        if cpus_enabled is not None:
            pulumi.set(__self__, "cpus_enabled", cpus_enabled)
        if csi_number is not None:
            pulumi.set(__self__, "csi_number", csi_number)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if infini_band_network_cidr is not None:
            pulumi.set(__self__, "infini_band_network_cidr", infini_band_network_cidr)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_slo_status is not None:
            pulumi.set(__self__, "maintenance_slo_status", maintenance_slo_status)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if max_cpu_count is not None:
            pulumi.set(__self__, "max_cpu_count", max_cpu_count)
        if max_data_storage_in_tbs is not None:
            pulumi.set(__self__, "max_data_storage_in_tbs", max_data_storage_in_tbs)
        if max_db_node_storage_in_gbs is not None:
            pulumi.set(__self__, "max_db_node_storage_in_gbs", max_db_node_storage_in_gbs)
        if max_memory_in_gbs is not None:
            pulumi.set(__self__, "max_memory_in_gbs", max_memory_in_gbs)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if ntp_servers is not None:
            pulumi.set(__self__, "ntp_servers", ntp_servers)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_count is not None:
            pulumi.set(__self__, "storage_count", storage_count)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "activated_storage_count")

    @activated_storage_count.setter
    def activated_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "activated_storage_count", value)

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "activation_file")

    @activation_file.setter
    def activation_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_file", value)

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "additional_storage_count")

    @additional_storage_count.setter
    def additional_storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "additional_storage_count", value)

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "admin_network_cidr")

    @admin_network_cidr.setter
    def admin_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_network_cidr", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_control_plane_server1")

    @cloud_control_plane_server1.setter
    def cloud_control_plane_server1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server1", value)

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_control_plane_server2")

    @cloud_control_plane_server2.setter
    def cloud_control_plane_server2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_control_plane_server2", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "compute_count")

    @compute_count.setter
    def compute_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compute_count", value)

    @property
    @pulumi.getter
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureStorageContactArgs']]]]:
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExadataInfrastructureStorageContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "corporate_proxy")

    @corporate_proxy.setter
    def corporate_proxy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "corporate_proxy", value)

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cpus_enabled")

    @cpus_enabled.setter
    def cpus_enabled(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpus_enabled", value)

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "csi_number")

    @csi_number.setter
    def csi_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csi_number", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "infini_band_network_cidr")

    @infini_band_network_cidr.setter
    def infini_band_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infini_band_network_cidr", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "maintenance_slo_status")

    @maintenance_slo_status.setter
    def maintenance_slo_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_slo_status", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['ExadataInfrastructureStorageMaintenanceWindowArgs']]:
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['ExadataInfrastructureStorageMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_cpu_count")

    @max_cpu_count.setter
    def max_cpu_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_cpu_count", value)

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "max_data_storage_in_tbs")

    @max_data_storage_in_tbs.setter
    def max_data_storage_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_data_storage_in_tbs", value)

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @max_db_node_storage_in_gbs.setter
    def max_db_node_storage_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_db_node_storage_in_gbs", value)

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_memory_in_gbs")

    @max_memory_in_gbs.setter
    def max_memory_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_memory_in_gbs", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmask", value)

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "ntp_servers")

    @ntp_servers.setter
    def ntp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ntp_servers", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "storage_count")

    @storage_count.setter
    def storage_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_count", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


class ExadataInfrastructureStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureStorageContactArgs', 'ExadataInfrastructureStorageContactArgsDict']]]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['ExadataInfrastructureStorageMaintenanceWindowArgs', 'ExadataInfrastructureStorageMaintenanceWindowArgsDict']]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a ExadataInfrastructureStorage resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExadataInfrastructureStorageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ExadataInfrastructureStorage resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ExadataInfrastructureStorageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExadataInfrastructureStorageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activation_file: Optional[pulumi.Input[str]] = None,
                 admin_network_cidr: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
                 cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_count: Optional[pulumi.Input[int]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureStorageContactArgs', 'ExadataInfrastructureStorageContactArgsDict']]]]] = None,
                 corporate_proxy: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gateway: Optional[pulumi.Input[str]] = None,
                 infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['ExadataInfrastructureStorageMaintenanceWindowArgs', 'ExadataInfrastructureStorageMaintenanceWindowArgsDict']]] = None,
                 netmask: Optional[pulumi.Input[str]] = None,
                 ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_count: Optional[pulumi.Input[int]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExadataInfrastructureStorageArgs.__new__(ExadataInfrastructureStorageArgs)

            __props__.__dict__["activation_file"] = activation_file
            if admin_network_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'admin_network_cidr'")
            __props__.__dict__["admin_network_cidr"] = admin_network_cidr
            if cloud_control_plane_server1 is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_control_plane_server1'")
            __props__.__dict__["cloud_control_plane_server1"] = cloud_control_plane_server1
            if cloud_control_plane_server2 is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_control_plane_server2'")
            __props__.__dict__["cloud_control_plane_server2"] = cloud_control_plane_server2
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_count"] = compute_count
            __props__.__dict__["contacts"] = contacts
            __props__.__dict__["corporate_proxy"] = corporate_proxy
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if dns_servers is None and not opts.urn:
                raise TypeError("Missing required property 'dns_servers'")
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if gateway is None and not opts.urn:
                raise TypeError("Missing required property 'gateway'")
            __props__.__dict__["gateway"] = gateway
            if infini_band_network_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'infini_band_network_cidr'")
            __props__.__dict__["infini_band_network_cidr"] = infini_band_network_cidr
            __props__.__dict__["maintenance_window"] = maintenance_window
            if netmask is None and not opts.urn:
                raise TypeError("Missing required property 'netmask'")
            __props__.__dict__["netmask"] = netmask
            if ntp_servers is None and not opts.urn:
                raise TypeError("Missing required property 'ntp_servers'")
            __props__.__dict__["ntp_servers"] = ntp_servers
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["storage_count"] = storage_count
            if time_zone is None and not opts.urn:
                raise TypeError("Missing required property 'time_zone'")
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["activated_storage_count"] = None
            __props__.__dict__["additional_storage_count"] = None
            __props__.__dict__["cpus_enabled"] = None
            __props__.__dict__["csi_number"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_slo_status"] = None
            __props__.__dict__["max_cpu_count"] = None
            __props__.__dict__["max_data_storage_in_tbs"] = None
            __props__.__dict__["max_db_node_storage_in_gbs"] = None
            __props__.__dict__["max_memory_in_gbs"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(ExadataInfrastructureStorage, __self__).__init__(
            'oci:Database/exadataInfrastructureStorage:ExadataInfrastructureStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activated_storage_count: Optional[pulumi.Input[int]] = None,
            activation_file: Optional[pulumi.Input[str]] = None,
            additional_storage_count: Optional[pulumi.Input[int]] = None,
            admin_network_cidr: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server1: Optional[pulumi.Input[str]] = None,
            cloud_control_plane_server2: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_count: Optional[pulumi.Input[int]] = None,
            contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExadataInfrastructureStorageContactArgs', 'ExadataInfrastructureStorageContactArgsDict']]]]] = None,
            corporate_proxy: Optional[pulumi.Input[str]] = None,
            cpus_enabled: Optional[pulumi.Input[int]] = None,
            csi_number: Optional[pulumi.Input[str]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            gateway: Optional[pulumi.Input[str]] = None,
            infini_band_network_cidr: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_slo_status: Optional[pulumi.Input[str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['ExadataInfrastructureStorageMaintenanceWindowArgs', 'ExadataInfrastructureStorageMaintenanceWindowArgsDict']]] = None,
            max_cpu_count: Optional[pulumi.Input[int]] = None,
            max_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
            max_db_node_storage_in_gbs: Optional[pulumi.Input[int]] = None,
            max_memory_in_gbs: Optional[pulumi.Input[int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            netmask: Optional[pulumi.Input[str]] = None,
            ntp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_count: Optional[pulumi.Input[int]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None) -> 'ExadataInfrastructureStorage':
        """
        Get an existing ExadataInfrastructureStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExadataInfrastructureStorageState.__new__(_ExadataInfrastructureStorageState)

        __props__.__dict__["activated_storage_count"] = activated_storage_count
        __props__.__dict__["activation_file"] = activation_file
        __props__.__dict__["additional_storage_count"] = additional_storage_count
        __props__.__dict__["admin_network_cidr"] = admin_network_cidr
        __props__.__dict__["cloud_control_plane_server1"] = cloud_control_plane_server1
        __props__.__dict__["cloud_control_plane_server2"] = cloud_control_plane_server2
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_count"] = compute_count
        __props__.__dict__["contacts"] = contacts
        __props__.__dict__["corporate_proxy"] = corporate_proxy
        __props__.__dict__["cpus_enabled"] = cpus_enabled
        __props__.__dict__["csi_number"] = csi_number
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["infini_band_network_cidr"] = infini_band_network_cidr
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_slo_status"] = maintenance_slo_status
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["max_cpu_count"] = max_cpu_count
        __props__.__dict__["max_data_storage_in_tbs"] = max_data_storage_in_tbs
        __props__.__dict__["max_db_node_storage_in_gbs"] = max_db_node_storage_in_gbs
        __props__.__dict__["max_memory_in_gbs"] = max_memory_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["netmask"] = netmask
        __props__.__dict__["ntp_servers"] = ntp_servers
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_count"] = storage_count
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        return ExadataInfrastructureStorage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activatedStorageCount")
    def activated_storage_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "activated_storage_count")

    @property
    @pulumi.getter(name="activationFile")
    def activation_file(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "activation_file")

    @property
    @pulumi.getter(name="additionalStorageCount")
    def additional_storage_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "additional_storage_count")

    @property
    @pulumi.getter(name="adminNetworkCidr")
    def admin_network_cidr(self) -> pulumi.Output[str]:
        return pulumi.get(self, "admin_network_cidr")

    @property
    @pulumi.getter(name="cloudControlPlaneServer1")
    def cloud_control_plane_server1(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cloud_control_plane_server1")

    @property
    @pulumi.getter(name="cloudControlPlaneServer2")
    def cloud_control_plane_server2(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cloud_control_plane_server2")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCount")
    def compute_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "compute_count")

    @property
    @pulumi.getter
    def contacts(self) -> pulumi.Output[Optional[Sequence['outputs.ExadataInfrastructureStorageContact']]]:
        return pulumi.get(self, "contacts")

    @property
    @pulumi.getter(name="corporateProxy")
    def corporate_proxy(self) -> pulumi.Output[str]:
        return pulumi.get(self, "corporate_proxy")

    @property
    @pulumi.getter(name="cpusEnabled")
    def cpus_enabled(self) -> pulumi.Output[int]:
        return pulumi.get(self, "cpus_enabled")

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> pulumi.Output[str]:
        return pulumi.get(self, "csi_number")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[str]:
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter(name="infiniBandNetworkCidr")
    def infini_band_network_cidr(self) -> pulumi.Output[str]:
        return pulumi.get(self, "infini_band_network_cidr")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceSloStatus")
    def maintenance_slo_status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "maintenance_slo_status")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.ExadataInfrastructureStorageMaintenanceWindow']:
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="maxCpuCount")
    def max_cpu_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "max_cpu_count")

    @property
    @pulumi.getter(name="maxDataStorageInTbs")
    def max_data_storage_in_tbs(self) -> pulumi.Output[float]:
        return pulumi.get(self, "max_data_storage_in_tbs")

    @property
    @pulumi.getter(name="maxDbNodeStorageInGbs")
    def max_db_node_storage_in_gbs(self) -> pulumi.Output[int]:
        return pulumi.get(self, "max_db_node_storage_in_gbs")

    @property
    @pulumi.getter(name="maxMemoryInGbs")
    def max_memory_in_gbs(self) -> pulumi.Output[int]:
        return pulumi.get(self, "max_memory_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter
    def netmask(self) -> pulumi.Output[str]:
        return pulumi.get(self, "netmask")

    @property
    @pulumi.getter(name="ntpServers")
    def ntp_servers(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "ntp_servers")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageCount")
    def storage_count(self) -> pulumi.Output[int]:
        return pulumi.get(self, "storage_count")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        return pulumi.get(self, "time_zone")

