# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ExternalPluggableDatabaseOperationsInsightsManagementArgs', 'ExternalPluggableDatabaseOperationsInsightsManagement']

@pulumi.input_type
class ExternalPluggableDatabaseOperationsInsightsManagementArgs:
    def __init__(__self__, *,
                 enable_operations_insights: pulumi.Input[bool],
                 external_database_connector_id: pulumi.Input[str],
                 external_pluggable_database_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ExternalPluggableDatabaseOperationsInsightsManagement resource.
        :param pulumi.Input[bool] enable_operations_insights: (Updatable) Enabling OPSI on External Pluggable Databases . Requires boolean value "true" or "false". 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] external_pluggable_database_id: The ExternalPluggableDatabaseId [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        pulumi.set(__self__, "enable_operations_insights", enable_operations_insights)
        pulumi.set(__self__, "external_database_connector_id", external_database_connector_id)
        pulumi.set(__self__, "external_pluggable_database_id", external_pluggable_database_id)

    @property
    @pulumi.getter(name="enableOperationsInsights")
    def enable_operations_insights(self) -> pulumi.Input[bool]:
        """
        (Updatable) Enabling OPSI on External Pluggable Databases . Requires boolean value "true" or "false". 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_operations_insights")

    @enable_operations_insights.setter
    def enable_operations_insights(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_operations_insights", value)

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_database_connector_id", value)

    @property
    @pulumi.getter(name="externalPluggableDatabaseId")
    def external_pluggable_database_id(self) -> pulumi.Input[str]:
        """
        The ExternalPluggableDatabaseId [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_pluggable_database_id")

    @external_pluggable_database_id.setter
    def external_pluggable_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "external_pluggable_database_id", value)


@pulumi.input_type
class _ExternalPluggableDatabaseOperationsInsightsManagementState:
    def __init__(__self__, *,
                 enable_operations_insights: Optional[pulumi.Input[bool]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 external_pluggable_database_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExternalPluggableDatabaseOperationsInsightsManagement resources.
        :param pulumi.Input[bool] enable_operations_insights: (Updatable) Enabling OPSI on External Pluggable Databases . Requires boolean value "true" or "false". 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] external_pluggable_database_id: The ExternalPluggableDatabaseId [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        if enable_operations_insights is not None:
            pulumi.set(__self__, "enable_operations_insights", enable_operations_insights)
        if external_database_connector_id is not None:
            pulumi.set(__self__, "external_database_connector_id", external_database_connector_id)
        if external_pluggable_database_id is not None:
            pulumi.set(__self__, "external_pluggable_database_id", external_pluggable_database_id)

    @property
    @pulumi.getter(name="enableOperationsInsights")
    def enable_operations_insights(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Enabling OPSI on External Pluggable Databases . Requires boolean value "true" or "false". 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_operations_insights")

    @enable_operations_insights.setter
    def enable_operations_insights(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_operations_insights", value)

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @external_database_connector_id.setter
    def external_database_connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_database_connector_id", value)

    @property
    @pulumi.getter(name="externalPluggableDatabaseId")
    def external_pluggable_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ExternalPluggableDatabaseId [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_pluggable_database_id")

    @external_pluggable_database_id.setter
    def external_pluggable_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_pluggable_database_id", value)


class ExternalPluggableDatabaseOperationsInsightsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_operations_insights: Optional[pulumi.Input[bool]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 external_pluggable_database_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the External Pluggable Database Operations Insights Management resource in Oracle Cloud Infrastructure Database service.

        Enable Operations Insights for the external pluggable database.
        When deleting this resource block , we call disable if it was in enabled state .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_pluggable_database_operations_insights_management = oci.database.ExternalPluggableDatabaseOperationsInsightsManagement("test_external_pluggable_database_operations_insights_management",
            external_database_connector_id=test_external_database_connector["id"],
            external_pluggable_database_id=test_external_pluggable_database["id"],
            enable_operations_insights=True)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_operations_insights: (Updatable) Enabling OPSI on External Pluggable Databases . Requires boolean value "true" or "false". 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] external_pluggable_database_id: The ExternalPluggableDatabaseId [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalPluggableDatabaseOperationsInsightsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the External Pluggable Database Operations Insights Management resource in Oracle Cloud Infrastructure Database service.

        Enable Operations Insights for the external pluggable database.
        When deleting this resource block , we call disable if it was in enabled state .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_external_pluggable_database_operations_insights_management = oci.database.ExternalPluggableDatabaseOperationsInsightsManagement("test_external_pluggable_database_operations_insights_management",
            external_database_connector_id=test_external_database_connector["id"],
            external_pluggable_database_id=test_external_pluggable_database["id"],
            enable_operations_insights=True)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ExternalPluggableDatabaseOperationsInsightsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalPluggableDatabaseOperationsInsightsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_operations_insights: Optional[pulumi.Input[bool]] = None,
                 external_database_connector_id: Optional[pulumi.Input[str]] = None,
                 external_pluggable_database_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalPluggableDatabaseOperationsInsightsManagementArgs.__new__(ExternalPluggableDatabaseOperationsInsightsManagementArgs)

            if enable_operations_insights is None and not opts.urn:
                raise TypeError("Missing required property 'enable_operations_insights'")
            __props__.__dict__["enable_operations_insights"] = enable_operations_insights
            if external_database_connector_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_database_connector_id'")
            __props__.__dict__["external_database_connector_id"] = external_database_connector_id
            if external_pluggable_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'external_pluggable_database_id'")
            __props__.__dict__["external_pluggable_database_id"] = external_pluggable_database_id
        super(ExternalPluggableDatabaseOperationsInsightsManagement, __self__).__init__(
            'oci:Database/externalPluggableDatabaseOperationsInsightsManagement:ExternalPluggableDatabaseOperationsInsightsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_operations_insights: Optional[pulumi.Input[bool]] = None,
            external_database_connector_id: Optional[pulumi.Input[str]] = None,
            external_pluggable_database_id: Optional[pulumi.Input[str]] = None) -> 'ExternalPluggableDatabaseOperationsInsightsManagement':
        """
        Get an existing ExternalPluggableDatabaseOperationsInsightsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_operations_insights: (Updatable) Enabling OPSI on External Pluggable Databases . Requires boolean value "true" or "false". 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] external_database_connector_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        :param pulumi.Input[str] external_pluggable_database_id: The ExternalPluggableDatabaseId [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalPluggableDatabaseOperationsInsightsManagementState.__new__(_ExternalPluggableDatabaseOperationsInsightsManagementState)

        __props__.__dict__["enable_operations_insights"] = enable_operations_insights
        __props__.__dict__["external_database_connector_id"] = external_database_connector_id
        __props__.__dict__["external_pluggable_database_id"] = external_pluggable_database_id
        return ExternalPluggableDatabaseOperationsInsightsManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableOperationsInsights")
    def enable_operations_insights(self) -> pulumi.Output[bool]:
        """
        (Updatable) Enabling OPSI on External Pluggable Databases . Requires boolean value "true" or "false". 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_operations_insights")

    @property
    @pulumi.getter(name="externalDatabaseConnectorId")
    def external_database_connector_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [external database connector](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/datatypes/CreateExternalDatabaseConnectorDetails).
        """
        return pulumi.get(self, "external_database_connector_id")

    @property
    @pulumi.getter(name="externalPluggableDatabaseId")
    def external_pluggable_database_id(self) -> pulumi.Output[str]:
        """
        The ExternalPluggableDatabaseId [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "external_pluggable_database_id")

