# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousVirtualMachinesResult',
    'AwaitableGetAutonomousVirtualMachinesResult',
    'get_autonomous_virtual_machines',
    'get_autonomous_virtual_machines_output',
]

@pulumi.output_type
class GetAutonomousVirtualMachinesResult:
    """
    A collection of values returned by getAutonomousVirtualMachines.
    """
    def __init__(__self__, autonomous_virtual_machines=None, autonomous_vm_cluster_id=None, compartment_id=None, filters=None, id=None, state=None):
        if autonomous_virtual_machines and not isinstance(autonomous_virtual_machines, list):
            raise TypeError("Expected argument 'autonomous_virtual_machines' to be a list")
        pulumi.set(__self__, "autonomous_virtual_machines", autonomous_virtual_machines)
        if autonomous_vm_cluster_id and not isinstance(autonomous_vm_cluster_id, str):
            raise TypeError("Expected argument 'autonomous_vm_cluster_id' to be a str")
        pulumi.set(__self__, "autonomous_vm_cluster_id", autonomous_vm_cluster_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autonomousVirtualMachines")
    def autonomous_virtual_machines(self) -> Sequence['outputs.GetAutonomousVirtualMachinesAutonomousVirtualMachineResult']:
        """
        The list of autonomous_virtual_machines.
        """
        return pulumi.get(self, "autonomous_virtual_machines")

    @property
    @pulumi.getter(name="autonomousVmClusterId")
    def autonomous_vm_cluster_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Autonomous VM Cluster associated with the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "autonomous_vm_cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousVirtualMachinesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Autonomous Virtual Machine.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousVirtualMachinesResult(GetAutonomousVirtualMachinesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousVirtualMachinesResult(
            autonomous_virtual_machines=self.autonomous_virtual_machines,
            autonomous_vm_cluster_id=self.autonomous_vm_cluster_id,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_autonomous_virtual_machines(autonomous_vm_cluster_id: Optional[str] = None,
                                    compartment_id: Optional[str] = None,
                                    filters: Optional[Sequence[Union['GetAutonomousVirtualMachinesFilterArgs', 'GetAutonomousVirtualMachinesFilterArgsDict']]] = None,
                                    state: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousVirtualMachinesResult:
    """
    This data source provides the list of Autonomous Virtual Machines in Oracle Cloud Infrastructure Database service.

    Lists the Autonomous Virtual Machines in the specified Autonomous VM Cluster and Compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_virtual_machines = oci.Database.get_autonomous_virtual_machines(autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
        compartment_id=compartment_id,
        state=autonomous_virtual_machine_state)
    ```


    :param str autonomous_vm_cluster_id: The Autonomous Virtual machine [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousVmClusterId'] = autonomous_vm_cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousVirtualMachines:getAutonomousVirtualMachines', __args__, opts=opts, typ=GetAutonomousVirtualMachinesResult).value

    return AwaitableGetAutonomousVirtualMachinesResult(
        autonomous_virtual_machines=pulumi.get(__ret__, 'autonomous_virtual_machines'),
        autonomous_vm_cluster_id=pulumi.get(__ret__, 'autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_autonomous_virtual_machines_output(autonomous_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                           compartment_id: Optional[pulumi.Input[str]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousVirtualMachinesFilterArgs', 'GetAutonomousVirtualMachinesFilterArgsDict']]]]] = None,
                                           state: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAutonomousVirtualMachinesResult]:
    """
    This data source provides the list of Autonomous Virtual Machines in Oracle Cloud Infrastructure Database service.

    Lists the Autonomous Virtual Machines in the specified Autonomous VM Cluster and Compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_virtual_machines = oci.Database.get_autonomous_virtual_machines(autonomous_vm_cluster_id=test_autonomous_vm_cluster["id"],
        compartment_id=compartment_id,
        state=autonomous_virtual_machine_state)
    ```


    :param str autonomous_vm_cluster_id: The Autonomous Virtual machine [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousVmClusterId'] = autonomous_vm_cluster_id
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getAutonomousVirtualMachines:getAutonomousVirtualMachines', __args__, opts=opts, typ=GetAutonomousVirtualMachinesResult)
    return __ret__.apply(lambda __response__: GetAutonomousVirtualMachinesResult(
        autonomous_virtual_machines=pulumi.get(__response__, 'autonomous_virtual_machines'),
        autonomous_vm_cluster_id=pulumi.get(__response__, 'autonomous_vm_cluster_id'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
