# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalExadataStorageServersResult',
    'AwaitableGetExternalExadataStorageServersResult',
    'get_external_exadata_storage_servers',
    'get_external_exadata_storage_servers_output',
]

@pulumi.output_type
class GetExternalExadataStorageServersResult:
    """
    A collection of values returned by getExternalExadataStorageServers.
    """
    def __init__(__self__, compartment_id=None, display_name=None, external_exadata_infrastructure_id=None, external_exadata_storage_server_collections=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if external_exadata_infrastructure_id and not isinstance(external_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'external_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "external_exadata_infrastructure_id", external_exadata_infrastructure_id)
        if external_exadata_storage_server_collections and not isinstance(external_exadata_storage_server_collections, list):
            raise TypeError("Expected argument 'external_exadata_storage_server_collections' to be a list")
        pulumi.set(__self__, "external_exadata_storage_server_collections", external_exadata_storage_server_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The name of the Exadata resource. English letters, numbers, "-", "_" and "." only.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalExadataInfrastructureId")
    def external_exadata_infrastructure_id(self) -> str:
        return pulumi.get(self, "external_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="externalExadataStorageServerCollections")
    def external_exadata_storage_server_collections(self) -> Sequence['outputs.GetExternalExadataStorageServersExternalExadataStorageServerCollectionResult']:
        """
        The list of external_exadata_storage_server_collection.
        """
        return pulumi.get(self, "external_exadata_storage_server_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExternalExadataStorageServersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetExternalExadataStorageServersResult(GetExternalExadataStorageServersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataStorageServersResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            external_exadata_infrastructure_id=self.external_exadata_infrastructure_id,
            external_exadata_storage_server_collections=self.external_exadata_storage_server_collections,
            filters=self.filters,
            id=self.id)


def get_external_exadata_storage_servers(compartment_id: Optional[str] = None,
                                         display_name: Optional[str] = None,
                                         external_exadata_infrastructure_id: Optional[str] = None,
                                         filters: Optional[Sequence[Union['GetExternalExadataStorageServersFilterArgs', 'GetExternalExadataStorageServersFilterArgsDict']]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataStorageServersResult:
    """
    This data source provides the list of External Exadata Storage Servers in Oracle Cloud Infrastructure Database Management service.

    Lists the Exadata storage servers for the specified Exadata infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_servers = oci.DatabaseManagement.get_external_exadata_storage_servers(compartment_id=compartment_id,
        external_exadata_infrastructure_id=test_external_exadata_infrastructure["id"],
        display_name=external_exadata_storage_server_display_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: The optional single value query filter parameter on the entity display name.
    :param str external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['externalExadataInfrastructureId'] = external_exadata_infrastructure_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataStorageServers:getExternalExadataStorageServers', __args__, opts=opts, typ=GetExternalExadataStorageServersResult).value

    return AwaitableGetExternalExadataStorageServersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        external_exadata_infrastructure_id=pulumi.get(__ret__, 'external_exadata_infrastructure_id'),
        external_exadata_storage_server_collections=pulumi.get(__ret__, 'external_exadata_storage_server_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_external_exadata_storage_servers_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                external_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExternalExadataStorageServersFilterArgs', 'GetExternalExadataStorageServersFilterArgsDict']]]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalExadataStorageServersResult]:
    """
    This data source provides the list of External Exadata Storage Servers in Oracle Cloud Infrastructure Database Management service.

    Lists the Exadata storage servers for the specified Exadata infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_servers = oci.DatabaseManagement.get_external_exadata_storage_servers(compartment_id=compartment_id,
        external_exadata_infrastructure_id=test_external_exadata_infrastructure["id"],
        display_name=external_exadata_storage_server_display_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: The optional single value query filter parameter on the entity display name.
    :param str external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['externalExadataInfrastructureId'] = external_exadata_infrastructure_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalExadataStorageServers:getExternalExadataStorageServers', __args__, opts=opts, typ=GetExternalExadataStorageServersResult)
    return __ret__.apply(lambda __response__: GetExternalExadataStorageServersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        external_exadata_infrastructure_id=pulumi.get(__response__, 'external_exadata_infrastructure_id'),
        external_exadata_storage_server_collections=pulumi.get(__response__, 'external_exadata_storage_server_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
