# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDataSafePrivateEndpointResult',
    'AwaitableGetDataSafePrivateEndpointResult',
    'get_data_safe_private_endpoint',
    'get_data_safe_private_endpoint_output',
]

@pulumi.output_type
class GetDataSafePrivateEndpointResult:
    """
    A collection of values returned by getDataSafePrivateEndpoint.
    """
    def __init__(__self__, compartment_id=None, data_safe_private_endpoint_id=None, defined_tags=None, description=None, display_name=None, endpoint_fqdn=None, freeform_tags=None, id=None, nsg_ids=None, private_endpoint_id=None, private_endpoint_ip=None, state=None, subnet_id=None, system_tags=None, time_created=None, vcn_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_safe_private_endpoint_id and not isinstance(data_safe_private_endpoint_id, str):
            raise TypeError("Expected argument 'data_safe_private_endpoint_id' to be a str")
        pulumi.set(__self__, "data_safe_private_endpoint_id", data_safe_private_endpoint_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoint_fqdn and not isinstance(endpoint_fqdn, str):
            raise TypeError("Expected argument 'endpoint_fqdn' to be a str")
        pulumi.set(__self__, "endpoint_fqdn", endpoint_fqdn)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if private_endpoint_id and not isinstance(private_endpoint_id, str):
            raise TypeError("Expected argument 'private_endpoint_id' to be a str")
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if private_endpoint_ip and not isinstance(private_endpoint_ip, str):
            raise TypeError("Expected argument 'private_endpoint_ip' to be a str")
        pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if vcn_id and not isinstance(vcn_id, str):
            raise TypeError("Expected argument 'vcn_id' to be a str")
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSafePrivateEndpointId")
    def data_safe_private_endpoint_id(self) -> str:
        return pulumi.get(self, "data_safe_private_endpoint_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the private endpoint.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointFqdn")
    def endpoint_fqdn(self) -> str:
        """
        The three-label fully qualified domain name (FQDN) of the private endpoint. The customer VCN's DNS records are updated with this FQDN.
        """
        return pulumi.get(self, "endpoint_fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the Data Safe private endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The OCIDs of the network security groups that the private endpoint belongs to.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        """
        The OCID of the underlying private endpoint.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> str:
        """
        The private IP address of the private endpoint.
        """
        return pulumi.get(self, "private_endpoint_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the private endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the private endpoint was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the VCN.
        """
        return pulumi.get(self, "vcn_id")


class AwaitableGetDataSafePrivateEndpointResult(GetDataSafePrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSafePrivateEndpointResult(
            compartment_id=self.compartment_id,
            data_safe_private_endpoint_id=self.data_safe_private_endpoint_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            endpoint_fqdn=self.endpoint_fqdn,
            freeform_tags=self.freeform_tags,
            id=self.id,
            nsg_ids=self.nsg_ids,
            private_endpoint_id=self.private_endpoint_id,
            private_endpoint_ip=self.private_endpoint_ip,
            state=self.state,
            subnet_id=self.subnet_id,
            system_tags=self.system_tags,
            time_created=self.time_created,
            vcn_id=self.vcn_id)


def get_data_safe_private_endpoint(data_safe_private_endpoint_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSafePrivateEndpointResult:
    """
    This data source provides details about a specific Data Safe Private Endpoint resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified Data Safe private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_safe_private_endpoint = oci.DataSafe.get_data_safe_private_endpoint(data_safe_private_endpoint_id=test_data_safe_private_endpoint_oci_data_safe_data_safe_private_endpoint["id"])
    ```


    :param str data_safe_private_endpoint_id: The OCID of the private endpoint.
    """
    __args__ = dict()
    __args__['dataSafePrivateEndpointId'] = data_safe_private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getDataSafePrivateEndpoint:getDataSafePrivateEndpoint', __args__, opts=opts, typ=GetDataSafePrivateEndpointResult).value

    return AwaitableGetDataSafePrivateEndpointResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_safe_private_endpoint_id=pulumi.get(__ret__, 'data_safe_private_endpoint_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoint_fqdn=pulumi.get(__ret__, 'endpoint_fqdn'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        private_endpoint_id=pulumi.get(__ret__, 'private_endpoint_id'),
        private_endpoint_ip=pulumi.get(__ret__, 'private_endpoint_ip'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        vcn_id=pulumi.get(__ret__, 'vcn_id'))
def get_data_safe_private_endpoint_output(data_safe_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataSafePrivateEndpointResult]:
    """
    This data source provides details about a specific Data Safe Private Endpoint resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified Data Safe private endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_safe_private_endpoint = oci.DataSafe.get_data_safe_private_endpoint(data_safe_private_endpoint_id=test_data_safe_private_endpoint_oci_data_safe_data_safe_private_endpoint["id"])
    ```


    :param str data_safe_private_endpoint_id: The OCID of the private endpoint.
    """
    __args__ = dict()
    __args__['dataSafePrivateEndpointId'] = data_safe_private_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getDataSafePrivateEndpoint:getDataSafePrivateEndpoint', __args__, opts=opts, typ=GetDataSafePrivateEndpointResult)
    return __ret__.apply(lambda __response__: GetDataSafePrivateEndpointResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_safe_private_endpoint_id=pulumi.get(__response__, 'data_safe_private_endpoint_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        endpoint_fqdn=pulumi.get(__response__, 'endpoint_fqdn'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        nsg_ids=pulumi.get(__response__, 'nsg_ids'),
        private_endpoint_id=pulumi.get(__response__, 'private_endpoint_id'),
        private_endpoint_ip=pulumi.get(__response__, 'private_endpoint_ip'),
        state=pulumi.get(__response__, 'state'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        vcn_id=pulumi.get(__response__, 'vcn_id')))
