# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecurityAssessmentComparisonResult',
    'AwaitableGetSecurityAssessmentComparisonResult',
    'get_security_assessment_comparison',
    'get_security_assessment_comparison_output',
]

@pulumi.output_type
class GetSecurityAssessmentComparisonResult:
    """
    A collection of values returned by getSecurityAssessmentComparison.
    """
    def __init__(__self__, baseline_id=None, comparison_security_assessment_id=None, id=None, security_assessment_id=None, state=None, targets=None, time_created=None):
        if baseline_id and not isinstance(baseline_id, str):
            raise TypeError("Expected argument 'baseline_id' to be a str")
        pulumi.set(__self__, "baseline_id", baseline_id)
        if comparison_security_assessment_id and not isinstance(comparison_security_assessment_id, str):
            raise TypeError("Expected argument 'comparison_security_assessment_id' to be a str")
        pulumi.set(__self__, "comparison_security_assessment_id", comparison_security_assessment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_assessment_id and not isinstance(security_assessment_id, str):
            raise TypeError("Expected argument 'security_assessment_id' to be a str")
        pulumi.set(__self__, "security_assessment_id", security_assessment_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="baselineId")
    def baseline_id(self) -> str:
        """
        The OCID of the security assessment that is set as a baseline.
        """
        return pulumi.get(self, "baseline_id")

    @property
    @pulumi.getter(name="comparisonSecurityAssessmentId")
    def comparison_security_assessment_id(self) -> str:
        return pulumi.get(self, "comparison_security_assessment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityAssessmentId")
    def security_assessment_id(self) -> str:
        return pulumi.get(self, "security_assessment_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the finding.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetSecurityAssessmentComparisonTargetResult']:
        """
        A target-based comparison between two security assessments.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time when the security assessment comparison was created. Conforms to the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")


class AwaitableGetSecurityAssessmentComparisonResult(GetSecurityAssessmentComparisonResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAssessmentComparisonResult(
            baseline_id=self.baseline_id,
            comparison_security_assessment_id=self.comparison_security_assessment_id,
            id=self.id,
            security_assessment_id=self.security_assessment_id,
            state=self.state,
            targets=self.targets,
            time_created=self.time_created)


def get_security_assessment_comparison(comparison_security_assessment_id: Optional[str] = None,
                                       security_assessment_id: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAssessmentComparisonResult:
    """
    This data source provides details about a specific Security Assessment Comparison resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the comparison report for the security assessments submitted for comparison.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_comparison = oci.DataSafe.get_security_assessment_comparison(comparison_security_assessment_id=test_security_assessment["id"],
        security_assessment_id=test_security_assessment["id"])
    ```


    :param str comparison_security_assessment_id: The OCID of the security assessment baseline.
    :param str security_assessment_id: The OCID of the security assessment.
    """
    __args__ = dict()
    __args__['comparisonSecurityAssessmentId'] = comparison_security_assessment_id
    __args__['securityAssessmentId'] = security_assessment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityAssessmentComparison:getSecurityAssessmentComparison', __args__, opts=opts, typ=GetSecurityAssessmentComparisonResult).value

    return AwaitableGetSecurityAssessmentComparisonResult(
        baseline_id=pulumi.get(__ret__, 'baseline_id'),
        comparison_security_assessment_id=pulumi.get(__ret__, 'comparison_security_assessment_id'),
        id=pulumi.get(__ret__, 'id'),
        security_assessment_id=pulumi.get(__ret__, 'security_assessment_id'),
        state=pulumi.get(__ret__, 'state'),
        targets=pulumi.get(__ret__, 'targets'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_security_assessment_comparison_output(comparison_security_assessment_id: Optional[pulumi.Input[str]] = None,
                                              security_assessment_id: Optional[pulumi.Input[str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityAssessmentComparisonResult]:
    """
    This data source provides details about a specific Security Assessment Comparison resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the comparison report for the security assessments submitted for comparison.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_comparison = oci.DataSafe.get_security_assessment_comparison(comparison_security_assessment_id=test_security_assessment["id"],
        security_assessment_id=test_security_assessment["id"])
    ```


    :param str comparison_security_assessment_id: The OCID of the security assessment baseline.
    :param str security_assessment_id: The OCID of the security assessment.
    """
    __args__ = dict()
    __args__['comparisonSecurityAssessmentId'] = comparison_security_assessment_id
    __args__['securityAssessmentId'] = security_assessment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityAssessmentComparison:getSecurityAssessmentComparison', __args__, opts=opts, typ=GetSecurityAssessmentComparisonResult)
    return __ret__.apply(lambda __response__: GetSecurityAssessmentComparisonResult(
        baseline_id=pulumi.get(__response__, 'baseline_id'),
        comparison_security_assessment_id=pulumi.get(__response__, 'comparison_security_assessment_id'),
        id=pulumi.get(__response__, 'id'),
        security_assessment_id=pulumi.get(__response__, 'security_assessment_id'),
        state=pulumi.get(__response__, 'state'),
        targets=pulumi.get(__response__, 'targets'),
        time_created=pulumi.get(__response__, 'time_created')))
