# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetModelDeploymentShapesResult',
    'AwaitableGetModelDeploymentShapesResult',
    'get_model_deployment_shapes',
    'get_model_deployment_shapes_output',
]

@pulumi.output_type
class GetModelDeploymentShapesResult:
    """
    A collection of values returned by getModelDeploymentShapes.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, model_deployment_shapes=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_deployment_shapes and not isinstance(model_deployment_shapes, list):
            raise TypeError("Expected argument 'model_deployment_shapes' to be a list")
        pulumi.set(__self__, "model_deployment_shapes", model_deployment_shapes)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetModelDeploymentShapesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modelDeploymentShapes")
    def model_deployment_shapes(self) -> Sequence['outputs.GetModelDeploymentShapesModelDeploymentShapeResult']:
        """
        The list of model_deployment_shapes.
        """
        return pulumi.get(self, "model_deployment_shapes")


class AwaitableGetModelDeploymentShapesResult(GetModelDeploymentShapesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelDeploymentShapesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            model_deployment_shapes=self.model_deployment_shapes)


def get_model_deployment_shapes(compartment_id: Optional[str] = None,
                                filters: Optional[Sequence[Union['GetModelDeploymentShapesFilterArgs', 'GetModelDeploymentShapesFilterArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelDeploymentShapesResult:
    """
    This data source provides the list of Model Deployment Shapes in Oracle Cloud Infrastructure Datascience service.

    Lists the valid model deployment shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_deployment_shapes = oci.DataScience.get_model_deployment_shapes(compartment_id=compartment_id)
    ```


    :param str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getModelDeploymentShapes:getModelDeploymentShapes', __args__, opts=opts, typ=GetModelDeploymentShapesResult).value

    return AwaitableGetModelDeploymentShapesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        model_deployment_shapes=pulumi.get(__ret__, 'model_deployment_shapes'))
def get_model_deployment_shapes_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetModelDeploymentShapesFilterArgs', 'GetModelDeploymentShapesFilterArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelDeploymentShapesResult]:
    """
    This data source provides the list of Model Deployment Shapes in Oracle Cloud Infrastructure Datascience service.

    Lists the valid model deployment shapes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model_deployment_shapes = oci.DataScience.get_model_deployment_shapes(compartment_id=compartment_id)
    ```


    :param str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getModelDeploymentShapes:getModelDeploymentShapes', __args__, opts=opts, typ=GetModelDeploymentShapesResult)
    return __ret__.apply(lambda __response__: GetModelDeploymentShapesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        model_deployment_shapes=pulumi.get(__response__, 'model_deployment_shapes')))
