# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServiceProvidersResult',
    'AwaitableGetServiceProvidersResult',
    'get_service_providers',
    'get_service_providers_output',
]

@pulumi.output_type
class GetServiceProvidersResult:
    """
    A collection of values returned by getServiceProviders.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, service_provider_summary_collections=None, service_provider_type=None, state=None, supported_resource_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_provider_summary_collections and not isinstance(service_provider_summary_collections, list):
            raise TypeError("Expected argument 'service_provider_summary_collections' to be a list")
        pulumi.set(__self__, "service_provider_summary_collections", service_provider_summary_collections)
        if service_provider_type and not isinstance(service_provider_type, str):
            raise TypeError("Expected argument 'service_provider_type' to be a str")
        pulumi.set(__self__, "service_provider_type", service_provider_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if supported_resource_type and not isinstance(supported_resource_type, str):
            raise TypeError("Expected argument 'supported_resource_type' to be a str")
        pulumi.set(__self__, "supported_resource_type", supported_resource_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the Delegation Control.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServiceProvidersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Unique name of the Service Provider.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceProviderSummaryCollections")
    def service_provider_summary_collections(self) -> Sequence['outputs.GetServiceProvidersServiceProviderSummaryCollectionResult']:
        """
        The list of service_provider_summary_collection.
        """
        return pulumi.get(self, "service_provider_summary_collections")

    @property
    @pulumi.getter(name="serviceProviderType")
    def service_provider_type(self) -> Optional[str]:
        """
        Service Provider type.
        """
        return pulumi.get(self, "service_provider_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the Service Provider.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportedResourceType")
    def supported_resource_type(self) -> Optional[str]:
        return pulumi.get(self, "supported_resource_type")


class AwaitableGetServiceProvidersResult(GetServiceProvidersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceProvidersResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            service_provider_summary_collections=self.service_provider_summary_collections,
            service_provider_type=self.service_provider_type,
            state=self.state,
            supported_resource_type=self.supported_resource_type)


def get_service_providers(compartment_id: Optional[str] = None,
                          filters: Optional[Sequence[Union['GetServiceProvidersFilterArgs', 'GetServiceProvidersFilterArgsDict']]] = None,
                          name: Optional[str] = None,
                          service_provider_type: Optional[str] = None,
                          state: Optional[str] = None,
                          supported_resource_type: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceProvidersResult:
    """
    This data source provides the list of Service Providers in Oracle Cloud Infrastructure Delegate Access Control service.

    Lists the Service Providers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_providers = oci.DelegateAccessControl.get_service_providers(compartment_id=compartment_id,
        name=service_provider_name,
        service_provider_type=service_provider_service_provider_type,
        state=service_provider_state,
        supported_resource_type=service_provider_supported_resource_type)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str name: A filter to return Service Provider resources that match the given name.
    :param str service_provider_type: A filter to return only Service Provider resources whose provider type matches the given provider type.
    :param str state: A filter to return only Service Provider resources whose lifecycleState matches the given Service Provider lifecycle state.
    :param str supported_resource_type: A filter to return only Service Provider resources whose supported resource type matches the given resource type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['serviceProviderType'] = service_provider_type
    __args__['state'] = state
    __args__['supportedResourceType'] = supported_resource_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getServiceProviders:getServiceProviders', __args__, opts=opts, typ=GetServiceProvidersResult).value

    return AwaitableGetServiceProvidersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        service_provider_summary_collections=pulumi.get(__ret__, 'service_provider_summary_collections'),
        service_provider_type=pulumi.get(__ret__, 'service_provider_type'),
        state=pulumi.get(__ret__, 'state'),
        supported_resource_type=pulumi.get(__ret__, 'supported_resource_type'))
def get_service_providers_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetServiceProvidersFilterArgs', 'GetServiceProvidersFilterArgsDict']]]]] = None,
                                 name: Optional[pulumi.Input[Optional[str]]] = None,
                                 service_provider_type: Optional[pulumi.Input[Optional[str]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 supported_resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceProvidersResult]:
    """
    This data source provides the list of Service Providers in Oracle Cloud Infrastructure Delegate Access Control service.

    Lists the Service Providers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_providers = oci.DelegateAccessControl.get_service_providers(compartment_id=compartment_id,
        name=service_provider_name,
        service_provider_type=service_provider_service_provider_type,
        state=service_provider_state,
        supported_resource_type=service_provider_supported_resource_type)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str name: A filter to return Service Provider resources that match the given name.
    :param str service_provider_type: A filter to return only Service Provider resources whose provider type matches the given provider type.
    :param str state: A filter to return only Service Provider resources whose lifecycleState matches the given Service Provider lifecycle state.
    :param str supported_resource_type: A filter to return only Service Provider resources whose supported resource type matches the given resource type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['serviceProviderType'] = service_provider_type
    __args__['state'] = state
    __args__['supportedResourceType'] = supported_resource_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DelegateAccessControl/getServiceProviders:getServiceProviders', __args__, opts=opts, typ=GetServiceProvidersResult)
    return __ret__.apply(lambda __response__: GetServiceProvidersResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        service_provider_summary_collections=pulumi.get(__response__, 'service_provider_summary_collections'),
        service_provider_type=pulumi.get(__response__, 'service_provider_type'),
        state=pulumi.get(__response__, 'state'),
        supported_resource_type=pulumi.get(__response__, 'supported_resource_type')))
