# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServicesResult',
    'AwaitableGetServicesResult',
    'get_services',
    'get_services_output',
]

@pulumi.output_type
class GetServicesResult:
    """
    A collection of values returned by getServices.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, services=None, subscription_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServicesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetServicesServiceResult']:
        """
        The list of services.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[str]:
        return pulumi.get(self, "subscription_id")


class AwaitableGetServicesResult(GetServicesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            services=self.services,
            subscription_id=self.subscription_id)


def get_services(compartment_id: Optional[str] = None,
                 filters: Optional[Sequence[Union['GetServicesFilterArgs', 'GetServicesFilterArgsDict']]] = None,
                 subscription_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicesResult:
    """
    This data source provides the list of Services in Oracle Cloud Infrastructure Limits service.

    Returns the list of supported services. If subscription ID is provided then only services supported by subscription will be returned.
    This includes the programmatic service name, along with the friendly service name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_services = oci.Limits.get_services(compartment_id=tenancy_ocid,
        subscription_id=subscription_ocid)
    ```


    :param str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
    :param str subscription_id: The OCID of the subscription assigned to tenant
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Limits/getServices:getServices', __args__, opts=opts, typ=GetServicesResult).value

    return AwaitableGetServicesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        services=pulumi.get(__ret__, 'services'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'))
def get_services_output(compartment_id: Optional[pulumi.Input[str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetServicesFilterArgs', 'GetServicesFilterArgsDict']]]]] = None,
                        subscription_id: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServicesResult]:
    """
    This data source provides the list of Services in Oracle Cloud Infrastructure Limits service.

    Returns the list of supported services. If subscription ID is provided then only services supported by subscription will be returned.
    This includes the programmatic service name, along with the friendly service name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_services = oci.Limits.get_services(compartment_id=tenancy_ocid,
        subscription_id=subscription_ocid)
    ```


    :param str compartment_id: The OCID of the parent compartment (remember that the tenancy is simply the root compartment).
    :param str subscription_id: The OCID of the subscription assigned to tenant
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Limits/getServices:getServices', __args__, opts=opts, typ=GetServicesResult)
    return __ret__.apply(lambda __response__: GetServicesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        services=pulumi.get(__response__, 'services'),
        subscription_id=pulumi.get(__response__, 'subscription_id')))
