# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBucketSummariesResult',
    'AwaitableGetBucketSummariesResult',
    'get_bucket_summaries',
    'get_bucket_summaries_output',
]

@pulumi.output_type
class GetBucketSummariesResult:
    """
    A collection of values returned by getBucketSummaries.
    """
    def __init__(__self__, bucket_summaries=None, compartment_id=None, filters=None, id=None, namespace=None):
        if bucket_summaries and not isinstance(bucket_summaries, list):
            raise TypeError("Expected argument 'bucket_summaries' to be a list")
        pulumi.set(__self__, "bucket_summaries", bucket_summaries)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="bucketSummaries")
    def bucket_summaries(self) -> Sequence['outputs.GetBucketSummariesBucketSummaryResult']:
        """
        The list of bucket_summaries.
        """
        return pulumi.get(self, "bucket_summaries")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment ID in which the bucket is authorized.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBucketSummariesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace in which the bucket resides.
        """
        return pulumi.get(self, "namespace")


class AwaitableGetBucketSummariesResult(GetBucketSummariesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBucketSummariesResult(
            bucket_summaries=self.bucket_summaries,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            namespace=self.namespace)


def get_bucket_summaries(compartment_id: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetBucketSummariesFilterArgs', 'GetBucketSummariesFilterArgsDict']]] = None,
                         namespace: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBucketSummariesResult:
    """
    This data source provides the list of Buckets in Oracle Cloud Infrastructure Object Storage service.

    Gets a list of all BucketSummary items in a compartment. A BucketSummary contains only summary fields for the bucket
    and does not contain fields like the user-defined metadata.

    ListBuckets returns a BucketSummary containing at most 1000 buckets. To paginate through more buckets, use the returned
    `opc-next-page` value with the `page` request parameter.

    To use this and other API operations, you must be authorized in an IAM policy. If you are not authorized,
    talk to an administrator. If you are an administrator who needs to write policies to give users access, see
    [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_buckets = oci.ObjectStorage.get_bucket_summaries(compartment_id=compartment_id,
        namespace=bucket_namespace)
    ```


    :param str compartment_id: The ID of the compartment in which to list buckets.
    :param str namespace: The Object Storage namespace used for the request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ObjectStorage/getBucketSummaries:getBucketSummaries', __args__, opts=opts, typ=GetBucketSummariesResult).value

    return AwaitableGetBucketSummariesResult(
        bucket_summaries=pulumi.get(__ret__, 'bucket_summaries'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'))
def get_bucket_summaries_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBucketSummariesFilterArgs', 'GetBucketSummariesFilterArgsDict']]]]] = None,
                                namespace: Optional[pulumi.Input[str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBucketSummariesResult]:
    """
    This data source provides the list of Buckets in Oracle Cloud Infrastructure Object Storage service.

    Gets a list of all BucketSummary items in a compartment. A BucketSummary contains only summary fields for the bucket
    and does not contain fields like the user-defined metadata.

    ListBuckets returns a BucketSummary containing at most 1000 buckets. To paginate through more buckets, use the returned
    `opc-next-page` value with the `page` request parameter.

    To use this and other API operations, you must be authorized in an IAM policy. If you are not authorized,
    talk to an administrator. If you are an administrator who needs to write policies to give users access, see
    [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_buckets = oci.ObjectStorage.get_bucket_summaries(compartment_id=compartment_id,
        namespace=bucket_namespace)
    ```


    :param str compartment_id: The ID of the compartment in which to list buckets.
    :param str namespace: The Object Storage namespace used for the request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ObjectStorage/getBucketSummaries:getBucketSummaries', __args__, opts=opts, typ=GetBucketSummariesResult)
    return __ret__.apply(lambda __response__: GetBucketSummariesResult(
        bucket_summaries=pulumi.get(__response__, 'bucket_summaries'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace')))
