# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSoftwareSourceResult',
    'AwaitableGetSoftwareSourceResult',
    'get_software_source',
    'get_software_source_output',
]

@pulumi.output_type
class GetSoftwareSourceResult:
    """
    A collection of values returned by getSoftwareSource.
    """
    def __init__(__self__, arch_type=None, associated_managed_instances=None, checksum_type=None, compartment_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, gpg_key_fingerprint=None, gpg_key_id=None, gpg_key_url=None, id=None, maintainer_email=None, maintainer_name=None, maintainer_phone=None, packages=None, parent_id=None, parent_name=None, repo_type=None, software_source_id=None, state=None, status=None, url=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if associated_managed_instances and not isinstance(associated_managed_instances, list):
            raise TypeError("Expected argument 'associated_managed_instances' to be a list")
        pulumi.set(__self__, "associated_managed_instances", associated_managed_instances)
        if checksum_type and not isinstance(checksum_type, str):
            raise TypeError("Expected argument 'checksum_type' to be a str")
        pulumi.set(__self__, "checksum_type", checksum_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if gpg_key_fingerprint and not isinstance(gpg_key_fingerprint, str):
            raise TypeError("Expected argument 'gpg_key_fingerprint' to be a str")
        pulumi.set(__self__, "gpg_key_fingerprint", gpg_key_fingerprint)
        if gpg_key_id and not isinstance(gpg_key_id, str):
            raise TypeError("Expected argument 'gpg_key_id' to be a str")
        pulumi.set(__self__, "gpg_key_id", gpg_key_id)
        if gpg_key_url and not isinstance(gpg_key_url, str):
            raise TypeError("Expected argument 'gpg_key_url' to be a str")
        pulumi.set(__self__, "gpg_key_url", gpg_key_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if maintainer_email and not isinstance(maintainer_email, str):
            raise TypeError("Expected argument 'maintainer_email' to be a str")
        pulumi.set(__self__, "maintainer_email", maintainer_email)
        if maintainer_name and not isinstance(maintainer_name, str):
            raise TypeError("Expected argument 'maintainer_name' to be a str")
        pulumi.set(__self__, "maintainer_name", maintainer_name)
        if maintainer_phone and not isinstance(maintainer_phone, str):
            raise TypeError("Expected argument 'maintainer_phone' to be a str")
        pulumi.set(__self__, "maintainer_phone", maintainer_phone)
        if packages and not isinstance(packages, int):
            raise TypeError("Expected argument 'packages' to be a int")
        pulumi.set(__self__, "packages", packages)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if parent_name and not isinstance(parent_name, str):
            raise TypeError("Expected argument 'parent_name' to be a str")
        pulumi.set(__self__, "parent_name", parent_name)
        if repo_type and not isinstance(repo_type, str):
            raise TypeError("Expected argument 'repo_type' to be a str")
        pulumi.set(__self__, "repo_type", repo_type)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> str:
        """
        The architecture type supported by the Software Source
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="associatedManagedInstances")
    def associated_managed_instances(self) -> Sequence['outputs.GetSoftwareSourceAssociatedManagedInstanceResult']:
        """
        list of the Managed Instances associated with this Software Sources
        """
        return pulumi.get(self, "associated_managed_instances")

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> str:
        """
        The yum repository checksum type used by this software source
        """
        return pulumi.get(self, "checksum_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID for the Compartment
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Information specified by the user about the software source
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        User friendly name for the software source
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="gpgKeyFingerprint")
    def gpg_key_fingerprint(self) -> str:
        """
        Fingerprint of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_fingerprint")

    @property
    @pulumi.getter(name="gpgKeyId")
    def gpg_key_id(self) -> str:
        """
        ID of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_id")

    @property
    @pulumi.getter(name="gpgKeyUrl")
    def gpg_key_url(self) -> str:
        """
        URL of the GPG key for this software source
        """
        return pulumi.get(self, "gpg_key_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID for the Software Source
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maintainerEmail")
    def maintainer_email(self) -> str:
        """
        Email address of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_email")

    @property
    @pulumi.getter(name="maintainerName")
    def maintainer_name(self) -> str:
        """
        Name of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_name")

    @property
    @pulumi.getter(name="maintainerPhone")
    def maintainer_phone(self) -> str:
        """
        Phone number of the person maintaining this software source
        """
        return pulumi.get(self, "maintainer_phone")

    @property
    @pulumi.getter
    def packages(self) -> int:
        """
        Number of packages
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> str:
        """
        OCID for the parent software source, if there is one
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> str:
        """
        Display name the parent software source, if there is one
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        Type of the Software Source
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> str:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Software Source.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        status of the software source.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL for the repostiory
        """
        return pulumi.get(self, "url")


class AwaitableGetSoftwareSourceResult(GetSoftwareSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceResult(
            arch_type=self.arch_type,
            associated_managed_instances=self.associated_managed_instances,
            checksum_type=self.checksum_type,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            gpg_key_fingerprint=self.gpg_key_fingerprint,
            gpg_key_id=self.gpg_key_id,
            gpg_key_url=self.gpg_key_url,
            id=self.id,
            maintainer_email=self.maintainer_email,
            maintainer_name=self.maintainer_name,
            maintainer_phone=self.maintainer_phone,
            packages=self.packages,
            parent_id=self.parent_id,
            parent_name=self.parent_name,
            repo_type=self.repo_type,
            software_source_id=self.software_source_id,
            state=self.state,
            status=self.status,
            url=self.url)


def get_software_source(software_source_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceResult:
    """
    This data source provides details about a specific Software Source resource in Oracle Cloud Infrastructure OS Management service.

    Returns a specific Software Source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source = oci.OsManagement.get_software_source(software_source_id=test_software_source_oci_osmanagement_software_source["id"])
    ```


    :param str software_source_id: The OCID of the software source.
    """
    __args__ = dict()
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagement/getSoftwareSource:getSoftwareSource', __args__, opts=opts, typ=GetSoftwareSourceResult).value

    return AwaitableGetSoftwareSourceResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        associated_managed_instances=pulumi.get(__ret__, 'associated_managed_instances'),
        checksum_type=pulumi.get(__ret__, 'checksum_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        gpg_key_fingerprint=pulumi.get(__ret__, 'gpg_key_fingerprint'),
        gpg_key_id=pulumi.get(__ret__, 'gpg_key_id'),
        gpg_key_url=pulumi.get(__ret__, 'gpg_key_url'),
        id=pulumi.get(__ret__, 'id'),
        maintainer_email=pulumi.get(__ret__, 'maintainer_email'),
        maintainer_name=pulumi.get(__ret__, 'maintainer_name'),
        maintainer_phone=pulumi.get(__ret__, 'maintainer_phone'),
        packages=pulumi.get(__ret__, 'packages'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        parent_name=pulumi.get(__ret__, 'parent_name'),
        repo_type=pulumi.get(__ret__, 'repo_type'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        url=pulumi.get(__ret__, 'url'))
def get_software_source_output(software_source_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSoftwareSourceResult]:
    """
    This data source provides details about a specific Software Source resource in Oracle Cloud Infrastructure OS Management service.

    Returns a specific Software Source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source = oci.OsManagement.get_software_source(software_source_id=test_software_source_oci_osmanagement_software_source["id"])
    ```


    :param str software_source_id: The OCID of the software source.
    """
    __args__ = dict()
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:OsManagement/getSoftwareSource:getSoftwareSource', __args__, opts=opts, typ=GetSoftwareSourceResult)
    return __ret__.apply(lambda __response__: GetSoftwareSourceResult(
        arch_type=pulumi.get(__response__, 'arch_type'),
        associated_managed_instances=pulumi.get(__response__, 'associated_managed_instances'),
        checksum_type=pulumi.get(__response__, 'checksum_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        gpg_key_fingerprint=pulumi.get(__response__, 'gpg_key_fingerprint'),
        gpg_key_id=pulumi.get(__response__, 'gpg_key_id'),
        gpg_key_url=pulumi.get(__response__, 'gpg_key_url'),
        id=pulumi.get(__response__, 'id'),
        maintainer_email=pulumi.get(__response__, 'maintainer_email'),
        maintainer_name=pulumi.get(__response__, 'maintainer_name'),
        maintainer_phone=pulumi.get(__response__, 'maintainer_phone'),
        packages=pulumi.get(__response__, 'packages'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        parent_name=pulumi.get(__response__, 'parent_name'),
        repo_type=pulumi.get(__response__, 'repo_type'),
        software_source_id=pulumi.get(__response__, 'software_source_id'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        url=pulumi.get(__response__, 'url')))
